/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.filters.dialogs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.actions.SystemCommonDeleteAction;
import org.eclipse.rse.internal.ui.actions.SystemCommonRenameAction;
import org.eclipse.rse.internal.ui.actions.SystemFilterCopyFilterPoolAction;
import org.eclipse.rse.internal.ui.actions.SystemFilterMoveFilterPoolAction;
import org.eclipse.rse.internal.ui.actions.SystemFilterNewFilterPoolAction;
import org.eclipse.rse.internal.ui.actions.SystemFilterWorkWithFilterPoolsRefreshAllAction;
import org.eclipse.rse.internal.ui.filters.SystemFilterPoolManagerUIProvider;
import org.eclipse.rse.internal.ui.filters.SystemFilterWorkWithFilterPoolsTreeViewer;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.ISystemDeleteTarget;
import org.eclipse.rse.ui.ISystemRenameTarget;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.actions.ISystemAction;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentElement;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentProvider;
import org.eclipse.rse.ui.filters.SystemFilterPoolDialogInterface;
import org.eclipse.rse.ui.filters.SystemFilterPoolDialogOutputs;
import org.eclipse.rse.ui.filters.SystemFilterUIHelpers;
import org.eclipse.rse.ui.filters.actions.SystemFilterAbstractFilterPoolAction;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.validators.ValidatorFilterPoolName;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;

public class SystemFilterWorkWithFilterPoolsDialog
extends SystemPromptDialog
implements ISelectionChangedListener,
ISystemDeleteTarget,
ISystemRenameTarget,
SystemFilterPoolDialogInterface {
    private String promptString;
    private SystemFilterWorkWithFilterPoolsTreeViewer tree;
    private ToolBar toolbar = null;
    private ToolBarManager toolbarMgr = null;
    private SystemSimpleContentProvider provider = new SystemSimpleContentProvider();
    private SystemSimpleContentElement filterPoolContent;
    private SystemSimpleContentElement preSelectedRoot = null;
    private ISystemFilterPoolManager[] filterPoolManagers;
    private SystemFilterPoolManagerUIProvider caller = null;
    private boolean initializing = false;
    private SystemFilterWorkWithFilterPoolsRefreshAllAction refreshAction = null;
    private SystemFilterNewFilterPoolAction newAction = null;
    private DeleteFilterPoolAction dltAction = null;
    private SystemCommonRenameAction rnmAction = null;
    private SystemFilterCopyFilterPoolAction cpyAction = null;
    private SystemFilterMoveFilterPoolAction movAction = null;
    private IAction[] contextMenuActions = null;

    public SystemFilterWorkWithFilterPoolsDialog(Shell shell, String title, String prompt, SystemFilterPoolManagerUIProvider caller) {
        super(shell, title);
        this.caller = caller;
        this.promptString = prompt;
        this.filterPoolContent = caller.getTreeModel();
        this.filterPoolManagers = caller.getFilterPoolManagers();
        this.preSelectedRoot = caller.getTreeModelPreSelection(this.filterPoolContent);
        this.setCancelButtonLabel(SystemResources.BUTTON_CLOSE);
        this.setShowOkButton(false);
    }

    public void setRootToPreselect(SystemSimpleContentElement preSelectedRoot) {
        this.preSelectedRoot = preSelectedRoot;
    }

    protected ISystemMessageLine createMessageLine(Composite c) {
        super.createMessageLine(c);
        return this.fMessageLine;
    }

    protected Control getInitialFocusControl() {
        return this.tree.getControl();
    }

    public void setFilterPoolNameValidator(ValidatorFilterPoolName pnv) {
    }

    protected Control createInner(Composite parent) {
        Composite composite_prompts = SystemWidgetHelpers.createComposite(parent, 1);
        SystemWidgetHelpers.createLabel(composite_prompts, this.promptString);
        this.createToolBar(composite_prompts);
        this.initializing = true;
        this.tree = new SystemFilterWorkWithFilterPoolsTreeViewer(this.getShell(), this, new Tree(composite_prompts, 2052));
        GridData treeData = new GridData();
        treeData.horizontalAlignment = 4;
        treeData.grabExcessHorizontalSpace = true;
        treeData.widthHint = 300;
        treeData.heightHint = 300;
        treeData.verticalAlignment = 2;
        treeData.grabExcessVerticalSpace = true;
        this.tree.getTree().setLayoutData((Object)treeData);
        this.tree.setContentProvider((IContentProvider)this.provider);
        this.tree.setLabelProvider((IBaseLabelProvider)this.provider);
        if (this.filterPoolContent != null) {
            this.filterPoolContent.setData((Object)this.tree);
            this.tree.setInput(this.filterPoolContent);
        }
        if (this.preSelectedRoot != null) {
            this.tree.setSelection((ISelection)new StructuredSelection((Object)this.preSelectedRoot), true);
        }
        this.tree.expandAll();
        this.tree.setAutoExpandLevel(-1);
        this.tree.addSelectionChangedListener(this);
        this.populateToolBar(this.getShell(), this.tree);
        this.initializing = false;
        return composite_prompts;
    }

    public boolean refreshTree() {
        if (this.initializing) {
            return false;
        }
        this.filterPoolContent = this.caller.getTreeModel();
        this.filterPoolManagers = this.caller.getFilterPoolManagers();
        this.preSelectedRoot = this.caller.getTreeModelPreSelection(this.filterPoolContent);
        this.filterPoolContent.setData((Object)this.tree);
        this.tree.setInput(this.filterPoolContent);
        return true;
    }

    protected void createToolBar(Composite parent) {
        this.toolbar = new ToolBar(parent, 0x800040);
        this.toolbarMgr = new ToolBarManager(this.toolbar);
    }

    protected void populateToolBar(Shell shell, SystemFilterWorkWithFilterPoolsTreeViewer tree) {
        this.newAction = new SystemFilterNewFilterPoolAction(shell, this);
        this.dltAction = new DeleteFilterPoolAction(shell, this);
        this.rnmAction = new SystemCommonRenameAction(shell, this);
        this.rnmAction.allowOnMultipleSelection(false);
        this.rnmAction.setProcessAllSelections(false);
        this.cpyAction = new SystemFilterCopyFilterPoolAction(shell);
        this.cpyAction.setSelectionProvider(this);
        this.movAction = new SystemFilterMoveFilterPoolAction(shell);
        this.movAction.setSelectionProvider(this);
        this.refreshAction = new SystemFilterWorkWithFilterPoolsRefreshAllAction(tree, shell);
        this.contextMenuActions = new IAction[6];
        this.contextMenuActions[0] = this.newAction;
        this.contextMenuActions[1] = this.rnmAction;
        this.contextMenuActions[2] = this.cpyAction;
        this.contextMenuActions[3] = this.movAction;
        this.contextMenuActions[4] = this.dltAction;
        this.contextMenuActions[5] = this.refreshAction;
        int idx = 0;
        while (idx < this.contextMenuActions.length) {
            ((ISystemAction)this.contextMenuActions[idx]).setSelection(tree.getSelection());
            ((ISystemAction)this.contextMenuActions[idx]).setViewer((Viewer)tree);
            ++idx;
        }
        this.toolbarMgr.add((IAction)this.refreshAction);
        this.toolbarMgr.add((IAction)this.newAction);
        this.toolbarMgr.add((IAction)this.dltAction);
        this.toolbarMgr.add((IAction)this.rnmAction);
        this.toolbarMgr.add((IAction)this.cpyAction);
        this.toolbarMgr.add((IAction)this.movAction);
        this.toolbarMgr.update(false);
        tree.setContextMenuActions(this.contextMenuActions);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.rnmAction != null) {
            this.rnmAction.selectionChanged(event);
        }
    }

    public SystemSimpleContentElement getSelectedElement() {
        IStructuredSelection sel = (IStructuredSelection)this.tree.getSelection();
        return (SystemSimpleContentElement)sel.getFirstElement();
    }

    public boolean isSelectionEmpty() {
        IStructuredSelection sel = (IStructuredSelection)this.tree.getSelection();
        return sel.isEmpty();
    }

    public void clearSelection() {
        this.tree.setSelection(null);
    }

    protected boolean processOK() {
        boolean closeDialog = this.verify();
        if (closeDialog) {
            this.setOutputObject(this.getInputObject());
        }
        return closeDialog;
    }

    public boolean close() {
        return super.close();
    }

    public boolean verify() {
        this.clearErrorMessage();
        return true;
    }

    public boolean isPageComplete() {
        boolean pageComplete = true;
        return pageComplete;
    }

    public void setPageComplete() {
        this.setPageComplete(this.isPageComplete());
    }

    public boolean showDelete() {
        return true;
    }

    public boolean canDelete() {
        Object elementData;
        SystemSimpleContentElement element = this.getSelectedElement();
        if (element != null && (elementData = element.getData()) instanceof ISystemFilterPool) {
            ISystemFilterPool pool = (ISystemFilterPool)elementData;
            return pool.isDeletable() && element.isDeletable();
        }
        return false;
    }

    public boolean doDelete(IProgressMonitor monitor) {
        boolean ok = false;
        SystemSimpleContentElement element = this.getSelectedElement();
        Object elementData = element.getData();
        if (elementData == null || !(elementData instanceof ISystemFilterPool)) {
            return ok;
        }
        ISystemFilterPool pool = (ISystemFilterPool)elementData;
        ISystemFilterPoolManager mgr = pool.getSystemFilterPoolManager();
        try {
            mgr.deleteSystemFilterPool(pool);
            ok = true;
            SystemSimpleContentElement parent = element.getParent();
            this.clearSelection();
            this.tree.setSelection((ISelection)new StructuredSelection((Object)parent), true);
            parent.deleteChild(element);
            this.tree.refresh(parent);
        }
        catch (Exception exc) {
            SystemMessageDialog msgDlg = new SystemMessageDialog(this.getShell(), RSEUIPlugin.getPluginMessage("RSEG1063").makeSubstitution((Object)pool.getName(), (Object)exc));
            msgDlg.open();
        }
        return ok;
    }

    public boolean showRename() {
        return true;
    }

    public boolean canRename() {
        Object elementData;
        boolean canRename = false;
        SystemSimpleContentElement element = this.getSelectedElement();
        if (element != null && (elementData = element.getData()) instanceof ISystemFilterPool) {
            ISystemFilterPool pool = (ISystemFilterPool)elementData;
            canRename = !pool.isNonRenamable() && element.isRenamable();
        }
        return canRename;
    }

    public boolean doRename(String[] newNames) {
        boolean ok = false;
        SystemSimpleContentElement element = this.getSelectedElement();
        Object elementData = element.getData();
        if (elementData == null || !(elementData instanceof ISystemFilterPool)) {
            return ok;
        }
        ISystemFilterPool pool = (ISystemFilterPool)elementData;
        ISystemFilterPoolManager mgr = pool.getSystemFilterPoolManager();
        try {
            mgr.renameSystemFilterPool(pool, newNames[0]);
            ok = true;
            element.setName(newNames[0]);
            String[] properties = new String[]{"org.eclipse.jface.text"};
            this.tree.update(element, properties);
        }
        catch (SystemMessageException exc) {
            SystemMessageDialog.displayMessage(this.getShell(), exc);
        }
        catch (Exception exc) {
            SystemMessageDialog msgDlg = new SystemMessageDialog(this.getShell(), RSEUIPlugin.getPluginMessage("RSEG1064").makeSubstitution((Object)pool.getName(), (Object)exc));
            msgDlg.open();
        }
        return ok;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.tree.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.tree.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.tree.setSelection(selection);
    }

    public ISelection getSelection() {
        return this.tree.getSelection();
    }

    public void addNewFilterPool(Shell shell, ISystemFilterPool pool) {
        String newPoolMgrName = pool.getSystemFilterPoolManager().getName();
        SystemSimpleContentElement rootElement = this.filterPoolContent;
        SystemSimpleContentElement[] mgrElements = rootElement.getChildren();
        SystemSimpleContentElement mgrElement = null;
        int idx = 0;
        while (mgrElement == null && idx < mgrElements.length) {
            String mgrName = mgrElements[idx].getName();
            if (mgrName.equals(newPoolMgrName)) {
                mgrElement = mgrElements[idx];
            }
            ++idx;
        }
        SystemSimpleContentElement cElement = new SystemSimpleContentElement(pool.getName(), (Object)pool, mgrElement, null);
        cElement.setImageDescriptor(SystemFilterUIHelpers.getFilterPoolImage(pool.getProvider(), pool));
        if (mgrElement != null) {
            mgrElement.addChild(cElement, 0);
        }
        this.tree.refresh(mgrElement);
        this.tree.setSelection((ISelection)new StructuredSelection((Object)cElement), true);
        Object inputObj = this.getInputObject();
        if (inputObj instanceof ISubSystem) {
            SystemMessageDialog msgdlg;
            boolean yes;
            ISubSystem ss = (ISubSystem)inputObj;
            SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1160");
            msg.makeSubstitution((Object)("'" + pool.getName() + "'"), (Object)("'" + ss.getName() + "'"));
            if (shell.isDisposed() || !shell.isVisible()) {
                shell = this.getShell();
            }
            if (yes = (msgdlg = new SystemMessageDialog(shell, msg)).openQuestionNoException()) {
                ISystemFilterPoolReferenceManager sfprm = ss.getSystemFilterPoolReferenceManager();
                sfprm.addReferenceToSystemFilterPool(pool);
            }
        }
    }

    public ISystemFilterPoolManager[] getFilterPoolManagers() {
        ISystemFilterPoolManager[] mgrs = this.filterPoolManagers;
        return mgrs;
    }

    public int getFilterPoolManagerSelection() {
        Object elementData;
        int selection = 0;
        SystemSimpleContentElement element = this.getSelectedElement();
        if (element != null && (elementData = element.getData()) != null) {
            if (elementData instanceof ISystemFilterPoolManager) {
                selection = this.getManagerIndex((ISystemFilterPoolManager)elementData);
            } else if (elementData instanceof ISystemFilterPool) {
                selection = this.getManagerIndex(((ISystemFilterPool)elementData).getSystemFilterPoolManager());
            }
        }
        return selection;
    }

    private int getManagerIndex(ISystemFilterPoolManager mgr) {
        int pos = -1;
        ISystemFilterPoolManager[] mgrs = this.filterPoolManagers;
        int idx = 0;
        while (pos == -1 && idx < mgrs.length) {
            if (mgr == mgrs[idx]) {
                pos = idx;
            }
            ++idx;
        }
        if (pos == -1) {
            pos = 0;
        }
        return pos;
    }

    public void setFilterPoolDialogActionCaller(SystemFilterAbstractFilterPoolAction caller) {
    }

    public SystemFilterPoolDialogOutputs getFilterPoolDialogOutputs() {
        SystemFilterPoolDialogOutputs output = new SystemFilterPoolDialogOutputs();
        output.filterPoolTreeRoot = this.filterPoolContent;
        return output;
    }

    public void setHelpContextId(String id) {
        super.setHelp(id);
    }

    class DeleteFilterPoolAction
    extends SystemCommonDeleteAction {
        public DeleteFilterPoolAction(Shell parent, ISystemDeleteTarget deleteTarget) {
            super(parent, deleteTarget);
        }

        protected Object getDialogValue(Dialog dlg) {
            SystemFilterWorkWithFilterPoolsDialog.this.doDelete(null);
            return null;
        }
    }
}

