/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model.state;

import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.mi.vo.LaneInfo;
import com.nvidia.cuda.ide.debug.mi.vo.UncoalescedThreadInfo;
import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaDim;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.CudaRuntimeInformation;
import com.nvidia.cuda.ide.debug.model.CudaThreadState;
import com.nvidia.cuda.ide.debug.model.ICoordSorter;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.IFocusDMContext;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.Lane;
import com.nvidia.cuda.ide.debug.model.Warp;
import com.nvidia.cuda.ide.debug.model.query.IElementQuery;
import com.nvidia.cuda.ide.debug.model.state.AbstractCudaStateManager;
import com.nvidia.cuda.ide.debug.model.state.ICudaQueries;
import com.nvidia.cuda.ide.debug.model.state.SourceLocation;
import com.nvidia.cuda.ide.debug.model.state.WarpsStateManager;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class ThreadsStateManager
extends AbstractCudaStateManager {
    private static final int LANES_IN_WARP = 32;
    private static final byte LAST_LANE = (byte)31;
    private final WarpsStateManager warpsStateManager;
    private final ICudaApplication application;
    private final ICudaQueries queries;
    private final Map<Long, Map<Long, Short>> activeThreads = new HashMap<Long, Map<Long, Short>>();
    private final ConcurrentMap<Long, SourceLocation> devicePcs = new ConcurrentHashMap<Long, SourceLocation>();
    private final Map<Integer, long[]> lanePCs = new HashMap<Integer, long[]>();
    private final ConcurrentMap<Long, Queue<DataRequestMonitor<SourceLocation>>> waitingRMs = new ConcurrentHashMap<Long, Queue<DataRequestMonitor<SourceLocation>>>();
    private final Map<Warp, Long> warpThreads = new HashMap<Warp, Long>();

    public ThreadsStateManager(ICudaApplication application, ICudaQueries queries) {
        this.application = application;
        this.queries = queries;
        this.warpsStateManager = new WarpsStateManager(application, queries);
    }

    public void isDivergentThread(IDMContext dmc, short deviceId, short sm, short warpId, short lane, DataRequestMonitor<CudaRuntimeInformation> rm) {
        CudaThreadState state = this.warpsStateManager.getLaneState(deviceId, sm, warpId, lane);
        SourceLocationRequestMonitor slrm = new SourceLocationRequestMonitor((Executor)this.queries.getExecutor(), deviceId, sm, warpId, lane, state, rm);
        if (CudaThreadState.DIVERGENT == state) {
            this.getDivergentSourceLocation(dmc, slrm, deviceId, sm, warpId, lane);
        } else {
            this.getWarpSourceLocation(dmc, slrm, deviceId, sm, warpId, lane);
        }
    }

    private void getWarpSourceLocation(IDMContext dmc, DataRequestMonitor<SourceLocation> rm, short device, short sm, short warp, short lane) {
        long devicePC = this.warpsStateManager.getWarpPC(device, sm, warp);
        if (this.devicePcs.containsKey(devicePC)) {
            SourceLocation location = (SourceLocation)this.devicePcs.get(devicePC);
            rm.setData((Object)location);
            rm.done();
        } else {
            this.fillPC(dmc, devicePC, device, sm, warp, lane, rm);
        }
    }

    private boolean activeThreadsUptoDate(Block cudaThread) {
        return this.activeThreads.containsKey(this.buildBlockIntId(cudaThread.getKernel(), cudaThread.getBlockIdx()));
    }

    private void buildBlockState(final IFocusDMContext cudaThread, final DataRequestMonitor<CudaRuntimeInformation> rm) {
        Block block = cudaThread.getBlock();
        block.getState(new DataRequestMonitor<CudaRuntimeInformation>((Executor)this.queries.getExecutor(), rm){

            protected void handleFailure() {
                rm.setData((Object)CudaRuntimeInformation.INACTIVE);
                rm.done();
            }

            protected void handleSuccess() {
                ThreadsStateManager.this.threadLevelStateQuery(cudaThread, (CudaRuntimeInformation)this.getData(), (DataRequestMonitor<CudaRuntimeInformation>)rm);
            }
        });
    }

    private void fillThreadState(IFocusDMContext cudaThread, DataRequestMonitor<CudaRuntimeInformation> rm) {
        Short warp;
        Long blockId = this.buildBlockIntId(cudaThread.getKernel(), cudaThread.getBlockIdx());
        Map<Long, Short> kernelThreads = this.activeThreads.get(blockId);
        Short s = warp = kernelThreads != null ? kernelThreads.get(this.getThreadWarpId(cudaThread)) : null;
        if (warp != null) {
            this.getDivergedState(cudaThread, cudaThread.getKernel().getDeviceId(), this.application.getSM(cudaThread.getBlock()), warp, this.getLane(cudaThread), rm);
            return;
        }
        rm.setData((Object)CudaRuntimeInformation.INACTIVE);
        rm.done();
    }

    public void getThreadState(IFocusDMContext cudaThread, DataRequestMonitor<CudaRuntimeInformation> rm) {
        if (this.activeThreadsUptoDate(cudaThread.getBlock())) {
            this.fillThreadState(cudaThread, rm);
        } else {
            this.buildBlockState(cudaThread, rm);
        }
    }

    private short getLane(IFocusDMContext cudaThread) {
        return (short)(cudaThread.getKernel().getBlockDim().getOrdinal(cudaThread.getThreadIdx()) & 0x1FL);
    }

    private Long getThreadWarpId(IFocusDMContext cudaThread) {
        return cudaThread.getKernel().getBlockDim().getOrdinal(cudaThread.getThreadIdx()) >> 5;
    }

    public void invalidate() {
        this.activeThreads.clear();
        this.warpsStateManager.invalidate();
        this.lanePCs.clear();
        this.warpThreads.clear();
    }

    private void getDivergedState(final IDMContext context, final short deviceId, final short sm, final short warp, final short lane, DataRequestMonitor<CudaRuntimeInformation> rm) {
        this.warpsStateManager.ensureWarpsUpToDate(context, deviceId, sm, warp, new RequestMonitor((Executor)this.queries.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm){
            private final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                ThreadsStateManager.this.isDivergentThread(context, deviceId, sm, warp, lane, (DataRequestMonitor<CudaRuntimeInformation>)this.val$rm);
            }
        });
    }

    protected void updateActiveThreads(UncoalescedThreadInfo[] threads) {
        if (threads != null) {
            UncoalescedThreadInfo[] uncoalescedThreadInfoArray = threads;
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                UncoalescedThreadInfo entry = uncoalescedThreadInfoArray[n2];
                Kernel kernel = this.application.getKernel(entry.getKernelId());
                Long uniqueBlockId = this.buildBlockIntId(kernel, entry.getBlockIdx());
                Map<Long, Short> set = this.activeThreads.get(uniqueBlockId);
                if (set == null) {
                    set = new TreeMap<Long, Short>();
                    this.activeThreads.put(uniqueBlockId, set);
                }
                CudaDim blockDim = kernel.getBlockDim();
                set.put(blockDim.getOrdinal(entry.getThreadIdx()) >> 5, entry.getWarp());
                ++n2;
            }
        }
    }

    private Long buildBlockIntId(Kernel kernel, CudaCoord blockIdx) {
        long ordinal = kernel.getGridDim().getOrdinal(blockIdx);
        return ordinal | kernel.getId() << 48;
    }

    private void getDivergentSourceLocation(IDMContext dmc, SourceLocationRequestMonitor slrm, short deviceId, short sm, short warpId, short lane) {
        int warpKey = Warp.getWarpKey(deviceId, sm, warpId);
        if (this.lanePCs.containsKey(warpKey)) {
            this.fillPC(dmc, this.lanePCs.get(warpKey)[lane], deviceId, sm, warpId, lane, slrm);
        } else {
            this.queries.queryLanes(dmc, deviceId, sm, warpId, new LanesStateParser((Executor)this.queries.getExecutor(), (RequestMonitor)slrm, slrm, sm, lane, warpId, deviceId, dmc));
        }
    }

    private void fillPC(IDMContext dmc, final long devicePC, short device, short sm, short warp, short lane, DataRequestMonitor<SourceLocation> rm) {
        ConcurrentLinkedQueue<DataRequestMonitor<SourceLocation>> queue = new ConcurrentLinkedQueue<DataRequestMonitor<SourceLocation>>(Collections.singleton(rm));
        Queue another = this.waitingRMs.putIfAbsent(devicePC, queue);
        if (another == null) {
            this.queries.queryThreads(dmc, device, sm, warp, lane, new DataRequestMonitor<UncoalescedThreadInfo[]>((Executor)this.queries.getExecutor(), rm){

                protected void handleFailure() {
                    Queue queue = (Queue)ThreadsStateManager.this.waitingRMs.remove(devicePC);
                    for (DataRequestMonitor requestMonitor : queue) {
                        if (this.isCanceled()) {
                            requestMonitor.cancel();
                        } else {
                            requestMonitor.setStatus(this.getStatus());
                        }
                        requestMonitor.done();
                    }
                }

                protected void handleSuccess() {
                    SourceLocation sourceLocation = ThreadsStateManager.this.createSourceLocation((UncoalescedThreadInfo[])this.getData(), devicePC);
                    Queue queue = (Queue)ThreadsStateManager.this.waitingRMs.remove(devicePC);
                    for (DataRequestMonitor requestMonitor : queue) {
                        requestMonitor.setData((Object)sourceLocation);
                        requestMonitor.done();
                    }
                }
            });
        } else {
            another.add(rm);
            if (!this.waitingRMs.containsKey(devicePC)) {
                rm.setData((Object)((SourceLocation)this.devicePcs.get(devicePC)));
                rm.done();
            }
        }
    }

    protected SourceLocation createSourceLocation(UncoalescedThreadInfo[] threadInfos, long devicePc) {
        SourceLocation location;
        if (threadInfos.length != 1) {
            Activator.log("Query returned several threads", new IllegalStateException());
            location = null;
        } else {
            UncoalescedThreadInfo info = threadInfos[0];
            location = new SourceLocation(info.getSourceFile(), info.getLineNo(), info.getVirtualPC(), devicePc);
            this.devicePcs.putIfAbsent(devicePc, location);
        }
        return location;
    }

    private void threadLevelStateQuery(final IFocusDMContext cudaThread, CudaRuntimeInformation blockState, DataRequestMonitor<CudaRuntimeInformation> rm) {
        if (blockState.getState().isActive()) {
            this.ensureUpToDate(cudaThread.getBlock(), new RequestMonitor((Executor)this.queries.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm){
                private final /* synthetic */ DataRequestMonitor val$rm;
                {
                    this.val$rm = dataRequestMonitor;
                    super($anonymous0, $anonymous1);
                }

                protected void handleSuccess() {
                    ThreadsStateManager.this.fillThreadState(cudaThread, (DataRequestMonitor<CudaRuntimeInformation>)this.val$rm);
                }
            });
        } else {
            this.activeThreads.put(this.buildBlockIntId(cudaThread.getKernel(), cudaThread.getBlockIdx()), Collections.emptyMap());
            rm.setData((Object)CudaRuntimeInformation.INACTIVE);
            rm.done();
        }
    }

    private void ensureUpToDate(final Block context, final RequestMonitor rm) {
        if (this.activeThreadsUptoDate(context)) {
            rm.done();
        } else {
            this.queries.queryThreads(context, context.getKernel().getId(), context.getBlockIdx(), new DataRequestMonitor<UncoalescedThreadInfo[]>((Executor)this.queries.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!ThreadsStateManager.this.activeThreadsUptoDate(context)) {
                        ThreadsStateManager.this.updateActiveThreads((UncoalescedThreadInfo[])this.getData());
                    }
                    rm.done();
                }
            });
        }
    }

    public void getLaneState(final Lane lane, final DataRequestMonitor<CudaRuntimeInformation> rm) {
        final Warp warp = (Warp)DMContexts.getAncestorOfType((IDMContext)lane, Warp.class);
        warp.getState(new DataRequestMonitor<CudaRuntimeInformation>((Executor)this.queries.getExecutor(), rm){

            protected void handleSuccess() {
                ThreadsStateManager.this.fillLaneProperties(warp, lane, (CudaRuntimeInformation)this.getData(), (DataRequestMonitor<CudaRuntimeInformation>)rm);
            }
        });
    }

    protected void fillLaneProperties(Warp warp, Lane lane, CudaRuntimeInformation info, DataRequestMonitor<CudaRuntimeInformation> rm) {
        if (!info.getState().isActive()) {
            rm.setData((Object)CudaRuntimeInformation.INACTIVE);
            rm.done();
        } else {
            CudaThreadState laneState = this.warpsStateManager.getLaneState(warp, lane.getId());
            switch (laneState) {
                case RUNNING: {
                    this.fillLaneInformation(warp, lane, info, rm);
                    break;
                }
                case DIVERGENT: {
                    info.setState(CudaThreadState.DIVERGENT);
                    this.fillDivergentLaneInformation(warp, lane, info, rm);
                    break;
                }
                default: {
                    rm.setData((Object)CudaRuntimeInformation.INACTIVE);
                    rm.done();
                }
            }
        }
    }

    private void fillLaneInformation(Warp warp, Lane lane, CudaRuntimeInformation info, DataRequestMonitor<CudaRuntimeInformation> rm) {
        if (this.warpThreads.containsKey(warp)) {
            long threadOrdinal = (this.warpThreads.get(warp) << 5) + (long)lane.getId();
            ICudaApplication app = (ICudaApplication)DMContexts.getAncestorOfType((IDMContext)lane, ICudaApplication.class);
            Kernel kernel = app.getKernel(info.getKernelId());
            CudaCoord threadIdx = kernel.getBlockDim().getCoord(threadOrdinal);
            info.setThreadIdx(threadIdx);
            rm.setData((Object)info);
            rm.done();
        } else {
            this.fillDivergentLaneInformation(warp, lane, info, rm);
        }
    }

    private void fillDivergentLaneInformation(final Warp warp, final Lane lane, final CudaRuntimeInformation info, final DataRequestMonitor<CudaRuntimeInformation> rm) {
        this.queries.queryLanes(lane, warp.getDeviceId(), warp.getSMId(), warp.getId(), new DataRequestMonitor<LaneInfo[]>((Executor)this.queries.getExecutor(), rm){

            protected void handleSuccess() {
                if (!DebugUtil.isNullOrEmpty((Object[])this.getData())) {
                    ThreadsStateManager.this.fillLaneThread(warp, lane, (LaneInfo[])this.getData(), info, (DataRequestMonitor<CudaRuntimeInformation>)rm);
                } else {
                    rm.setData((Object)CudaRuntimeInformation.INACTIVE);
                    rm.done();
                }
            }
        });
    }

    private void fillLaneThread(Warp warp, Lane lane, LaneInfo[] infos, final CudaRuntimeInformation info, final DataRequestMonitor<CudaRuntimeInformation> rm) {
        LaneInfo laneInfo = infos[lane.getId()];
        ICudaApplication app = (ICudaApplication)DMContexts.getAncestorOfType((IDMContext)lane, ICudaApplication.class);
        Kernel kernel = app.getKernel(info.getKernelId());
        CudaCoord threadIdx = laneInfo.getThreadIdx();
        long ordinal = kernel.getBlockDim().getOrdinal(threadIdx);
        this.warpThreads.put(warp, ordinal >> 5);
        info.setThreadIdx(threadIdx);
        this.fillPC(lane, laneInfo.getPC(), warp.getDeviceId(), warp.getSMId(), warp.getId(), lane.getId(), new DataRequestMonitor<SourceLocation>((Executor)this.queries.getExecutor(), rm){

            protected void handleSuccess() {
                info.setSourceLocation((SourceLocation)this.getData());
                rm.setData((Object)info);
                rm.done();
            }
        });
    }

    public void getSourceLocation(IDMContext dmc, short device, short sm, short warp, short lane, DataRequestMonitor<SourceLocation> rm) {
        long devicePC = this.warpsStateManager.getWarpPC(device, sm, warp);
        if (this.devicePcs.containsKey(devicePC)) {
            SourceLocation location = (SourceLocation)this.devicePcs.get(devicePC);
            rm.setData((Object)location);
            rm.done();
        } else {
            this.fillPC(dmc, devicePC, device, sm, warp, lane, rm);
        }
    }

    public void getWarpState(Warp warp, DataRequestMonitor<CudaRuntimeInformation> rm) {
        this.warpsStateManager.getWarpState(warp, rm);
    }

    public void getActiveThreads(final Block block, final boolean fillGaps, final ICoordSorter sorter, DataRequestMonitor<IDMContext[]> rm) {
        this.ensureUpToDate(block, new RequestMonitor((Executor)this.queries.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm){
            private final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                ThreadsStateManager.this.fillActiveThreads(block, fillGaps, sorter, (DataRequestMonitor<IDMContext[]>)this.val$rm);
            }
        });
    }

    protected void fillActiveThreads(Block block, boolean fillGaps, ICoordSorter sorter, DataRequestMonitor<IDMContext[]> rm) {
        Map<Long, Short> threadList = this.activeThreads.get(this.buildBlockIntId(block.getKernel(), block.getBlockIdx()));
        Set<Object> threads = threadList == null ? Collections.emptySet() : threadList.keySet();
        try {
            CudaDim dim = block.getKernel().getBlockDim();
            IDMContext[] ctxs = this.getActiveElements(block, fillGaps, sorter, dim, new ThreadIterator(threads, dim));
            rm.setData((Object)ctxs);
        }
        catch (CudaException e) {
            rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
        }
        rm.done();
    }

    @Override
    protected IDMContext createDMContext(IDMContext block, CudaCoord coord) throws CudaException {
        return ((Block)block).getThread(coord);
    }

    public void buildWarpQuery(Warp warp, IElementQuery query, DataRequestMonitor<IElementQuery> rm) {
        this.warpsStateManager.buildWarpQuery(warp, query, rm);
    }

    private final class LanesStateParser
    extends DataRequestMonitor<LaneInfo[]> {
        private final SourceLocationRequestMonitor slrm;
        private final short sm;
        private final short lane;
        private final short warpId;
        private final short deviceId;
        private final IDMContext dmc;

        private LanesStateParser(Executor executor, RequestMonitor parentRequestMonitor, SourceLocationRequestMonitor slrm, short sm, short lane, short warpId, short deviceId, IDMContext dmc) {
            super(executor, parentRequestMonitor);
            this.slrm = slrm;
            this.sm = sm;
            this.lane = lane;
            this.warpId = warpId;
            this.deviceId = deviceId;
            this.dmc = dmc;
        }

        protected void handleSuccess() {
            if (((LaneInfo[])this.getData()).length > 32) {
                Activator.log("More then 32 lanes", new IllegalStateException());
                this.slrm.done();
            } else {
                long[] pcs = new long[32];
                int i = 0;
                LaneInfo[] laneInfoArray = (LaneInfo[])this.getData();
                int n = laneInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LaneInfo info = laneInfoArray[n2];
                    pcs[i++] = info.getPC();
                    ThreadsStateManager.this.lanePCs.put(Warp.getWarpKey(this.deviceId, this.sm, this.warpId), pcs);
                    ++n2;
                }
                ThreadsStateManager.this.fillPC(this.dmc, pcs[this.lane], this.deviceId, this.sm, this.warpId, this.lane, (DataRequestMonitor<SourceLocation>)this.slrm);
            }
        }
    }

    private static final class SourceLocationRequestMonitor
    extends DataRequestMonitor<SourceLocation> {
        private final DataRequestMonitor<CudaRuntimeInformation> rm;
        private final CudaThreadState state;
        private final short lane;
        private final short warpId;
        private final short sm;
        private final short deviceId;

        public SourceLocationRequestMonitor(Executor executor, short deviceId, short sm, short warpId, short lane, CudaThreadState state, DataRequestMonitor<CudaRuntimeInformation> rm) {
            super(executor, rm);
            this.rm = rm;
            this.state = state;
            this.lane = lane;
            this.warpId = warpId;
            this.sm = sm;
            this.deviceId = deviceId;
        }

        protected void handleSuccess() {
            CudaRuntimeInformation information = new CudaRuntimeInformation(this.deviceId, this.sm, this.warpId, this.lane, this.state, (SourceLocation)this.getData());
            this.rm.setData((Object)information);
            this.rm.done();
        }
    }

    private static final class ThreadIterator
    implements Iterator<Long> {
        private byte ind = ThreadsStateManager.access$0();
        private final Iterator<Long> threads;
        private final int count;
        private long warp;

        public ThreadIterator(Set<Long> threads, CudaDim dim) {
            this.count = dim.elementCount();
            this.threads = threads.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.ind < LAST_LANE && (long)this.ind + this.warp < (long)(this.count - 1)) {
                return true;
            }
            return this.threads.hasNext();
        }

        @Override
        public Long next() {
            if (this.ind == LAST_LANE) {
                this.ind = 0;
                this.warp = this.threads.next() << 5;
            } else {
                this.ind = (byte)(this.ind + 1);
            }
            return (long)this.ind + this.warp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

