/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class DeferredUpdateManager
extends UpdateManager {
    private Rectangle damage;
    private Map dirtyRegions = new HashMap();
    private GraphicsSource graphicsSource;
    private List invalidFigures = new ArrayList();
    private IFigure root;
    private boolean updateQueued;
    private boolean updating;
    private boolean validating;
    private RunnableChain afterUpdate;

    public DeferredUpdateManager() {
    }

    public DeferredUpdateManager(GraphicsSource gs) {
        this.setGraphicsSource(gs);
    }

    public synchronized void addDirtyRegion(IFigure figure, int x, int y, int w, int h) {
        if (w == 0 || h == 0 || !figure.isShowing()) {
            return;
        }
        Rectangle rect = (Rectangle)this.dirtyRegions.get(figure);
        if (rect == null) {
            rect = new Rectangle(x, y, w, h);
            this.dirtyRegions.put(figure, rect);
        } else {
            rect.union(x, y, w, h);
        }
        this.queueWork();
    }

    public synchronized void addInvalidFigure(IFigure f) {
        if (this.invalidFigures.contains(f)) {
            return;
        }
        this.queueWork();
        this.invalidFigures.add(f);
    }

    protected Graphics getGraphics(Rectangle region) {
        if (this.graphicsSource == null) {
            return null;
        }
        return this.graphicsSource.getGraphics(region);
    }

    void paint(GC gc) {
        if (!this.validating) {
            SWTGraphics graphics = new SWTGraphics(gc);
            if (!this.updating) {
                Rectangle rect = graphics.getClip(new Rectangle());
                HashMap<IFigure, Rectangle> map = new HashMap<IFigure, Rectangle>();
                map.put(this.root, rect);
                this.firePainting(rect, map);
            }
            this.performValidation();
            this.root.paint(graphics);
            graphics.dispose();
        } else {
            this.addDirtyRegion(this.root, new Rectangle(gc.getClipping()));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void performUpdate() {
        if (this.isDisposed()) return;
        if (this.updating) {
            return;
        }
        this.updating = true;
        try {
            this.performValidation();
            this.updateQueued = false;
            this.repairDamage();
            if (this.afterUpdate != null) {
                RunnableChain chain = this.afterUpdate;
                this.afterUpdate = null;
                chain.run();
                if (this.afterUpdate != null) {
                    this.queueWork();
                }
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.updating = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.updating = false;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void performValidation() {
        if (this.invalidFigures.isEmpty()) return;
        if (this.validating) {
            return;
        }
        try {
            this.validating = true;
            this.fireValidating();
            int i = 0;
            while (i < this.invalidFigures.size()) {
                IFigure fig = (IFigure)this.invalidFigures.get(i);
                this.invalidFigures.set(i, null);
                fig.validate();
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.invalidFigures.clear();
            this.validating = false;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.invalidFigures.clear();
            this.validating = false;
            return;
        }
    }

    public synchronized void performUpdate(Rectangle exposed) {
        this.addDirtyRegion(this.root, exposed);
        this.performUpdate();
    }

    protected void queueWork() {
        if (!this.updateQueued) {
            this.sendUpdateRequest();
            this.updateQueued = true;
        }
    }

    protected void sendUpdateRequest() {
        Display display = Display.getCurrent();
        if (display == null) {
            throw new SWTException(22);
        }
        display.asyncExec((Runnable)new UpdateRequest());
    }

    protected void releaseGraphics(Graphics graphics) {
        graphics.dispose();
        this.graphicsSource.flushGraphics(this.damage);
    }

    protected void repairDamage() {
        Graphics graphics;
        Iterator keys = this.dirtyRegions.keySet().iterator();
        while (keys.hasNext()) {
            IFigure figure = (IFigure)keys.next();
            IFigure walker = figure.getParent();
            Rectangle contribution = (Rectangle)this.dirtyRegions.get(figure);
            contribution.intersect(figure.getBounds());
            while (!contribution.isEmpty() && walker != null) {
                walker.translateToParent(contribution);
                contribution.intersect(walker.getBounds());
                walker = walker.getParent();
            }
            if (this.damage == null) {
                this.damage = new Rectangle(contribution);
                continue;
            }
            this.damage.union(contribution);
        }
        if (!this.dirtyRegions.isEmpty()) {
            Map oldRegions = this.dirtyRegions;
            this.dirtyRegions = new HashMap();
            this.firePainting(this.damage, oldRegions);
        }
        if (this.damage != null && !this.damage.isEmpty() && (graphics = this.getGraphics(this.damage)) != null) {
            this.root.paint(graphics);
            this.releaseGraphics(graphics);
        }
        this.damage = null;
    }

    public synchronized void runWithUpdate(Runnable runnable) {
        this.afterUpdate = new RunnableChain(runnable, this.afterUpdate);
        if (!this.updating) {
            this.queueWork();
        }
    }

    public void setGraphicsSource(GraphicsSource gs) {
        this.graphicsSource = gs;
    }

    public void setRoot(IFigure figure) {
        this.root = figure;
    }

    protected void validateFigures() {
        this.performValidation();
    }

    private static class RunnableChain {
        RunnableChain next;
        Runnable run;

        RunnableChain(Runnable run, RunnableChain next) {
            this.run = run;
            this.next = next;
        }

        void run() {
            if (this.next != null) {
                this.next.run();
            }
            this.run.run();
        }
    }

    protected class UpdateRequest
    implements Runnable {
        public void run() {
            DeferredUpdateManager.this.performUpdate();
        }
    }
}

