/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.ProjectReference;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectReferenceImporter {
    private final String[] referenceStrings;

    public ProjectReferenceImporter(String[] referenceStrings) {
        this.referenceStrings = referenceStrings;
    }

    public List<IProject> run(IProgressMonitor monitor) throws TeamException {
        Map<URIish, Map<String, Set<ProjectReference>>> repositories = this.parseReferenceStrings();
        ArrayList<IProject> importedProjects = new ArrayList<IProject>();
        for (Map.Entry<URIish, Map<String, Set<ProjectReference>>> entry : repositories.entrySet()) {
            URIish gitUrl = entry.getKey();
            Map<String, Set<ProjectReference>> refs = entry.getValue();
            for (Map.Entry<String, Set<ProjectReference>> refEntry : refs.entrySet()) {
                String refName = refEntry.getKey();
                Set<ProjectReference> projects = refEntry.getValue();
                Set<String> allRefs = refs.keySet();
                File repositoryPath = null;
                if (allRefs.size() == 1) {
                    repositoryPath = ProjectReferenceImporter.findConfiguredRepository(gitUrl);
                }
                if (repositoryPath == null) {
                    try {
                        IPath workDir = ProjectReferenceImporter.getWorkingDir(gitUrl, refName, refs.keySet());
                        repositoryPath = ProjectReferenceImporter.cloneIfNecessary(gitUrl, refName, workDir, projects, monitor);
                    }
                    catch (InterruptedException interruptedException) {
                        return Collections.emptyList();
                    }
                }
                ProjectReferenceImporter.getRepositoryUtil().addConfiguredRepository(repositoryPath);
                IPath newWorkDir = new Path(repositoryPath.getAbsolutePath()).removeLastSegments(1);
                List<IProject> p = this.importProjects(projects, newWorkDir, repositoryPath, monitor);
                importedProjects.addAll(p);
            }
        }
        return importedProjects;
    }

    private static File cloneIfNecessary(URIish gitUrl, String refToCheckout, IPath workDir, Set<ProjectReference> projects, IProgressMonitor monitor) throws TeamException, InterruptedException {
        File repositoryPath = workDir.append(".git").toFile();
        if (workDir.toFile().exists()) {
            if (ProjectReferenceImporter.repositoryAlreadyExistsForUrl(repositoryPath, gitUrl)) {
                return repositoryPath;
            }
            LinkedList<String> projectNames = new LinkedList<String>();
            for (ProjectReference projectReference : projects) {
                projectNames.add(projectReference.getProjectDir());
            }
            throw new TeamException(NLS.bind((String)CoreText.GitProjectSetCapability_CloneToExistingDirectory, (Object[])new Object[]{workDir, projectNames, gitUrl}));
        }
        try {
            int timeout = 60;
            CloneOperation cloneOperation = new CloneOperation(gitUrl, true, null, workDir.toFile(), refToCheckout, "origin", timeout);
            cloneOperation.run(monitor);
            return repositoryPath;
        }
        catch (InvocationTargetException e) {
            throw ProjectReferenceImporter.getTeamException(e);
        }
    }

    private Map<URIish, Map<String, Set<ProjectReference>>> parseReferenceStrings() throws TeamException {
        LinkedHashMap<URIish, Map<String, Set<ProjectReference>>> repositories = new LinkedHashMap<URIish, Map<String, Set<ProjectReference>>>();
        String[] stringArray = this.referenceStrings;
        int n = this.referenceStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String reference = stringArray[n2];
            try {
                LinkedHashSet<ProjectReference> projectReferences;
                ProjectReference projectReference = new ProjectReference(reference);
                HashMap<String, LinkedHashSet<ProjectReference>> repositoryBranches = (HashMap<String, LinkedHashSet<ProjectReference>>)repositories.get(projectReference.getRepository());
                if (repositoryBranches == null) {
                    repositoryBranches = new HashMap<String, LinkedHashSet<ProjectReference>>();
                    repositories.put(projectReference.getRepository(), repositoryBranches);
                }
                if ((projectReferences = (LinkedHashSet<ProjectReference>)repositoryBranches.get(projectReference.getBranch())) == null) {
                    projectReferences = new LinkedHashSet<ProjectReference>();
                    repositoryBranches.put(projectReference.getBranch(), projectReferences);
                }
                projectReferences.add(projectReference);
            }
            catch (IllegalArgumentException e) {
                throw new TeamException(reference, (Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new TeamException(reference, (Throwable)e);
            }
            ++n2;
        }
        return repositories;
    }

    private static IPath getWorkingDir(URIish gitUrl, String branch, Set<String> allBranches) {
        IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getRawLocation();
        String humanishName = gitUrl.getHumanishName();
        String extendedName = allBranches.size() == 1 || branch.equals("master") ? humanishName : String.valueOf(humanishName) + "_" + branch;
        IPath workDir = workspaceLocation.append(extendedName);
        return workDir;
    }

    private static File findConfiguredRepository(URIish gitUrl) {
        for (String repoDir : ProjectReferenceImporter.getRepositoryUtil().getConfiguredRepositories()) {
            File repoDirFile = new File(repoDir);
            if (!ProjectReferenceImporter.repositoryAlreadyExistsForUrl(repoDirFile, gitUrl)) continue;
            return repoDirFile;
        }
        return null;
    }

    private static boolean repositoryAlreadyExistsForUrl(File repositoryPath, URIish gitUrl) {
        if (repositoryPath.exists()) {
            Repository existingRepository;
            try {
                existingRepository = FileRepositoryBuilder.create((File)repositoryPath);
            }
            catch (IOException iOException) {
                return false;
            }
            try {
                boolean exists;
                boolean bl = exists = ProjectReferenceImporter.containsRemoteForUrl((Config)existingRepository.getConfig(), gitUrl);
                return bl;
            }
            catch (URISyntaxException uRISyntaxException) {
                return false;
            }
            finally {
                existingRepository.close();
            }
        }
        return false;
    }

    private static boolean containsRemoteForUrl(Config config, URIish url) throws URISyntaxException {
        Set remotes = config.getSubsections("remote");
        for (String remote : remotes) {
            URIish anonUrl;
            String remoteUrl = config.getString("remote", remote, "url");
            URIish existingUrl = new URIish(remoteUrl);
            if (existingUrl.equals((Object)url)) {
                return true;
            }
            URIish anonExistingUrl = existingUrl.setUser(null);
            if (!anonExistingUrl.equals((Object)(anonUrl = url.setUser(null)))) continue;
            return true;
        }
        return false;
    }

    private List<IProject> importProjects(Set<ProjectReference> projects, IPath workDir, File repositoryPath, IProgressMonitor monitor) throws TeamException {
        try {
            ArrayList<IProject> importedProjects = new ArrayList<IProject>();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            for (ProjectReference projectToImport : projects) {
                IPath projectDir = workDir.append(projectToImport.getProjectDir());
                IProjectDescription projectDescription = workspace.loadProjectDescription(projectDir.append(".project"));
                IProject project = root.getProject(projectDescription.getName());
                if (!project.exists()) {
                    project.create(projectDescription, monitor);
                    importedProjects.add(project);
                }
                project.open(monitor);
                ConnectProviderOperation connectProviderOperation = new ConnectProviderOperation(project, repositoryPath);
                connectProviderOperation.execute(monitor);
            }
            return importedProjects;
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
    }

    private static TeamException getTeamException(Throwable throwable) {
        Throwable current = throwable;
        while (current.getCause() != null) {
            current = current.getCause();
        }
        return new TeamException(current.getMessage(), current);
    }

    private static RepositoryUtil getRepositoryUtil() {
        return Activator.getDefault().getRepositoryUtil();
    }
}

