/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.ui.disassembly.rulers.IColumnSupport;
import org.eclipse.cdt.debug.ui.disassembly.rulers.IContributedRulerColumn;
import org.eclipse.cdt.debug.ui.disassembly.rulers.RulerColumnDescriptor;
import org.eclipse.cdt.debug.ui.disassembly.rulers.RulerColumnRegistry;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyPart;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IWorkbenchPart;

class DisassemblyColumnSupport
implements IColumnSupport {
    private final DisassemblyPart fDisassembly;
    private final RulerColumnRegistry fRegistry;
    private final List<IContributedRulerColumn> fColumns;

    public DisassemblyColumnSupport(DisassemblyPart disassembly, RulerColumnRegistry registry) {
        Assert.isLegal((disassembly != null ? 1 : 0) != 0);
        Assert.isLegal((registry != null ? 1 : 0) != 0);
        this.fDisassembly = disassembly;
        this.fRegistry = registry;
        this.fColumns = new ArrayList<IContributedRulerColumn>();
    }

    public final void setColumnVisible(RulerColumnDescriptor descriptor, boolean visible) {
        Assert.isLegal((descriptor != null ? 1 : 0) != 0);
        CompositeRuler ruler = this.getRuler();
        if (ruler == null) {
            return;
        }
        if (!this.isColumnSupported(descriptor)) {
            visible = false;
        }
        if (this.isColumnVisible(descriptor)) {
            if (!visible) {
                this.removeColumn(ruler, descriptor);
            }
        } else if (visible) {
            this.addColumn(ruler, descriptor);
        }
    }

    private void addColumn(final CompositeRuler ruler, final RulerColumnDescriptor descriptor) {
        final int idx = this.computeIndex(ruler, descriptor);
        SafeRunnable runnable = new SafeRunnable(){

            public void run() throws Exception {
                IContributedRulerColumn column = descriptor.createColumn((IWorkbenchPart)DisassemblyColumnSupport.this.fDisassembly);
                DisassemblyColumnSupport.this.fColumns.add(column);
                DisassemblyColumnSupport.this.initializeColumn(column);
                ruler.addDecorator(idx, (IVerticalRulerColumn)column);
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
    }

    protected void initializeColumn(IContributedRulerColumn column) {
    }

    private void removeColumn(CompositeRuler ruler, RulerColumnDescriptor descriptor) {
        this.removeColumn(ruler, this.getVisibleColumn(ruler, descriptor));
    }

    private void removeColumn(final CompositeRuler ruler, final IContributedRulerColumn rulerColumn) {
        if (rulerColumn != null) {
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    if (ruler != null) {
                        ruler.removeDecorator((IVerticalRulerColumn)rulerColumn);
                    }
                    rulerColumn.columnRemoved();
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
    }

    private IContributedRulerColumn getVisibleColumn(CompositeRuler ruler, RulerColumnDescriptor descriptor) {
        Iterator it = ruler.getDecoratorIterator();
        while (it.hasNext()) {
            IContributedRulerColumn rulerColumn;
            RulerColumnDescriptor rcd;
            IVerticalRulerColumn column = (IVerticalRulerColumn)it.next();
            if (!(column instanceof IContributedRulerColumn) || !descriptor.equals((Object)(rcd = (rulerColumn = (IContributedRulerColumn)column).getDescriptor()))) continue;
            return rulerColumn;
        }
        return null;
    }

    private int computeIndex(CompositeRuler ruler, RulerColumnDescriptor descriptor) {
        int index = 0;
        List all = this.fRegistry.getColumnDescriptors();
        int newPos = all.indexOf(descriptor);
        Iterator it = ruler.getDecoratorIterator();
        while (it.hasNext()) {
            RulerColumnDescriptor rcd;
            IVerticalRulerColumn column = (IVerticalRulerColumn)it.next();
            if (column instanceof IContributedRulerColumn && (rcd = ((IContributedRulerColumn)column).getDescriptor()) != null && all.indexOf(rcd) > newPos) break;
            ++index;
        }
        return index;
    }

    public final boolean isColumnVisible(RulerColumnDescriptor descriptor) {
        Assert.isLegal((descriptor != null ? 1 : 0) != 0);
        CompositeRuler ruler = this.getRuler();
        return ruler != null && this.getVisibleColumn(ruler, descriptor) != null;
    }

    public final boolean isColumnSupported(RulerColumnDescriptor descriptor) {
        Assert.isLegal((descriptor != null ? 1 : 0) != 0);
        if (this.getRuler() == null) {
            return false;
        }
        return descriptor.matchesPart((IWorkbenchPart)this.fDisassembly);
    }

    private CompositeRuler getRuler() {
        Object ruler = this.fDisassembly.getAdapter(IVerticalRulerInfo.class);
        if (ruler instanceof CompositeRuler) {
            return (CompositeRuler)ruler;
        }
        return null;
    }

    public void dispose() {
        Iterator<IContributedRulerColumn> iter = new ArrayList<IContributedRulerColumn>(this.fColumns).iterator();
        while (iter.hasNext()) {
            this.removeColumn(this.getRuler(), iter.next());
        }
        this.fColumns.clear();
    }
}

