/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.ListRemoteOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefContentAssistProvider {
    private List<Ref> destinationRefs;
    private List<Ref> sourceRefs;
    private final Shell shell;
    private final Repository repo;
    private URIish uri;

    public RefContentAssistProvider(Repository repo, URIish uri, Shell shell) {
        this.repo = repo;
        this.uri = uri;
        this.shell = shell;
    }

    public List<Ref> getRefsForContentAssist(boolean source, boolean pushMode) {
        if (source) {
            if (this.sourceRefs != null) {
                return this.sourceRefs;
            }
        } else if (this.destinationRefs != null) {
            return this.destinationRefs;
        }
        ArrayList<Ref> result = new ArrayList<Ref>();
        try {
            boolean local;
            boolean bl = local = pushMode == source;
            if (!local) {
                final ListRemoteOperation lop = new ListRemoteOperation(this.repo, this.uri, Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout"));
                new ProgressMonitorDialog(this.shell).run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(UIText.RefSpecDialog_GettingRemoteRefsMonitorMessage, -1);
                        lop.run(monitor);
                        monitor.done();
                    }
                });
                for (Ref ref : lop.getRemoteRefs()) {
                    if (!ref.getName().startsWith("refs/heads/") && (pushMode || !ref.getName().startsWith("refs/tags/"))) continue;
                    result.add(ref);
                }
            } else if (pushMode) {
                for (Ref ref : this.repo.getRefDatabase().getRefs("").values()) {
                    if (ref.getName().startsWith("refs/remotes/")) continue;
                    result.add(ref);
                }
            } else {
                for (Ref ref : this.repo.getRefDatabase().getRefs("refs/remotes/").values()) {
                    result.add(ref);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Activator.handleError(cause.getMessage(), cause, true);
            return result;
        }
        catch (Exception e) {
            Activator.handleError(e.getMessage(), e, true);
            return result;
        }
        if (source) {
            this.sourceRefs = result;
        } else {
            this.destinationRefs = result;
        }
        return result;
    }

    public Repository getRepository() {
        return this.repo;
    }

    public URIish getRemoteURI() {
        return this.uri;
    }
}

