package cuda

/*
 THIS FILE IS AUTO-GENERATED BY CUDA2GO.
 EDITING IS FUTILE.
*/

import (
	"github.com/mumax/3/cuda/cu"
	"github.com/mumax/3/timer"
	"sync"
	"unsafe"
)

// CUDA handle for resize kernel
var resize_code cu.Function

// Stores the arguments for resize kernel invocation
type resize_args_t struct {
	arg_dst    unsafe.Pointer
	arg_Dx     int
	arg_Dy     int
	arg_Dz     int
	arg_src    unsafe.Pointer
	arg_Sx     int
	arg_Sy     int
	arg_Sz     int
	arg_layer  int
	arg_scalex int
	arg_scaley int
	argptr     [11]unsafe.Pointer
	sync.Mutex
}

// Stores the arguments for resize kernel invocation
var resize_args resize_args_t

func init() {
	// CUDA driver kernel call wants pointers to arguments, set them up once.
	resize_args.argptr[0] = unsafe.Pointer(&resize_args.arg_dst)
	resize_args.argptr[1] = unsafe.Pointer(&resize_args.arg_Dx)
	resize_args.argptr[2] = unsafe.Pointer(&resize_args.arg_Dy)
	resize_args.argptr[3] = unsafe.Pointer(&resize_args.arg_Dz)
	resize_args.argptr[4] = unsafe.Pointer(&resize_args.arg_src)
	resize_args.argptr[5] = unsafe.Pointer(&resize_args.arg_Sx)
	resize_args.argptr[6] = unsafe.Pointer(&resize_args.arg_Sy)
	resize_args.argptr[7] = unsafe.Pointer(&resize_args.arg_Sz)
	resize_args.argptr[8] = unsafe.Pointer(&resize_args.arg_layer)
	resize_args.argptr[9] = unsafe.Pointer(&resize_args.arg_scalex)
	resize_args.argptr[10] = unsafe.Pointer(&resize_args.arg_scaley)
}

// Wrapper for resize CUDA kernel, asynchronous.
func k_resize_async(dst unsafe.Pointer, Dx int, Dy int, Dz int, src unsafe.Pointer, Sx int, Sy int, Sz int, layer int, scalex int, scaley int, cfg *config) {
	if Synchronous { // debug
		Sync()
		timer.Start("resize")
	}

	resize_args.Lock()
	defer resize_args.Unlock()

	if resize_code == 0 {
		resize_code = fatbinLoad(resize_map, "resize")
	}

	resize_args.arg_dst = dst
	resize_args.arg_Dx = Dx
	resize_args.arg_Dy = Dy
	resize_args.arg_Dz = Dz
	resize_args.arg_src = src
	resize_args.arg_Sx = Sx
	resize_args.arg_Sy = Sy
	resize_args.arg_Sz = Sz
	resize_args.arg_layer = layer
	resize_args.arg_scalex = scalex
	resize_args.arg_scaley = scaley

	args := resize_args.argptr[:]
	cu.LaunchKernel(resize_code, cfg.Grid.X, cfg.Grid.Y, cfg.Grid.Z, cfg.Block.X, cfg.Block.Y, cfg.Block.Z, 0, stream0, args)

	if Synchronous { // debug
		Sync()
		timer.Stop("resize")
	}
}

// maps compute capability on PTX code for resize kernel.
var resize_map = map[int]string{0: "",
	50: resize_ptx_50,
	52: resize_ptx_52,
	53: resize_ptx_53,
	60: resize_ptx_60,
	61: resize_ptx_61,
	62: resize_ptx_62,
	70: resize_ptx_70,
	72: resize_ptx_72,
	75: resize_ptx_75,
	80: resize_ptx_80,
	86: resize_ptx_86,
	87: resize_ptx_87,
	89: resize_ptx_89,
	90: resize_ptx_90}

// resize PTX code for various compute capabilities.
const (
	resize_ptx_50 = `
.version 8.5
.target sm_50
.address_size 64

	// .globl	resize

.visible .entry resize(
	.param .u64 resize_param_0,
	.param .u32 resize_param_1,
	.param .u32 resize_param_2,
	.param .u32 resize_param_3,
	.param .u64 resize_param_4,
	.param .u32 resize_param_5,
	.param .u32 resize_param_6,
	.param .u32 resize_param_7,
	.param .u32 resize_param_8,
	.param .u32 resize_param_9,
	.param .u32 resize_param_10
)
{
	.reg .pred 	%p<33>;
	.reg .f32 	%f<80>;
	.reg .b32 	%r<49>;
	.reg .b64 	%rd<11>;


	ld.param.u64 	%rd4, [resize_param_0];
	ld.param.u32 	%r20, [resize_param_1];
	ld.param.u32 	%r26, [resize_param_2];
	ld.param.u64 	%rd5, [resize_param_4];
	ld.param.u32 	%r21, [resize_param_5];
	ld.param.u32 	%r22, [resize_param_6];
	ld.param.u32 	%r23, [resize_param_8];
	ld.param.u32 	%r24, [resize_param_9];
	ld.param.u32 	%r25, [resize_param_10];
	cvta.to.global.u64 	%rd1, %rd5;
	mov.u32 	%r27, %ntid.x;
	mov.u32 	%r28, %ctaid.x;
	mov.u32 	%r29, %tid.x;
	mad.lo.s32 	%r1, %r28, %r27, %r29;
	mov.u32 	%r30, %ntid.y;
	mov.u32 	%r31, %ctaid.y;
	mov.u32 	%r32, %tid.y;
	mad.lo.s32 	%r2, %r31, %r30, %r32;
	setp.ge.s32 	%p1, %r1, %r20;
	setp.ge.s32 	%p2, %r2, %r26;
	or.pred  	%p3, %p1, %p2;
	mov.f32 	%f60, 0f00000000;
	mov.f32 	%f61, 0f00000000;
	@%p3 bra 	$L__BB0_26;

	setp.lt.s32 	%p4, %r25, 1;
	@%p4 bra 	$L__BB0_25;

	mul.lo.s32 	%r3, %r1, %r24;
	setp.lt.s32 	%p5, %r24, 1;
	@%p5 bra 	$L__BB0_25;

	add.s32 	%r4, %r24, -1;
	and.b32  	%r5, %r24, 3;
	sub.s32 	%r6, %r24, %r5;
	mul.lo.s32 	%r7, %r23, %r22;
	mul.lo.s32 	%r8, %r2, %r25;
	mov.f32 	%f61, 0f00000000;
	mov.u32 	%r33, 0;
	mov.u32 	%r45, %r33;
	mov.f32 	%f60, %f61;

$L__BB0_4:
	add.s32 	%r10, %r45, %r8;
	add.s32 	%r35, %r10, %r7;
	mul.lo.s32 	%r11, %r35, %r21;
	setp.lt.u32 	%p6, %r4, 3;
	mov.u32 	%r48, %r33;
	@%p6 bra 	$L__BB0_15;

	mov.u32 	%r48, 0;
	mov.u32 	%r47, %r6;

$L__BB0_6:
	add.s32 	%r14, %r48, %r3;
	setp.ge.s32 	%p7, %r14, %r21;
	setp.ge.s32 	%p8, %r10, %r22;
	add.s32 	%r37, %r14, %r11;
	mul.wide.s32 	%rd6, %r37, 4;
	add.s64 	%rd2, %rd1, %rd6;
	or.pred  	%p9, %p8, %p7;
	@%p9 bra 	$L__BB0_8;

	ld.global.nc.f32 	%f46, [%rd2];
	add.f32 	%f60, %f60, %f46;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_8:
	add.s32 	%r38, %r14, 1;
	setp.ge.s32 	%p10, %r38, %r21;
	or.pred  	%p12, %p8, %p10;
	@%p12 bra 	$L__BB0_10;

	ld.global.nc.f32 	%f47, [%rd2+4];
	add.f32 	%f60, %f60, %f47;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_10:
	add.s32 	%r39, %r14, 2;
	setp.ge.s32 	%p13, %r39, %r21;
	or.pred  	%p15, %p8, %p13;
	@%p15 bra 	$L__BB0_12;

	ld.global.nc.f32 	%f48, [%rd2+8];
	add.f32 	%f60, %f60, %f48;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_12:
	add.s32 	%r40, %r14, 3;
	setp.ge.s32 	%p16, %r40, %r21;
	or.pred  	%p18, %p8, %p16;
	@%p18 bra 	$L__BB0_14;

	ld.global.nc.f32 	%f49, [%rd2+12];
	add.f32 	%f60, %f60, %f49;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_14:
	add.s32 	%r48, %r48, 4;
	add.s32 	%r47, %r47, -4;
	setp.ne.s32 	%p19, %r47, 0;
	@%p19 bra 	$L__BB0_6;

$L__BB0_15:
	setp.eq.s32 	%p20, %r5, 0;
	@%p20 bra 	$L__BB0_24;

	setp.ge.s32 	%p21, %r10, %r22;
	add.s32 	%r18, %r48, %r3;
	setp.ge.s32 	%p22, %r18, %r21;
	add.s32 	%r41, %r18, %r11;
	mul.wide.s32 	%rd7, %r41, 4;
	add.s64 	%rd3, %rd1, %rd7;
	or.pred  	%p23, %p21, %p22;
	@%p23 bra 	$L__BB0_18;

	ld.global.nc.f32 	%f50, [%rd3];
	add.f32 	%f60, %f60, %f50;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_18:
	setp.eq.s32 	%p24, %r5, 1;
	@%p24 bra 	$L__BB0_24;

	add.s32 	%r42, %r18, 1;
	setp.ge.s32 	%p26, %r42, %r21;
	or.pred  	%p27, %p21, %p26;
	@%p27 bra 	$L__BB0_21;

	ld.global.nc.f32 	%f51, [%rd3+4];
	add.f32 	%f60, %f60, %f51;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_21:
	setp.eq.s32 	%p28, %r5, 2;
	@%p28 bra 	$L__BB0_24;

	add.s32 	%r43, %r18, 2;
	setp.ge.s32 	%p30, %r43, %r21;
	or.pred  	%p31, %p21, %p30;
	@%p31 bra 	$L__BB0_24;

	ld.global.nc.f32 	%f52, [%rd3+8];
	add.f32 	%f60, %f60, %f52;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_24:
	add.s32 	%r45, %r45, 1;
	setp.lt.s32 	%p32, %r45, %r25;
	@%p32 bra 	$L__BB0_4;

$L__BB0_25:
	mad.lo.s32 	%r44, %r2, %r20, %r1;
	cvta.to.global.u64 	%rd8, %rd4;
	mul.wide.s32 	%rd9, %r44, 4;
	add.s64 	%rd10, %rd8, %rd9;
	div.rn.f32 	%f53, %f60, %f61;
	st.global.f32 	[%rd10], %f53;

$L__BB0_26:
	ret;

}

`
	resize_ptx_52 = `
.version 8.5
.target sm_52
.address_size 64

	// .globl	resize

.visible .entry resize(
	.param .u64 resize_param_0,
	.param .u32 resize_param_1,
	.param .u32 resize_param_2,
	.param .u32 resize_param_3,
	.param .u64 resize_param_4,
	.param .u32 resize_param_5,
	.param .u32 resize_param_6,
	.param .u32 resize_param_7,
	.param .u32 resize_param_8,
	.param .u32 resize_param_9,
	.param .u32 resize_param_10
)
{
	.reg .pred 	%p<33>;
	.reg .f32 	%f<80>;
	.reg .b32 	%r<49>;
	.reg .b64 	%rd<11>;


	ld.param.u64 	%rd4, [resize_param_0];
	ld.param.u32 	%r20, [resize_param_1];
	ld.param.u32 	%r26, [resize_param_2];
	ld.param.u64 	%rd5, [resize_param_4];
	ld.param.u32 	%r21, [resize_param_5];
	ld.param.u32 	%r22, [resize_param_6];
	ld.param.u32 	%r23, [resize_param_8];
	ld.param.u32 	%r24, [resize_param_9];
	ld.param.u32 	%r25, [resize_param_10];
	cvta.to.global.u64 	%rd1, %rd5;
	mov.u32 	%r27, %ntid.x;
	mov.u32 	%r28, %ctaid.x;
	mov.u32 	%r29, %tid.x;
	mad.lo.s32 	%r1, %r28, %r27, %r29;
	mov.u32 	%r30, %ntid.y;
	mov.u32 	%r31, %ctaid.y;
	mov.u32 	%r32, %tid.y;
	mad.lo.s32 	%r2, %r31, %r30, %r32;
	setp.ge.s32 	%p1, %r1, %r20;
	setp.ge.s32 	%p2, %r2, %r26;
	or.pred  	%p3, %p1, %p2;
	mov.f32 	%f60, 0f00000000;
	mov.f32 	%f61, 0f00000000;
	@%p3 bra 	$L__BB0_26;

	setp.lt.s32 	%p4, %r25, 1;
	@%p4 bra 	$L__BB0_25;

	mul.lo.s32 	%r3, %r1, %r24;
	setp.lt.s32 	%p5, %r24, 1;
	@%p5 bra 	$L__BB0_25;

	add.s32 	%r4, %r24, -1;
	and.b32  	%r5, %r24, 3;
	sub.s32 	%r6, %r24, %r5;
	mul.lo.s32 	%r7, %r23, %r22;
	mul.lo.s32 	%r8, %r2, %r25;
	mov.f32 	%f61, 0f00000000;
	mov.u32 	%r33, 0;
	mov.u32 	%r45, %r33;
	mov.f32 	%f60, %f61;

$L__BB0_4:
	add.s32 	%r10, %r45, %r8;
	add.s32 	%r35, %r10, %r7;
	mul.lo.s32 	%r11, %r35, %r21;
	setp.lt.u32 	%p6, %r4, 3;
	mov.u32 	%r48, %r33;
	@%p6 bra 	$L__BB0_15;

	mov.u32 	%r48, 0;
	mov.u32 	%r47, %r6;

$L__BB0_6:
	add.s32 	%r14, %r48, %r3;
	setp.ge.s32 	%p7, %r14, %r21;
	setp.ge.s32 	%p8, %r10, %r22;
	add.s32 	%r37, %r14, %r11;
	mul.wide.s32 	%rd6, %r37, 4;
	add.s64 	%rd2, %rd1, %rd6;
	or.pred  	%p9, %p8, %p7;
	@%p9 bra 	$L__BB0_8;

	ld.global.nc.f32 	%f46, [%rd2];
	add.f32 	%f60, %f60, %f46;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_8:
	add.s32 	%r38, %r14, 1;
	setp.ge.s32 	%p10, %r38, %r21;
	or.pred  	%p12, %p8, %p10;
	@%p12 bra 	$L__BB0_10;

	ld.global.nc.f32 	%f47, [%rd2+4];
	add.f32 	%f60, %f60, %f47;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_10:
	add.s32 	%r39, %r14, 2;
	setp.ge.s32 	%p13, %r39, %r21;
	or.pred  	%p15, %p8, %p13;
	@%p15 bra 	$L__BB0_12;

	ld.global.nc.f32 	%f48, [%rd2+8];
	add.f32 	%f60, %f60, %f48;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_12:
	add.s32 	%r40, %r14, 3;
	setp.ge.s32 	%p16, %r40, %r21;
	or.pred  	%p18, %p8, %p16;
	@%p18 bra 	$L__BB0_14;

	ld.global.nc.f32 	%f49, [%rd2+12];
	add.f32 	%f60, %f60, %f49;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_14:
	add.s32 	%r48, %r48, 4;
	add.s32 	%r47, %r47, -4;
	setp.ne.s32 	%p19, %r47, 0;
	@%p19 bra 	$L__BB0_6;

$L__BB0_15:
	setp.eq.s32 	%p20, %r5, 0;
	@%p20 bra 	$L__BB0_24;

	setp.ge.s32 	%p21, %r10, %r22;
	add.s32 	%r18, %r48, %r3;
	setp.ge.s32 	%p22, %r18, %r21;
	add.s32 	%r41, %r18, %r11;
	mul.wide.s32 	%rd7, %r41, 4;
	add.s64 	%rd3, %rd1, %rd7;
	or.pred  	%p23, %p21, %p22;
	@%p23 bra 	$L__BB0_18;

	ld.global.nc.f32 	%f50, [%rd3];
	add.f32 	%f60, %f60, %f50;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_18:
	setp.eq.s32 	%p24, %r5, 1;
	@%p24 bra 	$L__BB0_24;

	add.s32 	%r42, %r18, 1;
	setp.ge.s32 	%p26, %r42, %r21;
	or.pred  	%p27, %p21, %p26;
	@%p27 bra 	$L__BB0_21;

	ld.global.nc.f32 	%f51, [%rd3+4];
	add.f32 	%f60, %f60, %f51;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_21:
	setp.eq.s32 	%p28, %r5, 2;
	@%p28 bra 	$L__BB0_24;

	add.s32 	%r43, %r18, 2;
	setp.ge.s32 	%p30, %r43, %r21;
	or.pred  	%p31, %p21, %p30;
	@%p31 bra 	$L__BB0_24;

	ld.global.nc.f32 	%f52, [%rd3+8];
	add.f32 	%f60, %f60, %f52;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_24:
	add.s32 	%r45, %r45, 1;
	setp.lt.s32 	%p32, %r45, %r25;
	@%p32 bra 	$L__BB0_4;

$L__BB0_25:
	mad.lo.s32 	%r44, %r2, %r20, %r1;
	cvta.to.global.u64 	%rd8, %rd4;
	mul.wide.s32 	%rd9, %r44, 4;
	add.s64 	%rd10, %rd8, %rd9;
	div.rn.f32 	%f53, %f60, %f61;
	st.global.f32 	[%rd10], %f53;

$L__BB0_26:
	ret;

}

`
	resize_ptx_53 = `
.version 8.5
.target sm_53
.address_size 64

	// .globl	resize

.visible .entry resize(
	.param .u64 resize_param_0,
	.param .u32 resize_param_1,
	.param .u32 resize_param_2,
	.param .u32 resize_param_3,
	.param .u64 resize_param_4,
	.param .u32 resize_param_5,
	.param .u32 resize_param_6,
	.param .u32 resize_param_7,
	.param .u32 resize_param_8,
	.param .u32 resize_param_9,
	.param .u32 resize_param_10
)
{
	.reg .pred 	%p<33>;
	.reg .f32 	%f<80>;
	.reg .b32 	%r<49>;
	.reg .b64 	%rd<11>;


	ld.param.u64 	%rd4, [resize_param_0];
	ld.param.u32 	%r20, [resize_param_1];
	ld.param.u32 	%r26, [resize_param_2];
	ld.param.u64 	%rd5, [resize_param_4];
	ld.param.u32 	%r21, [resize_param_5];
	ld.param.u32 	%r22, [resize_param_6];
	ld.param.u32 	%r23, [resize_param_8];
	ld.param.u32 	%r24, [resize_param_9];
	ld.param.u32 	%r25, [resize_param_10];
	cvta.to.global.u64 	%rd1, %rd5;
	mov.u32 	%r27, %ntid.x;
	mov.u32 	%r28, %ctaid.x;
	mov.u32 	%r29, %tid.x;
	mad.lo.s32 	%r1, %r28, %r27, %r29;
	mov.u32 	%r30, %ntid.y;
	mov.u32 	%r31, %ctaid.y;
	mov.u32 	%r32, %tid.y;
	mad.lo.s32 	%r2, %r31, %r30, %r32;
	setp.ge.s32 	%p1, %r1, %r20;
	setp.ge.s32 	%p2, %r2, %r26;
	or.pred  	%p3, %p1, %p2;
	mov.f32 	%f60, 0f00000000;
	mov.f32 	%f61, 0f00000000;
	@%p3 bra 	$L__BB0_26;

	setp.lt.s32 	%p4, %r25, 1;
	@%p4 bra 	$L__BB0_25;

	mul.lo.s32 	%r3, %r1, %r24;
	setp.lt.s32 	%p5, %r24, 1;
	@%p5 bra 	$L__BB0_25;

	add.s32 	%r4, %r24, -1;
	and.b32  	%r5, %r24, 3;
	sub.s32 	%r6, %r24, %r5;
	mul.lo.s32 	%r7, %r23, %r22;
	mul.lo.s32 	%r8, %r2, %r25;
	mov.f32 	%f61, 0f00000000;
	mov.u32 	%r33, 0;
	mov.u32 	%r45, %r33;
	mov.f32 	%f60, %f61;

$L__BB0_4:
	add.s32 	%r10, %r45, %r8;
	add.s32 	%r35, %r10, %r7;
	mul.lo.s32 	%r11, %r35, %r21;
	setp.lt.u32 	%p6, %r4, 3;
	mov.u32 	%r48, %r33;
	@%p6 bra 	$L__BB0_15;

	mov.u32 	%r48, 0;
	mov.u32 	%r47, %r6;

$L__BB0_6:
	add.s32 	%r14, %r48, %r3;
	setp.ge.s32 	%p7, %r14, %r21;
	setp.ge.s32 	%p8, %r10, %r22;
	add.s32 	%r37, %r14, %r11;
	mul.wide.s32 	%rd6, %r37, 4;
	add.s64 	%rd2, %rd1, %rd6;
	or.pred  	%p9, %p8, %p7;
	@%p9 bra 	$L__BB0_8;

	ld.global.nc.f32 	%f46, [%rd2];
	add.f32 	%f60, %f60, %f46;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_8:
	add.s32 	%r38, %r14, 1;
	setp.ge.s32 	%p10, %r38, %r21;
	or.pred  	%p12, %p8, %p10;
	@%p12 bra 	$L__BB0_10;

	ld.global.nc.f32 	%f47, [%rd2+4];
	add.f32 	%f60, %f60, %f47;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_10:
	add.s32 	%r39, %r14, 2;
	setp.ge.s32 	%p13, %r39, %r21;
	or.pred  	%p15, %p8, %p13;
	@%p15 bra 	$L__BB0_12;

	ld.global.nc.f32 	%f48, [%rd2+8];
	add.f32 	%f60, %f60, %f48;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_12:
	add.s32 	%r40, %r14, 3;
	setp.ge.s32 	%p16, %r40, %r21;
	or.pred  	%p18, %p8, %p16;
	@%p18 bra 	$L__BB0_14;

	ld.global.nc.f32 	%f49, [%rd2+12];
	add.f32 	%f60, %f60, %f49;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_14:
	add.s32 	%r48, %r48, 4;
	add.s32 	%r47, %r47, -4;
	setp.ne.s32 	%p19, %r47, 0;
	@%p19 bra 	$L__BB0_6;

$L__BB0_15:
	setp.eq.s32 	%p20, %r5, 0;
	@%p20 bra 	$L__BB0_24;

	setp.ge.s32 	%p21, %r10, %r22;
	add.s32 	%r18, %r48, %r3;
	setp.ge.s32 	%p22, %r18, %r21;
	add.s32 	%r41, %r18, %r11;
	mul.wide.s32 	%rd7, %r41, 4;
	add.s64 	%rd3, %rd1, %rd7;
	or.pred  	%p23, %p21, %p22;
	@%p23 bra 	$L__BB0_18;

	ld.global.nc.f32 	%f50, [%rd3];
	add.f32 	%f60, %f60, %f50;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_18:
	setp.eq.s32 	%p24, %r5, 1;
	@%p24 bra 	$L__BB0_24;

	add.s32 	%r42, %r18, 1;
	setp.ge.s32 	%p26, %r42, %r21;
	or.pred  	%p27, %p21, %p26;
	@%p27 bra 	$L__BB0_21;

	ld.global.nc.f32 	%f51, [%rd3+4];
	add.f32 	%f60, %f60, %f51;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_21:
	setp.eq.s32 	%p28, %r5, 2;
	@%p28 bra 	$L__BB0_24;

	add.s32 	%r43, %r18, 2;
	setp.ge.s32 	%p30, %r43, %r21;
	or.pred  	%p31, %p21, %p30;
	@%p31 bra 	$L__BB0_24;

	ld.global.nc.f32 	%f52, [%rd3+8];
	add.f32 	%f60, %f60, %f52;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_24:
	add.s32 	%r45, %r45, 1;
	setp.lt.s32 	%p32, %r45, %r25;
	@%p32 bra 	$L__BB0_4;

$L__BB0_25:
	mad.lo.s32 	%r44, %r2, %r20, %r1;
	cvta.to.global.u64 	%rd8, %rd4;
	mul.wide.s32 	%rd9, %r44, 4;
	add.s64 	%rd10, %rd8, %rd9;
	div.rn.f32 	%f53, %f60, %f61;
	st.global.f32 	[%rd10], %f53;

$L__BB0_26:
	ret;

}

`
	resize_ptx_60 = `
.version 8.5
.target sm_60
.address_size 64

	// .globl	resize

.visible .entry resize(
	.param .u64 resize_param_0,
	.param .u32 resize_param_1,
	.param .u32 resize_param_2,
	.param .u32 resize_param_3,
	.param .u64 resize_param_4,
	.param .u32 resize_param_5,
	.param .u32 resize_param_6,
	.param .u32 resize_param_7,
	.param .u32 resize_param_8,
	.param .u32 resize_param_9,
	.param .u32 resize_param_10
)
{
	.reg .pred 	%p<33>;
	.reg .f32 	%f<80>;
	.reg .b32 	%r<49>;
	.reg .b64 	%rd<11>;


	ld.param.u64 	%rd4, [resize_param_0];
	ld.param.u32 	%r20, [resize_param_1];
	ld.param.u32 	%r26, [resize_param_2];
	ld.param.u64 	%rd5, [resize_param_4];
	ld.param.u32 	%r21, [resize_param_5];
	ld.param.u32 	%r22, [resize_param_6];
	ld.param.u32 	%r23, [resize_param_8];
	ld.param.u32 	%r24, [resize_param_9];
	ld.param.u32 	%r25, [resize_param_10];
	cvta.to.global.u64 	%rd1, %rd5;
	mov.u32 	%r27, %ntid.x;
	mov.u32 	%r28, %ctaid.x;
	mov.u32 	%r29, %tid.x;
	mad.lo.s32 	%r1, %r28, %r27, %r29;
	mov.u32 	%r30, %ntid.y;
	mov.u32 	%r31, %ctaid.y;
	mov.u32 	%r32, %tid.y;
	mad.lo.s32 	%r2, %r31, %r30, %r32;
	setp.ge.s32 	%p1, %r1, %r20;
	setp.ge.s32 	%p2, %r2, %r26;
	or.pred  	%p3, %p1, %p2;
	mov.f32 	%f60, 0f00000000;
	mov.f32 	%f61, 0f00000000;
	@%p3 bra 	$L__BB0_26;

	setp.lt.s32 	%p4, %r25, 1;
	@%p4 bra 	$L__BB0_25;

	mul.lo.s32 	%r3, %r1, %r24;
	setp.lt.s32 	%p5, %r24, 1;
	@%p5 bra 	$L__BB0_25;

	add.s32 	%r4, %r24, -1;
	and.b32  	%r5, %r24, 3;
	sub.s32 	%r6, %r24, %r5;
	mul.lo.s32 	%r7, %r23, %r22;
	mul.lo.s32 	%r8, %r2, %r25;
	mov.f32 	%f61, 0f00000000;
	mov.u32 	%r33, 0;
	mov.u32 	%r45, %r33;
	mov.f32 	%f60, %f61;

$L__BB0_4:
	add.s32 	%r10, %r45, %r8;
	add.s32 	%r35, %r10, %r7;
	mul.lo.s32 	%r11, %r35, %r21;
	setp.lt.u32 	%p6, %r4, 3;
	mov.u32 	%r48, %r33;
	@%p6 bra 	$L__BB0_15;

	mov.u32 	%r48, 0;
	mov.u32 	%r47, %r6;

$L__BB0_6:
	add.s32 	%r14, %r48, %r3;
	setp.ge.s32 	%p7, %r14, %r21;
	setp.ge.s32 	%p8, %r10, %r22;
	add.s32 	%r37, %r14, %r11;
	mul.wide.s32 	%rd6, %r37, 4;
	add.s64 	%rd2, %rd1, %rd6;
	or.pred  	%p9, %p8, %p7;
	@%p9 bra 	$L__BB0_8;

	ld.global.nc.f32 	%f46, [%rd2];
	add.f32 	%f60, %f60, %f46;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_8:
	add.s32 	%r38, %r14, 1;
	setp.ge.s32 	%p10, %r38, %r21;
	or.pred  	%p12, %p8, %p10;
	@%p12 bra 	$L__BB0_10;

	ld.global.nc.f32 	%f47, [%rd2+4];
	add.f32 	%f60, %f60, %f47;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_10:
	add.s32 	%r39, %r14, 2;
	setp.ge.s32 	%p13, %r39, %r21;
	or.pred  	%p15, %p8, %p13;
	@%p15 bra 	$L__BB0_12;

	ld.global.nc.f32 	%f48, [%rd2+8];
	add.f32 	%f60, %f60, %f48;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_12:
	add.s32 	%r40, %r14, 3;
	setp.ge.s32 	%p16, %r40, %r21;
	or.pred  	%p18, %p8, %p16;
	@%p18 bra 	$L__BB0_14;

	ld.global.nc.f32 	%f49, [%rd2+12];
	add.f32 	%f60, %f60, %f49;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_14:
	add.s32 	%r48, %r48, 4;
	add.s32 	%r47, %r47, -4;
	setp.ne.s32 	%p19, %r47, 0;
	@%p19 bra 	$L__BB0_6;

$L__BB0_15:
	setp.eq.s32 	%p20, %r5, 0;
	@%p20 bra 	$L__BB0_24;

	setp.ge.s32 	%p21, %r10, %r22;
	add.s32 	%r18, %r48, %r3;
	setp.ge.s32 	%p22, %r18, %r21;
	add.s32 	%r41, %r18, %r11;
	mul.wide.s32 	%rd7, %r41, 4;
	add.s64 	%rd3, %rd1, %rd7;
	or.pred  	%p23, %p21, %p22;
	@%p23 bra 	$L__BB0_18;

	ld.global.nc.f32 	%f50, [%rd3];
	add.f32 	%f60, %f60, %f50;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_18:
	setp.eq.s32 	%p24, %r5, 1;
	@%p24 bra 	$L__BB0_24;

	add.s32 	%r42, %r18, 1;
	setp.ge.s32 	%p26, %r42, %r21;
	or.pred  	%p27, %p21, %p26;
	@%p27 bra 	$L__BB0_21;

	ld.global.nc.f32 	%f51, [%rd3+4];
	add.f32 	%f60, %f60, %f51;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_21:
	setp.eq.s32 	%p28, %r5, 2;
	@%p28 bra 	$L__BB0_24;

	add.s32 	%r43, %r18, 2;
	setp.ge.s32 	%p30, %r43, %r21;
	or.pred  	%p31, %p21, %p30;
	@%p31 bra 	$L__BB0_24;

	ld.global.nc.f32 	%f52, [%rd3+8];
	add.f32 	%f60, %f60, %f52;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_24:
	add.s32 	%r45, %r45, 1;
	setp.lt.s32 	%p32, %r45, %r25;
	@%p32 bra 	$L__BB0_4;

$L__BB0_25:
	mad.lo.s32 	%r44, %r2, %r20, %r1;
	cvta.to.global.u64 	%rd8, %rd4;
	mul.wide.s32 	%rd9, %r44, 4;
	add.s64 	%rd10, %rd8, %rd9;
	div.rn.f32 	%f53, %f60, %f61;
	st.global.f32 	[%rd10], %f53;

$L__BB0_26:
	ret;

}

`
	resize_ptx_61 = `
.version 8.5
.target sm_61
.address_size 64

	// .globl	resize

.visible .entry resize(
	.param .u64 resize_param_0,
	.param .u32 resize_param_1,
	.param .u32 resize_param_2,
	.param .u32 resize_param_3,
	.param .u64 resize_param_4,
	.param .u32 resize_param_5,
	.param .u32 resize_param_6,
	.param .u32 resize_param_7,
	.param .u32 resize_param_8,
	.param .u32 resize_param_9,
	.param .u32 resize_param_10
)
{
	.reg .pred 	%p<33>;
	.reg .f32 	%f<80>;
	.reg .b32 	%r<49>;
	.reg .b64 	%rd<11>;


	ld.param.u64 	%rd4, [resize_param_0];
	ld.param.u32 	%r20, [resize_param_1];
	ld.param.u32 	%r26, [resize_param_2];
	ld.param.u64 	%rd5, [resize_param_4];
	ld.param.u32 	%r21, [resize_param_5];
	ld.param.u32 	%r22, [resize_param_6];
	ld.param.u32 	%r23, [resize_param_8];
	ld.param.u32 	%r24, [resize_param_9];
	ld.param.u32 	%r25, [resize_param_10];
	cvta.to.global.u64 	%rd1, %rd5;
	mov.u32 	%r27, %ntid.x;
	mov.u32 	%r28, %ctaid.x;
	mov.u32 	%r29, %tid.x;
	mad.lo.s32 	%r1, %r28, %r27, %r29;
	mov.u32 	%r30, %ntid.y;
	mov.u32 	%r31, %ctaid.y;
	mov.u32 	%r32, %tid.y;
	mad.lo.s32 	%r2, %r31, %r30, %r32;
	setp.ge.s32 	%p1, %r1, %r20;
	setp.ge.s32 	%p2, %r2, %r26;
	or.pred  	%p3, %p1, %p2;
	mov.f32 	%f60, 0f00000000;
	mov.f32 	%f61, 0f00000000;
	@%p3 bra 	$L__BB0_26;

	setp.lt.s32 	%p4, %r25, 1;
	@%p4 bra 	$L__BB0_25;

	mul.lo.s32 	%r3, %r1, %r24;
	setp.lt.s32 	%p5, %r24, 1;
	@%p5 bra 	$L__BB0_25;

	add.s32 	%r4, %r24, -1;
	and.b32  	%r5, %r24, 3;
	sub.s32 	%r6, %r24, %r5;
	mul.lo.s32 	%r7, %r23, %r22;
	mul.lo.s32 	%r8, %r2, %r25;
	mov.f32 	%f61, 0f00000000;
	mov.u32 	%r33, 0;
	mov.u32 	%r45, %r33;
	mov.f32 	%f60, %f61;

$L__BB0_4:
	add.s32 	%r10, %r45, %r8;
	add.s32 	%r35, %r10, %r7;
	mul.lo.s32 	%r11, %r35, %r21;
	setp.lt.u32 	%p6, %r4, 3;
	mov.u32 	%r48, %r33;
	@%p6 bra 	$L__BB0_15;

	mov.u32 	%r48, 0;
	mov.u32 	%r47, %r6;

$L__BB0_6:
	add.s32 	%r14, %r48, %r3;
	setp.ge.s32 	%p7, %r14, %r21;
	setp.ge.s32 	%p8, %r10, %r22;
	add.s32 	%r37, %r14, %r11;
	mul.wide.s32 	%rd6, %r37, 4;
	add.s64 	%rd2, %rd1, %rd6;
	or.pred  	%p9, %p8, %p7;
	@%p9 bra 	$L__BB0_8;

	ld.global.nc.f32 	%f46, [%rd2];
	add.f32 	%f60, %f60, %f46;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_8:
	add.s32 	%r38, %r14, 1;
	setp.ge.s32 	%p10, %r38, %r21;
	or.pred  	%p12, %p8, %p10;
	@%p12 bra 	$L__BB0_10;

	ld.global.nc.f32 	%f47, [%rd2+4];
	add.f32 	%f60, %f60, %f47;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_10:
	add.s32 	%r39, %r14, 2;
	setp.ge.s32 	%p13, %r39, %r21;
	or.pred  	%p15, %p8, %p13;
	@%p15 bra 	$L__BB0_12;

	ld.global.nc.f32 	%f48, [%rd2+8];
	add.f32 	%f60, %f60, %f48;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_12:
	add.s32 	%r40, %r14, 3;
	setp.ge.s32 	%p16, %r40, %r21;
	or.pred  	%p18, %p8, %p16;
	@%p18 bra 	$L__BB0_14;

	ld.global.nc.f32 	%f49, [%rd2+12];
	add.f32 	%f60, %f60, %f49;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_14:
	add.s32 	%r48, %r48, 4;
	add.s32 	%r47, %r47, -4;
	setp.ne.s32 	%p19, %r47, 0;
	@%p19 bra 	$L__BB0_6;

$L__BB0_15:
	setp.eq.s32 	%p20, %r5, 0;
	@%p20 bra 	$L__BB0_24;

	setp.ge.s32 	%p21, %r10, %r22;
	add.s32 	%r18, %r48, %r3;
	setp.ge.s32 	%p22, %r18, %r21;
	add.s32 	%r41, %r18, %r11;
	mul.wide.s32 	%rd7, %r41, 4;
	add.s64 	%rd3, %rd1, %rd7;
	or.pred  	%p23, %p21, %p22;
	@%p23 bra 	$L__BB0_18;

	ld.global.nc.f32 	%f50, [%rd3];
	add.f32 	%f60, %f60, %f50;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_18:
	setp.eq.s32 	%p24, %r5, 1;
	@%p24 bra 	$L__BB0_24;

	add.s32 	%r42, %r18, 1;
	setp.ge.s32 	%p26, %r42, %r21;
	or.pred  	%p27, %p21, %p26;
	@%p27 bra 	$L__BB0_21;

	ld.global.nc.f32 	%f51, [%rd3+4];
	add.f32 	%f60, %f60, %f51;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_21:
	setp.eq.s32 	%p28, %r5, 2;
	@%p28 bra 	$L__BB0_24;

	add.s32 	%r43, %r18, 2;
	setp.ge.s32 	%p30, %r43, %r21;
	or.pred  	%p31, %p21, %p30;
	@%p31 bra 	$L__BB0_24;

	ld.global.nc.f32 	%f52, [%rd3+8];
	add.f32 	%f60, %f60, %f52;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_24:
	add.s32 	%r45, %r45, 1;
	setp.lt.s32 	%p32, %r45, %r25;
	@%p32 bra 	$L__BB0_4;

$L__BB0_25:
	mad.lo.s32 	%r44, %r2, %r20, %r1;
	cvta.to.global.u64 	%rd8, %rd4;
	mul.wide.s32 	%rd9, %r44, 4;
	add.s64 	%rd10, %rd8, %rd9;
	div.rn.f32 	%f53, %f60, %f61;
	st.global.f32 	[%rd10], %f53;

$L__BB0_26:
	ret;

}

`
	resize_ptx_62 = `
.version 8.5
.target sm_62
.address_size 64

	// .globl	resize

.visible .entry resize(
	.param .u64 resize_param_0,
	.param .u32 resize_param_1,
	.param .u32 resize_param_2,
	.param .u32 resize_param_3,
	.param .u64 resize_param_4,
	.param .u32 resize_param_5,
	.param .u32 resize_param_6,
	.param .u32 resize_param_7,
	.param .u32 resize_param_8,
	.param .u32 resize_param_9,
	.param .u32 resize_param_10
)
{
	.reg .pred 	%p<33>;
	.reg .f32 	%f<80>;
	.reg .b32 	%r<49>;
	.reg .b64 	%rd<11>;


	ld.param.u64 	%rd4, [resize_param_0];
	ld.param.u32 	%r20, [resize_param_1];
	ld.param.u32 	%r26, [resize_param_2];
	ld.param.u64 	%rd5, [resize_param_4];
	ld.param.u32 	%r21, [resize_param_5];
	ld.param.u32 	%r22, [resize_param_6];
	ld.param.u32 	%r23, [resize_param_8];
	ld.param.u32 	%r24, [resize_param_9];
	ld.param.u32 	%r25, [resize_param_10];
	cvta.to.global.u64 	%rd1, %rd5;
	mov.u32 	%r27, %ntid.x;
	mov.u32 	%r28, %ctaid.x;
	mov.u32 	%r29, %tid.x;
	mad.lo.s32 	%r1, %r28, %r27, %r29;
	mov.u32 	%r30, %ntid.y;
	mov.u32 	%r31, %ctaid.y;
	mov.u32 	%r32, %tid.y;
	mad.lo.s32 	%r2, %r31, %r30, %r32;
	setp.ge.s32 	%p1, %r1, %r20;
	setp.ge.s32 	%p2, %r2, %r26;
	or.pred  	%p3, %p1, %p2;
	mov.f32 	%f60, 0f00000000;
	mov.f32 	%f61, 0f00000000;
	@%p3 bra 	$L__BB0_26;

	setp.lt.s32 	%p4, %r25, 1;
	@%p4 bra 	$L__BB0_25;

	mul.lo.s32 	%r3, %r1, %r24;
	setp.lt.s32 	%p5, %r24, 1;
	@%p5 bra 	$L__BB0_25;

	add.s32 	%r4, %r24, -1;
	and.b32  	%r5, %r24, 3;
	sub.s32 	%r6, %r24, %r5;
	mul.lo.s32 	%r7, %r23, %r22;
	mul.lo.s32 	%r8, %r2, %r25;
	mov.f32 	%f61, 0f00000000;
	mov.u32 	%r33, 0;
	mov.u32 	%r45, %r33;
	mov.f32 	%f60, %f61;

$L__BB0_4:
	add.s32 	%r10, %r45, %r8;
	add.s32 	%r35, %r10, %r7;
	mul.lo.s32 	%r11, %r35, %r21;
	setp.lt.u32 	%p6, %r4, 3;
	mov.u32 	%r48, %r33;
	@%p6 bra 	$L__BB0_15;

	mov.u32 	%r48, 0;
	mov.u32 	%r47, %r6;

$L__BB0_6:
	add.s32 	%r14, %r48, %r3;
	setp.ge.s32 	%p7, %r14, %r21;
	setp.ge.s32 	%p8, %r10, %r22;
	add.s32 	%r37, %r14, %r11;
	mul.wide.s32 	%rd6, %r37, 4;
	add.s64 	%rd2, %rd1, %rd6;
	or.pred  	%p9, %p8, %p7;
	@%p9 bra 	$L__BB0_8;

	ld.global.nc.f32 	%f46, [%rd2];
	add.f32 	%f60, %f60, %f46;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_8:
	add.s32 	%r38, %r14, 1;
	setp.ge.s32 	%p10, %r38, %r21;
	or.pred  	%p12, %p8, %p10;
	@%p12 bra 	$L__BB0_10;

	ld.global.nc.f32 	%f47, [%rd2+4];
	add.f32 	%f60, %f60, %f47;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_10:
	add.s32 	%r39, %r14, 2;
	setp.ge.s32 	%p13, %r39, %r21;
	or.pred  	%p15, %p8, %p13;
	@%p15 bra 	$L__BB0_12;

	ld.global.nc.f32 	%f48, [%rd2+8];
	add.f32 	%f60, %f60, %f48;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_12:
	add.s32 	%r40, %r14, 3;
	setp.ge.s32 	%p16, %r40, %r21;
	or.pred  	%p18, %p8, %p16;
	@%p18 bra 	$L__BB0_14;

	ld.global.nc.f32 	%f49, [%rd2+12];
	add.f32 	%f60, %f60, %f49;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_14:
	add.s32 	%r48, %r48, 4;
	add.s32 	%r47, %r47, -4;
	setp.ne.s32 	%p19, %r47, 0;
	@%p19 bra 	$L__BB0_6;

$L__BB0_15:
	setp.eq.s32 	%p20, %r5, 0;
	@%p20 bra 	$L__BB0_24;

	setp.ge.s32 	%p21, %r10, %r22;
	add.s32 	%r18, %r48, %r3;
	setp.ge.s32 	%p22, %r18, %r21;
	add.s32 	%r41, %r18, %r11;
	mul.wide.s32 	%rd7, %r41, 4;
	add.s64 	%rd3, %rd1, %rd7;
	or.pred  	%p23, %p21, %p22;
	@%p23 bra 	$L__BB0_18;

	ld.global.nc.f32 	%f50, [%rd3];
	add.f32 	%f60, %f60, %f50;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_18:
	setp.eq.s32 	%p24, %r5, 1;
	@%p24 bra 	$L__BB0_24;

	add.s32 	%r42, %r18, 1;
	setp.ge.s32 	%p26, %r42, %r21;
	or.pred  	%p27, %p21, %p26;
	@%p27 bra 	$L__BB0_21;

	ld.global.nc.f32 	%f51, [%rd3+4];
	add.f32 	%f60, %f60, %f51;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_21:
	setp.eq.s32 	%p28, %r5, 2;
	@%p28 bra 	$L__BB0_24;

	add.s32 	%r43, %r18, 2;
	setp.ge.s32 	%p30, %r43, %r21;
	or.pred  	%p31, %p21, %p30;
	@%p31 bra 	$L__BB0_24;

	ld.global.nc.f32 	%f52, [%rd3+8];
	add.f32 	%f60, %f60, %f52;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_24:
	add.s32 	%r45, %r45, 1;
	setp.lt.s32 	%p32, %r45, %r25;
	@%p32 bra 	$L__BB0_4;

$L__BB0_25:
	mad.lo.s32 	%r44, %r2, %r20, %r1;
	cvta.to.global.u64 	%rd8, %rd4;
	mul.wide.s32 	%rd9, %r44, 4;
	add.s64 	%rd10, %rd8, %rd9;
	div.rn.f32 	%f53, %f60, %f61;
	st.global.f32 	[%rd10], %f53;

$L__BB0_26:
	ret;

}

`
	resize_ptx_70 = `
.version 8.5
.target sm_70
.address_size 64

	// .globl	resize

.visible .entry resize(
	.param .u64 resize_param_0,
	.param .u32 resize_param_1,
	.param .u32 resize_param_2,
	.param .u32 resize_param_3,
	.param .u64 resize_param_4,
	.param .u32 resize_param_5,
	.param .u32 resize_param_6,
	.param .u32 resize_param_7,
	.param .u32 resize_param_8,
	.param .u32 resize_param_9,
	.param .u32 resize_param_10
)
{
	.reg .pred 	%p<33>;
	.reg .f32 	%f<80>;
	.reg .b32 	%r<49>;
	.reg .b64 	%rd<11>;


	ld.param.u64 	%rd4, [resize_param_0];
	ld.param.u32 	%r20, [resize_param_1];
	ld.param.u32 	%r26, [resize_param_2];
	ld.param.u64 	%rd5, [resize_param_4];
	ld.param.u32 	%r21, [resize_param_5];
	ld.param.u32 	%r22, [resize_param_6];
	ld.param.u32 	%r23, [resize_param_8];
	ld.param.u32 	%r24, [resize_param_9];
	ld.param.u32 	%r25, [resize_param_10];
	cvta.to.global.u64 	%rd1, %rd5;
	mov.u32 	%r27, %ntid.x;
	mov.u32 	%r28, %ctaid.x;
	mov.u32 	%r29, %tid.x;
	mad.lo.s32 	%r1, %r28, %r27, %r29;
	mov.u32 	%r30, %ntid.y;
	mov.u32 	%r31, %ctaid.y;
	mov.u32 	%r32, %tid.y;
	mad.lo.s32 	%r2, %r31, %r30, %r32;
	setp.ge.s32 	%p1, %r1, %r20;
	setp.ge.s32 	%p2, %r2, %r26;
	or.pred  	%p3, %p1, %p2;
	mov.f32 	%f60, 0f00000000;
	mov.f32 	%f61, 0f00000000;
	@%p3 bra 	$L__BB0_26;

	setp.lt.s32 	%p4, %r25, 1;
	@%p4 bra 	$L__BB0_25;

	mul.lo.s32 	%r3, %r1, %r24;
	setp.lt.s32 	%p5, %r24, 1;
	@%p5 bra 	$L__BB0_25;

	add.s32 	%r4, %r24, -1;
	and.b32  	%r5, %r24, 3;
	sub.s32 	%r6, %r24, %r5;
	mul.lo.s32 	%r7, %r23, %r22;
	mul.lo.s32 	%r8, %r2, %r25;
	mov.f32 	%f61, 0f00000000;
	mov.u32 	%r33, 0;
	mov.u32 	%r45, %r33;
	mov.f32 	%f60, %f61;

$L__BB0_4:
	add.s32 	%r10, %r45, %r8;
	add.s32 	%r35, %r10, %r7;
	mul.lo.s32 	%r11, %r35, %r21;
	setp.lt.u32 	%p6, %r4, 3;
	mov.u32 	%r48, %r33;
	@%p6 bra 	$L__BB0_15;

	mov.u32 	%r48, 0;
	mov.u32 	%r47, %r6;

$L__BB0_6:
	add.s32 	%r14, %r48, %r3;
	setp.ge.s32 	%p7, %r14, %r21;
	setp.ge.s32 	%p8, %r10, %r22;
	add.s32 	%r37, %r14, %r11;
	mul.wide.s32 	%rd6, %r37, 4;
	add.s64 	%rd2, %rd1, %rd6;
	or.pred  	%p9, %p8, %p7;
	@%p9 bra 	$L__BB0_8;

	ld.global.nc.f32 	%f46, [%rd2];
	add.f32 	%f60, %f60, %f46;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_8:
	add.s32 	%r38, %r14, 1;
	setp.ge.s32 	%p10, %r38, %r21;
	or.pred  	%p12, %p8, %p10;
	@%p12 bra 	$L__BB0_10;

	ld.global.nc.f32 	%f47, [%rd2+4];
	add.f32 	%f60, %f60, %f47;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_10:
	add.s32 	%r39, %r14, 2;
	setp.ge.s32 	%p13, %r39, %r21;
	or.pred  	%p15, %p8, %p13;
	@%p15 bra 	$L__BB0_12;

	ld.global.nc.f32 	%f48, [%rd2+8];
	add.f32 	%f60, %f60, %f48;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_12:
	add.s32 	%r40, %r14, 3;
	setp.ge.s32 	%p16, %r40, %r21;
	or.pred  	%p18, %p8, %p16;
	@%p18 bra 	$L__BB0_14;

	ld.global.nc.f32 	%f49, [%rd2+12];
	add.f32 	%f60, %f60, %f49;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_14:
	add.s32 	%r48, %r48, 4;
	add.s32 	%r47, %r47, -4;
	setp.ne.s32 	%p19, %r47, 0;
	@%p19 bra 	$L__BB0_6;

$L__BB0_15:
	setp.eq.s32 	%p20, %r5, 0;
	@%p20 bra 	$L__BB0_24;

	setp.ge.s32 	%p21, %r10, %r22;
	add.s32 	%r18, %r48, %r3;
	setp.ge.s32 	%p22, %r18, %r21;
	add.s32 	%r41, %r18, %r11;
	mul.wide.s32 	%rd7, %r41, 4;
	add.s64 	%rd3, %rd1, %rd7;
	or.pred  	%p23, %p21, %p22;
	@%p23 bra 	$L__BB0_18;

	ld.global.nc.f32 	%f50, [%rd3];
	add.f32 	%f60, %f60, %f50;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_18:
	setp.eq.s32 	%p24, %r5, 1;
	@%p24 bra 	$L__BB0_24;

	add.s32 	%r42, %r18, 1;
	setp.ge.s32 	%p26, %r42, %r21;
	or.pred  	%p27, %p21, %p26;
	@%p27 bra 	$L__BB0_21;

	ld.global.nc.f32 	%f51, [%rd3+4];
	add.f32 	%f60, %f60, %f51;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_21:
	setp.eq.s32 	%p28, %r5, 2;
	@%p28 bra 	$L__BB0_24;

	add.s32 	%r43, %r18, 2;
	setp.ge.s32 	%p30, %r43, %r21;
	or.pred  	%p31, %p21, %p30;
	@%p31 bra 	$L__BB0_24;

	ld.global.nc.f32 	%f52, [%rd3+8];
	add.f32 	%f60, %f60, %f52;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_24:
	add.s32 	%r45, %r45, 1;
	setp.lt.s32 	%p32, %r45, %r25;
	@%p32 bra 	$L__BB0_4;

$L__BB0_25:
	mad.lo.s32 	%r44, %r2, %r20, %r1;
	cvta.to.global.u64 	%rd8, %rd4;
	mul.wide.s32 	%rd9, %r44, 4;
	add.s64 	%rd10, %rd8, %rd9;
	div.rn.f32 	%f53, %f60, %f61;
	st.global.f32 	[%rd10], %f53;

$L__BB0_26:
	ret;

}

`
	resize_ptx_72 = `
.version 8.5
.target sm_72
.address_size 64

	// .globl	resize

.visible .entry resize(
	.param .u64 resize_param_0,
	.param .u32 resize_param_1,
	.param .u32 resize_param_2,
	.param .u32 resize_param_3,
	.param .u64 resize_param_4,
	.param .u32 resize_param_5,
	.param .u32 resize_param_6,
	.param .u32 resize_param_7,
	.param .u32 resize_param_8,
	.param .u32 resize_param_9,
	.param .u32 resize_param_10
)
{
	.reg .pred 	%p<33>;
	.reg .f32 	%f<80>;
	.reg .b32 	%r<49>;
	.reg .b64 	%rd<11>;


	ld.param.u64 	%rd4, [resize_param_0];
	ld.param.u32 	%r20, [resize_param_1];
	ld.param.u32 	%r26, [resize_param_2];
	ld.param.u64 	%rd5, [resize_param_4];
	ld.param.u32 	%r21, [resize_param_5];
	ld.param.u32 	%r22, [resize_param_6];
	ld.param.u32 	%r23, [resize_param_8];
	ld.param.u32 	%r24, [resize_param_9];
	ld.param.u32 	%r25, [resize_param_10];
	cvta.to.global.u64 	%rd1, %rd5;
	mov.u32 	%r27, %ntid.x;
	mov.u32 	%r28, %ctaid.x;
	mov.u32 	%r29, %tid.x;
	mad.lo.s32 	%r1, %r28, %r27, %r29;
	mov.u32 	%r30, %ntid.y;
	mov.u32 	%r31, %ctaid.y;
	mov.u32 	%r32, %tid.y;
	mad.lo.s32 	%r2, %r31, %r30, %r32;
	setp.ge.s32 	%p1, %r1, %r20;
	setp.ge.s32 	%p2, %r2, %r26;
	or.pred  	%p3, %p1, %p2;
	mov.f32 	%f60, 0f00000000;
	mov.f32 	%f61, 0f00000000;
	@%p3 bra 	$L__BB0_26;

	setp.lt.s32 	%p4, %r25, 1;
	@%p4 bra 	$L__BB0_25;

	mul.lo.s32 	%r3, %r1, %r24;
	setp.lt.s32 	%p5, %r24, 1;
	@%p5 bra 	$L__BB0_25;

	add.s32 	%r4, %r24, -1;
	and.b32  	%r5, %r24, 3;
	sub.s32 	%r6, %r24, %r5;
	mul.lo.s32 	%r7, %r23, %r22;
	mul.lo.s32 	%r8, %r2, %r25;
	mov.f32 	%f61, 0f00000000;
	mov.u32 	%r33, 0;
	mov.u32 	%r45, %r33;
	mov.f32 	%f60, %f61;

$L__BB0_4:
	add.s32 	%r10, %r45, %r8;
	add.s32 	%r35, %r10, %r7;
	mul.lo.s32 	%r11, %r35, %r21;
	setp.lt.u32 	%p6, %r4, 3;
	mov.u32 	%r48, %r33;
	@%p6 bra 	$L__BB0_15;

	mov.u32 	%r48, 0;
	mov.u32 	%r47, %r6;

$L__BB0_6:
	add.s32 	%r14, %r48, %r3;
	setp.ge.s32 	%p7, %r14, %r21;
	setp.ge.s32 	%p8, %r10, %r22;
	add.s32 	%r37, %r14, %r11;
	mul.wide.s32 	%rd6, %r37, 4;
	add.s64 	%rd2, %rd1, %rd6;
	or.pred  	%p9, %p8, %p7;
	@%p9 bra 	$L__BB0_8;

	ld.global.nc.f32 	%f46, [%rd2];
	add.f32 	%f60, %f60, %f46;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_8:
	add.s32 	%r38, %r14, 1;
	setp.ge.s32 	%p10, %r38, %r21;
	or.pred  	%p12, %p8, %p10;
	@%p12 bra 	$L__BB0_10;

	ld.global.nc.f32 	%f47, [%rd2+4];
	add.f32 	%f60, %f60, %f47;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_10:
	add.s32 	%r39, %r14, 2;
	setp.ge.s32 	%p13, %r39, %r21;
	or.pred  	%p15, %p8, %p13;
	@%p15 bra 	$L__BB0_12;

	ld.global.nc.f32 	%f48, [%rd2+8];
	add.f32 	%f60, %f60, %f48;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_12:
	add.s32 	%r40, %r14, 3;
	setp.ge.s32 	%p16, %r40, %r21;
	or.pred  	%p18, %p8, %p16;
	@%p18 bra 	$L__BB0_14;

	ld.global.nc.f32 	%f49, [%rd2+12];
	add.f32 	%f60, %f60, %f49;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_14:
	add.s32 	%r48, %r48, 4;
	add.s32 	%r47, %r47, -4;
	setp.ne.s32 	%p19, %r47, 0;
	@%p19 bra 	$L__BB0_6;

$L__BB0_15:
	setp.eq.s32 	%p20, %r5, 0;
	@%p20 bra 	$L__BB0_24;

	setp.ge.s32 	%p21, %r10, %r22;
	add.s32 	%r18, %r48, %r3;
	setp.ge.s32 	%p22, %r18, %r21;
	add.s32 	%r41, %r18, %r11;
	mul.wide.s32 	%rd7, %r41, 4;
	add.s64 	%rd3, %rd1, %rd7;
	or.pred  	%p23, %p21, %p22;
	@%p23 bra 	$L__BB0_18;

	ld.global.nc.f32 	%f50, [%rd3];
	add.f32 	%f60, %f60, %f50;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_18:
	setp.eq.s32 	%p24, %r5, 1;
	@%p24 bra 	$L__BB0_24;

	add.s32 	%r42, %r18, 1;
	setp.ge.s32 	%p26, %r42, %r21;
	or.pred  	%p27, %p21, %p26;
	@%p27 bra 	$L__BB0_21;

	ld.global.nc.f32 	%f51, [%rd3+4];
	add.f32 	%f60, %f60, %f51;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_21:
	setp.eq.s32 	%p28, %r5, 2;
	@%p28 bra 	$L__BB0_24;

	add.s32 	%r43, %r18, 2;
	setp.ge.s32 	%p30, %r43, %r21;
	or.pred  	%p31, %p21, %p30;
	@%p31 bra 	$L__BB0_24;

	ld.global.nc.f32 	%f52, [%rd3+8];
	add.f32 	%f60, %f60, %f52;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_24:
	add.s32 	%r45, %r45, 1;
	setp.lt.s32 	%p32, %r45, %r25;
	@%p32 bra 	$L__BB0_4;

$L__BB0_25:
	mad.lo.s32 	%r44, %r2, %r20, %r1;
	cvta.to.global.u64 	%rd8, %rd4;
	mul.wide.s32 	%rd9, %r44, 4;
	add.s64 	%rd10, %rd8, %rd9;
	div.rn.f32 	%f53, %f60, %f61;
	st.global.f32 	[%rd10], %f53;

$L__BB0_26:
	ret;

}

`
	resize_ptx_75 = `
.version 8.5
.target sm_75
.address_size 64

	// .globl	resize

.visible .entry resize(
	.param .u64 resize_param_0,
	.param .u32 resize_param_1,
	.param .u32 resize_param_2,
	.param .u32 resize_param_3,
	.param .u64 resize_param_4,
	.param .u32 resize_param_5,
	.param .u32 resize_param_6,
	.param .u32 resize_param_7,
	.param .u32 resize_param_8,
	.param .u32 resize_param_9,
	.param .u32 resize_param_10
)
{
	.reg .pred 	%p<33>;
	.reg .f32 	%f<80>;
	.reg .b32 	%r<49>;
	.reg .b64 	%rd<11>;


	ld.param.u64 	%rd4, [resize_param_0];
	ld.param.u32 	%r20, [resize_param_1];
	ld.param.u32 	%r26, [resize_param_2];
	ld.param.u64 	%rd5, [resize_param_4];
	ld.param.u32 	%r21, [resize_param_5];
	ld.param.u32 	%r22, [resize_param_6];
	ld.param.u32 	%r23, [resize_param_8];
	ld.param.u32 	%r24, [resize_param_9];
	ld.param.u32 	%r25, [resize_param_10];
	cvta.to.global.u64 	%rd1, %rd5;
	mov.u32 	%r27, %ntid.x;
	mov.u32 	%r28, %ctaid.x;
	mov.u32 	%r29, %tid.x;
	mad.lo.s32 	%r1, %r28, %r27, %r29;
	mov.u32 	%r30, %ntid.y;
	mov.u32 	%r31, %ctaid.y;
	mov.u32 	%r32, %tid.y;
	mad.lo.s32 	%r2, %r31, %r30, %r32;
	setp.ge.s32 	%p1, %r1, %r20;
	setp.ge.s32 	%p2, %r2, %r26;
	or.pred  	%p3, %p1, %p2;
	mov.f32 	%f60, 0f00000000;
	mov.f32 	%f61, 0f00000000;
	@%p3 bra 	$L__BB0_26;

	setp.lt.s32 	%p4, %r25, 1;
	@%p4 bra 	$L__BB0_25;

	mul.lo.s32 	%r3, %r1, %r24;
	setp.lt.s32 	%p5, %r24, 1;
	@%p5 bra 	$L__BB0_25;

	add.s32 	%r4, %r24, -1;
	and.b32  	%r5, %r24, 3;
	sub.s32 	%r6, %r24, %r5;
	mul.lo.s32 	%r7, %r23, %r22;
	mul.lo.s32 	%r8, %r2, %r25;
	mov.f32 	%f61, 0f00000000;
	mov.u32 	%r33, 0;
	mov.u32 	%r45, %r33;
	mov.f32 	%f60, %f61;

$L__BB0_4:
	add.s32 	%r10, %r45, %r8;
	add.s32 	%r35, %r10, %r7;
	mul.lo.s32 	%r11, %r35, %r21;
	setp.lt.u32 	%p6, %r4, 3;
	mov.u32 	%r48, %r33;
	@%p6 bra 	$L__BB0_15;

	mov.u32 	%r48, 0;
	mov.u32 	%r47, %r6;

$L__BB0_6:
	add.s32 	%r14, %r48, %r3;
	setp.ge.s32 	%p7, %r14, %r21;
	setp.ge.s32 	%p8, %r10, %r22;
	add.s32 	%r37, %r14, %r11;
	mul.wide.s32 	%rd6, %r37, 4;
	add.s64 	%rd2, %rd1, %rd6;
	or.pred  	%p9, %p8, %p7;
	@%p9 bra 	$L__BB0_8;

	ld.global.nc.f32 	%f46, [%rd2];
	add.f32 	%f60, %f60, %f46;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_8:
	add.s32 	%r38, %r14, 1;
	setp.ge.s32 	%p10, %r38, %r21;
	or.pred  	%p12, %p8, %p10;
	@%p12 bra 	$L__BB0_10;

	ld.global.nc.f32 	%f47, [%rd2+4];
	add.f32 	%f60, %f60, %f47;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_10:
	add.s32 	%r39, %r14, 2;
	setp.ge.s32 	%p13, %r39, %r21;
	or.pred  	%p15, %p8, %p13;
	@%p15 bra 	$L__BB0_12;

	ld.global.nc.f32 	%f48, [%rd2+8];
	add.f32 	%f60, %f60, %f48;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_12:
	add.s32 	%r40, %r14, 3;
	setp.ge.s32 	%p16, %r40, %r21;
	or.pred  	%p18, %p8, %p16;
	@%p18 bra 	$L__BB0_14;

	ld.global.nc.f32 	%f49, [%rd2+12];
	add.f32 	%f60, %f60, %f49;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_14:
	add.s32 	%r48, %r48, 4;
	add.s32 	%r47, %r47, -4;
	setp.ne.s32 	%p19, %r47, 0;
	@%p19 bra 	$L__BB0_6;

$L__BB0_15:
	setp.eq.s32 	%p20, %r5, 0;
	@%p20 bra 	$L__BB0_24;

	setp.ge.s32 	%p21, %r10, %r22;
	add.s32 	%r18, %r48, %r3;
	setp.ge.s32 	%p22, %r18, %r21;
	add.s32 	%r41, %r18, %r11;
	mul.wide.s32 	%rd7, %r41, 4;
	add.s64 	%rd3, %rd1, %rd7;
	or.pred  	%p23, %p21, %p22;
	@%p23 bra 	$L__BB0_18;

	ld.global.nc.f32 	%f50, [%rd3];
	add.f32 	%f60, %f60, %f50;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_18:
	setp.eq.s32 	%p24, %r5, 1;
	@%p24 bra 	$L__BB0_24;

	add.s32 	%r42, %r18, 1;
	setp.ge.s32 	%p26, %r42, %r21;
	or.pred  	%p27, %p21, %p26;
	@%p27 bra 	$L__BB0_21;

	ld.global.nc.f32 	%f51, [%rd3+4];
	add.f32 	%f60, %f60, %f51;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_21:
	setp.eq.s32 	%p28, %r5, 2;
	@%p28 bra 	$L__BB0_24;

	add.s32 	%r43, %r18, 2;
	setp.ge.s32 	%p30, %r43, %r21;
	or.pred  	%p31, %p21, %p30;
	@%p31 bra 	$L__BB0_24;

	ld.global.nc.f32 	%f52, [%rd3+8];
	add.f32 	%f60, %f60, %f52;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_24:
	add.s32 	%r45, %r45, 1;
	setp.lt.s32 	%p32, %r45, %r25;
	@%p32 bra 	$L__BB0_4;

$L__BB0_25:
	mad.lo.s32 	%r44, %r2, %r20, %r1;
	cvta.to.global.u64 	%rd8, %rd4;
	mul.wide.s32 	%rd9, %r44, 4;
	add.s64 	%rd10, %rd8, %rd9;
	div.rn.f32 	%f53, %f60, %f61;
	st.global.f32 	[%rd10], %f53;

$L__BB0_26:
	ret;

}

`
	resize_ptx_80 = `
.version 8.5
.target sm_80
.address_size 64

	// .globl	resize

.visible .entry resize(
	.param .u64 resize_param_0,
	.param .u32 resize_param_1,
	.param .u32 resize_param_2,
	.param .u32 resize_param_3,
	.param .u64 resize_param_4,
	.param .u32 resize_param_5,
	.param .u32 resize_param_6,
	.param .u32 resize_param_7,
	.param .u32 resize_param_8,
	.param .u32 resize_param_9,
	.param .u32 resize_param_10
)
{
	.reg .pred 	%p<33>;
	.reg .f32 	%f<80>;
	.reg .b32 	%r<49>;
	.reg .b64 	%rd<11>;


	ld.param.u64 	%rd4, [resize_param_0];
	ld.param.u32 	%r20, [resize_param_1];
	ld.param.u32 	%r26, [resize_param_2];
	ld.param.u64 	%rd5, [resize_param_4];
	ld.param.u32 	%r21, [resize_param_5];
	ld.param.u32 	%r22, [resize_param_6];
	ld.param.u32 	%r23, [resize_param_8];
	ld.param.u32 	%r24, [resize_param_9];
	ld.param.u32 	%r25, [resize_param_10];
	cvta.to.global.u64 	%rd1, %rd5;
	mov.u32 	%r27, %ntid.x;
	mov.u32 	%r28, %ctaid.x;
	mov.u32 	%r29, %tid.x;
	mad.lo.s32 	%r1, %r28, %r27, %r29;
	mov.u32 	%r30, %ntid.y;
	mov.u32 	%r31, %ctaid.y;
	mov.u32 	%r32, %tid.y;
	mad.lo.s32 	%r2, %r31, %r30, %r32;
	setp.ge.s32 	%p1, %r1, %r20;
	setp.ge.s32 	%p2, %r2, %r26;
	or.pred  	%p3, %p1, %p2;
	mov.f32 	%f60, 0f00000000;
	mov.f32 	%f61, 0f00000000;
	@%p3 bra 	$L__BB0_26;

	setp.lt.s32 	%p4, %r25, 1;
	@%p4 bra 	$L__BB0_25;

	mul.lo.s32 	%r3, %r1, %r24;
	setp.lt.s32 	%p5, %r24, 1;
	@%p5 bra 	$L__BB0_25;

	add.s32 	%r4, %r24, -1;
	and.b32  	%r5, %r24, 3;
	sub.s32 	%r6, %r24, %r5;
	mul.lo.s32 	%r7, %r23, %r22;
	mul.lo.s32 	%r8, %r2, %r25;
	mov.f32 	%f61, 0f00000000;
	mov.u32 	%r33, 0;
	mov.u32 	%r45, %r33;
	mov.f32 	%f60, %f61;

$L__BB0_4:
	add.s32 	%r10, %r45, %r8;
	add.s32 	%r35, %r10, %r7;
	mul.lo.s32 	%r11, %r35, %r21;
	setp.lt.u32 	%p6, %r4, 3;
	mov.u32 	%r48, %r33;
	@%p6 bra 	$L__BB0_15;

	mov.u32 	%r48, 0;
	mov.u32 	%r47, %r6;

$L__BB0_6:
	add.s32 	%r14, %r48, %r3;
	setp.ge.s32 	%p7, %r14, %r21;
	setp.ge.s32 	%p8, %r10, %r22;
	add.s32 	%r37, %r14, %r11;
	mul.wide.s32 	%rd6, %r37, 4;
	add.s64 	%rd2, %rd1, %rd6;
	or.pred  	%p9, %p8, %p7;
	@%p9 bra 	$L__BB0_8;

	ld.global.nc.f32 	%f46, [%rd2];
	add.f32 	%f60, %f60, %f46;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_8:
	add.s32 	%r38, %r14, 1;
	setp.ge.s32 	%p10, %r38, %r21;
	or.pred  	%p12, %p8, %p10;
	@%p12 bra 	$L__BB0_10;

	ld.global.nc.f32 	%f47, [%rd2+4];
	add.f32 	%f60, %f60, %f47;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_10:
	add.s32 	%r39, %r14, 2;
	setp.ge.s32 	%p13, %r39, %r21;
	or.pred  	%p15, %p8, %p13;
	@%p15 bra 	$L__BB0_12;

	ld.global.nc.f32 	%f48, [%rd2+8];
	add.f32 	%f60, %f60, %f48;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_12:
	add.s32 	%r40, %r14, 3;
	setp.ge.s32 	%p16, %r40, %r21;
	or.pred  	%p18, %p8, %p16;
	@%p18 bra 	$L__BB0_14;

	ld.global.nc.f32 	%f49, [%rd2+12];
	add.f32 	%f60, %f60, %f49;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_14:
	add.s32 	%r48, %r48, 4;
	add.s32 	%r47, %r47, -4;
	setp.ne.s32 	%p19, %r47, 0;
	@%p19 bra 	$L__BB0_6;

$L__BB0_15:
	setp.eq.s32 	%p20, %r5, 0;
	@%p20 bra 	$L__BB0_24;

	setp.ge.s32 	%p21, %r10, %r22;
	add.s32 	%r18, %r48, %r3;
	setp.ge.s32 	%p22, %r18, %r21;
	add.s32 	%r41, %r18, %r11;
	mul.wide.s32 	%rd7, %r41, 4;
	add.s64 	%rd3, %rd1, %rd7;
	or.pred  	%p23, %p21, %p22;
	@%p23 bra 	$L__BB0_18;

	ld.global.nc.f32 	%f50, [%rd3];
	add.f32 	%f60, %f60, %f50;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_18:
	setp.eq.s32 	%p24, %r5, 1;
	@%p24 bra 	$L__BB0_24;

	add.s32 	%r42, %r18, 1;
	setp.ge.s32 	%p26, %r42, %r21;
	or.pred  	%p27, %p21, %p26;
	@%p27 bra 	$L__BB0_21;

	ld.global.nc.f32 	%f51, [%rd3+4];
	add.f32 	%f60, %f60, %f51;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_21:
	setp.eq.s32 	%p28, %r5, 2;
	@%p28 bra 	$L__BB0_24;

	add.s32 	%r43, %r18, 2;
	setp.ge.s32 	%p30, %r43, %r21;
	or.pred  	%p31, %p21, %p30;
	@%p31 bra 	$L__BB0_24;

	ld.global.nc.f32 	%f52, [%rd3+8];
	add.f32 	%f60, %f60, %f52;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_24:
	add.s32 	%r45, %r45, 1;
	setp.lt.s32 	%p32, %r45, %r25;
	@%p32 bra 	$L__BB0_4;

$L__BB0_25:
	mad.lo.s32 	%r44, %r2, %r20, %r1;
	cvta.to.global.u64 	%rd8, %rd4;
	mul.wide.s32 	%rd9, %r44, 4;
	add.s64 	%rd10, %rd8, %rd9;
	div.rn.f32 	%f53, %f60, %f61;
	st.global.f32 	[%rd10], %f53;

$L__BB0_26:
	ret;

}

`
	resize_ptx_86 = `
.version 8.5
.target sm_86
.address_size 64

	// .globl	resize

.visible .entry resize(
	.param .u64 resize_param_0,
	.param .u32 resize_param_1,
	.param .u32 resize_param_2,
	.param .u32 resize_param_3,
	.param .u64 resize_param_4,
	.param .u32 resize_param_5,
	.param .u32 resize_param_6,
	.param .u32 resize_param_7,
	.param .u32 resize_param_8,
	.param .u32 resize_param_9,
	.param .u32 resize_param_10
)
{
	.reg .pred 	%p<33>;
	.reg .f32 	%f<80>;
	.reg .b32 	%r<49>;
	.reg .b64 	%rd<11>;


	ld.param.u64 	%rd4, [resize_param_0];
	ld.param.u32 	%r20, [resize_param_1];
	ld.param.u32 	%r26, [resize_param_2];
	ld.param.u64 	%rd5, [resize_param_4];
	ld.param.u32 	%r21, [resize_param_5];
	ld.param.u32 	%r22, [resize_param_6];
	ld.param.u32 	%r23, [resize_param_8];
	ld.param.u32 	%r24, [resize_param_9];
	ld.param.u32 	%r25, [resize_param_10];
	cvta.to.global.u64 	%rd1, %rd5;
	mov.u32 	%r27, %ntid.x;
	mov.u32 	%r28, %ctaid.x;
	mov.u32 	%r29, %tid.x;
	mad.lo.s32 	%r1, %r28, %r27, %r29;
	mov.u32 	%r30, %ntid.y;
	mov.u32 	%r31, %ctaid.y;
	mov.u32 	%r32, %tid.y;
	mad.lo.s32 	%r2, %r31, %r30, %r32;
	setp.ge.s32 	%p1, %r1, %r20;
	setp.ge.s32 	%p2, %r2, %r26;
	or.pred  	%p3, %p1, %p2;
	mov.f32 	%f60, 0f00000000;
	mov.f32 	%f61, 0f00000000;
	@%p3 bra 	$L__BB0_26;

	setp.lt.s32 	%p4, %r25, 1;
	@%p4 bra 	$L__BB0_25;

	mul.lo.s32 	%r3, %r1, %r24;
	setp.lt.s32 	%p5, %r24, 1;
	@%p5 bra 	$L__BB0_25;

	add.s32 	%r4, %r24, -1;
	and.b32  	%r5, %r24, 3;
	sub.s32 	%r6, %r24, %r5;
	mul.lo.s32 	%r7, %r23, %r22;
	mul.lo.s32 	%r8, %r2, %r25;
	mov.f32 	%f61, 0f00000000;
	mov.u32 	%r33, 0;
	mov.u32 	%r45, %r33;
	mov.f32 	%f60, %f61;

$L__BB0_4:
	add.s32 	%r10, %r45, %r8;
	add.s32 	%r35, %r10, %r7;
	mul.lo.s32 	%r11, %r35, %r21;
	setp.lt.u32 	%p6, %r4, 3;
	mov.u32 	%r48, %r33;
	@%p6 bra 	$L__BB0_15;

	mov.u32 	%r48, 0;
	mov.u32 	%r47, %r6;

$L__BB0_6:
	add.s32 	%r14, %r48, %r3;
	setp.ge.s32 	%p7, %r14, %r21;
	setp.ge.s32 	%p8, %r10, %r22;
	add.s32 	%r37, %r14, %r11;
	mul.wide.s32 	%rd6, %r37, 4;
	add.s64 	%rd2, %rd1, %rd6;
	or.pred  	%p9, %p8, %p7;
	@%p9 bra 	$L__BB0_8;

	ld.global.nc.f32 	%f46, [%rd2];
	add.f32 	%f60, %f60, %f46;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_8:
	add.s32 	%r38, %r14, 1;
	setp.ge.s32 	%p10, %r38, %r21;
	or.pred  	%p12, %p8, %p10;
	@%p12 bra 	$L__BB0_10;

	ld.global.nc.f32 	%f47, [%rd2+4];
	add.f32 	%f60, %f60, %f47;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_10:
	add.s32 	%r39, %r14, 2;
	setp.ge.s32 	%p13, %r39, %r21;
	or.pred  	%p15, %p8, %p13;
	@%p15 bra 	$L__BB0_12;

	ld.global.nc.f32 	%f48, [%rd2+8];
	add.f32 	%f60, %f60, %f48;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_12:
	add.s32 	%r40, %r14, 3;
	setp.ge.s32 	%p16, %r40, %r21;
	or.pred  	%p18, %p8, %p16;
	@%p18 bra 	$L__BB0_14;

	ld.global.nc.f32 	%f49, [%rd2+12];
	add.f32 	%f60, %f60, %f49;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_14:
	add.s32 	%r48, %r48, 4;
	add.s32 	%r47, %r47, -4;
	setp.ne.s32 	%p19, %r47, 0;
	@%p19 bra 	$L__BB0_6;

$L__BB0_15:
	setp.eq.s32 	%p20, %r5, 0;
	@%p20 bra 	$L__BB0_24;

	setp.ge.s32 	%p21, %r10, %r22;
	add.s32 	%r18, %r48, %r3;
	setp.ge.s32 	%p22, %r18, %r21;
	add.s32 	%r41, %r18, %r11;
	mul.wide.s32 	%rd7, %r41, 4;
	add.s64 	%rd3, %rd1, %rd7;
	or.pred  	%p23, %p21, %p22;
	@%p23 bra 	$L__BB0_18;

	ld.global.nc.f32 	%f50, [%rd3];
	add.f32 	%f60, %f60, %f50;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_18:
	setp.eq.s32 	%p24, %r5, 1;
	@%p24 bra 	$L__BB0_24;

	add.s32 	%r42, %r18, 1;
	setp.ge.s32 	%p26, %r42, %r21;
	or.pred  	%p27, %p21, %p26;
	@%p27 bra 	$L__BB0_21;

	ld.global.nc.f32 	%f51, [%rd3+4];
	add.f32 	%f60, %f60, %f51;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_21:
	setp.eq.s32 	%p28, %r5, 2;
	@%p28 bra 	$L__BB0_24;

	add.s32 	%r43, %r18, 2;
	setp.ge.s32 	%p30, %r43, %r21;
	or.pred  	%p31, %p21, %p30;
	@%p31 bra 	$L__BB0_24;

	ld.global.nc.f32 	%f52, [%rd3+8];
	add.f32 	%f60, %f60, %f52;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_24:
	add.s32 	%r45, %r45, 1;
	setp.lt.s32 	%p32, %r45, %r25;
	@%p32 bra 	$L__BB0_4;

$L__BB0_25:
	mad.lo.s32 	%r44, %r2, %r20, %r1;
	cvta.to.global.u64 	%rd8, %rd4;
	mul.wide.s32 	%rd9, %r44, 4;
	add.s64 	%rd10, %rd8, %rd9;
	div.rn.f32 	%f53, %f60, %f61;
	st.global.f32 	[%rd10], %f53;

$L__BB0_26:
	ret;

}

`
	resize_ptx_87 = `
.version 8.5
.target sm_87
.address_size 64

	// .globl	resize

.visible .entry resize(
	.param .u64 resize_param_0,
	.param .u32 resize_param_1,
	.param .u32 resize_param_2,
	.param .u32 resize_param_3,
	.param .u64 resize_param_4,
	.param .u32 resize_param_5,
	.param .u32 resize_param_6,
	.param .u32 resize_param_7,
	.param .u32 resize_param_8,
	.param .u32 resize_param_9,
	.param .u32 resize_param_10
)
{
	.reg .pred 	%p<33>;
	.reg .f32 	%f<80>;
	.reg .b32 	%r<49>;
	.reg .b64 	%rd<11>;


	ld.param.u64 	%rd4, [resize_param_0];
	ld.param.u32 	%r20, [resize_param_1];
	ld.param.u32 	%r26, [resize_param_2];
	ld.param.u64 	%rd5, [resize_param_4];
	ld.param.u32 	%r21, [resize_param_5];
	ld.param.u32 	%r22, [resize_param_6];
	ld.param.u32 	%r23, [resize_param_8];
	ld.param.u32 	%r24, [resize_param_9];
	ld.param.u32 	%r25, [resize_param_10];
	cvta.to.global.u64 	%rd1, %rd5;
	mov.u32 	%r27, %ntid.x;
	mov.u32 	%r28, %ctaid.x;
	mov.u32 	%r29, %tid.x;
	mad.lo.s32 	%r1, %r28, %r27, %r29;
	mov.u32 	%r30, %ntid.y;
	mov.u32 	%r31, %ctaid.y;
	mov.u32 	%r32, %tid.y;
	mad.lo.s32 	%r2, %r31, %r30, %r32;
	setp.ge.s32 	%p1, %r1, %r20;
	setp.ge.s32 	%p2, %r2, %r26;
	or.pred  	%p3, %p1, %p2;
	mov.f32 	%f60, 0f00000000;
	mov.f32 	%f61, 0f00000000;
	@%p3 bra 	$L__BB0_26;

	setp.lt.s32 	%p4, %r25, 1;
	@%p4 bra 	$L__BB0_25;

	mul.lo.s32 	%r3, %r1, %r24;
	setp.lt.s32 	%p5, %r24, 1;
	@%p5 bra 	$L__BB0_25;

	add.s32 	%r4, %r24, -1;
	and.b32  	%r5, %r24, 3;
	sub.s32 	%r6, %r24, %r5;
	mul.lo.s32 	%r7, %r23, %r22;
	mul.lo.s32 	%r8, %r2, %r25;
	mov.f32 	%f61, 0f00000000;
	mov.u32 	%r33, 0;
	mov.u32 	%r45, %r33;
	mov.f32 	%f60, %f61;

$L__BB0_4:
	add.s32 	%r10, %r45, %r8;
	add.s32 	%r35, %r10, %r7;
	mul.lo.s32 	%r11, %r35, %r21;
	setp.lt.u32 	%p6, %r4, 3;
	mov.u32 	%r48, %r33;
	@%p6 bra 	$L__BB0_15;

	mov.u32 	%r48, 0;
	mov.u32 	%r47, %r6;

$L__BB0_6:
	add.s32 	%r14, %r48, %r3;
	setp.ge.s32 	%p7, %r14, %r21;
	setp.ge.s32 	%p8, %r10, %r22;
	add.s32 	%r37, %r14, %r11;
	mul.wide.s32 	%rd6, %r37, 4;
	add.s64 	%rd2, %rd1, %rd6;
	or.pred  	%p9, %p8, %p7;
	@%p9 bra 	$L__BB0_8;

	ld.global.nc.f32 	%f46, [%rd2];
	add.f32 	%f60, %f60, %f46;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_8:
	add.s32 	%r38, %r14, 1;
	setp.ge.s32 	%p10, %r38, %r21;
	or.pred  	%p12, %p8, %p10;
	@%p12 bra 	$L__BB0_10;

	ld.global.nc.f32 	%f47, [%rd2+4];
	add.f32 	%f60, %f60, %f47;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_10:
	add.s32 	%r39, %r14, 2;
	setp.ge.s32 	%p13, %r39, %r21;
	or.pred  	%p15, %p8, %p13;
	@%p15 bra 	$L__BB0_12;

	ld.global.nc.f32 	%f48, [%rd2+8];
	add.f32 	%f60, %f60, %f48;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_12:
	add.s32 	%r40, %r14, 3;
	setp.ge.s32 	%p16, %r40, %r21;
	or.pred  	%p18, %p8, %p16;
	@%p18 bra 	$L__BB0_14;

	ld.global.nc.f32 	%f49, [%rd2+12];
	add.f32 	%f60, %f60, %f49;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_14:
	add.s32 	%r48, %r48, 4;
	add.s32 	%r47, %r47, -4;
	setp.ne.s32 	%p19, %r47, 0;
	@%p19 bra 	$L__BB0_6;

$L__BB0_15:
	setp.eq.s32 	%p20, %r5, 0;
	@%p20 bra 	$L__BB0_24;

	setp.ge.s32 	%p21, %r10, %r22;
	add.s32 	%r18, %r48, %r3;
	setp.ge.s32 	%p22, %r18, %r21;
	add.s32 	%r41, %r18, %r11;
	mul.wide.s32 	%rd7, %r41, 4;
	add.s64 	%rd3, %rd1, %rd7;
	or.pred  	%p23, %p21, %p22;
	@%p23 bra 	$L__BB0_18;

	ld.global.nc.f32 	%f50, [%rd3];
	add.f32 	%f60, %f60, %f50;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_18:
	setp.eq.s32 	%p24, %r5, 1;
	@%p24 bra 	$L__BB0_24;

	add.s32 	%r42, %r18, 1;
	setp.ge.s32 	%p26, %r42, %r21;
	or.pred  	%p27, %p21, %p26;
	@%p27 bra 	$L__BB0_21;

	ld.global.nc.f32 	%f51, [%rd3+4];
	add.f32 	%f60, %f60, %f51;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_21:
	setp.eq.s32 	%p28, %r5, 2;
	@%p28 bra 	$L__BB0_24;

	add.s32 	%r43, %r18, 2;
	setp.ge.s32 	%p30, %r43, %r21;
	or.pred  	%p31, %p21, %p30;
	@%p31 bra 	$L__BB0_24;

	ld.global.nc.f32 	%f52, [%rd3+8];
	add.f32 	%f60, %f60, %f52;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_24:
	add.s32 	%r45, %r45, 1;
	setp.lt.s32 	%p32, %r45, %r25;
	@%p32 bra 	$L__BB0_4;

$L__BB0_25:
	mad.lo.s32 	%r44, %r2, %r20, %r1;
	cvta.to.global.u64 	%rd8, %rd4;
	mul.wide.s32 	%rd9, %r44, 4;
	add.s64 	%rd10, %rd8, %rd9;
	div.rn.f32 	%f53, %f60, %f61;
	st.global.f32 	[%rd10], %f53;

$L__BB0_26:
	ret;

}

`
	resize_ptx_89 = `
.version 8.5
.target sm_89
.address_size 64

	// .globl	resize

.visible .entry resize(
	.param .u64 resize_param_0,
	.param .u32 resize_param_1,
	.param .u32 resize_param_2,
	.param .u32 resize_param_3,
	.param .u64 resize_param_4,
	.param .u32 resize_param_5,
	.param .u32 resize_param_6,
	.param .u32 resize_param_7,
	.param .u32 resize_param_8,
	.param .u32 resize_param_9,
	.param .u32 resize_param_10
)
{
	.reg .pred 	%p<33>;
	.reg .f32 	%f<80>;
	.reg .b32 	%r<49>;
	.reg .b64 	%rd<11>;


	ld.param.u64 	%rd4, [resize_param_0];
	ld.param.u32 	%r20, [resize_param_1];
	ld.param.u32 	%r26, [resize_param_2];
	ld.param.u64 	%rd5, [resize_param_4];
	ld.param.u32 	%r21, [resize_param_5];
	ld.param.u32 	%r22, [resize_param_6];
	ld.param.u32 	%r23, [resize_param_8];
	ld.param.u32 	%r24, [resize_param_9];
	ld.param.u32 	%r25, [resize_param_10];
	cvta.to.global.u64 	%rd1, %rd5;
	mov.u32 	%r27, %ntid.x;
	mov.u32 	%r28, %ctaid.x;
	mov.u32 	%r29, %tid.x;
	mad.lo.s32 	%r1, %r28, %r27, %r29;
	mov.u32 	%r30, %ntid.y;
	mov.u32 	%r31, %ctaid.y;
	mov.u32 	%r32, %tid.y;
	mad.lo.s32 	%r2, %r31, %r30, %r32;
	setp.ge.s32 	%p1, %r1, %r20;
	setp.ge.s32 	%p2, %r2, %r26;
	or.pred  	%p3, %p1, %p2;
	mov.f32 	%f60, 0f00000000;
	mov.f32 	%f61, 0f00000000;
	@%p3 bra 	$L__BB0_26;

	setp.lt.s32 	%p4, %r25, 1;
	@%p4 bra 	$L__BB0_25;

	mul.lo.s32 	%r3, %r1, %r24;
	setp.lt.s32 	%p5, %r24, 1;
	@%p5 bra 	$L__BB0_25;

	add.s32 	%r4, %r24, -1;
	and.b32  	%r5, %r24, 3;
	sub.s32 	%r6, %r24, %r5;
	mul.lo.s32 	%r7, %r23, %r22;
	mul.lo.s32 	%r8, %r2, %r25;
	mov.f32 	%f61, 0f00000000;
	mov.u32 	%r33, 0;
	mov.u32 	%r45, %r33;
	mov.f32 	%f60, %f61;

$L__BB0_4:
	add.s32 	%r10, %r45, %r8;
	add.s32 	%r35, %r10, %r7;
	mul.lo.s32 	%r11, %r35, %r21;
	setp.lt.u32 	%p6, %r4, 3;
	mov.u32 	%r48, %r33;
	@%p6 bra 	$L__BB0_15;

	mov.u32 	%r48, 0;
	mov.u32 	%r47, %r6;

$L__BB0_6:
	add.s32 	%r14, %r48, %r3;
	setp.ge.s32 	%p7, %r14, %r21;
	setp.ge.s32 	%p8, %r10, %r22;
	add.s32 	%r37, %r14, %r11;
	mul.wide.s32 	%rd6, %r37, 4;
	add.s64 	%rd2, %rd1, %rd6;
	or.pred  	%p9, %p8, %p7;
	@%p9 bra 	$L__BB0_8;

	ld.global.nc.f32 	%f46, [%rd2];
	add.f32 	%f60, %f60, %f46;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_8:
	add.s32 	%r38, %r14, 1;
	setp.ge.s32 	%p10, %r38, %r21;
	or.pred  	%p12, %p8, %p10;
	@%p12 bra 	$L__BB0_10;

	ld.global.nc.f32 	%f47, [%rd2+4];
	add.f32 	%f60, %f60, %f47;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_10:
	add.s32 	%r39, %r14, 2;
	setp.ge.s32 	%p13, %r39, %r21;
	or.pred  	%p15, %p8, %p13;
	@%p15 bra 	$L__BB0_12;

	ld.global.nc.f32 	%f48, [%rd2+8];
	add.f32 	%f60, %f60, %f48;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_12:
	add.s32 	%r40, %r14, 3;
	setp.ge.s32 	%p16, %r40, %r21;
	or.pred  	%p18, %p8, %p16;
	@%p18 bra 	$L__BB0_14;

	ld.global.nc.f32 	%f49, [%rd2+12];
	add.f32 	%f60, %f60, %f49;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_14:
	add.s32 	%r48, %r48, 4;
	add.s32 	%r47, %r47, -4;
	setp.ne.s32 	%p19, %r47, 0;
	@%p19 bra 	$L__BB0_6;

$L__BB0_15:
	setp.eq.s32 	%p20, %r5, 0;
	@%p20 bra 	$L__BB0_24;

	setp.ge.s32 	%p21, %r10, %r22;
	add.s32 	%r18, %r48, %r3;
	setp.ge.s32 	%p22, %r18, %r21;
	add.s32 	%r41, %r18, %r11;
	mul.wide.s32 	%rd7, %r41, 4;
	add.s64 	%rd3, %rd1, %rd7;
	or.pred  	%p23, %p21, %p22;
	@%p23 bra 	$L__BB0_18;

	ld.global.nc.f32 	%f50, [%rd3];
	add.f32 	%f60, %f60, %f50;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_18:
	setp.eq.s32 	%p24, %r5, 1;
	@%p24 bra 	$L__BB0_24;

	add.s32 	%r42, %r18, 1;
	setp.ge.s32 	%p26, %r42, %r21;
	or.pred  	%p27, %p21, %p26;
	@%p27 bra 	$L__BB0_21;

	ld.global.nc.f32 	%f51, [%rd3+4];
	add.f32 	%f60, %f60, %f51;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_21:
	setp.eq.s32 	%p28, %r5, 2;
	@%p28 bra 	$L__BB0_24;

	add.s32 	%r43, %r18, 2;
	setp.ge.s32 	%p30, %r43, %r21;
	or.pred  	%p31, %p21, %p30;
	@%p31 bra 	$L__BB0_24;

	ld.global.nc.f32 	%f52, [%rd3+8];
	add.f32 	%f60, %f60, %f52;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_24:
	add.s32 	%r45, %r45, 1;
	setp.lt.s32 	%p32, %r45, %r25;
	@%p32 bra 	$L__BB0_4;

$L__BB0_25:
	mad.lo.s32 	%r44, %r2, %r20, %r1;
	cvta.to.global.u64 	%rd8, %rd4;
	mul.wide.s32 	%rd9, %r44, 4;
	add.s64 	%rd10, %rd8, %rd9;
	div.rn.f32 	%f53, %f60, %f61;
	st.global.f32 	[%rd10], %f53;

$L__BB0_26:
	ret;

}

`
	resize_ptx_90 = `
.version 8.5
.target sm_90
.address_size 64

	// .globl	resize

.visible .entry resize(
	.param .u64 resize_param_0,
	.param .u32 resize_param_1,
	.param .u32 resize_param_2,
	.param .u32 resize_param_3,
	.param .u64 resize_param_4,
	.param .u32 resize_param_5,
	.param .u32 resize_param_6,
	.param .u32 resize_param_7,
	.param .u32 resize_param_8,
	.param .u32 resize_param_9,
	.param .u32 resize_param_10
)
{
	.reg .pred 	%p<33>;
	.reg .f32 	%f<80>;
	.reg .b32 	%r<49>;
	.reg .b64 	%rd<11>;


	ld.param.u64 	%rd4, [resize_param_0];
	ld.param.u32 	%r20, [resize_param_1];
	ld.param.u32 	%r26, [resize_param_2];
	ld.param.u64 	%rd5, [resize_param_4];
	ld.param.u32 	%r21, [resize_param_5];
	ld.param.u32 	%r22, [resize_param_6];
	ld.param.u32 	%r23, [resize_param_8];
	ld.param.u32 	%r24, [resize_param_9];
	ld.param.u32 	%r25, [resize_param_10];
	cvta.to.global.u64 	%rd1, %rd5;
	mov.u32 	%r27, %ntid.x;
	mov.u32 	%r28, %ctaid.x;
	mov.u32 	%r29, %tid.x;
	mad.lo.s32 	%r1, %r28, %r27, %r29;
	mov.u32 	%r30, %ntid.y;
	mov.u32 	%r31, %ctaid.y;
	mov.u32 	%r32, %tid.y;
	mad.lo.s32 	%r2, %r31, %r30, %r32;
	setp.ge.s32 	%p1, %r1, %r20;
	setp.ge.s32 	%p2, %r2, %r26;
	or.pred  	%p3, %p1, %p2;
	mov.f32 	%f60, 0f00000000;
	mov.f32 	%f61, 0f00000000;
	@%p3 bra 	$L__BB0_26;

	setp.lt.s32 	%p4, %r25, 1;
	@%p4 bra 	$L__BB0_25;

	mul.lo.s32 	%r3, %r1, %r24;
	setp.lt.s32 	%p5, %r24, 1;
	@%p5 bra 	$L__BB0_25;

	add.s32 	%r4, %r24, -1;
	and.b32  	%r5, %r24, 3;
	sub.s32 	%r6, %r24, %r5;
	mul.lo.s32 	%r7, %r23, %r22;
	mul.lo.s32 	%r8, %r2, %r25;
	mov.f32 	%f61, 0f00000000;
	mov.u32 	%r33, 0;
	mov.u32 	%r45, %r33;
	mov.f32 	%f60, %f61;

$L__BB0_4:
	add.s32 	%r10, %r45, %r8;
	add.s32 	%r35, %r10, %r7;
	mul.lo.s32 	%r11, %r35, %r21;
	setp.lt.u32 	%p6, %r4, 3;
	mov.u32 	%r48, %r33;
	@%p6 bra 	$L__BB0_15;

	mov.u32 	%r48, 0;
	mov.u32 	%r47, %r6;

$L__BB0_6:
	add.s32 	%r14, %r48, %r3;
	setp.ge.s32 	%p7, %r14, %r21;
	setp.ge.s32 	%p8, %r10, %r22;
	add.s32 	%r37, %r14, %r11;
	mul.wide.s32 	%rd6, %r37, 4;
	add.s64 	%rd2, %rd1, %rd6;
	or.pred  	%p9, %p8, %p7;
	@%p9 bra 	$L__BB0_8;

	ld.global.nc.f32 	%f46, [%rd2];
	add.f32 	%f60, %f60, %f46;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_8:
	add.s32 	%r38, %r14, 1;
	setp.ge.s32 	%p10, %r38, %r21;
	or.pred  	%p12, %p8, %p10;
	@%p12 bra 	$L__BB0_10;

	ld.global.nc.f32 	%f47, [%rd2+4];
	add.f32 	%f60, %f60, %f47;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_10:
	add.s32 	%r39, %r14, 2;
	setp.ge.s32 	%p13, %r39, %r21;
	or.pred  	%p15, %p8, %p13;
	@%p15 bra 	$L__BB0_12;

	ld.global.nc.f32 	%f48, [%rd2+8];
	add.f32 	%f60, %f60, %f48;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_12:
	add.s32 	%r40, %r14, 3;
	setp.ge.s32 	%p16, %r40, %r21;
	or.pred  	%p18, %p8, %p16;
	@%p18 bra 	$L__BB0_14;

	ld.global.nc.f32 	%f49, [%rd2+12];
	add.f32 	%f60, %f60, %f49;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_14:
	add.s32 	%r48, %r48, 4;
	add.s32 	%r47, %r47, -4;
	setp.ne.s32 	%p19, %r47, 0;
	@%p19 bra 	$L__BB0_6;

$L__BB0_15:
	setp.eq.s32 	%p20, %r5, 0;
	@%p20 bra 	$L__BB0_24;

	setp.ge.s32 	%p21, %r10, %r22;
	add.s32 	%r18, %r48, %r3;
	setp.ge.s32 	%p22, %r18, %r21;
	add.s32 	%r41, %r18, %r11;
	mul.wide.s32 	%rd7, %r41, 4;
	add.s64 	%rd3, %rd1, %rd7;
	or.pred  	%p23, %p21, %p22;
	@%p23 bra 	$L__BB0_18;

	ld.global.nc.f32 	%f50, [%rd3];
	add.f32 	%f60, %f60, %f50;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_18:
	setp.eq.s32 	%p24, %r5, 1;
	@%p24 bra 	$L__BB0_24;

	add.s32 	%r42, %r18, 1;
	setp.ge.s32 	%p26, %r42, %r21;
	or.pred  	%p27, %p21, %p26;
	@%p27 bra 	$L__BB0_21;

	ld.global.nc.f32 	%f51, [%rd3+4];
	add.f32 	%f60, %f60, %f51;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_21:
	setp.eq.s32 	%p28, %r5, 2;
	@%p28 bra 	$L__BB0_24;

	add.s32 	%r43, %r18, 2;
	setp.ge.s32 	%p30, %r43, %r21;
	or.pred  	%p31, %p21, %p30;
	@%p31 bra 	$L__BB0_24;

	ld.global.nc.f32 	%f52, [%rd3+8];
	add.f32 	%f60, %f60, %f52;
	add.f32 	%f61, %f61, 0f3F800000;

$L__BB0_24:
	add.s32 	%r45, %r45, 1;
	setp.lt.s32 	%p32, %r45, %r25;
	@%p32 bra 	$L__BB0_4;

$L__BB0_25:
	mad.lo.s32 	%r44, %r2, %r20, %r1;
	cvta.to.global.u64 	%rd8, %rd4;
	mul.wide.s32 	%rd9, %r44, 4;
	add.s64 	%rd10, %rd8, %rd9;
	div.rn.f32 	%f53, %f60, %f61;
	st.global.f32 	[%rd10], %f53;

$L__BB0_26:
	ret;

}

`
)
