/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.Request;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.CopySnapshotRequest;
import com.amazonaws.services.ec2.model.transform.CopySnapshotRequestMarshaller;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.HttpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.SimpleTimeZone;

public class PresigningAWS4Signer
extends AWS4Signer {
    private static final long MAX_EXPIRATION_TIME_IN_SECONDS = 604800L;

    public void presignRequest(Request<?> request) {
        String contentSha256;
        URI sourceEndpoint;
        CopySnapshotRequest originalRequest = (CopySnapshotRequest)request.getOriginalRequest();
        String sourceRegion = originalRequest.getSourceRegion();
        try {
            sourceEndpoint = new URI(String.format("https://ec2.%s.amazonaws.com", sourceRegion));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request<CopySnapshotRequest> requestForPresigning = new CopySnapshotRequestMarshaller().marshall(originalRequest);
        requestForPresigning.setEndpoint(sourceEndpoint);
        requestForPresigning.setHttpMethod(HttpMethodName.GET);
        if (requestForPresigning.getParameters().get("DestinationRegion") == null) {
            request.addParameter("DestinationRegion", (String)request.getParameters().get("DestinationRegion"));
        }
        this.addHostHeader(requestForPresigning);
        AWSCredentials sanitizedCredentials = this.sanitizeCredentials(originalRequest.getRequestCredentials());
        if (sanitizedCredentials instanceof AWSSessionCredentials) {
            requestForPresigning.addParameter("x-amz-security-token", ((AWSSessionCredentials)sanitizedCredentials).getSessionToken());
        }
        SimpleDateFormat dateStampFormat = new SimpleDateFormat("yyyyMMdd");
        dateStampFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        dateTimeFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        long nowMilli = new Date().getTime();
        String dateStamp = dateStampFormat.format(nowMilli);
        String timeStamp = dateTimeFormat.format(nowMilli);
        String scope = this.getScope(requestForPresigning, dateStamp, originalRequest.getSourceRegion());
        try {
            contentSha256 = this.calculateContentHash(requestForPresigning);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String signingCredentials = sanitizedCredentials.getAWSAccessKeyId() + "/" + scope;
        requestForPresigning.addParameter("X-Amz-Algorithm", "AWS4-HMAC-SHA256");
        requestForPresigning.addParameter("X-Amz-Date", timeStamp);
        requestForPresigning.addParameter("X-Amz-SignedHeaders", this.getSignedHeadersString(requestForPresigning));
        requestForPresigning.addParameter("X-Amz-Expires", Long.toString(604800L));
        requestForPresigning.addParameter("X-Amz-Credential", signingCredentials);
        HeaderSigningResult headerSigningResult = this.computeSignature(sourceRegion, scope, requestForPresigning, dateStamp, timeStamp, "AWS4-HMAC-SHA256", contentSha256, sanitizedCredentials);
        requestForPresigning.addParameter("X-Amz-Signature", BinaryUtils.toHex((byte[])headerSigningResult.getSignature()));
        request.addParameter("PresignedUrl", this.generateUrl(requestForPresigning));
    }

    protected String calculateContentHash(Request<?> request) throws UnsupportedEncodingException {
        InputStream payloadStream = this.getBinaryRequestPayloadStream(request);
        payloadStream.mark(-1);
        String contentSha256 = BinaryUtils.toHex((byte[])this.hash(payloadStream));
        try {
            payloadStream.reset();
        }
        catch (IOException e) {
            throw new AmazonClientException("Unable to reset stream after calculating AWS4 signature", (Throwable)e);
        }
        return contentSha256;
    }

    public static String appendUri(String baseUri, String path, boolean escapeDoubleSlash) {
        String resultUri = baseUri;
        if (path != null && path.length() > 0) {
            if (path.startsWith("/")) {
                if (resultUri.endsWith("/")) {
                    resultUri = resultUri.substring(0, resultUri.length() - 1);
                }
            } else if (!resultUri.endsWith("/")) {
                resultUri = resultUri + "/";
            }
            String encodedPath = HttpUtils.urlEncode((String)path, (boolean)true);
            if (escapeDoubleSlash) {
                encodedPath = encodedPath.replace("//", "/%2F");
            }
            resultUri = resultUri + encodedPath;
        } else if (!resultUri.endsWith("/")) {
            resultUri = resultUri + "/";
        }
        return resultUri;
    }

    protected void addHostHeader(Request<?> request) {
        String hostHeader = request.getEndpoint().getHost();
        if (HttpUtils.isUsingNonDefaultPort((URI)request.getEndpoint())) {
            hostHeader = hostHeader + ":" + request.getEndpoint().getPort();
        }
        request.addHeader("Host", hostHeader);
    }

    protected String getScope(Request<?> request, String dateStamp, String regionName) {
        String serviceName = "ec2";
        String scope = dateStamp + "/" + regionName + "/" + serviceName + "/" + "aws4_request";
        return scope;
    }

    protected String getSignedHeadersString(Request<?> request) {
        ArrayList sortedHeaders = new ArrayList();
        sortedHeaders.addAll(request.getHeaders().keySet());
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String header : sortedHeaders) {
            if (buffer.length() > 0) {
                buffer.append(";");
            }
            buffer.append(header.toLowerCase());
        }
        return buffer.toString();
    }

    protected HeaderSigningResult computeSignature(String regionName, String scope, Request<?> request, String dateStamp, String timeStamp, String algorithm, String contentSha256, AWSCredentials sanitizedCredentials) {
        String stringToSign = this.getStringToSign(algorithm, timeStamp, scope, this.getCanonicalRequest(request, contentSha256));
        byte[] kSecret = ("AWS4" + sanitizedCredentials.getAWSSecretKey()).getBytes();
        byte[] kDate = this.sign(dateStamp, kSecret, SigningAlgorithm.HmacSHA256);
        byte[] kRegion = this.sign(regionName, kDate, SigningAlgorithm.HmacSHA256);
        byte[] kService = this.sign("ec2", kRegion, SigningAlgorithm.HmacSHA256);
        byte[] kSigning = this.sign("aws4_request", kService, SigningAlgorithm.HmacSHA256);
        byte[] signature = this.sign(stringToSign, kSigning, SigningAlgorithm.HmacSHA256);
        return new HeaderSigningResult(timeStamp, scope, kSigning, signature);
    }

    protected String getStringToSign(String algorithm, String dateTime, String scope, String canonicalRequest) {
        String stringToSign = algorithm + "\n" + dateTime + "\n" + scope + "\n" + BinaryUtils.toHex((byte[])this.hash(canonicalRequest));
        return stringToSign;
    }

    private String generateUrl(Request<?> request) {
        URI endpoint = request.getEndpoint();
        String uri = PresigningAWS4Signer.appendUri(endpoint.toString(), request.getResourcePath(), true);
        String encodedParams = HttpUtils.encodeParameters(request);
        if (encodedParams != null) {
            uri = uri + "?" + encodedParams;
        }
        return uri;
    }

    protected String getCanonicalRequest(Request<?> request, String contentSha256) {
        String path = PresigningAWS4Signer.appendUri(request.getEndpoint().getPath(), request.getResourcePath(), false);
        String canonicalRequest = request.getHttpMethod().toString() + "\n" + this.getCanonicalizedResourcePath(path) + "\n" + this.getCanonicalizedQueryString(request) + "\n" + this.getCanonicalizedHeaderString(request) + "\n" + this.getSignedHeadersString(request) + "\n" + contentSha256;
        return canonicalRequest;
    }

    private String getCanonicalizedHeaderString(Request<?> request) {
        ArrayList sortedHeaders = new ArrayList();
        sortedHeaders.addAll(request.getHeaders().keySet());
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String header : sortedHeaders) {
            buffer.append(header.toLowerCase() + ":" + (String)request.getHeaders().get(header));
            buffer.append("\n");
        }
        return buffer.toString();
    }

    protected static class HeaderSigningResult {
        private String dateTime;
        private String scope;
        private byte[] kSigning;
        private byte[] signature;

        public HeaderSigningResult(String dateTime, String scope, byte[] kSigning, byte[] signature) {
            this.dateTime = dateTime;
            this.scope = scope;
            this.kSigning = kSigning;
            this.signature = signature;
        }

        public String getDateTime() {
            return this.dateTime;
        }

        public String getScope() {
            return this.scope;
        }

        public byte[] getKSigning() {
            byte[] kSigningCopy = new byte[this.kSigning.length];
            System.arraycopy(this.kSigning, 0, kSigningCopy, 0, this.kSigning.length);
            return kSigningCopy;
        }

        public byte[] getSignature() {
            byte[] signatureCopy = new byte[this.signature.length];
            System.arraycopy(this.signature, 0, signatureCopy, 0, this.signature.length);
            return signatureCopy;
        }
    }
}

