/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.GridConstrainer;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.gui.JLifeFormattedTextField;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.gui.plaf.palette.PaletteFormattedTextFieldUI;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.text.JavaNumberFormatter;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.prefs.PreferencesUtil;

public class ViewToolBar
extends AbstractToolBar {
    private DrawingView view;

    public ViewToolBar() {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        this.setName(resourceBundleUtil.getString(this.getID() + ".toolbar"));
        this.setDisclosureStateCount(3);
    }

    public void setView(DrawingView drawingView) {
        this.view = drawingView;
        this.prefs = PreferencesUtil.userNodeForPackage(this.getClass());
        GridConstrainer gridConstrainer = (GridConstrainer)drawingView.getVisibleConstrainer();
        gridConstrainer.setHeight(this.prefs.getDouble("view.gridSize", 8.0));
        gridConstrainer.setWidth(this.prefs.getDouble("view.gridSize", 8.0));
    }

    @Override
    protected JComponent createDisclosedComponent(int n) {
        JPanel jPanel = null;
        switch (n) {
            case 1: {
                AbstractButton abstractButton;
                jPanel = new JPanel();
                jPanel.setOpaque(false);
                jPanel.setBorder(new EmptyBorder(5, 5, 5, 8));
                if (this.editor == null) break;
                ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout gridBagLayout = new GridBagLayout();
                jPanel.setLayout(gridBagLayout);
                AbstractButton abstractButton2 = abstractButton = ButtonFactory.createToggleGridButton(this.view);
                abstractButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(abstractButton));
                resourceBundleUtil.configureToolBarButton(abstractButton, "alignGrid");
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = 23;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                jPanel.add((Component)abstractButton, gridBagConstraints);
                abstractButton = ButtonFactory.createZoomButton(this.view);
                abstractButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(abstractButton));
                resourceBundleUtil.configureToolBarButton(abstractButton, "view.zoomFactor");
                abstractButton.setText("100 %");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 23;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.weightx = 1.0;
                abstractButton.setPreferredSize(new Dimension(abstractButton.getPreferredSize().width, abstractButton2.getPreferredSize().height));
                jPanel.add((Component)abstractButton, gridBagConstraints);
                break;
            }
            case 2: {
                jPanel = new JPanel();
                jPanel.setOpaque(false);
                jPanel.setBorder(new EmptyBorder(5, 5, 5, 8));
                if (this.editor == null) break;
                ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout gridBagLayout = new GridBagLayout();
                jPanel.setLayout(gridBagLayout);
                JLifeFormattedTextField jLifeFormattedTextField = new JLifeFormattedTextField();
                jLifeFormattedTextField.setColumns(3);
                jLifeFormattedTextField.setToolTipText(resourceBundleUtil.getString("view.gridSize.toolTipText"));
                jLifeFormattedTextField.setHorizontalAlignment(4);
                jLifeFormattedTextField.putClientProperty("Palette.Component.segmentPosition", "first");
                jLifeFormattedTextField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(jLifeFormattedTextField));
                jLifeFormattedTextField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 1000.0, 1.0, true, false));
                jLifeFormattedTextField.setHorizontalAlignment(10);
                final GridConstrainer gridConstrainer = (GridConstrainer)this.view.getVisibleConstrainer();
                jLifeFormattedTextField.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getPropertyName().equals("value") && propertyChangeEvent.getNewValue() != null) {
                            gridConstrainer.setWidth((Double)propertyChangeEvent.getNewValue());
                            gridConstrainer.setHeight((Double)propertyChangeEvent.getNewValue());
                            ViewToolBar.this.prefs = PreferencesUtil.userNodeForPackage(this.getClass());
                            try {
                                ViewToolBar.this.prefs.putDouble("view.gridSize", (Double)propertyChangeEvent.getNewValue());
                            }
                            catch (IllegalStateException illegalStateException) {
                                // empty catch block
                            }
                            ViewToolBar.this.view.getComponent().repaint();
                        }
                    }
                });
                jLifeFormattedTextField.setValue(gridConstrainer.getHeight());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagConstraints.anchor = 23;
                jPanel.add((Component)jLifeFormattedTextField, gridBagConstraints);
                AbstractButton abstractButton = ButtonFactory.createToggleGridButton(this.view);
                abstractButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(abstractButton));
                resourceBundleUtil.configureToolBarButton(abstractButton, "alignGrid");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = 23;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                jPanel.add((Component)abstractButton, gridBagConstraints);
                final JLifeFormattedTextField jLifeFormattedTextField2 = new JLifeFormattedTextField();
                jLifeFormattedTextField2.setColumns(3);
                jLifeFormattedTextField2.setToolTipText(resourceBundleUtil.getString("view.zoomFactor.toolTipText"));
                jLifeFormattedTextField2.setHorizontalAlignment(4);
                jLifeFormattedTextField2.putClientProperty("Palette.Component.segmentPosition", "first");
                jLifeFormattedTextField2.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(jLifeFormattedTextField2));
                jLifeFormattedTextField2.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.01, 50.0, 100.0, true, false));
                jLifeFormattedTextField2.setHorizontalAlignment(10);
                jLifeFormattedTextField2.setValue(this.view.getScaleFactor());
                jLifeFormattedTextField2.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getPropertyName().equals("value") && propertyChangeEvent.getNewValue() != null) {
                            ViewToolBar.this.view.setScaleFactor((Double)propertyChangeEvent.getNewValue());
                        }
                    }
                });
                this.view.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getPropertyName() == "scaleFactor" && propertyChangeEvent.getNewValue() != null) {
                            jLifeFormattedTextField2.setValue((Double)propertyChangeEvent.getNewValue());
                        }
                    }
                });
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                gridBagConstraints.anchor = 23;
                jPanel.add((Component)jLifeFormattedTextField2, gridBagConstraints);
                abstractButton = ButtonFactory.createZoomButton(this.view);
                abstractButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(abstractButton));
                resourceBundleUtil.configureToolBarButton(abstractButton, "view.zoomFactor");
                abstractButton.setText("100 %");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 23;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                gridBagConstraints.weighty = 1.0;
                abstractButton.setPreferredSize(new Dimension(abstractButton.getPreferredSize().width, jLifeFormattedTextField2.getPreferredSize().height));
                jPanel.add((Component)abstractButton, gridBagConstraints);
            }
        }
        return jPanel;
    }

    @Override
    protected String getID() {
        return "view";
    }

    private void initComponents() {
        this.setOpaque(false);
    }
}

