package devtestlabs

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// CostThresholdStatus enumerates the values for cost threshold status.
type CostThresholdStatus string

const (
	// Disabled specifies the disabled state for cost threshold status.
	Disabled CostThresholdStatus = "Disabled"
	// Enabled specifies the enabled state for cost threshold status.
	Enabled CostThresholdStatus = "Enabled"
)

// CostType enumerates the values for cost type.
type CostType string

const (
	// Projected specifies the projected state for cost type.
	Projected CostType = "Projected"
	// Reported specifies the reported state for cost type.
	Reported CostType = "Reported"
	// Unavailable specifies the unavailable state for cost type.
	Unavailable CostType = "Unavailable"
)

// CustomImageOsType enumerates the values for custom image os type.
type CustomImageOsType string

const (
	// Linux specifies the linux state for custom image os type.
	Linux CustomImageOsType = "Linux"
	// None specifies the none state for custom image os type.
	None CustomImageOsType = "None"
	// Windows specifies the windows state for custom image os type.
	Windows CustomImageOsType = "Windows"
)

// EnableStatus enumerates the values for enable status.
type EnableStatus string

const (
	// EnableStatusDisabled specifies the enable status disabled state for
	// enable status.
	EnableStatusDisabled EnableStatus = "Disabled"
	// EnableStatusEnabled specifies the enable status enabled state for enable
	// status.
	EnableStatusEnabled EnableStatus = "Enabled"
)

// FileUploadOptions enumerates the values for file upload options.
type FileUploadOptions string

const (
	// FileUploadOptionsNone specifies the file upload options none state for
	// file upload options.
	FileUploadOptionsNone FileUploadOptions = "None"
	// FileUploadOptionsUploadFilesAndGenerateSasTokens specifies the file
	// upload options upload files and generate sas tokens state for file
	// upload options.
	FileUploadOptionsUploadFilesAndGenerateSasTokens FileUploadOptions = "UploadFilesAndGenerateSasTokens"
)

// HostCachingOptions enumerates the values for host caching options.
type HostCachingOptions string

const (
	// HostCachingOptionsNone specifies the host caching options none state for
	// host caching options.
	HostCachingOptionsNone HostCachingOptions = "None"
	// HostCachingOptionsReadOnly specifies the host caching options read only
	// state for host caching options.
	HostCachingOptionsReadOnly HostCachingOptions = "ReadOnly"
	// HostCachingOptionsReadWrite specifies the host caching options read
	// write state for host caching options.
	HostCachingOptionsReadWrite HostCachingOptions = "ReadWrite"
)

// LinuxOsState enumerates the values for linux os state.
type LinuxOsState string

const (
	// DeprovisionApplied specifies the deprovision applied state for linux os
	// state.
	DeprovisionApplied LinuxOsState = "DeprovisionApplied"
	// DeprovisionRequested specifies the deprovision requested state for linux
	// os state.
	DeprovisionRequested LinuxOsState = "DeprovisionRequested"
	// NonDeprovisioned specifies the non deprovisioned state for linux os
	// state.
	NonDeprovisioned LinuxOsState = "NonDeprovisioned"
)

// NotificationChannelEventType enumerates the values for notification channel
// event type.
type NotificationChannelEventType string

const (
	// AutoShutdown specifies the auto shutdown state for notification channel
	// event type.
	AutoShutdown NotificationChannelEventType = "AutoShutdown"
	// Cost specifies the cost state for notification channel event type.
	Cost NotificationChannelEventType = "Cost"
)

// NotificationStatus enumerates the values for notification status.
type NotificationStatus string

const (
	// NotificationStatusDisabled specifies the notification status disabled
	// state for notification status.
	NotificationStatusDisabled NotificationStatus = "Disabled"
	// NotificationStatusEnabled specifies the notification status enabled
	// state for notification status.
	NotificationStatusEnabled NotificationStatus = "Enabled"
)

// PolicyEvaluatorType enumerates the values for policy evaluator type.
type PolicyEvaluatorType string

const (
	// AllowedValuesPolicy specifies the allowed values policy state for policy
	// evaluator type.
	AllowedValuesPolicy PolicyEvaluatorType = "AllowedValuesPolicy"
	// MaxValuePolicy specifies the max value policy state for policy evaluator
	// type.
	MaxValuePolicy PolicyEvaluatorType = "MaxValuePolicy"
)

// PolicyFactName enumerates the values for policy fact name.
type PolicyFactName string

const (
	// PolicyFactNameGalleryImage specifies the policy fact name gallery image
	// state for policy fact name.
	PolicyFactNameGalleryImage PolicyFactName = "GalleryImage"
	// PolicyFactNameLabPremiumVMCount specifies the policy fact name lab
	// premium vm count state for policy fact name.
	PolicyFactNameLabPremiumVMCount PolicyFactName = "LabPremiumVmCount"
	// PolicyFactNameLabTargetCost specifies the policy fact name lab target
	// cost state for policy fact name.
	PolicyFactNameLabTargetCost PolicyFactName = "LabTargetCost"
	// PolicyFactNameLabVMCount specifies the policy fact name lab vm count
	// state for policy fact name.
	PolicyFactNameLabVMCount PolicyFactName = "LabVmCount"
	// PolicyFactNameLabVMSize specifies the policy fact name lab vm size state
	// for policy fact name.
	PolicyFactNameLabVMSize PolicyFactName = "LabVmSize"
	// PolicyFactNameUserOwnedLabPremiumVMCount specifies the policy fact name
	// user owned lab premium vm count state for policy fact name.
	PolicyFactNameUserOwnedLabPremiumVMCount PolicyFactName = "UserOwnedLabPremiumVmCount"
	// PolicyFactNameUserOwnedLabVMCount specifies the policy fact name user
	// owned lab vm count state for policy fact name.
	PolicyFactNameUserOwnedLabVMCount PolicyFactName = "UserOwnedLabVmCount"
	// PolicyFactNameUserOwnedLabVMCountInSubnet specifies the policy fact name
	// user owned lab vm count in subnet state for policy fact name.
	PolicyFactNameUserOwnedLabVMCountInSubnet PolicyFactName = "UserOwnedLabVmCountInSubnet"
)

// PolicyStatus enumerates the values for policy status.
type PolicyStatus string

const (
	// PolicyStatusDisabled specifies the policy status disabled state for
	// policy status.
	PolicyStatusDisabled PolicyStatus = "Disabled"
	// PolicyStatusEnabled specifies the policy status enabled state for policy
	// status.
	PolicyStatusEnabled PolicyStatus = "Enabled"
)

// PremiumDataDisk enumerates the values for premium data disk.
type PremiumDataDisk string

const (
	// PremiumDataDiskDisabled specifies the premium data disk disabled state
	// for premium data disk.
	PremiumDataDiskDisabled PremiumDataDisk = "Disabled"
	// PremiumDataDiskEnabled specifies the premium data disk enabled state for
	// premium data disk.
	PremiumDataDiskEnabled PremiumDataDisk = "Enabled"
)

// ReportingCycleType enumerates the values for reporting cycle type.
type ReportingCycleType string

const (
	// CalendarMonth specifies the calendar month state for reporting cycle
	// type.
	CalendarMonth ReportingCycleType = "CalendarMonth"
	// Custom specifies the custom state for reporting cycle type.
	Custom ReportingCycleType = "Custom"
)

// SourceControlType enumerates the values for source control type.
type SourceControlType string

const (
	// GitHub specifies the git hub state for source control type.
	GitHub SourceControlType = "GitHub"
	// VsoGit specifies the vso git state for source control type.
	VsoGit SourceControlType = "VsoGit"
)

// StorageType enumerates the values for storage type.
type StorageType string

const (
	// Premium specifies the premium state for storage type.
	Premium StorageType = "Premium"
	// Standard specifies the standard state for storage type.
	Standard StorageType = "Standard"
)

// TargetCostStatus enumerates the values for target cost status.
type TargetCostStatus string

const (
	// TargetCostStatusDisabled specifies the target cost status disabled state
	// for target cost status.
	TargetCostStatusDisabled TargetCostStatus = "Disabled"
	// TargetCostStatusEnabled specifies the target cost status enabled state
	// for target cost status.
	TargetCostStatusEnabled TargetCostStatus = "Enabled"
)

// TransportProtocol enumerates the values for transport protocol.
type TransportProtocol string

const (
	// TCP specifies the tcp state for transport protocol.
	TCP TransportProtocol = "Tcp"
	// UDP specifies the udp state for transport protocol.
	UDP TransportProtocol = "Udp"
)

// UsagePermissionType enumerates the values for usage permission type.
type UsagePermissionType string

const (
	// Allow specifies the allow state for usage permission type.
	Allow UsagePermissionType = "Allow"
	// Default specifies the default state for usage permission type.
	Default UsagePermissionType = "Default"
	// Deny specifies the deny state for usage permission type.
	Deny UsagePermissionType = "Deny"
)

// VirtualMachineCreationSource enumerates the values for virtual machine
// creation source.
type VirtualMachineCreationSource string

const (
	// FromCustomImage specifies the from custom image state for virtual
	// machine creation source.
	FromCustomImage VirtualMachineCreationSource = "FromCustomImage"
	// FromGalleryImage specifies the from gallery image state for virtual
	// machine creation source.
	FromGalleryImage VirtualMachineCreationSource = "FromGalleryImage"
)

// WindowsOsState enumerates the values for windows os state.
type WindowsOsState string

const (
	// NonSysprepped specifies the non sysprepped state for windows os state.
	NonSysprepped WindowsOsState = "NonSysprepped"
	// SysprepApplied specifies the sysprep applied state for windows os state.
	SysprepApplied WindowsOsState = "SysprepApplied"
	// SysprepRequested specifies the sysprep requested state for windows os
	// state.
	SysprepRequested WindowsOsState = "SysprepRequested"
)

// ApplicableSchedule is schedules applicable to a virtual machine. The
// schedules may have been defined on a VM or on lab level.
type ApplicableSchedule struct {
	autorest.Response             `json:"-"`
	ID                            *string             `json:"id,omitempty"`
	Name                          *string             `json:"name,omitempty"`
	Type                          *string             `json:"type,omitempty"`
	Location                      *string             `json:"location,omitempty"`
	Tags                          *map[string]*string `json:"tags,omitempty"`
	*ApplicableScheduleProperties `json:"properties,omitempty"`
}

// ApplicableScheduleFragment is schedules applicable to a virtual machine. The
// schedules may have been defined on a VM or on lab level.
type ApplicableScheduleFragment struct {
	ID                                    *string             `json:"id,omitempty"`
	Name                                  *string             `json:"name,omitempty"`
	Type                                  *string             `json:"type,omitempty"`
	Location                              *string             `json:"location,omitempty"`
	Tags                                  *map[string]*string `json:"tags,omitempty"`
	*ApplicableSchedulePropertiesFragment `json:"properties,omitempty"`
}

// ApplicableScheduleProperties is properties of a schedules applicable to a
// virtual machine.
type ApplicableScheduleProperties struct {
	LabVmsShutdown *Schedule `json:"labVmsShutdown,omitempty"`
	LabVmsStartup  *Schedule `json:"labVmsStartup,omitempty"`
}

// ApplicableSchedulePropertiesFragment is properties of a schedules applicable
// to a virtual machine.
type ApplicableSchedulePropertiesFragment struct {
	LabVmsShutdown *ScheduleFragment `json:"labVmsShutdown,omitempty"`
	LabVmsStartup  *ScheduleFragment `json:"labVmsStartup,omitempty"`
}

// ApplyArtifactsRequest is request body for applying artifacts to a virtual
// machine.
type ApplyArtifactsRequest struct {
	Artifacts *[]ArtifactInstallProperties `json:"artifacts,omitempty"`
}

// ArmTemplate is an Azure Resource Manager template.
type ArmTemplate struct {
	autorest.Response      `json:"-"`
	ID                     *string             `json:"id,omitempty"`
	Name                   *string             `json:"name,omitempty"`
	Type                   *string             `json:"type,omitempty"`
	Location               *string             `json:"location,omitempty"`
	Tags                   *map[string]*string `json:"tags,omitempty"`
	*ArmTemplateProperties `json:"properties,omitempty"`
}

// ArmTemplateInfo is information about a generated ARM template.
type ArmTemplateInfo struct {
	autorest.Response `json:"-"`
	Template          *map[string]interface{} `json:"template,omitempty"`
	Parameters        *map[string]interface{} `json:"parameters,omitempty"`
}

// ArmTemplateParameterProperties is properties of an Azure Resource Manager
// template parameter.
type ArmTemplateParameterProperties struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// ArmTemplateProperties is properties of an Azure Resource Manager template.
type ArmTemplateProperties struct {
	DisplayName              *string                    `json:"displayName,omitempty"`
	Description              *string                    `json:"description,omitempty"`
	Publisher                *string                    `json:"publisher,omitempty"`
	Icon                     *string                    `json:"icon,omitempty"`
	Contents                 *map[string]interface{}    `json:"contents,omitempty"`
	CreatedDate              *date.Time                 `json:"createdDate,omitempty"`
	ParametersValueFilesInfo *[]ParametersValueFileInfo `json:"parametersValueFilesInfo,omitempty"`
}

// Artifact is an artifact.
type Artifact struct {
	autorest.Response   `json:"-"`
	ID                  *string             `json:"id,omitempty"`
	Name                *string             `json:"name,omitempty"`
	Type                *string             `json:"type,omitempty"`
	Location            *string             `json:"location,omitempty"`
	Tags                *map[string]*string `json:"tags,omitempty"`
	*ArtifactProperties `json:"properties,omitempty"`
}

// ArtifactDeploymentStatusProperties is properties of an artifact deployment.
type ArtifactDeploymentStatusProperties struct {
	DeploymentStatus *string `json:"deploymentStatus,omitempty"`
	ArtifactsApplied *int32  `json:"artifactsApplied,omitempty"`
	TotalArtifacts   *int32  `json:"totalArtifacts,omitempty"`
}

// ArtifactDeploymentStatusPropertiesFragment is properties of an artifact
// deployment.
type ArtifactDeploymentStatusPropertiesFragment struct {
	DeploymentStatus *string `json:"deploymentStatus,omitempty"`
	ArtifactsApplied *int32  `json:"artifactsApplied,omitempty"`
	TotalArtifacts   *int32  `json:"totalArtifacts,omitempty"`
}

// ArtifactInstallProperties is properties of an artifact.
type ArtifactInstallProperties struct {
	ArtifactID               *string                        `json:"artifactId,omitempty"`
	Parameters               *[]ArtifactParameterProperties `json:"parameters,omitempty"`
	Status                   *string                        `json:"status,omitempty"`
	DeploymentStatusMessage  *string                        `json:"deploymentStatusMessage,omitempty"`
	VMExtensionStatusMessage *string                        `json:"vmExtensionStatusMessage,omitempty"`
	InstallTime              *date.Time                     `json:"installTime,omitempty"`
}

// ArtifactInstallPropertiesFragment is properties of an artifact.
type ArtifactInstallPropertiesFragment struct {
	ArtifactID               *string                                `json:"artifactId,omitempty"`
	Parameters               *[]ArtifactParameterPropertiesFragment `json:"parameters,omitempty"`
	Status                   *string                                `json:"status,omitempty"`
	DeploymentStatusMessage  *string                                `json:"deploymentStatusMessage,omitempty"`
	VMExtensionStatusMessage *string                                `json:"vmExtensionStatusMessage,omitempty"`
	InstallTime              *date.Time                             `json:"installTime,omitempty"`
}

// ArtifactParameterProperties is properties of an artifact parameter.
type ArtifactParameterProperties struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// ArtifactParameterPropertiesFragment is properties of an artifact parameter.
type ArtifactParameterPropertiesFragment struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// ArtifactProperties is properties of an artifact.
type ArtifactProperties struct {
	Title        *string                 `json:"title,omitempty"`
	Description  *string                 `json:"description,omitempty"`
	Publisher    *string                 `json:"publisher,omitempty"`
	FilePath     *string                 `json:"filePath,omitempty"`
	Icon         *string                 `json:"icon,omitempty"`
	TargetOsType *string                 `json:"targetOsType,omitempty"`
	Parameters   *map[string]interface{} `json:"parameters,omitempty"`
	CreatedDate  *date.Time              `json:"createdDate,omitempty"`
}

// ArtifactSource is properties of an artifact source.
type ArtifactSource struct {
	autorest.Response         `json:"-"`
	ID                        *string             `json:"id,omitempty"`
	Name                      *string             `json:"name,omitempty"`
	Type                      *string             `json:"type,omitempty"`
	Location                  *string             `json:"location,omitempty"`
	Tags                      *map[string]*string `json:"tags,omitempty"`
	*ArtifactSourceProperties `json:"properties,omitempty"`
}

// ArtifactSourceFragment is properties of an artifact source.
type ArtifactSourceFragment struct {
	ID                                *string             `json:"id,omitempty"`
	Name                              *string             `json:"name,omitempty"`
	Type                              *string             `json:"type,omitempty"`
	Location                          *string             `json:"location,omitempty"`
	Tags                              *map[string]*string `json:"tags,omitempty"`
	*ArtifactSourcePropertiesFragment `json:"properties,omitempty"`
}

// ArtifactSourceProperties is properties of an artifact source.
type ArtifactSourceProperties struct {
	DisplayName           *string           `json:"displayName,omitempty"`
	URI                   *string           `json:"uri,omitempty"`
	SourceType            SourceControlType `json:"sourceType,omitempty"`
	FolderPath            *string           `json:"folderPath,omitempty"`
	ArmTemplateFolderPath *string           `json:"armTemplateFolderPath,omitempty"`
	BranchRef             *string           `json:"branchRef,omitempty"`
	SecurityToken         *string           `json:"securityToken,omitempty"`
	Status                EnableStatus      `json:"status,omitempty"`
	CreatedDate           *date.Time        `json:"createdDate,omitempty"`
	ProvisioningState     *string           `json:"provisioningState,omitempty"`
	UniqueIdentifier      *string           `json:"uniqueIdentifier,omitempty"`
}

// ArtifactSourcePropertiesFragment is properties of an artifact source.
type ArtifactSourcePropertiesFragment struct {
	DisplayName           *string           `json:"displayName,omitempty"`
	URI                   *string           `json:"uri,omitempty"`
	SourceType            SourceControlType `json:"sourceType,omitempty"`
	FolderPath            *string           `json:"folderPath,omitempty"`
	ArmTemplateFolderPath *string           `json:"armTemplateFolderPath,omitempty"`
	BranchRef             *string           `json:"branchRef,omitempty"`
	SecurityToken         *string           `json:"securityToken,omitempty"`
	Status                EnableStatus      `json:"status,omitempty"`
	ProvisioningState     *string           `json:"provisioningState,omitempty"`
	UniqueIdentifier      *string           `json:"uniqueIdentifier,omitempty"`
}

// AttachDiskProperties is properties of the disk to attach.
type AttachDiskProperties struct {
	LeasedByLabVMID *string `json:"leasedByLabVmId,omitempty"`
}

// AttachNewDataDiskOptions is properties to attach new disk to the Virtual
// Machine.
type AttachNewDataDiskOptions struct {
	DiskSizeGiB *int32      `json:"diskSizeGiB,omitempty"`
	DiskName    *string     `json:"diskName,omitempty"`
	DiskType    StorageType `json:"diskType,omitempty"`
}

// BulkCreationParameters is parameters for creating multiple virtual machines
// as a single action.
type BulkCreationParameters struct {
	InstanceCount *int32 `json:"instanceCount,omitempty"`
}

// CloudError is error from a REST request.
type CloudError struct {
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody is body of an error from a REST request.
type CloudErrorBody struct {
	Code    *string           `json:"code,omitempty"`
	Message *string           `json:"message,omitempty"`
	Target  *string           `json:"target,omitempty"`
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// ComputeDataDisk is a data disks attached to a virtual machine.
type ComputeDataDisk struct {
	Name          *string `json:"name,omitempty"`
	DiskURI       *string `json:"diskUri,omitempty"`
	ManagedDiskID *string `json:"managedDiskId,omitempty"`
	DiskSizeGiB   *int32  `json:"diskSizeGiB,omitempty"`
}

// ComputeDataDiskFragment is a data disks attached to a virtual machine.
type ComputeDataDiskFragment struct {
	Name          *string `json:"name,omitempty"`
	DiskURI       *string `json:"diskUri,omitempty"`
	ManagedDiskID *string `json:"managedDiskId,omitempty"`
	DiskSizeGiB   *int32  `json:"diskSizeGiB,omitempty"`
}

// ComputeVMInstanceViewStatus is status information about a virtual machine.
type ComputeVMInstanceViewStatus struct {
	Code          *string `json:"code,omitempty"`
	DisplayStatus *string `json:"displayStatus,omitempty"`
	Message       *string `json:"message,omitempty"`
}

// ComputeVMInstanceViewStatusFragment is status information about a virtual
// machine.
type ComputeVMInstanceViewStatusFragment struct {
	Code          *string `json:"code,omitempty"`
	DisplayStatus *string `json:"displayStatus,omitempty"`
	Message       *string `json:"message,omitempty"`
}

// ComputeVMProperties is properties of a virtual machine returned by the
// Microsoft.Compute API.
type ComputeVMProperties struct {
	Statuses           *[]ComputeVMInstanceViewStatus `json:"statuses,omitempty"`
	OsType             *string                        `json:"osType,omitempty"`
	VMSize             *string                        `json:"vmSize,omitempty"`
	NetworkInterfaceID *string                        `json:"networkInterfaceId,omitempty"`
	OsDiskID           *string                        `json:"osDiskId,omitempty"`
	DataDiskIds        *[]string                      `json:"dataDiskIds,omitempty"`
	DataDisks          *[]ComputeDataDisk             `json:"dataDisks,omitempty"`
}

// ComputeVMPropertiesFragment is properties of a virtual machine returned by
// the Microsoft.Compute API.
type ComputeVMPropertiesFragment struct {
	Statuses           *[]ComputeVMInstanceViewStatusFragment `json:"statuses,omitempty"`
	OsType             *string                                `json:"osType,omitempty"`
	VMSize             *string                                `json:"vmSize,omitempty"`
	NetworkInterfaceID *string                                `json:"networkInterfaceId,omitempty"`
	OsDiskID           *string                                `json:"osDiskId,omitempty"`
	DataDiskIds        *[]string                              `json:"dataDiskIds,omitempty"`
	DataDisks          *[]ComputeDataDiskFragment             `json:"dataDisks,omitempty"`
}

// CostThresholdProperties is properties of a cost threshold item.
type CostThresholdProperties struct {
	ThresholdID                  *string                            `json:"thresholdId,omitempty"`
	PercentageThreshold          *PercentageCostThresholdProperties `json:"percentageThreshold,omitempty"`
	DisplayOnChart               CostThresholdStatus                `json:"displayOnChart,omitempty"`
	SendNotificationWhenExceeded CostThresholdStatus                `json:"sendNotificationWhenExceeded,omitempty"`
	NotificationSent             *string                            `json:"NotificationSent,omitempty"`
}

// CustomImage is a custom image.
type CustomImage struct {
	autorest.Response      `json:"-"`
	ID                     *string             `json:"id,omitempty"`
	Name                   *string             `json:"name,omitempty"`
	Type                   *string             `json:"type,omitempty"`
	Location               *string             `json:"location,omitempty"`
	Tags                   *map[string]*string `json:"tags,omitempty"`
	*CustomImageProperties `json:"properties,omitempty"`
}

// CustomImageProperties is properties of a custom image.
type CustomImageProperties struct {
	VM                *CustomImagePropertiesFromVM `json:"vm,omitempty"`
	Vhd               *CustomImagePropertiesCustom `json:"vhd,omitempty"`
	Description       *string                      `json:"description,omitempty"`
	Author            *string                      `json:"author,omitempty"`
	CreationDate      *date.Time                   `json:"creationDate,omitempty"`
	ManagedImageID    *string                      `json:"managedImageId,omitempty"`
	ProvisioningState *string                      `json:"provisioningState,omitempty"`
	UniqueIdentifier  *string                      `json:"uniqueIdentifier,omitempty"`
}

// CustomImagePropertiesCustom is properties for creating a custom image from a
// VHD.
type CustomImagePropertiesCustom struct {
	ImageName *string           `json:"imageName,omitempty"`
	SysPrep   *bool             `json:"sysPrep,omitempty"`
	OsType    CustomImageOsType `json:"osType,omitempty"`
}

// CustomImagePropertiesFromVM is properties for creating a custom image from a
// virtual machine.
type CustomImagePropertiesFromVM struct {
	SourceVMID    *string        `json:"sourceVmId,omitempty"`
	WindowsOsInfo *WindowsOsInfo `json:"windowsOsInfo,omitempty"`
	LinuxOsInfo   *LinuxOsInfo   `json:"linuxOsInfo,omitempty"`
}

// DataDiskProperties is request body for adding a new or existing data disk to
// a virtual machine.
type DataDiskProperties struct {
	AttachNewDataDiskOptions *AttachNewDataDiskOptions `json:"attachNewDataDiskOptions,omitempty"`
	ExistingLabDiskID        *string                   `json:"existingLabDiskId,omitempty"`
	HostCaching              HostCachingOptions        `json:"hostCaching,omitempty"`
}

// DayDetails is properties of a daily schedule.
type DayDetails struct {
	Time *string `json:"time,omitempty"`
}

// DayDetailsFragment is properties of a daily schedule.
type DayDetailsFragment struct {
	Time *string `json:"time,omitempty"`
}

// DetachDataDiskProperties is request body for detaching data disk from a
// virtual machine.
type DetachDataDiskProperties struct {
	ExistingLabDiskID *string `json:"existingLabDiskId,omitempty"`
}

// DetachDiskProperties is properties of the disk to detach.
type DetachDiskProperties struct {
	LeasedByLabVMID *string `json:"leasedByLabVmId,omitempty"`
}

// Disk is a Disk.
type Disk struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	*DiskProperties   `json:"properties,omitempty"`
}

// DiskProperties is properties of a disk.
type DiskProperties struct {
	DiskType          StorageType `json:"diskType,omitempty"`
	DiskSizeGiB       *int32      `json:"diskSizeGiB,omitempty"`
	LeasedByLabVMID   *string     `json:"leasedByLabVmId,omitempty"`
	DiskBlobName      *string     `json:"diskBlobName,omitempty"`
	DiskURI           *string     `json:"diskUri,omitempty"`
	CreatedDate       *date.Time  `json:"createdDate,omitempty"`
	HostCaching       *string     `json:"hostCaching,omitempty"`
	ManagedDiskID     *string     `json:"managedDiskId,omitempty"`
	ProvisioningState *string     `json:"provisioningState,omitempty"`
	UniqueIdentifier  *string     `json:"uniqueIdentifier,omitempty"`
}

// DtlEnvironment is an environment, which is essentially an ARM template
// deployment.
type DtlEnvironment struct {
	autorest.Response      `json:"-"`
	ID                     *string             `json:"id,omitempty"`
	Name                   *string             `json:"name,omitempty"`
	Type                   *string             `json:"type,omitempty"`
	Location               *string             `json:"location,omitempty"`
	Tags                   *map[string]*string `json:"tags,omitempty"`
	*EnvironmentProperties `json:"properties,omitempty"`
}

// EnvironmentDeploymentProperties is properties of an environment deployment.
type EnvironmentDeploymentProperties struct {
	ArmTemplateID *string                           `json:"armTemplateId,omitempty"`
	Parameters    *[]ArmTemplateParameterProperties `json:"parameters,omitempty"`
}

// EnvironmentProperties is properties of an environment.
type EnvironmentProperties struct {
	DeploymentProperties   *EnvironmentDeploymentProperties `json:"deploymentProperties,omitempty"`
	ArmTemplateDisplayName *string                          `json:"armTemplateDisplayName,omitempty"`
	ResourceGroupID        *string                          `json:"resourceGroupId,omitempty"`
	CreatedByUser          *string                          `json:"createdByUser,omitempty"`
	ProvisioningState      *string                          `json:"provisioningState,omitempty"`
	UniqueIdentifier       *string                          `json:"uniqueIdentifier,omitempty"`
}

// EvaluatePoliciesProperties is properties for evaluating a policy set.
type EvaluatePoliciesProperties struct {
	FactName    *string `json:"factName,omitempty"`
	FactData    *string `json:"factData,omitempty"`
	ValueOffset *string `json:"valueOffset,omitempty"`
}

// EvaluatePoliciesRequest is request body for evaluating a policy set.
type EvaluatePoliciesRequest struct {
	Policies *[]EvaluatePoliciesProperties `json:"policies,omitempty"`
}

// EvaluatePoliciesResponse is response body for evaluating a policy set.
type EvaluatePoliciesResponse struct {
	autorest.Response `json:"-"`
	Results           *[]PolicySetResult `json:"results,omitempty"`
}

// Event is an event to be notified for.
type Event struct {
	EventName NotificationChannelEventType `json:"eventName,omitempty"`
}

// EventFragment is an event to be notified for.
type EventFragment struct {
	EventName NotificationChannelEventType `json:"eventName,omitempty"`
}

// ExportResourceUsageParameters is the parameters of the export operation.
type ExportResourceUsageParameters struct {
	BlobStorageAbsoluteSasURI *string    `json:"blobStorageAbsoluteSasUri,omitempty"`
	UsageStartDate            *date.Time `json:"usageStartDate,omitempty"`
}

// ExternalSubnet is subnet information as returned by the Microsoft.Network
// API.
type ExternalSubnet struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
}

// ExternalSubnetFragment is subnet information as returned by the
// Microsoft.Network API.
type ExternalSubnetFragment struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
}

// Formula is a formula for creating a VM, specifying an image base and other
// parameters
type Formula struct {
	autorest.Response  `json:"-"`
	ID                 *string             `json:"id,omitempty"`
	Name               *string             `json:"name,omitempty"`
	Type               *string             `json:"type,omitempty"`
	Location           *string             `json:"location,omitempty"`
	Tags               *map[string]*string `json:"tags,omitempty"`
	*FormulaProperties `json:"properties,omitempty"`
}

// FormulaProperties is properties of a formula.
type FormulaProperties struct {
	Description       *string                             `json:"description,omitempty"`
	Author            *string                             `json:"author,omitempty"`
	OsType            *string                             `json:"osType,omitempty"`
	CreationDate      *date.Time                          `json:"creationDate,omitempty"`
	FormulaContent    *LabVirtualMachineCreationParameter `json:"formulaContent,omitempty"`
	VM                *FormulaPropertiesFromVM            `json:"vm,omitempty"`
	ProvisioningState *string                             `json:"provisioningState,omitempty"`
	UniqueIdentifier  *string                             `json:"uniqueIdentifier,omitempty"`
}

// FormulaPropertiesFromVM is information about a VM from which a formula is to
// be created.
type FormulaPropertiesFromVM struct {
	LabVMID *string `json:"labVmId,omitempty"`
}

// GalleryImage is a gallery image.
type GalleryImage struct {
	ID                      *string             `json:"id,omitempty"`
	Name                    *string             `json:"name,omitempty"`
	Type                    *string             `json:"type,omitempty"`
	Location                *string             `json:"location,omitempty"`
	Tags                    *map[string]*string `json:"tags,omitempty"`
	*GalleryImageProperties `json:"properties,omitempty"`
}

// GalleryImageProperties is properties of a gallery image.
type GalleryImageProperties struct {
	Author         *string                `json:"author,omitempty"`
	CreatedDate    *date.Time             `json:"createdDate,omitempty"`
	Description    *string                `json:"description,omitempty"`
	ImageReference *GalleryImageReference `json:"imageReference,omitempty"`
	Icon           *string                `json:"icon,omitempty"`
	Enabled        *bool                  `json:"enabled,omitempty"`
}

// GalleryImageReference is the reference information for an Azure Marketplace
// image.
type GalleryImageReference struct {
	Offer     *string `json:"offer,omitempty"`
	Publisher *string `json:"publisher,omitempty"`
	Sku       *string `json:"sku,omitempty"`
	OsType    *string `json:"osType,omitempty"`
	Version   *string `json:"version,omitempty"`
}

// GalleryImageReferenceFragment is the reference information for an Azure
// Marketplace image.
type GalleryImageReferenceFragment struct {
	Offer     *string `json:"offer,omitempty"`
	Publisher *string `json:"publisher,omitempty"`
	Sku       *string `json:"sku,omitempty"`
	OsType    *string `json:"osType,omitempty"`
	Version   *string `json:"version,omitempty"`
}

// GenerateArmTemplateRequest is parameters for generating an ARM template for
// deploying artifacts.
type GenerateArmTemplateRequest struct {
	VirtualMachineName *string           `json:"virtualMachineName,omitempty"`
	Parameters         *[]ParameterInfo  `json:"parameters,omitempty"`
	Location           *string           `json:"location,omitempty"`
	FileUploadOptions  FileUploadOptions `json:"fileUploadOptions,omitempty"`
}

// GenerateUploadURIParameter is properties for generating an upload URI.
type GenerateUploadURIParameter struct {
	BlobName *string `json:"blobName,omitempty"`
}

// GenerateUploadURIResponse is reponse body for generating an upload URI.
type GenerateUploadURIResponse struct {
	autorest.Response `json:"-"`
	UploadURI         *string `json:"uploadUri,omitempty"`
}

// HourDetails is properties of an hourly schedule.
type HourDetails struct {
	Minute *int32 `json:"minute,omitempty"`
}

// HourDetailsFragment is properties of an hourly schedule.
type HourDetailsFragment struct {
	Minute *int32 `json:"minute,omitempty"`
}

// IdentityProperties is identityProperties
type IdentityProperties struct {
	Type            *string `json:"type,omitempty"`
	PrincipalID     *string `json:"principalId,omitempty"`
	TenantID        *string `json:"tenantId,omitempty"`
	ClientSecretURL *string `json:"clientSecretUrl,omitempty"`
}

// InboundNatRule is a rule for NAT - exposing a VM's port (backendPort) on the
// public IP address using a load balancer.
type InboundNatRule struct {
	TransportProtocol TransportProtocol `json:"transportProtocol,omitempty"`
	FrontendPort      *int32            `json:"frontendPort,omitempty"`
	BackendPort       *int32            `json:"backendPort,omitempty"`
}

// InboundNatRuleFragment is a rule for NAT - exposing a VM's port
// (backendPort) on the public IP address using a load balancer.
type InboundNatRuleFragment struct {
	TransportProtocol TransportProtocol `json:"transportProtocol,omitempty"`
	FrontendPort      *int32            `json:"frontendPort,omitempty"`
	BackendPort       *int32            `json:"backendPort,omitempty"`
}

// Lab is a lab.
type Lab struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	*LabProperties    `json:"properties,omitempty"`
}

// LabCost is a cost item.
type LabCost struct {
	autorest.Response  `json:"-"`
	ID                 *string             `json:"id,omitempty"`
	Name               *string             `json:"name,omitempty"`
	Type               *string             `json:"type,omitempty"`
	Location           *string             `json:"location,omitempty"`
	Tags               *map[string]*string `json:"tags,omitempty"`
	*LabCostProperties `json:"properties,omitempty"`
}

// LabCostDetailsProperties is the properties of a lab cost item.
type LabCostDetailsProperties struct {
	Date     *date.Time `json:"date,omitempty"`
	Cost     *float64   `json:"cost,omitempty"`
	CostType CostType   `json:"costType,omitempty"`
}

// LabCostProperties is properties of a cost item.
type LabCostProperties struct {
	TargetCost        *TargetCostProperties        `json:"targetCost,omitempty"`
	LabCostSummary    *LabCostSummaryProperties    `json:"labCostSummary,omitempty"`
	LabCostDetails    *[]LabCostDetailsProperties  `json:"labCostDetails,omitempty"`
	ResourceCosts     *[]LabResourceCostProperties `json:"resourceCosts,omitempty"`
	CurrencyCode      *string                      `json:"currencyCode,omitempty"`
	StartDateTime     *date.Time                   `json:"startDateTime,omitempty"`
	EndDateTime       *date.Time                   `json:"endDateTime,omitempty"`
	CreatedDate       *date.Time                   `json:"createdDate,omitempty"`
	ProvisioningState *string                      `json:"provisioningState,omitempty"`
	UniqueIdentifier  *string                      `json:"uniqueIdentifier,omitempty"`
}

// LabCostSummaryProperties is the properties of the cost summary.
type LabCostSummaryProperties struct {
	EstimatedLabCost *float64 `json:"estimatedLabCost,omitempty"`
}

// LabFragment is a lab.
type LabFragment struct {
	ID                     *string             `json:"id,omitempty"`
	Name                   *string             `json:"name,omitempty"`
	Type                   *string             `json:"type,omitempty"`
	Location               *string             `json:"location,omitempty"`
	Tags                   *map[string]*string `json:"tags,omitempty"`
	*LabPropertiesFragment `json:"properties,omitempty"`
}

// LabProperties is properties of a lab.
type LabProperties struct {
	DefaultStorageAccount         *string         `json:"defaultStorageAccount,omitempty"`
	DefaultPremiumStorageAccount  *string         `json:"defaultPremiumStorageAccount,omitempty"`
	ArtifactsStorageAccount       *string         `json:"artifactsStorageAccount,omitempty"`
	PremiumDataDiskStorageAccount *string         `json:"premiumDataDiskStorageAccount,omitempty"`
	VaultName                     *string         `json:"vaultName,omitempty"`
	LabStorageType                StorageType     `json:"labStorageType,omitempty"`
	CreatedDate                   *date.Time      `json:"createdDate,omitempty"`
	PremiumDataDisks              PremiumDataDisk `json:"premiumDataDisks,omitempty"`
	ProvisioningState             *string         `json:"provisioningState,omitempty"`
	UniqueIdentifier              *string         `json:"uniqueIdentifier,omitempty"`
}

// LabPropertiesFragment is properties of a lab.
type LabPropertiesFragment struct {
	LabStorageType    StorageType     `json:"labStorageType,omitempty"`
	PremiumDataDisks  PremiumDataDisk `json:"premiumDataDisks,omitempty"`
	ProvisioningState *string         `json:"provisioningState,omitempty"`
	UniqueIdentifier  *string         `json:"uniqueIdentifier,omitempty"`
}

// LabResourceCostProperties is the properties of a resource cost item.
type LabResourceCostProperties struct {
	Resourcename        *string  `json:"resourcename,omitempty"`
	ResourceUID         *string  `json:"resourceUId,omitempty"`
	ResourceCost        *float64 `json:"resourceCost,omitempty"`
	ResourceType        *string  `json:"resourceType,omitempty"`
	ResourceOwner       *string  `json:"resourceOwner,omitempty"`
	ResourcePricingTier *string  `json:"resourcePricingTier,omitempty"`
	ResourceStatus      *string  `json:"resourceStatus,omitempty"`
	ResourceID          *string  `json:"resourceId,omitempty"`
	ExternalResourceID  *string  `json:"externalResourceId,omitempty"`
}

// LabVhd is properties of a VHD in the lab.
type LabVhd struct {
	ID *string `json:"id,omitempty"`
}

// LabVirtualMachine is a virtual machine.
type LabVirtualMachine struct {
	autorest.Response            `json:"-"`
	ID                           *string             `json:"id,omitempty"`
	Name                         *string             `json:"name,omitempty"`
	Type                         *string             `json:"type,omitempty"`
	Location                     *string             `json:"location,omitempty"`
	Tags                         *map[string]*string `json:"tags,omitempty"`
	*LabVirtualMachineProperties `json:"properties,omitempty"`
}

// LabVirtualMachineCreationParameter is properties for creating a virtual
// machine.
type LabVirtualMachineCreationParameter struct {
	*LabVirtualMachineCreationParameterProperties `json:"properties,omitempty"`
	Name                                          *string             `json:"name,omitempty"`
	Location                                      *string             `json:"location,omitempty"`
	Tags                                          *map[string]*string `json:"tags,omitempty"`
}

// LabVirtualMachineCreationParameterProperties is properties for virtual
// machine creation.
type LabVirtualMachineCreationParameterProperties struct {
	BulkCreationParameters       *BulkCreationParameters             `json:"bulkCreationParameters,omitempty"`
	Notes                        *string                             `json:"notes,omitempty"`
	OwnerObjectID                *string                             `json:"ownerObjectId,omitempty"`
	OwnerUserPrincipalName       *string                             `json:"ownerUserPrincipalName,omitempty"`
	CreatedByUserID              *string                             `json:"createdByUserId,omitempty"`
	CreatedByUser                *string                             `json:"createdByUser,omitempty"`
	CreatedDate                  *date.Time                          `json:"createdDate,omitempty"`
	CustomImageID                *string                             `json:"customImageId,omitempty"`
	OsType                       *string                             `json:"osType,omitempty"`
	Size                         *string                             `json:"size,omitempty"`
	UserName                     *string                             `json:"userName,omitempty"`
	Password                     *string                             `json:"password,omitempty"`
	SSHKey                       *string                             `json:"sshKey,omitempty"`
	IsAuthenticationWithSSHKey   *bool                               `json:"isAuthenticationWithSshKey,omitempty"`
	Fqdn                         *string                             `json:"fqdn,omitempty"`
	LabSubnetName                *string                             `json:"labSubnetName,omitempty"`
	LabVirtualNetworkID          *string                             `json:"labVirtualNetworkId,omitempty"`
	DisallowPublicIPAddress      *bool                               `json:"disallowPublicIpAddress,omitempty"`
	Artifacts                    *[]ArtifactInstallProperties        `json:"artifacts,omitempty"`
	ArtifactDeploymentStatus     *ArtifactDeploymentStatusProperties `json:"artifactDeploymentStatus,omitempty"`
	GalleryImageReference        *GalleryImageReference              `json:"galleryImageReference,omitempty"`
	ComputeVM                    *ComputeVMProperties                `json:"computeVm,omitempty"`
	NetworkInterface             *NetworkInterfaceProperties         `json:"networkInterface,omitempty"`
	ApplicableSchedule           *ApplicableSchedule                 `json:"applicableSchedule,omitempty"`
	ExpirationDate               *date.Time                          `json:"expirationDate,omitempty"`
	AllowClaim                   *bool                               `json:"allowClaim,omitempty"`
	StorageType                  *string                             `json:"storageType,omitempty"`
	VirtualMachineCreationSource VirtualMachineCreationSource        `json:"virtualMachineCreationSource,omitempty"`
	EnvironmentID                *string                             `json:"environmentId,omitempty"`
	ProvisioningState            *string                             `json:"provisioningState,omitempty"`
	UniqueIdentifier             *string                             `json:"uniqueIdentifier,omitempty"`
}

// LabVirtualMachineFragment is a virtual machine.
type LabVirtualMachineFragment struct {
	ID                                   *string             `json:"id,omitempty"`
	Name                                 *string             `json:"name,omitempty"`
	Type                                 *string             `json:"type,omitempty"`
	Location                             *string             `json:"location,omitempty"`
	Tags                                 *map[string]*string `json:"tags,omitempty"`
	*LabVirtualMachinePropertiesFragment `json:"properties,omitempty"`
}

// LabVirtualMachineProperties is properties of a virtual machine.
type LabVirtualMachineProperties struct {
	Notes                        *string                             `json:"notes,omitempty"`
	OwnerObjectID                *string                             `json:"ownerObjectId,omitempty"`
	OwnerUserPrincipalName       *string                             `json:"ownerUserPrincipalName,omitempty"`
	CreatedByUserID              *string                             `json:"createdByUserId,omitempty"`
	CreatedByUser                *string                             `json:"createdByUser,omitempty"`
	CreatedDate                  *date.Time                          `json:"createdDate,omitempty"`
	ComputeID                    *string                             `json:"computeId,omitempty"`
	CustomImageID                *string                             `json:"customImageId,omitempty"`
	OsType                       *string                             `json:"osType,omitempty"`
	Size                         *string                             `json:"size,omitempty"`
	UserName                     *string                             `json:"userName,omitempty"`
	Password                     *string                             `json:"password,omitempty"`
	SSHKey                       *string                             `json:"sshKey,omitempty"`
	IsAuthenticationWithSSHKey   *bool                               `json:"isAuthenticationWithSshKey,omitempty"`
	Fqdn                         *string                             `json:"fqdn,omitempty"`
	LabSubnetName                *string                             `json:"labSubnetName,omitempty"`
	LabVirtualNetworkID          *string                             `json:"labVirtualNetworkId,omitempty"`
	DisallowPublicIPAddress      *bool                               `json:"disallowPublicIpAddress,omitempty"`
	Artifacts                    *[]ArtifactInstallProperties        `json:"artifacts,omitempty"`
	ArtifactDeploymentStatus     *ArtifactDeploymentStatusProperties `json:"artifactDeploymentStatus,omitempty"`
	GalleryImageReference        *GalleryImageReference              `json:"galleryImageReference,omitempty"`
	ComputeVM                    *ComputeVMProperties                `json:"computeVm,omitempty"`
	NetworkInterface             *NetworkInterfaceProperties         `json:"networkInterface,omitempty"`
	ApplicableSchedule           *ApplicableSchedule                 `json:"applicableSchedule,omitempty"`
	ExpirationDate               *date.Time                          `json:"expirationDate,omitempty"`
	AllowClaim                   *bool                               `json:"allowClaim,omitempty"`
	StorageType                  *string                             `json:"storageType,omitempty"`
	VirtualMachineCreationSource VirtualMachineCreationSource        `json:"virtualMachineCreationSource,omitempty"`
	EnvironmentID                *string                             `json:"environmentId,omitempty"`
	ProvisioningState            *string                             `json:"provisioningState,omitempty"`
	UniqueIdentifier             *string                             `json:"uniqueIdentifier,omitempty"`
}

// LabVirtualMachinePropertiesFragment is properties of a virtual machine.
type LabVirtualMachinePropertiesFragment struct {
	Notes                        *string                                     `json:"notes,omitempty"`
	OwnerObjectID                *string                                     `json:"ownerObjectId,omitempty"`
	OwnerUserPrincipalName       *string                                     `json:"ownerUserPrincipalName,omitempty"`
	CreatedByUserID              *string                                     `json:"createdByUserId,omitempty"`
	CreatedByUser                *string                                     `json:"createdByUser,omitempty"`
	CreatedDate                  *date.Time                                  `json:"createdDate,omitempty"`
	CustomImageID                *string                                     `json:"customImageId,omitempty"`
	OsType                       *string                                     `json:"osType,omitempty"`
	Size                         *string                                     `json:"size,omitempty"`
	UserName                     *string                                     `json:"userName,omitempty"`
	Password                     *string                                     `json:"password,omitempty"`
	SSHKey                       *string                                     `json:"sshKey,omitempty"`
	IsAuthenticationWithSSHKey   *bool                                       `json:"isAuthenticationWithSshKey,omitempty"`
	Fqdn                         *string                                     `json:"fqdn,omitempty"`
	LabSubnetName                *string                                     `json:"labSubnetName,omitempty"`
	LabVirtualNetworkID          *string                                     `json:"labVirtualNetworkId,omitempty"`
	DisallowPublicIPAddress      *bool                                       `json:"disallowPublicIpAddress,omitempty"`
	Artifacts                    *[]ArtifactInstallPropertiesFragment        `json:"artifacts,omitempty"`
	ArtifactDeploymentStatus     *ArtifactDeploymentStatusPropertiesFragment `json:"artifactDeploymentStatus,omitempty"`
	GalleryImageReference        *GalleryImageReferenceFragment              `json:"galleryImageReference,omitempty"`
	ComputeVM                    *ComputeVMPropertiesFragment                `json:"computeVm,omitempty"`
	NetworkInterface             *NetworkInterfacePropertiesFragment         `json:"networkInterface,omitempty"`
	ApplicableSchedule           *ApplicableScheduleFragment                 `json:"applicableSchedule,omitempty"`
	ExpirationDate               *date.Time                                  `json:"expirationDate,omitempty"`
	AllowClaim                   *bool                                       `json:"allowClaim,omitempty"`
	StorageType                  *string                                     `json:"storageType,omitempty"`
	VirtualMachineCreationSource VirtualMachineCreationSource                `json:"virtualMachineCreationSource,omitempty"`
	EnvironmentID                *string                                     `json:"environmentId,omitempty"`
	ProvisioningState            *string                                     `json:"provisioningState,omitempty"`
	UniqueIdentifier             *string                                     `json:"uniqueIdentifier,omitempty"`
}

// LinuxOsInfo is information about a Linux OS.
type LinuxOsInfo struct {
	LinuxOsState LinuxOsState `json:"linuxOsState,omitempty"`
}

// NetworkInterfaceProperties is properties of a network interface.
type NetworkInterfaceProperties struct {
	VirtualNetworkID                   *string                             `json:"virtualNetworkId,omitempty"`
	SubnetID                           *string                             `json:"subnetId,omitempty"`
	PublicIPAddressID                  *string                             `json:"publicIpAddressId,omitempty"`
	PublicIPAddress                    *string                             `json:"publicIpAddress,omitempty"`
	PrivateIPAddress                   *string                             `json:"privateIpAddress,omitempty"`
	DNSName                            *string                             `json:"dnsName,omitempty"`
	RdpAuthority                       *string                             `json:"rdpAuthority,omitempty"`
	SSHAuthority                       *string                             `json:"sshAuthority,omitempty"`
	SharedPublicIPAddressConfiguration *SharedPublicIPAddressConfiguration `json:"sharedPublicIpAddressConfiguration,omitempty"`
}

// NetworkInterfacePropertiesFragment is properties of a network interface.
type NetworkInterfacePropertiesFragment struct {
	VirtualNetworkID                   *string                                     `json:"virtualNetworkId,omitempty"`
	SubnetID                           *string                                     `json:"subnetId,omitempty"`
	PublicIPAddressID                  *string                                     `json:"publicIpAddressId,omitempty"`
	PublicIPAddress                    *string                                     `json:"publicIpAddress,omitempty"`
	PrivateIPAddress                   *string                                     `json:"privateIpAddress,omitempty"`
	DNSName                            *string                                     `json:"dnsName,omitempty"`
	RdpAuthority                       *string                                     `json:"rdpAuthority,omitempty"`
	SSHAuthority                       *string                                     `json:"sshAuthority,omitempty"`
	SharedPublicIPAddressConfiguration *SharedPublicIPAddressConfigurationFragment `json:"sharedPublicIpAddressConfiguration,omitempty"`
}

// NotificationChannel is a notification.
type NotificationChannel struct {
	autorest.Response              `json:"-"`
	ID                             *string             `json:"id,omitempty"`
	Name                           *string             `json:"name,omitempty"`
	Type                           *string             `json:"type,omitempty"`
	Location                       *string             `json:"location,omitempty"`
	Tags                           *map[string]*string `json:"tags,omitempty"`
	*NotificationChannelProperties `json:"properties,omitempty"`
}

// NotificationChannelFragment is a notification.
type NotificationChannelFragment struct {
	ID                                     *string             `json:"id,omitempty"`
	Name                                   *string             `json:"name,omitempty"`
	Type                                   *string             `json:"type,omitempty"`
	Location                               *string             `json:"location,omitempty"`
	Tags                                   *map[string]*string `json:"tags,omitempty"`
	*NotificationChannelPropertiesFragment `json:"properties,omitempty"`
}

// NotificationChannelProperties is properties of a schedule.
type NotificationChannelProperties struct {
	WebHookURL        *string    `json:"webHookUrl,omitempty"`
	Description       *string    `json:"description,omitempty"`
	Events            *[]Event   `json:"events,omitempty"`
	CreatedDate       *date.Time `json:"createdDate,omitempty"`
	ProvisioningState *string    `json:"provisioningState,omitempty"`
	UniqueIdentifier  *string    `json:"uniqueIdentifier,omitempty"`
}

// NotificationChannelPropertiesFragment is properties of a schedule.
type NotificationChannelPropertiesFragment struct {
	WebHookURL        *string          `json:"webHookUrl,omitempty"`
	Description       *string          `json:"description,omitempty"`
	Events            *[]EventFragment `json:"events,omitempty"`
	ProvisioningState *string          `json:"provisioningState,omitempty"`
	UniqueIdentifier  *string          `json:"uniqueIdentifier,omitempty"`
}

// NotificationSettings is notification settings for a schedule.
type NotificationSettings struct {
	Status        NotificationStatus `json:"status,omitempty"`
	TimeInMinutes *int32             `json:"timeInMinutes,omitempty"`
	WebhookURL    *string            `json:"webhookUrl,omitempty"`
}

// NotificationSettingsFragment is notification settings for a schedule.
type NotificationSettingsFragment struct {
	Status        NotificationStatus `json:"status,omitempty"`
	TimeInMinutes *int32             `json:"timeInMinutes,omitempty"`
	WebhookURL    *string            `json:"webhookUrl,omitempty"`
}

// NotifyParameters is properties for generating a Notification.
type NotifyParameters struct {
	EventName   NotificationChannelEventType `json:"eventName,omitempty"`
	JSONPayload *string                      `json:"jsonPayload,omitempty"`
}

// ParameterInfo is information about an artifact's parameter.
type ParameterInfo struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// ParametersValueFileInfo is a file containing a set of parameter values for
// an ARM template.
type ParametersValueFileInfo struct {
	FileName            *string                 `json:"fileName,omitempty"`
	ParametersValueInfo *map[string]interface{} `json:"parametersValueInfo,omitempty"`
}

// PercentageCostThresholdProperties is properties of a percentage cost
// threshold.
type PercentageCostThresholdProperties struct {
	ThresholdValue *float64 `json:"thresholdValue,omitempty"`
}

// Policy is a Policy.
type Policy struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	*PolicyProperties `json:"properties,omitempty"`
}

// PolicyFragment is a Policy.
type PolicyFragment struct {
	ID                        *string             `json:"id,omitempty"`
	Name                      *string             `json:"name,omitempty"`
	Type                      *string             `json:"type,omitempty"`
	Location                  *string             `json:"location,omitempty"`
	Tags                      *map[string]*string `json:"tags,omitempty"`
	*PolicyPropertiesFragment `json:"properties,omitempty"`
}

// PolicyProperties is properties of a Policy.
type PolicyProperties struct {
	Description       *string             `json:"description,omitempty"`
	Status            PolicyStatus        `json:"status,omitempty"`
	FactName          PolicyFactName      `json:"factName,omitempty"`
	FactData          *string             `json:"factData,omitempty"`
	Threshold         *string             `json:"threshold,omitempty"`
	EvaluatorType     PolicyEvaluatorType `json:"evaluatorType,omitempty"`
	CreatedDate       *date.Time          `json:"createdDate,omitempty"`
	ProvisioningState *string             `json:"provisioningState,omitempty"`
	UniqueIdentifier  *string             `json:"uniqueIdentifier,omitempty"`
}

// PolicyPropertiesFragment is properties of a Policy.
type PolicyPropertiesFragment struct {
	Description       *string             `json:"description,omitempty"`
	Status            PolicyStatus        `json:"status,omitempty"`
	FactName          PolicyFactName      `json:"factName,omitempty"`
	FactData          *string             `json:"factData,omitempty"`
	Threshold         *string             `json:"threshold,omitempty"`
	EvaluatorType     PolicyEvaluatorType `json:"evaluatorType,omitempty"`
	ProvisioningState *string             `json:"provisioningState,omitempty"`
	UniqueIdentifier  *string             `json:"uniqueIdentifier,omitempty"`
}

// PolicySetResult is result of a policy set evaluation.
type PolicySetResult struct {
	HasError         *bool              `json:"hasError,omitempty"`
	PolicyViolations *[]PolicyViolation `json:"policyViolations,omitempty"`
}

// PolicyViolation is policy violation.
type PolicyViolation struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// Port is properties of a network port.
type Port struct {
	TransportProtocol TransportProtocol `json:"transportProtocol,omitempty"`
	BackendPort       *int32            `json:"backendPort,omitempty"`
}

// PortFragment is properties of a network port.
type PortFragment struct {
	TransportProtocol TransportProtocol `json:"transportProtocol,omitempty"`
	BackendPort       *int32            `json:"backendPort,omitempty"`
}

// Resource is an Azure resource.
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// ResponseWithContinuationArmTemplate is the response of a list operation.
type ResponseWithContinuationArmTemplate struct {
	autorest.Response `json:"-"`
	Value             *[]ArmTemplate `json:"value,omitempty"`
	NextLink          *string        `json:"nextLink,omitempty"`
}

// ResponseWithContinuationArmTemplatePreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResponseWithContinuationArmTemplate) ResponseWithContinuationArmTemplatePreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResponseWithContinuationArtifact is the response of a list operation.
type ResponseWithContinuationArtifact struct {
	autorest.Response `json:"-"`
	Value             *[]Artifact `json:"value,omitempty"`
	NextLink          *string     `json:"nextLink,omitempty"`
}

// ResponseWithContinuationArtifactPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResponseWithContinuationArtifact) ResponseWithContinuationArtifactPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResponseWithContinuationArtifactSource is the response of a list operation.
type ResponseWithContinuationArtifactSource struct {
	autorest.Response `json:"-"`
	Value             *[]ArtifactSource `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// ResponseWithContinuationArtifactSourcePreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResponseWithContinuationArtifactSource) ResponseWithContinuationArtifactSourcePreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResponseWithContinuationCustomImage is the response of a list operation.
type ResponseWithContinuationCustomImage struct {
	autorest.Response `json:"-"`
	Value             *[]CustomImage `json:"value,omitempty"`
	NextLink          *string        `json:"nextLink,omitempty"`
}

// ResponseWithContinuationCustomImagePreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResponseWithContinuationCustomImage) ResponseWithContinuationCustomImagePreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResponseWithContinuationDisk is the response of a list operation.
type ResponseWithContinuationDisk struct {
	autorest.Response `json:"-"`
	Value             *[]Disk `json:"value,omitempty"`
	NextLink          *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationDiskPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResponseWithContinuationDisk) ResponseWithContinuationDiskPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResponseWithContinuationDtlEnvironment is the response of a list operation.
type ResponseWithContinuationDtlEnvironment struct {
	autorest.Response `json:"-"`
	Value             *[]DtlEnvironment `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// ResponseWithContinuationDtlEnvironmentPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResponseWithContinuationDtlEnvironment) ResponseWithContinuationDtlEnvironmentPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResponseWithContinuationFormula is the response of a list operation.
type ResponseWithContinuationFormula struct {
	autorest.Response `json:"-"`
	Value             *[]Formula `json:"value,omitempty"`
	NextLink          *string    `json:"nextLink,omitempty"`
}

// ResponseWithContinuationFormulaPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResponseWithContinuationFormula) ResponseWithContinuationFormulaPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResponseWithContinuationGalleryImage is the response of a list operation.
type ResponseWithContinuationGalleryImage struct {
	autorest.Response `json:"-"`
	Value             *[]GalleryImage `json:"value,omitempty"`
	NextLink          *string         `json:"nextLink,omitempty"`
}

// ResponseWithContinuationGalleryImagePreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResponseWithContinuationGalleryImage) ResponseWithContinuationGalleryImagePreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResponseWithContinuationLab is the response of a list operation.
type ResponseWithContinuationLab struct {
	autorest.Response `json:"-"`
	Value             *[]Lab  `json:"value,omitempty"`
	NextLink          *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationLabPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResponseWithContinuationLab) ResponseWithContinuationLabPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResponseWithContinuationLabVhd is the response of a list operation.
type ResponseWithContinuationLabVhd struct {
	autorest.Response `json:"-"`
	Value             *[]LabVhd `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// ResponseWithContinuationLabVhdPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResponseWithContinuationLabVhd) ResponseWithContinuationLabVhdPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResponseWithContinuationLabVirtualMachine is the response of a list
// operation.
type ResponseWithContinuationLabVirtualMachine struct {
	autorest.Response `json:"-"`
	Value             *[]LabVirtualMachine `json:"value,omitempty"`
	NextLink          *string              `json:"nextLink,omitempty"`
}

// ResponseWithContinuationLabVirtualMachinePreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResponseWithContinuationLabVirtualMachine) ResponseWithContinuationLabVirtualMachinePreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResponseWithContinuationNotificationChannel is the response of a list
// operation.
type ResponseWithContinuationNotificationChannel struct {
	autorest.Response `json:"-"`
	Value             *[]NotificationChannel `json:"value,omitempty"`
	NextLink          *string                `json:"nextLink,omitempty"`
}

// ResponseWithContinuationNotificationChannelPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResponseWithContinuationNotificationChannel) ResponseWithContinuationNotificationChannelPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResponseWithContinuationPolicy is the response of a list operation.
type ResponseWithContinuationPolicy struct {
	autorest.Response `json:"-"`
	Value             *[]Policy `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// ResponseWithContinuationPolicyPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResponseWithContinuationPolicy) ResponseWithContinuationPolicyPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResponseWithContinuationSchedule is the response of a list operation.
type ResponseWithContinuationSchedule struct {
	autorest.Response `json:"-"`
	Value             *[]Schedule `json:"value,omitempty"`
	NextLink          *string     `json:"nextLink,omitempty"`
}

// ResponseWithContinuationSchedulePreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResponseWithContinuationSchedule) ResponseWithContinuationSchedulePreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResponseWithContinuationSecret is the response of a list operation.
type ResponseWithContinuationSecret struct {
	autorest.Response `json:"-"`
	Value             *[]Secret `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// ResponseWithContinuationSecretPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResponseWithContinuationSecret) ResponseWithContinuationSecretPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResponseWithContinuationServiceRunner is the response of a list operation.
type ResponseWithContinuationServiceRunner struct {
	autorest.Response `json:"-"`
	Value             *[]ServiceRunner `json:"value,omitempty"`
	NextLink          *string          `json:"nextLink,omitempty"`
}

// ResponseWithContinuationServiceRunnerPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResponseWithContinuationServiceRunner) ResponseWithContinuationServiceRunnerPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResponseWithContinuationUser is the response of a list operation.
type ResponseWithContinuationUser struct {
	autorest.Response `json:"-"`
	Value             *[]User `json:"value,omitempty"`
	NextLink          *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationUserPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResponseWithContinuationUser) ResponseWithContinuationUserPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResponseWithContinuationVirtualNetwork is the response of a list operation.
type ResponseWithContinuationVirtualNetwork struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualNetwork `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// ResponseWithContinuationVirtualNetworkPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResponseWithContinuationVirtualNetwork) ResponseWithContinuationVirtualNetworkPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RetargetScheduleProperties is properties for retargeting a virtual machine
// schedule.
type RetargetScheduleProperties struct {
	CurrentResourceID *string `json:"currentResourceId,omitempty"`
	TargetResourceID  *string `json:"targetResourceId,omitempty"`
}

// Schedule is a schedule.
type Schedule struct {
	autorest.Response   `json:"-"`
	ID                  *string             `json:"id,omitempty"`
	Name                *string             `json:"name,omitempty"`
	Type                *string             `json:"type,omitempty"`
	Location            *string             `json:"location,omitempty"`
	Tags                *map[string]*string `json:"tags,omitempty"`
	*ScheduleProperties `json:"properties,omitempty"`
}

// ScheduleFragment is a schedule.
type ScheduleFragment struct {
	ID                          *string             `json:"id,omitempty"`
	Name                        *string             `json:"name,omitempty"`
	Type                        *string             `json:"type,omitempty"`
	Location                    *string             `json:"location,omitempty"`
	Tags                        *map[string]*string `json:"tags,omitempty"`
	*SchedulePropertiesFragment `json:"properties,omitempty"`
}

// ScheduleProperties is properties of a schedule.
type ScheduleProperties struct {
	Status               EnableStatus          `json:"status,omitempty"`
	TaskType             *string               `json:"taskType,omitempty"`
	WeeklyRecurrence     *WeekDetails          `json:"weeklyRecurrence,omitempty"`
	DailyRecurrence      *DayDetails           `json:"dailyRecurrence,omitempty"`
	HourlyRecurrence     *HourDetails          `json:"hourlyRecurrence,omitempty"`
	TimeZoneID           *string               `json:"timeZoneId,omitempty"`
	NotificationSettings *NotificationSettings `json:"notificationSettings,omitempty"`
	CreatedDate          *date.Time            `json:"createdDate,omitempty"`
	TargetResourceID     *string               `json:"targetResourceId,omitempty"`
	ProvisioningState    *string               `json:"provisioningState,omitempty"`
	UniqueIdentifier     *string               `json:"uniqueIdentifier,omitempty"`
}

// SchedulePropertiesFragment is properties of a schedule.
type SchedulePropertiesFragment struct {
	Status               EnableStatus                  `json:"status,omitempty"`
	TaskType             *string                       `json:"taskType,omitempty"`
	WeeklyRecurrence     *WeekDetailsFragment          `json:"weeklyRecurrence,omitempty"`
	DailyRecurrence      *DayDetailsFragment           `json:"dailyRecurrence,omitempty"`
	HourlyRecurrence     *HourDetailsFragment          `json:"hourlyRecurrence,omitempty"`
	TimeZoneID           *string                       `json:"timeZoneId,omitempty"`
	NotificationSettings *NotificationSettingsFragment `json:"notificationSettings,omitempty"`
	TargetResourceID     *string                       `json:"targetResourceId,omitempty"`
	ProvisioningState    *string                       `json:"provisioningState,omitempty"`
	UniqueIdentifier     *string                       `json:"uniqueIdentifier,omitempty"`
}

// Secret is a secret.
type Secret struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	*SecretProperties `json:"properties,omitempty"`
}

// SecretProperties is properties of a secret.
type SecretProperties struct {
	Value             *string `json:"value,omitempty"`
	ProvisioningState *string `json:"provisioningState,omitempty"`
	UniqueIdentifier  *string `json:"uniqueIdentifier,omitempty"`
}

// ServiceRunner is a container for a managed identity to execute DevTest lab
// services.
type ServiceRunner struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	Identity          *IdentityProperties `json:"identity,omitempty"`
}

// SharedPublicIPAddressConfiguration is properties of a virtual machine that
// determine how it is connected to a load balancer.
type SharedPublicIPAddressConfiguration struct {
	InboundNatRules *[]InboundNatRule `json:"inboundNatRules,omitempty"`
}

// SharedPublicIPAddressConfigurationFragment is properties of a virtual
// machine that determine how it is connected to a load balancer.
type SharedPublicIPAddressConfigurationFragment struct {
	InboundNatRules *[]InboundNatRuleFragment `json:"inboundNatRules,omitempty"`
}

// ShutdownNotificationContent is the contents of a shutdown notification.
// Webhooks can use this type to deserialize the request body when they get
// notified of an imminent shutdown.
type ShutdownNotificationContent struct {
	SkipURL           *string `json:"skipUrl,omitempty"`
	DelayURL60        *string `json:"delayUrl60,omitempty"`
	DelayURL120       *string `json:"delayUrl120,omitempty"`
	VMName            *string `json:"vmName,omitempty"`
	GUID              *string `json:"guid,omitempty"`
	Owner             *string `json:"owner,omitempty"`
	EventType         *string `json:"eventType,omitempty"`
	Text              *string `json:"text,omitempty"`
	SubscriptionID    *string `json:"subscriptionId,omitempty"`
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	LabName           *string `json:"labName,omitempty"`
}

// Subnet is subnet information.
type Subnet struct {
	ResourceID    *string             `json:"resourceId,omitempty"`
	LabSubnetName *string             `json:"labSubnetName,omitempty"`
	AllowPublicIP UsagePermissionType `json:"allowPublicIp,omitempty"`
}

// SubnetFragment is subnet information.
type SubnetFragment struct {
	ResourceID    *string             `json:"resourceId,omitempty"`
	LabSubnetName *string             `json:"labSubnetName,omitempty"`
	AllowPublicIP UsagePermissionType `json:"allowPublicIp,omitempty"`
}

// SubnetOverride is property overrides on a subnet of a virtual network.
type SubnetOverride struct {
	ResourceID                         *string                                   `json:"resourceId,omitempty"`
	LabSubnetName                      *string                                   `json:"labSubnetName,omitempty"`
	UseInVMCreationPermission          UsagePermissionType                       `json:"useInVmCreationPermission,omitempty"`
	UsePublicIPAddressPermission       UsagePermissionType                       `json:"usePublicIpAddressPermission,omitempty"`
	SharedPublicIPAddressConfiguration *SubnetSharedPublicIPAddressConfiguration `json:"sharedPublicIpAddressConfiguration,omitempty"`
	VirtualNetworkPoolName             *string                                   `json:"virtualNetworkPoolName,omitempty"`
}

// SubnetOverrideFragment is property overrides on a subnet of a virtual
// network.
type SubnetOverrideFragment struct {
	ResourceID                         *string                                           `json:"resourceId,omitempty"`
	LabSubnetName                      *string                                           `json:"labSubnetName,omitempty"`
	UseInVMCreationPermission          UsagePermissionType                               `json:"useInVmCreationPermission,omitempty"`
	UsePublicIPAddressPermission       UsagePermissionType                               `json:"usePublicIpAddressPermission,omitempty"`
	SharedPublicIPAddressConfiguration *SubnetSharedPublicIPAddressConfigurationFragment `json:"sharedPublicIpAddressConfiguration,omitempty"`
	VirtualNetworkPoolName             *string                                           `json:"virtualNetworkPoolName,omitempty"`
}

// SubnetSharedPublicIPAddressConfiguration is configuration for public IP
// address sharing.
type SubnetSharedPublicIPAddressConfiguration struct {
	AllowedPorts *[]Port `json:"allowedPorts,omitempty"`
}

// SubnetSharedPublicIPAddressConfigurationFragment is configuration for public
// IP address sharing.
type SubnetSharedPublicIPAddressConfigurationFragment struct {
	AllowedPorts *[]PortFragment `json:"allowedPorts,omitempty"`
}

// TargetCostProperties is properties of a cost target.
type TargetCostProperties struct {
	Status             TargetCostStatus           `json:"status,omitempty"`
	Target             *int32                     `json:"target,omitempty"`
	CostThresholds     *[]CostThresholdProperties `json:"costThresholds,omitempty"`
	CycleStartDateTime *date.Time                 `json:"cycleStartDateTime,omitempty"`
	CycleEndDateTime   *date.Time                 `json:"cycleEndDateTime,omitempty"`
	CycleType          ReportingCycleType         `json:"cycleType,omitempty"`
}

// User is profile of a lab user.
type User struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	*UserProperties   `json:"properties,omitempty"`
}

// UserFragment is profile of a lab user.
type UserFragment struct {
	ID                      *string             `json:"id,omitempty"`
	Name                    *string             `json:"name,omitempty"`
	Type                    *string             `json:"type,omitempty"`
	Location                *string             `json:"location,omitempty"`
	Tags                    *map[string]*string `json:"tags,omitempty"`
	*UserPropertiesFragment `json:"properties,omitempty"`
}

// UserIdentity is identity attributes of a lab user.
type UserIdentity struct {
	PrincipalName *string `json:"principalName,omitempty"`
	PrincipalID   *string `json:"principalId,omitempty"`
	TenantID      *string `json:"tenantId,omitempty"`
	ObjectID      *string `json:"objectId,omitempty"`
	AppID         *string `json:"appId,omitempty"`
}

// UserIdentityFragment is identity attributes of a lab user.
type UserIdentityFragment struct {
	PrincipalName *string `json:"principalName,omitempty"`
	PrincipalID   *string `json:"principalId,omitempty"`
	TenantID      *string `json:"tenantId,omitempty"`
	ObjectID      *string `json:"objectId,omitempty"`
	AppID         *string `json:"appId,omitempty"`
}

// UserProperties is properties of a lab user profile.
type UserProperties struct {
	Identity          *UserIdentity    `json:"identity,omitempty"`
	SecretStore       *UserSecretStore `json:"secretStore,omitempty"`
	CreatedDate       *date.Time       `json:"createdDate,omitempty"`
	ProvisioningState *string          `json:"provisioningState,omitempty"`
	UniqueIdentifier  *string          `json:"uniqueIdentifier,omitempty"`
}

// UserPropertiesFragment is properties of a lab user profile.
type UserPropertiesFragment struct {
	Identity          *UserIdentityFragment    `json:"identity,omitempty"`
	SecretStore       *UserSecretStoreFragment `json:"secretStore,omitempty"`
	ProvisioningState *string                  `json:"provisioningState,omitempty"`
	UniqueIdentifier  *string                  `json:"uniqueIdentifier,omitempty"`
}

// UserSecretStore is properties of a user's secret store.
type UserSecretStore struct {
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`
	KeyVaultID  *string `json:"keyVaultId,omitempty"`
}

// UserSecretStoreFragment is properties of a user's secret store.
type UserSecretStoreFragment struct {
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`
	KeyVaultID  *string `json:"keyVaultId,omitempty"`
}

// VirtualNetwork is a virtual network.
type VirtualNetwork struct {
	autorest.Response         `json:"-"`
	ID                        *string             `json:"id,omitempty"`
	Name                      *string             `json:"name,omitempty"`
	Type                      *string             `json:"type,omitempty"`
	Location                  *string             `json:"location,omitempty"`
	Tags                      *map[string]*string `json:"tags,omitempty"`
	*VirtualNetworkProperties `json:"properties,omitempty"`
}

// VirtualNetworkFragment is a virtual network.
type VirtualNetworkFragment struct {
	ID                                *string             `json:"id,omitempty"`
	Name                              *string             `json:"name,omitempty"`
	Type                              *string             `json:"type,omitempty"`
	Location                          *string             `json:"location,omitempty"`
	Tags                              *map[string]*string `json:"tags,omitempty"`
	*VirtualNetworkPropertiesFragment `json:"properties,omitempty"`
}

// VirtualNetworkProperties is properties of a virtual network.
type VirtualNetworkProperties struct {
	AllowedSubnets             *[]Subnet         `json:"allowedSubnets,omitempty"`
	Description                *string           `json:"description,omitempty"`
	ExternalProviderResourceID *string           `json:"externalProviderResourceId,omitempty"`
	ExternalSubnets            *[]ExternalSubnet `json:"externalSubnets,omitempty"`
	SubnetOverrides            *[]SubnetOverride `json:"subnetOverrides,omitempty"`
	CreatedDate                *date.Time        `json:"createdDate,omitempty"`
	ProvisioningState          *string           `json:"provisioningState,omitempty"`
	UniqueIdentifier           *string           `json:"uniqueIdentifier,omitempty"`
}

// VirtualNetworkPropertiesFragment is properties of a virtual network.
type VirtualNetworkPropertiesFragment struct {
	AllowedSubnets             *[]SubnetFragment         `json:"allowedSubnets,omitempty"`
	Description                *string                   `json:"description,omitempty"`
	ExternalProviderResourceID *string                   `json:"externalProviderResourceId,omitempty"`
	ExternalSubnets            *[]ExternalSubnetFragment `json:"externalSubnets,omitempty"`
	SubnetOverrides            *[]SubnetOverrideFragment `json:"subnetOverrides,omitempty"`
	ProvisioningState          *string                   `json:"provisioningState,omitempty"`
	UniqueIdentifier           *string                   `json:"uniqueIdentifier,omitempty"`
}

// WeekDetails is properties of a weekly schedule.
type WeekDetails struct {
	Weekdays *[]string `json:"weekdays,omitempty"`
	Time     *string   `json:"time,omitempty"`
}

// WeekDetailsFragment is properties of a weekly schedule.
type WeekDetailsFragment struct {
	Weekdays *[]string `json:"weekdays,omitempty"`
	Time     *string   `json:"time,omitempty"`
}

// WindowsOsInfo is information about a Windows OS.
type WindowsOsInfo struct {
	WindowsOsState WindowsOsState `json:"windowsOsState,omitempty"`
}
