#!/bin/bash
#
# test for sending stream size of clone-src option, compare against a send
# stream generated by buggy version

source "$TEST_TOP/common" || exit

check_prereq mkfs.btrfs
check_prereq btrfs

setup_root_helper
prepare_test_dev

run_check_mkfs_test_dev
run_check_mount_test_dev

here=`pwd`
cd "$TEST_MNT" || _fail "cannot chdir to TEST_MNT"

run_check $SUDO_HELPER "$TOP/btrfs" subvolume create subv-parent1
for i in 1 2 3; do
	run_check $SUDO_HELPER dd if=/dev/zero of=subv-parent1/file1_$i bs=1M count=1
	run_check $SUDO_HELPER "$TOP/btrfs" subvolume snapshot -r subv-parent1 subv-snap1_$i
done

run_check $SUDO_HELPER "$TOP/btrfs" subvolume create subv-parent2
for i in 1 2 3; do
	run_check $SUDO_HELPER dd if=/dev/zero of=subv-parent2/file2_$i bs=1M count=1
	run_check $SUDO_HELPER "$TOP/btrfs" subvolume snapshot -r subv-parent2 subv-snap2_$i
done

_mktemp_local "$here/send-stream.img"
run_check $SUDO_HELPER "$TOP/btrfs" send -f "$here"/send-stream.img \
	-c subv-snap1_1 -c subv-snap2_1 subv-snap1_[23] subv-snap2_[23]

image=$(extract_image "$here"/multi-clone-src-v4.8.2.stream.xz)
old_stream_size=`stat --format=%s "$image"`
stream_size=`stat --format=%s "$here"/send-stream.img`

if [ "$old_stream_size" -lt "$stream_size" ]; then
	run_check ls -l "$image" "$here"/send-stream.img
	_fail "sending stream size is bigger than old stream"
fi

run_check rm -f -- "$image" "$here"/send-stream.img

cd "$here" || _fail "cannot chdir back to test directory"

run_check_umount_test_dev
