/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.NoAvailableConnectionsException;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.jdbc.ConnectionInitializationCallback;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class OracleConnectionConnectionPool
extends OracleJDBCConnectionPool {
    protected boolean useVanillaObjects = false;
    protected AtomicBoolean isFirstBorrow = new AtomicBoolean(true);
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    public OracleConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter);
    }

    public Connection getConnection(JDBCConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        Connection conn = (Connection)this.borrowConnection(connectionRetrievalInfo).getPhysicalConnection();
        return conn;
    }

    @Override
    public UniversalPooledConnection borrowConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        long giveUp = this.computeBorrowGiveUpTimestamp();
        while (this.isStillOkayToBorrow(giveUp)) {
            ConnectionInitializationCallback connInitCallback;
            OracleUniversalPooledConnection upc = (OracleUniversalPooledConnection)super.borrowConnection(connectionRetrievalInfo);
            try {
                if (this.isDRCPEnabled(upc) && connectionRetrievalInfo.getLabels() == null) {
                    upc.attachServerConnection(null);
                }
            }
            catch (SQLException ea) {
                throw new UniversalConnectionPoolException(ea);
            }
            Object pconn = upc.getPhysicalConnection();
            if (this.isFirstBorrow.get()) {
                this.useVanillaObjects = !pconn.getClass().getName().startsWith("oracle.jdbc.proxy");
                this.isFirstBorrow.set(false);
            }
            upc.getDelegator().setReplayable(!this.useVanillaObjects);
            if (this.useVanillaObjects) {
                this.core.connectionSource().setReplayable(false);
            }
            if (this.getConnectionLabelingCallback() == null && (connInitCallback = this.getConnectionInitializationCallback()) != null) {
                try {
                    connInitCallback.initialize((Connection)pconn);
                }
                catch (SQLException exc) {
                    throw UCPErrorHandler.newUniversalConnectionPoolException(271, exc);
                }
            }
            try {
                ((OracleConnection)pconn).beginRequest();
            }
            catch (SQLRecoverableException e) {
                upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                this.returnConnection(upc);
                continue;
            }
            catch (Throwable exc) {
                throw UCPErrorHandler.newUniversalConnectionPoolException(309, exc);
            }
            return upc;
        }
        throw new NoAvailableConnectionsException();
    }

    public boolean returnConnection(Connection connection) throws UniversalConnectionPoolException {
        boolean res = this.returnUsedPhysicalConnection(connection);
        return res;
    }

    @Override
    public void returnConnection(UniversalPooledConnection upc) throws UniversalConnectionPoolException {
        OracleUniversalPooledConnection oupc = (OracleUniversalPooledConnection)upc;
        if (upc.getStatus() != UniversalPooledConnectionStatus.STATUS_BAD) {
            Object pconn = upc.getPhysicalConnection();
            try {
                ((OracleConnection)pconn).endRequest();
            }
            catch (Throwable exc) {
                UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(310, exc);
                upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                super.returnConnection(upc);
                throw ucpe;
            }
        }
        try {
            if (this.isDRCPEnabled(oupc)) {
                oupc.detachServerConnection(null);
            }
        }
        catch (SQLException ea) {
            throw new UniversalConnectionPoolException(ea);
        }
        super.returnConnection(upc);
    }

    public boolean closeConnection(Connection connection) throws UniversalConnectionPoolException {
        boolean res = this.closeUsedPhysicalConnection(connection);
        return res;
    }

    @Override
    protected boolean needToConfigureConnection(UniversalPooledConnection pc, Properties requestedLabels) throws UniversalConnectionPoolException {
        boolean returnValue = false;
        OracleUniversalPooledConnection oconn = (OracleUniversalPooledConnection)pc;
        try {
            if (this.isDRCPEnabled(pc)) {
                if (this.isDRCPMultiTagEnabled(pc) && this.getDRCPPLSQLCallbackName(pc) != null) {
                    return false;
                }
                returnValue = !oconn.attachServerConnection(requestedLabels);
            }
        }
        catch (SQLException ea) {
            throw new UniversalConnectionPoolException(ea);
        }
        return returnValue;
    }

    @Override
    protected boolean isDRCPEnabled(UniversalPooledConnection pc) throws UniversalConnectionPoolException {
        OracleUniversalPooledConnection oconn = (OracleUniversalPooledConnection)pc;
        try {
            if (this.isDRCPEnabled == null) {
                this.isDRCPEnabled = oconn.isDRCPEnabled();
            }
        }
        catch (SQLException ea) {
            throw new UniversalConnectionPoolException(ea);
        }
        return this.isDRCPEnabled;
    }

    @Override
    protected boolean isDRCPMultiTagEnabled(UniversalPooledConnection pc) throws UniversalConnectionPoolException {
        OracleUniversalPooledConnection oconn = (OracleUniversalPooledConnection)pc;
        try {
            if (this.isDRCPMultiTagEnabled == null) {
                this.isDRCPMultiTagEnabled = oconn.isDRCPMultitagEnabled();
            }
        }
        catch (SQLException ea) {
            throw new UniversalConnectionPoolException(ea);
        }
        return this.isDRCPMultiTagEnabled;
    }

    @Override
    protected String getDRCPPLSQLCallbackName(UniversalPooledConnection pc) throws UniversalConnectionPoolException {
        OracleUniversalPooledConnection oconn = (OracleUniversalPooledConnection)pc;
        if (this.drcpPLSQLCallbackName == null) {
            this.drcpPLSQLCallbackName = oconn.getDRCPPLSQLCallbackName();
        }
        return this.drcpPLSQLCallbackName;
    }

    static {
        try {
            $$$methodRef$$$9 = OracleConnectionConnectionPool.class.getDeclaredConstructor(JDBCConnectionFactoryAdapter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$8 = OracleConnectionConnectionPool.class.getDeclaredMethod("getDRCPPLSQLCallbackName", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$7 = OracleConnectionConnectionPool.class.getDeclaredMethod("isDRCPMultiTagEnabled", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$6 = OracleConnectionConnectionPool.class.getDeclaredMethod("isDRCPEnabled", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$5 = OracleConnectionConnectionPool.class.getDeclaredMethod("needToConfigureConnection", UniversalPooledConnection.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$4 = OracleConnectionConnectionPool.class.getDeclaredMethod("closeConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$3 = OracleConnectionConnectionPool.class.getDeclaredMethod("returnConnection", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$2 = OracleConnectionConnectionPool.class.getDeclaredMethod("returnConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = OracleConnectionConnectionPool.class.getDeclaredMethod("borrowConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = OracleConnectionConnectionPool.class.getDeclaredMethod("getConnection", JDBCConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

