/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.ui;

import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.conn.ConnectionInitiationCallback;
import com.paterva.maltego.chatapi.msg.ChatMessagePropagator;
import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.collab.graph.GraphChatRoom;
import com.paterva.maltego.collab.ui.ChatFilterSettings;
import com.paterva.maltego.collab.ui.MessageColors;
import com.paterva.maltego.util.output.OutputMessage;
import com.paterva.maltego.util.ui.BackgroundWorkerHandle;
import java.awt.Color;
import java.util.logging.Logger;

class BackgroundWorkerCallback
implements ConnectionInitiationCallback {
    private static final Logger LOG = Logger.getLogger(BackgroundWorkerCallback.class.getName());
    private final BackgroundWorkerHandle _handle;
    private final GraphChatRoom _room;
    private int _lastPercent = 0;

    public BackgroundWorkerCallback(GraphChatRoom room, BackgroundWorkerHandle handle) {
        this._handle = handle;
        this._room = room;
    }

    public synchronized void progress(LogMessageLevel level, String message, int percent) {
        if (percent < this._lastPercent) {
            percent = this._lastPercent;
        }
        this.log(level, message);
        this._handle.progress(message, percent);
        this._lastPercent = percent;
    }

    public synchronized void progress(LogMessageLevel level, String message) {
        this.progress(level, message, this._lastPercent);
    }

    public boolean isCancelled() {
        return this._handle.isCancelled();
    }

    public void debug(String message) {
        LOG.fine(message);
        this.log(LogMessageLevel.Debug, message);
    }

    private void log(LogMessageLevel level, String message) {
        if (ChatFilterSettings.isShow(level, this._room != null ? this._room.isDebugMode() : false)) {
            ChatMessagePropagator.logMessage((ChatRoom)this._room, (LogMessageLevel)level, (OutputMessage)new OutputMessage(message), (Color)MessageColors.getColor(level), null);
        }
    }
}

