/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.util.SimpleThreadPoolTask;

public class SimpleThreadPool {
    private static final Logger logger = Logger.getLogger(SimpleThreadPool.class.getName());
    private final LinkedList taskList = new LinkedList();
    private final Set runningSet = new HashSet();
    private final int minThreads;
    private final int maxThreads;
    private final String name;
    private final int idleAliveMillis;
    private final Object taskMonitor = new Object();
    private final ThreadGroup threadGroup;
    private int numThreads = 0;
    private int numIdleThreads = 0;
    private int threadNumber = 0;

    public SimpleThreadPool(String name, int minShrinkToThreads, int maxThreads, int idleAliveMillis) {
        this.minThreads = minShrinkToThreads;
        this.maxThreads = maxThreads;
        this.idleAliveMillis = idleAliveMillis;
        this.name = name;
        this.threadGroup = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(SimpleThreadPoolTask task) {
        Object monitor;
        if (task == null) {
            throw new IllegalArgumentException("null task");
        }
        Object object = monitor = this.taskMonitor;
        synchronized (object) {
            if (this.numIdleThreads == 0) {
                this.addThreadImpl();
            }
            this.taskList.add(task);
            monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(SimpleThreadPoolTask task) {
        Object object = this.taskMonitor;
        synchronized (object) {
            this.taskList.remove(task);
        }
        task.cancel();
    }

    private void addThreadImpl() {
        if (this.numThreads < this.maxThreads) {
            Thread t = new Thread(this.threadGroup, new ThreadRunnable(), this.name + this.threadNumber++);
            t.setDaemon(true);
            t.start();
            ++this.numThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Object object = this.taskMonitor;
        synchronized (object) {
            this.taskList.clear();
            Iterator i = this.runningSet.iterator();
            while (i.hasNext()) {
                ((SimpleThreadPoolTask)i.next()).cancel();
            }
        }
    }

    static /* synthetic */ Object access$100(SimpleThreadPool x0) {
        return x0.taskMonitor;
    }

    static /* synthetic */ LinkedList access$200(SimpleThreadPool x0) {
        return x0.taskList;
    }

    static /* synthetic */ Set access$300(SimpleThreadPool x0) {
        return x0.runningSet;
    }

    static /* synthetic */ int access$400(SimpleThreadPool x0) {
        return x0.idleAliveMillis;
    }

    static /* synthetic */ int access$508(SimpleThreadPool x0) {
        return x0.numIdleThreads++;
    }

    static /* synthetic */ int access$600(SimpleThreadPool x0) {
        return x0.numThreads;
    }

    static /* synthetic */ int access$700(SimpleThreadPool x0) {
        return x0.minThreads;
    }

    static /* synthetic */ int access$610(SimpleThreadPool x0) {
        return x0.numThreads--;
    }

    static /* synthetic */ int access$510(SimpleThreadPool x0) {
        return x0.numIdleThreads--;
    }

    static /* synthetic */ Logger access$800() {
        return logger;
    }

    static /* synthetic */ String access$900(SimpleThreadPool x0) {
        return x0.name;
    }

    private class ThreadRunnable
    implements Runnable {
        private ThreadRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            monitor = SimpleThreadPool.access$100(SimpleThreadPool.this);
            tl = SimpleThreadPool.access$200(SimpleThreadPool.this);
            rs = SimpleThreadPool.access$300(SimpleThreadPool.this);
            iam = SimpleThreadPool.access$400(SimpleThreadPool.this);
            task = null;
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        var6_6 = monitor;
                        synchronized (var6_6) {
                            if (task != null) {
                                rs.remove(task);
                            }
                            SimpleThreadPool.access$508(SimpleThreadPool.this);
                            try {
                                waitBase = System.currentTimeMillis();
                                while (true) {
                                    if (tl.isEmpty()) {
                                        maxWait = (long)iam - (System.currentTimeMillis() - waitBase);
                                        if (maxWait <= 0L) {
                                            if (SimpleThreadPool.access$600(SimpleThreadPool.this) > SimpleThreadPool.access$700(SimpleThreadPool.this)) {
                                                SimpleThreadPool.access$610(SimpleThreadPool.this);
                                                return;
                                            }
                                            waitBase = System.currentTimeMillis();
                                            continue;
                                        }
                                        monitor.wait(maxWait);
                                        continue;
                                    }
                                    break;
                                }
                            }
                            finally {
                                SimpleThreadPool.access$510(SimpleThreadPool.this);
                            }
                            task = (SimpleThreadPoolTask)SimpleThreadPool.access$200(SimpleThreadPool.this).removeFirst();
                            rs.add(task);
                        }
                        currentThread = Thread.currentThread();
                        baseName = currentThread.getName();
                        try {
                            try {
                                currentThread.setName(baseName + ":" + task.toString());
                            }
                            catch (Throwable thrown) {
                                SimpleThreadPool.access$800().log(Level.WARNING, "run(): Unable to set task name.", thrown);
                            }
                            try {
                                task.run();
                            }
                            catch (Throwable thrown) {
                                SimpleThreadPool.access$800().log(Level.SEVERE, "run(): Error in task: " + task + ".", thrown);
                            }
                        }
                        finally {
                            currentThread.setName(baseName);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable thrown) {
                    SimpleThreadPool.access$800().log(Level.SEVERE, "run(): Error in thread pool: " + SimpleThreadPool.access$900(SimpleThreadPool.this) + ".", thrown);
                    continue;
                }
                ** GOTO lbl-1000
                break;
            }
        }
    }
}

