/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates.ui.manager;

import com.paterva.maltego.certificates.CertificateDefinition;
import com.paterva.maltego.certificates.CertificateRepository;
import com.paterva.maltego.certificates.CertificateUtils;
import com.paterva.maltego.certificates.ui.manager.AllCertificatesChildFactory;
import com.paterva.maltego.certificates.ui.manager.CertificateNode;
import com.paterva.maltego.certificates.ui.manager.EmptyCertificateView;
import com.paterva.maltego.certificates.ui.manager.ExpiresDateTableCellRenderer;
import com.paterva.maltego.certificates.ui.view.CertificateTabbedView;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.SlownessDetector;
import com.paterva.maltego.util.repository.RepositoryEvent;
import com.paterva.maltego.util.repository.RepositoryListener;
import com.paterva.maltego.util.ui.BusySpinnerPanel;
import com.paterva.maltego.util.ui.components.HeadingTextAndIcon;
import com.paterva.maltego.util.ui.components.LabelWithBackground;
import com.paterva.maltego.util.ui.outline.OutlineViewPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.swing.outline.Outline;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class CertificateManagerTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    private static final String TEST_BUTTON = "testButton";
    private static final String TEST_SPINNER = "testSpinner";
    private final CardLayout _cardLayout = new CardLayout();
    private final ExplorerManager _explorer = new ExplorerManager();
    private final OutlineViewPanel _view;
    private final CertificateTabbedView _tabbedView;
    private CertificateRepositoryListener _repoListener;
    private final EmptyCertificateView _emptyCertificatePanel = new EmptyCertificateView();
    private HeadingTextAndIcon _headingTextIcon;
    private JPanel _testButtonContainer;
    private JLabel _testLabel;
    private JTextField _testUrlTextField;
    private JSplitPane _topBottomSplit;
    private JPanel jPanel1;

    public CertificateManagerTopComponent() {
        this.initComponents();
        this._view = new OutlineViewPanel("Certificate");
        this._tabbedView = new CertificateTabbedView(this);
        this._headingTextIcon.setText("The certificates listed here are part of Maltego's certificate store and do not form part of the Operating System or Java certificates. You can manually add certificates using the Import Certificates button.");
        this._headingTextIcon.setTextTooltip("<html>When a certificate is encountered by Maltego that is untrusted in the list below, <br>or has Subject Alternative Names (SANs) or a subject Common Name (CN) that does <br>not match the requested URL, a prompt may be displayed to ask whether you want to <br>trust the certificate or not. Answering \"Trust\" or \"Don't Trust\" may add the <br>certificate to the list below. Afterwards, requests to URLs that use the certificate <br>will automatically be trusted or blocked depending on the state chosen and whether <br>the certificate SANs or subject CN match the requested URL. The \"Trusted\"/\"Untrusted\" <br>state of a certificate can be toggled using the checkbox next to each certificate. <br>You can also manually add certificates using the Import Certificates button. The <br>certificates listed here are part of Maltego's certificate store and do not form part <br>of the Operating System or Java certificates.</html>");
        Image image = ImageUtilities.loadImage((String)"com/paterva/maltego/certificates/ui/resources/Certificate48.png");
        this._headingTextIcon.addIcon((Object)image);
        this._headingTextIcon.setInsets(new Insets(0, 0, 6, 0));
        this._topBottomSplit.setTopComponent((Component)this._view);
        this._topBottomSplit.setBottomComponent(this._tabbedView);
        AllCertificatesChildFactory allCertificatesChildFactory = new AllCertificatesChildFactory();
        AbstractNode root = new AbstractNode(Children.create((ChildFactory)allCertificatesChildFactory, (boolean)false));
        this._explorer.setRootContext((Node)root);
        this._view.getView().setProperties(new Node.Property[]{CertificateNode.status(), CertificateNode.isca(), CertificateNode.subject(), CertificateNode.issuer(), CertificateNode.expires()});
        Outline outline = this._view.getView().getOutline();
        outline.getTableHeader().setReorderingAllowed(false);
        TableColumnModel columns = outline.getColumnModel();
        columns.getColumn(0).setPreferredWidth(210);
        columns.getColumn(1).setPreferredWidth(80);
        columns.getColumn(2).setPreferredWidth(60);
        columns.getColumn(3).setPreferredWidth(150);
        columns.getColumn(4).setPreferredWidth(150);
        TableColumn expiresDateCol = columns.getColumn(5);
        expiresDateCol.setPreferredWidth(200);
        expiresDateCol.setCellRenderer(new ExpiresDateTableCellRenderer());
        ActionMap map = this.getActionMap();
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this._explorer, (ActionMap)map));
        this.addActions();
        JButton testButton = new JButton("Test");
        testButton.addActionListener(ignored -> this.testClicked());
        this._testButtonContainer.add((Component)testButton, TEST_BUTTON);
        BusySpinnerPanel spinner = new BusySpinnerPanel(15);
        spinner.setPreferredSize(testButton.getPreferredSize());
        spinner.setBackground(new JPanel().getBackground());
        this._testButtonContainer.add((Component)spinner, TEST_SPINNER);
    }

    public void addNotify() {
        super.addNotify();
        this._repoListener = new CertificateRepositoryListener();
        CertificateRepository.getDefault().addRepositoryListener((RepositoryListener)this._repoListener);
        this.selectFirstCertificate();
        this.bindExplorer();
        this.render();
    }

    public void removeNotify() {
        CertificateRepository.getDefault().removeRepositoryListener((RepositoryListener)this._repoListener);
        this._repoListener = null;
        super.removeNotify();
    }

    private void bindExplorer() {
        this._explorer.addPropertyChangeListener(evt -> {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                this.render();
            }
        });
    }

    public void selectFirstCertificate() {
        Node[] nodes = this.getNodes();
        if (nodes.length > 0) {
            this.select(nodes[0]);
        }
    }

    public void selectCertificate(X509Certificate cert) {
        for (Node node : this.getNodes()) {
            CertificateDefinition certDefinition = (CertificateDefinition)node.getLookup().lookup(CertificateDefinition.class);
            if (!cert.equals(certDefinition.getCertificate())) continue;
            this.select(node);
            break;
        }
    }

    private void select(Node node) {
        try {
            this._explorer.setSelectedNodes(new Node[0]);
            this._explorer.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Node[] getNodes() {
        return this._explorer.getRootContext().getChildren().getNodes();
    }

    private void render() {
        JPanel requiredComponent;
        Node[] nodes = this._explorer.getSelectedNodes();
        if (nodes.length < 1) {
            requiredComponent = this._emptyCertificatePanel;
            this._emptyCertificatePanel.setLabelText("<No Certificates>");
        } else if (nodes.length == 1) {
            requiredComponent = this._tabbedView;
        } else {
            requiredComponent = this._emptyCertificatePanel;
            this._emptyCertificatePanel.setLabelText("<Multiple Certificates>");
        }
        Component bottomComponent = this._topBottomSplit.getBottomComponent();
        if (!bottomComponent.equals(requiredComponent)) {
            this._topBottomSplit.setBottomComponent(requiredComponent);
        }
    }

    private void addActions() {
        List actions = Utilities.actionsForPath((String)"Maltego/ContextActions/CertificateManager");
        for (int i = actions.size() - 1; i >= 0; --i) {
            Action action = (Action)actions.get(i);
            if (action instanceof ContextAwareAction) {
                action = ((ContextAwareAction)action).createContextAwareInstance(this.getLookup());
            }
            this._view.addToToolbarLeft(action);
        }
    }

    public ExplorerManager getExplorerManager() {
        return this._explorer;
    }

    private void initComponents() {
        this._headingTextIcon = new HeadingTextAndIcon();
        this._topBottomSplit = new JSplitPane();
        this.jPanel1 = new JPanel();
        this._testLabel = new LabelWithBackground();
        this._testUrlTextField = new JTextField();
        this._testButtonContainer = new JPanel(this._cardLayout);
        this.setMinimumSize(new Dimension(400, 400));
        this.setPreferredSize(new Dimension(780, 600));
        this.setLayout(new BorderLayout());
        this.add((Component)this._headingTextIcon, "North");
        this._topBottomSplit.setDividerLocation(80);
        this._topBottomSplit.setOrientation(0);
        this._topBottomSplit.setMinimumSize(new Dimension(500, 500));
        this.add(this._topBottomSplit, "Center");
        this.jPanel1.setLayout(new GridBagLayout());
        this._testLabel.setText(NbBundle.getMessage(CertificateManagerTopComponent.class, (String)"CertificateManagerTopComponent._testLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 6, 3, 0);
        this.jPanel1.add((Component)this._testLabel, gridBagConstraints);
        this._testUrlTextField.setText(NbBundle.getMessage(CertificateManagerTopComponent.class, (String)"CertificateManagerTopComponent._testUrlTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.jPanel1.add((Component)this._testUrlTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 6);
        this.jPanel1.add((Component)this._testButtonContainer, gridBagConstraints);
        this.add(this.jPanel1, "Last");
    }

    private void testClicked() {
        String urlStr = this._testUrlTextField.getText();
        this._cardLayout.show(this._testButtonContainer, TEST_SPINNER);
        SlownessDetector.setEnabled((boolean)false);
        new Thread(() -> {
            try {
                int certsBefore;
                String errorMsg;
                CertificateRepository certRepo = CertificateRepository.getDefault();
                boolean success = false;
                do {
                    certsBefore = certRepo.getAllDisplay().size();
                    errorMsg = null;
                    try {
                        URL url = new URL(urlStr);
                        success = CertificateUtils.testUrl((URL)url, (CertificateRepository)certRepo, (boolean)false, (boolean)true, null);
                    }
                    catch (Exception ex) {
                        NormalException.logStackTrace((Throwable)ex);
                        errorMsg = "Request failed with an error.";
                        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
                            errorMsg = errorMsg + "\n" + cause.getClass().getSimpleName() + ": " + cause.getMessage();
                        }
                    }
                } while (errorMsg == null && certsBefore == certRepo.getAllDisplay().size() && !success);
                String errorMsgUI = errorMsg;
                SwingUtilities.invokeLater(() -> {
                    this._cardLayout.show(this._testButtonContainer, TEST_BUTTON);
                    boolean error = errorMsgUI != null;
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)(error ? errorMsgUI : "Made a successful request to the URL " + urlStr));
                    nd.setTitle(error ? "Error" : "Success");
                    nd.setMessageType(error ? 2 : 1);
                    Object userAction = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    if (NotifyDescriptor.OK_OPTION.equals(userAction) || NotifyDescriptor.CLOSED_OPTION.equals(userAction)) {
                        SlownessDetector.setEnabled((boolean)true);
                    }
                });
            }
            catch (Exception ex) {
                this._cardLayout.show(this._testButtonContainer, TEST_BUTTON);
                SlownessDetector.setEnabled((boolean)true);
                Exceptions.printStackTrace((Throwable)ex);
            }
        }, "Test URL Certificate").start();
    }

    private class CertificateRepositoryListener
    implements RepositoryListener {
        private CertificateRepositoryListener() {
        }

        public void onItemAdded(RepositoryEvent evt) {
            CertificateManagerTopComponent.this.selectCertificate((X509Certificate)evt.getItem());
            CertificateManagerTopComponent.this.render();
        }

        public void onItemChanged(RepositoryEvent evt) {
            CertificateManagerTopComponent.this.selectCertificate((X509Certificate)evt.getItem());
            CertificateManagerTopComponent.this.render();
        }

        public void onItemRemoved(RepositoryEvent evt) {
            CertificateManagerTopComponent.this.selectFirstCertificate();
            CertificateManagerTopComponent.this.render();
        }
    }
}

