/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import com.paterva.maltego.ui.graph.ViewControlAdapter;
import com.paterva.maltego.ui.graph.ViewDescriptor;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.impl.GraphViewElement;
import com.paterva.maltego.ui.graph.impl.MasterGraphViewElement;
import com.paterva.maltego.ui.graph.impl.SlaveGraphViewElement;
import java.awt.Image;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.windows.CloneableTopComponent;

public class GraphViewFactory {
    public static CloneableTopComponent createViews(DataObject dobj) {
        return GraphViewFactory.createViews(dobj, null);
    }

    public static CloneableTopComponent createViews(DataObject dobj, CloseOperationHandler closeHandler) {
        Collection descriptors = Lookup.getDefault().lookupAll(ViewDescriptor.class);
        if (descriptors.size() > 0) {
            ViewDescriptor[] descriptorArray = descriptors.toArray(new ViewDescriptor[descriptors.size()]);
            Arrays.sort(descriptorArray, new GraphViewComparator());
            MultiViewDescription[] descriptions = new MultiViewDescription[descriptorArray.length];
            descriptions[0] = new MasterGraphViewDescription(dobj, descriptorArray[0]);
            for (int i = 1; i < descriptions.length; ++i) {
                descriptions[i] = new GraphViewDescription(dobj, descriptorArray[i]);
            }
            CloneableTopComponent tc = MultiViewFactory.createCloneableMultiView((MultiViewDescription[])descriptions, (MultiViewDescription)descriptions[0], (CloseOperationHandler)closeHandler);
            return tc;
        }
        return null;
    }

    private static class GraphViewComparator
    implements Comparator<ViewDescriptor> {
        private GraphViewComparator() {
        }

        @Override
        public int compare(ViewDescriptor o1, ViewDescriptor o2) {
            if (o1.getPosition() > o2.getPosition()) {
                return 1;
            }
            if (o1.getPosition() < o2.getPosition()) {
                return -1;
            }
            return 0;
        }
    }

    private static class MasterGraphViewDescription
    extends GraphViewDescription {
        private static final long serialVersionUID = 1L;

        public MasterGraphViewDescription(DataObject dobj, ViewDescriptor delegate) {
            super(dobj, delegate);
        }

        @Override
        public MultiViewElement createElement() {
            MasterGraphViewElement gve = new MasterGraphViewElement(this.getDataObject(), this.createControlAdapter());
            this.initElement(gve);
            return gve;
        }
    }

    private static class GraphViewDescription
    implements MultiViewDescription,
    Serializable {
        private final ViewDescriptor _delegate;
        private final DataObject _dobj;
        private static final long serialVersionUID = 1L;

        public GraphViewDescription(DataObject dobj, ViewDescriptor delegate) {
            this._delegate = delegate;
            this._dobj = dobj;
        }

        public DataObject getDataObject() {
            return this._dobj;
        }

        public int getPersistenceType() {
            return 2;
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public String getDisplayName() {
            return this._delegate.getDisplayName();
        }

        public Image getIcon() {
            return null;
        }

        public String preferredID() {
            return this._delegate.getName();
        }

        public MultiViewElement createElement() {
            SlaveGraphViewElement gve = new SlaveGraphViewElement(this.getDataObject(), this.createControlAdapter());
            this.initElement(gve);
            return gve;
        }

        protected ViewControlAdapter createControlAdapter() {
            return this._delegate.createComponent(((GraphDataObject)this._dobj).getGraphID());
        }

        protected void initElement(GraphViewElement gve) {
            gve.init(this._delegate);
        }
    }
}

