/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.laf.debug;

import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.Preferences;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class MaltegoLAFDebug {
    private static final String PREF_PROPS = "lafProperties";
    private static final String PREF_DIR = "maltego.laf.debug.dir";

    public static void save() {
        try {
            Preferences prefs = NbPreferences.forModule(MaltegoLAFDebug.class);
            MaltegoLAF laf = MaltegoLAF.getDefault();
            Properties properties = new Properties();
            for (String key : laf.getKeys()) {
                String value = laf.getRawString(key);
                properties.put(key, value);
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            properties.store(os, null);
            prefs.putByteArray(PREF_PROPS, os.toByteArray());
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void load() {
        try {
            Preferences prefs = NbPreferences.forModule(MaltegoLAFDebug.class);
            byte[] bytes = prefs.getByteArray(PREF_PROPS, null);
            if (bytes != null) {
                MaltegoLAF laf = MaltegoLAF.getDefault();
                Properties properties = new Properties();
                properties.load(new ByteArrayInputStream(bytes));
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    laf.setRawString(key, value);
                }
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void reset() {
        Preferences prefs = NbPreferences.forModule(MaltegoLAFDebug.class);
        prefs.remove(PREF_PROPS);
        MaltegoLAF.getDefault().reset();
    }

    public static File getDir() {
        Preferences prefs = NbPreferences.forModule(MaltegoLAFDebug.class);
        String dir = prefs.get(PREF_DIR, null);
        return dir != null ? new File(dir) : new File("");
    }

    public static void setDir(File dir) {
        Preferences prefs = NbPreferences.forModule(MaltegoLAFDebug.class);
        prefs.put(PREF_DIR, dir.getAbsolutePath());
    }
}

