// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// This file holds the expected results for the instructions tested by
// test-simulator-aarch64.
//
// If you update input lists in test-simulator-inputs-aarch64.h, or add a new
// test to test-simulator-aarch64.cc, please run
// tools/generate_simulator_traces.py on a reference platform to regenerate
// this file and trace files.
//

#ifndef VIXL_TEST_AARCH64_SIMULATOR_TRACES_AARCH64_H_
#define VIXL_TEST_AARCH64_SIMULATOR_TRACES_AARCH64_H_

extern "C" {
#include <stdint.h>
}

// To add a new simulator test to test-simulator-aarch64.cc, add placeholder
// array(s) below to build test-simulator-aarch64 for reference platform. Then,
// run tools/generate_simulator_traces.py on a reference platform to regenerate
// this file and traces files.

// ---------------------------------------------------------------------
// ADD DUMMY ARRAYS FOR NEW SIMULATOR TEST HERE.
// ---------------------------------------------------------------------
const uint64_t kExpected_placeholder_64[] = {0};
const size_t kExpectedCount_placeholder_64 = 0;

const uint32_t kExpected_placeholder_32[] = {0};
const size_t kExpectedCount_placeholder_32 = 0;

// ---------------------------------------------------------------------
// Simulator test trace output files.
// ---------------------------------------------------------------------


#include "aarch64/traces/sim-abs-16b-trace-aarch64.h"
#include "aarch64/traces/sim-abs-2d-trace-aarch64.h"
#include "aarch64/traces/sim-abs-2s-trace-aarch64.h"
#include "aarch64/traces/sim-abs-4h-trace-aarch64.h"
#include "aarch64/traces/sim-abs-4s-trace-aarch64.h"
#include "aarch64/traces/sim-abs-8b-trace-aarch64.h"
#include "aarch64/traces/sim-abs-8h-trace-aarch64.h"
#include "aarch64/traces/sim-abs-d-trace-aarch64.h"
#include "aarch64/traces/sim-add-16b-trace-aarch64.h"
#include "aarch64/traces/sim-add-2d-trace-aarch64.h"
#include "aarch64/traces/sim-add-2s-trace-aarch64.h"
#include "aarch64/traces/sim-add-4h-trace-aarch64.h"
#include "aarch64/traces/sim-add-4s-trace-aarch64.h"
#include "aarch64/traces/sim-add-8b-trace-aarch64.h"
#include "aarch64/traces/sim-add-8h-trace-aarch64.h"
#include "aarch64/traces/sim-add-d-trace-aarch64.h"
#include "aarch64/traces/sim-addhn-2s-trace-aarch64.h"
#include "aarch64/traces/sim-addhn-4h-trace-aarch64.h"
#include "aarch64/traces/sim-addhn-8b-trace-aarch64.h"
#include "aarch64/traces/sim-addhn2-16b-trace-aarch64.h"
#include "aarch64/traces/sim-addhn2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-addhn2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-addp-16b-trace-aarch64.h"
#include "aarch64/traces/sim-addp-2d-trace-aarch64.h"
#include "aarch64/traces/sim-addp-2s-trace-aarch64.h"
#include "aarch64/traces/sim-addp-4h-trace-aarch64.h"
#include "aarch64/traces/sim-addp-4s-trace-aarch64.h"
#include "aarch64/traces/sim-addp-8b-trace-aarch64.h"
#include "aarch64/traces/sim-addp-8h-trace-aarch64.h"
#include "aarch64/traces/sim-addp-scalar-trace-aarch64.h"
#include "aarch64/traces/sim-addv-b-16b-trace-aarch64.h"
#include "aarch64/traces/sim-addv-b-8b-trace-aarch64.h"
#include "aarch64/traces/sim-addv-h-4h-trace-aarch64.h"
#include "aarch64/traces/sim-addv-h-8h-trace-aarch64.h"
#include "aarch64/traces/sim-addv-s-4s-trace-aarch64.h"
#include "aarch64/traces/sim-and--16b-trace-aarch64.h"
#include "aarch64/traces/sim-and--8b-trace-aarch64.h"
#include "aarch64/traces/sim-bic-16b-trace-aarch64.h"
#include "aarch64/traces/sim-bic-8b-trace-aarch64.h"
#include "aarch64/traces/sim-bif-16b-trace-aarch64.h"
#include "aarch64/traces/sim-bif-8b-trace-aarch64.h"
#include "aarch64/traces/sim-bit-16b-trace-aarch64.h"
#include "aarch64/traces/sim-bit-8b-trace-aarch64.h"
#include "aarch64/traces/sim-bsl-16b-trace-aarch64.h"
#include "aarch64/traces/sim-bsl-8b-trace-aarch64.h"
#include "aarch64/traces/sim-cls-16b-trace-aarch64.h"
#include "aarch64/traces/sim-cls-2s-trace-aarch64.h"
#include "aarch64/traces/sim-cls-4h-trace-aarch64.h"
#include "aarch64/traces/sim-cls-4s-trace-aarch64.h"
#include "aarch64/traces/sim-cls-8b-trace-aarch64.h"
#include "aarch64/traces/sim-cls-8h-trace-aarch64.h"
#include "aarch64/traces/sim-clz-16b-trace-aarch64.h"
#include "aarch64/traces/sim-clz-2s-trace-aarch64.h"
#include "aarch64/traces/sim-clz-4h-trace-aarch64.h"
#include "aarch64/traces/sim-clz-4s-trace-aarch64.h"
#include "aarch64/traces/sim-clz-8b-trace-aarch64.h"
#include "aarch64/traces/sim-clz-8h-trace-aarch64.h"
#include "aarch64/traces/sim-cmeq-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmeq-16b-trace-aarch64.h"
#include "aarch64/traces/sim-cmeq-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmeq-2d-trace-aarch64.h"
#include "aarch64/traces/sim-cmeq-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmeq-2s-trace-aarch64.h"
#include "aarch64/traces/sim-cmeq-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmeq-4h-trace-aarch64.h"
#include "aarch64/traces/sim-cmeq-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmeq-4s-trace-aarch64.h"
#include "aarch64/traces/sim-cmeq-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmeq-8b-trace-aarch64.h"
#include "aarch64/traces/sim-cmeq-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmeq-8h-trace-aarch64.h"
#include "aarch64/traces/sim-cmeq-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmeq-d-trace-aarch64.h"
#include "aarch64/traces/sim-cmge-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmge-16b-trace-aarch64.h"
#include "aarch64/traces/sim-cmge-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmge-2d-trace-aarch64.h"
#include "aarch64/traces/sim-cmge-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmge-2s-trace-aarch64.h"
#include "aarch64/traces/sim-cmge-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmge-4h-trace-aarch64.h"
#include "aarch64/traces/sim-cmge-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmge-4s-trace-aarch64.h"
#include "aarch64/traces/sim-cmge-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmge-8b-trace-aarch64.h"
#include "aarch64/traces/sim-cmge-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmge-8h-trace-aarch64.h"
#include "aarch64/traces/sim-cmge-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmge-d-trace-aarch64.h"
#include "aarch64/traces/sim-cmgt-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmgt-16b-trace-aarch64.h"
#include "aarch64/traces/sim-cmgt-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmgt-2d-trace-aarch64.h"
#include "aarch64/traces/sim-cmgt-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmgt-2s-trace-aarch64.h"
#include "aarch64/traces/sim-cmgt-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmgt-4h-trace-aarch64.h"
#include "aarch64/traces/sim-cmgt-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmgt-4s-trace-aarch64.h"
#include "aarch64/traces/sim-cmgt-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmgt-8b-trace-aarch64.h"
#include "aarch64/traces/sim-cmgt-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmgt-8h-trace-aarch64.h"
#include "aarch64/traces/sim-cmgt-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmgt-d-trace-aarch64.h"
#include "aarch64/traces/sim-cmhi-16b-trace-aarch64.h"
#include "aarch64/traces/sim-cmhi-2d-trace-aarch64.h"
#include "aarch64/traces/sim-cmhi-2s-trace-aarch64.h"
#include "aarch64/traces/sim-cmhi-4h-trace-aarch64.h"
#include "aarch64/traces/sim-cmhi-4s-trace-aarch64.h"
#include "aarch64/traces/sim-cmhi-8b-trace-aarch64.h"
#include "aarch64/traces/sim-cmhi-8h-trace-aarch64.h"
#include "aarch64/traces/sim-cmhi-d-trace-aarch64.h"
#include "aarch64/traces/sim-cmhs-16b-trace-aarch64.h"
#include "aarch64/traces/sim-cmhs-2d-trace-aarch64.h"
#include "aarch64/traces/sim-cmhs-2s-trace-aarch64.h"
#include "aarch64/traces/sim-cmhs-4h-trace-aarch64.h"
#include "aarch64/traces/sim-cmhs-4s-trace-aarch64.h"
#include "aarch64/traces/sim-cmhs-8b-trace-aarch64.h"
#include "aarch64/traces/sim-cmhs-8h-trace-aarch64.h"
#include "aarch64/traces/sim-cmhs-d-trace-aarch64.h"
#include "aarch64/traces/sim-cmle-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmle-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmle-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmle-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmle-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmle-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmle-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmle-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmlt-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmlt-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmlt-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmlt-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmlt-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmlt-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmlt-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmlt-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-cmtst-16b-trace-aarch64.h"
#include "aarch64/traces/sim-cmtst-2d-trace-aarch64.h"
#include "aarch64/traces/sim-cmtst-2s-trace-aarch64.h"
#include "aarch64/traces/sim-cmtst-4h-trace-aarch64.h"
#include "aarch64/traces/sim-cmtst-4s-trace-aarch64.h"
#include "aarch64/traces/sim-cmtst-8b-trace-aarch64.h"
#include "aarch64/traces/sim-cmtst-8h-trace-aarch64.h"
#include "aarch64/traces/sim-cmtst-d-trace-aarch64.h"
#include "aarch64/traces/sim-cnt-16b-trace-aarch64.h"
#include "aarch64/traces/sim-cnt-8b-trace-aarch64.h"
#include "aarch64/traces/sim-dup-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-dup-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-dup-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-dup-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-dup-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-dup-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-dup-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-dup-b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-dup-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-dup-h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-dup-s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-eor-16b-trace-aarch64.h"
#include "aarch64/traces/sim-eor-8b-trace-aarch64.h"
#include "aarch64/traces/sim-fabd-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fabd-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fabd-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fabd-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fabd-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fabd-d-trace-aarch64.h"
#include "aarch64/traces/sim-fabd-h-trace-aarch64.h"
#include "aarch64/traces/sim-fabd-s-trace-aarch64.h"
#include "aarch64/traces/sim-fabs-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fabs-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fabs-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fabs-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fabs-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fabs-d-trace-aarch64.h"
#include "aarch64/traces/sim-fabs-h-trace-aarch64.h"
#include "aarch64/traces/sim-fabs-s-trace-aarch64.h"
#include "aarch64/traces/sim-facge-2d-trace-aarch64.h"
#include "aarch64/traces/sim-facge-2s-trace-aarch64.h"
#include "aarch64/traces/sim-facge-4h-trace-aarch64.h"
#include "aarch64/traces/sim-facge-4s-trace-aarch64.h"
#include "aarch64/traces/sim-facge-8h-trace-aarch64.h"
#include "aarch64/traces/sim-facge-d-trace-aarch64.h"
#include "aarch64/traces/sim-facge-h-trace-aarch64.h"
#include "aarch64/traces/sim-facge-s-trace-aarch64.h"
#include "aarch64/traces/sim-facgt-2d-trace-aarch64.h"
#include "aarch64/traces/sim-facgt-2s-trace-aarch64.h"
#include "aarch64/traces/sim-facgt-4h-trace-aarch64.h"
#include "aarch64/traces/sim-facgt-4s-trace-aarch64.h"
#include "aarch64/traces/sim-facgt-8h-trace-aarch64.h"
#include "aarch64/traces/sim-facgt-d-trace-aarch64.h"
#include "aarch64/traces/sim-facgt-h-trace-aarch64.h"
#include "aarch64/traces/sim-facgt-s-trace-aarch64.h"
#include "aarch64/traces/sim-fadd-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fadd-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fadd-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fadd-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fadd-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fadd-d-trace-aarch64.h"
#include "aarch64/traces/sim-fadd-h-trace-aarch64.h"
#include "aarch64/traces/sim-fadd-s-trace-aarch64.h"
#include "aarch64/traces/sim-faddp-2d-trace-aarch64.h"
#include "aarch64/traces/sim-faddp-2s-trace-aarch64.h"
#include "aarch64/traces/sim-faddp-4h-trace-aarch64.h"
#include "aarch64/traces/sim-faddp-4s-trace-aarch64.h"
#include "aarch64/traces/sim-faddp-8h-trace-aarch64.h"
#include "aarch64/traces/sim-faddp-d-trace-aarch64.h"
#include "aarch64/traces/sim-faddp-h-trace-aarch64.h"
#include "aarch64/traces/sim-faddp-s-trace-aarch64.h"
#include "aarch64/traces/sim-fcmeq-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmeq-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fcmeq-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmeq-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fcmeq-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmeq-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fcmeq-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmeq-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fcmeq-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmeq-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fcmeq-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmeq-d-trace-aarch64.h"
#include "aarch64/traces/sim-fcmeq-h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmeq-h-trace-aarch64.h"
#include "aarch64/traces/sim-fcmeq-s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmeq-s-trace-aarch64.h"
#include "aarch64/traces/sim-fcmge-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmge-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fcmge-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmge-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fcmge-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmge-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fcmge-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmge-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fcmge-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmge-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fcmge-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmge-d-trace-aarch64.h"
#include "aarch64/traces/sim-fcmge-h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmge-h-trace-aarch64.h"
#include "aarch64/traces/sim-fcmge-s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmge-s-trace-aarch64.h"
#include "aarch64/traces/sim-fcmgt-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmgt-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fcmgt-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmgt-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fcmgt-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmgt-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fcmgt-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmgt-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fcmgt-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmgt-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fcmgt-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmgt-d-trace-aarch64.h"
#include "aarch64/traces/sim-fcmgt-h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmgt-h-trace-aarch64.h"
#include "aarch64/traces/sim-fcmgt-s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmgt-s-trace-aarch64.h"
#include "aarch64/traces/sim-fcmle-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmle-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmle-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmle-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmle-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmle-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmle-h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmle-s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmlt-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmlt-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmlt-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmlt-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmlt-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmlt-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmlt-h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmlt-s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcmp-d-trace-aarch64.h"
#include "aarch64/traces/sim-fcmp-dz-trace-aarch64.h"
#include "aarch64/traces/sim-fcmp-s-trace-aarch64.h"
#include "aarch64/traces/sim-fcmp-sz-trace-aarch64.h"
#include "aarch64/traces/sim-fcvt-ds-trace-aarch64.h"
#include "aarch64/traces/sim-fcvt-sd-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtas-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtas-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtas-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtas-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtas-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtas-d-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtas-h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtas-s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtas-wd-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtas-wh-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtas-ws-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtas-xd-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtas-xh-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtas-xs-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtau-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtau-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtau-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtau-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtau-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtau-d-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtau-h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtau-s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtau-wd-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtau-wh-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtau-ws-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtau-xd-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtau-xh-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtau-xs-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtl-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtl-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtl2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtl2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtms-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtms-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtms-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtms-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtms-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtms-d-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtms-h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtms-s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtms-wd-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtms-wh-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtms-ws-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtms-xd-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtms-xh-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtms-xs-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtmu-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtmu-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtmu-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtmu-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtmu-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtmu-d-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtmu-h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtmu-s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtmu-wd-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtmu-wh-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtmu-ws-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtmu-xd-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtmu-xh-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtmu-xs-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtn-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtn-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtn2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtn2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtns-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtns-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtns-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtns-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtns-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtns-d-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtns-h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtns-s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtns-wd-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtns-wh-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtns-ws-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtns-xd-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtns-xh-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtns-xs-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtnu-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtnu-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtnu-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtnu-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtnu-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtnu-d-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtnu-h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtnu-s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtnu-wd-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtnu-wh-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtnu-ws-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtnu-xd-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtnu-xh-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtnu-xs-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtps-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtps-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtps-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtps-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtps-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtps-d-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtps-h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtps-s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtpu-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtpu-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtpu-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtpu-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtpu-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtpu-d-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtpu-h-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtpu-s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtxn-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtxn-scalar-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtxn2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzs-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzs-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzs-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzs-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzs-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzs-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzs-h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzs-s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzs-wd-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzs-wh-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzs-ws-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzs-xd-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzs-xh-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzs-xs-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzu-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzu-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzu-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzu-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzu-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzu-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzu-h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzu-s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzu-wd-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzu-wh-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzu-ws-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzu-xd-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzu-xh-trace-aarch64.h"
#include "aarch64/traces/sim-fcvtzu-xs-trace-aarch64.h"
#include "aarch64/traces/sim-fdiv-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fdiv-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fdiv-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fdiv-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fdiv-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fdiv-d-trace-aarch64.h"
#include "aarch64/traces/sim-fdiv-h-trace-aarch64.h"
#include "aarch64/traces/sim-fdiv-s-trace-aarch64.h"
#include "aarch64/traces/sim-fjcvtzs-wd-trace-aarch64.h"
#include "aarch64/traces/sim-fmadd-d-trace-aarch64.h"
#include "aarch64/traces/sim-fmadd-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmadd-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmax-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fmax-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fmax-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fmax-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fmax-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fmax-d-trace-aarch64.h"
#include "aarch64/traces/sim-fmax-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmax-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxnm-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxnm-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxnm-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxnm-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxnm-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxnm-d-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxnm-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxnm-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxnmp-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxnmp-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxnmp-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxnmp-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxnmp-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxnmp-d-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxnmp-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxnmp-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxnmv-h-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxnmv-h-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxnmv-s-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxp-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxp-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxp-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxp-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxp-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxp-d-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxp-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxp-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxv-h-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxv-h-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fmaxv-s-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fmin-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fmin-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fmin-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fmin-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fmin-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fmin-d-trace-aarch64.h"
#include "aarch64/traces/sim-fmin-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmin-s-trace-aarch64.h"
#include "aarch64/traces/sim-fminnm-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fminnm-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fminnm-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fminnm-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fminnm-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fminnm-d-trace-aarch64.h"
#include "aarch64/traces/sim-fminnm-h-trace-aarch64.h"
#include "aarch64/traces/sim-fminnm-s-trace-aarch64.h"
#include "aarch64/traces/sim-fminnmp-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fminnmp-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fminnmp-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fminnmp-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fminnmp-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fminnmp-d-trace-aarch64.h"
#include "aarch64/traces/sim-fminnmp-h-trace-aarch64.h"
#include "aarch64/traces/sim-fminnmp-s-trace-aarch64.h"
#include "aarch64/traces/sim-fminnmv-h-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fminnmv-h-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fminnmv-s-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fminp-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fminp-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fminp-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fminp-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fminp-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fminp-d-trace-aarch64.h"
#include "aarch64/traces/sim-fminp-h-trace-aarch64.h"
#include "aarch64/traces/sim-fminp-s-trace-aarch64.h"
#include "aarch64/traces/sim-fminv-h-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fminv-h-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fminv-s-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fmla-2d-2d-d-trace-aarch64.h"
#include "aarch64/traces/sim-fmla-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fmla-2s-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmla-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fmla-4h-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmla-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fmla-4s-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmla-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fmla-8h-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmla-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fmla-d-d-d-trace-aarch64.h"
#include "aarch64/traces/sim-fmla-h-h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmla-s-s-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmlal-2s-2h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmlal-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fmlal-4s-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmlal-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fmlal2-2s-2h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmlal2-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fmlal2-4s-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmlal2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fmls-2d-2d-d-trace-aarch64.h"
#include "aarch64/traces/sim-fmls-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fmls-2s-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmls-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fmls-4h-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmls-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fmls-4s-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmls-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fmls-8h-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmls-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fmls-d-d-d-trace-aarch64.h"
#include "aarch64/traces/sim-fmls-h-h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmls-s-s-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmlsl-2s-2h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmlsl-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fmlsl-4s-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmlsl-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fmlsl2-2s-2h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmlsl2-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fmlsl2-4s-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmlsl2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fmov-d-trace-aarch64.h"
#include "aarch64/traces/sim-fmov-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmov-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmsub-d-trace-aarch64.h"
#include "aarch64/traces/sim-fmsub-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmsub-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmul-2d-2d-d-trace-aarch64.h"
#include "aarch64/traces/sim-fmul-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fmul-2s-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmul-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fmul-4h-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmul-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fmul-4s-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmul-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fmul-8h-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmul-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fmul-d-d-d-trace-aarch64.h"
#include "aarch64/traces/sim-fmul-d-trace-aarch64.h"
#include "aarch64/traces/sim-fmul-h-h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmul-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmul-s-s-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmul-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmulx-2d-2d-d-trace-aarch64.h"
#include "aarch64/traces/sim-fmulx-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fmulx-2s-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmulx-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fmulx-4h-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmulx-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fmulx-4s-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmulx-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fmulx-8h-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmulx-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fmulx-d-d-d-trace-aarch64.h"
#include "aarch64/traces/sim-fmulx-d-trace-aarch64.h"
#include "aarch64/traces/sim-fmulx-h-h-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmulx-h-trace-aarch64.h"
#include "aarch64/traces/sim-fmulx-s-s-s-trace-aarch64.h"
#include "aarch64/traces/sim-fmulx-s-trace-aarch64.h"
#include "aarch64/traces/sim-fneg-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fneg-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fneg-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fneg-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fneg-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fneg-d-trace-aarch64.h"
#include "aarch64/traces/sim-fneg-h-trace-aarch64.h"
#include "aarch64/traces/sim-fneg-s-trace-aarch64.h"
#include "aarch64/traces/sim-fnmadd-d-trace-aarch64.h"
#include "aarch64/traces/sim-fnmadd-h-trace-aarch64.h"
#include "aarch64/traces/sim-fnmadd-s-trace-aarch64.h"
#include "aarch64/traces/sim-fnmsub-d-trace-aarch64.h"
#include "aarch64/traces/sim-fnmsub-h-trace-aarch64.h"
#include "aarch64/traces/sim-fnmsub-s-trace-aarch64.h"
#include "aarch64/traces/sim-fnmul-d-trace-aarch64.h"
#include "aarch64/traces/sim-fnmul-h-trace-aarch64.h"
#include "aarch64/traces/sim-fnmul-s-trace-aarch64.h"
#include "aarch64/traces/sim-frecpe-2d-trace-aarch64.h"
#include "aarch64/traces/sim-frecpe-2s-trace-aarch64.h"
#include "aarch64/traces/sim-frecpe-4h-trace-aarch64.h"
#include "aarch64/traces/sim-frecpe-4s-trace-aarch64.h"
#include "aarch64/traces/sim-frecpe-8h-trace-aarch64.h"
#include "aarch64/traces/sim-frecpe-d-trace-aarch64.h"
#include "aarch64/traces/sim-frecpe-h-trace-aarch64.h"
#include "aarch64/traces/sim-frecpe-s-trace-aarch64.h"
#include "aarch64/traces/sim-frecps-2d-trace-aarch64.h"
#include "aarch64/traces/sim-frecps-2s-trace-aarch64.h"
#include "aarch64/traces/sim-frecps-4h-trace-aarch64.h"
#include "aarch64/traces/sim-frecps-4s-trace-aarch64.h"
#include "aarch64/traces/sim-frecps-8h-trace-aarch64.h"
#include "aarch64/traces/sim-frecps-d-trace-aarch64.h"
#include "aarch64/traces/sim-frecps-h-trace-aarch64.h"
#include "aarch64/traces/sim-frecps-s-trace-aarch64.h"
#include "aarch64/traces/sim-frecpx-d-trace-aarch64.h"
#include "aarch64/traces/sim-frecpx-h-trace-aarch64.h"
#include "aarch64/traces/sim-frecpx-s-trace-aarch64.h"
#include "aarch64/traces/sim-frint32x-2d-trace-aarch64.h"
#include "aarch64/traces/sim-frint32x-2s-trace-aarch64.h"
#include "aarch64/traces/sim-frint32x-4s-trace-aarch64.h"
#include "aarch64/traces/sim-frint32x-d-trace-aarch64.h"
#include "aarch64/traces/sim-frint32x-s-trace-aarch64.h"
#include "aarch64/traces/sim-frint32z-2d-trace-aarch64.h"
#include "aarch64/traces/sim-frint32z-2s-trace-aarch64.h"
#include "aarch64/traces/sim-frint32z-4s-trace-aarch64.h"
#include "aarch64/traces/sim-frint32z-d-trace-aarch64.h"
#include "aarch64/traces/sim-frint32z-s-trace-aarch64.h"
#include "aarch64/traces/sim-frint64x-2d-trace-aarch64.h"
#include "aarch64/traces/sim-frint64x-2s-trace-aarch64.h"
#include "aarch64/traces/sim-frint64x-4s-trace-aarch64.h"
#include "aarch64/traces/sim-frint64x-d-trace-aarch64.h"
#include "aarch64/traces/sim-frint64x-s-trace-aarch64.h"
#include "aarch64/traces/sim-frint64z-2d-trace-aarch64.h"
#include "aarch64/traces/sim-frint64z-2s-trace-aarch64.h"
#include "aarch64/traces/sim-frint64z-4s-trace-aarch64.h"
#include "aarch64/traces/sim-frint64z-d-trace-aarch64.h"
#include "aarch64/traces/sim-frint64z-s-trace-aarch64.h"
#include "aarch64/traces/sim-frinta-2d-trace-aarch64.h"
#include "aarch64/traces/sim-frinta-2s-trace-aarch64.h"
#include "aarch64/traces/sim-frinta-4h-trace-aarch64.h"
#include "aarch64/traces/sim-frinta-4s-trace-aarch64.h"
#include "aarch64/traces/sim-frinta-8h-trace-aarch64.h"
#include "aarch64/traces/sim-frinta-d-trace-aarch64.h"
#include "aarch64/traces/sim-frinta-h-trace-aarch64.h"
#include "aarch64/traces/sim-frinta-s-trace-aarch64.h"
#include "aarch64/traces/sim-frinti-2d-trace-aarch64.h"
#include "aarch64/traces/sim-frinti-2s-trace-aarch64.h"
#include "aarch64/traces/sim-frinti-4h-trace-aarch64.h"
#include "aarch64/traces/sim-frinti-4s-trace-aarch64.h"
#include "aarch64/traces/sim-frinti-8h-trace-aarch64.h"
#include "aarch64/traces/sim-frinti-d-trace-aarch64.h"
#include "aarch64/traces/sim-frinti-h-trace-aarch64.h"
#include "aarch64/traces/sim-frinti-s-trace-aarch64.h"
#include "aarch64/traces/sim-frintm-2d-trace-aarch64.h"
#include "aarch64/traces/sim-frintm-2s-trace-aarch64.h"
#include "aarch64/traces/sim-frintm-4h-trace-aarch64.h"
#include "aarch64/traces/sim-frintm-4s-trace-aarch64.h"
#include "aarch64/traces/sim-frintm-8h-trace-aarch64.h"
#include "aarch64/traces/sim-frintm-d-trace-aarch64.h"
#include "aarch64/traces/sim-frintm-h-trace-aarch64.h"
#include "aarch64/traces/sim-frintm-s-trace-aarch64.h"
#include "aarch64/traces/sim-frintn-2d-trace-aarch64.h"
#include "aarch64/traces/sim-frintn-2s-trace-aarch64.h"
#include "aarch64/traces/sim-frintn-4h-trace-aarch64.h"
#include "aarch64/traces/sim-frintn-4s-trace-aarch64.h"
#include "aarch64/traces/sim-frintn-8h-trace-aarch64.h"
#include "aarch64/traces/sim-frintn-d-trace-aarch64.h"
#include "aarch64/traces/sim-frintn-h-trace-aarch64.h"
#include "aarch64/traces/sim-frintn-s-trace-aarch64.h"
#include "aarch64/traces/sim-frintp-2d-trace-aarch64.h"
#include "aarch64/traces/sim-frintp-2s-trace-aarch64.h"
#include "aarch64/traces/sim-frintp-4h-trace-aarch64.h"
#include "aarch64/traces/sim-frintp-4s-trace-aarch64.h"
#include "aarch64/traces/sim-frintp-8h-trace-aarch64.h"
#include "aarch64/traces/sim-frintp-d-trace-aarch64.h"
#include "aarch64/traces/sim-frintp-h-trace-aarch64.h"
#include "aarch64/traces/sim-frintp-s-trace-aarch64.h"
#include "aarch64/traces/sim-frintx-2d-trace-aarch64.h"
#include "aarch64/traces/sim-frintx-2s-trace-aarch64.h"
#include "aarch64/traces/sim-frintx-4h-trace-aarch64.h"
#include "aarch64/traces/sim-frintx-4s-trace-aarch64.h"
#include "aarch64/traces/sim-frintx-8h-trace-aarch64.h"
#include "aarch64/traces/sim-frintx-d-trace-aarch64.h"
#include "aarch64/traces/sim-frintx-h-trace-aarch64.h"
#include "aarch64/traces/sim-frintx-s-trace-aarch64.h"
#include "aarch64/traces/sim-frintz-2d-trace-aarch64.h"
#include "aarch64/traces/sim-frintz-2s-trace-aarch64.h"
#include "aarch64/traces/sim-frintz-4h-trace-aarch64.h"
#include "aarch64/traces/sim-frintz-4s-trace-aarch64.h"
#include "aarch64/traces/sim-frintz-8h-trace-aarch64.h"
#include "aarch64/traces/sim-frintz-d-trace-aarch64.h"
#include "aarch64/traces/sim-frintz-h-trace-aarch64.h"
#include "aarch64/traces/sim-frintz-s-trace-aarch64.h"
#include "aarch64/traces/sim-frsqrte-2d-trace-aarch64.h"
#include "aarch64/traces/sim-frsqrte-2s-trace-aarch64.h"
#include "aarch64/traces/sim-frsqrte-4h-trace-aarch64.h"
#include "aarch64/traces/sim-frsqrte-4s-trace-aarch64.h"
#include "aarch64/traces/sim-frsqrte-8h-trace-aarch64.h"
#include "aarch64/traces/sim-frsqrte-d-trace-aarch64.h"
#include "aarch64/traces/sim-frsqrte-h-trace-aarch64.h"
#include "aarch64/traces/sim-frsqrte-s-trace-aarch64.h"
#include "aarch64/traces/sim-frsqrts-2d-trace-aarch64.h"
#include "aarch64/traces/sim-frsqrts-2s-trace-aarch64.h"
#include "aarch64/traces/sim-frsqrts-4h-trace-aarch64.h"
#include "aarch64/traces/sim-frsqrts-4s-trace-aarch64.h"
#include "aarch64/traces/sim-frsqrts-8h-trace-aarch64.h"
#include "aarch64/traces/sim-frsqrts-d-trace-aarch64.h"
#include "aarch64/traces/sim-frsqrts-h-trace-aarch64.h"
#include "aarch64/traces/sim-frsqrts-s-trace-aarch64.h"
#include "aarch64/traces/sim-fsqrt-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fsqrt-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fsqrt-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fsqrt-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fsqrt-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fsqrt-d-trace-aarch64.h"
#include "aarch64/traces/sim-fsqrt-h-trace-aarch64.h"
#include "aarch64/traces/sim-fsqrt-s-trace-aarch64.h"
#include "aarch64/traces/sim-fsub-2d-trace-aarch64.h"
#include "aarch64/traces/sim-fsub-2s-trace-aarch64.h"
#include "aarch64/traces/sim-fsub-4h-trace-aarch64.h"
#include "aarch64/traces/sim-fsub-4s-trace-aarch64.h"
#include "aarch64/traces/sim-fsub-8h-trace-aarch64.h"
#include "aarch64/traces/sim-fsub-d-trace-aarch64.h"
#include "aarch64/traces/sim-fsub-h-trace-aarch64.h"
#include "aarch64/traces/sim-fsub-s-trace-aarch64.h"
#include "aarch64/traces/sim-ins-b-trace-aarch64.h"
#include "aarch64/traces/sim-ins-d-trace-aarch64.h"
#include "aarch64/traces/sim-ins-h-trace-aarch64.h"
#include "aarch64/traces/sim-ins-s-trace-aarch64.h"
#include "aarch64/traces/sim-mla-16b-trace-aarch64.h"
#include "aarch64/traces/sim-mla-2s-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-mla-2s-trace-aarch64.h"
#include "aarch64/traces/sim-mla-4h-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-mla-4h-trace-aarch64.h"
#include "aarch64/traces/sim-mla-4s-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-mla-4s-trace-aarch64.h"
#include "aarch64/traces/sim-mla-8b-trace-aarch64.h"
#include "aarch64/traces/sim-mla-8h-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-mla-8h-trace-aarch64.h"
#include "aarch64/traces/sim-mls-16b-trace-aarch64.h"
#include "aarch64/traces/sim-mls-2s-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-mls-2s-trace-aarch64.h"
#include "aarch64/traces/sim-mls-4h-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-mls-4h-trace-aarch64.h"
#include "aarch64/traces/sim-mls-4s-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-mls-4s-trace-aarch64.h"
#include "aarch64/traces/sim-mls-8b-trace-aarch64.h"
#include "aarch64/traces/sim-mls-8h-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-mls-8h-trace-aarch64.h"
#include "aarch64/traces/sim-mul-16b-trace-aarch64.h"
#include "aarch64/traces/sim-mul-2s-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-mul-2s-trace-aarch64.h"
#include "aarch64/traces/sim-mul-4h-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-mul-4h-trace-aarch64.h"
#include "aarch64/traces/sim-mul-4s-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-mul-4s-trace-aarch64.h"
#include "aarch64/traces/sim-mul-8b-trace-aarch64.h"
#include "aarch64/traces/sim-mul-8h-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-mul-8h-trace-aarch64.h"
#include "aarch64/traces/sim-neg-16b-trace-aarch64.h"
#include "aarch64/traces/sim-neg-2d-trace-aarch64.h"
#include "aarch64/traces/sim-neg-2s-trace-aarch64.h"
#include "aarch64/traces/sim-neg-4h-trace-aarch64.h"
#include "aarch64/traces/sim-neg-4s-trace-aarch64.h"
#include "aarch64/traces/sim-neg-8b-trace-aarch64.h"
#include "aarch64/traces/sim-neg-8h-trace-aarch64.h"
#include "aarch64/traces/sim-neg-d-trace-aarch64.h"
#include "aarch64/traces/sim-not--16b-trace-aarch64.h"
#include "aarch64/traces/sim-not--8b-trace-aarch64.h"
#include "aarch64/traces/sim-orn-16b-trace-aarch64.h"
#include "aarch64/traces/sim-orn-8b-trace-aarch64.h"
#include "aarch64/traces/sim-orr-16b-trace-aarch64.h"
#include "aarch64/traces/sim-orr-8b-trace-aarch64.h"
#include "aarch64/traces/sim-pmul-16b-trace-aarch64.h"
#include "aarch64/traces/sim-pmul-8b-trace-aarch64.h"
#include "aarch64/traces/sim-pmull-8h-trace-aarch64.h"
#include "aarch64/traces/sim-pmull2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-raddhn-2s-trace-aarch64.h"
#include "aarch64/traces/sim-raddhn-4h-trace-aarch64.h"
#include "aarch64/traces/sim-raddhn-8b-trace-aarch64.h"
#include "aarch64/traces/sim-raddhn2-16b-trace-aarch64.h"
#include "aarch64/traces/sim-raddhn2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-raddhn2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-rbit-16b-trace-aarch64.h"
#include "aarch64/traces/sim-rbit-8b-trace-aarch64.h"
#include "aarch64/traces/sim-rev16-16b-trace-aarch64.h"
#include "aarch64/traces/sim-rev16-8b-trace-aarch64.h"
#include "aarch64/traces/sim-rev32-16b-trace-aarch64.h"
#include "aarch64/traces/sim-rev32-4h-trace-aarch64.h"
#include "aarch64/traces/sim-rev32-8b-trace-aarch64.h"
#include "aarch64/traces/sim-rev32-8h-trace-aarch64.h"
#include "aarch64/traces/sim-rev64-16b-trace-aarch64.h"
#include "aarch64/traces/sim-rev64-2s-trace-aarch64.h"
#include "aarch64/traces/sim-rev64-4h-trace-aarch64.h"
#include "aarch64/traces/sim-rev64-4s-trace-aarch64.h"
#include "aarch64/traces/sim-rev64-8b-trace-aarch64.h"
#include "aarch64/traces/sim-rev64-8h-trace-aarch64.h"
#include "aarch64/traces/sim-rshrn-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-rshrn-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-rshrn-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-rshrn2-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-rshrn2-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-rshrn2-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-rsubhn-2s-trace-aarch64.h"
#include "aarch64/traces/sim-rsubhn-4h-trace-aarch64.h"
#include "aarch64/traces/sim-rsubhn-8b-trace-aarch64.h"
#include "aarch64/traces/sim-rsubhn2-16b-trace-aarch64.h"
#include "aarch64/traces/sim-rsubhn2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-rsubhn2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-runfrom-trace-aarch64.h"
#include "aarch64/traces/sim-saba-16b-trace-aarch64.h"
#include "aarch64/traces/sim-saba-2s-trace-aarch64.h"
#include "aarch64/traces/sim-saba-4h-trace-aarch64.h"
#include "aarch64/traces/sim-saba-4s-trace-aarch64.h"
#include "aarch64/traces/sim-saba-8b-trace-aarch64.h"
#include "aarch64/traces/sim-saba-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sabal-2d-trace-aarch64.h"
#include "aarch64/traces/sim-sabal-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sabal-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sabal2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-sabal2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sabal2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sabd-16b-trace-aarch64.h"
#include "aarch64/traces/sim-sabd-2s-trace-aarch64.h"
#include "aarch64/traces/sim-sabd-4h-trace-aarch64.h"
#include "aarch64/traces/sim-sabd-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sabd-8b-trace-aarch64.h"
#include "aarch64/traces/sim-sabd-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sabdl-2d-trace-aarch64.h"
#include "aarch64/traces/sim-sabdl-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sabdl-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sabdl2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-sabdl2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sabdl2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sadalp-1d-trace-aarch64.h"
#include "aarch64/traces/sim-sadalp-2d-trace-aarch64.h"
#include "aarch64/traces/sim-sadalp-2s-trace-aarch64.h"
#include "aarch64/traces/sim-sadalp-4h-trace-aarch64.h"
#include "aarch64/traces/sim-sadalp-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sadalp-8h-trace-aarch64.h"
#include "aarch64/traces/sim-saddl-2d-trace-aarch64.h"
#include "aarch64/traces/sim-saddl-4s-trace-aarch64.h"
#include "aarch64/traces/sim-saddl-8h-trace-aarch64.h"
#include "aarch64/traces/sim-saddl2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-saddl2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-saddl2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-saddlp-1d-trace-aarch64.h"
#include "aarch64/traces/sim-saddlp-2d-trace-aarch64.h"
#include "aarch64/traces/sim-saddlp-2s-trace-aarch64.h"
#include "aarch64/traces/sim-saddlp-4h-trace-aarch64.h"
#include "aarch64/traces/sim-saddlp-4s-trace-aarch64.h"
#include "aarch64/traces/sim-saddlp-8h-trace-aarch64.h"
#include "aarch64/traces/sim-saddlv-d-4s-trace-aarch64.h"
#include "aarch64/traces/sim-saddlv-h-16b-trace-aarch64.h"
#include "aarch64/traces/sim-saddlv-h-8b-trace-aarch64.h"
#include "aarch64/traces/sim-saddlv-s-4h-trace-aarch64.h"
#include "aarch64/traces/sim-saddlv-s-8h-trace-aarch64.h"
#include "aarch64/traces/sim-saddw-2d-trace-aarch64.h"
#include "aarch64/traces/sim-saddw-4s-trace-aarch64.h"
#include "aarch64/traces/sim-saddw-8h-trace-aarch64.h"
#include "aarch64/traces/sim-saddw2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-saddw2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-saddw2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-scvtf-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-scvtf-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-scvtf-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-scvtf-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-scvtf-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-scvtf-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-scvtf-h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-scvtf-s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sdot-2s-8b-b-trace-aarch64.h"
#include "aarch64/traces/sim-sdot-2s-trace-aarch64.h"
#include "aarch64/traces/sim-sdot-4s-16b-b-trace-aarch64.h"
#include "aarch64/traces/sim-sdot-4s-trace-aarch64.h"
#include "aarch64/traces/sim-shadd-16b-trace-aarch64.h"
#include "aarch64/traces/sim-shadd-2s-trace-aarch64.h"
#include "aarch64/traces/sim-shadd-4h-trace-aarch64.h"
#include "aarch64/traces/sim-shadd-4s-trace-aarch64.h"
#include "aarch64/traces/sim-shadd-8b-trace-aarch64.h"
#include "aarch64/traces/sim-shadd-8h-trace-aarch64.h"
#include "aarch64/traces/sim-shl-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shl-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shl-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shl-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shl-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shl-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shl-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shl-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shll-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shll-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shll-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shll2-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shll2-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shll2-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shrn-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shrn-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shrn-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shrn2-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shrn2-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shrn2-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-shsub-16b-trace-aarch64.h"
#include "aarch64/traces/sim-shsub-2s-trace-aarch64.h"
#include "aarch64/traces/sim-shsub-4h-trace-aarch64.h"
#include "aarch64/traces/sim-shsub-4s-trace-aarch64.h"
#include "aarch64/traces/sim-shsub-8b-trace-aarch64.h"
#include "aarch64/traces/sim-shsub-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sli-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sli-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sli-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sli-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sli-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sli-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sli-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sli-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-smax-16b-trace-aarch64.h"
#include "aarch64/traces/sim-smax-2s-trace-aarch64.h"
#include "aarch64/traces/sim-smax-4h-trace-aarch64.h"
#include "aarch64/traces/sim-smax-4s-trace-aarch64.h"
#include "aarch64/traces/sim-smax-8b-trace-aarch64.h"
#include "aarch64/traces/sim-smax-8h-trace-aarch64.h"
#include "aarch64/traces/sim-smaxp-16b-trace-aarch64.h"
#include "aarch64/traces/sim-smaxp-2s-trace-aarch64.h"
#include "aarch64/traces/sim-smaxp-4h-trace-aarch64.h"
#include "aarch64/traces/sim-smaxp-4s-trace-aarch64.h"
#include "aarch64/traces/sim-smaxp-8b-trace-aarch64.h"
#include "aarch64/traces/sim-smaxp-8h-trace-aarch64.h"
#include "aarch64/traces/sim-smaxv-b-16b-trace-aarch64.h"
#include "aarch64/traces/sim-smaxv-b-8b-trace-aarch64.h"
#include "aarch64/traces/sim-smaxv-h-4h-trace-aarch64.h"
#include "aarch64/traces/sim-smaxv-h-8h-trace-aarch64.h"
#include "aarch64/traces/sim-smaxv-s-4s-trace-aarch64.h"
#include "aarch64/traces/sim-smin-16b-trace-aarch64.h"
#include "aarch64/traces/sim-smin-2s-trace-aarch64.h"
#include "aarch64/traces/sim-smin-4h-trace-aarch64.h"
#include "aarch64/traces/sim-smin-4s-trace-aarch64.h"
#include "aarch64/traces/sim-smin-8b-trace-aarch64.h"
#include "aarch64/traces/sim-smin-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sminp-16b-trace-aarch64.h"
#include "aarch64/traces/sim-sminp-2s-trace-aarch64.h"
#include "aarch64/traces/sim-sminp-4h-trace-aarch64.h"
#include "aarch64/traces/sim-sminp-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sminp-8b-trace-aarch64.h"
#include "aarch64/traces/sim-sminp-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sminv-b-16b-trace-aarch64.h"
#include "aarch64/traces/sim-sminv-b-8b-trace-aarch64.h"
#include "aarch64/traces/sim-sminv-h-4h-trace-aarch64.h"
#include "aarch64/traces/sim-sminv-h-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sminv-s-4s-trace-aarch64.h"
#include "aarch64/traces/sim-smlal-2d-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-smlal-2d-trace-aarch64.h"
#include "aarch64/traces/sim-smlal-4s-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-smlal-4s-trace-aarch64.h"
#include "aarch64/traces/sim-smlal-8h-trace-aarch64.h"
#include "aarch64/traces/sim-smlal2-2d-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-smlal2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-smlal2-4s-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-smlal2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-smlal2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-smlsl-2d-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-smlsl-2d-trace-aarch64.h"
#include "aarch64/traces/sim-smlsl-4s-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-smlsl-4s-trace-aarch64.h"
#include "aarch64/traces/sim-smlsl-8h-trace-aarch64.h"
#include "aarch64/traces/sim-smlsl2-2d-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-smlsl2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-smlsl2-4s-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-smlsl2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-smlsl2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-smull-2d-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-smull-2d-trace-aarch64.h"
#include "aarch64/traces/sim-smull-4s-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-smull-4s-trace-aarch64.h"
#include "aarch64/traces/sim-smull-8h-trace-aarch64.h"
#include "aarch64/traces/sim-smull2-2d-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-smull2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-smull2-4s-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-smull2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-smull2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sqabs-16b-trace-aarch64.h"
#include "aarch64/traces/sim-sqabs-2d-trace-aarch64.h"
#include "aarch64/traces/sim-sqabs-2s-trace-aarch64.h"
#include "aarch64/traces/sim-sqabs-4h-trace-aarch64.h"
#include "aarch64/traces/sim-sqabs-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sqabs-8b-trace-aarch64.h"
#include "aarch64/traces/sim-sqabs-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sqabs-b-trace-aarch64.h"
#include "aarch64/traces/sim-sqabs-d-trace-aarch64.h"
#include "aarch64/traces/sim-sqabs-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqabs-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqadd-16b-trace-aarch64.h"
#include "aarch64/traces/sim-sqadd-2d-trace-aarch64.h"
#include "aarch64/traces/sim-sqadd-2s-trace-aarch64.h"
#include "aarch64/traces/sim-sqadd-4h-trace-aarch64.h"
#include "aarch64/traces/sim-sqadd-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sqadd-8b-trace-aarch64.h"
#include "aarch64/traces/sim-sqadd-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sqadd-b-trace-aarch64.h"
#include "aarch64/traces/sim-sqadd-d-trace-aarch64.h"
#include "aarch64/traces/sim-sqadd-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqadd-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlal-2d-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlal-2d-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlal-4s-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlal-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlal-d-s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlal-d-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlal-s-h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlal-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlal2-2d-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlal2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlal2-4s-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlal2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlsl-2d-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlsl-2d-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlsl-4s-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlsl-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlsl-d-s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlsl-d-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlsl-s-h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlsl-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlsl2-2d-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlsl2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlsl2-4s-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmlsl2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmulh-2s-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmulh-2s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmulh-4h-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmulh-4h-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmulh-4s-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmulh-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmulh-8h-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmulh-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmulh-h-h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmulh-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmulh-s-s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmulh-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmull-2d-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmull-2d-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmull-4s-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmull-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmull-d-s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmull-d-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmull-s-h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmull-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmull2-2d-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmull2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmull2-4s-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqdmull2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sqneg-16b-trace-aarch64.h"
#include "aarch64/traces/sim-sqneg-2d-trace-aarch64.h"
#include "aarch64/traces/sim-sqneg-2s-trace-aarch64.h"
#include "aarch64/traces/sim-sqneg-4h-trace-aarch64.h"
#include "aarch64/traces/sim-sqneg-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sqneg-8b-trace-aarch64.h"
#include "aarch64/traces/sim-sqneg-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sqneg-b-trace-aarch64.h"
#include "aarch64/traces/sim-sqneg-d-trace-aarch64.h"
#include "aarch64/traces/sim-sqneg-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqneg-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlah-2s-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlah-2s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlah-4h-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlah-4h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlah-4s-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlah-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlah-8h-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlah-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlah-h-h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlah-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlah-s-s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlah-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlsh-2s-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlsh-2s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlsh-4h-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlsh-4h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlsh-4s-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlsh-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlsh-8h-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlsh-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlsh-h-h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlsh-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlsh-s-s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmlsh-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmulh-2s-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmulh-2s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmulh-4h-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmulh-4h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmulh-4s-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmulh-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmulh-8h-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmulh-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmulh-h-h-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmulh-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmulh-s-s-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrdmulh-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshl-16b-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshl-2d-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshl-2s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshl-4h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshl-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshl-8b-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshl-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshl-b-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshl-d-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshl-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshl-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshrn-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshrn-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshrn-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshrn-b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshrn-h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshrn-s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshrn2-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshrn2-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshrn2-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshrun-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshrun-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshrun-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshrun-b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshrun-h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshrun-s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshrun2-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshrun2-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqrshrun2-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-16b-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-2d-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-2s-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-4h-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-8b-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-b-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-d-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshl-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqshlu-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshlu-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshlu-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshlu-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshlu-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshlu-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshlu-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshlu-b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshlu-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshlu-h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshlu-s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshrn-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshrn-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshrn-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshrn-b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshrn-h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshrn-s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshrn2-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshrn2-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshrn2-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshrun-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshrun-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshrun-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshrun-b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshrun-h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshrun-s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshrun2-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshrun2-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqshrun2-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sqsub-16b-trace-aarch64.h"
#include "aarch64/traces/sim-sqsub-2d-trace-aarch64.h"
#include "aarch64/traces/sim-sqsub-2s-trace-aarch64.h"
#include "aarch64/traces/sim-sqsub-4h-trace-aarch64.h"
#include "aarch64/traces/sim-sqsub-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sqsub-8b-trace-aarch64.h"
#include "aarch64/traces/sim-sqsub-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sqsub-b-trace-aarch64.h"
#include "aarch64/traces/sim-sqsub-d-trace-aarch64.h"
#include "aarch64/traces/sim-sqsub-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqsub-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqxtn-2s-trace-aarch64.h"
#include "aarch64/traces/sim-sqxtn-4h-trace-aarch64.h"
#include "aarch64/traces/sim-sqxtn-8b-trace-aarch64.h"
#include "aarch64/traces/sim-sqxtn-b-trace-aarch64.h"
#include "aarch64/traces/sim-sqxtn-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqxtn-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqxtn2-16b-trace-aarch64.h"
#include "aarch64/traces/sim-sqxtn2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sqxtn2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sqxtun-2s-trace-aarch64.h"
#include "aarch64/traces/sim-sqxtun-4h-trace-aarch64.h"
#include "aarch64/traces/sim-sqxtun-8b-trace-aarch64.h"
#include "aarch64/traces/sim-sqxtun-b-trace-aarch64.h"
#include "aarch64/traces/sim-sqxtun-h-trace-aarch64.h"
#include "aarch64/traces/sim-sqxtun-s-trace-aarch64.h"
#include "aarch64/traces/sim-sqxtun2-16b-trace-aarch64.h"
#include "aarch64/traces/sim-sqxtun2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sqxtun2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-srhadd-16b-trace-aarch64.h"
#include "aarch64/traces/sim-srhadd-2s-trace-aarch64.h"
#include "aarch64/traces/sim-srhadd-4h-trace-aarch64.h"
#include "aarch64/traces/sim-srhadd-4s-trace-aarch64.h"
#include "aarch64/traces/sim-srhadd-8b-trace-aarch64.h"
#include "aarch64/traces/sim-srhadd-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sri-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sri-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sri-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sri-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sri-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sri-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sri-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sri-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-srshl-16b-trace-aarch64.h"
#include "aarch64/traces/sim-srshl-2d-trace-aarch64.h"
#include "aarch64/traces/sim-srshl-2s-trace-aarch64.h"
#include "aarch64/traces/sim-srshl-4h-trace-aarch64.h"
#include "aarch64/traces/sim-srshl-4s-trace-aarch64.h"
#include "aarch64/traces/sim-srshl-8b-trace-aarch64.h"
#include "aarch64/traces/sim-srshl-8h-trace-aarch64.h"
#include "aarch64/traces/sim-srshl-d-trace-aarch64.h"
#include "aarch64/traces/sim-srshr-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-srshr-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-srshr-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-srshr-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-srshr-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-srshr-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-srshr-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-srshr-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-srsra-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-srsra-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-srsra-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-srsra-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-srsra-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-srsra-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-srsra-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-srsra-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sshl-16b-trace-aarch64.h"
#include "aarch64/traces/sim-sshl-2d-trace-aarch64.h"
#include "aarch64/traces/sim-sshl-2s-trace-aarch64.h"
#include "aarch64/traces/sim-sshl-4h-trace-aarch64.h"
#include "aarch64/traces/sim-sshl-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sshl-8b-trace-aarch64.h"
#include "aarch64/traces/sim-sshl-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sshl-d-trace-aarch64.h"
#include "aarch64/traces/sim-sshll-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sshll-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sshll-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sshll2-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sshll2-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sshll2-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sshr-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sshr-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sshr-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sshr-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sshr-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sshr-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sshr-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-sshr-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ssra-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ssra-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ssra-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ssra-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ssra-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ssra-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ssra-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ssra-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ssubl-2d-trace-aarch64.h"
#include "aarch64/traces/sim-ssubl-4s-trace-aarch64.h"
#include "aarch64/traces/sim-ssubl-8h-trace-aarch64.h"
#include "aarch64/traces/sim-ssubl2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-ssubl2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-ssubl2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-ssubw-2d-trace-aarch64.h"
#include "aarch64/traces/sim-ssubw-4s-trace-aarch64.h"
#include "aarch64/traces/sim-ssubw-8h-trace-aarch64.h"
#include "aarch64/traces/sim-ssubw2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-ssubw2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-ssubw2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sub-16b-trace-aarch64.h"
#include "aarch64/traces/sim-sub-2d-trace-aarch64.h"
#include "aarch64/traces/sim-sub-2s-trace-aarch64.h"
#include "aarch64/traces/sim-sub-4h-trace-aarch64.h"
#include "aarch64/traces/sim-sub-4s-trace-aarch64.h"
#include "aarch64/traces/sim-sub-8b-trace-aarch64.h"
#include "aarch64/traces/sim-sub-8h-trace-aarch64.h"
#include "aarch64/traces/sim-sub-d-trace-aarch64.h"
#include "aarch64/traces/sim-subhn-2s-trace-aarch64.h"
#include "aarch64/traces/sim-subhn-4h-trace-aarch64.h"
#include "aarch64/traces/sim-subhn-8b-trace-aarch64.h"
#include "aarch64/traces/sim-subhn2-16b-trace-aarch64.h"
#include "aarch64/traces/sim-subhn2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-subhn2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-suqadd-16b-trace-aarch64.h"
#include "aarch64/traces/sim-suqadd-2d-trace-aarch64.h"
#include "aarch64/traces/sim-suqadd-2s-trace-aarch64.h"
#include "aarch64/traces/sim-suqadd-4h-trace-aarch64.h"
#include "aarch64/traces/sim-suqadd-4s-trace-aarch64.h"
#include "aarch64/traces/sim-suqadd-8b-trace-aarch64.h"
#include "aarch64/traces/sim-suqadd-8h-trace-aarch64.h"
#include "aarch64/traces/sim-suqadd-b-trace-aarch64.h"
#include "aarch64/traces/sim-suqadd-d-trace-aarch64.h"
#include "aarch64/traces/sim-suqadd-h-trace-aarch64.h"
#include "aarch64/traces/sim-suqadd-s-trace-aarch64.h"
#include "aarch64/traces/sim-trn1-16b-trace-aarch64.h"
#include "aarch64/traces/sim-trn1-2d-trace-aarch64.h"
#include "aarch64/traces/sim-trn1-2s-trace-aarch64.h"
#include "aarch64/traces/sim-trn1-4h-trace-aarch64.h"
#include "aarch64/traces/sim-trn1-4s-trace-aarch64.h"
#include "aarch64/traces/sim-trn1-8b-trace-aarch64.h"
#include "aarch64/traces/sim-trn1-8h-trace-aarch64.h"
#include "aarch64/traces/sim-trn2-16b-trace-aarch64.h"
#include "aarch64/traces/sim-trn2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-trn2-2s-trace-aarch64.h"
#include "aarch64/traces/sim-trn2-4h-trace-aarch64.h"
#include "aarch64/traces/sim-trn2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-trn2-8b-trace-aarch64.h"
#include "aarch64/traces/sim-trn2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uaba-16b-trace-aarch64.h"
#include "aarch64/traces/sim-uaba-2s-trace-aarch64.h"
#include "aarch64/traces/sim-uaba-4h-trace-aarch64.h"
#include "aarch64/traces/sim-uaba-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uaba-8b-trace-aarch64.h"
#include "aarch64/traces/sim-uaba-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uabal-2d-trace-aarch64.h"
#include "aarch64/traces/sim-uabal-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uabal-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uabal2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-uabal2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uabal2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uabd-16b-trace-aarch64.h"
#include "aarch64/traces/sim-uabd-2s-trace-aarch64.h"
#include "aarch64/traces/sim-uabd-4h-trace-aarch64.h"
#include "aarch64/traces/sim-uabd-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uabd-8b-trace-aarch64.h"
#include "aarch64/traces/sim-uabd-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uabdl-2d-trace-aarch64.h"
#include "aarch64/traces/sim-uabdl-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uabdl-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uabdl2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-uabdl2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uabdl2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uadalp-1d-trace-aarch64.h"
#include "aarch64/traces/sim-uadalp-2d-trace-aarch64.h"
#include "aarch64/traces/sim-uadalp-2s-trace-aarch64.h"
#include "aarch64/traces/sim-uadalp-4h-trace-aarch64.h"
#include "aarch64/traces/sim-uadalp-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uadalp-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uaddl-2d-trace-aarch64.h"
#include "aarch64/traces/sim-uaddl-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uaddl-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uaddl2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-uaddl2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uaddl2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uaddlp-1d-trace-aarch64.h"
#include "aarch64/traces/sim-uaddlp-2d-trace-aarch64.h"
#include "aarch64/traces/sim-uaddlp-2s-trace-aarch64.h"
#include "aarch64/traces/sim-uaddlp-4h-trace-aarch64.h"
#include "aarch64/traces/sim-uaddlp-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uaddlp-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uaddlv-d-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uaddlv-h-16b-trace-aarch64.h"
#include "aarch64/traces/sim-uaddlv-h-8b-trace-aarch64.h"
#include "aarch64/traces/sim-uaddlv-s-4h-trace-aarch64.h"
#include "aarch64/traces/sim-uaddlv-s-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uaddw-2d-trace-aarch64.h"
#include "aarch64/traces/sim-uaddw-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uaddw-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uaddw2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-uaddw2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uaddw2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-ucvtf-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ucvtf-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ucvtf-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ucvtf-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ucvtf-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ucvtf-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ucvtf-h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ucvtf-s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-udot-2s-8b-b-trace-aarch64.h"
#include "aarch64/traces/sim-udot-2s-trace-aarch64.h"
#include "aarch64/traces/sim-udot-4s-16b-b-trace-aarch64.h"
#include "aarch64/traces/sim-udot-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uhadd-16b-trace-aarch64.h"
#include "aarch64/traces/sim-uhadd-2s-trace-aarch64.h"
#include "aarch64/traces/sim-uhadd-4h-trace-aarch64.h"
#include "aarch64/traces/sim-uhadd-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uhadd-8b-trace-aarch64.h"
#include "aarch64/traces/sim-uhadd-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uhsub-16b-trace-aarch64.h"
#include "aarch64/traces/sim-uhsub-2s-trace-aarch64.h"
#include "aarch64/traces/sim-uhsub-4h-trace-aarch64.h"
#include "aarch64/traces/sim-uhsub-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uhsub-8b-trace-aarch64.h"
#include "aarch64/traces/sim-uhsub-8h-trace-aarch64.h"
#include "aarch64/traces/sim-umax-16b-trace-aarch64.h"
#include "aarch64/traces/sim-umax-2s-trace-aarch64.h"
#include "aarch64/traces/sim-umax-4h-trace-aarch64.h"
#include "aarch64/traces/sim-umax-4s-trace-aarch64.h"
#include "aarch64/traces/sim-umax-8b-trace-aarch64.h"
#include "aarch64/traces/sim-umax-8h-trace-aarch64.h"
#include "aarch64/traces/sim-umaxp-16b-trace-aarch64.h"
#include "aarch64/traces/sim-umaxp-2s-trace-aarch64.h"
#include "aarch64/traces/sim-umaxp-4h-trace-aarch64.h"
#include "aarch64/traces/sim-umaxp-4s-trace-aarch64.h"
#include "aarch64/traces/sim-umaxp-8b-trace-aarch64.h"
#include "aarch64/traces/sim-umaxp-8h-trace-aarch64.h"
#include "aarch64/traces/sim-umaxv-b-16b-trace-aarch64.h"
#include "aarch64/traces/sim-umaxv-b-8b-trace-aarch64.h"
#include "aarch64/traces/sim-umaxv-h-4h-trace-aarch64.h"
#include "aarch64/traces/sim-umaxv-h-8h-trace-aarch64.h"
#include "aarch64/traces/sim-umaxv-s-4s-trace-aarch64.h"
#include "aarch64/traces/sim-umin-16b-trace-aarch64.h"
#include "aarch64/traces/sim-umin-2s-trace-aarch64.h"
#include "aarch64/traces/sim-umin-4h-trace-aarch64.h"
#include "aarch64/traces/sim-umin-4s-trace-aarch64.h"
#include "aarch64/traces/sim-umin-8b-trace-aarch64.h"
#include "aarch64/traces/sim-umin-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uminp-16b-trace-aarch64.h"
#include "aarch64/traces/sim-uminp-2s-trace-aarch64.h"
#include "aarch64/traces/sim-uminp-4h-trace-aarch64.h"
#include "aarch64/traces/sim-uminp-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uminp-8b-trace-aarch64.h"
#include "aarch64/traces/sim-uminp-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uminv-b-16b-trace-aarch64.h"
#include "aarch64/traces/sim-uminv-b-8b-trace-aarch64.h"
#include "aarch64/traces/sim-uminv-h-4h-trace-aarch64.h"
#include "aarch64/traces/sim-uminv-h-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uminv-s-4s-trace-aarch64.h"
#include "aarch64/traces/sim-umlal-2d-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-umlal-2d-trace-aarch64.h"
#include "aarch64/traces/sim-umlal-4s-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-umlal-4s-trace-aarch64.h"
#include "aarch64/traces/sim-umlal-8h-trace-aarch64.h"
#include "aarch64/traces/sim-umlal2-2d-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-umlal2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-umlal2-4s-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-umlal2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-umlal2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-umlsl-2d-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-umlsl-2d-trace-aarch64.h"
#include "aarch64/traces/sim-umlsl-4s-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-umlsl-4s-trace-aarch64.h"
#include "aarch64/traces/sim-umlsl-8h-trace-aarch64.h"
#include "aarch64/traces/sim-umlsl2-2d-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-umlsl2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-umlsl2-4s-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-umlsl2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-umlsl2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-umull-2d-2s-s-trace-aarch64.h"
#include "aarch64/traces/sim-umull-2d-trace-aarch64.h"
#include "aarch64/traces/sim-umull-4s-4h-h-trace-aarch64.h"
#include "aarch64/traces/sim-umull-4s-trace-aarch64.h"
#include "aarch64/traces/sim-umull-8h-trace-aarch64.h"
#include "aarch64/traces/sim-umull2-2d-4s-s-trace-aarch64.h"
#include "aarch64/traces/sim-umull2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-umull2-4s-8h-h-trace-aarch64.h"
#include "aarch64/traces/sim-umull2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-umull2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uqadd-16b-trace-aarch64.h"
#include "aarch64/traces/sim-uqadd-2d-trace-aarch64.h"
#include "aarch64/traces/sim-uqadd-2s-trace-aarch64.h"
#include "aarch64/traces/sim-uqadd-4h-trace-aarch64.h"
#include "aarch64/traces/sim-uqadd-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uqadd-8b-trace-aarch64.h"
#include "aarch64/traces/sim-uqadd-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uqadd-d-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshl-16b-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshl-2d-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshl-2s-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshl-4h-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshl-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshl-8b-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshl-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshl-b-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshl-d-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshl-h-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshl-s-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshrn-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshrn-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshrn-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshrn-b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshrn-h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshrn-s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshrn2-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshrn2-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqrshrn2-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-16b-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-2d-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-2s-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-4h-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-8b-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-b-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-d-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-h-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshl-s-trace-aarch64.h"
#include "aarch64/traces/sim-uqshrn-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshrn-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshrn-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshrn-b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshrn-h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshrn-s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshrn2-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshrn2-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqshrn2-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-uqsub-16b-trace-aarch64.h"
#include "aarch64/traces/sim-uqsub-2d-trace-aarch64.h"
#include "aarch64/traces/sim-uqsub-2s-trace-aarch64.h"
#include "aarch64/traces/sim-uqsub-4h-trace-aarch64.h"
#include "aarch64/traces/sim-uqsub-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uqsub-8b-trace-aarch64.h"
#include "aarch64/traces/sim-uqsub-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uqsub-d-trace-aarch64.h"
#include "aarch64/traces/sim-uqxtn-2s-trace-aarch64.h"
#include "aarch64/traces/sim-uqxtn-4h-trace-aarch64.h"
#include "aarch64/traces/sim-uqxtn-8b-trace-aarch64.h"
#include "aarch64/traces/sim-uqxtn-b-trace-aarch64.h"
#include "aarch64/traces/sim-uqxtn-h-trace-aarch64.h"
#include "aarch64/traces/sim-uqxtn-s-trace-aarch64.h"
#include "aarch64/traces/sim-uqxtn2-16b-trace-aarch64.h"
#include "aarch64/traces/sim-uqxtn2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uqxtn2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-urecpe-2s-trace-aarch64.h"
#include "aarch64/traces/sim-urecpe-4s-trace-aarch64.h"
#include "aarch64/traces/sim-urhadd-16b-trace-aarch64.h"
#include "aarch64/traces/sim-urhadd-2s-trace-aarch64.h"
#include "aarch64/traces/sim-urhadd-4h-trace-aarch64.h"
#include "aarch64/traces/sim-urhadd-4s-trace-aarch64.h"
#include "aarch64/traces/sim-urhadd-8b-trace-aarch64.h"
#include "aarch64/traces/sim-urhadd-8h-trace-aarch64.h"
#include "aarch64/traces/sim-urshl-16b-trace-aarch64.h"
#include "aarch64/traces/sim-urshl-2d-trace-aarch64.h"
#include "aarch64/traces/sim-urshl-2s-trace-aarch64.h"
#include "aarch64/traces/sim-urshl-4h-trace-aarch64.h"
#include "aarch64/traces/sim-urshl-4s-trace-aarch64.h"
#include "aarch64/traces/sim-urshl-8b-trace-aarch64.h"
#include "aarch64/traces/sim-urshl-8h-trace-aarch64.h"
#include "aarch64/traces/sim-urshl-d-trace-aarch64.h"
#include "aarch64/traces/sim-urshr-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-urshr-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-urshr-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-urshr-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-urshr-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-urshr-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-urshr-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-urshr-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ursqrte-2s-trace-aarch64.h"
#include "aarch64/traces/sim-ursqrte-4s-trace-aarch64.h"
#include "aarch64/traces/sim-ursra-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ursra-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ursra-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ursra-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ursra-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ursra-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ursra-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ursra-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ushl-16b-trace-aarch64.h"
#include "aarch64/traces/sim-ushl-2d-trace-aarch64.h"
#include "aarch64/traces/sim-ushl-2s-trace-aarch64.h"
#include "aarch64/traces/sim-ushl-4h-trace-aarch64.h"
#include "aarch64/traces/sim-ushl-4s-trace-aarch64.h"
#include "aarch64/traces/sim-ushl-8b-trace-aarch64.h"
#include "aarch64/traces/sim-ushl-8h-trace-aarch64.h"
#include "aarch64/traces/sim-ushl-d-trace-aarch64.h"
#include "aarch64/traces/sim-ushll-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ushll-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ushll-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ushll2-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ushll2-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ushll2-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ushr-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ushr-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ushr-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ushr-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ushr-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ushr-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ushr-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-ushr-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-usqadd-16b-trace-aarch64.h"
#include "aarch64/traces/sim-usqadd-2d-trace-aarch64.h"
#include "aarch64/traces/sim-usqadd-2s-trace-aarch64.h"
#include "aarch64/traces/sim-usqadd-4h-trace-aarch64.h"
#include "aarch64/traces/sim-usqadd-4s-trace-aarch64.h"
#include "aarch64/traces/sim-usqadd-8b-trace-aarch64.h"
#include "aarch64/traces/sim-usqadd-8h-trace-aarch64.h"
#include "aarch64/traces/sim-usqadd-b-trace-aarch64.h"
#include "aarch64/traces/sim-usqadd-d-trace-aarch64.h"
#include "aarch64/traces/sim-usqadd-h-trace-aarch64.h"
#include "aarch64/traces/sim-usqadd-s-trace-aarch64.h"
#include "aarch64/traces/sim-usra-16b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-usra-2d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-usra-2s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-usra-4h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-usra-4s-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-usra-8b-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-usra-8h-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-usra-d-2opimm-trace-aarch64.h"
#include "aarch64/traces/sim-usubl-2d-trace-aarch64.h"
#include "aarch64/traces/sim-usubl-4s-trace-aarch64.h"
#include "aarch64/traces/sim-usubl-8h-trace-aarch64.h"
#include "aarch64/traces/sim-usubl2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-usubl2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-usubl2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-usubw-2d-trace-aarch64.h"
#include "aarch64/traces/sim-usubw-4s-trace-aarch64.h"
#include "aarch64/traces/sim-usubw-8h-trace-aarch64.h"
#include "aarch64/traces/sim-usubw2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-usubw2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-usubw2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uzp1-16b-trace-aarch64.h"
#include "aarch64/traces/sim-uzp1-2d-trace-aarch64.h"
#include "aarch64/traces/sim-uzp1-2s-trace-aarch64.h"
#include "aarch64/traces/sim-uzp1-4h-trace-aarch64.h"
#include "aarch64/traces/sim-uzp1-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uzp1-8b-trace-aarch64.h"
#include "aarch64/traces/sim-uzp1-8h-trace-aarch64.h"
#include "aarch64/traces/sim-uzp2-16b-trace-aarch64.h"
#include "aarch64/traces/sim-uzp2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-uzp2-2s-trace-aarch64.h"
#include "aarch64/traces/sim-uzp2-4h-trace-aarch64.h"
#include "aarch64/traces/sim-uzp2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-uzp2-8b-trace-aarch64.h"
#include "aarch64/traces/sim-uzp2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-xtn-2s-trace-aarch64.h"
#include "aarch64/traces/sim-xtn-4h-trace-aarch64.h"
#include "aarch64/traces/sim-xtn-8b-trace-aarch64.h"
#include "aarch64/traces/sim-xtn2-16b-trace-aarch64.h"
#include "aarch64/traces/sim-xtn2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-xtn2-8h-trace-aarch64.h"
#include "aarch64/traces/sim-zip1-16b-trace-aarch64.h"
#include "aarch64/traces/sim-zip1-2d-trace-aarch64.h"
#include "aarch64/traces/sim-zip1-2s-trace-aarch64.h"
#include "aarch64/traces/sim-zip1-4h-trace-aarch64.h"
#include "aarch64/traces/sim-zip1-4s-trace-aarch64.h"
#include "aarch64/traces/sim-zip1-8b-trace-aarch64.h"
#include "aarch64/traces/sim-zip1-8h-trace-aarch64.h"
#include "aarch64/traces/sim-zip2-16b-trace-aarch64.h"
#include "aarch64/traces/sim-zip2-2d-trace-aarch64.h"
#include "aarch64/traces/sim-zip2-2s-trace-aarch64.h"
#include "aarch64/traces/sim-zip2-4h-trace-aarch64.h"
#include "aarch64/traces/sim-zip2-4s-trace-aarch64.h"
#include "aarch64/traces/sim-zip2-8b-trace-aarch64.h"
#include "aarch64/traces/sim-zip2-8h-trace-aarch64.h"

#endif  // VIXL_TEST_AARCH64_SIMULATOR_TRACES_AARCH64_H_
