/*
 * This table maps Unicode codepoints to entries in Nelson
 * Note that there may be multiple entries in Nelson for a single
 * Unicode codepoint.
 */

#include "unicode.h"
#include "nelson.h"

struct unmap NelsonTbl[]={
0x3402,265,
0x3427,127,
0x34E4,677,
0x353A,84,
0x374D,1278,
0x37AE,1408,
0x3800,5343,
0x384C,1476,
0x3861,1487,
0x3861,1491,
0x39AE,133,
0x3C16,2399,
0x3C7E,2453,
0x3C83,2459,
0x3E03,2809,
0x4096,28,
0x432B,3629,
0x43EE,3756,
0x459F,300,
0x4610,4208,
0x4757,4477,
0x4831,4600,
0x4E00,1,
0x4E01,2,
0x4E03,261,
0x4E07,3984,
0x4E07,7,
0x4E08,151,
0x4E09,8,
0x4E0A,798,
0x4E0B,9,
0x4E0D,17,
0x4E0E,6,
0x4E10,11,
0x4E11,13,
0x4E12,13,
0x4E14,23,
0x4E16,84,
0x4E16,95,
0x4E17,83,
0x4E18,174,
0x4E19,22,
0x4E1A,20,
0x4E1E,21,
0x4E21,34,
0x4E21,47,
0x4E26,589,
0x4E2A,340,
0x4E2A,147,
0x4E2B,76,
0x4E2D,81,
0x4E30,77,
0x4E32,104,
0x4E38,155,
0x4E39,163,
0x4E3B,285,
0x4E3C,171,
0x4E43,145,
0x4E44,126,
0x4E45,153,
0x4E4B,280,
0x4E4D,172,
0x4E4E,170,
0x4E4F,150,
0x4E56,206,
0x4E57,223,
0x4E57,225,
0x4E58,225,
0x4E59,260,
0x4E5D,146,
0x4E5E,262,
0x4E5F,75,
0x4E71,3856,
0x4E73,266,
0x4E7E,784,
0x4E80,5445,
0x4E82,267,
0x4E86,268,
0x4E88,271,
0x4E89,186,
0x4E8B,272,
0x4E8C,273,
0x4E8E,5,
0x4E91,274,
0x4E92,14,
0x4E94,15,
0x4E95,165,
0x4E98,30,
0x4E99,18,
0x4E99,31,
0x4E9B,276,
0x4E9C,43,
0x4E9E,45,
0x4EA1,281,
0x4EA2,282,
0x4EA4,290,
0x4EA5,287,
0x4EA6,286,
0x4EAB,293,
0x4EAC,295,
0x4EAD,303,
0x4EAE,302,
0x4EB0,299,
0x4EBA,339,
0x4EC0,345,
0x4EC1,349,
0x4EC2,342,
0x4EC4,815,
0x4EC6,343,
0x4EC7,346,
0x4ECA,352,
0x4ECB,347,
0x4ECD,344,
0x4ECF,351,
0x4ED0,341,
0x4ED4,358,
0x4ED5,362,
0x4ED6,361,
0x4ED7,357,
0x4ED8,363,
0x4ED9,359,
0x4EDD,355,
0x4EDE,356,
0x4EDF,156,
0x4EDF,353,
0x4EE3,364,
0x4EE4,360,
0x4EE5,348,
0x4EEE,382,
0x4EF0,375,
0x4EF2,378,
0x4EF6,368,
0x4EFB,374,
0x4EFF,365,
0x4F01,373,
0x4F09,367,
0x4F0A,372,
0x4F0D,369,
0x4F0E,371,
0x4F0F,377,
0x4F10,370,
0x4F11,380,
0x4F1A,381,
0x4F1C,366,
0x4F1D,379,
0x4F2F,397,
0x4F30,387,
0x4F34,396,
0x4F36,388,
0x4F38,403,
0x4F3A,395,
0x4F3C,376,
0x4F3D,398,
0x4F43,390,
0x4F46,394,
0x4F47,391,
0x4F4D,401,
0x4F4E,406,
0x4F4F,404,
0x4F50,392,
0x4F51,389,
0x4F53,405,
0x4F55,409,
0x4F57,386,
0x4F57,399,
0x4F59,5168,
0x4F59,408,
0x4F5A,393,
0x4F5B,385,
0x4F5C,407,
0x4F5E,400,
0x4F69,420,
0x4F6A,413,
0x4F6F,419,
0x4F70,410,
0x4F73,429,
0x4F75,425,
0x4F76,418,
0x4F7B,412,
0x4F7F,432,
0x4F83,416,
0x4F86,204,
0x4F88,414,
0x4F8B,428,
0x4F8D,427,
0x4F8F,417,
0x4F91,411,
0x4F98,415,
0x4F9B,431,
0x4F9D,426,
0x4FA0,445,
0x4FA1,422,
0x4FAE,421,
0x4FAE,434,
0x4FAF,443,
0x4FB5,452,
0x4FB6,440,
0x4FBF,450,
0x4FBF,451,
0x4FC2,449,
0x4FC3,444,
0x4FC4,447,
0x4FCA,448,
0x4FCE,441,
0x4FCF,439,
0x4FD0,433,
0x4FD7,453,
0x4FD8,442,
0x4FDA,446,
0x4FDD,455,
0x4FDF,438,
0x4FE0,445,
0x4FE1,454,
0x4FE3,437,
0x4FE4,435,
0x4FE5,436,
0x4FEE,491,
0x4FEF,484,
0x4FF1,477,
0x4FF2,459,
0x4FF2,513,
0x4FF3,485,
0x4FF5,467,
0x4FF8,480,
0x4FFA,472,
0x5002,458,
0x5005,456,
0x5006,463,
0x5009,486,
0x500B,147,
0x500D,483,
0x5012,487,
0x5014,470,
0x5016,462,
0x5018,468,
0x5019,481,
0x501A,476,
0x501F,490,
0x5021,457,
0x5021,478,
0x5022,461,
0x5023,466,
0x5024,488,
0x5025,469,
0x5026,482,
0x5028,473,
0x5029,464,
0x502A,460,
0x502B,474,
0x502D,475,
0x5036,477,
0x5039,479,
0x5043,503,
0x5047,493,
0x5049,506,
0x504F,511,
0x5053,500,
0x5055,501,
0x5056,498,
0x505A,495,
0x505C,507,
0x5065,512,
0x506C,494,
0x5072,499,
0x5074,509,
0x5075,502,
0x5076,508,
0x5078,504,
0x507D,510,
0x5080,516,
0x5085,515,
0x508D,520,
0x5091,517,
0x5098,518,
0x5099,519,
0x509A,513,
0x50AC,533,
0x50AD,530,
0x50B2,529,
0x50B3,521,
0x50B4,525,
0x50B5,531,
0x50B7,535,
0x50BE,534,
0x50C2,523,
0x50C5,527,
0x50CA,524,
0x50CD,532,
0x50CF,540,
0x50D1,539,
0x50D5,544,
0x50DA,545,
0x50DE,537,
0x50E3,546,
0x50E5,542,
0x50E7,536,
0x50E7,538,
0x50ED,560,
0x50EE,541,
0x50F9,548,
0x50F9,422,
0x50FB,553,
0x5100,554,
0x5101,543,
0x5104,551,
0x5108,549,
0x5109,547,
0x5112,561,
0x5114,557,
0x5115,559,
0x5118,558,
0x511A,550,
0x511F,563,
0x5121,562,
0x512A,564,
0x5132,565,
0x5137,566,
0x513A,567,
0x513C,569,
0x5140,4,
0x5141,843,
0x5143,275,
0x5144,875,
0x5145,289,
0x5146,637,
0x5147,570,
0x5148,571,
0x5149,1358,
0x514B,772,
0x514C,582,
0x514D,189,
0x514D,573,
0x514E,198,
0x5150,572,
0x5152,3850,
0x5154,675,
0x515A,1363,
0x515C,232,
0x5165,574,
0x5168,384,
0x5168,576,
0x5169,34,
0x5169,44,
0x516B,577,
0x516C,579,
0x516D,283,
0x5171,581,
0x5175,201,
0x5176,590,
0x5177,585,
0x5177,3128,
0x5178,588,
0x5179,592,
0x517C,598,
0x517E,608,
0x5180,614,
0x5185,82,
0x5186,617,
0x518A,88,
0x518C,169,
0x518D,35,
0x5190,2102,
0x5191,3747,
0x5192,623,
0x5192,2102,
0x5192,2117,
0x5192,3742,
0x5195,2130,
0x5195,624,
0x5197,625,
0x5197,1277,
0x5199,626,
0x5199,1278,
0x51A0,627,
0x51A2,629,
0x51A4,631,
0x51A5,630,
0x51A8,1321,
0x51AA,632,
0x51AC,633,
0x51AC,1161,
0x51B0,634,
0x51B2,636,
0x51B4,641,
0x51B4,635,
0x51B5,639,
0x51B6,640,
0x51B7,642,
0x51BD,643,
0x51C4,647,
0x51C6,648,
0x51C9,644,
0x51CB,645,
0x51CC,646,
0x51CD,649,
0x51D6,785,
0x51DB,651,
0x51DD,652,
0x51E0,653,
0x51E1,654,
0x51E2,148,
0x51E6,1162,
0x51E7,655,
0x51E9,656,
0x51EA,657,
0x51ED,659,
0x51F0,660,
0x51F1,661,
0x51F6,663,
0x51F8,90,
0x51F9,664,
0x51FA,1408,
0x51FA,97,
0x51FD,49,
0x51FE,105,
0x5200,665,
0x5203,152,
0x5206,578,
0x5207,667,
0x5208,666,
0x520A,1493,
0x520E,669,
0x5211,670,
0x5217,2438,
0x521D,4215,
0x5220,672,
0x5224,673,
0x5225,674,
0x5227,671,
0x5229,3264,
0x522E,3857,
0x5230,3846,
0x5232,676,
0x5233,680,
0x5236,683,
0x5237,210,
0x5238,678,
0x5239,679,
0x523A,682,
0x523B,681,
0x5243,691,
0x5244,687,
0x5247,4487,
0x524A,690,
0x524B,686,
0x524B,776,
0x524C,688,
0x524D,595,
0x5254,694,
0x5256,693,
0x525B,114,
0x5263,556,
0x5263,696,
0x5264,5424,
0x5265,695,
0x5269,700,
0x526A,599,
0x526F,699,
0x5270,698,
0x5272,703,
0x5273,697,
0x5274,701,
0x5275,702,
0x527D,705,
0x527F,704,
0x5282,243,
0x5283,707,
0x5284,706,
0x5287,247,
0x5288,710,
0x5289,709,
0x528D,708,
0x5292,711,
0x5292,556,
0x5294,556,
0x529B,715,
0x529F,1454,
0x52A0,716,
0x52A3,185,
0x52A9,719,
0x52AA,717,
0x52AB,718,
0x52B1,193,
0x52B4,720,
0x52B9,722,
0x52BE,721,
0x52C1,723,
0x52C3,724,
0x52C5,725,
0x52C5,2048,
0x52C7,726,
0x52C9,214,
0x52C9,228,
0x52C9,684,
0x52D2,5089,
0x52D5,730,
0x52D8,729,
0x52D9,728,
0x52D9,3167,
0x52DD,3787,
0x52DE,731,
0x52DF,3996,
0x52E2,735,
0x52E4,732,
0x52E4,733,
0x52E6,734,
0x52E7,736,
0x52F2,2794,
0x52F3,738,
0x52F5,737,
0x52F8,739,
0x52FA,740,
0x52FE,741,
0x52FF,743,
0x5301,159,
0x5302,742,
0x5305,176,
0x5306,744,
0x5308,746,
0x530D,748,
0x5310,749,
0x5315,750,
0x5316,350,
0x5317,751,
0x5317,20,
0x5319,2131,
0x531D,759,
0x5320,761,
0x5321,760,
0x5323,762,
0x532A,765,
0x5331,767,
0x5339,756,
0x533A,757,
0x533B,763,
0x533F,764,
0x5340,766,
0x5341,768,
0x5343,156,
0x5345,78,
0x5346,769,
0x5347,160,
0x5348,162,
0x5349,85,
0x5349,771,
0x534A,132,
0x534A,167,
0x534B,84,
0x534B,98,
0x534C,87,
0x534D,79,
0x5350,12,
0x5351,221,
0x5352,294,
0x5353,802,
0x5354,774,
0x5354,780,
0x5357,778,
0x5358,139,
0x535A,787,
0x535C,797,
0x5360,799,
0x5366,801,
0x536F,806,
0x5370,102,
0x5371,187,
0x5373,811,
0x5373,3886,
0x5374,808,
0x5375,199,
0x5377,810,
0x5378,812,
0x5379,4206,
0x537A,807,
0x537B,4459,
0x537D,811,
0x537F,813,
0x5382,814,
0x5384,816,
0x5393,821,
0x5396,822,
0x5398,823,
0x539A,824,
0x539F,825,
0x53A0,826,
0x53A5,828,
0x53A6,827,
0x53A8,829,
0x53A8,1527,
0x53A9,832,
0x53AD,834,
0x53B2,831,
0x53B3,253,
0x53B6,842,
0x53BB,1051,
0x53C2,850,
0x53C3,850,
0x53C3,854,
0x53C8,855,
0x53C9,856,
0x53CA,154,
0x53CA,157,
0x53CB,858,
0x53CC,859,
0x53CC,866,
0x53CD,817,
0x53CE,860,
0x53CE,857,
0x53CE,2042,
0x53CE,2043,
0x53D4,861,
0x53D6,3699,
0x53D7,2826,
0x53D9,862,
0x53DB,220,
0x53DF,863,
0x53E1,865,
0x53E2,144,
0x53E3,868,
0x53E4,770,
0x53E5,745,
0x53E9,876,
0x53EA,874,
0x53EB,881,
0x53EC,668,
0x53ED,869,
0x53EE,872,
0x53EF,24,
0x53F0,848,
0x53F1,873,
0x53F2,91,
0x53F3,878,
0x53F6,871,
0x53F7,882,
0x53F8,877,
0x53FA,870,
0x5403,880,
0x5404,1163,
0x5408,383,
0x5409,1053,
0x540A,884,
0x540B,879,
0x540C,619,
0x540D,1170,
0x540E,181,
0x540F,183,
0x5410,883,
0x5411,101,
0x541B,899,
0x541D,2066,
0x541E,191,
0x541F,898,
0x5420,897,
0x5426,40,
0x542B,402,
0x5433,887,
0x5436,894,
0x5438,888,
0x5438,885,
0x5439,901,
0x543B,892,
0x543C,893,
0x543E,37,
0x543F,2854,
0x5442,891,
0x5446,896,
0x5448,895,
0x5449,583,
0x544A,900,
0x544A,2854,
0x544E,890,
0x5451,39,
0x545F,903,
0x5468,622,
0x546A,912,
0x5471,906,
0x5473,913,
0x5475,911,
0x5476,905,
0x547B,910,
0x547C,914,
0x547D,430,
0x5480,907,
0x5484,909,
0x5486,904,
0x548C,3268,
0x548E,908,
0x548F,902,
0x54A4,916,
0x54A8,915,
0x54AB,216,
0x54AC,919,
0x54AF,917,
0x54B2,922,
0x54B3,921,
0x54BD,920,
0x54C0,304,
0x54C1,889,
0x54C1,923,
0x54C4,918,
0x54C9,777,
0x54E1,928,
0x54E5,56,
0x54E8,930,
0x54E9,927,
0x54ED,2880,
0x54EE,926,
0x54F2,931,
0x54FA,929,
0x5504,924,
0x5506,925,
0x5507,4654,
0x5510,1516,
0x5516,939,
0x552F,942,
0x5531,941,
0x5538,937,
0x553E,938,
0x5540,934,
0x5544,935,
0x5546,278,
0x5546,321,
0x554F,4944,
0x5553,940,
0x5556,933,
0x5557,932,
0x555C,936,
0x555E,939,
0x5563,956,
0x557B,279,
0x557C,945,
0x5580,952,
0x5583,951,
0x5584,606,
0x5587,957,
0x5589,960,
0x558A,949,
0x558B,959,
0x5598,954,
0x5599,946,
0x559A,958,
0x559C,1115,
0x559C,265,
0x559D,953,
0x559E,950,
0x559F,948,
0x55A7,962,
0x55A8,944,
0x55A9,947,
0x55AA,117,
0x55AB,961,
0x55AC,239,
0x55AE,943,
0x55B0,955,
0x55B6,963,
0x55B6,1006,
0x55C4,971,
0x55C5,973,
0x55C7,67,
0x55C9,966,
0x55DA,968,
0x55DB,965,
0x55DC,972,
0x55DF,970,
0x55E3,969,
0x55E4,967,
0x55F7,979,
0x55F8,979,
0x55FD,981,
0x55FE,977,
0x5606,974,
0x5606,975,
0x5608,978,
0x5609,1136,
0x5614,982,
0x5616,980,
0x5617,1369,
0x5618,993,
0x561B,976,
0x5629,964,
0x562F,999,
0x5631,989,
0x5631,1023,
0x5632,992,
0x5634,1000,
0x5636,987,
0x5638,988,
0x5640,986,
0x5642,991,
0x564C,984,
0x564E,990,
0x565A,985,
0x565B,1012,
0x5664,1004,
0x5666,1009,
0x5668,994,
0x5668,996,
0x566A,1001,
0x566C,997,
0x566F,1002,
0x5674,995,
0x5678,1005,
0x567A,998,
0x5680,1007,
0x5686,1003,
0x5687,1008,
0x5694,1010,
0x5699,1012,
0x56A0,1011,
0x56A2,122,
0x56A5,1015,
0x56AC,1014,
0x56AE,1013,
0x56B4,256,
0x56BC,1016,
0x56C0,1017,
0x56C1,1018,
0x56C2,1020,
0x56C3,1019,
0x56C8,1021,
0x56CA,124,
0x56D1,1023,
0x56D8,618,
0x56DA,1024,
0x56DB,1025,
0x56DE,1028,
0x56E0,1026,
0x56E3,1027,
0x56EC,1029,
0x56EE,1031,
0x56EF,1030,
0x56F0,1033,
0x56F2,1032,
0x56F3,1034,
0x56F9,1035,
0x56FA,1036,
0x56FD,1037,
0x5700,1038,
0x5703,1040,
0x5704,1039,
0x5708,1041,
0x570A,1043,
0x570B,1042,
0x570D,1044,
0x570F,1045,
0x5712,1047,
0x5713,1046,
0x5716,1048,
0x5718,1049,
0x571F,1050,
0x5727,818,
0x5727,839,
0x5728,1055,
0x572D,1052,
0x5730,1056,
0x5740,1058,
0x5742,1061,
0x5747,1065,
0x574A,1062,
0x574F,1060,
0x5750,41,
0x5751,1063,
0x575A,1057,
0x5761,1068,
0x5764,1070,
0x5766,1071,
0x5769,1069,
0x576A,1072,
0x5782,211,
0x578B,1077,
0x579B,1074,
0x579C,1074,
0x57A2,1076,
0x57A3,1075,
0x57C3,1081,
0x57CB,1084,
0x57CE,1078,
0x57CE,1079,
0x57D2,1083,
0x57DF,1085,
0x57E0,1089,
0x57E6,1086,
0x57F4,1090,
0x57F5,1087,
0x57F7,1097,
0x57F9,1091,
0x57FA,1098,
0x57FC,1088,
0x5800,1095,
0x5802,1365,
0x5805,1057,
0x5805,1096,
0x5806,1094,
0x580A,59,
0x5815,1092,
0x5819,1106,
0x581D,1105,
0x5821,1107,
0x5824,1108,
0x582A,1112,
0x5830,1111,
0x5831,1114,
0x5834,1113,
0x5835,1110,
0x583A,1101,
0x5840,1103,
0x5840,1131,
0x5841,3009,
0x584A,1122,
0x584B,1118,
0x5851,1121,
0x5852,1117,
0x5854,1109,
0x5857,1124,
0x5858,1119,
0x5859,1116,
0x585A,1104,
0x585A,1120,
0x585E,1324,
0x5861,1123,
0x5869,3125,
0x5869,1125,
0x5869,3126,
0x586B,1123,
0x5872,1126,
0x5875,5376,
0x5879,1134,
0x587E,1133,
0x5883,1135,
0x5893,4027,
0x5897,1137,
0x5897,1138,
0x589C,1132,
0x589E,1137,
0x589E,1138,
0x589F,1130,
0x589F,1139,
0x58A8,5404,
0x58AE,1092,
0x58AE,1129,
0x58B3,1141,
0x58BA,1145,
0x58BB,1144,
0x58BE,1142,
0x58C1,1148,
0x58C5,332,
0x58C7,1146,
0x58CA,1147,
0x58CC,1143,
0x58D1,1150,
0x58D3,250,
0x58D3,839,
0x58D4,1149,
0x58D5,1151,
0x58D8,3015,
0x58D9,1152,
0x58DC,1156,
0x58DE,1154,
0x58DF,5441,
0x58E0,1155,
0x58E4,1157,
0x58EB,1160,
0x58EC,2921,
0x58EE,2837,
0x58EF,2837,
0x58F0,1066,
0x58F1,1059,
0x58F2,1067,
0x58F7,1093,
0x58F9,1100,
0x58FA,1099,
0x58FB,1102,
0x58FD,1128,
0x5909,306,
0x5909,1166,
0x590F,58,
0x5915,1167,
0x5916,1168,
0x5919,658,
0x591A,1169,
0x591A,1580,
0x591B,1580,
0x591C,298,
0x5922,4028,
0x5925,120,
0x5927,1171,
0x5929,16,
0x592A,1172,
0x592B,164,
0x592D,161,
0x592E,86,
0x5931,178,
0x5937,182,
0x593E,192,
0x5944,1173,
0x5947,1176,
0x5948,1174,
0x5949,212,
0x594C,800,
0x594F,1178,
0x5951,1177,
0x5954,1175,
0x5955,301,
0x5957,1179,
0x5960,602,
0x5962,1180,
0x5965,240,
0x5968,1181,
0x596A,1183,
0x596C,1182,
0x596C,1181,
0x596E,1184,
0x5973,1185,
0x5974,1186,
0x5978,1190,
0x597D,1191,
0x5981,1187,
0x5982,1189,
0x5983,1188,
0x5984,288,
0x598A,1197,
0x598D,1195,
0x5992,1192,
0x5993,1194,
0x5996,1198,
0x5999,1199,
0x59A3,1193,
0x59A5,2823,
0x59A8,1196,
0x59AC,1205,
0x59B9,1204,
0x59BB,1206,
0x59BE,3346,
0x59C6,1200,
0x59C9,1207,
0x59CB,1208,
0x59D0,1202,
0x59D1,1201,
0x59D3,1203,
0x59D4,3267,
0x59D9,1209,
0x59DC,3657,
0x59E5,1213,
0x59E6,1217,
0x59EA,1212,
0x59EB,1216,
0x59EC,1218,
0x59F8,1210,
0x59FB,1214,
0x59FF,1215,
0x5A01,1803,
0x5A11,1224,
0x5A18,1225,
0x5A1B,1226,
0x5A1C,1211,
0x5A1F,1221,
0x5A20,1220,
0x5A23,1222,
0x5A29,1219,
0x5A2F,1226,
0x5A35,1231,
0x5A36,1230,
0x5A3C,457,
0x5A3C,1235,
0x5A40,1223,
0x5A41,1229,
0x5A46,1234,
0x5A49,1233,
0x5A5A,1236,
0x5A62,1232,
0x5A66,1237,
0x5A6A,1228,
0x5A6C,1227,
0x5A7F,1239,
0x5A92,1241,
0x5A9A,1240,
0x5A9B,1238,
0x5AB3,1244,
0x5ABC,1243,
0x5ABD,1242,
0x5ABE,1246,
0x5AC1,1249,
0x5AC2,1245,
0x5AC9,1248,
0x5ACB,1247,
0x5ACC,1250,
0x5AE1,1253,
0x5AE3,1251,
0x5AE9,1252,
0x5B09,1255,
0x5B0B,1254,
0x5B0C,1256,
0x5B16,1258,
0x5B22,1257,
0x5B2A,1259,
0x5B30,1260,
0x5B32,3014,
0x5B36,1261,
0x5B40,1263,
0x5B43,1262,
0x5B50,1264,
0x5B51,269,
0x5B54,1265,
0x5B55,1266,
0x5B57,1281,
0x5B58,1267,
0x5B5C,1268,
0x5B5D,773,
0x5B5F,1269,
0x5B63,3266,
0x5B64,1270,
0x5B66,1271,
0x5B69,1272,
0x5B6B,1273,
0x5B70,316,
0x5B73,603,
0x5B75,244,
0x5B76,1274,
0x5B78,1275,
0x5B7A,1276,
0x5B82,1277,
0x5B85,1279,
0x5B87,1280,
0x5B88,1282,
0x5B89,1283,
0x5B8B,1285,
0x5B8C,1288,
0x5B8D,1284,
0x5B8F,1286,
0x5B95,1289,
0x5B97,1294,
0x5B98,1295,
0x5B99,1291,
0x5B9A,1296,
0x5B9B,1292,
0x5B9C,1290,
0x5B9D,1293,
0x5B9F,1297,
0x5B9F,1329,
0x5BA2,1302,
0x5BA3,1301,
0x5BA4,1300,
0x5BA5,1299,
0x5BA6,1298,
0x5BAE,1310,
0x5BB0,1303,
0x5BB3,1306,
0x5BB4,1304,
0x5BB5,1307,
0x5BB6,1311,
0x5BB8,1305,
0x5BB9,1309,
0x5BBF,1317,
0x5BC2,1315,
0x5BC3,1312,
0x5BC4,1318,
0x5BC5,1314,
0x5BC6,1316,
0x5BC7,1313,
0x5BCC,1321,
0x5BD0,1319,
0x5BD2,1322,
0x5BD3,1320,
0x5BDB,1325,
0x5BDD,1326,
0x5BDE,1323,
0x5BDF,1334,
0x5BE1,1337,
0x5BE2,1327,
0x5BE4,1332,
0x5BE5,1333,
0x5BE6,1329,
0x5BE7,1335,
0x5BE8,1331,
0x5BE9,1341,
0x5BEB,1338,
0x5BEC,1328,
0x5BEE,1340,
0x5BF3,1345,
0x5BF5,1346,
0x5BF6,1347,
0x5BF8,1348,
0x5BFA,1054,
0x5BFE,2067,
0x5BFF,194,
0x5C01,1349,
0x5C02,1350,
0x5C04,4603,
0x5C05,779,
0x5C06,2840,
0x5C08,1351,
0x5C09,231,
0x5C0A,607,
0x5C0B,1583,
0x5C0B,1585,
0x5C0C,1352,
0x5C0D,1353,
0x5C0E,1354,
0x5C0F,1355,
0x5C11,166,
0x5C12,575,
0x5C12,354,
0x5C13,168,
0x5C13,1356,
0x5C16,1357,
0x5C1A,1361,
0x5C1F,2147,
0x5C20,142,
0x5C24,128,
0x5C28,136,
0x5C31,323,
0x5C38,1376,
0x5C39,158,
0x5C3A,1377,
0x5C3B,1379,
0x5C3C,1378,
0x5C3D,1380,
0x5C3D,3120,
0x5C3E,1383,
0x5C3F,1382,
0x5C40,886,
0x5C40,1384,
0x5C41,1381,
0x5C45,1387,
0x5C48,1386,
0x5C4A,1385,
0x5C4B,1392,
0x5C4D,1391,
0x5C4E,1390,
0x5C4F,1388,
0x5C50,1393,
0x5C51,1395,
0x5C53,1394,
0x5C55,1396,
0x5C5B,1398,
0x5C5E,1389,
0x5C5E,1400,
0x5C60,1399,
0x5C61,1401,
0x5C62,1401,
0x5C64,1402,
0x5C64,1403,
0x5C65,1404,
0x5C6C,1405,
0x5C6D,1406,
0x5C6F,264,
0x5C71,1407,
0x5C79,1409,
0x5C90,1410,
0x5CA1,621,
0x5CA8,1411,
0x5CA9,1414,
0x5CAC,1412,
0x5CB3,208,
0x5CB8,1413,
0x5CD9,1415,
0x5CE0,1416,
0x5CE1,1417,
0x5CE8,1422,
0x5CE9,1422,
0x5CED,1421,
0x5CF0,1423,
0x5CF6,5343,
0x5CF6,230,
0x5CFB,1424,
0x5CFD,1419,
0x5D07,1429,
0x5D0E,1426,
0x5D16,1428,
0x5D17,1425,
0x5D29,1430,
0x5D2B,1427,
0x5D4C,1432,
0x5D50,1431,
0x5D69,1433,
0x5D84,1436,
0x5D87,1435,
0x5D8B,1434,
0x5D8B,5343,
0x5DAE,1437,
0x5DB7,1441,
0x5DBA,1440,
0x5DBC,1438,
0x5DBD,1439,
0x5DC7,1443,
0x5DCC,1442,
0x5DCD,1444,
0x5DD2,1445,
0x5DD3,1446,
0x5DDD,1447,
0x5DDE,99,
0x5DE1,4667,
0x5DE2,1449,
0x5DE3,141,
0x5DE5,3,
0x5DE5,1451,
0x5DE6,1455,
0x5DE7,1453,
0x5DE8,19,
0x5DE8,758,
0x5DE8,1452,
0x5DEB,38,
0x5DEE,3662,
0x5DF1,1462,
0x5DF2,1461,
0x5DF3,1460,
0x5DF4,263,
0x5DF7,809,
0x5DF7,1465,
0x5DFB,1466,
0x5DFD,601,
0x5DFE,1467,
0x5E02,284,
0x5E03,1468,
0x5E06,1469,
0x5E08,29,
0x5E0C,1470,
0x5E11,1472,
0x5E16,1473,
0x5E19,1471,
0x5E1A,1581,
0x5E1B,3096,
0x5E1D,305,
0x5E1D,277,
0x5E25,109,
0x5E2B,113,
0x5E2D,1513,
0x5E2F,1474,
0x5E30,1582,
0x5E33,1478,
0x5E36,1475,
0x5E37,1477,
0x5E38,1364,
0x5E3D,1476,
0x5E3D,1483,
0x5E40,1480,
0x5E43,1479,
0x5E44,1481,
0x5E45,1484,
0x5E47,1482,
0x5E4C,1485,
0x5E54,1486,
0x5E55,4026,
0x5E5F,1488,
0x5E61,1489,
0x5E63,1490,
0x5E6E,1491,
0x5E72,1492,
0x5E73,26,
0x5E74,188,
0x5E76,580,
0x5E77,203,
0x5E78,1073,
0x5E79,790,
0x5E7B,1494,
0x5E7C,1495,
0x5E7D,112,
0x5E7E,1496,
0x5E81,1498,
0x5E83,1499,
0x5E84,1500,
0x5E87,1501,
0x5E8A,1503,
0x5E8F,1502,
0x5E95,1508,
0x5E96,1506,
0x5E97,1509,
0x5E9A,1505,
0x5E9C,1507,
0x5EA6,1511,
0x5EA7,1515,
0x5EA7,1517,
0x5EAB,1512,
0x5EAD,1514,
0x5EB5,1521,
0x5EB6,1522,
0x5EB7,1518,
0x5EB8,1520,
0x5EC1,1523,
0x5EC1,826,
0x5EC2,1525,
0x5EC3,1526,
0x5EC4,1531,
0x5EC8,1528,
0x5EC9,1530,
0x5ECA,1524,
0x5ECA,1519,
0x5ECF,1531,
0x5ED0,832,
0x5ED3,1529,
0x5EDA,1533,
0x5EDB,1537,
0x5EDF,1538,
0x5EE0,1536,
0x5EE2,1534,
0x5EE3,1535,
0x5EE9,1540,
0x5EEC,1543,
0x5EF3,1545,
0x5EF6,1547,
0x5EF7,1546,
0x5EFA,1549,
0x5EFB,1548,
0x5EFF,1550,
0x5F01,4652,
0x5F01,846,
0x5F01,4649,
0x5F01,4651,
0x5F01,845,
0x5F04,2924,
0x5F0A,1551,
0x5F0B,1552,
0x5F0C,1553,
0x5F0D,1554,
0x5F0E,1555,
0x5F0F,1556,
0x5F10,1554,
0x5F10,32,
0x5F11,1558,
0x5F13,1560,
0x5F14,80,
0x5F15,1562,
0x5F16,1561,
0x5F17,173,
0x5F18,1563,
0x5F1B,1564,
0x5F1F,584,
0x5F25,1565,
0x5F26,1568,
0x5F27,1567,
0x5F29,1566,
0x5F31,650,
0x5F31,1569,
0x5F35,1570,
0x5F37,1571,
0x5F37,1572,
0x5F3A,1572,
0x5F3C,1573,
0x5F3E,1575,
0x5F48,1576,
0x5F4A,1577,
0x5F4C,1578,
0x5F4E,1579,
0x5F53,1359,
0x5F57,1584,
0x5F59,1586,
0x5F5C,1587,
0x5F5D,1587,
0x5F5D,1588,
0x5F62,1589,
0x5F65,2068,
0x5F66,3347,
0x5F69,1590,
0x5F6B,236,
0x5F6D,1591,
0x5F70,1593,
0x5F71,1594,
0x5F73,1595,
0x5F77,1597,
0x5F79,1598,
0x5F7C,1604,
0x5F7D,1599,
0x5F7F,1601,
0x5F80,1605,
0x5F81,1603,
0x5F82,1600,
0x5F84,1602,
0x5F85,1609,
0x5F8A,1606,
0x5F8B,1608,
0x5F8C,1610,
0x5F90,1612,
0x5F91,1611,
0x5F92,1614,
0x5F93,1613,
0x5F97,1622,
0x5F98,1619,
0x5F9B,1617,
0x5F9C,1618,
0x5F9E,1615,
0x5FA0,1616,
0x5FA1,1628,
0x5FA7,1624,
0x5FA8,1623,
0x5FA9,1627,
0x5FAA,1625,
0x5FAE,1631,
0x5FB3,1633,
0x5FB4,1634,
0x5FB5,1635,
0x5FB7,1636,
0x5FB7,1633,
0x5FB9,1637,
0x5FBD,1642,
0x5FC3,1645,
0x5FC5,129,
0x5FCC,1463,
0x5FCD,1648,
0x5FD6,1646,
0x5FD7,1064,
0x5FD8,291,
0x5FD9,1647,
0x5FDC,1504,
0x5FDD,46,
0x5FDD,209,
0x5FE0,1653,
0x5FE9,586,
0x5FEB,1654,
0x5FF0,1649,
0x5FF5,424,
0x5FF7,1650,
0x5FF8,1651,
0x5FFD,1652,
0x5FFF,587,
0x600F,1657,
0x6012,1664,
0x6016,1662,
0x601C,1658,
0x601D,3001,
0x6020,851,
0x6025,1667,
0x6027,1666,
0x6028,1663,
0x6029,1566,
0x6029,1655,
0x602A,1665,
0x602B,1659,
0x602F,1661,
0x6031,1660,
0x603A,1656,
0x6043,1668,
0x604B,313,
0x604B,1793,
0x604D,1671,
0x6050,1685,
0x6052,1683,
0x6055,1670,
0x6059,3660,
0x605A,1080,
0x605F,1669,
0x6062,1678,
0x6063,1674,
0x6064,1676,
0x6065,3704,
0x6068,1677,
0x6069,1684,
0x606A,1672,
0x606B,1673,
0x606C,1679,
0x606D,1680,
0x606F,3844,
0x6070,1675,
0x6075,1681,
0x6083,1693,
0x6084,1695,
0x6089,4808,
0x608B,1692,
0x608C,1690,
0x608D,1691,
0x6092,1688,
0x6094,1682,
0x6094,1686,
0x6096,1699,
0x609A,1689,
0x609B,1687,
0x609F,1700,
0x60A0,1701,
0x60A3,1697,
0x60A6,1696,
0x60A7,1694,
0x60A9,1698,
0x60AA,62,
0x60B2,5082,
0x60B4,1704,
0x60B5,1707,
0x60B6,4947,
0x60B8,1705,
0x60BC,1706,
0x60C5,1714,
0x60D1,1710,
0x60DA,1711,
0x60DC,1712,
0x60DF,1709,
0x60E0,1702,
0x60E1,63,
0x60E3,1708,
0x60E7,1703,
0x60E8,1713,
0x60F0,1727,
0x60F1,1717,
0x60F3,1728,
0x60F6,1720,
0x60F9,3991,
0x60FB,1722,
0x60FC,1718,
0x6100,1721,
0x6101,1729,
0x6106,1719,
0x6108,526,
0x6109,1726,
0x610D,1724,
0x610F,5113,
0x6112,1715,
0x6115,1723,
0x611A,1730,
0x611B,2829,
0x611F,1731,
0x611F,1807,
0x6120,1716,
0x6127,1739,
0x6134,1740,
0x613E,1734,
0x6142,1733,
0x6144,1738,
0x6147,1737,
0x6148,612,
0x614A,1736,
0x614B,1743,
0x614C,1725,
0x614D,1732,
0x614E,1742,
0x6155,4040,
0x6158,1744,
0x615A,1754,
0x615F,1750,
0x6162,1755,
0x6163,1756,
0x6165,1735,
0x6167,1753,
0x6168,1741,
0x6168,1761,
0x616B,1749,
0x616E,4112,
0x6170,1758,
0x6173,1751,
0x6174,1752,
0x6176,1539,
0x6177,1748,
0x617C,1747,
0x617C,1812,
0x617E,1746,
0x6182,70,
0x6187,1745,
0x618A,1762,
0x618E,1757,
0x618E,1759,
0x6190,1772,
0x6191,1769,
0x6194,1768,
0x6196,1764,
0x619A,1770,
0x61A4,1773,
0x61A7,1767,
0x61A9,1765,
0x61AB,1771,
0x61AC,1763,
0x61AE,1766,
0x61B2,1342,
0x61B6,1780,
0x61BA,1776,
0x61BE,1778,
0x61C3,1774,
0x61C7,1781,
0x61C8,1779,
0x61C9,1541,
0x61CA,1777,
0x61CC,1775,
0x61D0,1782,
0x61E3,1783,
0x61E6,1784,
0x61F2,1785,
0x61F2,1786,
0x61F4,1787,
0x61F6,1789,
0x61F7,1782,
0x61F7,1788,
0x61F8,1790,
0x61FA,1791,
0x61FC,1703,
0x61FC,1792,
0x6200,1793,
0x6208,1794,
0x620A,1795,
0x620C,1796,
0x620D,1797,
0x620E,1798,
0x6210,1800,
0x6210,1799,
0x6211,200,
0x6212,1801,
0x6216,1802,
0x621A,1804,
0x621B,61,
0x621B,64,
0x621E,64,
0x621E,1805,
0x621F,1806,
0x6221,1809,
0x6226,1814,
0x6226,1810,
0x6229,1811,
0x622A,793,
0x622E,1813,
0x622F,246,
0x6230,1814,
0x6231,1815,
0x6232,251,
0x6234,795,
0x6235,1816,
0x6238,1817,
0x623B,1818,
0x623F,1819,
0x6240,1821,
0x6241,1822,
0x6247,1823,
0x6248,1824,
0x6249,1825,
0x624B,1827,
0x624D,270,
0x6253,1829,
0x6255,1828,
0x6258,1835,
0x625B,1830,
0x625E,1832,
0x6260,1834,
0x6263,1833,
0x6268,1831,
0x626E,1844,
0x6271,1836,
0x6276,1850,
0x6279,1848,
0x627C,1842,
0x627F,197,
0x6280,1853,
0x6283,1839,
0x6284,1849,
0x6289,1840,
0x628A,1846,
0x6291,1851,
0x6292,1841,
0x6293,1843,
0x6294,1838,
0x6295,1856,
0x6297,1852,
0x6298,1855,
0x629C,1854,
0x629E,1845,
0x62AB,1874,
0x62B1,1883,
0x62B5,1878,
0x62B9,1870,
0x62BC,1885,
0x62BD,1877,
0x62C2,1857,
0x62C5,1879,
0x62C6,1860,
0x62C7,1868,
0x62C8,1866,
0x62C9,1867,
0x62CA,1863,
0x62CB,1837,
0x62CB,1875,
0x62CC,1861,
0x62CD,1872,
0x62CD,1886,
0x62CF,1862,
0x62D0,1865,
0x62D2,1847,
0x62D2,1858,
0x62D3,1873,
0x62D4,1859,
0x62D7,1869,
0x62D8,1881,
0x62D9,1880,
0x62DB,1882,
0x62DD,1884,
0x62E0,2003,
0x62E0,1871,
0x62E1,1876,
0x62EC,1896,
0x62ED,1897,
0x62EE,1894,
0x62EF,1864,
0x62F1,1892,
0x62F3,1900,
0x62F5,1893,
0x62F6,1888,
0x62F7,1895,
0x62FE,1901,
0x62FF,471,
0x6301,1903,
0x6302,1890,
0x6307,1904,
0x6308,1887,
0x6309,1899,
0x630C,1889,
0x6311,1898,
0x6318,1891,
0x6319,3854,
0x6319,2007,
0x6319,1902,
0x6328,1910,
0x632B,1913,
0x632F,1920,
0x6335,1908,
0x633A,1914,
0x633D,1918,
0x633E,1915,
0x633F,1916,
0x6349,1909,
0x634B,1907,
0x634C,1912,
0x634F,1905,
0x6350,1906,
0x6355,1919,
0x6357,1911,
0x635C,1917,
0x635C,1968,
0x6365,1928,
0x6367,1939,
0x6368,1944,
0x6369,1942,
0x636B,1922,
0x636E,1935,
0x6372,1933,
0x6377,1938,
0x637A,1929,
0x637B,1940,
0x6383,1945,
0x6388,1946,
0x6389,1926,
0x638C,1366,
0x638F,1927,
0x6392,1948,
0x6396,1925,
0x6398,1943,
0x639B,1952,
0x639F,1921,
0x63A0,1931,
0x63A1,1947,
0x63A2,1949,
0x63A3,1923,
0x63A5,1951,
0x63A7,1941,
0x63A8,1950,
0x63A9,1932,
0x63AA,1930,
0x63AC,1937,
0x63B2,1934,
0x63B4,1985,
0x63BB,1980,
0x63C3,1957,
0x63C4,1955,
0x63C6,1956,
0x63C9,1962,
0x63CF,1936,
0x63D0,1967,
0x63D2,1953,
0x63DA,1966,
0x63DB,1964,
0x63E1,1963,
0x63E3,1958,
0x63E9,1954,
0x63EE,1960,
0x63F4,1961,
0x63F6,1924,
0x63FA,1965,
0x640D,1979,
0x640F,1970,
0x6414,1980,
0x6416,1969,
0x6417,1978,
0x641C,1968,
0x6422,1971,
0x6426,1972,
0x642C,1973,
0x642D,1959,
0x643A,1977,
0x643E,1975,
0x6442,1976,
0x6451,1985,
0x6458,1987,
0x6467,1983,
0x6469,5392,
0x646F,1982,
0x6478,1974,
0x6479,4035,
0x647A,1984,
0x6483,1986,
0x6488,1989,
0x6492,1998,
0x6493,1994,
0x649A,1997,
0x649E,1995,
0x64A4,1999,
0x64A5,2002,
0x64A6,1988,
0x64A9,1991,
0x64AB,2000,
0x64AD,1992,
0x64AE,2001,
0x64B0,1996,
0x64B2,1993,
0x64BB,1990,
0x64BC,2010,
0x64BF,2011,
0x64C1,2013,
0x64C2,2014,
0x64C5,2012,
0x64C7,2004,
0x64CA,2006,
0x64CD,2015,
0x64D2,2008,
0x64D4,1879,
0x64D4,2005,
0x64D8,2009,
0x64DA,2003,
0x64DA,1981,
0x64E0,2016,
0x64E1,2021,
0x64E2,2022,
0x64E3,2020,
0x64E4,2017,
0x64E6,2025,
0x64E7,2007,
0x64E7,3854,
0x64EC,2026,
0x64EF,2019,
0x64F1,2024,
0x64F2,2023,
0x64F4,2027,
0x64FA,2029,
0x64FD,2028,
0x64FE,2030,
0x64FF,2018,
0x6500,2031,
0x6518,2032,
0x651C,2034,
0x651D,2033,
0x6523,2035,
0x652A,2037,
0x652B,2036,
0x652C,2038,
0x652F,2039,
0x6532,2041,
0x6536,2042,
0x6536,2043,
0x6539,1464,
0x653B,1457,
0x653E,2084,
0x653F,2045,
0x6545,2044,
0x6548,2046,
0x654D,2050,
0x654F,2047,
0x654F,2049,
0x6551,2051,
0x6555,2048,
0x6557,4494,
0x6559,2052,
0x6562,2054,
0x6563,2056,
0x6566,2053,
0x656C,2055,
0x6570,2057,
0x6572,5249,
0x6574,2436,
0x6575,2060,
0x6577,2059,
0x6578,2058,
0x6582,2061,
0x6583,1373,
0x6587,2064,
0x6588,2065,
0x6589,5423,
0x658B,2070,
0x658E,5425,
0x6590,5081,
0x6591,2950,
0x6597,2073,
0x6599,3468,
0x659B,4302,
0x659C,2074,
0x659F,2075,
0x65A1,792,
0x65A4,2076,
0x65A5,175,
0x65A7,2833,
0x65AC,4613,
0x65AD,2078,
0x65AF,2079,
0x65B0,2080,
0x65B7,2081,
0x65B9,2082,
0x65BC,2083,
0x65BD,2085,
0x65C1,310,
0x65C3,2087,
0x65C5,2088,
0x65C6,2086,
0x65CB,2091,
0x65CC,2089,
0x65CF,2090,
0x65D2,2092,
0x65D7,2093,
0x65DB,2094,
0x65E2,2095,
0x65E2,3887,
0x65E3,2095,
0x65E5,2097,
0x65E6,2098,
0x65E7,4076,
0x65E7,94,
0x65E8,752,
0x65E9,2100,
0x65EC,747,
0x65ED,2099,
0x65F1,2101,
0x65FA,2104,
0x6602,2103,
0x6606,2106,
0x6607,2109,
0x660C,2105,
0x660E,2110,
0x660F,2479,
0x6613,2107,
0x6614,2108,
0x661E,2111,
0x661F,2121,
0x6620,2118,
0x6625,2122,
0x6627,2113,
0x6628,2119,
0x662D,2114,
0x662F,2120,
0x6635,2115,
0x663B,2103,
0x663B,2116,
0x663C,2127,
0x663C,53,
0x663C,3720,
0x6642,2126,
0x6644,2123,
0x6649,55,
0x664B,55,
0x664F,2124,
0x6652,2125,
0x665A,2128,
0x665A,2145,
0x665D,3720,
0x665D,2127,
0x665D,53,
0x6664,2129,
0x6666,2135,
0x6668,2133,
0x6669,2128,
0x6669,2145,
0x666E,605,
0x666E,609,
0x666F,2142,
0x6670,2136,
0x6674,2143,
0x6676,2137,
0x667A,2144,
0x6681,2139,
0x6681,2148,
0x6681,2158,
0x6687,2152,
0x6688,2151,
0x6689,2150,
0x668F,2149,
0x6691,2138,
0x6696,2153,
0x6697,2154,
0x669D,2155,
0x66A2,119,
0x66A6,833,
0x66AB,2156,
0x66AE,4041,
0x66B4,2157,
0x66B8,2159,
0x66C6,838,
0x66C7,2160,
0x66C9,2158,
0x66D6,2161,
0x66D9,2163,
0x66DC,2112,
0x66DC,2162,
0x66DD,2165,
0x66E0,2166,
0x66E9,2167,
0x66F0,2168,
0x66F2,103,
0x66F3,100,
0x66F4,42,
0x66F8,3719,
0x66F9,2134,
0x66FC,2132,
0x66FE,604,
0x66FF,2140,
0x6700,2146,
0x6703,522,
0x6708,2169,
0x6709,3727,
0x670B,3737,
0x670D,3741,
0x6714,3761,
0x6715,3757,
0x6717,3762,
0x6717,3769,
0x671B,2940,
0x671D,3788,
0x671E,3778,
0x671F,3785,
0x6726,3823,
0x6727,3833,
0x6728,2170,
0x672A,179,
0x672B,177,
0x672C,96,
0x672D,2171,
0x6731,184,
0x6734,2176,
0x6736,2173,
0x673A,2174,
0x673D,2175,
0x6743,2172,
0x6746,2178,
0x6749,2190,
0x674C,2180,
0x674E,2179,
0x674F,2185,
0x6750,2189,
0x6750,2193,
0x6751,2191,
0x6753,2187,
0x6756,2183,
0x6759,2184,
0x675C,2188,
0x675E,2182,
0x675F,196,
0x6760,2181,
0x6761,1164,
0x6762,2177,
0x6763,2186,
0x6765,202,
0x6765,204,
0x676A,2198,
0x676D,2203,
0x676F,52,
0x676F,2206,
0x6771,213,
0x6773,2197,
0x6775,2201,
0x6777,2195,
0x677C,2196,
0x677E,2212,
0x677F,2213,
0x6787,2200,
0x6789,2204,
0x6790,2194,
0x6795,2209,
0x6797,2210,
0x6798,2199,
0x679A,2202,
0x679C,107,
0x679D,2211,
0x67A0,2205,
0x67A1,2207,
0x67A2,2208,
0x67AF,2238,
0x67B6,2237,
0x67B7,2222,
0x67B8,2224,
0x67C1,2214,
0x67C4,2234,
0x67CA,2221,
0x67CF,2230,
0x67D0,2989,
0x67D1,2225,
0x67D3,2240,
0x67D4,3166,
0x67D8,2232,
0x67DA,2223,
0x67DD,2216,
0x67E2,2219,
0x67E9,2226,
0x67EE,2215,
0x67EF,2192,
0x67EF,2217,
0x67F0,2218,
0x67F1,2236,
0x67F3,2233,
0x67F4,2251,
0x67F5,2229,
0x67F9,2231,
0x67FB,2235,
0x67FE,2228,
0x67FF,2231,
0x6802,2227,
0x6803,2220,
0x6804,2239,
0x6813,2247,
0x6816,2248,
0x6817,4275,
0x681E,2243,
0x6821,2260,
0x682A,2257,
0x6838,2254,
0x6839,2261,
0x683C,2259,
0x683D,781,
0x6841,2250,
0x6842,2253,
0x6843,2255,
0x6846,2244,
0x6848,1308,
0x684E,2245,
0x6850,2249,
0x6851,864,
0x685B,2246,
0x685C,2256,
0x685D,2242,
0x685F,2284,
0x685F,2252,
0x6874,2270,
0x6876,2274,
0x6877,2265,
0x687F,2280,
0x6881,2281,
0x6883,2266,
0x6885,2258,
0x6885,2262,
0x688F,2263,
0x6893,2268,
0x6894,2272,
0x6897,2278,
0x689D,492,
0x689F,235,
0x68A0,2394,
0x68A2,2276,
0x68A8,2275,
0x68AD,2273,
0x68AE,2269,
0x68AF,2283,
0x68B0,2264,
0x68B1,2277,
0x68B3,2282,
0x68B5,140,
0x68B6,2279,
0x68BB,2267,
0x68C4,326,
0x68C9,2295,
0x68CB,2294,
0x68CD,2289,
0x68D2,2302,
0x68D5,2293,
0x68D7,116,
0x68D8,238,
0x68DA,2300,
0x68DF,2299,
0x68E7,2284,
0x68EE,2301,
0x68F1,2285,
0x68F2,2297,
0x68F9,2291,
0x68FA,2298,
0x6900,2287,
0x6905,2290,
0x690D,2303,
0x690E,2296,
0x6912,2286,
0x691A,2288,
0x691C,2304,
0x6930,2292,
0x6934,2312,
0x6936,2306,
0x693D,2316,
0x693F,2319,
0x694A,2321,
0x6953,2315,
0x6954,2323,
0x6955,2313,
0x695A,3022,
0x6960,2317,
0x6961,2309,
0x6962,2310,
0x696B,2320,
0x696D,143,
0x696E,2311,
0x696F,2314,
0x6975,2305,
0x6977,2318,
0x697C,2322,
0x697D,2324,
0x6982,2344,
0x698A,2330,
0x698E,2332,
0x6994,2307,
0x6995,2336,
0x699B,2333,
0x699C,2326,
0x69AE,2325,
0x69B4,2340,
0x69B4,2364,
0x69BB,2329,
0x69BB,2923,
0x69BE,2331,
0x69C1,2328,
0x69C3,2327,
0x69CA,2334,
0x69CB,2343,
0x69CC,2308,
0x69CD,2342,
0x69D3,2335,
0x69D8,2341,
0x69D9,2339,
0x69EA,2365,
0x69FB,2352,
0x69FD,2351,
0x69FF,2356,
0x6A02,2350,
0x6A05,2353,
0x6A0B,2338,
0x6A0F,2355,
0x6A12,2354,
0x6A13,2348,
0x6A19,2359,
0x6A1E,2346,
0x6A1F,2358,
0x6A21,2345,
0x6A23,2349,
0x6A29,2360,
0x6A2A,2361,
0x6A2A,2362,
0x6A2B,2357,
0x6A35,2370,
0x6A38,2372,
0x6A39,2377,
0x6A3A,2337,
0x6A3D,2375,
0x6A44,2374,
0x6A45,2367,
0x6A47,2373,
0x6A48,2371,
0x6A4A,2364,
0x6A4B,2378,
0x6A58,2368,
0x6A59,2376,
0x6A5F,2379,
0x6A61,2366,
0x6A62,2347,
0x6A64,1760,
0x6A66,2369,
0x6A6B,2361,
0x6A6B,2362,
0x6A7F,2383,
0x6A80,2386,
0x6A84,2385,
0x6A8E,2382,
0x6A9C,2388,
0x6A9E,2384,
0x6AA2,2381,
0x6AA3,2387,
0x6AA5,2380,
0x6AA8,2363,
0x6AB3,2390,
0x6ABB,2392,
0x6AC2,2391,
0x6AC3,2389,
0x6AD3,2397,
0x6ADA,2394,
0x6ADB,2398,
0x6ADD,2396,
0x6ADE,2393,
0x6ADF,2395,
0x6AE7,2400,
0x6AFB,2404,
0x6B04,2401,
0x6B04,2402,
0x6B0A,2403,
0x6B12,2407,
0x6B16,2399,
0x6B16,2408,
0x6B1B,2409,
0x6B1B,2406,
0x6B1D,2410,
0x6B20,2412,
0x6B21,638,
0x6B23,2077,
0x6B27,2413,
0x6B2C,2414,
0x6B2C,921,
0x6B32,4461,
0x6B35,2415,
0x6B37,2416,
0x6B39,2417,
0x6B3A,2419,
0x6B3D,4829,
0x6B3E,2418,
0x6B3E,2420,
0x6B40,2420,
0x6B47,2421,
0x6B4C,2422,
0x6B4E,2424,
0x6B50,2423,
0x6B53,2425,
0x6B54,248,
0x6B5B,2426,
0x6B5F,2427,
0x6B61,2428,
0x6B62,2429,
0x6B63,27,
0x6B64,2430,
0x6B65,2431,
0x6B66,51,
0x6B69,2433,
0x6B6A,54,
0x6B6F,5428,
0x6B73,2434,
0x6B74,819,
0x6B74,835,
0x6B74,837,
0x6B77,837,
0x6B78,123,
0x6B7B,2439,
0x6B7F,2440,
0x6B83,2442,
0x6B86,2441,
0x6B89,2444,
0x6B8A,2443,
0x6B8B,2445,
0x6B8B,2446,
0x6B96,2448,
0x6B98,2446,
0x6B9B,2447,
0x6BAF,2449,
0x6BB2,2450,
0x6BB4,2451,
0x6BB5,2452,
0x6BB7,227,
0x6BBA,2455,
0x6BBA,2454,
0x6BBB,2456,
0x6BBC,2457,
0x6BBD,2458,
0x6BBF,242,
0x6BC0,2460,
0x6BC1,2460,
0x6BC5,2463,
0x6BCD,2466,
0x6BCE,2467,
0x6BD2,2468,
0x6BD4,2470,
0x6BD8,2997,
0x6BDB,2473,
0x6BDF,207,
0x6BEB,318,
0x6BEC,2474,
0x6BEF,2475,
0x6BF3,2476,
0x6C08,2477,
0x6C0F,2478,
0x6C11,25,
0x6C13,292,
0x6C17,2480,
0x6C17,2481,
0x6C23,2481,
0x6C34,2482,
0x6C37,131,
0x6C38,130,
0x6C3E,2483,
0x6C40,2484,
0x6C41,2485,
0x6C42,137,
0x6C4E,2490,
0x6C50,2488,
0x6C57,2493,
0x6C5A,2494,
0x6C5D,2487,
0x6C5E,1456,
0x6C5F,2491,
0x6C60,2489,
0x6C6A,2498,
0x6C70,2496,
0x6C72,2492,
0x6C7A,2509,
0x6C7D,2507,
0x6C81,2497,
0x6C83,2502,
0x6C88,2508,
0x6C8C,2495,
0x6C8D,2499,
0x6C90,2500,
0x6C93,2501,
0x6C96,2505,
0x6C99,2504,
0x6C9B,2518,
0x6CA1,2506,
0x6CA2,2503,
0x6CAB,2515,
0x6CAE,2519,
0x6CB1,2512,
0x6CB3,2530,
0x6CB8,2524,
0x6CB9,2534,
0x6CBB,2528,
0x6CBC,2521,
0x6CBD,2517,
0x6CBE,2511,
0x6CBF,2525,
0x6CC1,2516,
0x6CC4,2513,
0x6CC9,3099,
0x6CCA,2527,
0x6CCC,2522,
0x6CD4,2514,
0x6CD5,2535,
0x6CDB,2486,
0x6CE1,2523,
0x6CE2,2529,
0x6CE3,2532,
0x6CE5,2533,
0x6CE8,2531,
0x6CEA,2510,
0x6CF0,2526,
0x6CF3,2520,
0x6D04,2537,
0x6D0B,2550,
0x6D0C,2536,
0x6D12,2545,
0x6D17,2551,
0x6D1B,2541,
0x6D1E,2546,
0x6D1F,2542,
0x6D25,2543,
0x6D29,2540,
0x6D2A,2544,
0x6D32,2539,
0x6D35,2538,
0x6D3B,2552,
0x6D3E,2547,
0x6D41,2576,
0x6D44,2548,
0x6D44,2580,
0x6D45,2549,
0x6D5A,2566,
0x6D5C,2716,
0x6D5C,2567,
0x6D63,2562,
0x6D66,2571,
0x6D69,2563,
0x6D6A,2570,
0x6D6C,2557,
0x6D6E,2575,
0x6D74,2568,
0x6D77,2553,
0x6D77,2556,
0x6D78,2572,
0x6D85,2564,
0x6D88,2574,
0x6D89,2555,
0x6D8C,2565,
0x6D8E,2560,
0x6D93,2561,
0x6D95,2559,
0x6D99,2569,
0x6D99,2578,
0x6DAF,2584,
0x6DB2,2599,
0x6DB5,2558,
0x6DB5,2577,
0x6DB8,2593,
0x6DBC,2598,
0x6DC0,2585,
0x6DC6,2583,
0x6DCB,2595,
0x6DD1,2592,
0x6DD8,2588,
0x6DD9,2589,
0x6DDA,2578,
0x6DE1,2602,
0x6DE6,2594,
0x6DE8,2580,
0x6DEA,2587,
0x6DEB,2603,
0x6DF1,2606,
0x6DF3,2590,
0x6DF5,2625,
0x6DF7,2604,
0x6DF8,2605,
0x6DFA,2579,
0x6DFB,2601,
0x6DFC,2586,
0x6E05,2605,
0x6E07,2596,
0x6E08,2597,
0x6E09,2591,
0x6E0B,2600,
0x6E13,2581,
0x6E19,2619,
0x6E1A,2617,
0x6E1B,2637,
0x6E1F,2610,
0x6E20,2271,
0x6E21,2635,
0x6E23,2612,
0x6E25,2613,
0x6E26,2629,
0x6E29,2634,
0x6E2B,2614,
0x6E2C,2632,
0x6E2F,2582,
0x6E2F,2630,
0x6E34,2608,
0x6E38,2620,
0x6E3A,2623,
0x6E3E,2624,
0x6E43,2611,
0x6E4A,2615,
0x6E4D,2618,
0x6E51,2616,
0x6E56,2628,
0x6E5B,2622,
0x6E67,2607,
0x6E6E,2621,
0x6E6F,2633,
0x6E72,2609,
0x6E7E,2627,
0x6E7E,2742,
0x6E7F,2631,
0x6E80,2636,
0x6E8C,2690,
0x6E8D,2643,
0x6E90,2656,
0x6E96,791,
0x6E9C,2658,
0x6E9D,2657,
0x6E9F,2640,
0x6EA2,2651,
0x6EAA,2654,
0x6EAB,2638,
0x6EAF,2653,
0x6EB2,2554,
0x6EB2,2646,
0x6EB6,2659,
0x6EB7,2644,
0x6EBA,2652,
0x6EC2,2645,
0x6EC4,2647,
0x6EC5,2660,
0x6ECA,2507,
0x6ECA,2639,
0x6ECB,2626,
0x6ECC,2671,
0x6ED1,2663,
0x6ED3,2642,
0x6ED4,2650,
0x6EDD,2655,
0x6EDE,2661,
0x6EEF,2661,
0x6EEF,2666,
0x6EF2,2677,
0x6EF4,2674,
0x6EF8,2667,
0x6EFE,2672,
0x6EFF,2664,
0x6F01,2684,
0x6F02,2678,
0x6F06,2679,
0x6F09,2675,
0x6F0F,2682,
0x6F11,2689,
0x6F13,2668,
0x6F14,2685,
0x6F15,2681,
0x6F20,2649,
0x6F22,2662,
0x6F22,2665,
0x6F23,2641,
0x6F2B,2683,
0x6F2C,2676,
0x6F31,2669,
0x6F32,2670,
0x6F38,2680,
0x6F3F,2673,
0x6F45,2739,
0x6F51,2690,
0x6F54,2698,
0x6F5B,2713,
0x6F5C,2703,
0x6F5F,2695,
0x6F64,2700,
0x6F6D,2692,
0x6F6E,2702,
0x6F70,2701,
0x6F7A,2693,
0x6F81,2686,
0x6F84,2699,
0x6F86,2694,
0x6F88,2688,
0x6F8E,2697,
0x6F94,2687,
0x6F97,2696,
0x6FA4,2704,
0x6FB1,2709,
0x6FB3,2706,
0x6FB9,2708,
0x6FC0,2712,
0x6FC1,2710,
0x6FC3,2711,
0x6FC6,2691,
0x6FC6,2705,
0x6FD5,2714,
0x6FD8,2717,
0x6FDB,2707,
0x6FDF,2715,
0x6FE0,2720,
0x6FE1,2723,
0x6FE4,2719,
0x6FEB,2724,
0x6FEF,2718,
0x6FF1,2716,
0x6FF3,2703,
0x6FF6,2721,
0x6FFE,2725,
0x7006,2727,
0x7009,2728,
0x7011,2726,
0x7015,2732,
0x7018,2736,
0x701A,2730,
0x701D,2733,
0x701E,2731,
0x701F,2734,
0x7027,2729,
0x702C,2735,
0x7030,2738,
0x703E,2737,
0x704C,2739,
0x7051,2740,
0x7058,2741,
0x7063,2742,
0x706B,2743,
0x706F,2745,
0x7070,820,
0x7070,2744,
0x7078,2747,
0x707C,2746,
0x707D,1448,
0x7089,2750,
0x708A,2752,
0x708E,2751,
0x7092,2749,
0x7099,205,
0x70AC,2748,
0x70AD,1418,
0x70AE,2753,
0x70AF,2755,
0x70B3,2754,
0x70B8,2756,
0x70B9,804,
0x70B9,2809,
0x70BA,138,
0x70C8,2761,
0x70CF,229,
0x70D8,2759,
0x70D9,2760,
0x70DF,2758,
0x70F1,2762,
0x70F9,309,
0x70FD,2763,
0x7109,60,
0x7114,249,
0x7119,2768,
0x711A,2769,
0x711C,2766,
0x7120,2764,
0x7121,2773,
0x7126,5029,
0x7130,2767,
0x7131,2765,
0x7136,2770,
0x713C,2774,
0x713C,2772,
0x7149,2783,
0x714C,2778,
0x714E,611,
0x7151,2775,
0x7155,2789,
0x7156,2780,
0x7159,2784,
0x7160,2779,
0x7164,2781,
0x7165,2777,
0x7167,2785,
0x7168,2776,
0x7169,2782,
0x716E,2771,
0x716E,2775,
0x7174,2790,
0x717D,2792,
0x7184,2788,
0x7185,2790,
0x718A,2791,
0x7194,2786,
0x7196,2787,
0x719F,2795,
0x71A8,2793,
0x71B1,2797,
0x71BE,2801,
0x71C3,2808,
0x71C4,249,
0x71C4,712,
0x71C8,2800,
0x71CB,2803,
0x71CE,2804,
0x71D0,2807,
0x71D2,2798,
0x71D4,2802,
0x71D5,4070,
0x71D7,2806,
0x71DF,1006,
0x71E0,2812,
0x71E5,2810,
0x71E6,2813,
0x71E7,2805,
0x71ED,2811,
0x71F5,2799,
0x71F9,2815,
0x71FB,2817,
0x71FC,2816,
0x71FF,2814,
0x7206,2818,
0x7210,2819,
0x721B,2820,
0x7228,2821,
0x722A,2822,
0x722C,2824,
0x7230,2827,
0x7232,2828,
0x7235,2830,
0x7235,2831,
0x7236,2832,
0x723A,2835,
0x723C,441,
0x723C,2836,
0x723D,234,
0x723E,69,
0x723E,575,
0x723E,1356,
0x7240,2838,
0x7246,1144,
0x7246,2841,
0x7247,2842,
0x7248,2843,
0x724B,2844,
0x724C,2845,
0x7252,2846,
0x7258,2847,
0x7259,2848,
0x725B,2852,
0x725D,2853,
0x725F,849,
0x7261,2855,
0x7262,1287,
0x7267,2856,
0x7269,2857,
0x7272,2858,
0x7274,2859,
0x7279,2860,
0x727D,320,
0x7280,1397,
0x7281,2861,
0x7282,2863,
0x7287,2862,
0x7292,2864,
0x72A0,2865,
0x72A2,2866,
0x72A7,2865,
0x72A7,2867,
0x72AC,2868,
0x72AF,2869,
0x72B6,2839,
0x72C2,2872,
0x72C4,2870,
0x72C6,2871,
0x72CE,2873,
0x72D0,2878,
0x72D2,2874,
0x72D7,2875,
0x72D9,2877,
0x72DB,2876,
0x72E1,2881,
0x72E2,2879,
0x72E9,2883,
0x72EC,2884,
0x72ED,2882,
0x72F7,2886,
0x72F8,2887,
0x72F9,2882,
0x72FC,2888,
0x72FD,2885,
0x730A,2890,
0x7316,2891,
0x731B,2895,
0x731C,2892,
0x731F,2894,
0x7325,2898,
0x7329,2899,
0x732A,2889,
0x732B,2893,
0x732E,2901,
0x7334,2896,
0x7336,2897,
0x733E,2903,
0x733F,2905,
0x7344,2906,
0x7345,2904,
0x734F,2902,
0x7357,2908,
0x7360,2907,
0x7363,2914,
0x7363,2909,
0x7368,2910,
0x736A,2911,
0x7370,2913,
0x7372,2912,
0x7375,2915,
0x7378,2914,
0x737A,2917,
0x737B,2916,
0x7384,2918,
0x7386,2919,
0x7387,319,
0x7389,2923,
0x738B,2922,
0x73A9,2925,
0x73B2,2928,
0x73B3,2929,
0x73BB,2931,
0x73C0,2926,
0x73C2,2927,
0x73C8,2930,
0x73CA,2932,
0x73CD,2933,
0x73DE,2934,
0x73E0,2936,
0x73EA,2937,
0x73ED,2935,
0x73FE,2943,
0x7403,2941,
0x7405,2938,
0x7406,2942,
0x7409,2939,
0x7422,2946,
0x7425,2947,
0x7432,2944,
0x7434,2949,
0x7435,2472,
0x7436,2945,
0x743A,2948,
0x7441,2955,
0x7447,2929,
0x7447,2951,
0x7455,2958,
0x7459,2952,
0x745A,2956,
0x745C,2957,
0x745E,2959,
0x745F,2953,
0x7460,2965,
0x7463,2966,
0x746A,2963,
0x746F,2954,
0x7470,2964,
0x7471,2962,
0x7473,2961,
0x747E,2968,
0x7483,2967,
0x74A7,2969,
0x74B0,2970,
0x74BD,71,
0x74CF,2971,
0x74D4,2972,
0x74DC,2973,
0x74E0,2974,
0x74E2,2975,
0x74E3,845,
0x74E3,2976,
0x74E3,4649,
0x74E6,2977,
0x74E7,2978,
0x74E9,2979,
0x74F0,2980,
0x74F1,2981,
0x74F6,2984,
0x74F7,2982,
0x74F8,2983,
0x7501,2984,
0x7503,2986,
0x7505,2985,
0x750D,4046,
0x750E,2987,
0x7515,335,
0x7518,2988,
0x751A,111,
0x751B,2990,
0x751C,3859,
0x751E,1368,
0x751F,2991,
0x7522,3354,
0x7522,2072,
0x7522,314,
0x7523,3354,
0x7523,314,
0x7525,2992,
0x7526,66,
0x7526,68,
0x7528,2993,
0x752B,135,
0x7530,2994,
0x7531,89,
0x7532,92,
0x7533,93,
0x7537,2996,
0x753A,2995,
0x753B,50,
0x753B,3721,
0x753B,3722,
0x754C,2998,
0x754F,2999,
0x7551,2757,
0x7554,3002,
0x7559,3003,
0x755A,852,
0x755C,2920,
0x755D,311,
0x7560,3102,
0x7562,3005,
0x7565,3007,
0x7566,3004,
0x756A,4811,
0x756B,50,
0x756B,3721,
0x7570,3008,
0x7573,3010,
0x7575,50,
0x7575,3722,
0x7576,1367,
0x7577,3011,
0x7578,3012,
0x757F,1497,
0x7582,3010,
0x7586,72,
0x7587,3016,
0x758A,3017,
0x758B,3018,
0x758E,3021,
0x758F,3020,
0x7591,755,
0x7594,3023,
0x759A,3024,
0x759D,3025,
0x75A3,3027,
0x75A5,3026,
0x75AB,3028,
0x75B1,3036,
0x75B2,3040,
0x75B3,3032,
0x75B4,3029,
0x75B5,3047,
0x75B8,3030,
0x75B9,3033,
0x75BC,3037,
0x75BD,3031,
0x75BE,3041,
0x75C0,3035,
0x75C2,3038,
0x75C3,3034,
0x75C5,3042,
0x75C7,3039,
0x75CD,3043,
0x75D2,3044,
0x75D4,3046,
0x75D5,3045,
0x75D8,3053,
0x75D9,3052,
0x75DB,3054,
0x75E2,3049,
0x75E3,3050,
0x75E4,3051,
0x75E9,3069,
0x75F0,3060,
0x75F2,3057,
0x75F3,3058,
0x75F4,3061,
0x75FA,3059,
0x75FC,3056,
0x75FE,3029,
0x75FE,3048,
0x7601,3055,
0x760B,3064,
0x760D,3062,
0x761F,3065,
0x7620,3070,
0x7621,3067,
0x7622,3066,
0x7624,3068,
0x7626,3069,
0x7627,3063,
0x762D,3072,
0x7630,3074,
0x7634,3073,
0x763B,3071,
0x7642,3078,
0x7647,3079,
0x7648,3077,
0x764C,3076,
0x7652,3081,
0x7655,3080,
0x7656,3082,
0x7658,3075,
0x7661,3083,
0x7662,3084,
0x7667,3085,
0x7669,3087,
0x766A,3086,
0x766C,3088,
0x7670,3089,
0x7672,3090,
0x7678,3091,
0x767A,3092,
0x767B,3094,
0x767C,3093,
0x767D,3095,
0x767E,33,
0x7684,3097,
0x7686,2471,
0x7687,3100,
0x7688,3098,
0x768B,3101,
0x768E,3103,
0x7690,3101,
0x7690,3104,
0x7693,3105,
0x769A,3107,
0x76AE,3109,
0x76B8,3111,
0x76BA,3112,
0x76BF,3113,
0x76C2,48,
0x76C3,52,
0x76C6,594,
0x76C8,3114,
0x76CA,597,
0x76D2,496,
0x76D7,3115,
0x76DB,3116,
0x76DB,3118,
0x76DC,3117,
0x76DE,1808,
0x76DF,3119,
0x76E1,3120,
0x76E3,3121,
0x76E4,3122,
0x76E5,3123,
0x76E7,4114,
0x76EA,3124,
0x76EE,3127,
0x76F2,297,
0x76F4,775,
0x76F8,2241,
0x76FE,215,
0x7701,218,
0x7704,3129,
0x7707,3130,
0x7709,219,
0x770B,222,
0x770C,1362,
0x771B,3131,
0x771E,753,
0x771F,783,
0x7720,3132,
0x7725,3135,
0x7729,3133,
0x7734,3136,
0x7736,3134,
0x7737,3139,
0x7738,3137,
0x773A,3138,
0x773C,3140,
0x7740,3665,
0x7747,3141,
0x775B,3142,
0x7761,3149,
0x7762,3143,
0x7763,3147,
0x7765,3144,
0x7766,3146,
0x7768,3148,
0x776B,3145,
0x777E,4211,
0x777F,805,
0x778B,3150,
0x7791,3151,
0x779E,3153,
0x779F,3152,
0x77A0,3154,
0x77A5,3155,
0x77AC,3159,
0x77AD,3156,
0x77B0,3158,
0x77B3,3157,
0x77BC,3160,
0x77BD,5416,
0x77C7,3161,
0x77CD,867,
0x77D5,3162,
0x77D7,796,
0x77DA,3163,
0x77DB,3164,
0x77DC,3165,
0x77E2,3168,
0x77E5,3169,
0x77E7,3170,
0x77E9,3171,
0x77ED,3172,
0x77EE,3174,
0x77EF,3175,
0x77F3,28,
0x77F3,3176,
0x7802,3181,
0x780C,3177,
0x7812,3178,
0x7814,3180,
0x7814,3187,
0x7815,3179,
0x7815,3194,
0x7825,3184,
0x7826,3189,
0x7827,3183,
0x7832,3185,
0x7834,3186,
0x783F,3182,
0x7845,3188,
0x784F,3187,
0x785D,3192,
0x786B,3191,
0x786C,3193,
0x786F,3190,
0x787C,3200,
0x7881,3202,
0x7887,3201,
0x788C,3199,
0x788D,3198,
0x788E,3194,
0x7891,3195,
0x7891,3206,
0x7893,3218,
0x7895,3197,
0x7897,3196,
0x78A3,3205,
0x78A7,3208,
0x78A9,3207,
0x78AA,3203,
0x78AC,3204,
0x78BA,3217,
0x78BE,3216,
0x78C1,3210,
0x78C1,3209,
0x78CA,3213,
0x78CB,3211,
0x78D0,3214,
0x78D1,3212,
0x78D4,3215,
0x78DA,3219,
0x78E8,5393,
0x78EF,3221,
0x7901,3220,
0x790E,3222,
0x7919,3223,
0x7926,3225,
0x792A,3224,
0x792B,3227,
0x792C,3226,
0x793A,3228,
0x793C,3229,
0x793C,3259,
0x793E,3231,
0x7940,3230,
0x7947,3233,
0x7948,3234,
0x7949,3232,
0x7950,3240,
0x7953,3242,
0x7955,3236,
0x7956,3243,
0x7957,3238,
0x795A,3237,
0x795D,3244,
0x795E,3245,
0x795F,3239,
0x7960,3241,
0x7962,3235,
0x7965,3246,
0x7968,4276,
0x796D,3247,
0x7977,3260,
0x7980,3249,
0x7980,325,
0x7981,3251,
0x7984,3250,
0x7985,3255,
0x798A,3253,
0x798D,3254,
0x798E,3252,
0x798F,3256,
0x79A6,3258,
0x79AA,3257,
0x79AE,3259,
0x79B0,3261,
0x79B1,3260,
0x79BD,528,
0x79BF,3262,
0x79C0,3263,
0x79C1,3265,
0x79CB,3273,
0x79D1,3272,
0x79D2,3271,
0x79D4,3270,
0x79D5,3269,
0x79D5,3466,
0x79D8,3281,
0x79DF,3279,
0x79E3,3277,
0x79E4,3275,
0x79E6,3274,
0x79E7,3278,
0x79E9,3276,
0x79F0,3280,
0x79FB,3282,
0x7A00,3286,
0x7A08,3283,
0x7A0B,3285,
0x7A0D,3284,
0x7A0E,3287,
0x7A14,3288,
0x7A17,3290,
0x7A1A,3292,
0x7A1C,3291,
0x7A1F,325,
0x7A1F,3249,
0x7A20,3289,
0x7A2E,3295,
0x7A31,3293,
0x7A32,3294,
0x7A37,3298,
0x7A3A,3297,
0x7A3B,3296,
0x7A3C,3301,
0x7A3D,3304,
0x7A3E,5251,
0x7A3F,3299,
0x7A3F,5251,
0x7A40,2461,
0x7A40,2462,
0x7A42,3300,
0x7A47,3302,
0x7A49,3303,
0x7A4D,3306,
0x7A4E,5127,
0x7A4F,3305,
0x7A57,3307,
0x7A61,3310,
0x7A62,3311,
0x7A63,3308,
0x7A69,3312,
0x7A6B,3309,
0x7A74,3313,
0x7A76,3314,
0x7A79,3315,
0x7A7A,3317,
0x7A7D,3319,
0x7A7F,3323,
0x7A81,3316,
0x7A81,3318,
0x7A83,3320,
0x7A84,3322,
0x7A88,3321,
0x7A92,3325,
0x7A93,3326,
0x7A95,3324,
0x7A96,3329,
0x7A97,3327,
0x7A98,3328,
0x7A9F,3331,
0x7AA0,3330,
0x7AA9,3333,
0x7AAA,3334,
0x7AAC,3332,
0x7AAE,3337,
0x7AAF,3336,
0x7AB6,3338,
0x7ABA,3339,
0x7ABF,3335,
0x7AC3,3341,
0x7AC4,3340,
0x7AC8,3341,
0x7ACA,3342,
0x7ACB,3343,
0x7ACD,3344,
0x7ACF,3345,
0x7AD3,3349,
0x7AD5,3348,
0x7AD9,3352,
0x7ADC,3351,
0x7ADC,5440,
0x7ADD,3350,
0x7ADF,5111,
0x7AE0,5112,
0x7AE1,3353,
0x7AE3,3356,
0x7AE5,3357,
0x7AE6,3355,
0x7AEA,3359,
0x7AED,3361,
0x7AEF,3363,
0x7AF0,3360,
0x7AF6,3364,
0x7AF8,3365,
0x7AF9,3366,
0x7AFA,3367,
0x7AFF,3369,
0x7B04,3373,
0x7B04,3403,
0x7B08,3368,
0x7B0A,3371,
0x7B0B,3370,
0x7B0B,3390,
0x7B0F,3372,
0x7B11,3374,
0x7B19,3377,
0x7B1B,3382,
0x7B1E,3380,
0x7B20,3381,
0x7B25,3378,
0x7B26,3383,
0x7B27,3379,
0x7B28,3375,
0x7B2C,127,
0x7B2C,3385,
0x7B34,3376,
0x7B39,3384,
0x7B46,3397,
0x7B48,3387,
0x7B49,3396,
0x7B4B,3395,
0x7B4C,3388,
0x7B4D,3390,
0x7B4F,3391,
0x7B50,3386,
0x7B51,3389,
0x7B52,3392,
0x7B54,3394,
0x7B56,3393,
0x7B67,3399,
0x7B69,3398,
0x7B6E,3401,
0x7B75,3400,
0x7B86,3426,
0x7B86,3410,
0x7B87,3414,
0x7B8B,3404,
0x7B8D,3409,
0x7B8F,3412,
0x7B92,3408,
0x7B94,3411,
0x7B95,3407,
0x7B97,3415,
0x7B99,3406,
0x7B9A,3405,
0x7B9D,3413,
0x7BA1,3416,
0x7BAA,3443,
0x7BAD,3419,
0x7BB1,3425,
0x7BB4,3421,
0x7BB8,3422,
0x7BC0,3402,
0x7BC0,3417,
0x7BC1,3420,
0x7BC4,3424,
0x7BC6,3423,
0x7BC7,3418,
0x7BC9,3435,
0x7BDD,3432,
0x7BE0,3428,
0x7BE0,3440,
0x7BE1,3430,
0x7BE4,3434,
0x7BE5,3429,
0x7BE6,3426,
0x7BE9,3433,
0x7BF3,3431,
0x7C00,3439,
0x7C07,3441,
0x7C11,3427,
0x7C12,3436,
0x7C13,3438,
0x7C17,3437,
0x7C21,3444,
0x7C27,3442,
0x7C2A,3451,
0x7C37,3445,
0x7C38,3447,
0x7C3D,3446,
0x7C3E,3449,
0x7C3F,3448,
0x7C43,3452,
0x7C4C,3453,
0x7C4D,3450,
0x7C50,3456,
0x7C54,3455,
0x7C5F,3457,
0x7C60,3458,
0x7C64,3459,
0x7C6C,3460,
0x7C73,3461,
0x7C75,3462,
0x7C7E,3464,
0x7C81,3463,
0x7C83,3466,
0x7C89,3469,
0x7C8B,3467,
0x7C8D,3465,
0x7C92,3471,
0x7C95,3470,
0x7C97,3473,
0x7C98,3472,
0x7C9B,115,
0x7C9F,4277,
0x7CA4,237,
0x7CA5,1574,
0x7CA7,3475,
0x7CA8,3476,
0x7CAE,3474,
0x7CAE,3490,
0x7CB2,3477,
0x7CB3,3478,
0x7CB3,3270,
0x7CB9,3479,
0x7CBE,3480,
0x7CC5,3482,
0x7CCA,3483,
0x7CCE,3481,
0x7CD2,3484,
0x7CD3,2464,
0x7CD6,3485,
0x7CDC,5395,
0x7CDD,3486,
0x7CDE,3489,
0x7CDF,3487,
0x7CE0,3488,
0x7CE7,3490,
0x7CEF,3491,
0x7CF6,3682,
0x7CF8,3492,
0x7CFA,3493,
0x7CFB,195,
0x7CFE,3494,
0x7CFE,3498,
0x7D00,3497,
0x7D04,3499,
0x7D05,3500,
0x7D06,3495,
0x7D0A,2071,
0x7D0B,3507,
0x7D0D,3508,
0x7D10,3504,
0x7D14,3509,
0x7D17,3503,
0x7D18,3502,
0x7D19,3510,
0x7D1A,3496,
0x7D1A,3501,
0x7D1B,3506,
0x7D20,3511,
0x7D21,3505,
0x7D22,782,
0x7D2B,3534,
0x7D2C,3513,
0x7D2E,3514,
0x7D2F,3006,
0x7D30,3522,
0x7D32,3512,
0x7D33,3518,
0x7D39,3516,
0x7D3A,3517,
0x7D42,3521,
0x7D43,3519,
0x7D44,3520,
0x7D46,3515,
0x7D4C,3523,
0x7D4E,3531,
0x7D4F,3525,
0x7D50,3540,
0x7D53,3529,
0x7D56,3526,
0x7D5E,3535,
0x7D61,3533,
0x7D62,3530,
0x7D63,3527,
0x7D66,3538,
0x7D68,3532,
0x7D6E,3528,
0x7D71,3536,
0x7D72,3524,
0x7D75,3537,
0x7D76,3539,
0x7D79,3543,
0x7D7D,3542,
0x7D93,3541,
0x7D99,3545,
0x7D9A,3544,
0x7D9C,3555,
0x7DAC,3547,
0x7DAD,3552,
0x7DAE,3548,
0x7DAF,3550,
0x7DB0,3549,
0x7DB1,3561,
0x7DB2,3563,
0x7DB4,3562,
0x7DB8,3556,
0x7DBA,3558,
0x7DBB,3551,
0x7DBD,3554,
0x7DBE,3559,
0x7DBF,3566,
0x7DCA,3560,
0x7DCB,3553,
0x7DCD,3546,
0x7DCF,3567,
0x7DD1,3564,
0x7DD2,3557,
0x7DD2,3570,
0x7DD6,3570,
0x7DD8,3577,
0x7DDA,3580,
0x7DDC,3106,
0x7DDE,3578,
0x7DE0,3581,
0x7DE1,3573,
0x7DE8,3583,
0x7DE9,3584,
0x7DEC,3574,
0x7DEF,3579,
0x7DF4,3565,
0x7DF4,3569,
0x7DFB,3575,
0x7DFB,3587,
0x7DFC,3571,
0x7DFC,3591,
0x7E01,3585,
0x7E04,3568,
0x7E05,3572,
0x7E09,3590,
0x7E0A,3594,
0x7E0B,3576,
0x7E12,3588,
0x7E15,3571,
0x7E15,3591,
0x7E1B,3593,
0x7E1E,3595,
0x7E1F,3589,
0x7E22,3816,
0x7E26,3597,
0x7E2B,3582,
0x7E2B,3586,
0x7E2E,3608,
0x7E31,3600,
0x7E32,3603,
0x7E37,3605,
0x7E39,3606,
0x7E3A,3592,
0x7E3B,5394,
0x7E3D,3599,
0x7E3E,3602,
0x7E41,3598,
0x7E41,3596,
0x7E43,3604,
0x7E46,3601,
0x7E4A,3607,
0x7E4B,3618,
0x7E4D,3616,
0x7E54,3613,
0x7E55,3612,
0x7E59,3611,
0x7E5A,3610,
0x7E5E,3609,
0x7E69,3617,
0x7E6A,3614,
0x7E6D,4087,
0x7E70,3619,
0x7E79,3615,
0x7E7B,3621,
0x7E7C,3620,
0x7E82,3454,
0x7E8C,3622,
0x7E8E,3607,
0x7E8E,3623,
0x7E8F,3624,
0x7E92,3627,
0x7E94,3628,
0x7E96,3607,
0x7E96,3626,
0x7E9C,3625,
0x7E9C,3629,
0x7F3A,3630,
0x7F45,3631,
0x7F4C,3632,
0x7F4E,3633,
0x7F50,3634,
0x7F54,620,
0x7F60,3635,
0x7F68,3639,
0x7F69,3638,
0x7F6A,3643,
0x7F6B,3641,
0x7F6E,3644,
0x7F70,3646,
0x7F72,3642,
0x7F72,3645,
0x7F75,3648,
0x7F77,3649,
0x7F78,3647,
0x7F79,3650,
0x7F82,3652,
0x7F83,3651,
0x7F85,3654,
0x7F86,3653,
0x7F87,3655,
0x7F88,3655,
0x7F88,4283,
0x7F8A,3656,
0x7F8E,3658,
0x7F94,3659,
0x7F9A,3663,
0x7F9E,3661,
0x7FA4,3667,
0x7FA8,3666,
0x7FA9,3668,
0x7FAE,3669,
0x7FAF,3670,
0x7FB8,338,
0x7FB9,3672,
0x7FBD,3673,
0x7FC1,596,
0x7FC5,2040,
0x7FCC,3674,
0x7FD2,3675,
0x7FD4,3664,
0x7FD5,514,
0x7FE0,3676,
0x7FE1,5083,
0x7FE5,3677,
0x7FE6,613,
0x7FE9,245,
0x7FEB,3678,
0x7FF0,794,
0x7FF3,3679,
0x7FF9,1153,
0x7FFB,3681,
0x7FFC,3680,
0x8000,1375,
0x8001,3683,
0x8003,3684,
0x8004,3686,
0x8005,3685,
0x8005,3688,
0x8006,3687,
0x800C,3689,
0x8010,3690,
0x8012,3691,
0x8015,3695,
0x8017,3694,
0x8018,3693,
0x8019,3692,
0x8026,3696,
0x8033,3697,
0x8036,3698,
0x803A,3700,
0x803D,3703,
0x803E,3701,
0x803F,3702,
0x804A,3705,
0x8052,3706,
0x8056,2960,
0x8058,3707,
0x805A,3711,
0x805E,4959,
0x805F,3709,
0x8061,3708,
0x8062,3710,
0x8068,3713,
0x806F,3713,
0x8071,3714,
0x8072,3712,
0x8073,3715,
0x8074,3716,
0x8076,3717,
0x8077,3718,
0x807D,3716,
0x807E,5442,
0x8085,118,
0x8086,4939,
0x8087,3723,
0x8089,3724,
0x808B,3725,
0x808C,3726,
0x8096,1360,
0x8098,3730,
0x809A,3729,
0x809B,3728,
0x809D,3731,
0x80A1,3739,
0x80A2,3736,
0x80A5,3740,
0x80A9,1820,
0x80AA,3734,
0x80AB,3732,
0x80AD,3733,
0x80AF,2432,
0x80B1,3738,
0x80B2,296,
0x80B4,3735,
0x80BA,3752,
0x80C3,3000,
0x80C6,3751,
0x80CC,3754,
0x80CE,3750,
0x80D9,3746,
0x80DA,3748,
0x80DB,3745,
0x80DD,3744,
0x80DE,3749,
0x80E1,3753,
0x80E4,217,
0x80EF,3759,
0x80F1,3755,
0x80F4,3767,
0x80F8,3768,
0x80FC,3758,
0x80FD,853,
0x8102,3766,
0x8105,727,
0x8106,3760,
0x8107,3756,
0x8107,3765,
0x8108,3764,
0x8109,3764,
0x8109,3743,
0x810A,3763,
0x811A,3773,
0x811B,3771,
0x8123,4656,
0x8129,497,
0x8130,3770,
0x8131,3775,
0x8133,3774,
0x8139,3782,
0x813E,3780,
0x814A,3777,
0x814B,3783,
0x814E,3784,
0x8150,1532,
0x8151,3781,
0x8153,3779,
0x8154,3776,
0x8155,3786,
0x815F,3791,
0x8165,3794,
0x8166,3789,
0x816B,3797,
0x816D,3790,
0x816D,5437,
0x816E,3793,
0x8170,3799,
0x8171,3792,
0x8178,3810,
0x8178,3798,
0x8179,3800,
0x817A,3796,
0x817F,3795,
0x8180,3808,
0x8182,3807,
0x8183,3806,
0x8184,3804,
0x8188,3805,
0x818A,3801,
0x818C,3802,
0x818F,5250,
0x8193,3810,
0x8195,3811,
0x819A,4113,
0x819C,3803,
0x819D,3814,
0x81A0,3813,
0x81A3,3791,
0x81A3,3809,
0x81A8,3818,
0x81B0,3815,
0x81B3,3817,
0x81B5,3812,
0x81BA,1542,
0x81BD,3751,
0x81BD,3819,
0x81BE,3821,
0x81BF,3826,
0x81C0,3822,
0x81C2,3820,
0x81C6,3825,
0x81CD,3829,
0x81D1,3827,
0x81D3,3828,
0x81D8,3830,
0x81D9,3832,
0x81DF,3828,
0x81DF,3835,
0x81E0,3836,
0x81E3,3837,
0x81E4,3838,
0x81E5,3839,
0x81E8,3840,
0x81EA,3841,
0x81ED,3843,
0x81ED,3842,
0x81F3,3845,
0x81F4,3847,
0x81FA,1127,
0x81FC,3849,
0x81FE,106,
0x8201,3851,
0x8202,3852,
0x8205,3853,
0x8207,6,
0x8207,610,
0x8208,615,
0x820A,4076,
0x820C,3855,
0x820E,423,
0x8210,3858,
0x8213,3861,
0x8217,552,
0x8218,555,
0x821E,3862,
0x821F,3863,
0x8221,3864,
0x822A,3867,
0x822B,3866,
0x822C,3865,
0x8233,3869,
0x8235,3871,
0x8236,3870,
0x8237,3872,
0x8238,3868,
0x8239,3873,
0x8240,3874,
0x8247,3875,
0x8258,3876,
0x8259,3877,
0x825F,3878,
0x8264,3880,
0x8266,3881,
0x8268,3879,
0x826A,3882,
0x826B,3883,
0x826E,3884,
0x826F,134,
0x826F,36,
0x826F,190,
0x826F,3885,
0x8271,3888,
0x8272,3889,
0x8276,3890,
0x8277,3891,
0x827E,3892,
0x828B,3896,
0x828D,3895,
0x8292,3894,
0x829D,3893,
0x829F,3902,
0x82A5,3906,
0x82A6,3904,
0x82AC,3901,
0x82AD,3903,
0x82AF,3905,
0x82B1,3909,
0x82B3,3907,
0x82B8,3908,
0x82B9,3899,
0x82BB,226,
0x82BD,3897,
0x82BD,3920,
0x82C5,3898,
0x82D1,3916,
0x82D2,3910,
0x82D4,3921,
0x82D7,3923,
0x82DB,3925,
0x82DE,3917,
0x82DF,3918,
0x82E3,3900,
0x82E5,3926,
0x82E6,3928,
0x82E7,3919,
0x82EB,3922,
0x82F1,3927,
0x82F4,3913,
0x82FA,3911,
0x8302,3915,
0x8304,3914,
0x8305,3924,
0x830E,3912,
0x8317,3929,
0x8318,3934,
0x831C,3932,
0x8323,3949,
0x8328,3930,
0x832B,3936,
0x8332,2919,
0x8335,3931,
0x8336,3940,
0x8338,3935,
0x8339,3937,
0x8346,591,
0x8349,3939,
0x834A,591,
0x834A,689,
0x834F,3933,
0x8352,3941,
0x8358,3938,
0x8377,3956,
0x837B,3952,
0x837C,3951,
0x838A,3943,
0x8393,3945,
0x8396,3942,
0x839A,3400,
0x839A,3948,
0x839E,3950,
0x839F,3947,
0x83A2,3953,
0x83A8,3946,
0x83A9,3944,
0x83AB,3954,
0x83BD,3971,
0x83C1,3959,
0x83C5,3975,
0x83C6,3961,
0x83CA,3981,
0x83CC,3976,
0x83CE,3974,
0x83D3,3980,
0x83D4,3958,
0x83D6,3969,
0x83DC,3982,
0x83DF,3964,
0x83E0,3968,
0x83E9,3978,
0x83EB,3972,
0x83EF,3955,
0x83F0,3966,
0x83F1,3977,
0x83F2,3970,
0x83F4,3957,
0x8401,3967,
0x8403,3965,
0x8404,3962,
0x840A,3960,
0x840C,3979,
0x840D,3963,
0x840E,3973,
0x8420,3979,
0x8429,3992,
0x842C,3984,
0x8431,3989,
0x843C,3987,
0x843D,4003,
0x8449,4001,
0x8457,3985,
0x8457,3983,
0x845B,3997,
0x8461,3999,
0x8463,3986,
0x8466,3998,
0x846C,4000,
0x846D,3994,
0x8471,3993,
0x8475,3990,
0x847A,3995,
0x8490,4022,
0x8494,4018,
0x8499,4020,
0x849C,4010,
0x849F,4016,
0x84A1,4011,
0x84B2,4021,
0x84B4,4006,
0x84B8,4002,
0x84BB,4007,
0x84BC,4025,
0x84BF,4013,
0x84C4,4024,
0x84C6,4014,
0x84CB,4019,
0x84CF,4005,
0x84D0,4015,
0x84D1,4009,
0x84D9,4008,
0x84DA,4012,
0x84EC,4023,
0x84EE,4004,
0x84EE,4731,
0x8511,4038,
0x8513,4039,
0x8514,4031,
0x8517,4034,
0x8518,4032,
0x851F,4033,
0x8523,4036,
0x8526,4037,
0x852C,4049,
0x852D,4017,
0x8532,4030,
0x8535,4042,
0x853D,4050,
0x8541,4029,
0x8541,4052,
0x8543,4056,
0x8548,4047,
0x8549,4048,
0x854A,4045,
0x854E,4054,
0x855A,4043,
0x8568,4051,
0x8569,4055,
0x856A,4053,
0x856D,4068,
0x8573,4044,
0x8577,4062,
0x857E,4063,
0x8584,4075,
0x8587,4057,
0x8588,4058,
0x858A,4061,
0x8591,4060,
0x8594,4071,
0x8599,4072,
0x85A4,4059,
0x85A6,4067,
0x85A8,4064,
0x85A9,4066,
0x85AA,4069,
0x85AB,4073,
0x85AC,4074,
0x85AF,4080,
0x85B0,4077,
0x85B9,4079,
0x85C1,4083,
0x85C9,4081,
0x85CD,4082,
0x85CF,4078,
0x85D5,4086,
0x85DD,4084,
0x85E4,4090,
0x85E5,4085,
0x85E9,4089,
0x85EA,4088,
0x85F7,4093,
0x85F9,4094,
0x85FA,4096,
0x85FB,4098,
0x8606,4092,
0x8607,4097,
0x860A,4095,
0x8616,4099,
0x861A,4101,
0x861E,4100,
0x862D,4091,
0x862D,4103,
0x863F,4104,
0x864E,4105,
0x8650,4106,
0x8654,4107,
0x8655,4108,
0x865A,4109,
0x865C,4111,
0x865E,4110,
0x8667,252,
0x866B,4115,
0x8671,4116,
0x8679,4118,
0x867B,4117,
0x867B,300,
0x8689,2069,
0x868A,4123,
0x868B,4138,
0x868B,4121,
0x8693,4120,
0x8695,57,
0x869C,4127,
0x86A4,4122,
0x86AA,4119,
0x86AF,4129,
0x86B0,4126,
0x86C4,4125,
0x86C6,4128,
0x86C7,4130,
0x86C9,4124,
0x86CB,3019,
0x86D4,4134,
0x86D9,4137,
0x86DB,4131,
0x86DE,4133,
0x86DF,4135,
0x86E4,4136,
0x86ED,4132,
0x86EE,322,
0x86F8,4149,
0x86F9,4148,
0x86FE,4147,
0x8700,3640,
0x8702,4150,
0x8703,4657,
0x8706,4144,
0x8709,4146,
0x870A,4141,
0x870B,4143,
0x870D,4142,
0x8712,4139,
0x8713,4140,
0x8715,4145,
0x8718,4158,
0x871A,5084,
0x871C,1336,
0x8725,4155,
0x8729,4151,
0x8731,4153,
0x8734,4152,
0x8737,4156,
0x8739,4138,
0x873B,4157,
0x873F,4154,
0x8749,4190,
0x874C,4166,
0x874E,4164,
0x8753,4161,
0x8755,5165,
0x8757,4169,
0x8759,4168,
0x875F,4167,
0x8760,4163,
0x8763,4162,
0x8766,4172,
0x8768,4159,
0x876E,4165,
0x8771,330,
0x8776,4171,
0x8778,4170,
0x8782,4160,
0x878D,5274,
0x8795,4174,
0x879F,4175,
0x87A2,4176,
0x87AB,4180,
0x87AF,4178,
0x87B3,4177,
0x87BA,4184,
0x87BD,1165,
0x87C0,4181,
0x87C4,4183,
0x87C6,4173,
0x87C7,4065,
0x87CB,4182,
0x87D2,4179,
0x87D6,4187,
0x87E0,4189,
0x87EF,4188,
0x87F2,4185,
0x87F7,4193,
0x87FB,4196,
0x87FE,4192,
0x8805,4194,
0x880D,4191,
0x880E,4186,
0x880F,4195,
0x8815,4197,
0x881F,4200,
0x8822,4199,
0x8823,4198,
0x8827,1158,
0x8831,4201,
0x8835,4203,
0x8836,2096,
0x8839,4202,
0x883A,74,
0x883B,4204,
0x8840,4205,
0x8842,4208,
0x8842,4207,
0x8844,4208,
0x8844,4212,
0x8846,4210,
0x8849,4209,
0x884C,4213,
0x884D,1607,
0x8852,1620,
0x8853,1621,
0x8853,1629,
0x8857,1626,
0x8859,1630,
0x885B,1596,
0x885D,1638,
0x885E,1640,
0x8861,1641,
0x8862,1644,
0x8863,4214,
0x8868,108,
0x886E,308,
0x8870,312,
0x8877,307,
0x8877,110,
0x887D,4218,
0x887E,465,
0x887F,4217,
0x8881,1082,
0x8882,4216,
0x8888,4222,
0x888B,4223,
0x888D,4219,
0x8892,4220,
0x8896,4224,
0x889E,317,
0x88A2,4221,
0x88A4,315,
0x88AB,4225,
0x88B1,4227,
0x88B4,4229,
0x88B5,4226,
0x88B7,4230,
0x88BF,4232,
0x88C1,788,
0x88C2,4233,
0x88C3,4228,
0x88C4,4231,
0x88C5,4234,
0x88CF,327,
0x88CF,4235,
0x88D4,4239,
0x88D5,4241,
0x88D8,4238,
0x88D9,4240,
0x88DC,4242,
0x88DD,4236,
0x88DF,4237,
0x88E1,4235,
0x88E8,4244,
0x88F2,4245,
0x88F3,1370,
0x88F8,4248,
0x88F9,328,
0x88FD,4249,
0x88FE,4247,
0x8904,4246,
0x8907,4255,
0x890A,4252,
0x890C,4251,
0x8910,4243,
0x8910,4254,
0x8912,331,
0x8913,4250,
0x891E,4256,
0x8925,4257,
0x892A,4253,
0x892B,4258,
0x8936,4262,
0x8938,4259,
0x893B,334,
0x8940,4260,
0x8941,4261,
0x8941,4263,
0x8943,333,
0x8956,4264,
0x895E,4265,
0x895F,4267,
0x8960,4266,
0x8964,4269,
0x8966,4268,
0x896F,4270,
0x8972,5443,
0x8974,4271,
0x8977,4272,
0x897F,4273,
0x8981,4274,
0x8986,4279,
0x8987,4281,
0x8988,4280,
0x8989,4282,
0x898A,4283,
0x898B,4284,
0x898F,4285,
0x8996,3248,
0x8997,4287,
0x8998,4286,
0x899A,4288,
0x89A1,4289,
0x89A6,4291,
0x89A7,4292,
0x89A9,4290,
0x89AA,4293,
0x89AC,4295,
0x89AF,4294,
0x89B3,4296,
0x89BA,4297,
0x89BD,4298,
0x89BF,4299,
0x89C0,4300,
0x89D2,4301,
0x89DA,4303,
0x89DC,4304,
0x89E3,4306,
0x89E6,4305,
0x89F4,4307,
0x89F8,4308,
0x8A00,4309,
0x8A02,4310,
0x8A03,4311,
0x8A08,4312,
0x8A0A,4314,
0x8A0C,4313,
0x8A0E,4316,
0x8A13,4317,
0x8A17,4315,
0x8A18,4318,
0x8A1B,4323,
0x8A1D,4319,
0x8A1D,4331,
0x8A1F,4320,
0x8A23,4322,
0x8A25,4321,
0x8A2A,4326,
0x8A2D,4325,
0x8A31,4324,
0x8A33,4327,
0x8A34,4340,
0x8A36,4328,
0x8A3A,4338,
0x8A3B,4334,
0x8A3C,4341,
0x8A41,4329,
0x8A48,3636,
0x8A50,4337,
0x8A51,4332,
0x8A54,4333,
0x8A55,4339,
0x8A5B,4330,
0x8A5E,4335,
0x8A60,4336,
0x8A60,4343,
0x8A62,4344,
0x8A63,4346,
0x8A66,4361,
0x8A69,4360,
0x8A6B,4345,
0x8A6C,4347,
0x8A6D,4355,
0x8A6E,4356,
0x8A70,4359,
0x8A71,4358,
0x8A72,4349,
0x8A73,4357,
0x8A82,4348,
0x8A84,4350,
0x8A85,4351,
0x8A87,4354,
0x8A89,4353,
0x8A89,4441,
0x8A8C,4366,
0x8A8D,4370,
0x8A91,4367,
0x8A93,4369,
0x8A95,4386,
0x8A98,4371,
0x8A9E,4374,
0x8AA0,4352,
0x8AA0,4362,
0x8AA1,4364,
0x8AA3,4365,
0x8AA4,4372,
0x8AA6,4368,
0x8AA8,4363,
0x8AAC,4373,
0x8AAD,4375,
0x8AB0,4384,
0x8AB2,4389,
0x8AB9,4385,
0x8ABC,4379,
0x8ABF,4392,
0x8AC2,4381,
0x8AC4,4380,
0x8AC7,4388,
0x8AC7,4432,
0x8ACB,4390,
0x8ACD,4378,
0x8ACF,4377,
0x8AD2,4387,
0x8AD6,4391,
0x8ADA,4376,
0x8ADB,4342,
0x8ADB,4399,
0x8ADC,4409,
0x8AE0,4400,
0x8AE1,4398,
0x8AE4,4401,
0x8AE6,4407,
0x8AE7,4413,
0x8AEB,4408,
0x8AED,4411,
0x8AEE,4404,
0x8AF1,4397,
0x8AF3,4406,
0x8AF7,4412,
0x8AF8,4393,
0x8AF8,4395,
0x8AFA,4403,
0x8AFE,4383,
0x8B00,4414,
0x8B01,4394,
0x8B01,4382,
0x8B02,4402,
0x8B04,3824,
0x8B0E,4405,
0x8B10,4419,
0x8B14,4396,
0x8B17,4421,
0x8B19,4422,
0x8B1A,4417,
0x8B1B,4425,
0x8B1D,4423,
0x8B1F,4420,
0x8B20,4415,
0x8B21,4410,
0x8B26,4428,
0x8B28,4418,
0x8B2B,4430,
0x8B2C,4431,
0x8B33,4429,
0x8B39,4424,
0x8B39,4426,
0x8B3E,4427,
0x8B41,4416,
0x8B41,964,
0x8B49,4433,
0x8B4C,4434,
0x8B4E,4435,
0x8B4F,4436,
0x8B58,4438,
0x8B5A,4432,
0x8B5C,4437,
0x8B5C,4440,
0x8B66,4439,
0x8B6B,4444,
0x8B6C,4445,
0x8B6F,4442,
0x8B70,4448,
0x8B72,4446,
0x8B74,4443,
0x8B77,4447,
0x8B7D,4441,
0x8B80,4375,
0x8B80,4450,
0x8B81,4449,
0x8B83,4451,
0x8B8A,1166,
0x8B8A,2063,
0x8B8C,4453,
0x8B8E,5041,
0x8B90,4452,
0x8B92,4456,
0x8B93,4454,
0x8B96,4455,
0x8B9A,4457,
0x8C37,4458,
0x8C3A,4460,
0x8C3A,4462,
0x8C3F,4464,
0x8C41,4463,
0x8C46,4465,
0x8C48,1420,
0x8C4A,4466,
0x8C4C,4467,
0x8C4E,4468,
0x8C50,4470,
0x8C54,1159,
0x8C55,4471,
0x8C5A,3772,
0x8C61,4472,
0x8C68,4473,
0x8C6A,329,
0x8C6B,4474,
0x8C79,4475,
0x8C7A,4476,
0x8C7C,4478,
0x8C82,4479,
0x8C85,4477,
0x8C85,4481,
0x8C89,4480,
0x8C8C,4483,
0x8C8D,4482,
0x8C94,4485,
0x8C98,4484,
0x8C9D,4486,
0x8C9E,803,
0x8CA0,685,
0x8CA0,4488,
0x8CA1,4490,
0x8CA2,1458,
0x8CA7,600,
0x8CA8,4493,
0x8CA9,4491,
0x8CAA,505,
0x8CAB,2469,
0x8CAC,4492,
0x8CAF,4502,
0x8CB0,4500,
0x8CB3,1557,
0x8CB4,4504,
0x8CB6,4489,
0x8CB7,3637,
0x8CB8,4503,
0x8CBB,4497,
0x8CBC,4498,
0x8CBD,4496,
0x8CBF,4499,
0x8CC0,4501,
0x8CC1,4495,
0x8CC2,4506,
0x8CC3,4509,
0x8CC4,4507,
0x8CC7,4510,
0x8CC8,4278,
0x8CCA,4508,
0x8CCE,4505,
0x8CD1,4511,
0x8CD3,1330,
0x8CD3,1339,
0x8CDB,4516,
0x8CDC,4514,
0x8CDE,1372,
0x8CE0,4512,
0x8CE2,4517,
0x8CE3,1140,
0x8CE4,4515,
0x8CE6,4513,
0x8CEA,4518,
0x8CED,4519,
0x8CF4,713,
0x8CFA,4521,
0x8CFB,4520,
0x8CFC,4522,
0x8CFD,1344,
0x8D04,4523,
0x8D05,4524,
0x8D08,4525,
0x8D08,4527,
0x8D0A,4528,
0x8D0B,840,
0x8D0B,4526,
0x8D0F,337,
0x8D13,4529,
0x8D14,4530,
0x8D16,4532,
0x8D17,840,
0x8D17,4531,
0x8D1C,4533,
0x8D64,4534,
0x8D66,4536,
0x8D67,4535,
0x8D6B,4537,
0x8D6D,4538,
0x8D70,4539,
0x8D74,4540,
0x8D77,4541,
0x8D85,4543,
0x8D8A,4542,
0x8DA3,4544,
0x8DA8,4545,
0x8DB3,4546,
0x8DBE,4547,
0x8DCB,4553,
0x8DCC,4549,
0x8DD1,4551,
0x8DDA,4550,
0x8DDB,4552,
0x8DDD,4548,
0x8DDF,4554,
0x8DE1,4560,
0x8DE3,4556,
0x8DE8,4557,
0x8DEA,4559,
0x8DEB,4555,
0x8DEF,4561,
0x8DF3,4562,
0x8DF5,4558,
0x8DF5,4566,
0x8DFC,4564,
0x8E09,4563,
0x8E0A,4565,
0x8E0F,4571,
0x8E10,4566,
0x8E1D,4570,
0x8E1E,4567,
0x8E20,4568,
0x8E2A,4569,
0x8E35,4573,
0x8E42,4572,
0x8E44,4574,
0x8E47,1343,
0x8E48,4575,
0x8E49,4578,
0x8E4A,4576,
0x8E4C,4579,
0x8E50,4577,
0x8E55,4581,
0x8E59,254,
0x8E5F,4582,
0x8E60,4583,
0x8E63,4584,
0x8E64,4580,
0x8E72,4588,
0x8E74,4589,
0x8E76,4587,
0x8E7C,4586,
0x8E81,4592,
0x8E84,4591,
0x8E85,4590,
0x8E85,4600,
0x8E87,4585,
0x8E8A,4593,
0x8E8D,4595,
0x8E91,4594,
0x8E93,4596,
0x8E99,4597,
0x8EA1,4598,
0x8EAA,4599,
0x8EAB,4601,
0x8EAC,4602,
0x8EAF,4606,
0x8EB3,4604,
0x8EBE,4605,
0x8EC8,4607,
0x8ECA,4608,
0x8ECB,4609,
0x8ECC,4610,
0x8ECD,628,
0x8ED2,4611,
0x8EDB,4612,
0x8EDF,4614,
0x8EE2,4615,
0x8EEB,4617,
0x8EF8,4619,
0x8EFB,4616,
0x8EFC,4618,
0x8EFD,4620,
0x8EFD,4624,
0x8F00,4621,
0x8F00,4642,
0x8F03,4623,
0x8F09,789,
0x8F0A,4622,
0x8F13,4625,
0x8F14,4626,
0x8F15,4624,
0x8F1B,4628,
0x8F1D,1371,
0x8F21,4627,
0x8F26,4629,
0x8F29,5086,
0x8F2A,4630,
0x8F2F,4632,
0x8F33,4631,
0x8F38,4634,
0x8F3B,4633,
0x8F3E,4637,
0x8F3F,616,
0x8F42,2465,
0x8F44,4636,
0x8F45,4635,
0x8F46,4639,
0x8F49,4638,
0x8F4D,4640,
0x8F57,4641,
0x8F5C,4621,
0x8F5C,4642,
0x8F5F,4643,
0x8F61,1022,
0x8F62,4644,
0x8F64,4645,
0x8F9B,4646,
0x8F9C,786,
0x8F9E,3860,
0x8F9F,241,
0x8FA3,4647,
0x8FA8,4648,
0x8FAD,4650,
0x8FAE,844,
0x8FAE,4651,
0x8FAF,4652,
0x8FAF,847,
0x8FB0,4653,
0x8FB1,4655,
0x8FB2,4658,
0x8FB7,4659,
0x8FBA,4661,
0x8FBB,4662,
0x8FBC,4660,
0x8FBF,4665,
0x8FC2,4666,
0x8FC4,4663,
0x8FC5,4664,
0x8FCE,4669,
0x8FD1,4671,
0x8FD4,4670,
0x8FDA,4668,
0x8FE0,4674,
0x8FE6,4673,
0x8FEB,4676,
0x8FED,4672,
0x8FF0,4675,
0x8FF4,4677,
0x8FF7,4681,
0x8FF8,4680,
0x8FF9,4679,
0x8FFD,4686,
0x9000,4684,
0x9001,4683,
0x9003,4682,
0x9005,4678,
0x9006,4685,
0x900B,4687,
0x900D,4689,
0x900F,4699,
0x9010,4696,
0x9013,4695,
0x9014,4697,
0x9015,4692,
0x9017,4693,
0x9019,4698,
0x901A,4703,
0x901D,4691,
0x901E,4688,
0x901F,4700,
0x9020,4701,
0x9021,4690,
0x9022,4694,
0x9023,4702,
0x902C,4704,
0x902E,4706,
0x9031,4707,
0x9032,4709,
0x9035,4705,
0x9038,4708,
0x903C,4717,
0x9041,4719,
0x9042,4716,
0x9045,4722,
0x9045,4739,
0x9047,4715,
0x9049,4714,
0x904A,4726,
0x904B,4725,
0x904D,4718,
0x904E,4723,
0x904F,4711,
0x9050,4712,
0x9051,4713,
0x9053,4724,
0x9054,4721,
0x9055,4720,
0x9059,4729,
0x905C,4730,
0x905E,4728,
0x9060,4733,
0x9061,4727,
0x9063,4732,
0x9069,4738,
0x906D,4736,
0x906E,4737,
0x906F,4735,
0x9072,4734,
0x9072,4739,
0x9075,4742,
0x9077,4743,
0x9078,4710,
0x9078,4744,
0x907A,4745,
0x907C,4741,
0x907D,4746,
0x907F,4749,
0x9080,4748,
0x9081,4740,
0x9082,4747,
0x9083,4752,
0x9084,4750,
0x9087,4751,
0x908A,4753,
0x908C,4554,
0x908C,4754,
0x908F,4755,
0x9091,4756,
0x90A3,4757,
0x90A6,4758,
0x90AA,2849,
0x90B8,4759,
0x90C1,4760,
0x90CA,4761,
0x90CE,4762,
0x90CE,4763,
0x90DE,4763,
0x90E1,4764,
0x90E8,4767,
0x90ED,4765,
0x90F5,4768,
0x90F7,4766,
0x90F7,4771,
0x90FD,4769,
0x90FD,4770,
0x9115,4771,
0x9119,4772,
0x912D,4774,
0x9130,4773,
0x9149,4775,
0x914A,4776,
0x914B,593,
0x914C,4778,
0x914D,4779,
0x914E,4777,
0x9152,2573,
0x9154,4781,
0x9156,4780,
0x9162,4783,
0x9163,4782,
0x9166,4802,
0x9169,4784,
0x916A,4786,
0x916C,4785,
0x9175,4787,
0x9177,4788,
0x9178,4789,
0x9182,4792,
0x9187,4793,
0x9189,4790,
0x918B,4791,
0x918D,4795,
0x9190,4794,
0x9192,4796,
0x9197,4802,
0x919C,4798,
0x919E,4797,
0x91A4,4801,
0x91AA,4800,
0x91AB,4799,
0x91AC,4801,
0x91B5,4803,
0x91B8,4804,
0x91BA,4805,
0x91C0,4806,
0x91C1,714,
0x91C6,4807,
0x91C7,2825,
0x91C8,4809,
0x91C8,4812,
0x91C9,4810,
0x91CB,4812,
0x91CC,4813,
0x91CD,224,
0x91CE,4814,
0x91CF,2141,
0x91D0,2062,
0x91D1,4815,
0x91D8,4816,
0x91DC,2834,
0x91DD,4817,
0x91E3,4820,
0x91E6,4819,
0x91E7,4818,
0x91FD,4826,
0x9207,4828,
0x920D,4830,
0x920E,4821,
0x9211,4825,
0x9214,4827,
0x9215,4824,
0x921E,4823,
0x9229,4822,
0x9234,4837,
0x9238,4831,
0x923F,4834,
0x9244,4844,
0x9248,4833,
0x9249,4832,
0x924B,4838,
0x9257,4836,
0x925B,4842,
0x925E,4835,
0x9262,4840,
0x9264,4841,
0x9266,4839,
0x9271,4843,
0x927E,4845,
0x9280,4855,
0x9283,4854,
0x9285,4853,
0x9291,4850,
0x9293,4848,
0x9298,4852,
0x929A,4847,
0x929B,4849,
0x929C,1632,
0x92AD,4851,
0x92B7,4861,
0x92B9,4857,
0x92CF,4858,
0x92D2,4860,
0x92DC,4856,
0x92E4,4863,
0x92E9,4846,
0x92ED,4864,
0x92F2,4862,
0x92F3,4865,
0x92F8,4878,
0x92FA,4869,
0x92FC,4883,
0x9306,4877,
0x9310,4875,
0x9318,4872,
0x931A,4871,
0x9320,4874,
0x9322,133,
0x9322,4866,
0x9323,4868,
0x9326,4882,
0x9328,4876,
0x932B,4873,
0x932C,4881,
0x932E,4867,
0x932F,4880,
0x9332,4879,
0x933A,4859,
0x933B,4870,
0x934A,4881,
0x934A,4884,
0x934B,4892,
0x934D,4889,
0x9354,4890,
0x935B,4895,
0x936C,4891,
0x936E,4885,
0x9375,4894,
0x937C,4893,
0x937E,4888,
0x938C,4902,
0x938D,4898,
0x9394,4904,
0x9396,4901,
0x9397,4896,
0x939A,4887,
0x93A7,4900,
0x93AC,4897,
0x93AD,4903,
0x93AE,4903,
0x93B9,4486,
0x93B9,4886,
0x93C1,4905,
0x93C3,4908,
0x93C8,4899,
0x93D1,4906,
0x93D6,5379,
0x93D8,4909,
0x93DD,4911,
0x93E1,4912,
0x93E4,4910,
0x93E8,4907,
0x93FD,4918,
0x9403,4915,
0x9418,4917,
0x9419,4913,
0x941A,4916,
0x942B,4914,
0x9435,4919,
0x9436,4922,
0x9438,4920,
0x9444,4923,
0x9451,4924,
0x9452,4924,
0x9453,4921,
0x945A,4930,
0x945B,4925,
0x945E,4929,
0x9460,4928,
0x9462,4927,
0x9463,4926,
0x946A,4931,
0x9470,4933,
0x9472,4934,
0x9475,4932,
0x947C,4936,
0x947D,4930,
0x947D,4935,
0x947F,4937,
0x9577,4938,
0x9580,4940,
0x9582,4941,
0x9583,4942,
0x9589,4945,
0x958A,4943,
0x958B,4950,
0x958F,4946,
0x9591,4948,
0x9593,4949,
0x9598,4952,
0x9599,4951,
0x95A2,4958,
0x95A3,4957,
0x95A4,4953,
0x95A5,4954,
0x95A7,4955,
0x95A8,4956,
0x95AD,4960,
0x95B2,4961,
0x95B9,4963,
0x95BB,4965,
0x95BC,4964,
0x95BE,4962,
0x95C7,4969,
0x95CA,4966,
0x95CB,4967,
0x95CC,4968,
0x95D4,4970,
0x95D5,4972,
0x95D6,4971,
0x95D8,4973,
0x95DC,4974,
0x95E1,4975,
0x95E2,4976,
0x961C,4977,
0x9621,4978,
0x962A,4979,
0x9632,4980,
0x963B,4984,
0x963C,4981,
0x963F,4985,
0x9640,4982,
0x9644,4983,
0x964B,4986,
0x964D,4994,
0x9650,4987,
0x965B,4988,
0x965E,4989,
0x9662,4991,
0x9663,4992,
0x9664,4993,
0x9665,4990,
0x966A,5002,
0x966C,4997,
0x9670,5006,
0x9672,4996,
0x9673,5001,
0x9675,4998,
0x9676,5003,
0x9677,4995,
0x9678,5005,
0x967A,5000,
0x967D,5012,
0x9685,5009,
0x9686,4999,
0x9686,5007,
0x9688,5008,
0x968A,5010,
0x968E,5011,
0x968F,5004,
0x9694,5016,
0x9695,5015,
0x9698,5014,
0x9699,5013,
0x969B,5018,
0x969C,5019,
0x96A0,5020,
0x96A3,5023,
0x96A7,5022,
0x96A8,5021,
0x96AA,5024,
0x96B1,5025,
0x96B7,5026,
0x96B8,5027,
0x96BB,5028,
0x96C0,233,
0x96C1,830,
0x96C1,836,
0x96C4,5030,
0x96C5,2850,
0x96C6,5031,
0x96C7,1826,
0x96C9,3173,
0x96CC,2435,
0x96CD,324,
0x96D1,5032,
0x96D5,5033,
0x96D6,5034,
0x96D9,866,
0x96DB,5037,
0x96DC,5035,
0x96DE,5036,
0x96E2,5040,
0x96E3,5038,
0x96E3,5039,
0x96E8,5042,
0x96EA,5044,
0x96EB,5043,
0x96F0,5045,
0x96F2,5046,
0x96F6,5048,
0x96F7,5049,
0x96F9,5047,
0x96FB,5050,
0x9700,5052,
0x9704,5054,
0x9706,5053,
0x9707,5055,
0x9708,5059,
0x970A,5056,
0x970F,5061,
0x9711,5058,
0x9713,5057,
0x9716,5062,
0x9719,5060,
0x971C,5064,
0x971E,5063,
0x9727,5065,
0x9730,5066,
0x9732,5069,
0x9738,5067,
0x9739,5068,
0x973D,5070,
0x9742,5073,
0x9744,5074,
0x9746,5071,
0x9748,5056,
0x9748,5072,
0x9749,5075,
0x9752,5076,
0x9756,3358,
0x9759,5077,
0x975B,5078,
0x975C,5079,
0x975E,5080,
0x9760,5085,
0x9761,5397,
0x9762,5087,
0x9768,73,
0x9769,5088,
0x976B,5090,
0x976D,5091,
0x9771,5091,
0x9774,5092,
0x9784,5095,
0x9785,5094,
0x9786,5093,
0x978B,5096,
0x978D,5098,
0x978F,5097,
0x9798,5099,
0x979C,5100,
0x97A0,5101,
0x97A3,5103,
0x97AB,5102,
0x97AD,5104,
0x97B4,5105,
0x97BA,5106,
0x97D3,5107,
0x97DC,5108,
0x97ED,5109,
0x97EE,3988,
0x97F2,336,
0x97F2,5427,
0x97F3,5110,
0x97FB,5115,
0x97FF,5114,
0x97FF,5116,
0x9801,5117,
0x9802,5118,
0x9803,754,
0x9805,1459,
0x9806,1450,
0x9808,1592,
0x980C,5120,
0x9810,5123,
0x9811,5122,
0x9812,5119,
0x9813,5121,
0x9817,3110,
0x9818,5124,
0x9824,5126,
0x982C,5131,
0x982D,4469,
0x9837,5125,
0x9838,5132,
0x9839,5130,
0x983B,5128,
0x983C,5129,
0x9846,5133,
0x984B,5134,
0x984C,2164,
0x984D,5136,
0x984E,5135,
0x9854,5139,
0x9855,5144,
0x9855,5137,
0x9858,255,
0x985B,5140,
0x985E,5138,
0x9865,5142,
0x9867,5141,
0x986B,5143,
0x986C,5145,
0x986F,5144,
0x9870,2437,
0x9871,259,
0x9873,5147,
0x9874,5146,
0x98A8,5148,
0x98AA,65,
0x98AF,3362,
0x98B1,5149,
0x98B6,5150,
0x98C4,5151,
0x98DB,5152,
0x98DC,5153,
0x98DF,5154,
0x98E2,5155,
0x98E9,5156,
0x98ED,5157,
0x98EF,5158,
0x98F2,5159,
0x98F4,5160,
0x98FC,5163,
0x98FD,5162,
0x98FE,5161,
0x9905,5166,
0x9909,5164,
0x990A,3671,
0x990C,5167,
0x9910,5170,
0x9912,5169,
0x9913,5171,
0x9918,5168,
0x991E,5173,
0x9920,5172,
0x9921,5175,
0x9928,5174,
0x992C,5176,
0x993E,5177,
0x9942,5178,
0x9945,5180,
0x9949,5179,
0x994C,5181,
0x9950,5182,
0x9951,5185,
0x9952,5183,
0x9957,5184,
0x995C,257,
0x995C,841,
0x9996,5186,
0x9998,5187,
0x9999,5188,
0x99A5,5189,
0x99A8,5190,
0x99AC,5191,
0x99AD,5192,
0x99B1,5193,
0x99B3,5195,
0x99B4,5194,
0x99BF,5196,
0x99C1,5197,
0x99C4,5198,
0x99C5,5199,
0x99C6,5200,
0x99C8,5208,
0x99D0,5209,
0x99D1,5205,
0x99D2,5206,
0x99D5,5207,
0x99D8,5203,
0x99DB,5202,
0x99DD,5204,
0x99DF,5201,
0x99E2,5211,
0x99ED,5213,
0x99EE,5210,
0x99F1,5212,
0x99F8,5214,
0x99FB,5215,
0x99FF,5216,
0x9A08,5211,
0x9A08,5218,
0x9A0E,5222,
0x9A0F,5219,
0x9A10,5217,
0x9A12,5221,
0x9A13,5217,
0x9A13,5220,
0x9A19,5223,
0x9A30,3834,
0x9A37,5224,
0x9A3E,5226,
0x9A40,4102,
0x9A45,5225,
0x9A45,5200,
0x9A4D,5227,
0x9A55,5228,
0x9A57,5231,
0x9A5A,5229,
0x9A5B,5230,
0x9A5F,5232,
0x9A62,5233,
0x9A65,5234,
0x9A69,5235,
0x9AA8,5236,
0x9AB0,5237,
0x9AB6,5238,
0x9AB8,5240,
0x9ABC,5239,
0x9AC0,5241,
0x9AC4,5242,
0x9ACF,5243,
0x9AD1,5246,
0x9AD3,5244,
0x9AD4,5245,
0x9AD8,5247,
0x9AD8,5248,
0x9AD9,5247,
0x9AE2,5252,
0x9AE3,5254,
0x9AE5,5253,
0x9AEA,5255,
0x9AED,5262,
0x9AEE,5256,
0x9AEF,5259,
0x9AF1,5258,
0x9AF4,5257,
0x9AF7,5260,
0x9AFB,5261,
0x9B18,5263,
0x9B1A,5264,
0x9B1B,5267,
0x9B22,5266,
0x9B23,5265,
0x9B27,5268,
0x9B28,5269,
0x9B29,5270,
0x9B2A,5271,
0x9B2E,5273,
0x9B2E,5272,
0x9B31,2411,
0x9B3B,5275,
0x9B3C,5276,
0x9B41,5277,
0x9B42,5278,
0x9B43,5279,
0x9B44,3108,
0x9B45,5280,
0x9B54,5398,
0x9B58,258,
0x9B5A,692,
0x9B6F,5283,
0x9B73,5282,
0x9B83,5285,
0x9B8E,5288,
0x9B91,5284,
0x9B92,5287,
0x9B93,5286,
0x9B9E,5289,
0x9BA0,5292,
0x9BA8,5293,
0x9BAA,5290,
0x9BAB,5294,
0x9BAD,5291,
0x9BAE,5295,
0x9BB9,5297,
0x9BC1,5298,
0x9BC9,5299,
0x9BD2,5296,
0x9BD4,5304,
0x9BD6,5301,
0x9BDB,5305,
0x9BE1,5302,
0x9BE3,5303,
0x9BE8,5307,
0x9BF0,5300,
0x9BF1,5306,
0x9BF7,5310,
0x9BFD,5312,
0x9C08,5313,
0x9C0A,5309,
0x9C0C,5314,
0x9C0D,5311,
0x9C10,5317,
0x9C12,5316,
0x9C13,5315,
0x9C15,5308,
0x9C24,5320,
0x9C25,5321,
0x9C2D,5322,
0x9C2E,5319,
0x9C2F,5318,
0x9C39,5327,
0x9C3A,5324,
0x9C3B,5326,
0x9C3E,5323,
0x9C46,5325,
0x9C48,5328,
0x9C49,5329,
0x9C49,5413,
0x9C4F,5330,
0x9C52,5332,
0x9C53,5331,
0x9C57,5334,
0x9C58,5333,
0x9C67,5336,
0x9C6E,5335,
0x9C76,5337,
0x9C77,5338,
0x9C78,5339,
0x9CE5,5340,
0x9CE7,5341,
0x9CE9,5342,
0x9CF3,662,
0x9CF4,983,
0x9CF6,1559,
0x9D08,836,
0x9D09,2851,
0x9D0E,5367,
0x9D12,5344,
0x9D1B,5346,
0x9D1F,3848,
0x9D1F,5347,
0x9D1F,5348,
0x9D26,5345,
0x9D28,121,
0x9D2B,3013,
0x9D3B,2722,
0x9D3E,5350,
0x9D3F,5349,
0x9D44,3848,
0x9D44,5347,
0x9D51,5351,
0x9D5C,5354,
0x9D5E,5353,
0x9D60,5352,
0x9D61,5355,
0x9D6C,3831,
0x9D72,5356,
0x9D7C,5357,
0x9D89,5358,
0x9D8F,5359,
0x9DA9,5360,
0x9DAF,5364,
0x9DB4,5365,
0x9DB8,5362,
0x9DBA,5363,
0x9DC4,5361,
0x9DD7,5367,
0x9DDA,5366,
0x9DF2,5368,
0x9DF9,1544,
0x9DFA,5369,
0x9E1A,5371,
0x9E1B,5370,
0x9E75,5372,
0x9E78,5374,
0x9E79,5373,
0x9E7C,5374,
0x9E7D,1125,
0x9E7D,3126,
0x9E7F,1510,
0x9E7F,5375,
0x9E91,5378,
0x9E92,5380,
0x9E93,5377,
0x9E97,5381,
0x9E9D,5382,
0x9E9F,5383,
0x9EA4,5384,
0x9EA6,5385,
0x9EA9,5386,
0x9EAA,5389,
0x9EAD,5387,
0x9EB5,5389,
0x9EB9,5388,
0x9EBA,5389,
0x9EBB,5390,
0x9EBE,5391,
0x9EBF,5396,
0x9EC4,5399,
0x9ECD,5400,
0x9ECE,2648,
0x9ECF,5401,
0x9ED0,5402,
0x9ED2,5403,
0x9ED8,2796,
0x9ED8,5405,
0x9ED9,2796,
0x9EDB,5408,
0x9EDC,5407,
0x9EDE,5406,
0x9EE0,5409,
0x9EE5,5410,
0x9EE8,1374,
0x9EEF,5411,
0x9EF4,1643,
0x9EFD,5412,
0x9F08,5413,
0x9F0E,5414,
0x9F13,5415,
0x9F20,5417,
0x9F2C,5418,
0x9F34,5419,
0x9F39,5419,
0x9F39,5420,
0x9F3B,5421,
0x9F3E,5422,
0x9F4E,5426,
0x9F52,5428,
0x9F5D,5430,
0x9F5F,5432,
0x9F61,5431,
0x9F62,5431,
0x9F63,5429,
0x9F66,5433,
0x9F67,5434,
0x9F6A,5436,
0x9F6C,5435,
0x9F72,5439,
0x9F76,5437,
0x9F77,5438,
0x9F8D,3351,
0x9F8D,5440,
0x9F95,568,
0x9F98,5444,
0x9F9C,5445,
0x9FA0,5446,
0xF913,4755,
0xF91D,2402,
0xF91F,4103,
0xF928,1524,
0xF929,3769,
0xF92C,4763,
0xF92D,204,
0xF938,5069,
0xF940,1510,
0xF953,3725,
0xF95A,4375,
0xF963,20,
0xF965,451,
0xF96B,850,
0xF970,2455,
0xF978,34,
0xF97A,2281,
0xF97B,3490,
0xF97C,3885,
0xF98C,837,
0xF993,2783,
0xF996,3569,
0xF99B,4881,
0xF99F,2761,
0xF9AF,3663,
0xF9B3,5056,
0xF9B6,3259,
0xF9BA,268,
0xF9C4,3351,
0xF9DD,3264,
0xF9E6,3650,
0xF9E7,4235,
0xF9E8,4235,
0xFA10,1104,
0xFA16,2900,
0xFA18,3259,
0xFA1C,3358,
0xFA22,4395,
0xFA26,4770,
0xFA2B,5163,
0x20015,18,
0x20BEE,889,
0x2123D,10,
0x22165,1487,
0x22218,1510,
0x2228D,1527,
0x22AE6,1886,
0x233FE,2193,
0x237EC,2402,
0x237F1,2405,
0x2383D,2406,
0x24BF3,68,
0x25535,3210,
0x264B7,3686,
0x26999,2007,
0x26999,3854,
0x275D7,4208,
0x275D7,4212,
0x275F7,1629,
0x27C27,180,
0x28EF6,5017,
0x290B3,5051,
0x29D4B,692,
0x2A012,5348,
0x2A269,3125
};

static int Codes_Defined = sizeof(NelsonTbl)/sizeof(struct unmap);

/*
 * We need a modified form of binary search since we can have multiple
 * identical entries. We therefore search for the first and last matching
 * entries. We return the number of entries found and place the index
 * of the first such entry in the variable whose address is passed as
 * as an argument.
 */

int GetNelson(UTF32 ch, unsigned int *first)
{
  int l;			/* Lower bound of region */
  int u;			/* Upper bound of region */
  int m;			/* Midpoint of region */
  int FirstMatch;		/* Array index of first matching entry */
  int LastMatch;		/* Array index of first matching entry */
  int InitialMatch;		/* Array index of first matching entry located */

  /* First we find a matching entry, if there is one */

  l = 0;
  u = Codes_Defined -1;

  InitialMatch = -1;
  while(l <= u){
    m = (l + u) / 2;
    if(ch < NelsonTbl[m].uc) u = m - 1;
    else if(ch > NelsonTbl[m].uc)  l = m + 1;
    else{
      InitialMatch = m;
      break;
    }
  }
  if(InitialMatch < 0) return(0);

  /* Now we determine the neighborhood containing identical entries  */

  /* First we find the lower bound */

  l = 0;
  u = InitialMatch;

  while(l <= u){
    m = (l + u) / 2;
    if(ch < NelsonTbl[m].uc) u = m - 1;
    else if(ch > NelsonTbl[m].uc)  l = m + 1;
    else{
      FirstMatch = m;
      break;
    }
  }

  /* Now we find the upper bound */

  l = InitialMatch;
  u = Codes_Defined -1;

  while(l <= u){
    m = (l + u) / 2;
    if(ch < NelsonTbl[m].uc) u = m - 1;
    else if(ch > NelsonTbl[m].uc)  l = m + 1;
    else{
      LastMatch = m;
      break;
    }
  }

  *first = FirstMatch;
  return(1+LastMatch-FirstMatch);
}
