% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{page_links}
\alias{page_links}
\title{Retrieve a page's links}
\usage{
page_links(
  language = NULL,
  project = NULL,
  domain = NULL,
  page,
  limit = 50,
  direction = "ascending",
  namespaces = NULL,
  clean_response = FALSE,
  ...
)
}
\arguments{
\item{language}{The language code of the project you wish to query,
if appropriate.}

\item{project}{The project you wish to query ("wikiquote"), if appropriate.
Should be provided in conjunction with \code{language}.}

\item{domain}{as an alternative to a \code{language} and \code{project} combination,
you can also provide a domain ("rationalwiki.org") to the URL constructor, allowing
for the querying of non-Wikimedia MediaWiki instances.}

\item{page}{the title of the page you want the links of.}

\item{limit}{the number of links to retrieve. 50 by default; a maximum of 500 is set server-side.}

\item{direction}{the direction to order the links in, by destination page ID: "ascending"
or "descending". Set to "ascending" by default.}

\item{namespaces}{The namespaces to filter to. By default, links to any namespace
are retrieved: alternately, a numeric vector of accepted namespaces (which are described
\href{https://www.mediawiki.org/wiki/Manual:Namespace#Built-in_namespaces}{here}) can be
provided, and only backlinks from pages within those namespaces will be returned.}

\item{clean_response}{whether to do some basic sanitising of the resulting data structure.
Set to FALSE by default.}

\item{...}{further arguments to pass to httr's GET.}
}
\description{
page_links, when provided with a page title, retrieves internal wikilinks from the
current revision of that page.
}
\examples{
\dontrun{
#Links
links <- page_links("en","wikipedia", page = "Aaron Halfaker")

#Namespace-specific links
mainspace_links <- page_links("en","wikipedia", page = "Aaron Halfaker", namespaces = 0)
}
}
