% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_id.R
\name{as_screenname}
\alias{as_screenname}
\alias{as_userid}
\title{Mark a user id as a screen name}
\usage{
as_screenname(x)
}
\arguments{
\item{x}{A character vector of Twitter screen names.}
}
\description{
There are two ways to identify a Twitter user: a screen name (e.g.
"justinbieber") or a user identifier (e.g. "27260086"). User identifiers
look like regular numbers, but are actually 64-bit integers which can't be
stored in R's numeric vectors. For this reason, rtweet always returns ids as
strings.

Unfortunately this introduces an ambiguity, because user names can
also consist solely of numbers (e.g. "123456") so it's not obvious whether
a string consisting only of numbers is a screen name or a user id. By
default, rtweet will assume its a user id, so if you have a screen name
that consists only of numbers, you'll need to use \code{as_screenname()} to
tell rtweet that it's actually a screen name.

Note that in general, you are best off using user ids; screen names are
not static and may change over longer periods of time.
}
\seealso{
Other users: 
\code{\link{lists_subscribers}()},
\code{\link{lookup_users}()},
\code{\link{search_users}()}
}
\concept{users}
