require 'spec_helper'

describe 'collectd::plugin::numa', type: :class do
  on_supported_os(baseline_os_hash).each do |os, facts|
    context "on #{os} " do
      let :facts do
        facts
      end

      options = os_specific_options(facts)
      context 'default' do
        it 'defaults' do
          content = <<EOS
# Generated by Puppet
<LoadPlugin numa>
  Globals false
</LoadPlugin>


EOS

          is_expected.to compile.with_all_deps
          is_expected.to contain_file('numa.load').with(
            content: content,
            path: "#{options[:plugin_conf_dir]}/10-numa.conf"
          )
        end
      end
    end
  end
end
