/*
 * Decompiled with CFR 0.152.
 */
package ork.plugins;

import cqure.repeng.ReportObject;
import cqure.repeng.ReportTree;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import ork.Account;
import ork.AccountList;
import ork.Logger;
import ork.OracleDBConnection;
import ork.SIDList;
import ork.ServerResult;

public class PluginHelper {
    ServerResult m_oRes = null;
    AccountList m_oAccList = null;
    SIDList m_oSIDList = null;
    Logger m_oLogger = null;
    ReportTree m_oTree = null;

    public PluginHelper(ServerResult oRes) {
        this.m_oRes = oRes;
        this.m_oAccList = oRes.getAccountList();
        this.m_oSIDList = oRes.getSIDList();
    }

    public PluginHelper(ServerResult oRes, Logger oLogger) {
        this.m_oRes = oRes;
        this.m_oAccList = oRes.getAccountList();
        this.m_oSIDList = oRes.getSIDList();
        this.m_oLogger = oLogger;
    }

    public PluginHelper(ServerResult oRes, Logger oLogger, ReportTree oTree) {
        this.m_oRes = oRes;
        this.m_oAccList = oRes.getAccountList();
        this.m_oSIDList = oRes.getSIDList();
        this.m_oLogger = oLogger;
        this.m_oTree = oTree;
    }

    public Connection getConnectionWithRole(String sSID, String sRole) {
        String sPath = String.valueOf(this.m_oRes.getServer()) + "/" + sSID + "/Accounts";
        String sPriv = null;
        String sStatus = null;
        OracleDBConnection oOConn = null;
        StringTokenizer oPrivs = null;
        if (this.m_oTree == null) {
            return null;
        }
        ReportObject oRo = this.m_oTree.findReportItem(sPath);
        if (oRo == null) {
            this.m_oLogger.info("PluginHelper: failed to find path: " + sPath);
            return null;
        }
        Enumeration oEnum = oRo.children();
        while (oEnum.hasMoreElements()) {
            oRo = (ReportObject)oEnum.nextElement();
            sStatus = (String)oRo.getProperty("Status");
            if (sStatus == null || !sStatus.equalsIgnoreCase("Open")) continue;
            if ((String)oRo.getProperty("Privileges") != null) {
                oPrivs = new StringTokenizer((String)oRo.getProperty("Privileges"), ",");
            }
            while (oPrivs != null && oPrivs.hasMoreTokens()) {
                sPriv = oPrivs.nextToken();
                if (!sPriv.equalsIgnoreCase(sRole)) continue;
                oOConn = new OracleDBConnection(this.m_oRes.getServer(), this.m_oRes.getPort(), sSID);
                oOConn.setUser(oRo.getName());
                oOConn.setPassword((String)oRo.getProperty("Password"));
                if (oOConn.login() != 28009) continue;
                this.m_oLogger.debug("[x] Connection requires AS SYSDBA, trying ...");
                oOConn.setUser(String.valueOf(oRo.getName()) + " AS SYSDBA");
                oOConn.login();
            }
        }
        if (oOConn != null) {
            return oOConn.getConnection();
        }
        return null;
    }

    public Connection getAdminConnection() {
        return null;
    }

    public Connection getAnyConnection() {
        String sSID = null;
        Vector oV = null;
        boolean bFound = false;
        Account oA = null;
        int i = 0;
        OracleDBConnection oOraConn = null;
        while ((sSID = this.m_oSIDList.getNextSID()) != null) {
            oV = this.m_oAccList.getAccountsForSID(sSID);
            while (oV != null && !bFound && i < oV.size()) {
                oA = (Account)oV.get(i);
                if (oA != null && oA.getState() == 0) {
                    oOraConn = new OracleDBConnection(this.m_oRes.getServer(), this.m_oRes.getPort(), sSID);
                    oOraConn.setUser(oA.getUsername());
                    oOraConn.setPassword(oA.getPassword());
                    oOraConn.login();
                    return oOraConn.getConnection();
                }
                ++i;
            }
        }
        return null;
    }
}

