/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualValues;

public class PathReference
extends VirtualPathValue {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(PathReference.class);
    private final long[] nodes;
    private final long[] relationships;

    PathReference(long[] nodes, long[] relationships) {
        this.nodes = nodes;
        this.relationships = relationships;
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE;
    }

    @Override
    public long startNodeId() {
        return this.nodes[0];
    }

    @Override
    public long endNodeId() {
        return this.nodes[this.nodes.length - 1];
    }

    @Override
    public long[] nodeIds() {
        return this.nodes;
    }

    @Override
    public long[] relationshipIds() {
        return this.relationships;
    }

    @Override
    public int size() {
        return this.relationships.length;
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        writer.writePathReference(this.nodes, this.relationships);
    }

    @Override
    public ListValue asList() {
        int size = this.nodes.length + this.relationships.length;
        ListValueBuilder builder = ListValueBuilder.newListBuilder(size);
        for (int i = 0; i < size; ++i) {
            if (i % 2 == 0) {
                builder.add(VirtualValues.node(this.nodes[i / 2]));
                continue;
            }
            builder.add(VirtualValues.relationship(this.relationships[i / 2]));
        }
        return builder.build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getTypeName() + "{");
        sb.append("(").append(this.nodes[0]).append(")");
        for (int i = 0; i < this.relationships.length; ++i) {
            sb.append("-");
            sb.append("[").append(this.relationships[i]).append("]");
            sb.append("-");
            sb.append("(").append(this.nodes[i + 1]).append(")");
        }
        sb.append('}');
        return sb.toString();
    }
}

