/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import org.neo4j.io.pagecache.IOController;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.monitoring.Health;

public class CheckpointerLifecycle
extends LifecycleAdapter {
    private final CheckPointer checkPointer;
    private final Health databaseHealth;
    private final IOController ioController;
    private volatile boolean checkpointOnShutdown = true;

    public CheckpointerLifecycle(CheckPointer checkPointer, Health databaseHealth, IOController ioController) {
        this.checkPointer = checkPointer;
        this.databaseHealth = databaseHealth;
        this.ioController = ioController;
    }

    public void setCheckpointOnShutdown(boolean checkpointOnShutdown) {
        this.checkpointOnShutdown = checkpointOnShutdown;
    }

    public void shutdown() throws Exception {
        if (this.checkpointOnShutdown && this.databaseHealth.isHealthy()) {
            this.ioController.disable();
            this.checkPointer.forceCheckPoint(new SimpleTriggerInfo("Database shutdown"));
        }
    }
}

