/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RecordLoadOverride;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.RelationshipDirection;

class RecordRelationshipGroupCursor
extends RelationshipGroupRecord
implements AutoCloseable {
    private final RelationshipStore relationshipStore;
    private final RelationshipGroupStore groupStore;
    private final RelationshipGroupDegreesStore groupDegreesStore;
    private final CursorContext cursorContext;
    private final RelationshipRecord edge = new RelationshipRecord(-1L);
    private PageCursor page;
    private PageCursor edgePage;
    private boolean open;
    RecordLoadOverride loadMode;

    RecordRelationshipGroupCursor(RelationshipStore relationshipStore, RelationshipGroupStore groupStore, RelationshipGroupDegreesStore groupDegreesStore, RecordLoadOverride loadMode, CursorContext cursorContext) {
        super(-1L);
        this.relationshipStore = relationshipStore;
        this.groupStore = groupStore;
        this.groupDegreesStore = groupDegreesStore;
        this.cursorContext = cursorContext;
        this.loadMode = loadMode;
    }

    void init(long nodeReference, long reference, boolean nodeIsDense) {
        if (reference != -1L && !nodeIsDense) {
            throw new UnsupportedOperationException("Not a dense node");
        }
        this.direct(nodeReference, reference);
        this.open = true;
    }

    void direct(long nodeReference, long reference) {
        this.clear();
        this.setOwningNode(nodeReference);
        this.setNext(reference);
        if (this.page == null) {
            this.page = this.groupPage(reference);
        }
    }

    boolean next() {
        do {
            if (this.getNext() == -1L) {
                return false;
            }
            this.group(this, this.getNext(), this.page);
        } while (!this.inUse());
        return true;
    }

    int outgoingCount() {
        return this.count(this.outgoingRawId(), this.hasExternalDegreesOut(), RelationshipDirection.OUTGOING);
    }

    int incomingCount() {
        return this.count(this.incomingRawId(), this.hasExternalDegreesIn(), RelationshipDirection.INCOMING);
    }

    int loopCount() {
        return this.count(this.loopsRawId(), this.hasExternalDegreesLoop(), RelationshipDirection.LOOP);
    }

    private int count(long reference, boolean hasExternal, RelationshipDirection direction) {
        if (reference == -1L) {
            return 0;
        }
        if (hasExternal) {
            return Numbers.safeCastLongToInt((long)this.groupDegreesStore.degree(this.getId(), direction, this.cursorContext));
        }
        if (this.edgePage == null) {
            this.edgePage = this.relationshipStore.openPageCursorForReading(reference, this.cursorContext);
        }
        this.relationshipStore.getRecordByCursor(reference, this.edge, this.loadMode.orElse(RecordLoad.ALWAYS), this.edgePage);
        return (int)this.edge.getPrevRel(this.getOwningNode());
    }

    @Override
    public RelationshipGroupRecord copy() {
        throw new UnsupportedOperationException("Record cursors are not copyable.");
    }

    @Override
    public String toString() {
        if (!this.open) {
            return "RelationshipGroupCursor[closed state]";
        }
        return "RelationshipGroupCursor[id=" + this.getId() + ", open state with: underlying record=" + super.toString() + "]";
    }

    long outgoingRawId() {
        return this.getFirstOut();
    }

    long incomingRawId() {
        return this.getFirstIn();
    }

    long loopsRawId() {
        return this.getFirstLoop();
    }

    @Override
    public void close() {
        if (this.edgePage != null) {
            this.edgePage.close();
            this.edgePage = null;
        }
        if (this.page != null) {
            this.page.close();
            this.page = null;
        }
    }

    private PageCursor groupPage(long reference) {
        return this.groupStore.openPageCursorForReading(reference, this.cursorContext);
    }

    private void group(RelationshipGroupRecord record, long reference, PageCursor page) {
        this.groupStore.getRecordByCursor(reference, record, this.loadMode.orElse(RecordLoad.ALWAYS), page);
    }
}

