/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.function.Function;
import org.neo4j.common.ProgressReporter;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.ProcessRelationshipCountsDataStep;
import org.neo4j.internal.batchimport.RecordIdIterators;
import org.neo4j.internal.batchimport.cache.NodeLabelsCache;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.staging.BatchFeedStep;
import org.neo4j.internal.batchimport.staging.ReadRecordsStep;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class RelationshipCountsStage
extends Stage {
    public static final String NAME = "Relationship counts";

    public RelationshipCountsStage(Configuration config, NodeLabelsCache cache, RelationshipStore relationshipStore, int highLabelId, int highRelationshipTypeId, CountsAccessor.Updater countsUpdater, NumberArrayFactory cacheFactory, ProgressReporter progressReporter, PageCacheTracer pageCacheTracer, Function<CursorContext, StoreCursors> storeCursorsCreator, MemoryTracker memoryTracker) {
        super(NAME, null, config, 2);
        this.add((Step)new BatchFeedStep(this.control(), config, RecordIdIterators.allIn(relationshipStore, config), relationshipStore.getRecordSize()));
        this.add((Step)new ReadRecordsStep<RelationshipRecord>(this.control(), config, false, relationshipStore, pageCacheTracer));
        this.add((Step)new ProcessRelationshipCountsDataStep(this.control(), cache, config, highLabelId, highRelationshipTypeId, countsUpdater, cacheFactory, progressReporter, pageCacheTracer, storeCursorsCreator, memoryTracker));
    }
}

