// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package rpc

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// MerlinClient is the client API for Merlin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MerlinClient interface {
	Reconnect(ctx context.Context, in *ID, opts ...grpc.CallOption) (*ID, error)
	Register(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*ID, error)
	Listen(ctx context.Context, in *ID, opts ...grpc.CallOption) (Merlin_ListenClient, error)
	// Agent Commands
	Any(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	CD(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	CheckIn(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error)
	ClearJobs(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error)
	ClearJobsCreated(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Message, error)
	CMD(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	Connect(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	Download(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	ENV(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	ExecuteAssembly(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	ExecutePE(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	ExecuteShellcode(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	Exit(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error)
	IFConfig(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error)
	InvokeAssembly(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	JA3(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	KillDate(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	KillProcess(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	LinkAgent(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	ListAssemblies(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error)
	Listener(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	LoadAssembly(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	LoadCLR(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	LS(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	MaxRetry(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	Memory(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	MEMFD(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	Netstat(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	Note(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	Nslookup(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	Padding(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	Parrot(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	Pipes(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error)
	PS(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error)
	PWD(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error)
	RM(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	RunAs(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	SecureDelete(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	SharpGen(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	Skew(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	Sleep(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	Socks(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	SSH(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	Token(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	Touch(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	UnlinkAgent(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	Upload(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	Uptime(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error)
	// Agent Service
	Groups(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Slice, error)
	GroupAdd(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Message, error)
	GroupList(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Slice, error)
	GroupListAll(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*GroupMembers, error)
	GroupRemove(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Message, error)
	GetAgent(ctx context.Context, in *ID, opts ...grpc.CallOption) (*AgentInfo, error)
	GetAgents(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Slice, error)
	GetAgentLinks(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Slice, error)
	GetAgentStatus(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error)
	GetAgentRows(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*TableData, error)
	Remove(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error)
	// Job Service
	GetAllJobs(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Jobs, error)
	GetAllActiveJobs(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Jobs, error)
	GetAgentJobs(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Jobs, error)
	GetAgentActiveJobs(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Jobs, error)
	// Listener
	CreateListener(ctx context.Context, in *Options, opts ...grpc.CallOption) (*Message, error)
	GetListenerIDs(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Slice, error)
	GetListeners(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*TableData, error)
	GetListenerOptions(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Options, error)
	GetListenerDefaultOptions(ctx context.Context, in *String, opts ...grpc.CallOption) (*Options, error)
	GetListenerTypes(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Slice, error)
	GetListenerStatus(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error)
	RemoveListener(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error)
	RestartListener(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error)
	SetListenerOption(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error)
	StartListener(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error)
	StopListener(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error)
	Servers(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Slice, error)
	GetModule(ctx context.Context, in *String, opts ...grpc.CallOption) (*Module, error)
	GetModuleList(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Slice, error)
	RunModule(ctx context.Context, in *ModuleRun, opts ...grpc.CallOption) (*Messages, error)
}

type merlinClient struct {
	cc grpc.ClientConnInterface
}

func NewMerlinClient(cc grpc.ClientConnInterface) MerlinClient {
	return &merlinClient{cc}
}

func (c *merlinClient) Reconnect(ctx context.Context, in *ID, opts ...grpc.CallOption) (*ID, error) {
	out := new(ID)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Reconnect", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Register(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*ID, error) {
	out := new(ID)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Register", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Listen(ctx context.Context, in *ID, opts ...grpc.CallOption) (Merlin_ListenClient, error) {
	stream, err := c.cc.NewStream(ctx, &Merlin_ServiceDesc.Streams[0], "/rpc.Merlin/Listen", opts...)
	if err != nil {
		return nil, err
	}
	x := &merlinListenClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Merlin_ListenClient interface {
	Recv() (*Message, error)
	grpc.ClientStream
}

type merlinListenClient struct {
	grpc.ClientStream
}

func (x *merlinListenClient) Recv() (*Message, error) {
	m := new(Message)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *merlinClient) Any(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Any", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) CD(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/CD", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) CheckIn(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/CheckIn", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) ClearJobs(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/ClearJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) ClearJobsCreated(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/ClearJobsCreated", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) CMD(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/CMD", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Connect(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Connect", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Download(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Download", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) ENV(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/ENV", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) ExecuteAssembly(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/ExecuteAssembly", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) ExecutePE(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/ExecutePE", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) ExecuteShellcode(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/ExecuteShellcode", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Exit(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Exit", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) IFConfig(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/IFConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) InvokeAssembly(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/InvokeAssembly", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) JA3(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/JA3", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) KillDate(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/KillDate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) KillProcess(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/KillProcess", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) LinkAgent(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/LinkAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) ListAssemblies(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/ListAssemblies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Listener(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Listener", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) LoadAssembly(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/LoadAssembly", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) LoadCLR(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/LoadCLR", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) LS(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/LS", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) MaxRetry(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/MaxRetry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Memory(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Memory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) MEMFD(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/MEMFD", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Netstat(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Netstat", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Note(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Note", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Nslookup(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Nslookup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Padding(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Padding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Parrot(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Parrot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Pipes(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Pipes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) PS(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/PS", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) PWD(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/PWD", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) RM(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/RM", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) RunAs(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/RunAs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) SecureDelete(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/SecureDelete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) SharpGen(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/SharpGen", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Skew(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Skew", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Sleep(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Sleep", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Socks(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Socks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) SSH(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/SSH", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Token(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Token", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Touch(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Touch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) UnlinkAgent(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/UnlinkAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Upload(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Upload", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Uptime(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Uptime", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Groups(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Slice, error) {
	out := new(Slice)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Groups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GroupAdd(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GroupAdd", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GroupList(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Slice, error) {
	out := new(Slice)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GroupList", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GroupListAll(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*GroupMembers, error) {
	out := new(GroupMembers)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GroupListAll", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GroupRemove(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GroupRemove", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GetAgent(ctx context.Context, in *ID, opts ...grpc.CallOption) (*AgentInfo, error) {
	out := new(AgentInfo)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GetAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GetAgents(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Slice, error) {
	out := new(Slice)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GetAgents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GetAgentLinks(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Slice, error) {
	out := new(Slice)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GetAgentLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GetAgentStatus(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GetAgentStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GetAgentRows(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*TableData, error) {
	out := new(TableData)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GetAgentRows", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Remove(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Remove", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GetAllJobs(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Jobs, error) {
	out := new(Jobs)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GetAllJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GetAllActiveJobs(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Jobs, error) {
	out := new(Jobs)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GetAllActiveJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GetAgentJobs(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Jobs, error) {
	out := new(Jobs)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GetAgentJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GetAgentActiveJobs(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Jobs, error) {
	out := new(Jobs)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GetAgentActiveJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) CreateListener(ctx context.Context, in *Options, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/CreateListener", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GetListenerIDs(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Slice, error) {
	out := new(Slice)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GetListenerIDs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GetListeners(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*TableData, error) {
	out := new(TableData)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GetListeners", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GetListenerOptions(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Options, error) {
	out := new(Options)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GetListenerOptions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GetListenerDefaultOptions(ctx context.Context, in *String, opts ...grpc.CallOption) (*Options, error) {
	out := new(Options)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GetListenerDefaultOptions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GetListenerTypes(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Slice, error) {
	out := new(Slice)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GetListenerTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GetListenerStatus(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GetListenerStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) RemoveListener(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/RemoveListener", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) RestartListener(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/RestartListener", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) SetListenerOption(ctx context.Context, in *AgentCMD, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/SetListenerOption", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) StartListener(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/StartListener", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) StopListener(ctx context.Context, in *ID, opts ...grpc.CallOption) (*Message, error) {
	out := new(Message)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/StopListener", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) Servers(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Slice, error) {
	out := new(Slice)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/Servers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GetModule(ctx context.Context, in *String, opts ...grpc.CallOption) (*Module, error) {
	out := new(Module)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GetModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) GetModuleList(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Slice, error) {
	out := new(Slice)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/GetModuleList", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merlinClient) RunModule(ctx context.Context, in *ModuleRun, opts ...grpc.CallOption) (*Messages, error) {
	out := new(Messages)
	err := c.cc.Invoke(ctx, "/rpc.Merlin/RunModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MerlinServer is the server API for Merlin service.
// All implementations must embed UnimplementedMerlinServer
// for forward compatibility
type MerlinServer interface {
	Reconnect(context.Context, *ID) (*ID, error)
	Register(context.Context, *emptypb.Empty) (*ID, error)
	Listen(*ID, Merlin_ListenServer) error
	// Agent Commands
	Any(context.Context, *AgentCMD) (*Message, error)
	CD(context.Context, *AgentCMD) (*Message, error)
	CheckIn(context.Context, *ID) (*Message, error)
	ClearJobs(context.Context, *ID) (*Message, error)
	ClearJobsCreated(context.Context, *emptypb.Empty) (*Message, error)
	CMD(context.Context, *AgentCMD) (*Message, error)
	Connect(context.Context, *AgentCMD) (*Message, error)
	Download(context.Context, *AgentCMD) (*Message, error)
	ENV(context.Context, *AgentCMD) (*Message, error)
	ExecuteAssembly(context.Context, *AgentCMD) (*Message, error)
	ExecutePE(context.Context, *AgentCMD) (*Message, error)
	ExecuteShellcode(context.Context, *AgentCMD) (*Message, error)
	Exit(context.Context, *ID) (*Message, error)
	IFConfig(context.Context, *ID) (*Message, error)
	InvokeAssembly(context.Context, *AgentCMD) (*Message, error)
	JA3(context.Context, *AgentCMD) (*Message, error)
	KillDate(context.Context, *AgentCMD) (*Message, error)
	KillProcess(context.Context, *AgentCMD) (*Message, error)
	LinkAgent(context.Context, *AgentCMD) (*Message, error)
	ListAssemblies(context.Context, *ID) (*Message, error)
	Listener(context.Context, *AgentCMD) (*Message, error)
	LoadAssembly(context.Context, *AgentCMD) (*Message, error)
	LoadCLR(context.Context, *AgentCMD) (*Message, error)
	LS(context.Context, *AgentCMD) (*Message, error)
	MaxRetry(context.Context, *AgentCMD) (*Message, error)
	Memory(context.Context, *AgentCMD) (*Message, error)
	MEMFD(context.Context, *AgentCMD) (*Message, error)
	Netstat(context.Context, *AgentCMD) (*Message, error)
	Note(context.Context, *AgentCMD) (*Message, error)
	Nslookup(context.Context, *AgentCMD) (*Message, error)
	Padding(context.Context, *AgentCMD) (*Message, error)
	Parrot(context.Context, *AgentCMD) (*Message, error)
	Pipes(context.Context, *ID) (*Message, error)
	PS(context.Context, *ID) (*Message, error)
	PWD(context.Context, *ID) (*Message, error)
	RM(context.Context, *AgentCMD) (*Message, error)
	RunAs(context.Context, *AgentCMD) (*Message, error)
	SecureDelete(context.Context, *AgentCMD) (*Message, error)
	SharpGen(context.Context, *AgentCMD) (*Message, error)
	Skew(context.Context, *AgentCMD) (*Message, error)
	Sleep(context.Context, *AgentCMD) (*Message, error)
	Socks(context.Context, *AgentCMD) (*Message, error)
	SSH(context.Context, *AgentCMD) (*Message, error)
	Token(context.Context, *AgentCMD) (*Message, error)
	Touch(context.Context, *AgentCMD) (*Message, error)
	UnlinkAgent(context.Context, *AgentCMD) (*Message, error)
	Upload(context.Context, *AgentCMD) (*Message, error)
	Uptime(context.Context, *ID) (*Message, error)
	// Agent Service
	Groups(context.Context, *emptypb.Empty) (*Slice, error)
	GroupAdd(context.Context, *Group) (*Message, error)
	GroupList(context.Context, *ID) (*Slice, error)
	GroupListAll(context.Context, *emptypb.Empty) (*GroupMembers, error)
	GroupRemove(context.Context, *Group) (*Message, error)
	GetAgent(context.Context, *ID) (*AgentInfo, error)
	GetAgents(context.Context, *emptypb.Empty) (*Slice, error)
	GetAgentLinks(context.Context, *ID) (*Slice, error)
	GetAgentStatus(context.Context, *ID) (*Message, error)
	GetAgentRows(context.Context, *emptypb.Empty) (*TableData, error)
	Remove(context.Context, *ID) (*Message, error)
	// Job Service
	GetAllJobs(context.Context, *emptypb.Empty) (*Jobs, error)
	GetAllActiveJobs(context.Context, *emptypb.Empty) (*Jobs, error)
	GetAgentJobs(context.Context, *ID) (*Jobs, error)
	GetAgentActiveJobs(context.Context, *ID) (*Jobs, error)
	// Listener
	CreateListener(context.Context, *Options) (*Message, error)
	GetListenerIDs(context.Context, *emptypb.Empty) (*Slice, error)
	GetListeners(context.Context, *emptypb.Empty) (*TableData, error)
	GetListenerOptions(context.Context, *ID) (*Options, error)
	GetListenerDefaultOptions(context.Context, *String) (*Options, error)
	GetListenerTypes(context.Context, *emptypb.Empty) (*Slice, error)
	GetListenerStatus(context.Context, *ID) (*Message, error)
	RemoveListener(context.Context, *ID) (*Message, error)
	RestartListener(context.Context, *ID) (*Message, error)
	SetListenerOption(context.Context, *AgentCMD) (*Message, error)
	StartListener(context.Context, *ID) (*Message, error)
	StopListener(context.Context, *ID) (*Message, error)
	Servers(context.Context, *emptypb.Empty) (*Slice, error)
	GetModule(context.Context, *String) (*Module, error)
	GetModuleList(context.Context, *emptypb.Empty) (*Slice, error)
	RunModule(context.Context, *ModuleRun) (*Messages, error)
	mustEmbedUnimplementedMerlinServer()
}

// UnimplementedMerlinServer must be embedded to have forward compatible implementations.
type UnimplementedMerlinServer struct {
}

func (UnimplementedMerlinServer) Reconnect(context.Context, *ID) (*ID, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Reconnect not implemented")
}
func (UnimplementedMerlinServer) Register(context.Context, *emptypb.Empty) (*ID, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Register not implemented")
}
func (UnimplementedMerlinServer) Listen(*ID, Merlin_ListenServer) error {
	return status.Errorf(codes.Unimplemented, "method Listen not implemented")
}
func (UnimplementedMerlinServer) Any(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Any not implemented")
}
func (UnimplementedMerlinServer) CD(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CD not implemented")
}
func (UnimplementedMerlinServer) CheckIn(context.Context, *ID) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckIn not implemented")
}
func (UnimplementedMerlinServer) ClearJobs(context.Context, *ID) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ClearJobs not implemented")
}
func (UnimplementedMerlinServer) ClearJobsCreated(context.Context, *emptypb.Empty) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ClearJobsCreated not implemented")
}
func (UnimplementedMerlinServer) CMD(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CMD not implemented")
}
func (UnimplementedMerlinServer) Connect(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Connect not implemented")
}
func (UnimplementedMerlinServer) Download(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Download not implemented")
}
func (UnimplementedMerlinServer) ENV(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ENV not implemented")
}
func (UnimplementedMerlinServer) ExecuteAssembly(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExecuteAssembly not implemented")
}
func (UnimplementedMerlinServer) ExecutePE(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExecutePE not implemented")
}
func (UnimplementedMerlinServer) ExecuteShellcode(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExecuteShellcode not implemented")
}
func (UnimplementedMerlinServer) Exit(context.Context, *ID) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Exit not implemented")
}
func (UnimplementedMerlinServer) IFConfig(context.Context, *ID) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IFConfig not implemented")
}
func (UnimplementedMerlinServer) InvokeAssembly(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InvokeAssembly not implemented")
}
func (UnimplementedMerlinServer) JA3(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method JA3 not implemented")
}
func (UnimplementedMerlinServer) KillDate(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method KillDate not implemented")
}
func (UnimplementedMerlinServer) KillProcess(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method KillProcess not implemented")
}
func (UnimplementedMerlinServer) LinkAgent(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LinkAgent not implemented")
}
func (UnimplementedMerlinServer) ListAssemblies(context.Context, *ID) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAssemblies not implemented")
}
func (UnimplementedMerlinServer) Listener(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Listener not implemented")
}
func (UnimplementedMerlinServer) LoadAssembly(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LoadAssembly not implemented")
}
func (UnimplementedMerlinServer) LoadCLR(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LoadCLR not implemented")
}
func (UnimplementedMerlinServer) LS(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LS not implemented")
}
func (UnimplementedMerlinServer) MaxRetry(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MaxRetry not implemented")
}
func (UnimplementedMerlinServer) Memory(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Memory not implemented")
}
func (UnimplementedMerlinServer) MEMFD(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MEMFD not implemented")
}
func (UnimplementedMerlinServer) Netstat(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Netstat not implemented")
}
func (UnimplementedMerlinServer) Note(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Note not implemented")
}
func (UnimplementedMerlinServer) Nslookup(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Nslookup not implemented")
}
func (UnimplementedMerlinServer) Padding(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Padding not implemented")
}
func (UnimplementedMerlinServer) Parrot(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Parrot not implemented")
}
func (UnimplementedMerlinServer) Pipes(context.Context, *ID) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Pipes not implemented")
}
func (UnimplementedMerlinServer) PS(context.Context, *ID) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PS not implemented")
}
func (UnimplementedMerlinServer) PWD(context.Context, *ID) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PWD not implemented")
}
func (UnimplementedMerlinServer) RM(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RM not implemented")
}
func (UnimplementedMerlinServer) RunAs(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunAs not implemented")
}
func (UnimplementedMerlinServer) SecureDelete(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SecureDelete not implemented")
}
func (UnimplementedMerlinServer) SharpGen(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SharpGen not implemented")
}
func (UnimplementedMerlinServer) Skew(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Skew not implemented")
}
func (UnimplementedMerlinServer) Sleep(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Sleep not implemented")
}
func (UnimplementedMerlinServer) Socks(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Socks not implemented")
}
func (UnimplementedMerlinServer) SSH(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SSH not implemented")
}
func (UnimplementedMerlinServer) Token(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Token not implemented")
}
func (UnimplementedMerlinServer) Touch(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Touch not implemented")
}
func (UnimplementedMerlinServer) UnlinkAgent(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UnlinkAgent not implemented")
}
func (UnimplementedMerlinServer) Upload(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Upload not implemented")
}
func (UnimplementedMerlinServer) Uptime(context.Context, *ID) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Uptime not implemented")
}
func (UnimplementedMerlinServer) Groups(context.Context, *emptypb.Empty) (*Slice, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Groups not implemented")
}
func (UnimplementedMerlinServer) GroupAdd(context.Context, *Group) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GroupAdd not implemented")
}
func (UnimplementedMerlinServer) GroupList(context.Context, *ID) (*Slice, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GroupList not implemented")
}
func (UnimplementedMerlinServer) GroupListAll(context.Context, *emptypb.Empty) (*GroupMembers, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GroupListAll not implemented")
}
func (UnimplementedMerlinServer) GroupRemove(context.Context, *Group) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GroupRemove not implemented")
}
func (UnimplementedMerlinServer) GetAgent(context.Context, *ID) (*AgentInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAgent not implemented")
}
func (UnimplementedMerlinServer) GetAgents(context.Context, *emptypb.Empty) (*Slice, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAgents not implemented")
}
func (UnimplementedMerlinServer) GetAgentLinks(context.Context, *ID) (*Slice, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAgentLinks not implemented")
}
func (UnimplementedMerlinServer) GetAgentStatus(context.Context, *ID) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAgentStatus not implemented")
}
func (UnimplementedMerlinServer) GetAgentRows(context.Context, *emptypb.Empty) (*TableData, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAgentRows not implemented")
}
func (UnimplementedMerlinServer) Remove(context.Context, *ID) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Remove not implemented")
}
func (UnimplementedMerlinServer) GetAllJobs(context.Context, *emptypb.Empty) (*Jobs, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAllJobs not implemented")
}
func (UnimplementedMerlinServer) GetAllActiveJobs(context.Context, *emptypb.Empty) (*Jobs, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAllActiveJobs not implemented")
}
func (UnimplementedMerlinServer) GetAgentJobs(context.Context, *ID) (*Jobs, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAgentJobs not implemented")
}
func (UnimplementedMerlinServer) GetAgentActiveJobs(context.Context, *ID) (*Jobs, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAgentActiveJobs not implemented")
}
func (UnimplementedMerlinServer) CreateListener(context.Context, *Options) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateListener not implemented")
}
func (UnimplementedMerlinServer) GetListenerIDs(context.Context, *emptypb.Empty) (*Slice, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetListenerIDs not implemented")
}
func (UnimplementedMerlinServer) GetListeners(context.Context, *emptypb.Empty) (*TableData, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetListeners not implemented")
}
func (UnimplementedMerlinServer) GetListenerOptions(context.Context, *ID) (*Options, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetListenerOptions not implemented")
}
func (UnimplementedMerlinServer) GetListenerDefaultOptions(context.Context, *String) (*Options, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetListenerDefaultOptions not implemented")
}
func (UnimplementedMerlinServer) GetListenerTypes(context.Context, *emptypb.Empty) (*Slice, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetListenerTypes not implemented")
}
func (UnimplementedMerlinServer) GetListenerStatus(context.Context, *ID) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetListenerStatus not implemented")
}
func (UnimplementedMerlinServer) RemoveListener(context.Context, *ID) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveListener not implemented")
}
func (UnimplementedMerlinServer) RestartListener(context.Context, *ID) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestartListener not implemented")
}
func (UnimplementedMerlinServer) SetListenerOption(context.Context, *AgentCMD) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetListenerOption not implemented")
}
func (UnimplementedMerlinServer) StartListener(context.Context, *ID) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartListener not implemented")
}
func (UnimplementedMerlinServer) StopListener(context.Context, *ID) (*Message, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopListener not implemented")
}
func (UnimplementedMerlinServer) Servers(context.Context, *emptypb.Empty) (*Slice, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Servers not implemented")
}
func (UnimplementedMerlinServer) GetModule(context.Context, *String) (*Module, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModule not implemented")
}
func (UnimplementedMerlinServer) GetModuleList(context.Context, *emptypb.Empty) (*Slice, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModuleList not implemented")
}
func (UnimplementedMerlinServer) RunModule(context.Context, *ModuleRun) (*Messages, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunModule not implemented")
}
func (UnimplementedMerlinServer) mustEmbedUnimplementedMerlinServer() {}

// UnsafeMerlinServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MerlinServer will
// result in compilation errors.
type UnsafeMerlinServer interface {
	mustEmbedUnimplementedMerlinServer()
}

func RegisterMerlinServer(s grpc.ServiceRegistrar, srv MerlinServer) {
	s.RegisterService(&Merlin_ServiceDesc, srv)
}

func _Merlin_Reconnect_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Reconnect(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Reconnect",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Reconnect(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Register_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Register(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Register",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Register(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Listen_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ID)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(MerlinServer).Listen(m, &merlinListenServer{stream})
}

type Merlin_ListenServer interface {
	Send(*Message) error
	grpc.ServerStream
}

type merlinListenServer struct {
	grpc.ServerStream
}

func (x *merlinListenServer) Send(m *Message) error {
	return x.ServerStream.SendMsg(m)
}

func _Merlin_Any_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Any(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Any",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Any(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_CD_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).CD(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/CD",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).CD(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_CheckIn_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).CheckIn(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/CheckIn",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).CheckIn(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_ClearJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).ClearJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/ClearJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).ClearJobs(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_ClearJobsCreated_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).ClearJobsCreated(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/ClearJobsCreated",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).ClearJobsCreated(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_CMD_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).CMD(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/CMD",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).CMD(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Connect_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Connect(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Connect",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Connect(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Download_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Download(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Download",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Download(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_ENV_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).ENV(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/ENV",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).ENV(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_ExecuteAssembly_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).ExecuteAssembly(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/ExecuteAssembly",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).ExecuteAssembly(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_ExecutePE_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).ExecutePE(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/ExecutePE",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).ExecutePE(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_ExecuteShellcode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).ExecuteShellcode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/ExecuteShellcode",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).ExecuteShellcode(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Exit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Exit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Exit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Exit(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_IFConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).IFConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/IFConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).IFConfig(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_InvokeAssembly_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).InvokeAssembly(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/InvokeAssembly",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).InvokeAssembly(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_JA3_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).JA3(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/JA3",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).JA3(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_KillDate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).KillDate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/KillDate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).KillDate(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_KillProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).KillProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/KillProcess",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).KillProcess(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_LinkAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).LinkAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/LinkAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).LinkAgent(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_ListAssemblies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).ListAssemblies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/ListAssemblies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).ListAssemblies(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Listener_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Listener(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Listener",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Listener(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_LoadAssembly_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).LoadAssembly(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/LoadAssembly",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).LoadAssembly(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_LoadCLR_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).LoadCLR(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/LoadCLR",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).LoadCLR(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_LS_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).LS(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/LS",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).LS(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_MaxRetry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).MaxRetry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/MaxRetry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).MaxRetry(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Memory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Memory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Memory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Memory(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_MEMFD_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).MEMFD(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/MEMFD",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).MEMFD(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Netstat_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Netstat(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Netstat",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Netstat(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Note_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Note(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Note",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Note(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Nslookup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Nslookup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Nslookup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Nslookup(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Padding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Padding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Padding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Padding(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Parrot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Parrot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Parrot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Parrot(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Pipes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Pipes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Pipes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Pipes(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_PS_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).PS(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/PS",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).PS(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_PWD_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).PWD(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/PWD",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).PWD(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_RM_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).RM(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/RM",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).RM(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_RunAs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).RunAs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/RunAs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).RunAs(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_SecureDelete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).SecureDelete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/SecureDelete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).SecureDelete(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_SharpGen_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).SharpGen(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/SharpGen",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).SharpGen(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Skew_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Skew(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Skew",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Skew(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Sleep_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Sleep(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Sleep",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Sleep(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Socks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Socks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Socks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Socks(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_SSH_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).SSH(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/SSH",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).SSH(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Token_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Token(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Token",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Token(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Touch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Touch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Touch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Touch(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_UnlinkAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).UnlinkAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/UnlinkAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).UnlinkAgent(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Upload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Upload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Upload",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Upload(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Uptime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Uptime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Uptime",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Uptime(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Groups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Groups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Groups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Groups(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GroupAdd_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Group)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GroupAdd(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GroupAdd",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GroupAdd(ctx, req.(*Group))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GroupList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GroupList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GroupList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GroupList(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GroupListAll_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GroupListAll(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GroupListAll",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GroupListAll(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GroupRemove_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Group)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GroupRemove(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GroupRemove",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GroupRemove(ctx, req.(*Group))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GetAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GetAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GetAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GetAgent(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GetAgents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GetAgents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GetAgents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GetAgents(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GetAgentLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GetAgentLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GetAgentLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GetAgentLinks(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GetAgentStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GetAgentStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GetAgentStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GetAgentStatus(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GetAgentRows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GetAgentRows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GetAgentRows",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GetAgentRows(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Remove_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Remove(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Remove",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Remove(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GetAllJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GetAllJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GetAllJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GetAllJobs(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GetAllActiveJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GetAllActiveJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GetAllActiveJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GetAllActiveJobs(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GetAgentJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GetAgentJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GetAgentJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GetAgentJobs(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GetAgentActiveJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GetAgentActiveJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GetAgentActiveJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GetAgentActiveJobs(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_CreateListener_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Options)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).CreateListener(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/CreateListener",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).CreateListener(ctx, req.(*Options))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GetListenerIDs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GetListenerIDs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GetListenerIDs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GetListenerIDs(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GetListeners_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GetListeners(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GetListeners",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GetListeners(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GetListenerOptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GetListenerOptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GetListenerOptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GetListenerOptions(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GetListenerDefaultOptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(String)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GetListenerDefaultOptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GetListenerDefaultOptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GetListenerDefaultOptions(ctx, req.(*String))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GetListenerTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GetListenerTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GetListenerTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GetListenerTypes(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GetListenerStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GetListenerStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GetListenerStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GetListenerStatus(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_RemoveListener_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).RemoveListener(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/RemoveListener",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).RemoveListener(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_RestartListener_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).RestartListener(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/RestartListener",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).RestartListener(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_SetListenerOption_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AgentCMD)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).SetListenerOption(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/SetListenerOption",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).SetListenerOption(ctx, req.(*AgentCMD))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_StartListener_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).StartListener(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/StartListener",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).StartListener(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_StopListener_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).StopListener(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/StopListener",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).StopListener(ctx, req.(*ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_Servers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).Servers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/Servers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).Servers(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GetModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(String)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GetModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GetModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GetModule(ctx, req.(*String))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_GetModuleList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).GetModuleList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/GetModuleList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).GetModuleList(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Merlin_RunModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModuleRun)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerlinServer).RunModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Merlin/RunModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerlinServer).RunModule(ctx, req.(*ModuleRun))
	}
	return interceptor(ctx, in, info, handler)
}

// Merlin_ServiceDesc is the grpc.ServiceDesc for Merlin service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Merlin_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "rpc.Merlin",
	HandlerType: (*MerlinServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Reconnect",
			Handler:    _Merlin_Reconnect_Handler,
		},
		{
			MethodName: "Register",
			Handler:    _Merlin_Register_Handler,
		},
		{
			MethodName: "Any",
			Handler:    _Merlin_Any_Handler,
		},
		{
			MethodName: "CD",
			Handler:    _Merlin_CD_Handler,
		},
		{
			MethodName: "CheckIn",
			Handler:    _Merlin_CheckIn_Handler,
		},
		{
			MethodName: "ClearJobs",
			Handler:    _Merlin_ClearJobs_Handler,
		},
		{
			MethodName: "ClearJobsCreated",
			Handler:    _Merlin_ClearJobsCreated_Handler,
		},
		{
			MethodName: "CMD",
			Handler:    _Merlin_CMD_Handler,
		},
		{
			MethodName: "Connect",
			Handler:    _Merlin_Connect_Handler,
		},
		{
			MethodName: "Download",
			Handler:    _Merlin_Download_Handler,
		},
		{
			MethodName: "ENV",
			Handler:    _Merlin_ENV_Handler,
		},
		{
			MethodName: "ExecuteAssembly",
			Handler:    _Merlin_ExecuteAssembly_Handler,
		},
		{
			MethodName: "ExecutePE",
			Handler:    _Merlin_ExecutePE_Handler,
		},
		{
			MethodName: "ExecuteShellcode",
			Handler:    _Merlin_ExecuteShellcode_Handler,
		},
		{
			MethodName: "Exit",
			Handler:    _Merlin_Exit_Handler,
		},
		{
			MethodName: "IFConfig",
			Handler:    _Merlin_IFConfig_Handler,
		},
		{
			MethodName: "InvokeAssembly",
			Handler:    _Merlin_InvokeAssembly_Handler,
		},
		{
			MethodName: "JA3",
			Handler:    _Merlin_JA3_Handler,
		},
		{
			MethodName: "KillDate",
			Handler:    _Merlin_KillDate_Handler,
		},
		{
			MethodName: "KillProcess",
			Handler:    _Merlin_KillProcess_Handler,
		},
		{
			MethodName: "LinkAgent",
			Handler:    _Merlin_LinkAgent_Handler,
		},
		{
			MethodName: "ListAssemblies",
			Handler:    _Merlin_ListAssemblies_Handler,
		},
		{
			MethodName: "Listener",
			Handler:    _Merlin_Listener_Handler,
		},
		{
			MethodName: "LoadAssembly",
			Handler:    _Merlin_LoadAssembly_Handler,
		},
		{
			MethodName: "LoadCLR",
			Handler:    _Merlin_LoadCLR_Handler,
		},
		{
			MethodName: "LS",
			Handler:    _Merlin_LS_Handler,
		},
		{
			MethodName: "MaxRetry",
			Handler:    _Merlin_MaxRetry_Handler,
		},
		{
			MethodName: "Memory",
			Handler:    _Merlin_Memory_Handler,
		},
		{
			MethodName: "MEMFD",
			Handler:    _Merlin_MEMFD_Handler,
		},
		{
			MethodName: "Netstat",
			Handler:    _Merlin_Netstat_Handler,
		},
		{
			MethodName: "Note",
			Handler:    _Merlin_Note_Handler,
		},
		{
			MethodName: "Nslookup",
			Handler:    _Merlin_Nslookup_Handler,
		},
		{
			MethodName: "Padding",
			Handler:    _Merlin_Padding_Handler,
		},
		{
			MethodName: "Parrot",
			Handler:    _Merlin_Parrot_Handler,
		},
		{
			MethodName: "Pipes",
			Handler:    _Merlin_Pipes_Handler,
		},
		{
			MethodName: "PS",
			Handler:    _Merlin_PS_Handler,
		},
		{
			MethodName: "PWD",
			Handler:    _Merlin_PWD_Handler,
		},
		{
			MethodName: "RM",
			Handler:    _Merlin_RM_Handler,
		},
		{
			MethodName: "RunAs",
			Handler:    _Merlin_RunAs_Handler,
		},
		{
			MethodName: "SecureDelete",
			Handler:    _Merlin_SecureDelete_Handler,
		},
		{
			MethodName: "SharpGen",
			Handler:    _Merlin_SharpGen_Handler,
		},
		{
			MethodName: "Skew",
			Handler:    _Merlin_Skew_Handler,
		},
		{
			MethodName: "Sleep",
			Handler:    _Merlin_Sleep_Handler,
		},
		{
			MethodName: "Socks",
			Handler:    _Merlin_Socks_Handler,
		},
		{
			MethodName: "SSH",
			Handler:    _Merlin_SSH_Handler,
		},
		{
			MethodName: "Token",
			Handler:    _Merlin_Token_Handler,
		},
		{
			MethodName: "Touch",
			Handler:    _Merlin_Touch_Handler,
		},
		{
			MethodName: "UnlinkAgent",
			Handler:    _Merlin_UnlinkAgent_Handler,
		},
		{
			MethodName: "Upload",
			Handler:    _Merlin_Upload_Handler,
		},
		{
			MethodName: "Uptime",
			Handler:    _Merlin_Uptime_Handler,
		},
		{
			MethodName: "Groups",
			Handler:    _Merlin_Groups_Handler,
		},
		{
			MethodName: "GroupAdd",
			Handler:    _Merlin_GroupAdd_Handler,
		},
		{
			MethodName: "GroupList",
			Handler:    _Merlin_GroupList_Handler,
		},
		{
			MethodName: "GroupListAll",
			Handler:    _Merlin_GroupListAll_Handler,
		},
		{
			MethodName: "GroupRemove",
			Handler:    _Merlin_GroupRemove_Handler,
		},
		{
			MethodName: "GetAgent",
			Handler:    _Merlin_GetAgent_Handler,
		},
		{
			MethodName: "GetAgents",
			Handler:    _Merlin_GetAgents_Handler,
		},
		{
			MethodName: "GetAgentLinks",
			Handler:    _Merlin_GetAgentLinks_Handler,
		},
		{
			MethodName: "GetAgentStatus",
			Handler:    _Merlin_GetAgentStatus_Handler,
		},
		{
			MethodName: "GetAgentRows",
			Handler:    _Merlin_GetAgentRows_Handler,
		},
		{
			MethodName: "Remove",
			Handler:    _Merlin_Remove_Handler,
		},
		{
			MethodName: "GetAllJobs",
			Handler:    _Merlin_GetAllJobs_Handler,
		},
		{
			MethodName: "GetAllActiveJobs",
			Handler:    _Merlin_GetAllActiveJobs_Handler,
		},
		{
			MethodName: "GetAgentJobs",
			Handler:    _Merlin_GetAgentJobs_Handler,
		},
		{
			MethodName: "GetAgentActiveJobs",
			Handler:    _Merlin_GetAgentActiveJobs_Handler,
		},
		{
			MethodName: "CreateListener",
			Handler:    _Merlin_CreateListener_Handler,
		},
		{
			MethodName: "GetListenerIDs",
			Handler:    _Merlin_GetListenerIDs_Handler,
		},
		{
			MethodName: "GetListeners",
			Handler:    _Merlin_GetListeners_Handler,
		},
		{
			MethodName: "GetListenerOptions",
			Handler:    _Merlin_GetListenerOptions_Handler,
		},
		{
			MethodName: "GetListenerDefaultOptions",
			Handler:    _Merlin_GetListenerDefaultOptions_Handler,
		},
		{
			MethodName: "GetListenerTypes",
			Handler:    _Merlin_GetListenerTypes_Handler,
		},
		{
			MethodName: "GetListenerStatus",
			Handler:    _Merlin_GetListenerStatus_Handler,
		},
		{
			MethodName: "RemoveListener",
			Handler:    _Merlin_RemoveListener_Handler,
		},
		{
			MethodName: "RestartListener",
			Handler:    _Merlin_RestartListener_Handler,
		},
		{
			MethodName: "SetListenerOption",
			Handler:    _Merlin_SetListenerOption_Handler,
		},
		{
			MethodName: "StartListener",
			Handler:    _Merlin_StartListener_Handler,
		},
		{
			MethodName: "StopListener",
			Handler:    _Merlin_StopListener_Handler,
		},
		{
			MethodName: "Servers",
			Handler:    _Merlin_Servers_Handler,
		},
		{
			MethodName: "GetModule",
			Handler:    _Merlin_GetModule_Handler,
		},
		{
			MethodName: "GetModuleList",
			Handler:    _Merlin_GetModuleList_Handler,
		},
		{
			MethodName: "RunModule",
			Handler:    _Merlin_RunModule_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Listen",
			Handler:       _Merlin_Listen_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "pkg/rpc/rpc.proto",
}
