/*                                                                                                            
 * Copyright (c) Members of the EGEE Collaboration. 2004.
 * See http://eu-egee.org/partners/ for details on the copyright holders.
 * For license conditions see the license file or
 * http://eu-egee.org/license.html
 */

/*
 *   Copyright (c) 2003 EU DataGrid        http://www.eu-datagrid.org/
 *
 *   $Id: pdl_lex.l 17546 2014-02-27 13:40:10Z msalle $
 *
 *   Copyright (c) 2003 by
 *      G.M. Venekamp <venekamp@nikhef.nl>
 *      NIKHEF Amsterdam, the Netherlands
 *
 *   This software is distributed under a BSD-style open source
 *   licence. For a complete description of the licence take a look
 *   at: http://eu-datagrid.web.cern.ch/eu-datagrid/license.html
 *
 */

/* Don't use yywrap functionality, this prevents missing symbols */
%option noyywrap

%{
#include <string.h>

#include "evaluationmanager/pdl_rule.h"
#include "evaluationmanager/pdl.h"
#include "evaluationmanager/pdl_yacc.h"
#include "evaluationmanager/pdl_policy.h"
#include "evaluationmanager/pdl_variable.h"

/* If we are running flex, we are creating our own prototype for the lexer
 * called pdl_yylex(). Flex will use that, bison will still call yylex() so we
 * create (for flex only) yylex as a wrapper around pdl_yylex(). This is all
 * needed to prevent warnings about  missing or redundant prototype. */
#ifdef FLEX_SCANNER
#ifndef YY_DECL
#define YY_DECL	static int pdl_yylex(void)
/* Declare prototype */
static int pdl_yylex(void);
/* Note: we don't need to declare a prototype for yylex() since we have that
 * already declared in pdl.h. flex will not declare it flex since we use
 * pdl_yylex() instead */
int yylex(void) {
    return pdl_yylex();
}
#endif
#endif

#ifndef _XOPEN_SOURCE
/* _XOPEN_SOURCE is defined by flex on supporting platforms, hence we are on a
 * non-supported one: The compiler might still have defined macros to get a
 * prototype for strdup and fileno. As long as they are not defined as macros,
 * the worst thing is a duplicate prototype. So check they aren't defined as
 * macro. */
#ifndef strdup
char *strdup(const char *s);
#endif /* strdup */
#ifndef fileno
int fileno(FILE *stream);
#endif /* fileno */
#endif /* _XOPEN_SOURCE */

/*static int no_valid_rule=0;*/

#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) \
    lcmaps_pdl_warning(PDL_ERROR, "Fatal parsing error: %s", (msg));
#endif
%}

ws           [\t ]+
nl           \n
term         [a-zA-Z_\.0-9/]+
label        ^[ \t]*[a-zA-Z_\.0-9/]+:
trans        "->"
comment      #[^\n]*\n
tokens       [\~=\|]
pvar         "path"
pdlstr       \"[^\"\n]*[\"\n]


%x path pathcom linecom mq
%%

{ws}         ;
{pvar}       { BEGIN path; return PVAR; }
<path>{tokens}  { return yytext[0]; }
<path>{ws}      ;
<path>{term}    { if ((yylval.record = (record_t*)malloc(sizeof(record_t))) == NULL ||
		      ((yylval.record)->string = strdup(yytext)) == NULL) {
                      lcmaps_pdl_warning(PDL_ERROR, "out of memory.");
                      return 0;
		  }
                  (yylval.record)->lineno = lineno;
                  return PATH;
                }
<path>\n        { ++lineno; BEGIN INITIAL; }
<path>{comment} { ++lineno; BEGIN INITIAL; }
{label}      { yytext[yyleng-1] = '\0';   /* remove trailing ':' */

               /*  Check if this policy rule is allowed or not. */
               if (lcmaps_allowed_policy_rule(yytext)) {
                 lcmaps_allow_rules(TRUE);
               } else {
                 /*  This label should not be added, however normal parsing
                  *  must continue.  */
                 lcmaps_allow_rules(FALSE);
               }
               if ((yylval.record = (record_t*)malloc(sizeof(record_t))) == NULL ||
		   ((yylval.record)->string = strdup(yytext)) == NULL) {
                   lcmaps_pdl_warning(PDL_ERROR, "out of memory.");
                   return 0; 
	       }
               (yylval.record)->lineno = lineno;
               return LABEL;
             }
{term}       { if ((yylval.record = (record_t*)malloc(sizeof(record_t))) == NULL ||
                   ((yylval.record)->string = strdup(yytext)) == NULL) {
                   lcmaps_pdl_warning(PDL_ERROR, "out of memory.");
                   return 0;
	       }
               (yylval.record)->lineno = lineno;
               return TERM;
             }
{nl}         { ++lineno;          }
{tokens}     { return yytext[0];  }
{trans}      { return TRANS;      }
{comment}    { ++lineno;	  }
{pdlstr}     { if ((yylval.record = (record_t*)malloc(sizeof(record_t))) == NULL) {
	           lcmaps_pdl_warning(PDL_ERROR, "out of memory.");
		   return 0;
	       }
               if (yytext[yyleng-2] == '\\') {
                   if (((yylval.record)->string = strdup(yytext+1)) == NULL) {
	               lcmaps_pdl_warning(PDL_ERROR, "out of memory.");
		       return 0;
	           }
		   (yylval.record)->string[yyleng-2] = '\0';
		   (yylval.record)->string[yyleng-3] = '\"';
		   (yylval.record)->lineno = lineno;
		   yyless(yyleng-1);  /*  make the next string start with "  */
		   BEGIN mq;
		   return STRING;
	       } else if (yytext[yyleng-1] == '\"') {
                   if (((yylval.record)->string = strdup(yytext+1)) == NULL) {
	               lcmaps_pdl_warning(PDL_ERROR, "out of memory.");
		       return 0;
	           }
		   (yylval.record)->string[yyleng-2] = '\0';
                   (yylval.record)->lineno = lineno;
	    	   return STRING;
               } else {
		   lcmaps_pdl_warning(PDL_ERROR, "Unbalanced quotes.");
                   return 0;
	       }
             }
<mq>{pdlstr} { if ((yylval.record = (record_t*)malloc(sizeof(record_t))) == NULL) {
		   lcmaps_pdl_warning(PDL_ERROR, "out of memory.");
                   return 0;
	       }
               if (yytext[yyleng-2] == '\\') {
                   if (((yylval.record)->string = strdup(yytext+1)) == NULL) {
		       lcmaps_pdl_warning(PDL_ERROR, "out of memory.");
                       return 0;
	           }
                   (yylval.record)->string[yyleng-2] = '\0';
                   (yylval.record)->string[yyleng-3] = '\"';
                   (yylval.record)->lineno = lineno;
                   yyless(yyleng-1);  /*  make the next string start with "  */
                   BEGIN INITIAL;
                   return STRING;
               } else {
                   lcmaps_pdl_warning(PDL_ERROR, "Unbalanced quotes.");
                   return 0;
               }
             }
.            { lcmaps_pdl_warning(PDL_WARNING, "unrecognized token '%c'.", yytext[0]);
               return yytext[0];
             }
%%

/**
 * Function to tidy up (most of) the memory, to be called after we're done with
 * parsing
 */
void pdl_lex_cleanup(void)	{
#ifdef FLEX_SCANNER
#if (YY_FLEX_MAJOR_VERSION>2) || \
    (YY_FLEX_MAJOR_VERSION==2 && YY_FLEX_MINOR_VERSION>5) || \
    (YY_FLEX_MAJOR_VERSION==2 && YY_FLEX_MINOR_VERSION==5 && \
     defined(YY_FLEX_SUBMINOR_VERSION) && YY_FLEX_SUBMINOR_VERSION>=9)
    yylex_destroy();
#else /* flex >= 2.5.9 */
    /* delete buffer */
    yy_delete_buffer(YY_CURRENT_BUFFER);
    /* make sure to put it to zero: note that on newer flex we should use
     * YY_CURRENT_BUFFER_LVALUE here instead of YY_CURRENT_BUFFER itself */
    YY_CURRENT_BUFFER=NULL;
    /* set init to 1 meaning we need to initialize */
    yy_init=1;
#endif /* flex >= 2.5.9 */
#endif /* FLEX_SCANNER */
}
