/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.JSqlException;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SoapUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final InjectionModel injectionModel;

    public SoapUtil(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public boolean testParameters(boolean hasFoundInjection) {
        if (hasFoundInjection) {
            return true;
        }
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "{} SOAP...", () -> I18nUtil.valueByKey("LOG_CHECKING"));
        if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isCheckingAllSoapParam() && this.injectionModel.getMediatorUtils().getParameterUtil().isRequestSoap()) {
            try {
                Document doc = SoapUtil.convertToDocument(this.injectionModel.getMediatorUtils().getParameterUtil().getRawRequest());
                LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Parsing SOAP from Request...");
                return this.isTextNodeInjectable(doc, doc.getDocumentElement());
            }
            catch (Exception e) {
                LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "SOAP not detected");
            }
        }
        return false;
    }

    public static Document convertToDocument(String xmlStr) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        factory.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        factory.setExpandEntityReferences(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(new StringReader(xmlStr)));
    }

    public boolean isTextNodeInjectable(Document doc, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node currentNode = nodeList.item(i);
            if (currentNode.getNodeType() == 1) {
                if (!this.isTextNodeInjectable(doc, currentNode)) continue;
                return true;
            }
            if (currentNode.getNodeType() != 3) continue;
            SoapUtil.removeInjectionPoint(doc, doc.getDocumentElement());
            currentNode.setTextContent(currentNode.getTextContent().replace("*", "") + "*");
            this.injectionModel.getMediatorUtils().getParameterUtil().initRequest(SoapUtil.convertDocumentToString(doc));
            try {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "{} SOAP {}={}", () -> I18nUtil.valueByKey("LOG_CHECKING"), () -> currentNode.getParentNode().getNodeName(), () -> currentNode.getTextContent().replace("*", ""));
                if (!this.injectionModel.getMediatorMethod().getRequest().testParameters()) continue;
                return true;
            }
            catch (JSqlException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, String.format("No SOAP Request injection for %s=%s", currentNode.getParentNode().getNodeName(), currentNode.getTextContent().replace("*", "")));
            }
        }
        return false;
    }

    public static void removeInjectionPoint(Document doc, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node currentNode = nodeList.item(i);
            if (currentNode.getNodeType() == 1) {
                SoapUtil.removeInjectionPoint(doc, currentNode);
                continue;
            }
            if (currentNode.getNodeType() != 3) continue;
            currentNode.setTextContent(currentNode.getTextContent().replaceAll(Pattern.quote("*") + "*$", ""));
        }
    }

    private static String convertDocumentToString(Document doc) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        String output = null;
        try {
            Transformer transformer = transformerFactory.newTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            output = writer.getBuffer().toString();
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return output;
    }
}

