/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.util;

import com.aspect.snoop.util.ClassFilter;
import com.aspect.snoop.util.DirFilter;
import com.aspect.snoop.util.IOUtil;
import com.aspect.snoop.util.JarFilter;
import com.aspect.snoop.util.ReflectionUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class ClasspathUtil {
    public static byte[] getClassBytes(String clazz, String classpath, boolean useSystemClasspath) {
        String completeClasspath = "";
        if (useSystemClasspath) {
            completeClasspath = completeClasspath + ClasspathUtil.getSystemClasspath();
        }
        completeClasspath = completeClasspath + classpath;
        String simpleClassName = ReflectionUtil.getSimpleClassName(clazz);
        StringTokenizer st = new StringTokenizer(completeClasspath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            File classpathElement = new File(token);
            if (classpathElement.isDirectory()) {
                String[] jarFiles;
                String[] classFiles;
                for (String file : classFiles = classpathElement.list(new ClassFilter())) {
                    if (!file.equals(simpleClassName + ".class")) continue;
                    File targetFile = new File(classpathElement.getAbsolutePath() + File.separatorChar + file);
                    try {
                        return IOUtil.getBytesFromFile(targetFile);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                for (String file : jarFiles = classpathElement.list(new JarFilter())) {
                    byte[] classBytes = null;
                    try {
                        File jarFile = new File(classpathElement.getAbsolutePath() + File.separator + file);
                        classBytes = ClasspathUtil.findClassInJar(clazz, jarFile);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    if (classBytes == null) continue;
                    return classBytes;
                }
                continue;
            }
            byte[] classBytes = null;
            try {
                classBytes = ClasspathUtil.findClassInJar(clazz, classpathElement);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (classBytes == null) continue;
            return classBytes;
        }
        return null;
    }

    public static String getSystemClasspath() {
        String javaHome;
        String classpath = System.getProperty("java.class.path", ".");
        if (classpath.equals("")) {
            System.err.println("error: classpath is not set");
        }
        if (!"".equals(classpath)) {
            classpath = classpath + ";";
        }
        if (!"".equals(javaHome = System.getProperty("java.home"))) {
            javaHome = javaHome + File.separator + "lib";
            classpath = classpath + javaHome;
            classpath = classpath + ";";
        }
        return classpath;
    }

    public static List<String> getClasses(String appClasspath) {
        return ClasspathUtil.getClasses(appClasspath, true);
    }

    public static List<String> getClasses(String appClasspath, boolean useSystemClasspath) {
        ArrayList classes = new ArrayList();
        try {
            String classpath = "";
            if (useSystemClasspath) {
                classpath = ClasspathUtil.getSystemClasspath();
            }
            classpath = classpath + appClasspath;
            StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                File classpathElement = new File(token);
                if (classpathElement.isDirectory()) {
                    classes.addAll(ClasspathUtil.recursiveFindClasses(classpathElement.getAbsolutePath(), ""));
                    continue;
                }
                if (classpathElement.getName().endsWith(".jar")) {
                    classes.addAll(ClasspathUtil.loadClassesFromJar(classpathElement));
                    continue;
                }
                if (!classpathElement.getName().endsWith(".class")) continue;
                String clz = classpathElement.getName();
                clz = clz.substring(0, clz.length() - 6);
                classes.add(clz);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        classes = ClasspathUtil.removeDuplicates(classes);
        return classes;
    }

    private static byte[] findClassInJar(String clazz, File jarFile) throws IOException {
        if (!jarFile.getName().endsWith(".jar")) {
            return null;
        }
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> classes = jar.entries();
        while (classes.hasMoreElements()) {
            JarEntry entry = classes.nextElement();
            String completeClass = entry.getName().replace("/", ".");
            if (!completeClass.equals(clazz + ".class")) continue;
            return IOUtil.getBytesFromStream(jar.getInputStream(entry));
        }
        return null;
    }

    private static List<String> loadClassesFromJar(File jarFile) {
        ArrayList<String> files = new ArrayList<String>();
        try {
            Enumeration<JarEntry> fileNames = new JarFile(jarFile).entries();
            JarEntry entry = null;
            while (fileNames.hasMoreElements()) {
                entry = fileNames.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                String converted = entry.getName().replace("/", ".");
                converted = converted.substring(0, converted.length() - 6);
                files.add(converted);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LinkedHashSet noDupes = new LinkedHashSet(files);
        files.clear();
        files.addAll(noDupes);
        return files;
    }

    public static Class[] getAllSubtypes(Class c) {
        return new Class[]{c};
    }

    private static List recursiveFindClasses(String root, String dir) {
        ArrayList<String> classes = new ArrayList<String>();
        File currentDir = dir.length() > 0 ? new File(dir) : new File(root);
        File[] classFiles = currentDir.listFiles(new ClassFilter());
        File[] jarFiles = currentDir.listFiles(new JarFilter());
        File[] subDirectories = currentDir.listFiles(new DirFilter());
        String pkg = "";
        if (dir.length() > 0) {
            pkg = dir.substring(root.length() + 1);
        }
        for (File classFile : classFiles) {
            String s = pkg + "." + classFile.getName();
            s = s.substring(0, s.length() - 6);
            s = s.replace(File.separator, ".");
            classes.add(s);
        }
        for (File jarFile : jarFiles) {
            classes.addAll(ClasspathUtil.loadClassesFromJar(jarFile));
        }
        for (File subDir : subDirectories) {
            classes.addAll(ClasspathUtil.recursiveFindClasses(root, subDir.getAbsolutePath()));
        }
        return classes;
    }

    public static Class[] asClasses(String[] types) throws ClassNotFoundException {
        Class[] classes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            if ("boolean".equals(types[i])) {
                types[i] = "java.lang.Boolean";
            } else if ("byte".equals(types[i])) {
                types[i] = "java.lang.Byte";
            } else if ("short".equals(types[i])) {
                types[i] = "java.lang.Short";
            } else if ("char".equals(types[i])) {
                types[i] = "java.lang.Character";
            } else if ("long".equals(types[i])) {
                types[i] = "java.lang.Long";
            } else if ("double".equals(types[i])) {
                types[i] = "java.lang.Double";
            } else if ("float".equals(types[i])) {
                types[i] = "java.lang.Float";
            }
            classes[i] = Class.forName(types[i]);
        }
        return classes;
    }

    public static String[] asStrings(Class[] types) throws ClassNotFoundException {
        String[] classes = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            classes[i] = types[i].getName();
        }
        return classes;
    }

    public static String getManifestSystemClasspathString() {
        return ClasspathUtil.getManifestClasspathString(System.getProperty("java.class.path"));
    }

    public static String getManifestClasspathString(String cp) {
        String classpath = new String(cp);
        classpath = classpath.replaceAll(" ", "%20");
        StringBuffer sb = new StringBuffer();
        int firstLineLength = 72 - ("Class-Path: ".length() + 1);
        String s = classpath.substring(0, firstLineLength);
        sb.append(s + " \r\n");
        int index = firstLineLength;
        while (index < classpath.length()) {
            int toBeCopied = 70;
            if (classpath.length() - index < 70) {
                toBeCopied = classpath.length() - index;
            }
            sb.append(" ");
            sb.append(classpath.substring(index, index + toBeCopied));
            index += toBeCopied;
            if (toBeCopied == 70) {
                sb.append(" ");
            }
            sb.append("\r\n");
        }
        return sb.toString();
    }

    private static ArrayList removeDuplicates(List<String> classes) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.addAll(classes);
        return new ArrayList(set);
    }

    public static boolean isJavaOrSunClass(String cls) {
        String[] pkgs;
        for (String pkg : pkgs = new String[]{"java.", "javax.", "sun.", "sunw.", "netscape.", "apple.", "com.apple.", "com.sun."}) {
            if (!cls.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJavaSnoopClass(String cls) {
        String[] pkgs;
        for (String pkg : pkgs = new String[]{"com.aspect.snoop", "org.fife", "org.apache.log4j", "org.codehaus", "org.xmlpull", "org.relaxng", "org.jaxen", "org.jcp", "org.joda", "com.aspect.org.jdesktop", "org.jdom", "org.ietf", "org.omg", "org.dom4j", "org.xml.sax", "org.w3c.dom", "org.codehaus.jettison", "net.sf.cglib", "com.wutka", "com.thoughtworks.xstream", "com.megginson", "com.ctc.wstx", "com.bea.xml.stream", "JDOMAbout", "javassist.", "net.sf.cgilib", "nu.xom", "org.python"}) {
            if (!cls.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    public static String getMainClassFromJarFile(String path) throws IOException {
        if (!new File(path).exists()) {
            return "(unknown)";
        }
        JarFile jar = new JarFile(path);
        Manifest manifest = jar.getManifest();
        Attributes attrs = manifest.getMainAttributes();
        return attrs.getValue(Attributes.Name.MAIN_CLASS);
    }
}

