/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.choose.process;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class ClassesTreeModel
extends DefaultTreeModel {
    private static Comparator alphabeticComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.toLowerCase().compareTo(s2.toLowerCase());
        }
    };
    List<String> classes;

    public ClassesTreeModel(TreeNode root) {
        super(root);
    }

    public void setClasses(List<String> classes) {
        this.classes = classes;
    }

    @Override
    public void reload() {
        for (int i = 0; i < this.classes.size(); ++i) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.root;
            StringTokenizer st = new StringTokenizer(this.classes.get(i), ".");
            while (st.hasMoreTokens()) {
                String value = st.nextToken();
                boolean lastToken = !st.hasMoreTokens();
                boolean exist = false;
                boolean duplicate = false;
                Enumeration<TreeNode> e = parent.children();
                while (e.hasMoreElements()) {
                    DefaultMutableTreeNode dtm = (DefaultMutableTreeNode)e.nextElement();
                    String dtmName = dtm.toString();
                    if (dtmName == null || !dtmName.equals(value)) continue;
                    if (!lastToken) {
                        exist = true;
                        parent = dtm;
                        break;
                    }
                    duplicate = true;
                    break;
                }
                if (exist) continue;
                int index = 0;
                boolean found = false;
                e = parent.children();
                while (e.hasMoreElements()) {
                    DefaultMutableTreeNode dtm = (DefaultMutableTreeNode)e.nextElement();
                    String dtmName = dtm.toString();
                    if (dtmName != null) {
                        if (dtm.isLeaf() && !lastToken) {
                            index = parent.getIndex(dtm);
                            found = true;
                            break;
                        }
                        if (!dtm.isLeaf() && lastToken) continue;
                        if (alphabeticComparator.compare(dtmName, value) >= 0) {
                            index = parent.getIndex(dtm);
                            found = true;
                            break;
                        }
                    }
                    ++index;
                }
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(value);
                if (!found) {
                    parent.add(child);
                } else {
                    if (duplicate) {
                        ++index;
                    }
                    parent.insert(child, index);
                }
                parent = child;
            }
        }
    }
}

