# OpenAPI v3 Protocol Buffer Models

This directory contains a Protocol Buffer-language model
and related code for supporting OpenAPI v3.

Gnostic applications and plugins can use OpenAPIv3.proto
to generate Protocol Buffer support code for their preferred
languages.

OpenAPIv3.go is used by Gnostic to read JSON and YAML OpenAPI 
descriptions into the Protocol Buffer-based datastructures 
generated from OpenAPIv3.proto.

OpenAPIv3.proto and OpenAPIv3.go are generated by the Gnostic 
compiler generator, and OpenAPIv3.pb.go is generated by 
protoc, the Protocol Buffer compiler, and protoc-gen-go, the
Protocol Buffer Go code generation plugin.

openapi-3.0.json is a preliminary draft JSON schema for OpenAPI 3.0.
It is not the official OpenAPI 3.0 JSON Schema, which at the time 
of this commit, does not exist.

The schema-generator directory contains support code which 
generates openapi-3.0.json from a draft of the OpenAPI 3.0 
specification document (Markdown).
