// Code generated by smithy-go-codegen DO NOT EDIT.

package kafkaconnect

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/kafkaconnect/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCreateConnector struct {
}

func (*validateOpCreateConnector) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateConnector) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateConnectorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateConnectorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateCustomPlugin struct {
}

func (*validateOpCreateCustomPlugin) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateCustomPlugin) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateCustomPluginInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateCustomPluginInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateWorkerConfiguration struct {
}

func (*validateOpCreateWorkerConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateWorkerConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateWorkerConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateWorkerConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteConnector struct {
}

func (*validateOpDeleteConnector) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteConnector) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteConnectorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteConnectorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteCustomPlugin struct {
}

func (*validateOpDeleteCustomPlugin) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteCustomPlugin) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteCustomPluginInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteCustomPluginInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteWorkerConfiguration struct {
}

func (*validateOpDeleteWorkerConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteWorkerConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteWorkerConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteWorkerConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeConnector struct {
}

func (*validateOpDescribeConnector) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeConnector) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeConnectorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeConnectorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeCustomPlugin struct {
}

func (*validateOpDescribeCustomPlugin) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeCustomPlugin) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeCustomPluginInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeCustomPluginInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeWorkerConfiguration struct {
}

func (*validateOpDescribeWorkerConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeWorkerConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeWorkerConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeWorkerConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateConnector struct {
}

func (*validateOpUpdateConnector) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateConnector) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateConnectorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateConnectorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCreateConnectorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateConnector{}, middleware.After)
}

func addOpCreateCustomPluginValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateCustomPlugin{}, middleware.After)
}

func addOpCreateWorkerConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateWorkerConfiguration{}, middleware.After)
}

func addOpDeleteConnectorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteConnector{}, middleware.After)
}

func addOpDeleteCustomPluginValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteCustomPlugin{}, middleware.After)
}

func addOpDeleteWorkerConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteWorkerConfiguration{}, middleware.After)
}

func addOpDescribeConnectorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeConnector{}, middleware.After)
}

func addOpDescribeCustomPluginValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeCustomPlugin{}, middleware.After)
}

func addOpDescribeWorkerConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeWorkerConfiguration{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateConnectorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateConnector{}, middleware.After)
}

func validate__listOfPlugin(v []types.Plugin) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListOfPlugin"}
	for i := range v {
		if err := validatePlugin(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateApacheKafkaCluster(v *types.ApacheKafkaCluster) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ApacheKafkaCluster"}
	if v.BootstrapServers == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BootstrapServers"))
	}
	if v.Vpc == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Vpc"))
	} else if v.Vpc != nil {
		if err := validateVpc(v.Vpc); err != nil {
			invalidParams.AddNested("Vpc", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAutoScaling(v *types.AutoScaling) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AutoScaling"}
	if v.ScaleInPolicy != nil {
		if err := validateScaleInPolicy(v.ScaleInPolicy); err != nil {
			invalidParams.AddNested("ScaleInPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if v.ScaleOutPolicy != nil {
		if err := validateScaleOutPolicy(v.ScaleOutPolicy); err != nil {
			invalidParams.AddNested("ScaleOutPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAutoScalingUpdate(v *types.AutoScalingUpdate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AutoScalingUpdate"}
	if v.ScaleInPolicy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ScaleInPolicy"))
	} else if v.ScaleInPolicy != nil {
		if err := validateScaleInPolicyUpdate(v.ScaleInPolicy); err != nil {
			invalidParams.AddNested("ScaleInPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if v.ScaleOutPolicy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ScaleOutPolicy"))
	} else if v.ScaleOutPolicy != nil {
		if err := validateScaleOutPolicyUpdate(v.ScaleOutPolicy); err != nil {
			invalidParams.AddNested("ScaleOutPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCapacity(v *types.Capacity) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Capacity"}
	if v.AutoScaling != nil {
		if err := validateAutoScaling(v.AutoScaling); err != nil {
			invalidParams.AddNested("AutoScaling", err.(smithy.InvalidParamsError))
		}
	}
	if v.ProvisionedCapacity != nil {
		if err := validateProvisionedCapacity(v.ProvisionedCapacity); err != nil {
			invalidParams.AddNested("ProvisionedCapacity", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCapacityUpdate(v *types.CapacityUpdate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CapacityUpdate"}
	if v.AutoScaling != nil {
		if err := validateAutoScalingUpdate(v.AutoScaling); err != nil {
			invalidParams.AddNested("AutoScaling", err.(smithy.InvalidParamsError))
		}
	}
	if v.ProvisionedCapacity != nil {
		if err := validateProvisionedCapacityUpdate(v.ProvisionedCapacity); err != nil {
			invalidParams.AddNested("ProvisionedCapacity", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCloudWatchLogsLogDelivery(v *types.CloudWatchLogsLogDelivery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CloudWatchLogsLogDelivery"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCustomPlugin(v *types.CustomPlugin) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CustomPlugin"}
	if v.CustomPluginArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CustomPluginArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCustomPluginLocation(v *types.CustomPluginLocation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CustomPluginLocation"}
	if v.S3Location == nil {
		invalidParams.Add(smithy.NewErrParamRequired("S3Location"))
	} else if v.S3Location != nil {
		if err := validateS3Location(v.S3Location); err != nil {
			invalidParams.AddNested("S3Location", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFirehoseLogDelivery(v *types.FirehoseLogDelivery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FirehoseLogDelivery"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKafkaCluster(v *types.KafkaCluster) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KafkaCluster"}
	if v.ApacheKafkaCluster == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApacheKafkaCluster"))
	} else if v.ApacheKafkaCluster != nil {
		if err := validateApacheKafkaCluster(v.ApacheKafkaCluster); err != nil {
			invalidParams.AddNested("ApacheKafkaCluster", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKafkaClusterClientAuthentication(v *types.KafkaClusterClientAuthentication) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KafkaClusterClientAuthentication"}
	if len(v.AuthenticationType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("AuthenticationType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKafkaClusterEncryptionInTransit(v *types.KafkaClusterEncryptionInTransit) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KafkaClusterEncryptionInTransit"}
	if len(v.EncryptionType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("EncryptionType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLogDelivery(v *types.LogDelivery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LogDelivery"}
	if v.WorkerLogDelivery == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkerLogDelivery"))
	} else if v.WorkerLogDelivery != nil {
		if err := validateWorkerLogDelivery(v.WorkerLogDelivery); err != nil {
			invalidParams.AddNested("WorkerLogDelivery", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePlugin(v *types.Plugin) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Plugin"}
	if v.CustomPlugin == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CustomPlugin"))
	} else if v.CustomPlugin != nil {
		if err := validateCustomPlugin(v.CustomPlugin); err != nil {
			invalidParams.AddNested("CustomPlugin", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateProvisionedCapacity(v *types.ProvisionedCapacity) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ProvisionedCapacity"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateProvisionedCapacityUpdate(v *types.ProvisionedCapacityUpdate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ProvisionedCapacityUpdate"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3Location(v *types.S3Location) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3Location"}
	if v.BucketArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BucketArn"))
	}
	if v.FileKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileKey"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3LogDelivery(v *types.S3LogDelivery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3LogDelivery"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateScaleInPolicy(v *types.ScaleInPolicy) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ScaleInPolicy"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateScaleInPolicyUpdate(v *types.ScaleInPolicyUpdate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ScaleInPolicyUpdate"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateScaleOutPolicy(v *types.ScaleOutPolicy) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ScaleOutPolicy"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateScaleOutPolicyUpdate(v *types.ScaleOutPolicyUpdate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ScaleOutPolicyUpdate"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVpc(v *types.Vpc) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Vpc"}
	if v.Subnets == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Subnets"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWorkerConfiguration(v *types.WorkerConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WorkerConfiguration"}
	if v.WorkerConfigurationArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkerConfigurationArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWorkerLogDelivery(v *types.WorkerLogDelivery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WorkerLogDelivery"}
	if v.CloudWatchLogs != nil {
		if err := validateCloudWatchLogsLogDelivery(v.CloudWatchLogs); err != nil {
			invalidParams.AddNested("CloudWatchLogs", err.(smithy.InvalidParamsError))
		}
	}
	if v.Firehose != nil {
		if err := validateFirehoseLogDelivery(v.Firehose); err != nil {
			invalidParams.AddNested("Firehose", err.(smithy.InvalidParamsError))
		}
	}
	if v.S3 != nil {
		if err := validateS3LogDelivery(v.S3); err != nil {
			invalidParams.AddNested("S3", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateConnectorInput(v *CreateConnectorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateConnectorInput"}
	if v.Capacity == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Capacity"))
	} else if v.Capacity != nil {
		if err := validateCapacity(v.Capacity); err != nil {
			invalidParams.AddNested("Capacity", err.(smithy.InvalidParamsError))
		}
	}
	if v.ConnectorConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectorConfiguration"))
	}
	if v.ConnectorName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectorName"))
	}
	if v.KafkaCluster == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KafkaCluster"))
	} else if v.KafkaCluster != nil {
		if err := validateKafkaCluster(v.KafkaCluster); err != nil {
			invalidParams.AddNested("KafkaCluster", err.(smithy.InvalidParamsError))
		}
	}
	if v.KafkaClusterClientAuthentication == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KafkaClusterClientAuthentication"))
	} else if v.KafkaClusterClientAuthentication != nil {
		if err := validateKafkaClusterClientAuthentication(v.KafkaClusterClientAuthentication); err != nil {
			invalidParams.AddNested("KafkaClusterClientAuthentication", err.(smithy.InvalidParamsError))
		}
	}
	if v.KafkaClusterEncryptionInTransit == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KafkaClusterEncryptionInTransit"))
	} else if v.KafkaClusterEncryptionInTransit != nil {
		if err := validateKafkaClusterEncryptionInTransit(v.KafkaClusterEncryptionInTransit); err != nil {
			invalidParams.AddNested("KafkaClusterEncryptionInTransit", err.(smithy.InvalidParamsError))
		}
	}
	if v.KafkaConnectVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KafkaConnectVersion"))
	}
	if v.LogDelivery != nil {
		if err := validateLogDelivery(v.LogDelivery); err != nil {
			invalidParams.AddNested("LogDelivery", err.(smithy.InvalidParamsError))
		}
	}
	if v.Plugins == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Plugins"))
	} else if v.Plugins != nil {
		if err := validate__listOfPlugin(v.Plugins); err != nil {
			invalidParams.AddNested("Plugins", err.(smithy.InvalidParamsError))
		}
	}
	if v.ServiceExecutionRoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceExecutionRoleArn"))
	}
	if v.WorkerConfiguration != nil {
		if err := validateWorkerConfiguration(v.WorkerConfiguration); err != nil {
			invalidParams.AddNested("WorkerConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateCustomPluginInput(v *CreateCustomPluginInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateCustomPluginInput"}
	if len(v.ContentType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ContentType"))
	}
	if v.Location == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Location"))
	} else if v.Location != nil {
		if err := validateCustomPluginLocation(v.Location); err != nil {
			invalidParams.AddNested("Location", err.(smithy.InvalidParamsError))
		}
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateWorkerConfigurationInput(v *CreateWorkerConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateWorkerConfigurationInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.PropertiesFileContent == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PropertiesFileContent"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteConnectorInput(v *DeleteConnectorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteConnectorInput"}
	if v.ConnectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectorArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteCustomPluginInput(v *DeleteCustomPluginInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteCustomPluginInput"}
	if v.CustomPluginArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CustomPluginArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteWorkerConfigurationInput(v *DeleteWorkerConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteWorkerConfigurationInput"}
	if v.WorkerConfigurationArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkerConfigurationArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeConnectorInput(v *DescribeConnectorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeConnectorInput"}
	if v.ConnectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectorArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeCustomPluginInput(v *DescribeCustomPluginInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeCustomPluginInput"}
	if v.CustomPluginArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CustomPluginArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeWorkerConfigurationInput(v *DescribeWorkerConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeWorkerConfigurationInput"}
	if v.WorkerConfigurationArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkerConfigurationArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateConnectorInput(v *UpdateConnectorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateConnectorInput"}
	if v.Capacity == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Capacity"))
	} else if v.Capacity != nil {
		if err := validateCapacityUpdate(v.Capacity); err != nil {
			invalidParams.AddNested("Capacity", err.(smithy.InvalidParamsError))
		}
	}
	if v.ConnectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectorArn"))
	}
	if v.CurrentVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CurrentVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
