// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Enables or modifies the block public access for snapshots setting at the
// account level for the specified Amazon Web Services Region. After you enable
// block public access for snapshots in a Region, users can no longer request
// public sharing for snapshots in that Region. Snapshots that are already publicly
// shared are either treated as private or they remain publicly shared, depending
// on the State that you specify.
//
// If block public access is enabled in block-all-sharing mode, and you change the
// mode to block-new-sharing , all snapshots that were previously publicly shared
// are no longer treated as private and they become publicly accessible again.
//
// For more information, see [Block public access for snapshots] in the Amazon EBS User Guide.
//
// [Block public access for snapshots]: https://docs.aws.amazon.com/ebs/latest/userguide/block-public-access-snapshots.html
func (c *Client) EnableSnapshotBlockPublicAccess(ctx context.Context, params *EnableSnapshotBlockPublicAccessInput, optFns ...func(*Options)) (*EnableSnapshotBlockPublicAccessOutput, error) {
	if params == nil {
		params = &EnableSnapshotBlockPublicAccessInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "EnableSnapshotBlockPublicAccess", params, optFns, c.addOperationEnableSnapshotBlockPublicAccessMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*EnableSnapshotBlockPublicAccessOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type EnableSnapshotBlockPublicAccessInput struct {

	// The mode in which to enable block public access for snapshots for the Region.
	// Specify one of the following values:
	//
	//   - block-all-sharing - Prevents all public sharing of snapshots in the Region.
	//   Users in the account will no longer be able to request new public sharing.
	//   Additionally, snapshots that are already publicly shared are treated as private
	//   and they are no longer publicly available.
	//
	// If you enable block public access for snapshots in block-all-sharing mode, it
	//   does not change the permissions for snapshots that are already publicly shared.
	//   Instead, it prevents these snapshots from be publicly visible and publicly
	//   accessible. Therefore, the attributes for these snapshots still indicate that
	//   they are publicly shared, even though they are not publicly available.
	//
	//   - block-new-sharing - Prevents only new public sharing of snapshots in the
	//   Region. Users in the account will no longer be able to request new public
	//   sharing. However, snapshots that are already publicly shared, remain publicly
	//   available.
	//
	// unblocked is not a valid value for EnableSnapshotBlockPublicAccess.
	//
	// This member is required.
	State types.SnapshotBlockPublicAccessState

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	noSmithyDocumentSerde
}

type EnableSnapshotBlockPublicAccessOutput struct {

	// The state of block public access for snapshots for the account and Region.
	// Returns either block-all-sharing or block-new-sharing if the request succeeds.
	State types.SnapshotBlockPublicAccessState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationEnableSnapshotBlockPublicAccessMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpEnableSnapshotBlockPublicAccess{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpEnableSnapshotBlockPublicAccess{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "EnableSnapshotBlockPublicAccess"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpEnableSnapshotBlockPublicAccessValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opEnableSnapshotBlockPublicAccess(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opEnableSnapshotBlockPublicAccess(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "EnableSnapshotBlockPublicAccess",
	}
}
