// Code generated by smithy-go-codegen DO NOT EDIT.

package appflow

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/appflow/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Resets metadata about your connector entities that Amazon AppFlow stored in its
// cache. Use this action when you want Amazon AppFlow to return the latest
// information about the data that you have in a source application.
//
// Amazon AppFlow returns metadata about your entities when you use the
// ListConnectorEntities or DescribeConnectorEntities actions. Following these
// actions, Amazon AppFlow caches the metadata to reduce the number of API requests
// that it must send to the source application. Amazon AppFlow automatically resets
// the cache once every hour, but you can use this action when you want to get the
// latest metadata right away.
func (c *Client) ResetConnectorMetadataCache(ctx context.Context, params *ResetConnectorMetadataCacheInput, optFns ...func(*Options)) (*ResetConnectorMetadataCacheOutput, error) {
	if params == nil {
		params = &ResetConnectorMetadataCacheInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ResetConnectorMetadataCache", params, optFns, c.addOperationResetConnectorMetadataCacheMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ResetConnectorMetadataCacheOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ResetConnectorMetadataCacheInput struct {

	// The API version that you specified in the connector profile that you’re
	// resetting cached metadata for. You must use this parameter only if the connector
	// supports multiple API versions or if the connector type is CustomConnector.
	//
	// To look up how many versions a connector supports, use the DescribeConnectors
	// action. In the response, find the value that Amazon AppFlow returns for the
	// connectorVersion parameter.
	//
	// To look up the connector type, use the DescribeConnectorProfiles action. In the
	// response, find the value that Amazon AppFlow returns for the connectorType
	// parameter.
	//
	// To look up the API version that you specified in a connector profile, use the
	// DescribeConnectorProfiles action.
	ApiVersion *string

	// Use this parameter if you want to reset cached metadata about the details for
	// an individual entity.
	//
	// If you don't include this parameter in your request, Amazon AppFlow only resets
	// cached metadata about entity names, not entity details.
	ConnectorEntityName *string

	// The name of the connector profile that you want to reset cached metadata for.
	//
	// You can omit this parameter if you're resetting the cache for any of the
	// following connectors: Amazon Connect, Amazon EventBridge, Amazon Lookout for
	// Metrics, Amazon S3, or Upsolver. If you're resetting the cache for any other
	// connector, you must include this parameter in your request.
	ConnectorProfileName *string

	// The type of connector to reset cached metadata for.
	//
	// You must include this parameter in your request if you're resetting the cache
	// for any of the following connectors: Amazon Connect, Amazon EventBridge, Amazon
	// Lookout for Metrics, Amazon S3, or Upsolver. If you're resetting the cache for
	// any other connector, you can omit this parameter from your request.
	ConnectorType types.ConnectorType

	// Use this parameter only if you’re resetting the cached metadata about a nested
	// entity. Only some connectors support nested entities. A nested entity is one
	// that has another entity as a parent. To use this parameter, specify the name of
	// the parent entity.
	//
	// To look up the parent-child relationship of entities, you can send a
	// ListConnectorEntities request that omits the entitiesPath parameter. Amazon
	// AppFlow will return a list of top-level entities. For each one, it indicates
	// whether the entity has nested entities. Then, in a subsequent
	// ListConnectorEntities request, you can specify a parent entity name for the
	// entitiesPath parameter. Amazon AppFlow will return a list of the child entities
	// for that parent.
	EntitiesPath *string

	noSmithyDocumentSerde
}

type ResetConnectorMetadataCacheOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationResetConnectorMetadataCacheMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpResetConnectorMetadataCache{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpResetConnectorMetadataCache{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ResetConnectorMetadataCache"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opResetConnectorMetadataCache(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opResetConnectorMetadataCache(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ResetConnectorMetadataCache",
	}
}
