//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple1200series

import "time"

// AccessControlRecord - The access control record
type AccessControlRecord struct {
	// REQUIRED; Properties of AccessControlRecord
	Properties *AccessControlRecordProperties `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccessControlRecordList - Collection of AccessControlRecords
type AccessControlRecordList struct {
	// REQUIRED; The value.
	Value []*AccessControlRecord `json:"value,omitempty"`
}

// AccessControlRecordProperties - Properties of access control record
type AccessControlRecordProperties struct {
	// REQUIRED; The Iscsi initiator name (IQN)
	InitiatorName *string `json:"initiatorName,omitempty"`
}

// AccessControlRecordsClientBeginCreateOrUpdateOptions contains the optional parameters for the AccessControlRecordsClient.BeginCreateOrUpdate
// method.
type AccessControlRecordsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccessControlRecordsClientBeginDeleteOptions contains the optional parameters for the AccessControlRecordsClient.BeginDelete
// method.
type AccessControlRecordsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccessControlRecordsClientGetOptions contains the optional parameters for the AccessControlRecordsClient.Get method.
type AccessControlRecordsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AccessControlRecordsClientListByManagerOptions contains the optional parameters for the AccessControlRecordsClient.ListByManager
// method.
type AccessControlRecordsClientListByManagerOptions struct {
	// placeholder for future optional parameters
}

// Alert class
type Alert struct {
	// REQUIRED; Properties of alert
	Properties *AlertProperties `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AlertErrorDetails - Error details for the alert
type AlertErrorDetails struct {
	// Error code.
	ErrorCode *string `json:"errorCode,omitempty"`

	// Error Message
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// Number of occurrences.
	Occurences *int32 `json:"occurences,omitempty"`
}

// AlertFilter - Filters that can be specified on the alert
type AlertFilter struct {
	// UTC time on which the alert appeared
	AppearedOnTime *time.Time `json:"appearedOnTime,omitempty"`

	// Severity of the alert
	Severity *AlertSeverity `json:"severity,omitempty"`

	// Source name of the alert
	SourceName *string `json:"sourceName,omitempty"`

	// Source of the alert
	SourceType *AlertSourceType `json:"sourceType,omitempty"`

	// Status of the alert
	Status *AlertStatus `json:"status,omitempty"`
}

// AlertList - Collection of Alerts
type AlertList struct {
	// REQUIRED; The value.
	Value []*Alert `json:"value,omitempty"`

	// Id of the next page of alerts
	NextLink *string `json:"nextLink,omitempty"`
}

// AlertProperties - Properties of alert
type AlertProperties struct {
	// REQUIRED; Type of the alert
	AlertType *string `json:"alertType,omitempty"`

	// REQUIRED; UTC time at which the alert appeared on the source
	AppearedAtSourceTime *time.Time `json:"appearedAtSourceTime,omitempty"`

	// REQUIRED; UTC time at which the alert appeared
	AppearedAtTime *time.Time `json:"appearedAtTime,omitempty"`

	// REQUIRED; Device or Resource alert
	Scope *AlertScope `json:"scope,omitempty"`

	// REQUIRED; Severity of the alert
	Severity *AlertSeverity `json:"severity,omitempty"`

	// REQUIRED; Source at which the alert was cleared
	Source *AlertSource `json:"source,omitempty"`

	// REQUIRED; Current status of the alert
	Status *AlertStatus `json:"status,omitempty"`

	// REQUIRED; Title of the alert
	Title *string `json:"title,omitempty"`

	// UTC time at which the alert was cleared on the source
	ClearedAtSourceTime *time.Time `json:"clearedAtSourceTime,omitempty"`

	// UTC time at which the alert got cleared
	ClearedAtTime *time.Time `json:"clearedAtTime,omitempty"`

	// Other information about the alert
	DetailedInformation map[string]*string `json:"detailedInformation,omitempty"`

	// ErrorDetails of the alert
	ErrorDetails *AlertErrorDetails `json:"errorDetails,omitempty"`

	// Recommendation for acting on the alert
	Recommendation *string `json:"recommendation,omitempty"`

	// Reason for resolving the alert
	ResolutionReason *string `json:"resolutionReason,omitempty"`
}

// AlertSettings on the device which represents how alerts will be processed
type AlertSettings struct {
	// REQUIRED; Properties of AlertSettings
	Properties *AlertSettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AlertSettingsProperties - Class containing the properties of AlertSettings
type AlertSettingsProperties struct {
	// REQUIRED; Culture setting to be used while building alert emails. For eg: "en-US"
	AlertNotificationCulture *string `json:"alertNotificationCulture,omitempty"`

	// REQUIRED; Value indicating whether user/admins will receive emails when an alert condition occurs on the system
	EmailNotification *AlertEmailNotificationStatus `json:"emailNotification,omitempty"`

	// REQUIRED; Value indicating whether service owners will receive emails when an alert condition occurs on the system. Applicable
	// only if emailNotification flag is Enabled.
	NotificationToServiceOwners *ServiceOwnersAlertNotificationStatus `json:"notificationToServiceOwners,omitempty"`

	// List of email addresses (apart from admin/co-admin of subscription) to whom the alert emails need to be sent
	AdditionalRecipientEmailList []*string `json:"additionalRecipientEmailList,omitempty"`
}

// AlertSource - source at which the alert can be raised
type AlertSource struct {
	// Source type of the alert.
	AlertSourceType *AlertSourceType `json:"alertSourceType,omitempty"`

	// Name of the source.
	Name *string `json:"name,omitempty"`

	// The time zone.
	TimeZone *string `json:"timeZone,omitempty"`
}

// AlertsClientClearOptions contains the optional parameters for the AlertsClient.Clear method.
type AlertsClientClearOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientListByManagerOptions contains the optional parameters for the AlertsClient.ListByManager method.
type AlertsClientListByManagerOptions struct {
	// OData Filter options
	Filter *string
}

// AlertsClientSendTestEmailOptions contains the optional parameters for the AlertsClient.SendTestEmail method.
type AlertsClientSendTestEmailOptions struct {
	// placeholder for future optional parameters
}

// AsymmetricEncryptedSecret - This class can be used as the Type for any secret entity represented as Password, CertThumbprint,
// Algorithm. This class is intended to be used when the secret is encrypted with an asymmetric key pair.
// The encryptionAlgorithm field is mainly for future usage to potentially allow different entities encrypted using different
// algorithms.
type AsymmetricEncryptedSecret struct {
	// REQUIRED; Algorithm used to encrypt "Value"
	EncryptionAlgorithm *EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`

	// REQUIRED; The value of the secret itself. If the secret is in plaintext then EncryptionAlgorithm will be none and EncryptionCertThumbprint
	// will be null.
	Value *string `json:"value,omitempty"`

	// Thumbprint certificate that was used to encrypt "Value"
	EncryptionCertificateThumbprint *string `json:"encryptionCertificateThumbprint,omitempty"`
}

// AvailableProviderOperation - Class represents provider operation
type AvailableProviderOperation struct {
	// Gets or sets Display information Contains the localized display information for this particular operation/action
	Display *AvailableProviderOperationDisplay `json:"display,omitempty"`

	// Gets or sets the name of the operation being performed on this particular object Return value format: "{resourceProviderNamespace}/{resourceType}/{read|write|deletion|action}"
	// Eg:
	// Microsoft.StorSimple/managers/devices/fileServers/read Microsoft.StorSimple/managers/devices/alerts/clearAlerts/action
	Name *string `json:"name,omitempty"`

	// Gets or sets Origin The intended executor of the operation; governs the display of the operation in the RBAC UX and the
	// audit logs UX. Default value is “user,system”
	Origin *string `json:"origin,omitempty"`

	// Gets or sets Properties Reserved for future use
	Properties interface{} `json:"properties,omitempty"`
}

// AvailableProviderOperationDisplay - Contains the localized display information for this particular operation / action.
// These value will be used by several clients for (1) custom role definitions for RBAC; (2) complex query filters for
// the event service; and (3) audit history / records for management operations.
type AvailableProviderOperationDisplay struct {
	// Gets or sets Description The localized friendly description for the operation, as it should be shown to the user. It should
	// be thorough, yet concise – it will be used in tool tips and detailed views.
	Description *string `json:"description,omitempty"`

	// Gets or sets Operation The localized friendly name for the operation, as it should be shown to the user. It should be concise
	// (to fit in drop downs) but clear (i.e. self-documenting). It should use
	// Title Casing and include the entity/resource to which it applies.
	Operation *string `json:"operation,omitempty"`

	// Gets or sets Provider The localized friendly form of the resource provider name – it is expected to also include the publisher/company
	// responsible. It should use Title Casing and begin with
	// “Microsoft” for 1st party services.
	Provider *string `json:"provider,omitempty"`

	// Gets or sets Resource The localized friendly form of the resource type related to this action/operation – it should match
	// the public documentation for the resource provider. It should use Title Casing
	// – for examples, please refer to the “name” section.
	Resource *string `json:"resource,omitempty"`
}

// AvailableProviderOperations - Class for set of operations used for discovery of available provider operations.
type AvailableProviderOperations struct {
	// REQUIRED; The value.
	Value []*AvailableProviderOperation `json:"value,omitempty"`

	// The NextLink.
	NextLink *string `json:"nextLink,omitempty"`
}

// AvailableProviderOperationsClientListOptions contains the optional parameters for the AvailableProviderOperationsClient.List
// method.
type AvailableProviderOperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Backup - The backup.
type Backup struct {
	// REQUIRED; Properties of backup
	Properties *BackupProperties `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupElement - Class represents BackupElement
type BackupElement struct {
	// REQUIRED; The Properties of backup element
	Properties *BackupElementProperties `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupElementProperties - The backup element properties
type BackupElementProperties struct {
	// REQUIRED; The data policy of backed up endpoint.
	DataPolicy *DataPolicy `json:"dataPolicy,omitempty"`

	// REQUIRED; The name of the endpoint.
	EndpointName *string `json:"endpointName,omitempty"`

	// REQUIRED; The size in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`
}

// BackupFilter - Backup OData filter class
type BackupFilter struct {
	// Gets or sets CreatedTime
	CreatedTime *time.Time `json:"createdTime,omitempty"`

	// Gets or sets InitiatedBy
	InitiatedBy *InitiatedBy `json:"initiatedBy,omitempty"`
}

// BackupList - Collection of backups
type BackupList struct {
	// REQUIRED; The value.
	Value []*Backup `json:"value,omitempty"`

	// The NextLink.
	NextLink *string `json:"nextLink,omitempty"`
}

// BackupProperties - Class represents Backup properties
type BackupProperties struct {
	// REQUIRED; The Device Identifier.
	DeviceID *string `json:"deviceId,omitempty"`

	// REQUIRED; The backup elements.
	Elements []*BackupElement `json:"elements,omitempty"`

	// REQUIRED; Indicates how the backup was initiated "Manual | Scheduled".
	InitiatedBy *InitiatedBy `json:"initiatedBy,omitempty"`

	// REQUIRED; The backup size in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`

	// The time when the backup was created.
	CreatedTime *time.Time `json:"createdTime,omitempty"`

	// The time when the backup will expire.
	ExpirationTime *time.Time `json:"expirationTime,omitempty"`

	// The path id of the target FileServer or IscsiServer for which the backup was taken.
	TargetID *string `json:"targetId,omitempty"`

	// Type of target, FileServer or IscsiServer
	TargetType *string `json:"targetType,omitempty"`
}

// BackupScheduleGroup - The Backup Schedule Group
type BackupScheduleGroup struct {
	// REQUIRED; Properties of BackupScheduleGroup
	Properties *BackupScheduleGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupScheduleGroupList - The list response of backup schedule groups
type BackupScheduleGroupList struct {
	// REQUIRED; The value.
	Value []*BackupScheduleGroup `json:"value,omitempty"`
}

// BackupScheduleGroupProperties - The Backup Schedule Group Properties
type BackupScheduleGroupProperties struct {
	// REQUIRED; The start time. When this field is specified we will generate Default GrandFather Father Son Backup Schedules.
	StartTime *Time `json:"startTime,omitempty"`
}

// BackupScheduleGroupsClientBeginCreateOrUpdateOptions contains the optional parameters for the BackupScheduleGroupsClient.BeginCreateOrUpdate
// method.
type BackupScheduleGroupsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupScheduleGroupsClientBeginDeleteOptions contains the optional parameters for the BackupScheduleGroupsClient.BeginDelete
// method.
type BackupScheduleGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupScheduleGroupsClientGetOptions contains the optional parameters for the BackupScheduleGroupsClient.Get method.
type BackupScheduleGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// BackupScheduleGroupsClientListByDeviceOptions contains the optional parameters for the BackupScheduleGroupsClient.ListByDevice
// method.
type BackupScheduleGroupsClientListByDeviceOptions struct {
	// placeholder for future optional parameters
}

// BackupsClientBeginCloneOptions contains the optional parameters for the BackupsClient.BeginClone method.
type BackupsClientBeginCloneOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupsClientBeginDeleteOptions contains the optional parameters for the BackupsClient.BeginDelete method.
type BackupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupsClientListByDeviceOptions contains the optional parameters for the BackupsClient.ListByDevice method.
type BackupsClientListByDeviceOptions struct {
	// OData Filter options
	Filter *string
	// Set to true if you need backups which can be used for failover.
	ForFailover *bool
}

// BackupsClientListByManagerOptions contains the optional parameters for the BackupsClient.ListByManager method.
type BackupsClientListByManagerOptions struct {
	// OData Filter options
	Filter *string
}

// BaseModel - Base class for models
type BaseModel struct {
	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ChapProperties - Chap properties
type ChapProperties struct {
	// REQUIRED; The chap password.
	Password *AsymmetricEncryptedSecret `json:"password,omitempty"`
}

// ChapSettings - Challenge-Handshake Authentication Protocol (CHAP) setting
type ChapSettings struct {
	// REQUIRED; Chap properties
	Properties *ChapProperties `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ChapSettingsClientBeginCreateOrUpdateOptions contains the optional parameters for the ChapSettingsClient.BeginCreateOrUpdate
// method.
type ChapSettingsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ChapSettingsClientBeginDeleteOptions contains the optional parameters for the ChapSettingsClient.BeginDelete method.
type ChapSettingsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ChapSettingsClientGetOptions contains the optional parameters for the ChapSettingsClient.Get method.
type ChapSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ChapSettingsClientListByDeviceOptions contains the optional parameters for the ChapSettingsClient.ListByDevice method.
type ChapSettingsClientListByDeviceOptions struct {
	// placeholder for future optional parameters
}

// ChapSettingsList - Collection of Chap setting entities
type ChapSettingsList struct {
	// REQUIRED; The chap settings entity collection
	Value []*ChapSettings `json:"value,omitempty"`
}

// ClearAlertRequest - Request for clearing the alert
type ClearAlertRequest struct {
	// REQUIRED; List of alert Ids to be cleared
	Alerts []*string `json:"alerts,omitempty"`

	// Resolution message while clearing the request
	ResolutionMessage *string `json:"resolutionMessage,omitempty"`
}

// CloneRequest - Clone Job Request Model.
type CloneRequest struct {
	// REQUIRED; CloneJob Properties are encapsulated in this object.
	Properties *CloneRequestProperties `json:"properties,omitempty"`
}

// CloneRequestProperties - Properties of CloneRequest
type CloneRequestProperties struct {
	// REQUIRED; Name of new endpoint which will created as part of clone job.
	NewEndpointName *string `json:"newEndpointName,omitempty"`

	// REQUIRED; Access point Id on which clone job will performed.
	TargetAccessPointID *string `json:"targetAccessPointId,omitempty"`

	// REQUIRED; DeviceId of the device which will act as the Clone target
	TargetDeviceID *string `json:"targetDeviceId,omitempty"`

	// Disk Object
	Disk *ISCSIDisk `json:"disk,omitempty"`

	// Share Object.
	Share *FileShare `json:"share,omitempty"`
}

// Device - Represents a StorSimple device object along with its properties
type Device struct {
	// Collection of properties for the device
	Properties *DeviceProperties `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeviceDetails - Class containing more granular details about the device
type DeviceDetails struct {
	// Local pending storage available on the device in bytes
	AvailableLocalStorageInBytes *int64 `json:"availableLocalStorageInBytes,omitempty"`

	// Total pending available storage on the device in bytes
	AvailableStorageInBytes *int64 `json:"availableStorageInBytes,omitempty"`

	// Total number of endpoints that are currently on the device ( i.e. number of shares on FileServer or number of volumes on
	// IscsiServer)
	EndpointCount *int32 `json:"endpointCount,omitempty"`

	// Storage in bytes that has been provisioned locally on the device
	ProvisionedLocalStorageInBytes *int64 `json:"provisionedLocalStorageInBytes,omitempty"`

	// Storage in bytes that has been provisioned on the device including both local and cloud
	ProvisionedStorageInBytes *int64 `json:"provisionedStorageInBytes,omitempty"`

	// Total size taken up by backups in bytes
	TotalBackupSizeInBytes *int64 `json:"totalBackupSizeInBytes,omitempty"`

	// Total local storage capacity in device in bytes.
	TotalLocalStorageInBytes *int64 `json:"totalLocalStorageInBytes,omitempty"`

	// Total storage available on the device in bytes.
	TotalStorageInBytes *int64 `json:"totalStorageInBytes,omitempty"`

	// Local Storage that is being currently used in bytes
	UsingLocalStorageInBytes *int64 `json:"usingLocalStorageInBytes,omitempty"`

	// Storage that is being currently used in bytes including both local and cloud
	UsingStorageInBytes *int64 `json:"usingStorageInBytes,omitempty"`
}

// DeviceList - Collection of Devices
type DeviceList struct {
	// REQUIRED; The value.
	Value []*Device `json:"value,omitempty"`
}

// DevicePatch - Class that represents the Input for the PATCH call on Device. Currently the only patchable property on device
// is "DeviceDescription"
type DevicePatch struct {
	// Short description given for the device
	DeviceDescription *string `json:"deviceDescription,omitempty"`
}

// DeviceProperties - Encases all the properties of the Device
type DeviceProperties struct {
	// The UTC time at which the device was activated
	ActivationTime *time.Time `json:"activationTime,omitempty"`

	// Operations that are allowed on the device based on its current state
	AllowedDeviceOperations []*DeviceOperation `json:"allowedDeviceOperations,omitempty"`

	// Language culture setting on the device. For eg: "en-US"
	Culture *string `json:"culture,omitempty"`

	// subclass containing more storage-related information about the device. This field will be populated only if the get call
	// is made with $expand = details.
	Details *DeviceDetails `json:"details,omitempty"`

	// Device can be configured either as FileServer or IscsiServer
	DeviceCapabilities []*SupportedDeviceCapabilities `json:"deviceCapabilities,omitempty"`

	// "Complete" if the device has been successfully registered as File/IscsiServer and the creation of share/volume is complete,
	// "Pending" if the device is only registered but the creation of share/volume
	// is complete is still pending
	DeviceConfigurationStatus *DeviceConfigurationStatus `json:"deviceConfigurationStatus,omitempty"`

	// Short description given for the device
	DeviceDescription *string `json:"deviceDescription,omitempty"`

	// Version number of the software running on the device
	DeviceSoftwareVersion *string `json:"deviceSoftwareVersion,omitempty"`

	// Fully qualified name of the domain to which the device is attached
	DomainName *string `json:"domainName,omitempty"`

	// Friendly name for the software version
	FriendlySoftwareName *string `json:"friendlySoftwareName,omitempty"`

	// Name of the device model
	ModelDescription *string `json:"modelDescription,omitempty"`

	// Current status of the device
	Status *DeviceStatus `json:"status,omitempty"`

	// Type of the device
	Type *DeviceType `json:"type,omitempty"`
}

// DevicesClientBeginCreateOrUpdateAlertSettingsOptions contains the optional parameters for the DevicesClient.BeginCreateOrUpdateAlertSettings
// method.
type DevicesClientBeginCreateOrUpdateAlertSettingsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginCreateOrUpdateSecuritySettingsOptions contains the optional parameters for the DevicesClient.BeginCreateOrUpdateSecuritySettings
// method.
type DevicesClientBeginCreateOrUpdateSecuritySettingsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginDeactivateOptions contains the optional parameters for the DevicesClient.BeginDeactivate method.
type DevicesClientBeginDeactivateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginDeleteOptions contains the optional parameters for the DevicesClient.BeginDelete method.
type DevicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginDownloadUpdatesOptions contains the optional parameters for the DevicesClient.BeginDownloadUpdates method.
type DevicesClientBeginDownloadUpdatesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginFailoverOptions contains the optional parameters for the DevicesClient.BeginFailover method.
type DevicesClientBeginFailoverOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginInstallUpdatesOptions contains the optional parameters for the DevicesClient.BeginInstallUpdates method.
type DevicesClientBeginInstallUpdatesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginPatchOptions contains the optional parameters for the DevicesClient.BeginPatch method.
type DevicesClientBeginPatchOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginScanForUpdatesOptions contains the optional parameters for the DevicesClient.BeginScanForUpdates method.
type DevicesClientBeginScanForUpdatesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientGetAlertSettingsOptions contains the optional parameters for the DevicesClient.GetAlertSettings method.
type DevicesClientGetAlertSettingsOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientGetNetworkSettingsOptions contains the optional parameters for the DevicesClient.GetNetworkSettings method.
type DevicesClientGetNetworkSettingsOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientGetOptions contains the optional parameters for the DevicesClient.Get method.
type DevicesClientGetOptions struct {
	// Specify $expand=details to populate additional fields related to the device.
	Expand *string
}

// DevicesClientGetTimeSettingsOptions contains the optional parameters for the DevicesClient.GetTimeSettings method.
type DevicesClientGetTimeSettingsOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientGetUpdateSummaryOptions contains the optional parameters for the DevicesClient.GetUpdateSummary method.
type DevicesClientGetUpdateSummaryOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientListByManagerOptions contains the optional parameters for the DevicesClient.ListByManager method.
type DevicesClientListByManagerOptions struct {
	// Specify $expand=details to populate additional fields related to the device.
	Expand *string
}

// DevicesClientListFailoverTargetOptions contains the optional parameters for the DevicesClient.ListFailoverTarget method.
type DevicesClientListFailoverTargetOptions struct {
	// Specify $expand=details to populate additional fields related to the device.
	Expand *string
}

// DevicesClientListMetricDefinitionOptions contains the optional parameters for the DevicesClient.ListMetricDefinition method.
type DevicesClientListMetricDefinitionOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientListMetricsOptions contains the optional parameters for the DevicesClient.ListMetrics method.
type DevicesClientListMetricsOptions struct {
	// OData Filter options
	Filter *string
}

// EncryptionSettings - The EncryptionSettings
type EncryptionSettings struct {
	// REQUIRED; Properties of the EncryptionSettings.
	Properties *EncryptionSettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EncryptionSettingsProperties - The properties of EncryptionSettings
type EncryptionSettingsProperties struct {
	// REQUIRED; The encryption status which indicates if encryption is enabled or not.
	EncryptionStatus *EncryptionStatus `json:"encryptionStatus,omitempty"`

	// REQUIRED; The key rollover status which indicates if key rollover is required or not. If secrets encryption has been upgraded,
	// then it requires key rollover.
	KeyRolloverStatus *KeyRolloverStatus `json:"keyRolloverStatus,omitempty"`
}

type Error struct {
	// REQUIRED
	ErrorCode *string `json:"errorCode,omitempty"`

	// REQUIRED
	Message *Message `json:"message,omitempty"`
	Values  []*Item  `json:"values,omitempty"`
}

// FailoverRequest - The Failover request object.
type FailoverRequest struct {
	AccesspointIDs   []*string `json:"accesspointIds,omitempty"`
	KeepSourceDevice *bool     `json:"keepSourceDevice,omitempty"`
	SkipValidation   *bool     `json:"skipValidation,omitempty"`
	TargetDeviceID   *string   `json:"targetDeviceId,omitempty"`
}

// FileServer - The file server.
type FileServer struct {
	// REQUIRED; The properties.
	Properties *FileServerProperties `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FileServerList - Collection of file servers
type FileServerList struct {
	// REQUIRED; The value.
	Value []*FileServer `json:"value,omitempty"`
}

// FileServerProperties - The file server properties.
type FileServerProperties struct {
	// REQUIRED; The backup policy id.
	BackupScheduleGroupID *string `json:"backupScheduleGroupId,omitempty"`

	// REQUIRED; Domain of the file server
	DomainName *string `json:"domainName,omitempty"`

	// REQUIRED; The storage domain id.
	StorageDomainID *string `json:"storageDomainId,omitempty"`

	// The description of the file server
	Description *string `json:"description,omitempty"`
}

// FileServersClientBeginBackupNowOptions contains the optional parameters for the FileServersClient.BeginBackupNow method.
type FileServersClientBeginBackupNowOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FileServersClientBeginCreateOrUpdateOptions contains the optional parameters for the FileServersClient.BeginCreateOrUpdate
// method.
type FileServersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FileServersClientBeginDeleteOptions contains the optional parameters for the FileServersClient.BeginDelete method.
type FileServersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FileServersClientGetOptions contains the optional parameters for the FileServersClient.Get method.
type FileServersClientGetOptions struct {
	// placeholder for future optional parameters
}

// FileServersClientListByDeviceOptions contains the optional parameters for the FileServersClient.ListByDevice method.
type FileServersClientListByDeviceOptions struct {
	// placeholder for future optional parameters
}

// FileServersClientListByManagerOptions contains the optional parameters for the FileServersClient.ListByManager method.
type FileServersClientListByManagerOptions struct {
	// placeholder for future optional parameters
}

// FileServersClientListMetricDefinitionOptions contains the optional parameters for the FileServersClient.ListMetricDefinition
// method.
type FileServersClientListMetricDefinitionOptions struct {
	// placeholder for future optional parameters
}

// FileServersClientListMetricsOptions contains the optional parameters for the FileServersClient.ListMetrics method.
type FileServersClientListMetricsOptions struct {
	// OData Filter options
	Filter *string
}

// FileShare - The File Share.
type FileShare struct {
	// REQUIRED; The properties.
	Properties *FileShareProperties `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FileShareList - Collection of file shares
type FileShareList struct {
	// REQUIRED; The value.
	Value []*FileShare `json:"value,omitempty"`
}

// FileShareProperties - The File Share.
type FileShareProperties struct {
	// REQUIRED; The user/group who will have full permission in this share. Active directory email address. Example: xyz@contoso.com
	// or Contoso\xyz.
	AdminUser *string `json:"adminUser,omitempty"`

	// REQUIRED; The data policy
	DataPolicy *DataPolicy `json:"dataPolicy,omitempty"`

	// REQUIRED; The monitoring status
	MonitoringStatus *MonitoringStatus `json:"monitoringStatus,omitempty"`

	// REQUIRED; The total provisioned capacity in Bytes
	ProvisionedCapacityInBytes *int64 `json:"provisionedCapacityInBytes,omitempty"`

	// REQUIRED; The Share Status
	ShareStatus *ShareStatus `json:"shareStatus,omitempty"`

	// Description for file share
	Description *string `json:"description,omitempty"`

	// READ-ONLY; The local used capacity in Bytes.
	LocalUsedCapacityInBytes *int64 `json:"localUsedCapacityInBytes,omitempty" azure:"ro"`

	// READ-ONLY; The used capacity in Bytes.
	UsedCapacityInBytes *int64 `json:"usedCapacityInBytes,omitempty" azure:"ro"`
}

// FileSharesClientBeginCreateOrUpdateOptions contains the optional parameters for the FileSharesClient.BeginCreateOrUpdate
// method.
type FileSharesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FileSharesClientBeginDeleteOptions contains the optional parameters for the FileSharesClient.BeginDelete method.
type FileSharesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FileSharesClientGetOptions contains the optional parameters for the FileSharesClient.Get method.
type FileSharesClientGetOptions struct {
	// placeholder for future optional parameters
}

// FileSharesClientListByDeviceOptions contains the optional parameters for the FileSharesClient.ListByDevice method.
type FileSharesClientListByDeviceOptions struct {
	// placeholder for future optional parameters
}

// FileSharesClientListByFileServerOptions contains the optional parameters for the FileSharesClient.ListByFileServer method.
type FileSharesClientListByFileServerOptions struct {
	// placeholder for future optional parameters
}

// FileSharesClientListMetricDefinitionOptions contains the optional parameters for the FileSharesClient.ListMetricDefinition
// method.
type FileSharesClientListMetricDefinitionOptions struct {
	// placeholder for future optional parameters
}

// FileSharesClientListMetricsOptions contains the optional parameters for the FileSharesClient.ListMetrics method.
type FileSharesClientListMetricsOptions struct {
	// OData Filter options
	Filter *string
}

// IPConfig - Details related to the IP address configuration
type IPConfig struct {
	// REQUIRED; The gateway of the network adapter.
	Gateway *string `json:"gateway,omitempty"`

	// REQUIRED; The IP address of the network adapter, either ipv4 or ipv6.
	IPAddress *string `json:"ipAddress,omitempty"`

	// The prefix length of the network adapter.
	PrefixLength *int32 `json:"prefixLength,omitempty"`
}

// ISCSIDisk - The iSCSI disk.
type ISCSIDisk struct {
	// REQUIRED; The properties.
	Properties *ISCSIDiskProperties `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ISCSIDiskList - Collection of Iscsi disk
type ISCSIDiskList struct {
	// REQUIRED; The value.
	Value []*ISCSIDisk `json:"value,omitempty"`
}

// ISCSIDiskProperties - The iSCSI disk properties.
type ISCSIDiskProperties struct {
	// REQUIRED; The access control records.
	AccessControlRecords []*string `json:"accessControlRecords,omitempty"`

	// REQUIRED; The data policy.
	DataPolicy *DataPolicy `json:"dataPolicy,omitempty"`

	// REQUIRED; The disk status.
	DiskStatus *DiskStatus `json:"diskStatus,omitempty"`

	// REQUIRED; The monitoring.
	MonitoringStatus *MonitoringStatus `json:"monitoringStatus,omitempty"`

	// REQUIRED; The provisioned capacity in bytes.
	ProvisionedCapacityInBytes *int64 `json:"provisionedCapacityInBytes,omitempty"`

	// The description.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; The local used capacity in bytes.
	LocalUsedCapacityInBytes *int64 `json:"localUsedCapacityInBytes,omitempty" azure:"ro"`

	// READ-ONLY; The used capacity in bytes.
	UsedCapacityInBytes *int64 `json:"usedCapacityInBytes,omitempty" azure:"ro"`
}

// ISCSIServer - The iSCSI server.
type ISCSIServer struct {
	// REQUIRED; The properties.
	Properties *ISCSIServerProperties `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ISCSIServerList - Collection of Iscsi servers
type ISCSIServerList struct {
	// REQUIRED; The value.
	Value []*ISCSIServer `json:"value,omitempty"`
}

// ISCSIServerProperties - The iSCSI server properties.
type ISCSIServerProperties struct {
	// REQUIRED; The backup policy id.
	BackupScheduleGroupID *string `json:"backupScheduleGroupId,omitempty"`

	// REQUIRED; The storage domain id.
	StorageDomainID *string `json:"storageDomainId,omitempty"`

	// The chap id.
	ChapID *string `json:"chapId,omitempty"`

	// The description.
	Description *string `json:"description,omitempty"`

	// The reverse chap id.
	ReverseChapID *string `json:"reverseChapId,omitempty"`
}

// IscsiDisksClientBeginCreateOrUpdateOptions contains the optional parameters for the IscsiDisksClient.BeginCreateOrUpdate
// method.
type IscsiDisksClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IscsiDisksClientBeginDeleteOptions contains the optional parameters for the IscsiDisksClient.BeginDelete method.
type IscsiDisksClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IscsiDisksClientGetOptions contains the optional parameters for the IscsiDisksClient.Get method.
type IscsiDisksClientGetOptions struct {
	// placeholder for future optional parameters
}

// IscsiDisksClientListByDeviceOptions contains the optional parameters for the IscsiDisksClient.ListByDevice method.
type IscsiDisksClientListByDeviceOptions struct {
	// placeholder for future optional parameters
}

// IscsiDisksClientListByIscsiServerOptions contains the optional parameters for the IscsiDisksClient.ListByIscsiServer method.
type IscsiDisksClientListByIscsiServerOptions struct {
	// placeholder for future optional parameters
}

// IscsiDisksClientListMetricDefinitionOptions contains the optional parameters for the IscsiDisksClient.ListMetricDefinition
// method.
type IscsiDisksClientListMetricDefinitionOptions struct {
	// placeholder for future optional parameters
}

// IscsiDisksClientListMetricsOptions contains the optional parameters for the IscsiDisksClient.ListMetrics method.
type IscsiDisksClientListMetricsOptions struct {
	// OData Filter options
	Filter *string
}

// IscsiServersClientBeginBackupNowOptions contains the optional parameters for the IscsiServersClient.BeginBackupNow method.
type IscsiServersClientBeginBackupNowOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IscsiServersClientBeginCreateOrUpdateOptions contains the optional parameters for the IscsiServersClient.BeginCreateOrUpdate
// method.
type IscsiServersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IscsiServersClientBeginDeleteOptions contains the optional parameters for the IscsiServersClient.BeginDelete method.
type IscsiServersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IscsiServersClientGetOptions contains the optional parameters for the IscsiServersClient.Get method.
type IscsiServersClientGetOptions struct {
	// placeholder for future optional parameters
}

// IscsiServersClientListByDeviceOptions contains the optional parameters for the IscsiServersClient.ListByDevice method.
type IscsiServersClientListByDeviceOptions struct {
	// placeholder for future optional parameters
}

// IscsiServersClientListByManagerOptions contains the optional parameters for the IscsiServersClient.ListByManager method.
type IscsiServersClientListByManagerOptions struct {
	// placeholder for future optional parameters
}

// IscsiServersClientListMetricDefinitionOptions contains the optional parameters for the IscsiServersClient.ListMetricDefinition
// method.
type IscsiServersClientListMetricDefinitionOptions struct {
	// placeholder for future optional parameters
}

// IscsiServersClientListMetricsOptions contains the optional parameters for the IscsiServersClient.ListMetrics method.
type IscsiServersClientListMetricsOptions struct {
	// OData Filter options
	Filter *string
}

type Item struct {
	// REQUIRED
	Key *string `json:"key,omitempty"`

	// REQUIRED
	Value *string `json:"value,omitempty"`
}

// Job - The Job.
type Job struct {
	// REQUIRED; The percentage of the job that is already complete
	PercentComplete *int32 `json:"percentComplete,omitempty"`

	// REQUIRED; Current status of the job
	Status *JobStatus `json:"status,omitempty"`

	// The UTC time at which the job completed
	EndTime *time.Time `json:"endTime,omitempty"`

	// The Error details.
	Error *JobErrorDetails `json:"error,omitempty"`

	// Other properties of the job
	Properties *JobProperties `json:"properties,omitempty"`

	// The UTC time at which the job was started
	StartTime *time.Time `json:"startTime,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JobErrorDetails - The job error information containing List of JobErrorItem.
type JobErrorDetails struct {
	// REQUIRED; The code intended for programmatic access
	Code *string `json:"code,omitempty"`

	// REQUIRED; The message intended to describe the error in detail
	Message *string `json:"message,omitempty"`

	// The error details.
	ErrorDetails []*JobErrorItem `json:"errorDetails,omitempty"`
}

// JobErrorItem - The job error items.
type JobErrorItem struct {
	// REQUIRED; The code intended for programmatic access
	Code *string `json:"code,omitempty"`

	// REQUIRED; The message intended to describe the error in detail
	Message *string `json:"message,omitempty"`

	// The recommended actions.
	Recommendations []*string `json:"recommendations,omitempty"`
}

// JobFilter - Filters that can be specified for the job
type JobFilter struct {
	// REQUIRED; The job type.
	JobType *JobType `json:"jobType,omitempty"`

	// REQUIRED; The job status.
	Status *JobStatus `json:"status,omitempty"`

	// The start time of the job.
	StartTime *time.Time `json:"startTime,omitempty"`
}

// JobList - Collection of jobs
type JobList struct {
	// REQUIRED; The value.
	Value []*Job `json:"value,omitempty"`

	// The NextLink.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobProperties - properties for the job
type JobProperties struct {
	// REQUIRED; Type of the job
	JobType *JobType `json:"jobType,omitempty"`

	// The time of the backup used for the failover.
	BackupPointInTime *time.Time `json:"backupPointInTime,omitempty"`

	// The device id in which the job is currently running
	DeviceID *string `json:"deviceId,omitempty"`

	// The download progress.
	DownloadProgress *UpdateDownloadProgress `json:"downloadProgress,omitempty"`

	// The entity identifier for which the job ran.
	EntityID *string `json:"entityId,omitempty"`

	// The entity type for which the job ran.
	EntityType *string `json:"entityType,omitempty"`

	// The install progress.
	InstallProgress *UpdateInstallProgress `json:"installProgress,omitempty"`

	// Represents whether the job is cancellable or not
	IsCancellable *bool `json:"isCancellable,omitempty"`

	// The job stages.
	JobStages []*JobStage `json:"jobStages,omitempty"`

	// The source device identifier of the failover job.
	SourceDeviceID *string `json:"sourceDeviceId,omitempty"`

	// stats properties for the job
	Stats *JobStats `json:"stats,omitempty"`

	// Id of the object that is created by the job
	TargetID *string `json:"targetId,omitempty"`

	// The target type of the backup.
	TargetType *TargetType `json:"targetType,omitempty"`
}

// JobStage - Contains details about the multiple job stages of a job
type JobStage struct {
	// REQUIRED; The stage status.
	StageStatus *JobStatus `json:"stageStatus,omitempty"`

	// The details of the stage.
	Detail *string `json:"detail,omitempty"`

	// The error code of the stage if any.
	ErrorCode *string `json:"errorCode,omitempty"`

	// The message of the job stage.
	Message *string `json:"message,omitempty"`
}

// JobStats - Stats that are available for all jobs in common
type JobStats struct {
	// Completed work item count.
	CompletedWorkItemCount *int32 `json:"completedWorkItemCount,omitempty"`

	// The estimated time remaining.
	EstimatedTimeRemaining *int32 `json:"estimatedTimeRemaining,omitempty"`

	// Total work item count.
	TotalWorkItemCount *int32 `json:"totalWorkItemCount,omitempty"`
}

// JobsClientGetOptions contains the optional parameters for the JobsClient.Get method.
type JobsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JobsClientListByDeviceOptions contains the optional parameters for the JobsClient.ListByDevice method.
type JobsClientListByDeviceOptions struct {
	// OData Filter options
	Filter *string
}

// JobsClientListByManagerOptions contains the optional parameters for the JobsClient.ListByManager method.
type JobsClientListByManagerOptions struct {
	// OData Filter options
	Filter *string
}

// Manager - The StorSimple Manager
type Manager struct {
	// REQUIRED; The Geo location of the Manager
	Location *string `json:"location,omitempty"`

	// ETag of the Manager
	Etag *string `json:"etag,omitempty"`

	// List of properties of the Manager
	Properties *ManagerProperties `json:"properties,omitempty"`

	// Tags attached to the Manager
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagerExtendedInfo - The extended info of the manager.
type ManagerExtendedInfo struct {
	// REQUIRED; The extended info properties.
	Properties *ManagerExtendedInfoProperties `json:"properties,omitempty"`

	// ETag of the Resource
	Etag *string `json:"etag,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagerExtendedInfoProperties - Properties of the ManagerExtendedInfo
type ManagerExtendedInfoProperties struct {
	// REQUIRED; Represents the encryption algorithm used to encrypt the other keys. None - if EncryptionKey is saved in plain
	// text format. AlgorithmName - if encryption is used
	Algorithm *string `json:"algorithm,omitempty"`

	// REQUIRED; Represents the CIK of the resource
	IntegrityKey *string `json:"integrityKey,omitempty"`

	// Represents the CEK of the resource
	EncryptionKey *string `json:"encryptionKey,omitempty"`

	// Represents the Cert thumbprint that was used to encrypt the CEK
	EncryptionKeyThumbprint *string `json:"encryptionKeyThumbprint,omitempty"`

	// Represents the portal thumbprint which can be used optionally to encrypt the entire data before storing it.
	PortalCertificateThumbprint *string `json:"portalCertificateThumbprint,omitempty"`

	// Represents the version of the ExtendedInfo object being persisted
	Version *string `json:"version,omitempty"`
}

// ManagerIntrinsicSettings - Intrinsic settings which refers to the type of the StorSimple manager
type ManagerIntrinsicSettings struct {
	// REQUIRED; Refers to the type of the StorSimple Manager
	Type *ManagerType `json:"type,omitempty"`
}

// ManagerList - List of StorSimple Managers under a particular resourceGroup
type ManagerList struct {
	// REQUIRED; List of Managers
	Value []*Manager `json:"value,omitempty"`
}

// ManagerPatch - The StorSimple Manager patch.
type ManagerPatch struct {
	// The tags attached to the StorSimple Manager.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ManagerProperties - The properties of the Manager
type ManagerProperties struct {
	// Specifies if the Manager is Garda or Helsinki
	CisIntrinsicSettings *ManagerIntrinsicSettings `json:"cisIntrinsicSettings,omitempty"`

	// Specifies the Sku
	SKU *ManagerSKU `json:"sku,omitempty"`

	// READ-ONLY; Specifies the state of the resource as it is getting provisioned. Value of "Succeeded" means the Manager was
	// successfully created
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ManagerSKU - The Sku.
type ManagerSKU struct {
	// REQUIRED; Refers to the sku name which should be "Standard"
	Name *string `json:"name,omitempty"`
}

// ManagersClientCreateExtendedInfoOptions contains the optional parameters for the ManagersClient.CreateExtendedInfo method.
type ManagersClientCreateExtendedInfoOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientCreateOrUpdateOptions contains the optional parameters for the ManagersClient.CreateOrUpdate method.
type ManagersClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientDeleteExtendedInfoOptions contains the optional parameters for the ManagersClient.DeleteExtendedInfo method.
type ManagersClientDeleteExtendedInfoOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientDeleteOptions contains the optional parameters for the ManagersClient.Delete method.
type ManagersClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientGetEncryptionKeyOptions contains the optional parameters for the ManagersClient.GetEncryptionKey method.
type ManagersClientGetEncryptionKeyOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientGetEncryptionSettingsOptions contains the optional parameters for the ManagersClient.GetEncryptionSettings
// method.
type ManagersClientGetEncryptionSettingsOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientGetExtendedInfoOptions contains the optional parameters for the ManagersClient.GetExtendedInfo method.
type ManagersClientGetExtendedInfoOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientGetOptions contains the optional parameters for the ManagersClient.Get method.
type ManagersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientListByResourceGroupOptions contains the optional parameters for the ManagersClient.ListByResourceGroup method.
type ManagersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientListMetricDefinitionOptions contains the optional parameters for the ManagersClient.ListMetricDefinition
// method.
type ManagersClientListMetricDefinitionOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientListMetricsOptions contains the optional parameters for the ManagersClient.ListMetrics method.
type ManagersClientListMetricsOptions struct {
	// OData Filter options
	Filter *string
}

// ManagersClientListOptions contains the optional parameters for the ManagersClient.List method.
type ManagersClientListOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientUpdateExtendedInfoOptions contains the optional parameters for the ManagersClient.UpdateExtendedInfo method.
type ManagersClientUpdateExtendedInfoOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientUpdateOptions contains the optional parameters for the ManagersClient.Update method.
type ManagersClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientUploadRegistrationCertificateOptions contains the optional parameters for the ManagersClient.UploadRegistrationCertificate
// method.
type ManagersClientUploadRegistrationCertificateOptions struct {
	// placeholder for future optional parameters
}

type Message struct {
	Language *string `json:"language,omitempty"`
	Value    *string `json:"value,omitempty"`
}

// MetricAvailablity - Metric availability specifies the time grain (aggregation interval or frequency) and the retention
// period for that time grain
type MetricAvailablity struct {
	// REQUIRED; The retention period for the metric at the specified timegrain
	Retention *string `json:"retention,omitempty"`

	// REQUIRED; The time grain, specifies the aggregation interval for the metric.
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// MetricData - The metric data.
type MetricData struct {
	// REQUIRED; The average of all sample for the given instance
	Average *float64 `json:"average,omitempty"`

	// REQUIRED; The count of samples of the metric data available for the given instance
	Count *int32 `json:"count,omitempty"`

	// REQUIRED; The maximum of all samples available
	Maximum *float64 `json:"maximum,omitempty"`

	// REQUIRED; The minimum of all samples available
	Minimum *float64 `json:"minimum,omitempty"`

	// REQUIRED; The sum of all the samples available in the given instance of time for the specific metric data
	Sum *float64 `json:"sum,omitempty"`

	// REQUIRED; The time when the metric data is fetched
	TimeStamp *time.Time `json:"timeStamp,omitempty"`
}

// MetricDefinition - Monitoring metric definition represents the metadata of the metrics.
type MetricDefinition struct {
	// REQUIRED; The supported dimensions
	Dimensions []*MetricDimension `json:"dimensions,omitempty"`

	// REQUIRED; The available metric granularities
	MetricAvailabilities []*MetricAvailablity `json:"metricAvailabilities,omitempty"`

	// REQUIRED; The metric name
	Name *MetricName `json:"name,omitempty"`

	// REQUIRED; The metric aggregation type
	PrimaryAggregationType *MetricAggregationType `json:"primaryAggregationType,omitempty"`

	// REQUIRED; The metric source id
	ResourceID *string `json:"resourceId,omitempty"`

	// REQUIRED; The metric definition type
	Type *string `json:"type,omitempty"`

	// REQUIRED; The metric unit
	Unit *MetricUnit `json:"unit,omitempty"`
}

// MetricDefinitionList - List of metric definition
type MetricDefinitionList struct {
	// REQUIRED; The list of metric definition
	Value []*MetricDefinition `json:"value,omitempty"`
}

// MetricDimension - Metric dimension
type MetricDimension struct {
	// REQUIRED; Metric dimension name
	Name *string `json:"name,omitempty"`

	// REQUIRED; Metric dimension values
	Value *string `json:"value,omitempty"`
}

// MetricFilter - class representing the filters to be passed while fetching metrics
type MetricFilter struct {
	// endtime for fetching metrics
	EndTime *time.Time `json:"endTime,omitempty"`

	// filter for name property
	Name *MetricNameFilter `json:"name,omitempty"`

	// starttime for fetching metrics
	StartTime *time.Time `json:"startTime,omitempty"`

	// timegrain of the metrics
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// MetricList - Collection of metrics
type MetricList struct {
	// REQUIRED; The value.
	Value []*Metrics `json:"value,omitempty"`
}

// MetricName - The name of the metric
type MetricName struct {
	// REQUIRED; Localized name of the metric
	LocalizedValue *string `json:"localizedValue,omitempty"`

	// REQUIRED; Name of the metric
	Value *string `json:"value,omitempty"`
}

// MetricNameFilter - Class representing the name filter to be passed while fetching metrics
type MetricNameFilter struct {
	// The value.
	Value *string `json:"value,omitempty"`
}

// Metrics - Monitoring metric
type Metrics struct {
	// REQUIRED; The Metric dimension which indicates the source of the metric
	Dimensions []*MetricDimension `json:"dimensions,omitempty"`

	// REQUIRED; The metric end time
	EndTime *time.Time `json:"endTime,omitempty"`

	// REQUIRED; The name of the metrics
	Name *MetricName `json:"name,omitempty"`

	// REQUIRED; The metric aggregation type
	PrimaryAggregation *MetricAggregationType `json:"primaryAggregation,omitempty"`

	// REQUIRED; The id of metric source
	ResourceID *string `json:"resourceId,omitempty"`

	// REQUIRED; The metric start time
	StartTime *time.Time `json:"startTime,omitempty"`

	// REQUIRED; The time grain, time grain indicates frequency of the metric data
	TimeGrain *string `json:"timeGrain,omitempty"`

	// REQUIRED; The Type of the metric data
	Type *string `json:"type,omitempty"`

	// REQUIRED; The unit of the metric data
	Unit *MetricUnit `json:"unit,omitempty"`

	// REQUIRED; The metric data
	Values []*MetricData `json:"values,omitempty"`
}

// NetworkAdapter - Represents a networkAdapter in a particular node.
type NetworkAdapter struct {
	// REQUIRED; Represents state of DHCP.
	DhcpStatus *DhcpStatus `json:"dhcpStatus,omitempty"`

	// REQUIRED; The name of the network adapter.
	NetworkAdapterName *string `json:"networkAdapterName,omitempty"`

	// The ipv4 configuration of the network adapter.
	IPv4Info *IPConfig `json:"iPv4Info,omitempty"`

	// The ipv6 configuration of the network adapter.
	IPv6Info *IPConfig `json:"iPv6Info,omitempty"`

	// The speed of the network adapter.
	LinkSpeed *int64 `json:"linkSpeed,omitempty"`
}

// NetworkSettings - The NetworkSettings of a device
type NetworkSettings struct {
	// REQUIRED; Properties of the given NetworkSettings.
	Properties *NetworkSettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NetworkSettingsProperties - The properties of NetworkSettings
type NetworkSettingsProperties struct {
	// REQUIRED; The NetworkAdapters under each node of the device.
	NodeNetworks []*NodeNetwork `json:"nodeNetworks,omitempty"`

	// REQUIRED; The Primary DNS server for the device
	PrimaryDNSServer *string `json:"primaryDnsServer,omitempty"`

	// The secondary DNS server for the device
	SecondaryDNSServer *string `json:"secondaryDnsServer,omitempty"`
}

// NodeNetwork - Represents a single node in a device.
type NodeNetwork struct {
	// REQUIRED; The array of network adapters in the node.
	NetworkAdapters []*NetworkAdapter `json:"networkAdapters,omitempty"`
}

// RawCertificateData - Raw Certificate Data From IDM
type RawCertificateData struct {
	// REQUIRED; Gets or sets the base64 encoded certificate raw data string
	Certificate *string `json:"certificate,omitempty"`

	// Specify the Authentication type
	AuthType *AuthType `json:"authType,omitempty"`
}

// Resource - The Azure Resource.
type Resource struct {
	// REQUIRED; The Geo location of the Manager
	Location *string `json:"location,omitempty"`

	// Tags attached to the Manager
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceCertificateAndAADDetails - Resource Certificate And AAD Details from IDM
type ResourceCertificateAndAADDetails struct {
	// REQUIRED; AAD tenant authority
	AADAuthority *string `json:"aadAuthority,omitempty"`

	// REQUIRED; AAD tenant Id
	AADTenantID *string `json:"aadTenantId,omitempty"`

	// REQUIRED; Azure Management Endpoint Audience
	AzureManagementEndpointAudience *string `json:"azureManagementEndpointAudience,omitempty"`

	// REQUIRED; Gets or sets the base64 encoded certificate raw data string
	Certificate *string `json:"certificate,omitempty"`

	// REQUIRED; Certificate friendly name
	FriendlyName *string `json:"friendlyName,omitempty"`

	// REQUIRED; Certificate issuer
	Issuer *string `json:"issuer,omitempty"`

	// REQUIRED; Gets or Sets the ResourceId
	ResourceID *int64 `json:"resourceId,omitempty"`

	// REQUIRED; AAD service principal clientId
	ServicePrincipalClientID *string `json:"servicePrincipalClientId,omitempty"`

	// REQUIRED; AAD service principal ObjectId
	ServicePrincipalObjectID *string `json:"servicePrincipalObjectId,omitempty"`

	// REQUIRED; Certificate Subject Name
	Subject *string `json:"subject,omitempty"`

	// REQUIRED; Certificate thumbprint
	Thumbprint *string `json:"thumbprint,omitempty"`

	// REQUIRED; Certificate Validity start Date time
	ValidFrom *time.Time `json:"validFrom,omitempty"`

	// REQUIRED; Certificate Validity End Date time
	ValidTo *time.Time `json:"validTo,omitempty"`

	// Specify the Authentication type
	AuthType *AuthType `json:"authType,omitempty"`
}

// SecuritySettings - The SecuritySettings of a device
type SecuritySettings struct {
	// REQUIRED; Properties of the SecuritySettings.
	Properties *SecuritySettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SecuritySettingsProperties - The properties of SecuritySettings
type SecuritySettingsProperties struct {
	// REQUIRED; Device administrator password as an encrypted string (encrypted using RSA PKCS #1) is used to log into the local
	// web UI of the device. Actual password could have at least 8 characters that are a
	// combination of uppercase, lowercase, numeric, and special characters
	DeviceAdminPassword *AsymmetricEncryptedSecret `json:"deviceAdminPassword,omitempty"`
}

// SendTestAlertEmailRequest - Request for sending test alert email
type SendTestAlertEmailRequest struct {
	// REQUIRED; List of emails to send the test alerts
	EmailList []*string `json:"emailList,omitempty"`
}

// StorageAccountCredential - The storage account credential
type StorageAccountCredential struct {
	// REQUIRED; Credential properties
	Properties *StorageAccountCredentialProperties `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StorageAccountCredentialList - Collection of Storage account credential entities
type StorageAccountCredentialList struct {
	// REQUIRED; The value.
	Value []*StorageAccountCredential `json:"value,omitempty"`
}

// StorageAccountCredentialProperties - Storage account properties
type StorageAccountCredentialProperties struct {
	// REQUIRED; The cloud service provider
	CloudType *CloudType `json:"cloudType,omitempty"`

	// REQUIRED; SSL needs to be enabled or not
	EnableSSL *SSLStatus `json:"enableSSL,omitempty"`

	// REQUIRED; The storage endpoint
	EndPoint *string `json:"endPoint,omitempty"`

	// REQUIRED; The storage account login
	Login *string `json:"login,omitempty"`

	// The details of the storage account password
	AccessKey *AsymmetricEncryptedSecret `json:"accessKey,omitempty"`

	// The storage account's geo location
	Location *string `json:"location,omitempty"`
}

// StorageAccountCredentialsClientBeginCreateOrUpdateOptions contains the optional parameters for the StorageAccountCredentialsClient.BeginCreateOrUpdate
// method.
type StorageAccountCredentialsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StorageAccountCredentialsClientBeginDeleteOptions contains the optional parameters for the StorageAccountCredentialsClient.BeginDelete
// method.
type StorageAccountCredentialsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StorageAccountCredentialsClientGetOptions contains the optional parameters for the StorageAccountCredentialsClient.Get
// method.
type StorageAccountCredentialsClientGetOptions struct {
	// placeholder for future optional parameters
}

// StorageAccountCredentialsClientListByManagerOptions contains the optional parameters for the StorageAccountCredentialsClient.ListByManager
// method.
type StorageAccountCredentialsClientListByManagerOptions struct {
	// placeholder for future optional parameters
}

// StorageDomain - The storage domain.
type StorageDomain struct {
	// REQUIRED; The properties.
	Properties *StorageDomainProperties `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StorageDomainList - Collection of storage domains
type StorageDomainList struct {
	// REQUIRED; The value.
	Value []*StorageDomain `json:"value,omitempty"`
}

// StorageDomainProperties - The storage domain properties.
type StorageDomainProperties struct {
	// REQUIRED; The encryption status "Enabled | Disabled".
	EncryptionStatus *EncryptionStatus `json:"encryptionStatus,omitempty"`

	// REQUIRED; The storage account credentials.
	StorageAccountCredentialIDs []*string `json:"storageAccountCredentialIds,omitempty"`

	// The encryption key used to encrypt the data. This is a user secret.
	EncryptionKey *AsymmetricEncryptedSecret `json:"encryptionKey,omitempty"`
}

// StorageDomainsClientBeginCreateOrUpdateOptions contains the optional parameters for the StorageDomainsClient.BeginCreateOrUpdate
// method.
type StorageDomainsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StorageDomainsClientBeginDeleteOptions contains the optional parameters for the StorageDomainsClient.BeginDelete method.
type StorageDomainsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StorageDomainsClientGetOptions contains the optional parameters for the StorageDomainsClient.Get method.
type StorageDomainsClientGetOptions struct {
	// placeholder for future optional parameters
}

// StorageDomainsClientListByManagerOptions contains the optional parameters for the StorageDomainsClient.ListByManager method.
type StorageDomainsClientListByManagerOptions struct {
	// placeholder for future optional parameters
}

// SymmetricEncryptedSecret - This class can be used as the Type for any secret entity represented as Value, ValueCertificateThumbprint,
// EncryptionAlgorithm. In this case, "Value" is a secret and the "valueThumbprint" represents
// the certificate thumbprint of the value. The algorithm field is mainly for future usage to potentially allow different
// entities encrypted using different algorithms.
type SymmetricEncryptedSecret struct {
	// REQUIRED; Algorithm used to encrypt "Value"
	EncryptionAlgorithm *EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`

	// REQUIRED; The value of the secret itself. If the secret is in plaintext or null then EncryptionAlgorithm will be none
	Value *string `json:"value,omitempty"`

	// Thumbprint cert that was used to encrypt "Value"
	ValueCertificateThumbprint *string `json:"valueCertificateThumbprint,omitempty"`
}

// Time - The Time.
type Time struct {
	// REQUIRED; The hour.
	Hour *int32 `json:"hour,omitempty"`

	// REQUIRED; The minute.
	Minute *int32 `json:"minute,omitempty"`
}

// TimeSettings - The TimeSettings of a device
type TimeSettings struct {
	// REQUIRED; Properties of the TimeSettings.
	Properties *TimeSettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TimeSettingsProperties - The properties of TimeSettings
type TimeSettingsProperties struct {
	// REQUIRED; The primary Network Time Protocol (NTP) server name, like 'time.windows.com'.
	PrimaryTimeServer *string `json:"primaryTimeServer,omitempty"`

	// REQUIRED; The timezone of device, like '(UTC -06:00) Central America'
	TimeZone *string `json:"timeZone,omitempty"`

	// The secondary Network Time Protocol (NTP) server name, like 'time.contoso.com'. It's optional.
	SecondaryTimeServer *string `json:"secondaryTimeServer,omitempty"`
}

// UpdateDownloadProgress - details available during the download
type UpdateDownloadProgress struct {
	// The download phase.
	DownloadPhase *DownloadPhase `json:"downloadPhase,omitempty"`

	// Number of updates downloaded.
	NumberOfUpdatesDownloaded *int32 `json:"numberOfUpdatesDownloaded,omitempty"`

	// Number of updates to download.
	NumberOfUpdatesToDownload *int32 `json:"numberOfUpdatesToDownload,omitempty"`

	// Percentage of completion.
	PercentComplete *int32 `json:"percentComplete,omitempty"`

	// Total bytes downloaded.
	TotalBytesDownloaded *float64 `json:"totalBytesDownloaded,omitempty"`

	// Total bytes to download.
	TotalBytesToDownload *float64 `json:"totalBytesToDownload,omitempty"`
}

// UpdateInstallProgress - Class representing the progress during installation of updates
type UpdateInstallProgress struct {
	// Number of updates installed.
	NumberOfUpdatesInstalled *int32 `json:"numberOfUpdatesInstalled,omitempty"`

	// Number of updates to install.
	NumberOfUpdatesToInstall *int32 `json:"numberOfUpdatesToInstall,omitempty"`

	// Percentage of completion.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
}

// Updates - The updates profile
type Updates struct {
	// Update properties.
	Properties *UpdatesProperties `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UpdatesProperties - Properties of the update profile
type UpdatesProperties struct {
	// The last time when the device did an update scan.
	DeviceLastScannedTime *time.Time `json:"deviceLastScannedTime,omitempty"`

	// The current Device version.
	DeviceVersion *string `json:"deviceVersion,omitempty"`

	// If a download is in progress, this field contains the JobId of that particular download job
	InProgressDownloadJobID *string `json:"inProgressDownloadJobId,omitempty"`

	// The time when the currently running download (if any) started
	InProgressDownloadJobStartedTime *time.Time `json:"inProgressDownloadJobStartedTime,omitempty"`

	// If an install is in progress, this field contains the JobId of that particular install job
	InProgressInstallJobID *string `json:"inProgressInstallJobId,omitempty"`

	// The time when the currently running install (if any) started
	InProgressInstallJobStartedTime *time.Time `json:"inProgressInstallJobStartedTime,omitempty"`

	// The time when the currently running scan (if any) started
	InProgressScanStartedTime *time.Time `json:"inProgressScanStartedTime,omitempty"`

	// The time when the last Download job was completed (success|cancelled|failed) on the device.
	LastCompletedDownloadJobTime *time.Time `json:"lastCompletedDownloadJobTime,omitempty"`

	// The time when the last Install job was completed (success|cancelled|failed) on the device.
	LastCompletedInstallJobTime *time.Time `json:"lastCompletedInstallJobTime,omitempty"`

	// The time when the last scan job was completed (success|cancelled|failed) on the device.
	LastCompletedScanTime *time.Time `json:"lastCompletedScanTime,omitempty"`

	// Set to true if RegularUpdatesAvailable is true and if at least one of the updateItems detected has needs a reboot to install.
	RebootRequiredForInstall *bool `json:"rebootRequiredForInstall,omitempty"`

	// Set to true if regular updates were detected for the current version of the device.
	RegularUpdatesAvailable *bool `json:"regularUpdatesAvailable,omitempty"`

	// The current update operation.
	Status *UpdateOperation `json:"status,omitempty"`

	// The total number of items pending for download.
	TotalItemsPendingForDownload *int32 `json:"totalItemsPendingForDownload,omitempty"`

	// The total number of items pending for install.
	TotalItemsPendingForInstall *int32 `json:"totalItemsPendingForInstall,omitempty"`
}

// UploadCertificateRequest - Upload Certificate Request to IDM
type UploadCertificateRequest struct {
	// REQUIRED; Raw Certificate Data From IDM
	Properties *RawCertificateData `json:"properties,omitempty"`

	// READ-ONLY; Gets ContractVersion
	ContractVersion *ContractVersions `json:"contractVersion,omitempty" azure:"ro"`
}

// UploadCertificateResponse - Upload Certificate Response from IDM
type UploadCertificateResponse struct {
	// REQUIRED; Resource Certificate And AAD Details from IDM
	Properties *ResourceCertificateAndAADDetails `json:"properties,omitempty"`

	// READ-ONLY; The identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type.
	Type *string `json:"type,omitempty" azure:"ro"`
}
