//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorageimportexport

import "time"

// BitLockerKeysClientListOptions contains the optional parameters for the BitLockerKeysClient.List method.
type BitLockerKeysClientListOptions struct {
}

// DeliveryPackageInformation - Contains information about the delivery package being shipped by the customer to the Microsoft
// data center.
type DeliveryPackageInformation struct {
	// REQUIRED; The name of the carrier that is used to ship the import or export drives.
	CarrierName *string `json:"carrierName,omitempty"`

	// REQUIRED; The tracking number of the package.
	TrackingNumber *string `json:"trackingNumber,omitempty"`

	// The number of drives included in the package.
	DriveCount *int64 `json:"driveCount,omitempty"`

	// The date when the package is shipped.
	ShipDate *string `json:"shipDate,omitempty"`
}

// DriveBitLockerKey - BitLocker recovery key or password to the specified drive
type DriveBitLockerKey struct {
	// BitLocker recovery key or password
	BitLockerKey *string `json:"bitLockerKey,omitempty"`

	// Drive ID
	DriveID *string `json:"driveId,omitempty"`
}

// DriveStatus - Provides information about the drive's status
type DriveStatus struct {
	// The BitLocker key used to encrypt the drive.
	BitLockerKey *string `json:"bitLockerKey,omitempty"`

	// Bytes successfully transferred for the drive.
	BytesSucceeded *int64 `json:"bytesSucceeded,omitempty"`

	// Detailed status about the data transfer process. This field is not returned in the response until the drive is in the Transferring
	// state.
	CopyStatus *string `json:"copyStatus,omitempty"`

	// The drive header hash value.
	DriveHeaderHash *string `json:"driveHeaderHash,omitempty"`

	// The drive's hardware serial number, without spaces.
	DriveID *string `json:"driveId,omitempty"`

	// A URI that points to the blob containing the error log for the data transfer operation.
	ErrorLogURI *string `json:"errorLogUri,omitempty"`

	// The relative path of the manifest file on the drive.
	ManifestFile *string `json:"manifestFile,omitempty"`

	// The Base16-encoded MD5 hash of the manifest file on the drive.
	ManifestHash *string `json:"manifestHash,omitempty"`

	// A URI that points to the blob containing the drive manifest file.
	ManifestURI *string `json:"manifestUri,omitempty"`

	// Percentage completed for the drive.
	PercentComplete *int64 `json:"percentComplete,omitempty"`

	// The drive's current state.
	State *DriveState `json:"state,omitempty"`

	// A URI that points to the blob containing the verbose log for the data transfer operation.
	VerboseLogURI *string `json:"verboseLogUri,omitempty"`
}

// EncryptionKeyDetails - Specifies the encryption key properties
type EncryptionKeyDetails struct {
	// The type of kek encryption key
	KekType *EncryptionKekType `json:"kekType,omitempty"`

	// Specifies the url for kek encryption key.
	KekURL *string `json:"kekUrl,omitempty"`

	// Specifies the keyvault resource id for kek encryption key.
	KekVaultResourceID *string `json:"kekVaultResourceID,omitempty"`
}

// ErrorResponse - Response when errors occurred
type ErrorResponse struct {
	// Describes the error information.
	Error *ErrorResponseError `json:"error,omitempty"`
}

// ErrorResponseError - Describes the error information.
type ErrorResponseError struct {
	// Provides information about the error code.
	Code *string `json:"code,omitempty"`

	// Describes the error details if present.
	Details []*ErrorResponseErrorDetailsItem `json:"details,omitempty"`

	// Inner error object if present.
	Innererror interface{} `json:"innererror,omitempty"`

	// Provides information about the error message.
	Message *string `json:"message,omitempty"`

	// Provides information about the error target.
	Target *string `json:"target,omitempty"`
}

type ErrorResponseErrorDetailsItem struct {
	// Provides information about the error code.
	Code *string `json:"code,omitempty"`

	// Provides information about the error message.
	Message *string `json:"message,omitempty"`

	// Provides information about the error target.
	Target *string `json:"target,omitempty"`
}

// Export - A property containing information about the blobs to be exported for an export job. This property is required
// for export jobs, but must not be specified for import jobs.
type Export struct {
	// A list of the blobs to be exported.
	BlobList *ExportBlobList `json:"blobList,omitempty"`

	// The relative URI to the block blob that contains the list of blob paths or blob path prefixes as defined above, beginning
	// with the container name. If the blob is in root container, the URI must begin
	// with $root.
	BlobListBlobPath *string `json:"blobListBlobPath,omitempty"`
}

// ExportBlobList - A list of the blobs to be exported.
type ExportBlobList struct {
	// A collection of blob-path strings.
	BlobPath []*string `json:"blobPath,omitempty"`

	// A collection of blob-prefix strings.
	BlobPathPrefix []*string `json:"blobPathPrefix,omitempty"`
}

// GetBitLockerKeysResponse - GetBitLockerKeys response
type GetBitLockerKeysResponse struct {
	// drive status
	Value []*DriveBitLockerKey `json:"value,omitempty"`
}

// IdentityDetails - Specifies the identity properties.
type IdentityDetails struct {
	// The type of identity
	Type *IdentityType `json:"type,omitempty"`

	// READ-ONLY; Specifies the principal id for the identity for the job.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the tenant id for the identity for the job.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// JobDetails - Specifies the job properties
type JobDetails struct {
	// Default value is false. Indicates whether the manifest files on the drives should be copied to block blobs.
	BackupDriveManifest *bool `json:"backupDriveManifest,omitempty"`

	// Indicates whether a request has been submitted to cancel the job.
	CancelRequested *bool `json:"cancelRequested,omitempty"`

	// Contains information about the package being shipped by the customer to the Microsoft data center.
	DeliveryPackage *DeliveryPackageInformation `json:"deliveryPackage,omitempty"`

	// The virtual blob directory to which the copy logs and backups of drive manifest files (if enabled) will be stored.
	DiagnosticsPath *string `json:"diagnosticsPath,omitempty"`

	// List of up to ten drives that comprise the job. The drive list is a required element for an import job; it is not specified
	// for export jobs.
	DriveList []*DriveStatus `json:"driveList,omitempty"`

	// Contains information about the encryption key.
	EncryptionKey *EncryptionKeyDetails `json:"encryptionKey,omitempty"`

	// A property containing information about the blobs to be exported for an export job. This property is included for export
	// jobs only.
	Export *Export `json:"export,omitempty"`

	// A blob path that points to a block blob containing a list of blob names that were not exported due to insufficient drive
	// space. If all blobs were exported successfully, then this element is not
	// included in the response.
	IncompleteBlobListURI *string `json:"incompleteBlobListUri,omitempty"`

	// The type of job
	JobType *string `json:"jobType,omitempty"`

	// Default value is Error. Indicates whether error logging or verbose logging will be enabled.
	LogLevel *string `json:"logLevel,omitempty"`

	// Overall percentage completed for the job.
	PercentComplete *int64 `json:"percentComplete,omitempty"`

	// Specifies the provisioning state of the job.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// Specifies the return address information for the job.
	ReturnAddress *ReturnAddress `json:"returnAddress,omitempty"`

	// Contains information about the package being shipped from the Microsoft data center to the customer to return the drives.
	// The format is the same as the deliveryPackage property above. This property is
	// not included if the drives have not yet been returned.
	ReturnPackage *PackageInformation `json:"returnPackage,omitempty"`

	// Specifies the return carrier and customer's account with the carrier.
	ReturnShipping *ReturnShipping `json:"returnShipping,omitempty"`

	// Contains information about the Microsoft datacenter to which the drives should be shipped.
	ShippingInformation *ShippingInformation `json:"shippingInformation,omitempty"`

	// Current state of the job.
	State *string `json:"state,omitempty"`

	// The resource identifier of the storage account where data will be imported to or exported from.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
}

// JobResponse - Contains the job information.
type JobResponse struct {
	// Specifies the job identity details
	Identity *IdentityDetails `json:"identity,omitempty"`

	// Specifies the Azure location where the job is created.
	Location *string `json:"location,omitempty"`

	// Specifies the job properties
	Properties *JobDetails `json:"properties,omitempty"`

	// Specifies the tags that are assigned to the job.
	Tags interface{} `json:"tags,omitempty"`

	// READ-ONLY; Specifies the resource identifier of the job.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the name of the job.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; SystemData of ImportExport Jobs.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the type of the job resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JobsClientCreateOptions contains the optional parameters for the JobsClient.Create method.
type JobsClientCreateOptions struct {
	// The tenant ID of the client making the request.
	ClientTenantID *string
}

// JobsClientDeleteOptions contains the optional parameters for the JobsClient.Delete method.
type JobsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// JobsClientGetOptions contains the optional parameters for the JobsClient.Get method.
type JobsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JobsClientListByResourceGroupOptions contains the optional parameters for the JobsClient.ListByResourceGroup method.
type JobsClientListByResourceGroupOptions struct {
	// Can be used to restrict the results to certain conditions.
	Filter *string
	// An integer value that specifies how many jobs at most should be returned. The value cannot exceed 100.
	Top *int64
}

// JobsClientListBySubscriptionOptions contains the optional parameters for the JobsClient.ListBySubscription method.
type JobsClientListBySubscriptionOptions struct {
	// Can be used to restrict the results to certain conditions.
	Filter *string
	// An integer value that specifies how many jobs at most should be returned. The value cannot exceed 100.
	Top *int64
}

// JobsClientUpdateOptions contains the optional parameters for the JobsClient.Update method.
type JobsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ListJobsResponse - List jobs response
type ListJobsResponse struct {
	// link to next batch of jobs
	NextLink *string `json:"nextLink,omitempty"`

	// Job list
	Value []*JobResponse `json:"value,omitempty"`
}

// ListOperationsResponse - List operations response
type ListOperationsResponse struct {
	// operations
	Value []*Operation `json:"value,omitempty"`
}

// Location - Provides information about an Azure data center location.
type Location struct {
	// Specifies the resource identifier of the location.
	ID *string `json:"id,omitempty"`

	// Specifies the name of the location. Use List Locations to get all supported locations.
	Name *string `json:"name,omitempty"`

	// location properties
	Properties *LocationProperties `json:"properties,omitempty"`

	// Specifies the type of the location.
	Type *string `json:"type,omitempty"`
}

// LocationProperties - location properties
type LocationProperties struct {
	// Additional shipping information for customer, specific to datacenter to which customer should send their disks.
	AdditionalShippingInformation *string `json:"additionalShippingInformation,omitempty"`

	// A list of location IDs that should be used to ship shipping drives to for jobs created against the current location. If
	// the current location is active, it will be part of the list. If it is
	// temporarily closed due to maintenance, this list may contain other locations.
	AlternateLocations []*string `json:"alternateLocations,omitempty"`

	// The city name to use when shipping the drives to the Azure data center.
	City *string `json:"city,omitempty"`

	// The country or region to use when shipping the drives to the Azure data center.
	CountryOrRegion *string `json:"countryOrRegion,omitempty"`

	// The phone number for the Azure data center.
	Phone *string `json:"phone,omitempty"`

	// The postal code to use when shipping the drives to the Azure data center.
	PostalCode *string `json:"postalCode,omitempty"`

	// The recipient name to use when shipping the drives to the Azure data center.
	RecipientName *string `json:"recipientName,omitempty"`

	// The state or province to use when shipping the drives to the Azure data center.
	StateOrProvince *string `json:"stateOrProvince,omitempty"`

	// The first line of the street address to use when shipping the drives to the Azure data center.
	StreetAddress1 *string `json:"streetAddress1,omitempty"`

	// The second line of the street address to use when shipping the drives to the Azure data center.
	StreetAddress2 *string `json:"streetAddress2,omitempty"`

	// A list of carriers that are supported at this location.
	SupportedCarriers []*string `json:"supportedCarriers,omitempty"`
}

// LocationsClientGetOptions contains the optional parameters for the LocationsClient.Get method.
type LocationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// LocationsClientListOptions contains the optional parameters for the LocationsClient.List method.
type LocationsClientListOptions struct {
}

// LocationsResponse - Locations response
type LocationsResponse struct {
	// locations
	Value []*Location `json:"value,omitempty"`
}

// Operation - Describes a supported operation by the Storage Import/Export job API.
type Operation struct {
	// REQUIRED; operation display properties
	Display *OperationDisplay `json:"display,omitempty"`

	// REQUIRED; Name of the operation.
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - operation display properties
type OperationDisplay struct {
	// Short description of the operation.
	Description *string `json:"description,omitempty"`

	// The display name of the operation.
	Operation *string `json:"operation,omitempty"`

	// The resource provider name to which the operation belongs.
	Provider *string `json:"provider,omitempty"`

	// The name of the resource to which the operation belongs.
	Resource *string `json:"resource,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
}

// PackageInformation - Contains information about the package being shipped by the customer to the Microsoft data center.
type PackageInformation struct {
	// REQUIRED; The name of the carrier that is used to ship the import or export drives.
	CarrierName *string `json:"carrierName,omitempty"`

	// REQUIRED; The number of drives included in the package.
	DriveCount *int64 `json:"driveCount,omitempty"`

	// REQUIRED; The date when the package is shipped.
	ShipDate *string `json:"shipDate,omitempty"`

	// REQUIRED; The tracking number of the package.
	TrackingNumber *string `json:"trackingNumber,omitempty"`
}

// PutJobParameters - Put Job parameters
type PutJobParameters struct {
	// Specifies the supported Azure location where the job should be created
	Location *string `json:"location,omitempty"`

	// Specifies the job properties
	Properties *JobDetails `json:"properties,omitempty"`

	// Specifies the tags that will be assigned to the job.
	Tags interface{} `json:"tags,omitempty"`
}

// ReturnAddress - Specifies the return address information for the job.
type ReturnAddress struct {
	// REQUIRED; The city name to use when returning the drives.
	City *string `json:"city,omitempty"`

	// REQUIRED; The country or region to use when returning the drives.
	CountryOrRegion *string `json:"countryOrRegion,omitempty"`

	// REQUIRED; Email address of the recipient of the returned drives.
	Email *string `json:"email,omitempty"`

	// REQUIRED; Phone number of the recipient of the returned drives.
	Phone *string `json:"phone,omitempty"`

	// REQUIRED; The postal code to use when returning the drives.
	PostalCode *string `json:"postalCode,omitempty"`

	// REQUIRED; The name of the recipient who will receive the hard drives when they are returned.
	RecipientName *string `json:"recipientName,omitempty"`

	// REQUIRED; The first line of the street address to use when returning the drives.
	StreetAddress1 *string `json:"streetAddress1,omitempty"`

	// The state or province to use when returning the drives.
	StateOrProvince *string `json:"stateOrProvince,omitempty"`

	// The second line of the street address to use when returning the drives.
	StreetAddress2 *string `json:"streetAddress2,omitempty"`
}

// ReturnShipping - Specifies the return carrier and customer's account with the carrier.
type ReturnShipping struct {
	// REQUIRED; The customer's account number with the carrier.
	CarrierAccountNumber *string `json:"carrierAccountNumber,omitempty"`

	// REQUIRED; The carrier's name.
	CarrierName *string `json:"carrierName,omitempty"`
}

// ShippingInformation - Contains information about the Microsoft datacenter to which the drives should be shipped.
type ShippingInformation struct {
	// The city name to use when returning the drives.
	City *string `json:"city,omitempty"`

	// The country or region to use when returning the drives.
	CountryOrRegion *string `json:"countryOrRegion,omitempty"`

	// Phone number of the recipient of the returned drives.
	Phone *string `json:"phone,omitempty"`

	// The postal code to use when returning the drives.
	PostalCode *string `json:"postalCode,omitempty"`

	// The name of the recipient who will receive the hard drives when they are returned.
	RecipientName *string `json:"recipientName,omitempty"`

	// The state or province to use when returning the drives.
	StateOrProvince *string `json:"stateOrProvince,omitempty"`

	// The first line of the street address to use when returning the drives.
	StreetAddress1 *string `json:"streetAddress1,omitempty"`

	// The second line of the street address to use when returning the drives.
	StreetAddress2 *string `json:"streetAddress2,omitempty"`

	// READ-ONLY; Additional shipping information for customer, specific to datacenter to which customer should send their disks.
	AdditionalInformation *string `json:"additionalInformation,omitempty" azure:"ro"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// UpdateJobParameters - Update Job parameters
type UpdateJobParameters struct {
	// Specifies the properties of a UpdateJob.
	Properties *UpdateJobParametersProperties `json:"properties,omitempty"`

	// Specifies the tags that will be assigned to the job
	Tags interface{} `json:"tags,omitempty"`
}

// UpdateJobParametersProperties - Specifies the properties of a UpdateJob.
type UpdateJobParametersProperties struct {
	// Indicates whether the manifest files on the drives should be copied to block blobs.
	BackupDriveManifest *bool `json:"backupDriveManifest,omitempty"`

	// If specified, the value must be true. The service will attempt to cancel the job.
	CancelRequested *bool `json:"cancelRequested,omitempty"`

	// Contains information about the package being shipped by the customer to the Microsoft data center.
	DeliveryPackage *DeliveryPackageInformation `json:"deliveryPackage,omitempty"`

	// List of drives that comprise the job.
	DriveList []*DriveStatus `json:"driveList,omitempty"`

	// Indicates whether error logging or verbose logging is enabled.
	LogLevel *string `json:"logLevel,omitempty"`

	// Specifies the return address information for the job.
	ReturnAddress *ReturnAddress `json:"returnAddress,omitempty"`

	// Specifies the return carrier and customer's account with the carrier.
	ReturnShipping *ReturnShipping `json:"returnShipping,omitempty"`

	// If specified, the value must be Shipping, which tells the Import/Export service that the package for the job has been shipped.
	// The ReturnAddress and DeliveryPackage properties must have been set
	// either in this request or in a previous request, otherwise the request will fail.
	State *string `json:"state,omitempty"`
}
