//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armresourcemover

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// MoveCollectionsClient contains the methods for the MoveCollections group.
// Don't use this type directly, use NewMoveCollectionsClient() instead.
type MoveCollectionsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewMoveCollectionsClient creates a new instance of MoveCollectionsClient with the specified values.
// subscriptionID - The Subscription ID.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewMoveCollectionsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*MoveCollectionsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &MoveCollectionsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginBulkRemove - Removes the set of move resources included in the request body from move collection. The orchestration
// is done by service. To aid the user to prerequisite the operation the client can call operation
// with validateOnly property set to true.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
// options - MoveCollectionsClientBeginBulkRemoveOptions contains the optional parameters for the MoveCollectionsClient.BeginBulkRemove
// method.
func (client *MoveCollectionsClient) BeginBulkRemove(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginBulkRemoveOptions) (*runtime.Poller[MoveCollectionsClientBulkRemoveResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.bulkRemove(ctx, resourceGroupName, moveCollectionName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[MoveCollectionsClientBulkRemoveResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
		})
	} else {
		return runtime.NewPollerFromResumeToken[MoveCollectionsClientBulkRemoveResponse](options.ResumeToken, client.pl, nil)
	}
}

// BulkRemove - Removes the set of move resources included in the request body from move collection. The orchestration is
// done by service. To aid the user to prerequisite the operation the client can call operation
// with validateOnly property set to true.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
func (client *MoveCollectionsClient) bulkRemove(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginBulkRemoveOptions) (*http.Response, error) {
	req, err := client.bulkRemoveCreateRequest(ctx, resourceGroupName, moveCollectionName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// bulkRemoveCreateRequest creates the BulkRemove request.
func (client *MoveCollectionsClient) bulkRemoveCreateRequest(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginBulkRemoveOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}/bulkRemove"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if moveCollectionName == "" {
		return nil, errors.New("parameter moveCollectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{moveCollectionName}", url.PathEscape(moveCollectionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Body != nil {
		return req, runtime.MarshalAsJSON(req, *options.Body)
	}
	return req, nil
}

// BeginCommit - Commits the set of resources included in the request body. The commit operation is triggered on the moveResources
// in the moveState 'CommitPending' or 'CommitFailed', on a successful completion the
// moveResource moveState do a transition to Committed. To aid the user to prerequisite the operation the client can call
// operation with validateOnly property set to true.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
// resourceGroupName - The Resource Group Name.
// moveCollectionName - The Move Collection Name.
// options - MoveCollectionsClientBeginCommitOptions contains the optional parameters for the MoveCollectionsClient.BeginCommit
// method.
func (client *MoveCollectionsClient) BeginCommit(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginCommitOptions) (*runtime.Poller[MoveCollectionsClientCommitResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.commit(ctx, resourceGroupName, moveCollectionName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[MoveCollectionsClientCommitResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
		})
	} else {
		return runtime.NewPollerFromResumeToken[MoveCollectionsClientCommitResponse](options.ResumeToken, client.pl, nil)
	}
}

// Commit - Commits the set of resources included in the request body. The commit operation is triggered on the moveResources
// in the moveState 'CommitPending' or 'CommitFailed', on a successful completion the
// moveResource moveState do a transition to Committed. To aid the user to prerequisite the operation the client can call
// operation with validateOnly property set to true.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
func (client *MoveCollectionsClient) commit(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginCommitOptions) (*http.Response, error) {
	req, err := client.commitCreateRequest(ctx, resourceGroupName, moveCollectionName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// commitCreateRequest creates the Commit request.
func (client *MoveCollectionsClient) commitCreateRequest(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginCommitOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}/commit"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if moveCollectionName == "" {
		return nil, errors.New("parameter moveCollectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{moveCollectionName}", url.PathEscape(moveCollectionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Body != nil {
		return req, runtime.MarshalAsJSON(req, *options.Body)
	}
	return req, nil
}

// Create - Creates or updates a move collection.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
// resourceGroupName - The Resource Group Name.
// moveCollectionName - The Move Collection Name.
// options - MoveCollectionsClientCreateOptions contains the optional parameters for the MoveCollectionsClient.Create method.
func (client *MoveCollectionsClient) Create(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientCreateOptions) (MoveCollectionsClientCreateResponse, error) {
	req, err := client.createCreateRequest(ctx, resourceGroupName, moveCollectionName, options)
	if err != nil {
		return MoveCollectionsClientCreateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return MoveCollectionsClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return MoveCollectionsClientCreateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createHandleResponse(resp)
}

// createCreateRequest creates the Create request.
func (client *MoveCollectionsClient) createCreateRequest(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if moveCollectionName == "" {
		return nil, errors.New("parameter moveCollectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{moveCollectionName}", url.PathEscape(moveCollectionName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Body != nil {
		return req, runtime.MarshalAsJSON(req, *options.Body)
	}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *MoveCollectionsClient) createHandleResponse(resp *http.Response) (MoveCollectionsClientCreateResponse, error) {
	result := MoveCollectionsClientCreateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MoveCollection); err != nil {
		return MoveCollectionsClientCreateResponse{}, err
	}
	return result, nil
}

// BeginDelete - Deletes a move collection.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
// resourceGroupName - The Resource Group Name.
// moveCollectionName - The Move Collection Name.
// options - MoveCollectionsClientBeginDeleteOptions contains the optional parameters for the MoveCollectionsClient.BeginDelete
// method.
func (client *MoveCollectionsClient) BeginDelete(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginDeleteOptions) (*runtime.Poller[MoveCollectionsClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, moveCollectionName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[MoveCollectionsClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
		})
	} else {
		return runtime.NewPollerFromResumeToken[MoveCollectionsClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Deletes a move collection.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
func (client *MoveCollectionsClient) deleteOperation(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, moveCollectionName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *MoveCollectionsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if moveCollectionName == "" {
		return nil, errors.New("parameter moveCollectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{moveCollectionName}", url.PathEscape(moveCollectionName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDiscard - Discards the set of resources included in the request body. The discard operation is triggered on the moveResources
// in the moveState 'CommitPending' or 'DiscardFailed', on a successful completion the
// moveResource moveState do a transition to MovePending. To aid the user to prerequisite the operation the client can call
// operation with validateOnly property set to true.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
// resourceGroupName - The Resource Group Name.
// moveCollectionName - The Move Collection Name.
// options - MoveCollectionsClientBeginDiscardOptions contains the optional parameters for the MoveCollectionsClient.BeginDiscard
// method.
func (client *MoveCollectionsClient) BeginDiscard(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginDiscardOptions) (*runtime.Poller[MoveCollectionsClientDiscardResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.discard(ctx, resourceGroupName, moveCollectionName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[MoveCollectionsClientDiscardResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
		})
	} else {
		return runtime.NewPollerFromResumeToken[MoveCollectionsClientDiscardResponse](options.ResumeToken, client.pl, nil)
	}
}

// Discard - Discards the set of resources included in the request body. The discard operation is triggered on the moveResources
// in the moveState 'CommitPending' or 'DiscardFailed', on a successful completion the
// moveResource moveState do a transition to MovePending. To aid the user to prerequisite the operation the client can call
// operation with validateOnly property set to true.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
func (client *MoveCollectionsClient) discard(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginDiscardOptions) (*http.Response, error) {
	req, err := client.discardCreateRequest(ctx, resourceGroupName, moveCollectionName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// discardCreateRequest creates the Discard request.
func (client *MoveCollectionsClient) discardCreateRequest(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginDiscardOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}/discard"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if moveCollectionName == "" {
		return nil, errors.New("parameter moveCollectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{moveCollectionName}", url.PathEscape(moveCollectionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Body != nil {
		return req, runtime.MarshalAsJSON(req, *options.Body)
	}
	return req, nil
}

// Get - Gets the move collection.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
// resourceGroupName - The Resource Group Name.
// moveCollectionName - The Move Collection Name.
// options - MoveCollectionsClientGetOptions contains the optional parameters for the MoveCollectionsClient.Get method.
func (client *MoveCollectionsClient) Get(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientGetOptions) (MoveCollectionsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, moveCollectionName, options)
	if err != nil {
		return MoveCollectionsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return MoveCollectionsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return MoveCollectionsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *MoveCollectionsClient) getCreateRequest(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if moveCollectionName == "" {
		return nil, errors.New("parameter moveCollectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{moveCollectionName}", url.PathEscape(moveCollectionName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *MoveCollectionsClient) getHandleResponse(resp *http.Response) (MoveCollectionsClientGetResponse, error) {
	result := MoveCollectionsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MoveCollection); err != nil {
		return MoveCollectionsClientGetResponse{}, err
	}
	return result, nil
}

// BeginInitiateMove - Moves the set of resources included in the request body. The move operation is triggered after the
// moveResources are in the moveState 'MovePending' or 'MoveFailed', on a successful completion the
// moveResource moveState do a transition to CommitPending. To aid the user to prerequisite the operation the client can call
// operation with validateOnly property set to true.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
// resourceGroupName - The Resource Group Name.
// moveCollectionName - The Move Collection Name.
// options - MoveCollectionsClientBeginInitiateMoveOptions contains the optional parameters for the MoveCollectionsClient.BeginInitiateMove
// method.
func (client *MoveCollectionsClient) BeginInitiateMove(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginInitiateMoveOptions) (*runtime.Poller[MoveCollectionsClientInitiateMoveResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.initiateMove(ctx, resourceGroupName, moveCollectionName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[MoveCollectionsClientInitiateMoveResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
		})
	} else {
		return runtime.NewPollerFromResumeToken[MoveCollectionsClientInitiateMoveResponse](options.ResumeToken, client.pl, nil)
	}
}

// InitiateMove - Moves the set of resources included in the request body. The move operation is triggered after the moveResources
// are in the moveState 'MovePending' or 'MoveFailed', on a successful completion the
// moveResource moveState do a transition to CommitPending. To aid the user to prerequisite the operation the client can call
// operation with validateOnly property set to true.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
func (client *MoveCollectionsClient) initiateMove(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginInitiateMoveOptions) (*http.Response, error) {
	req, err := client.initiateMoveCreateRequest(ctx, resourceGroupName, moveCollectionName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// initiateMoveCreateRequest creates the InitiateMove request.
func (client *MoveCollectionsClient) initiateMoveCreateRequest(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginInitiateMoveOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}/initiateMove"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if moveCollectionName == "" {
		return nil, errors.New("parameter moveCollectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{moveCollectionName}", url.PathEscape(moveCollectionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Body != nil {
		return req, runtime.MarshalAsJSON(req, *options.Body)
	}
	return req, nil
}

// NewListMoveCollectionsByResourceGroupPager - Get all the Move Collections in the resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
// resourceGroupName - The Resource Group Name.
// options - MoveCollectionsClientListMoveCollectionsByResourceGroupOptions contains the optional parameters for the MoveCollectionsClient.ListMoveCollectionsByResourceGroup
// method.
func (client *MoveCollectionsClient) NewListMoveCollectionsByResourceGroupPager(resourceGroupName string, options *MoveCollectionsClientListMoveCollectionsByResourceGroupOptions) *runtime.Pager[MoveCollectionsClientListMoveCollectionsByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[MoveCollectionsClientListMoveCollectionsByResourceGroupResponse]{
		More: func(page MoveCollectionsClientListMoveCollectionsByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *MoveCollectionsClientListMoveCollectionsByResourceGroupResponse) (MoveCollectionsClientListMoveCollectionsByResourceGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listMoveCollectionsByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return MoveCollectionsClientListMoveCollectionsByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return MoveCollectionsClientListMoveCollectionsByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return MoveCollectionsClientListMoveCollectionsByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMoveCollectionsByResourceGroupHandleResponse(resp)
		},
	})
}

// listMoveCollectionsByResourceGroupCreateRequest creates the ListMoveCollectionsByResourceGroup request.
func (client *MoveCollectionsClient) listMoveCollectionsByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *MoveCollectionsClientListMoveCollectionsByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMoveCollectionsByResourceGroupHandleResponse handles the ListMoveCollectionsByResourceGroup response.
func (client *MoveCollectionsClient) listMoveCollectionsByResourceGroupHandleResponse(resp *http.Response) (MoveCollectionsClientListMoveCollectionsByResourceGroupResponse, error) {
	result := MoveCollectionsClientListMoveCollectionsByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MoveCollectionResultList); err != nil {
		return MoveCollectionsClientListMoveCollectionsByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListMoveCollectionsBySubscriptionPager - Get all the Move Collections in the subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
// options - MoveCollectionsClientListMoveCollectionsBySubscriptionOptions contains the optional parameters for the MoveCollectionsClient.ListMoveCollectionsBySubscription
// method.
func (client *MoveCollectionsClient) NewListMoveCollectionsBySubscriptionPager(options *MoveCollectionsClientListMoveCollectionsBySubscriptionOptions) *runtime.Pager[MoveCollectionsClientListMoveCollectionsBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[MoveCollectionsClientListMoveCollectionsBySubscriptionResponse]{
		More: func(page MoveCollectionsClientListMoveCollectionsBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *MoveCollectionsClientListMoveCollectionsBySubscriptionResponse) (MoveCollectionsClientListMoveCollectionsBySubscriptionResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listMoveCollectionsBySubscriptionCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return MoveCollectionsClientListMoveCollectionsBySubscriptionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return MoveCollectionsClientListMoveCollectionsBySubscriptionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return MoveCollectionsClientListMoveCollectionsBySubscriptionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMoveCollectionsBySubscriptionHandleResponse(resp)
		},
	})
}

// listMoveCollectionsBySubscriptionCreateRequest creates the ListMoveCollectionsBySubscription request.
func (client *MoveCollectionsClient) listMoveCollectionsBySubscriptionCreateRequest(ctx context.Context, options *MoveCollectionsClientListMoveCollectionsBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Migrate/moveCollections"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMoveCollectionsBySubscriptionHandleResponse handles the ListMoveCollectionsBySubscription response.
func (client *MoveCollectionsClient) listMoveCollectionsBySubscriptionHandleResponse(resp *http.Response) (MoveCollectionsClientListMoveCollectionsBySubscriptionResponse, error) {
	result := MoveCollectionsClientListMoveCollectionsBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MoveCollectionResultList); err != nil {
		return MoveCollectionsClientListMoveCollectionsBySubscriptionResponse{}, err
	}
	return result, nil
}

// ListRequiredFor - List of the move resources for which an arm resource is required for.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
// resourceGroupName - The Resource Group Name.
// moveCollectionName - The Move Collection Name.
// sourceID - The sourceId for which the api is invoked.
// options - MoveCollectionsClientListRequiredForOptions contains the optional parameters for the MoveCollectionsClient.ListRequiredFor
// method.
func (client *MoveCollectionsClient) ListRequiredFor(ctx context.Context, resourceGroupName string, moveCollectionName string, sourceID string, options *MoveCollectionsClientListRequiredForOptions) (MoveCollectionsClientListRequiredForResponse, error) {
	req, err := client.listRequiredForCreateRequest(ctx, resourceGroupName, moveCollectionName, sourceID, options)
	if err != nil {
		return MoveCollectionsClientListRequiredForResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return MoveCollectionsClientListRequiredForResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return MoveCollectionsClientListRequiredForResponse{}, runtime.NewResponseError(resp)
	}
	return client.listRequiredForHandleResponse(resp)
}

// listRequiredForCreateRequest creates the ListRequiredFor request.
func (client *MoveCollectionsClient) listRequiredForCreateRequest(ctx context.Context, resourceGroupName string, moveCollectionName string, sourceID string, options *MoveCollectionsClientListRequiredForOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}/requiredFor"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if moveCollectionName == "" {
		return nil, errors.New("parameter moveCollectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{moveCollectionName}", url.PathEscape(moveCollectionName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("sourceId", sourceID)
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listRequiredForHandleResponse handles the ListRequiredFor response.
func (client *MoveCollectionsClient) listRequiredForHandleResponse(resp *http.Response) (MoveCollectionsClientListRequiredForResponse, error) {
	result := MoveCollectionsClientListRequiredForResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RequiredForResourcesCollection); err != nil {
		return MoveCollectionsClientListRequiredForResponse{}, err
	}
	return result, nil
}

// BeginPrepare - Initiates prepare for the set of resources included in the request body. The prepare operation is on the
// moveResources that are in the moveState 'PreparePending' or 'PrepareFailed', on a successful
// completion the moveResource moveState do a transition to MovePending. To aid the user to prerequisite the operation the
// client can call operation with validateOnly property set to true.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
// resourceGroupName - The Resource Group Name.
// moveCollectionName - The Move Collection Name.
// options - MoveCollectionsClientBeginPrepareOptions contains the optional parameters for the MoveCollectionsClient.BeginPrepare
// method.
func (client *MoveCollectionsClient) BeginPrepare(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginPrepareOptions) (*runtime.Poller[MoveCollectionsClientPrepareResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.prepare(ctx, resourceGroupName, moveCollectionName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[MoveCollectionsClientPrepareResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
		})
	} else {
		return runtime.NewPollerFromResumeToken[MoveCollectionsClientPrepareResponse](options.ResumeToken, client.pl, nil)
	}
}

// Prepare - Initiates prepare for the set of resources included in the request body. The prepare operation is on the moveResources
// that are in the moveState 'PreparePending' or 'PrepareFailed', on a successful
// completion the moveResource moveState do a transition to MovePending. To aid the user to prerequisite the operation the
// client can call operation with validateOnly property set to true.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
func (client *MoveCollectionsClient) prepare(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginPrepareOptions) (*http.Response, error) {
	req, err := client.prepareCreateRequest(ctx, resourceGroupName, moveCollectionName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// prepareCreateRequest creates the Prepare request.
func (client *MoveCollectionsClient) prepareCreateRequest(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginPrepareOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}/prepare"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if moveCollectionName == "" {
		return nil, errors.New("parameter moveCollectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{moveCollectionName}", url.PathEscape(moveCollectionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Body != nil {
		return req, runtime.MarshalAsJSON(req, *options.Body)
	}
	return req, nil
}

// BeginResolveDependencies - Computes, resolves and validate the dependencies of the moveResources in the move collection.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
// resourceGroupName - The Resource Group Name.
// moveCollectionName - The Move Collection Name.
// options - MoveCollectionsClientBeginResolveDependenciesOptions contains the optional parameters for the MoveCollectionsClient.BeginResolveDependencies
// method.
func (client *MoveCollectionsClient) BeginResolveDependencies(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginResolveDependenciesOptions) (*runtime.Poller[MoveCollectionsClientResolveDependenciesResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.resolveDependencies(ctx, resourceGroupName, moveCollectionName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[MoveCollectionsClientResolveDependenciesResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
		})
	} else {
		return runtime.NewPollerFromResumeToken[MoveCollectionsClientResolveDependenciesResponse](options.ResumeToken, client.pl, nil)
	}
}

// ResolveDependencies - Computes, resolves and validate the dependencies of the moveResources in the move collection.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
func (client *MoveCollectionsClient) resolveDependencies(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginResolveDependenciesOptions) (*http.Response, error) {
	req, err := client.resolveDependenciesCreateRequest(ctx, resourceGroupName, moveCollectionName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// resolveDependenciesCreateRequest creates the ResolveDependencies request.
func (client *MoveCollectionsClient) resolveDependenciesCreateRequest(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientBeginResolveDependenciesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}/resolveDependencies"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if moveCollectionName == "" {
		return nil, errors.New("parameter moveCollectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{moveCollectionName}", url.PathEscape(moveCollectionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Update - Updates a move collection.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-08-01
// resourceGroupName - The Resource Group Name.
// moveCollectionName - The Move Collection Name.
// options - MoveCollectionsClientUpdateOptions contains the optional parameters for the MoveCollectionsClient.Update method.
func (client *MoveCollectionsClient) Update(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientUpdateOptions) (MoveCollectionsClientUpdateResponse, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, moveCollectionName, options)
	if err != nil {
		return MoveCollectionsClientUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return MoveCollectionsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return MoveCollectionsClientUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateHandleResponse(resp)
}

// updateCreateRequest creates the Update request.
func (client *MoveCollectionsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, moveCollectionName string, options *MoveCollectionsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if moveCollectionName == "" {
		return nil, errors.New("parameter moveCollectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{moveCollectionName}", url.PathEscape(moveCollectionName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Body != nil {
		return req, runtime.MarshalAsJSON(req, *options.Body)
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *MoveCollectionsClient) updateHandleResponse(resp *http.Response) (MoveCollectionsClientUpdateResponse, error) {
	result := MoveCollectionsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MoveCollection); err != nil {
		return MoveCollectionsClientUpdateResponse{}, err
	}
	return result, nil
}
