//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmediaservices

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AacAudio.
func (a AacAudio) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bitrate", a.Bitrate)
	populate(objectMap, "channels", a.Channels)
	populate(objectMap, "label", a.Label)
	objectMap["@odata.type"] = "#Microsoft.Media.AacAudio"
	populate(objectMap, "profile", a.Profile)
	populate(objectMap, "samplingRate", a.SamplingRate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AacAudio.
func (a *AacAudio) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bitrate":
			err = unpopulate(val, "Bitrate", &a.Bitrate)
			delete(rawMsg, key)
		case "channels":
			err = unpopulate(val, "Channels", &a.Channels)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &a.Label)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &a.ODataType)
			delete(rawMsg, key)
		case "profile":
			err = unpopulate(val, "Profile", &a.Profile)
			delete(rawMsg, key)
		case "samplingRate":
			err = unpopulate(val, "SamplingRate", &a.SamplingRate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AbsoluteClipTime.
func (a AbsoluteClipTime) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = "#Microsoft.Media.AbsoluteClipTime"
	populate(objectMap, "time", a.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AbsoluteClipTime.
func (a *AbsoluteClipTime) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &a.ODataType)
			delete(rawMsg, key)
		case "time":
			err = unpopulate(val, "Time", &a.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessControl.
func (a AccessControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "defaultAction", a.DefaultAction)
	populate(objectMap, "ipAllowList", a.IPAllowList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessControl.
func (a *AccessControl) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultAction":
			err = unpopulate(val, "DefaultAction", &a.DefaultAction)
			delete(rawMsg, key)
		case "ipAllowList":
			err = unpopulate(val, "IPAllowList", &a.IPAllowList)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountEncryption.
func (a AccountEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "keyVaultProperties", a.KeyVaultProperties)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountEncryption.
func (a *AccountEncryption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &a.Identity)
			delete(rawMsg, key)
		case "keyVaultProperties":
			err = unpopulate(val, "KeyVaultProperties", &a.KeyVaultProperties)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountFilter.
func (a AccountFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountFilter.
func (a *AccountFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountFilterCollection.
func (a AccountFilterCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "@odata.nextLink", a.ODataNextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountFilterCollection.
func (a *AccountFilterCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.nextLink":
			err = unpopulate(val, "ODataNextLink", &a.ODataNextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AkamaiAccessControl.
func (a AkamaiAccessControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "akamaiSignatureHeaderAuthenticationKeyList", a.AkamaiSignatureHeaderAuthenticationKeyList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AkamaiAccessControl.
func (a *AkamaiAccessControl) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "akamaiSignatureHeaderAuthenticationKeyList":
			err = unpopulate(val, "AkamaiSignatureHeaderAuthenticationKeyList", &a.AkamaiSignatureHeaderAuthenticationKeyList)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AkamaiSignatureHeaderAuthenticationKey.
func (a AkamaiSignatureHeaderAuthenticationKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "base64Key", a.Base64Key)
	populateTimeRFC3339(objectMap, "expiration", a.Expiration)
	populate(objectMap, "identifier", a.Identifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AkamaiSignatureHeaderAuthenticationKey.
func (a *AkamaiSignatureHeaderAuthenticationKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "base64Key":
			err = unpopulate(val, "Base64Key", &a.Base64Key)
			delete(rawMsg, key)
		case "expiration":
			err = unpopulateTimeRFC3339(val, "Expiration", &a.Expiration)
			delete(rawMsg, key)
		case "identifier":
			err = unpopulate(val, "Identifier", &a.Identifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmStreamingEndpointCapacity.
func (a ArmStreamingEndpointCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "default", a.Default)
	populate(objectMap, "maximum", a.Maximum)
	populate(objectMap, "minimum", a.Minimum)
	populate(objectMap, "scaleType", a.ScaleType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmStreamingEndpointCapacity.
func (a *ArmStreamingEndpointCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "default":
			err = unpopulate(val, "Default", &a.Default)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &a.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &a.Minimum)
			delete(rawMsg, key)
		case "scaleType":
			err = unpopulate(val, "ScaleType", &a.ScaleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmStreamingEndpointCurrentSKU.
func (a ArmStreamingEndpointCurrentSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "capacity", a.Capacity)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmStreamingEndpointCurrentSKU.
func (a *ArmStreamingEndpointCurrentSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &a.Capacity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmStreamingEndpointSKU.
func (a ArmStreamingEndpointSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmStreamingEndpointSKU.
func (a *ArmStreamingEndpointSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmStreamingEndpointSKUInfo.
func (a ArmStreamingEndpointSKUInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "capacity", a.Capacity)
	populate(objectMap, "resourceType", a.ResourceType)
	populate(objectMap, "sku", a.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmStreamingEndpointSKUInfo.
func (a *ArmStreamingEndpointSKUInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &a.Capacity)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &a.ResourceType)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Asset.
func (a Asset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Asset.
func (a *Asset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssetCollection.
func (a AssetCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "@odata.nextLink", a.ODataNextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssetCollection.
func (a *AssetCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.nextLink":
			err = unpopulate(val, "ODataNextLink", &a.ODataNextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssetContainerSas.
func (a AssetContainerSas) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assetContainerSasUrls", a.AssetContainerSasUrls)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssetContainerSas.
func (a *AssetContainerSas) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assetContainerSasUrls":
			err = unpopulate(val, "AssetContainerSasUrls", &a.AssetContainerSasUrls)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssetFileEncryptionMetadata.
func (a AssetFileEncryptionMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assetFileId", a.AssetFileID)
	populate(objectMap, "assetFileName", a.AssetFileName)
	populate(objectMap, "initializationVector", a.InitializationVector)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssetFileEncryptionMetadata.
func (a *AssetFileEncryptionMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assetFileId":
			err = unpopulate(val, "AssetFileID", &a.AssetFileID)
			delete(rawMsg, key)
		case "assetFileName":
			err = unpopulate(val, "AssetFileName", &a.AssetFileName)
			delete(rawMsg, key)
		case "initializationVector":
			err = unpopulate(val, "InitializationVector", &a.InitializationVector)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssetFilter.
func (a AssetFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssetFilter.
func (a *AssetFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssetFilterCollection.
func (a AssetFilterCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "@odata.nextLink", a.ODataNextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssetFilterCollection.
func (a *AssetFilterCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.nextLink":
			err = unpopulate(val, "ODataNextLink", &a.ODataNextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssetProperties.
func (a AssetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alternateId", a.AlternateID)
	populate(objectMap, "assetId", a.AssetID)
	populate(objectMap, "container", a.Container)
	populateTimeRFC3339(objectMap, "created", a.Created)
	populate(objectMap, "description", a.Description)
	populateTimeRFC3339(objectMap, "lastModified", a.LastModified)
	populate(objectMap, "storageAccountName", a.StorageAccountName)
	populate(objectMap, "storageEncryptionFormat", a.StorageEncryptionFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssetProperties.
func (a *AssetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alternateId":
			err = unpopulate(val, "AlternateID", &a.AlternateID)
			delete(rawMsg, key)
		case "assetId":
			err = unpopulate(val, "AssetID", &a.AssetID)
			delete(rawMsg, key)
		case "container":
			err = unpopulate(val, "Container", &a.Container)
			delete(rawMsg, key)
		case "created":
			err = unpopulateTimeRFC3339(val, "Created", &a.Created)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "lastModified":
			err = unpopulateTimeRFC3339(val, "LastModified", &a.LastModified)
			delete(rawMsg, key)
		case "storageAccountName":
			err = unpopulate(val, "StorageAccountName", &a.StorageAccountName)
			delete(rawMsg, key)
		case "storageEncryptionFormat":
			err = unpopulate(val, "StorageEncryptionFormat", &a.StorageEncryptionFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssetStreamingLocator.
func (a AssetStreamingLocator) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assetName", a.AssetName)
	populateTimeRFC3339(objectMap, "created", a.Created)
	populate(objectMap, "defaultContentKeyPolicyName", a.DefaultContentKeyPolicyName)
	populateTimeRFC3339(objectMap, "endTime", a.EndTime)
	populate(objectMap, "name", a.Name)
	populateTimeRFC3339(objectMap, "startTime", a.StartTime)
	populate(objectMap, "streamingLocatorId", a.StreamingLocatorID)
	populate(objectMap, "streamingPolicyName", a.StreamingPolicyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssetStreamingLocator.
func (a *AssetStreamingLocator) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assetName":
			err = unpopulate(val, "AssetName", &a.AssetName)
			delete(rawMsg, key)
		case "created":
			err = unpopulateTimeRFC3339(val, "Created", &a.Created)
			delete(rawMsg, key)
		case "defaultContentKeyPolicyName":
			err = unpopulate(val, "DefaultContentKeyPolicyName", &a.DefaultContentKeyPolicyName)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &a.EndTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		case "streamingLocatorId":
			err = unpopulate(val, "StreamingLocatorID", &a.StreamingLocatorID)
			delete(rawMsg, key)
		case "streamingPolicyName":
			err = unpopulate(val, "StreamingPolicyName", &a.StreamingPolicyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssetTrack.
func (a AssetTrack) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssetTrack.
func (a *AssetTrack) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssetTrackCollection.
func (a AssetTrackCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssetTrackCollection.
func (a *AssetTrackCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssetTrackOperationStatus.
func (a AssetTrackOperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endTime", a.EndTime)
	populate(objectMap, "error", a.Error)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populateTimeRFC3339(objectMap, "startTime", a.StartTime)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssetTrackOperationStatus.
func (a *AssetTrackOperationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &a.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssetTrackProperties.
func (a AssetTrackProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "track", a.Track)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssetTrackProperties.
func (a *AssetTrackProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "track":
			a.Track, err = unmarshalTrackBaseClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AsyncOperationResult.
func (a AsyncOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", a.Error)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AsyncOperationResult.
func (a *AsyncOperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Audio.
func (a Audio) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bitrate", a.Bitrate)
	populate(objectMap, "channels", a.Channels)
	populate(objectMap, "label", a.Label)
	objectMap["@odata.type"] = "#Microsoft.Media.Audio"
	populate(objectMap, "samplingRate", a.SamplingRate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Audio.
func (a *Audio) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bitrate":
			err = unpopulate(val, "Bitrate", &a.Bitrate)
			delete(rawMsg, key)
		case "channels":
			err = unpopulate(val, "Channels", &a.Channels)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &a.Label)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &a.ODataType)
			delete(rawMsg, key)
		case "samplingRate":
			err = unpopulate(val, "SamplingRate", &a.SamplingRate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AudioAnalyzerPreset.
func (a AudioAnalyzerPreset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "audioLanguage", a.AudioLanguage)
	populate(objectMap, "experimentalOptions", a.ExperimentalOptions)
	populate(objectMap, "mode", a.Mode)
	objectMap["@odata.type"] = "#Microsoft.Media.AudioAnalyzerPreset"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AudioAnalyzerPreset.
func (a *AudioAnalyzerPreset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "audioLanguage":
			err = unpopulate(val, "AudioLanguage", &a.AudioLanguage)
			delete(rawMsg, key)
		case "experimentalOptions":
			err = unpopulate(val, "ExperimentalOptions", &a.ExperimentalOptions)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &a.Mode)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &a.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AudioOverlay.
func (a AudioOverlay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "audioGainLevel", a.AudioGainLevel)
	populate(objectMap, "end", a.End)
	populate(objectMap, "fadeInDuration", a.FadeInDuration)
	populate(objectMap, "fadeOutDuration", a.FadeOutDuration)
	populate(objectMap, "inputLabel", a.InputLabel)
	objectMap["@odata.type"] = "#Microsoft.Media.AudioOverlay"
	populate(objectMap, "start", a.Start)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AudioOverlay.
func (a *AudioOverlay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "audioGainLevel":
			err = unpopulate(val, "AudioGainLevel", &a.AudioGainLevel)
			delete(rawMsg, key)
		case "end":
			err = unpopulate(val, "End", &a.End)
			delete(rawMsg, key)
		case "fadeInDuration":
			err = unpopulate(val, "FadeInDuration", &a.FadeInDuration)
			delete(rawMsg, key)
		case "fadeOutDuration":
			err = unpopulate(val, "FadeOutDuration", &a.FadeOutDuration)
			delete(rawMsg, key)
		case "inputLabel":
			err = unpopulate(val, "InputLabel", &a.InputLabel)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &a.ODataType)
			delete(rawMsg, key)
		case "start":
			err = unpopulate(val, "Start", &a.Start)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AudioTrack.
func (a AudioTrack) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bitRate", a.BitRate)
	populate(objectMap, "dashSettings", a.DashSettings)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "fileName", a.FileName)
	populate(objectMap, "hlsSettings", a.HlsSettings)
	populate(objectMap, "languageCode", a.LanguageCode)
	populate(objectMap, "mpeg4TrackId", a.Mpeg4TrackID)
	objectMap["@odata.type"] = "#Microsoft.Media.AudioTrack"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AudioTrack.
func (a *AudioTrack) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bitRate":
			err = unpopulate(val, "BitRate", &a.BitRate)
			delete(rawMsg, key)
		case "dashSettings":
			err = unpopulate(val, "DashSettings", &a.DashSettings)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &a.FileName)
			delete(rawMsg, key)
		case "hlsSettings":
			err = unpopulate(val, "HlsSettings", &a.HlsSettings)
			delete(rawMsg, key)
		case "languageCode":
			err = unpopulate(val, "LanguageCode", &a.LanguageCode)
			delete(rawMsg, key)
		case "mpeg4TrackId":
			err = unpopulate(val, "Mpeg4TrackID", &a.Mpeg4TrackID)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &a.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AudioTrackDescriptor.
func (a AudioTrackDescriptor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "channelMapping", a.ChannelMapping)
	objectMap["@odata.type"] = "#Microsoft.Media.AudioTrackDescriptor"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AudioTrackDescriptor.
func (a *AudioTrackDescriptor) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelMapping":
			err = unpopulate(val, "ChannelMapping", &a.ChannelMapping)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &a.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BuiltInStandardEncoderPreset.
func (b BuiltInStandardEncoderPreset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configurations", b.Configurations)
	objectMap["@odata.type"] = "#Microsoft.Media.BuiltInStandardEncoderPreset"
	populate(objectMap, "presetName", b.PresetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BuiltInStandardEncoderPreset.
func (b *BuiltInStandardEncoderPreset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurations":
			err = unpopulate(val, "Configurations", &b.Configurations)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &b.ODataType)
			delete(rawMsg, key)
		case "presetName":
			err = unpopulate(val, "PresetName", &b.PresetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CbcsDrmConfiguration.
func (c CbcsDrmConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "fairPlay", c.FairPlay)
	populate(objectMap, "playReady", c.PlayReady)
	populate(objectMap, "widevine", c.Widevine)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CbcsDrmConfiguration.
func (c *CbcsDrmConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fairPlay":
			err = unpopulate(val, "FairPlay", &c.FairPlay)
			delete(rawMsg, key)
		case "playReady":
			err = unpopulate(val, "PlayReady", &c.PlayReady)
			delete(rawMsg, key)
		case "widevine":
			err = unpopulate(val, "Widevine", &c.Widevine)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CencDrmConfiguration.
func (c CencDrmConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "playReady", c.PlayReady)
	populate(objectMap, "widevine", c.Widevine)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CencDrmConfiguration.
func (c *CencDrmConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "playReady":
			err = unpopulate(val, "PlayReady", &c.PlayReady)
			delete(rawMsg, key)
		case "widevine":
			err = unpopulate(val, "Widevine", &c.Widevine)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityInput.
func (c CheckNameAvailabilityInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", c.Name)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityInput.
func (c *CheckNameAvailabilityInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClearKeyEncryptionConfiguration.
func (c ClearKeyEncryptionConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customKeysAcquisitionUrlTemplate", c.CustomKeysAcquisitionURLTemplate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClearKeyEncryptionConfiguration.
func (c *ClearKeyEncryptionConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customKeysAcquisitionUrlTemplate":
			err = unpopulate(val, "CustomKeysAcquisitionURLTemplate", &c.CustomKeysAcquisitionURLTemplate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClipTime.
func (c ClipTime) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = c.ODataType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClipTime.
func (c *ClipTime) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Codec.
func (c Codec) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "label", c.Label)
	objectMap["@odata.type"] = c.ODataType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Codec.
func (c *Codec) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "label":
			err = unpopulate(val, "Label", &c.Label)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommonEncryptionCbcs.
func (c CommonEncryptionCbcs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clearKeyEncryptionConfiguration", c.ClearKeyEncryptionConfiguration)
	populate(objectMap, "clearTracks", c.ClearTracks)
	populate(objectMap, "contentKeys", c.ContentKeys)
	populate(objectMap, "drm", c.Drm)
	populate(objectMap, "enabledProtocols", c.EnabledProtocols)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommonEncryptionCbcs.
func (c *CommonEncryptionCbcs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clearKeyEncryptionConfiguration":
			err = unpopulate(val, "ClearKeyEncryptionConfiguration", &c.ClearKeyEncryptionConfiguration)
			delete(rawMsg, key)
		case "clearTracks":
			err = unpopulate(val, "ClearTracks", &c.ClearTracks)
			delete(rawMsg, key)
		case "contentKeys":
			err = unpopulate(val, "ContentKeys", &c.ContentKeys)
			delete(rawMsg, key)
		case "drm":
			err = unpopulate(val, "Drm", &c.Drm)
			delete(rawMsg, key)
		case "enabledProtocols":
			err = unpopulate(val, "EnabledProtocols", &c.EnabledProtocols)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommonEncryptionCenc.
func (c CommonEncryptionCenc) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clearKeyEncryptionConfiguration", c.ClearKeyEncryptionConfiguration)
	populate(objectMap, "clearTracks", c.ClearTracks)
	populate(objectMap, "contentKeys", c.ContentKeys)
	populate(objectMap, "drm", c.Drm)
	populate(objectMap, "enabledProtocols", c.EnabledProtocols)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommonEncryptionCenc.
func (c *CommonEncryptionCenc) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clearKeyEncryptionConfiguration":
			err = unpopulate(val, "ClearKeyEncryptionConfiguration", &c.ClearKeyEncryptionConfiguration)
			delete(rawMsg, key)
		case "clearTracks":
			err = unpopulate(val, "ClearTracks", &c.ClearTracks)
			delete(rawMsg, key)
		case "contentKeys":
			err = unpopulate(val, "ContentKeys", &c.ContentKeys)
			delete(rawMsg, key)
		case "drm":
			err = unpopulate(val, "Drm", &c.Drm)
			delete(rawMsg, key)
		case "enabledProtocols":
			err = unpopulate(val, "EnabledProtocols", &c.EnabledProtocols)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicy.
func (c ContentKeyPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicy.
func (c *ContentKeyPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyClearKeyConfiguration.
func (c ContentKeyPolicyClearKeyConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = "#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyClearKeyConfiguration.
func (c *ContentKeyPolicyClearKeyConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyCollection.
func (c ContentKeyPolicyCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "@odata.nextLink", c.ODataNextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyCollection.
func (c *ContentKeyPolicyCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.nextLink":
			err = unpopulate(val, "ODataNextLink", &c.ODataNextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyConfiguration.
func (c ContentKeyPolicyConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = c.ODataType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyConfiguration.
func (c *ContentKeyPolicyConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyFairPlayConfiguration.
func (c ContentKeyPolicyFairPlayConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateByteArray(objectMap, "ask", c.Ask, runtime.Base64StdFormat)
	populate(objectMap, "fairPlayPfx", c.FairPlayPfx)
	populate(objectMap, "fairPlayPfxPassword", c.FairPlayPfxPassword)
	objectMap["@odata.type"] = "#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration"
	populate(objectMap, "offlineRentalConfiguration", c.OfflineRentalConfiguration)
	populate(objectMap, "rentalAndLeaseKeyType", c.RentalAndLeaseKeyType)
	populate(objectMap, "rentalDuration", c.RentalDuration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyFairPlayConfiguration.
func (c *ContentKeyPolicyFairPlayConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ask":
			err = runtime.DecodeByteArray(string(val), &c.Ask, runtime.Base64StdFormat)
			delete(rawMsg, key)
		case "fairPlayPfx":
			err = unpopulate(val, "FairPlayPfx", &c.FairPlayPfx)
			delete(rawMsg, key)
		case "fairPlayPfxPassword":
			err = unpopulate(val, "FairPlayPfxPassword", &c.FairPlayPfxPassword)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		case "offlineRentalConfiguration":
			err = unpopulate(val, "OfflineRentalConfiguration", &c.OfflineRentalConfiguration)
			delete(rawMsg, key)
		case "rentalAndLeaseKeyType":
			err = unpopulate(val, "RentalAndLeaseKeyType", &c.RentalAndLeaseKeyType)
			delete(rawMsg, key)
		case "rentalDuration":
			err = unpopulate(val, "RentalDuration", &c.RentalDuration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyFairPlayOfflineRentalConfiguration.
func (c ContentKeyPolicyFairPlayOfflineRentalConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "playbackDurationSeconds", c.PlaybackDurationSeconds)
	populate(objectMap, "storageDurationSeconds", c.StorageDurationSeconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyFairPlayOfflineRentalConfiguration.
func (c *ContentKeyPolicyFairPlayOfflineRentalConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "playbackDurationSeconds":
			err = unpopulate(val, "PlaybackDurationSeconds", &c.PlaybackDurationSeconds)
			delete(rawMsg, key)
		case "storageDurationSeconds":
			err = unpopulate(val, "StorageDurationSeconds", &c.StorageDurationSeconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyOpenRestriction.
func (c ContentKeyPolicyOpenRestriction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = "#Microsoft.Media.ContentKeyPolicyOpenRestriction"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyOpenRestriction.
func (c *ContentKeyPolicyOpenRestriction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyOption.
func (c ContentKeyPolicyOption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configuration", c.Configuration)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "policyOptionId", c.PolicyOptionID)
	populate(objectMap, "restriction", c.Restriction)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyOption.
func (c *ContentKeyPolicyOption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			c.Configuration, err = unmarshalContentKeyPolicyConfigurationClassification(val)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "policyOptionId":
			err = unpopulate(val, "PolicyOptionID", &c.PolicyOptionID)
			delete(rawMsg, key)
		case "restriction":
			c.Restriction, err = unmarshalContentKeyPolicyRestrictionClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyPlayReadyConfiguration.
func (c ContentKeyPolicyPlayReadyConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "licenses", c.Licenses)
	objectMap["@odata.type"] = "#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration"
	populate(objectMap, "responseCustomData", c.ResponseCustomData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyPlayReadyConfiguration.
func (c *ContentKeyPolicyPlayReadyConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "licenses":
			err = unpopulate(val, "Licenses", &c.Licenses)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		case "responseCustomData":
			err = unpopulate(val, "ResponseCustomData", &c.ResponseCustomData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader.
func (c ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = "#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader.
func (c *ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier.
func (c ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "keyId", c.KeyID)
	objectMap["@odata.type"] = "#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier.
func (c *ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyId":
			err = unpopulate(val, "KeyID", &c.KeyID)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyPlayReadyContentKeyLocation.
func (c ContentKeyPolicyPlayReadyContentKeyLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = c.ODataType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyPlayReadyContentKeyLocation.
func (c *ContentKeyPolicyPlayReadyContentKeyLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction.
func (c ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bestEffort", c.BestEffort)
	populate(objectMap, "configurationData", c.ConfigurationData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction.
func (c *ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bestEffort":
			err = unpopulate(val, "BestEffort", &c.BestEffort)
			delete(rawMsg, key)
		case "configurationData":
			err = unpopulate(val, "ConfigurationData", &c.ConfigurationData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyPlayReadyLicense.
func (c ContentKeyPolicyPlayReadyLicense) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowTestDevices", c.AllowTestDevices)
	populateTimeRFC3339(objectMap, "beginDate", c.BeginDate)
	populate(objectMap, "contentKeyLocation", c.ContentKeyLocation)
	populate(objectMap, "contentType", c.ContentType)
	populateTimeRFC3339(objectMap, "expirationDate", c.ExpirationDate)
	populate(objectMap, "gracePeriod", c.GracePeriod)
	populate(objectMap, "licenseType", c.LicenseType)
	populate(objectMap, "playRight", c.PlayRight)
	populate(objectMap, "relativeBeginDate", c.RelativeBeginDate)
	populate(objectMap, "relativeExpirationDate", c.RelativeExpirationDate)
	populate(objectMap, "securityLevel", c.SecurityLevel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyPlayReadyLicense.
func (c *ContentKeyPolicyPlayReadyLicense) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowTestDevices":
			err = unpopulate(val, "AllowTestDevices", &c.AllowTestDevices)
			delete(rawMsg, key)
		case "beginDate":
			err = unpopulateTimeRFC3339(val, "BeginDate", &c.BeginDate)
			delete(rawMsg, key)
		case "contentKeyLocation":
			c.ContentKeyLocation, err = unmarshalContentKeyPolicyPlayReadyContentKeyLocationClassification(val)
			delete(rawMsg, key)
		case "contentType":
			err = unpopulate(val, "ContentType", &c.ContentType)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateTimeRFC3339(val, "ExpirationDate", &c.ExpirationDate)
			delete(rawMsg, key)
		case "gracePeriod":
			err = unpopulate(val, "GracePeriod", &c.GracePeriod)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &c.LicenseType)
			delete(rawMsg, key)
		case "playRight":
			err = unpopulate(val, "PlayRight", &c.PlayRight)
			delete(rawMsg, key)
		case "relativeBeginDate":
			err = unpopulate(val, "RelativeBeginDate", &c.RelativeBeginDate)
			delete(rawMsg, key)
		case "relativeExpirationDate":
			err = unpopulate(val, "RelativeExpirationDate", &c.RelativeExpirationDate)
			delete(rawMsg, key)
		case "securityLevel":
			err = unpopulate(val, "SecurityLevel", &c.SecurityLevel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyPlayReadyPlayRight.
func (c ContentKeyPolicyPlayReadyPlayRight) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agcAndColorStripeRestriction", c.AgcAndColorStripeRestriction)
	populate(objectMap, "allowPassingVideoContentToUnknownOutput", c.AllowPassingVideoContentToUnknownOutput)
	populate(objectMap, "analogVideoOpl", c.AnalogVideoOpl)
	populate(objectMap, "compressedDigitalAudioOpl", c.CompressedDigitalAudioOpl)
	populate(objectMap, "compressedDigitalVideoOpl", c.CompressedDigitalVideoOpl)
	populate(objectMap, "digitalVideoOnlyContentRestriction", c.DigitalVideoOnlyContentRestriction)
	populate(objectMap, "explicitAnalogTelevisionOutputRestriction", c.ExplicitAnalogTelevisionOutputRestriction)
	populate(objectMap, "firstPlayExpiration", c.FirstPlayExpiration)
	populate(objectMap, "imageConstraintForAnalogComponentVideoRestriction", c.ImageConstraintForAnalogComponentVideoRestriction)
	populate(objectMap, "imageConstraintForAnalogComputerMonitorRestriction", c.ImageConstraintForAnalogComputerMonitorRestriction)
	populate(objectMap, "scmsRestriction", c.ScmsRestriction)
	populate(objectMap, "uncompressedDigitalAudioOpl", c.UncompressedDigitalAudioOpl)
	populate(objectMap, "uncompressedDigitalVideoOpl", c.UncompressedDigitalVideoOpl)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyPlayReadyPlayRight.
func (c *ContentKeyPolicyPlayReadyPlayRight) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agcAndColorStripeRestriction":
			err = unpopulate(val, "AgcAndColorStripeRestriction", &c.AgcAndColorStripeRestriction)
			delete(rawMsg, key)
		case "allowPassingVideoContentToUnknownOutput":
			err = unpopulate(val, "AllowPassingVideoContentToUnknownOutput", &c.AllowPassingVideoContentToUnknownOutput)
			delete(rawMsg, key)
		case "analogVideoOpl":
			err = unpopulate(val, "AnalogVideoOpl", &c.AnalogVideoOpl)
			delete(rawMsg, key)
		case "compressedDigitalAudioOpl":
			err = unpopulate(val, "CompressedDigitalAudioOpl", &c.CompressedDigitalAudioOpl)
			delete(rawMsg, key)
		case "compressedDigitalVideoOpl":
			err = unpopulate(val, "CompressedDigitalVideoOpl", &c.CompressedDigitalVideoOpl)
			delete(rawMsg, key)
		case "digitalVideoOnlyContentRestriction":
			err = unpopulate(val, "DigitalVideoOnlyContentRestriction", &c.DigitalVideoOnlyContentRestriction)
			delete(rawMsg, key)
		case "explicitAnalogTelevisionOutputRestriction":
			err = unpopulate(val, "ExplicitAnalogTelevisionOutputRestriction", &c.ExplicitAnalogTelevisionOutputRestriction)
			delete(rawMsg, key)
		case "firstPlayExpiration":
			err = unpopulate(val, "FirstPlayExpiration", &c.FirstPlayExpiration)
			delete(rawMsg, key)
		case "imageConstraintForAnalogComponentVideoRestriction":
			err = unpopulate(val, "ImageConstraintForAnalogComponentVideoRestriction", &c.ImageConstraintForAnalogComponentVideoRestriction)
			delete(rawMsg, key)
		case "imageConstraintForAnalogComputerMonitorRestriction":
			err = unpopulate(val, "ImageConstraintForAnalogComputerMonitorRestriction", &c.ImageConstraintForAnalogComputerMonitorRestriction)
			delete(rawMsg, key)
		case "scmsRestriction":
			err = unpopulate(val, "ScmsRestriction", &c.ScmsRestriction)
			delete(rawMsg, key)
		case "uncompressedDigitalAudioOpl":
			err = unpopulate(val, "UncompressedDigitalAudioOpl", &c.UncompressedDigitalAudioOpl)
			delete(rawMsg, key)
		case "uncompressedDigitalVideoOpl":
			err = unpopulate(val, "UncompressedDigitalVideoOpl", &c.UncompressedDigitalVideoOpl)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyProperties.
func (c ContentKeyPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "created", c.Created)
	populate(objectMap, "description", c.Description)
	populateTimeRFC3339(objectMap, "lastModified", c.LastModified)
	populate(objectMap, "options", c.Options)
	populate(objectMap, "policyId", c.PolicyID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyProperties.
func (c *ContentKeyPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "created":
			err = unpopulateTimeRFC3339(val, "Created", &c.Created)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "lastModified":
			err = unpopulateTimeRFC3339(val, "LastModified", &c.LastModified)
			delete(rawMsg, key)
		case "options":
			err = unpopulate(val, "Options", &c.Options)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &c.PolicyID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyRestriction.
func (c ContentKeyPolicyRestriction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = c.ODataType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyRestriction.
func (c *ContentKeyPolicyRestriction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyRestrictionTokenKey.
func (c ContentKeyPolicyRestrictionTokenKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = c.ODataType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyRestrictionTokenKey.
func (c *ContentKeyPolicyRestrictionTokenKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyRsaTokenKey.
func (c ContentKeyPolicyRsaTokenKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateByteArray(objectMap, "exponent", c.Exponent, runtime.Base64StdFormat)
	populateByteArray(objectMap, "modulus", c.Modulus, runtime.Base64StdFormat)
	objectMap["@odata.type"] = "#Microsoft.Media.ContentKeyPolicyRsaTokenKey"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyRsaTokenKey.
func (c *ContentKeyPolicyRsaTokenKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exponent":
			err = runtime.DecodeByteArray(string(val), &c.Exponent, runtime.Base64StdFormat)
			delete(rawMsg, key)
		case "modulus":
			err = runtime.DecodeByteArray(string(val), &c.Modulus, runtime.Base64StdFormat)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicySymmetricTokenKey.
func (c ContentKeyPolicySymmetricTokenKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateByteArray(objectMap, "keyValue", c.KeyValue, runtime.Base64StdFormat)
	objectMap["@odata.type"] = "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicySymmetricTokenKey.
func (c *ContentKeyPolicySymmetricTokenKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyValue":
			err = runtime.DecodeByteArray(string(val), &c.KeyValue, runtime.Base64StdFormat)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyTokenClaim.
func (c ContentKeyPolicyTokenClaim) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "claimType", c.ClaimType)
	populate(objectMap, "claimValue", c.ClaimValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyTokenClaim.
func (c *ContentKeyPolicyTokenClaim) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "claimType":
			err = unpopulate(val, "ClaimType", &c.ClaimType)
			delete(rawMsg, key)
		case "claimValue":
			err = unpopulate(val, "ClaimValue", &c.ClaimValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyTokenRestriction.
func (c ContentKeyPolicyTokenRestriction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alternateVerificationKeys", c.AlternateVerificationKeys)
	populate(objectMap, "audience", c.Audience)
	populate(objectMap, "issuer", c.Issuer)
	objectMap["@odata.type"] = "#Microsoft.Media.ContentKeyPolicyTokenRestriction"
	populate(objectMap, "openIdConnectDiscoveryDocument", c.OpenIDConnectDiscoveryDocument)
	populate(objectMap, "primaryVerificationKey", c.PrimaryVerificationKey)
	populate(objectMap, "requiredClaims", c.RequiredClaims)
	populate(objectMap, "restrictionTokenType", c.RestrictionTokenType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyTokenRestriction.
func (c *ContentKeyPolicyTokenRestriction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alternateVerificationKeys":
			c.AlternateVerificationKeys, err = unmarshalContentKeyPolicyRestrictionTokenKeyClassificationArray(val)
			delete(rawMsg, key)
		case "audience":
			err = unpopulate(val, "Audience", &c.Audience)
			delete(rawMsg, key)
		case "issuer":
			err = unpopulate(val, "Issuer", &c.Issuer)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		case "openIdConnectDiscoveryDocument":
			err = unpopulate(val, "OpenIDConnectDiscoveryDocument", &c.OpenIDConnectDiscoveryDocument)
			delete(rawMsg, key)
		case "primaryVerificationKey":
			c.PrimaryVerificationKey, err = unmarshalContentKeyPolicyRestrictionTokenKeyClassification(val)
			delete(rawMsg, key)
		case "requiredClaims":
			err = unpopulate(val, "RequiredClaims", &c.RequiredClaims)
			delete(rawMsg, key)
		case "restrictionTokenType":
			err = unpopulate(val, "RestrictionTokenType", &c.RestrictionTokenType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyUnknownConfiguration.
func (c ContentKeyPolicyUnknownConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = "#Microsoft.Media.ContentKeyPolicyUnknownConfiguration"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyUnknownConfiguration.
func (c *ContentKeyPolicyUnknownConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyUnknownRestriction.
func (c ContentKeyPolicyUnknownRestriction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = "#Microsoft.Media.ContentKeyPolicyUnknownRestriction"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyUnknownRestriction.
func (c *ContentKeyPolicyUnknownRestriction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyWidevineConfiguration.
func (c ContentKeyPolicyWidevineConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = "#Microsoft.Media.ContentKeyPolicyWidevineConfiguration"
	populate(objectMap, "widevineTemplate", c.WidevineTemplate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyWidevineConfiguration.
func (c *ContentKeyPolicyWidevineConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		case "widevineTemplate":
			err = unpopulate(val, "WidevineTemplate", &c.WidevineTemplate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentKeyPolicyX509CertificateTokenKey.
func (c ContentKeyPolicyX509CertificateTokenKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = "#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey"
	populateByteArray(objectMap, "rawBody", c.RawBody, runtime.Base64StdFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentKeyPolicyX509CertificateTokenKey.
func (c *ContentKeyPolicyX509CertificateTokenKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		case "rawBody":
			err = runtime.DecodeByteArray(string(val), &c.RawBody, runtime.Base64StdFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CopyAudio.
func (c CopyAudio) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "label", c.Label)
	objectMap["@odata.type"] = "#Microsoft.Media.CopyAudio"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CopyAudio.
func (c *CopyAudio) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "label":
			err = unpopulate(val, "Label", &c.Label)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CopyVideo.
func (c CopyVideo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "label", c.Label)
	objectMap["@odata.type"] = "#Microsoft.Media.CopyVideo"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CopyVideo.
func (c *CopyVideo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "label":
			err = unpopulate(val, "Label", &c.Label)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &c.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CrossSiteAccessPolicies.
func (c CrossSiteAccessPolicies) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientAccessPolicy", c.ClientAccessPolicy)
	populate(objectMap, "crossDomainPolicy", c.CrossDomainPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CrossSiteAccessPolicies.
func (c *CrossSiteAccessPolicies) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientAccessPolicy":
			err = unpopulate(val, "ClientAccessPolicy", &c.ClientAccessPolicy)
			delete(rawMsg, key)
		case "crossDomainPolicy":
			err = unpopulate(val, "CrossDomainPolicy", &c.CrossDomainPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DashSettings.
func (d DashSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "role", d.Role)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DashSettings.
func (d *DashSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "role":
			err = unpopulate(val, "Role", &d.Role)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultKey.
func (d DefaultKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "label", d.Label)
	populate(objectMap, "policyName", d.PolicyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultKey.
func (d *DefaultKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "label":
			err = unpopulate(val, "Label", &d.Label)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &d.PolicyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Deinterlace.
func (d Deinterlace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "mode", d.Mode)
	populate(objectMap, "parity", d.Parity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Deinterlace.
func (d *Deinterlace) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &d.Mode)
			delete(rawMsg, key)
		case "parity":
			err = unpopulate(val, "Parity", &d.Parity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdgePolicies.
func (e EdgePolicies) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "usageDataCollectionPolicy", e.UsageDataCollectionPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdgePolicies.
func (e *EdgePolicies) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "usageDataCollectionPolicy":
			err = unpopulate(val, "UsageDataCollectionPolicy", &e.UsageDataCollectionPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdgeUsageDataCollectionPolicy.
func (e EdgeUsageDataCollectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataCollectionFrequency", e.DataCollectionFrequency)
	populate(objectMap, "dataReportingFrequency", e.DataReportingFrequency)
	populate(objectMap, "eventHubDetails", e.EventHubDetails)
	populate(objectMap, "maxAllowedUnreportedUsageDuration", e.MaxAllowedUnreportedUsageDuration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdgeUsageDataCollectionPolicy.
func (e *EdgeUsageDataCollectionPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataCollectionFrequency":
			err = unpopulate(val, "DataCollectionFrequency", &e.DataCollectionFrequency)
			delete(rawMsg, key)
		case "dataReportingFrequency":
			err = unpopulate(val, "DataReportingFrequency", &e.DataReportingFrequency)
			delete(rawMsg, key)
		case "eventHubDetails":
			err = unpopulate(val, "EventHubDetails", &e.EventHubDetails)
			delete(rawMsg, key)
		case "maxAllowedUnreportedUsageDuration":
			err = unpopulate(val, "MaxAllowedUnreportedUsageDuration", &e.MaxAllowedUnreportedUsageDuration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdgeUsageDataEventHub.
func (e EdgeUsageDataEventHub) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", e.Name)
	populate(objectMap, "namespace", e.Namespace)
	populate(objectMap, "token", e.Token)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdgeUsageDataEventHub.
func (e *EdgeUsageDataEventHub) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &e.Namespace)
			delete(rawMsg, key)
		case "token":
			err = unpopulate(val, "Token", &e.Token)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnabledProtocols.
func (e EnabledProtocols) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dash", e.Dash)
	populate(objectMap, "download", e.Download)
	populate(objectMap, "hls", e.Hls)
	populate(objectMap, "smoothStreaming", e.SmoothStreaming)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnabledProtocols.
func (e *EnabledProtocols) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dash":
			err = unpopulate(val, "Dash", &e.Dash)
			delete(rawMsg, key)
		case "download":
			err = unpopulate(val, "Download", &e.Download)
			delete(rawMsg, key)
		case "hls":
			err = unpopulate(val, "Hls", &e.Hls)
			delete(rawMsg, key)
		case "smoothStreaming":
			err = unpopulate(val, "SmoothStreaming", &e.SmoothStreaming)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EntityNameAvailabilityCheckOutput.
func (e EntityNameAvailabilityCheckOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "message", e.Message)
	populate(objectMap, "nameAvailable", e.NameAvailable)
	populate(objectMap, "reason", e.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EntityNameAvailabilityCheckOutput.
func (e *EntityNameAvailabilityCheckOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &e.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &e.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvelopeEncryption.
func (e EnvelopeEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clearTracks", e.ClearTracks)
	populate(objectMap, "contentKeys", e.ContentKeys)
	populate(objectMap, "customKeyAcquisitionUrlTemplate", e.CustomKeyAcquisitionURLTemplate)
	populate(objectMap, "enabledProtocols", e.EnabledProtocols)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvelopeEncryption.
func (e *EnvelopeEncryption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clearTracks":
			err = unpopulate(val, "ClearTracks", &e.ClearTracks)
			delete(rawMsg, key)
		case "contentKeys":
			err = unpopulate(val, "ContentKeys", &e.ContentKeys)
			delete(rawMsg, key)
		case "customKeyAcquisitionUrlTemplate":
			err = unpopulate(val, "CustomKeyAcquisitionURLTemplate", &e.CustomKeyAcquisitionURLTemplate)
			delete(rawMsg, key)
		case "enabledProtocols":
			err = unpopulate(val, "EnabledProtocols", &e.EnabledProtocols)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorAdditionalInfo.
func (e ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "info", &e.Info)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorAdditionalInfo.
func (e *ErrorAdditionalInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &e.Info)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetail.
func (e *ErrorDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FaceDetectorPreset.
func (f FaceDetectorPreset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blurType", f.BlurType)
	populate(objectMap, "experimentalOptions", f.ExperimentalOptions)
	populate(objectMap, "mode", f.Mode)
	objectMap["@odata.type"] = "#Microsoft.Media.FaceDetectorPreset"
	populate(objectMap, "resolution", f.Resolution)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FaceDetectorPreset.
func (f *FaceDetectorPreset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blurType":
			err = unpopulate(val, "BlurType", &f.BlurType)
			delete(rawMsg, key)
		case "experimentalOptions":
			err = unpopulate(val, "ExperimentalOptions", &f.ExperimentalOptions)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &f.Mode)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &f.ODataType)
			delete(rawMsg, key)
		case "resolution":
			err = unpopulate(val, "Resolution", &f.Resolution)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FilterTrackPropertyCondition.
func (f FilterTrackPropertyCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "operation", f.Operation)
	populate(objectMap, "property", f.Property)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FilterTrackPropertyCondition.
func (f *FilterTrackPropertyCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operation":
			err = unpopulate(val, "Operation", &f.Operation)
			delete(rawMsg, key)
		case "property":
			err = unpopulate(val, "Property", &f.Property)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FilterTrackSelection.
func (f FilterTrackSelection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "trackSelections", f.TrackSelections)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FilterTrackSelection.
func (f *FilterTrackSelection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "trackSelections":
			err = unpopulate(val, "TrackSelections", &f.TrackSelections)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Filters.
func (f Filters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "crop", f.Crop)
	populate(objectMap, "deinterlace", f.Deinterlace)
	populate(objectMap, "overlays", f.Overlays)
	populate(objectMap, "rotation", f.Rotation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Filters.
func (f *Filters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "crop":
			err = unpopulate(val, "Crop", &f.Crop)
			delete(rawMsg, key)
		case "deinterlace":
			err = unpopulate(val, "Deinterlace", &f.Deinterlace)
			delete(rawMsg, key)
		case "overlays":
			f.Overlays, err = unmarshalOverlayClassificationArray(val)
			delete(rawMsg, key)
		case "rotation":
			err = unpopulate(val, "Rotation", &f.Rotation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirstQuality.
func (f FirstQuality) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bitrate", f.Bitrate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirstQuality.
func (f *FirstQuality) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bitrate":
			err = unpopulate(val, "Bitrate", &f.Bitrate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Format.
func (f Format) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "filenamePattern", f.FilenamePattern)
	objectMap["@odata.type"] = f.ODataType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Format.
func (f *Format) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filenamePattern":
			err = unpopulate(val, "FilenamePattern", &f.FilenamePattern)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &f.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FromAllInputFile.
func (f FromAllInputFile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "includedTracks", f.IncludedTracks)
	objectMap["@odata.type"] = "#Microsoft.Media.FromAllInputFile"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FromAllInputFile.
func (f *FromAllInputFile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "includedTracks":
			f.IncludedTracks, err = unmarshalTrackDescriptorClassificationArray(val)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &f.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FromEachInputFile.
func (f FromEachInputFile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "includedTracks", f.IncludedTracks)
	objectMap["@odata.type"] = "#Microsoft.Media.FromEachInputFile"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FromEachInputFile.
func (f *FromEachInputFile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "includedTracks":
			f.IncludedTracks, err = unmarshalTrackDescriptorClassificationArray(val)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &f.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type H264Layer.
func (h H264Layer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "adaptiveBFrame", h.AdaptiveBFrame)
	populate(objectMap, "bFrames", h.BFrames)
	populate(objectMap, "bitrate", h.Bitrate)
	populate(objectMap, "bufferWindow", h.BufferWindow)
	populate(objectMap, "crf", h.Crf)
	populate(objectMap, "entropyMode", h.EntropyMode)
	populate(objectMap, "frameRate", h.FrameRate)
	populate(objectMap, "height", h.Height)
	populate(objectMap, "label", h.Label)
	populate(objectMap, "level", h.Level)
	populate(objectMap, "maxBitrate", h.MaxBitrate)
	populate(objectMap, "profile", h.Profile)
	populate(objectMap, "referenceFrames", h.ReferenceFrames)
	populate(objectMap, "slices", h.Slices)
	populate(objectMap, "width", h.Width)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type H264Layer.
func (h *H264Layer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adaptiveBFrame":
			err = unpopulate(val, "AdaptiveBFrame", &h.AdaptiveBFrame)
			delete(rawMsg, key)
		case "bFrames":
			err = unpopulate(val, "BFrames", &h.BFrames)
			delete(rawMsg, key)
		case "bitrate":
			err = unpopulate(val, "Bitrate", &h.Bitrate)
			delete(rawMsg, key)
		case "bufferWindow":
			err = unpopulate(val, "BufferWindow", &h.BufferWindow)
			delete(rawMsg, key)
		case "crf":
			err = unpopulate(val, "Crf", &h.Crf)
			delete(rawMsg, key)
		case "entropyMode":
			err = unpopulate(val, "EntropyMode", &h.EntropyMode)
			delete(rawMsg, key)
		case "frameRate":
			err = unpopulate(val, "FrameRate", &h.FrameRate)
			delete(rawMsg, key)
		case "height":
			err = unpopulate(val, "Height", &h.Height)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &h.Label)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, "Level", &h.Level)
			delete(rawMsg, key)
		case "maxBitrate":
			err = unpopulate(val, "MaxBitrate", &h.MaxBitrate)
			delete(rawMsg, key)
		case "profile":
			err = unpopulate(val, "Profile", &h.Profile)
			delete(rawMsg, key)
		case "referenceFrames":
			err = unpopulate(val, "ReferenceFrames", &h.ReferenceFrames)
			delete(rawMsg, key)
		case "slices":
			err = unpopulate(val, "Slices", &h.Slices)
			delete(rawMsg, key)
		case "width":
			err = unpopulate(val, "Width", &h.Width)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type H264Video.
func (h H264Video) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "complexity", h.Complexity)
	populate(objectMap, "keyFrameInterval", h.KeyFrameInterval)
	populate(objectMap, "label", h.Label)
	populate(objectMap, "layers", h.Layers)
	objectMap["@odata.type"] = "#Microsoft.Media.H264Video"
	populate(objectMap, "rateControlMode", h.RateControlMode)
	populate(objectMap, "sceneChangeDetection", h.SceneChangeDetection)
	populate(objectMap, "stretchMode", h.StretchMode)
	populate(objectMap, "syncMode", h.SyncMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type H264Video.
func (h *H264Video) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "complexity":
			err = unpopulate(val, "Complexity", &h.Complexity)
			delete(rawMsg, key)
		case "keyFrameInterval":
			err = unpopulate(val, "KeyFrameInterval", &h.KeyFrameInterval)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &h.Label)
			delete(rawMsg, key)
		case "layers":
			err = unpopulate(val, "Layers", &h.Layers)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &h.ODataType)
			delete(rawMsg, key)
		case "rateControlMode":
			err = unpopulate(val, "RateControlMode", &h.RateControlMode)
			delete(rawMsg, key)
		case "sceneChangeDetection":
			err = unpopulate(val, "SceneChangeDetection", &h.SceneChangeDetection)
			delete(rawMsg, key)
		case "stretchMode":
			err = unpopulate(val, "StretchMode", &h.StretchMode)
			delete(rawMsg, key)
		case "syncMode":
			err = unpopulate(val, "SyncMode", &h.SyncMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type H265Layer.
func (h H265Layer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "adaptiveBFrame", h.AdaptiveBFrame)
	populate(objectMap, "bFrames", h.BFrames)
	populate(objectMap, "bitrate", h.Bitrate)
	populate(objectMap, "bufferWindow", h.BufferWindow)
	populate(objectMap, "crf", h.Crf)
	populate(objectMap, "frameRate", h.FrameRate)
	populate(objectMap, "height", h.Height)
	populate(objectMap, "label", h.Label)
	populate(objectMap, "level", h.Level)
	populate(objectMap, "maxBitrate", h.MaxBitrate)
	populate(objectMap, "profile", h.Profile)
	populate(objectMap, "referenceFrames", h.ReferenceFrames)
	populate(objectMap, "slices", h.Slices)
	populate(objectMap, "width", h.Width)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type H265Layer.
func (h *H265Layer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adaptiveBFrame":
			err = unpopulate(val, "AdaptiveBFrame", &h.AdaptiveBFrame)
			delete(rawMsg, key)
		case "bFrames":
			err = unpopulate(val, "BFrames", &h.BFrames)
			delete(rawMsg, key)
		case "bitrate":
			err = unpopulate(val, "Bitrate", &h.Bitrate)
			delete(rawMsg, key)
		case "bufferWindow":
			err = unpopulate(val, "BufferWindow", &h.BufferWindow)
			delete(rawMsg, key)
		case "crf":
			err = unpopulate(val, "Crf", &h.Crf)
			delete(rawMsg, key)
		case "frameRate":
			err = unpopulate(val, "FrameRate", &h.FrameRate)
			delete(rawMsg, key)
		case "height":
			err = unpopulate(val, "Height", &h.Height)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &h.Label)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, "Level", &h.Level)
			delete(rawMsg, key)
		case "maxBitrate":
			err = unpopulate(val, "MaxBitrate", &h.MaxBitrate)
			delete(rawMsg, key)
		case "profile":
			err = unpopulate(val, "Profile", &h.Profile)
			delete(rawMsg, key)
		case "referenceFrames":
			err = unpopulate(val, "ReferenceFrames", &h.ReferenceFrames)
			delete(rawMsg, key)
		case "slices":
			err = unpopulate(val, "Slices", &h.Slices)
			delete(rawMsg, key)
		case "width":
			err = unpopulate(val, "Width", &h.Width)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type H265Video.
func (h H265Video) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "complexity", h.Complexity)
	populate(objectMap, "keyFrameInterval", h.KeyFrameInterval)
	populate(objectMap, "label", h.Label)
	populate(objectMap, "layers", h.Layers)
	objectMap["@odata.type"] = "#Microsoft.Media.H265Video"
	populate(objectMap, "sceneChangeDetection", h.SceneChangeDetection)
	populate(objectMap, "stretchMode", h.StretchMode)
	populate(objectMap, "syncMode", h.SyncMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type H265Video.
func (h *H265Video) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "complexity":
			err = unpopulate(val, "Complexity", &h.Complexity)
			delete(rawMsg, key)
		case "keyFrameInterval":
			err = unpopulate(val, "KeyFrameInterval", &h.KeyFrameInterval)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &h.Label)
			delete(rawMsg, key)
		case "layers":
			err = unpopulate(val, "Layers", &h.Layers)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &h.ODataType)
			delete(rawMsg, key)
		case "sceneChangeDetection":
			err = unpopulate(val, "SceneChangeDetection", &h.SceneChangeDetection)
			delete(rawMsg, key)
		case "stretchMode":
			err = unpopulate(val, "StretchMode", &h.StretchMode)
			delete(rawMsg, key)
		case "syncMode":
			err = unpopulate(val, "SyncMode", &h.SyncMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type H265VideoLayer.
func (h H265VideoLayer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "adaptiveBFrame", h.AdaptiveBFrame)
	populate(objectMap, "bFrames", h.BFrames)
	populate(objectMap, "bitrate", h.Bitrate)
	populate(objectMap, "frameRate", h.FrameRate)
	populate(objectMap, "height", h.Height)
	populate(objectMap, "label", h.Label)
	populate(objectMap, "maxBitrate", h.MaxBitrate)
	populate(objectMap, "slices", h.Slices)
	populate(objectMap, "width", h.Width)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type H265VideoLayer.
func (h *H265VideoLayer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adaptiveBFrame":
			err = unpopulate(val, "AdaptiveBFrame", &h.AdaptiveBFrame)
			delete(rawMsg, key)
		case "bFrames":
			err = unpopulate(val, "BFrames", &h.BFrames)
			delete(rawMsg, key)
		case "bitrate":
			err = unpopulate(val, "Bitrate", &h.Bitrate)
			delete(rawMsg, key)
		case "frameRate":
			err = unpopulate(val, "FrameRate", &h.FrameRate)
			delete(rawMsg, key)
		case "height":
			err = unpopulate(val, "Height", &h.Height)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &h.Label)
			delete(rawMsg, key)
		case "maxBitrate":
			err = unpopulate(val, "MaxBitrate", &h.MaxBitrate)
			delete(rawMsg, key)
		case "slices":
			err = unpopulate(val, "Slices", &h.Slices)
			delete(rawMsg, key)
		case "width":
			err = unpopulate(val, "Width", &h.Width)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Hls.
func (h Hls) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "fragmentsPerTsSegment", h.FragmentsPerTsSegment)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Hls.
func (h *Hls) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fragmentsPerTsSegment":
			err = unpopulate(val, "FragmentsPerTsSegment", &h.FragmentsPerTsSegment)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HlsSettings.
func (h HlsSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "characteristics", h.Characteristics)
	populate(objectMap, "default", h.Default)
	populate(objectMap, "forced", h.Forced)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HlsSettings.
func (h *HlsSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "characteristics":
			err = unpopulate(val, "Characteristics", &h.Characteristics)
			delete(rawMsg, key)
		case "default":
			err = unpopulate(val, "Default", &h.Default)
			delete(rawMsg, key)
		case "forced":
			err = unpopulate(val, "Forced", &h.Forced)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPAccessControl.
func (i IPAccessControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allow", i.Allow)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPAccessControl.
func (i *IPAccessControl) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allow":
			err = unpopulate(val, "Allow", &i.Allow)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPRange.
func (i IPRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "address", i.Address)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "subnetPrefixLength", i.SubnetPrefixLength)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPRange.
func (i *IPRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &i.Address)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "subnetPrefixLength":
			err = unpopulate(val, "SubnetPrefixLength", &i.SubnetPrefixLength)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Image.
func (i Image) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "keyFrameInterval", i.KeyFrameInterval)
	populate(objectMap, "label", i.Label)
	objectMap["@odata.type"] = "#Microsoft.Media.Image"
	populate(objectMap, "range", i.Range)
	populate(objectMap, "start", i.Start)
	populate(objectMap, "step", i.Step)
	populate(objectMap, "stretchMode", i.StretchMode)
	populate(objectMap, "syncMode", i.SyncMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Image.
func (i *Image) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyFrameInterval":
			err = unpopulate(val, "KeyFrameInterval", &i.KeyFrameInterval)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &i.Label)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &i.ODataType)
			delete(rawMsg, key)
		case "range":
			err = unpopulate(val, "Range", &i.Range)
			delete(rawMsg, key)
		case "start":
			err = unpopulate(val, "Start", &i.Start)
			delete(rawMsg, key)
		case "step":
			err = unpopulate(val, "Step", &i.Step)
			delete(rawMsg, key)
		case "stretchMode":
			err = unpopulate(val, "StretchMode", &i.StretchMode)
			delete(rawMsg, key)
		case "syncMode":
			err = unpopulate(val, "SyncMode", &i.SyncMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageFormat.
func (i ImageFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "filenamePattern", i.FilenamePattern)
	objectMap["@odata.type"] = "#Microsoft.Media.ImageFormat"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageFormat.
func (i *ImageFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filenamePattern":
			err = unpopulate(val, "FilenamePattern", &i.FilenamePattern)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &i.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InputDefinition.
func (i InputDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "includedTracks", i.IncludedTracks)
	objectMap["@odata.type"] = i.ODataType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InputDefinition.
func (i *InputDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "includedTracks":
			i.IncludedTracks, err = unmarshalTrackDescriptorClassificationArray(val)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &i.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InputFile.
func (i InputFile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "filename", i.Filename)
	populate(objectMap, "includedTracks", i.IncludedTracks)
	objectMap["@odata.type"] = "#Microsoft.Media.InputFile"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InputFile.
func (i *InputFile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filename":
			err = unpopulate(val, "Filename", &i.Filename)
			delete(rawMsg, key)
		case "includedTracks":
			i.IncludedTracks, err = unmarshalTrackDescriptorClassificationArray(val)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &i.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", j.ID)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "systemData", j.SystemData)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Job.
func (j *Job) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &j.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobCollection.
func (j JobCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "@odata.nextLink", j.ODataNextLink)
	populate(objectMap, "value", j.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobCollection.
func (j *JobCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.nextLink":
			err = unpopulate(val, "ODataNextLink", &j.ODataNextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &j.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobError.
func (j JobError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "category", j.Category)
	populate(objectMap, "code", j.Code)
	populate(objectMap, "details", j.Details)
	populate(objectMap, "message", j.Message)
	populate(objectMap, "retry", j.Retry)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobError.
func (j *JobError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &j.Category)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &j.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &j.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &j.Message)
			delete(rawMsg, key)
		case "retry":
			err = unpopulate(val, "Retry", &j.Retry)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobErrorDetail.
func (j JobErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", j.Code)
	populate(objectMap, "message", j.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobErrorDetail.
func (j *JobErrorDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &j.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &j.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobInput.
func (j JobInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = j.ODataType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobInput.
func (j *JobInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &j.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobInputAsset.
func (j JobInputAsset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assetName", j.AssetName)
	populate(objectMap, "end", j.End)
	populate(objectMap, "files", j.Files)
	populate(objectMap, "inputDefinitions", j.InputDefinitions)
	populate(objectMap, "label", j.Label)
	objectMap["@odata.type"] = "#Microsoft.Media.JobInputAsset"
	populate(objectMap, "start", j.Start)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobInputAsset.
func (j *JobInputAsset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assetName":
			err = unpopulate(val, "AssetName", &j.AssetName)
			delete(rawMsg, key)
		case "end":
			j.End, err = unmarshalClipTimeClassification(val)
			delete(rawMsg, key)
		case "files":
			err = unpopulate(val, "Files", &j.Files)
			delete(rawMsg, key)
		case "inputDefinitions":
			j.InputDefinitions, err = unmarshalInputDefinitionClassificationArray(val)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &j.Label)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &j.ODataType)
			delete(rawMsg, key)
		case "start":
			j.Start, err = unmarshalClipTimeClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobInputClip.
func (j JobInputClip) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "end", j.End)
	populate(objectMap, "files", j.Files)
	populate(objectMap, "inputDefinitions", j.InputDefinitions)
	populate(objectMap, "label", j.Label)
	objectMap["@odata.type"] = "#Microsoft.Media.JobInputClip"
	populate(objectMap, "start", j.Start)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobInputClip.
func (j *JobInputClip) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "end":
			j.End, err = unmarshalClipTimeClassification(val)
			delete(rawMsg, key)
		case "files":
			err = unpopulate(val, "Files", &j.Files)
			delete(rawMsg, key)
		case "inputDefinitions":
			j.InputDefinitions, err = unmarshalInputDefinitionClassificationArray(val)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &j.Label)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &j.ODataType)
			delete(rawMsg, key)
		case "start":
			j.Start, err = unmarshalClipTimeClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobInputHTTP.
func (j JobInputHTTP) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "baseUri", j.BaseURI)
	populate(objectMap, "end", j.End)
	populate(objectMap, "files", j.Files)
	populate(objectMap, "inputDefinitions", j.InputDefinitions)
	populate(objectMap, "label", j.Label)
	objectMap["@odata.type"] = "#Microsoft.Media.JobInputHttp"
	populate(objectMap, "start", j.Start)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobInputHTTP.
func (j *JobInputHTTP) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "baseUri":
			err = unpopulate(val, "BaseURI", &j.BaseURI)
			delete(rawMsg, key)
		case "end":
			j.End, err = unmarshalClipTimeClassification(val)
			delete(rawMsg, key)
		case "files":
			err = unpopulate(val, "Files", &j.Files)
			delete(rawMsg, key)
		case "inputDefinitions":
			j.InputDefinitions, err = unmarshalInputDefinitionClassificationArray(val)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &j.Label)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &j.ODataType)
			delete(rawMsg, key)
		case "start":
			j.Start, err = unmarshalClipTimeClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobInputSequence.
func (j JobInputSequence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "inputs", j.Inputs)
	objectMap["@odata.type"] = "#Microsoft.Media.JobInputSequence"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobInputSequence.
func (j *JobInputSequence) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inputs":
			j.Inputs, err = unmarshalJobInputClipClassificationArray(val)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &j.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobInputs.
func (j JobInputs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "inputs", j.Inputs)
	objectMap["@odata.type"] = "#Microsoft.Media.JobInputs"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobInputs.
func (j *JobInputs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inputs":
			j.Inputs, err = unmarshalJobInputClassificationArray(val)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &j.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobOutput.
func (j JobOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endTime", j.EndTime)
	populate(objectMap, "error", j.Error)
	populate(objectMap, "label", j.Label)
	objectMap["@odata.type"] = j.ODataType
	populate(objectMap, "presetOverride", j.PresetOverride)
	populate(objectMap, "progress", j.Progress)
	populateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "state", j.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobOutput.
func (j *JobOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &j.Error)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &j.Label)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &j.ODataType)
			delete(rawMsg, key)
		case "presetOverride":
			j.PresetOverride, err = unmarshalPresetClassification(val)
			delete(rawMsg, key)
		case "progress":
			err = unpopulate(val, "Progress", &j.Progress)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &j.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobOutputAsset.
func (j JobOutputAsset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assetName", j.AssetName)
	populateTimeRFC3339(objectMap, "endTime", j.EndTime)
	populate(objectMap, "error", j.Error)
	populate(objectMap, "label", j.Label)
	objectMap["@odata.type"] = "#Microsoft.Media.JobOutputAsset"
	populate(objectMap, "presetOverride", j.PresetOverride)
	populate(objectMap, "progress", j.Progress)
	populateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "state", j.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobOutputAsset.
func (j *JobOutputAsset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assetName":
			err = unpopulate(val, "AssetName", &j.AssetName)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &j.Error)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &j.Label)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &j.ODataType)
			delete(rawMsg, key)
		case "presetOverride":
			j.PresetOverride, err = unmarshalPresetClassification(val)
			delete(rawMsg, key)
		case "progress":
			err = unpopulate(val, "Progress", &j.Progress)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &j.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobProperties.
func (j JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "correlationData", j.CorrelationData)
	populateTimeRFC3339(objectMap, "created", j.Created)
	populate(objectMap, "description", j.Description)
	populateTimeRFC3339(objectMap, "endTime", j.EndTime)
	populate(objectMap, "input", j.Input)
	populateTimeRFC3339(objectMap, "lastModified", j.LastModified)
	populate(objectMap, "outputs", j.Outputs)
	populate(objectMap, "priority", j.Priority)
	populateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "state", j.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobProperties.
func (j *JobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationData":
			err = unpopulate(val, "CorrelationData", &j.CorrelationData)
			delete(rawMsg, key)
		case "created":
			err = unpopulateTimeRFC3339(val, "Created", &j.Created)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &j.Description)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "input":
			j.Input, err = unmarshalJobInputClassification(val)
			delete(rawMsg, key)
		case "lastModified":
			err = unpopulateTimeRFC3339(val, "LastModified", &j.LastModified)
			delete(rawMsg, key)
		case "outputs":
			j.Outputs, err = unmarshalJobOutputClassificationArray(val)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &j.Priority)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &j.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JpgFormat.
func (j JpgFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "filenamePattern", j.FilenamePattern)
	objectMap["@odata.type"] = "#Microsoft.Media.JpgFormat"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JpgFormat.
func (j *JpgFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filenamePattern":
			err = unpopulate(val, "FilenamePattern", &j.FilenamePattern)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &j.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JpgImage.
func (j JpgImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "keyFrameInterval", j.KeyFrameInterval)
	populate(objectMap, "label", j.Label)
	populate(objectMap, "layers", j.Layers)
	objectMap["@odata.type"] = "#Microsoft.Media.JpgImage"
	populate(objectMap, "range", j.Range)
	populate(objectMap, "spriteColumn", j.SpriteColumn)
	populate(objectMap, "start", j.Start)
	populate(objectMap, "step", j.Step)
	populate(objectMap, "stretchMode", j.StretchMode)
	populate(objectMap, "syncMode", j.SyncMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JpgImage.
func (j *JpgImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyFrameInterval":
			err = unpopulate(val, "KeyFrameInterval", &j.KeyFrameInterval)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &j.Label)
			delete(rawMsg, key)
		case "layers":
			err = unpopulate(val, "Layers", &j.Layers)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &j.ODataType)
			delete(rawMsg, key)
		case "range":
			err = unpopulate(val, "Range", &j.Range)
			delete(rawMsg, key)
		case "spriteColumn":
			err = unpopulate(val, "SpriteColumn", &j.SpriteColumn)
			delete(rawMsg, key)
		case "start":
			err = unpopulate(val, "Start", &j.Start)
			delete(rawMsg, key)
		case "step":
			err = unpopulate(val, "Step", &j.Step)
			delete(rawMsg, key)
		case "stretchMode":
			err = unpopulate(val, "StretchMode", &j.StretchMode)
			delete(rawMsg, key)
		case "syncMode":
			err = unpopulate(val, "SyncMode", &j.SyncMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JpgLayer.
func (j JpgLayer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "height", j.Height)
	populate(objectMap, "label", j.Label)
	populate(objectMap, "quality", j.Quality)
	populate(objectMap, "width", j.Width)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JpgLayer.
func (j *JpgLayer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "height":
			err = unpopulate(val, "Height", &j.Height)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &j.Label)
			delete(rawMsg, key)
		case "quality":
			err = unpopulate(val, "Quality", &j.Quality)
			delete(rawMsg, key)
		case "width":
			err = unpopulate(val, "Width", &j.Width)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyDelivery.
func (k KeyDelivery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accessControl", k.AccessControl)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyDelivery.
func (k *KeyDelivery) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessControl":
			err = unpopulate(val, "AccessControl", &k.AccessControl)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultProperties.
func (k KeyVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "currentKeyIdentifier", k.CurrentKeyIdentifier)
	populate(objectMap, "keyIdentifier", k.KeyIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultProperties.
func (k *KeyVaultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentKeyIdentifier":
			err = unpopulate(val, "CurrentKeyIdentifier", &k.CurrentKeyIdentifier)
			delete(rawMsg, key)
		case "keyIdentifier":
			err = unpopulate(val, "KeyIdentifier", &k.KeyIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Layer.
func (l Layer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "height", l.Height)
	populate(objectMap, "label", l.Label)
	populate(objectMap, "width", l.Width)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Layer.
func (l *Layer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "height":
			err = unpopulate(val, "Height", &l.Height)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &l.Label)
			delete(rawMsg, key)
		case "width":
			err = unpopulate(val, "Width", &l.Width)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListContainerSasInput.
func (l ListContainerSasInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "expiryTime", l.ExpiryTime)
	populate(objectMap, "permissions", l.Permissions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListContainerSasInput.
func (l *ListContainerSasInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiryTime":
			err = unpopulateTimeRFC3339(val, "ExpiryTime", &l.ExpiryTime)
			delete(rawMsg, key)
		case "permissions":
			err = unpopulate(val, "Permissions", &l.Permissions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListContentKeysResponse.
func (l ListContentKeysResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contentKeys", l.ContentKeys)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListContentKeysResponse.
func (l *ListContentKeysResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentKeys":
			err = unpopulate(val, "ContentKeys", &l.ContentKeys)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListEdgePoliciesInput.
func (l ListEdgePoliciesInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deviceId", l.DeviceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListEdgePoliciesInput.
func (l *ListEdgePoliciesInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceId":
			err = unpopulate(val, "DeviceID", &l.DeviceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListPathsResponse.
func (l ListPathsResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "downloadPaths", l.DownloadPaths)
	populate(objectMap, "streamingPaths", l.StreamingPaths)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListPathsResponse.
func (l *ListPathsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "downloadPaths":
			err = unpopulate(val, "DownloadPaths", &l.DownloadPaths)
			delete(rawMsg, key)
		case "streamingPaths":
			err = unpopulate(val, "StreamingPaths", &l.StreamingPaths)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListStreamingLocatorsResponse.
func (l ListStreamingLocatorsResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "streamingLocators", l.StreamingLocators)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListStreamingLocatorsResponse.
func (l *ListStreamingLocatorsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "streamingLocators":
			err = unpopulate(val, "StreamingLocators", &l.StreamingLocators)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LiveEvent.
func (l LiveEvent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", l.ID)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "systemData", l.SystemData)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LiveEvent.
func (l *LiveEvent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &l.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LiveEventActionInput.
func (l LiveEventActionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "removeOutputsOnStop", l.RemoveOutputsOnStop)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LiveEventActionInput.
func (l *LiveEventActionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "removeOutputsOnStop":
			err = unpopulate(val, "RemoveOutputsOnStop", &l.RemoveOutputsOnStop)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LiveEventEncoding.
func (l LiveEventEncoding) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "encodingType", l.EncodingType)
	populate(objectMap, "keyFrameInterval", l.KeyFrameInterval)
	populate(objectMap, "presetName", l.PresetName)
	populate(objectMap, "stretchMode", l.StretchMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LiveEventEncoding.
func (l *LiveEventEncoding) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encodingType":
			err = unpopulate(val, "EncodingType", &l.EncodingType)
			delete(rawMsg, key)
		case "keyFrameInterval":
			err = unpopulate(val, "KeyFrameInterval", &l.KeyFrameInterval)
			delete(rawMsg, key)
		case "presetName":
			err = unpopulate(val, "PresetName", &l.PresetName)
			delete(rawMsg, key)
		case "stretchMode":
			err = unpopulate(val, "StretchMode", &l.StretchMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LiveEventEndpoint.
func (l LiveEventEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "protocol", l.Protocol)
	populate(objectMap, "url", l.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LiveEventEndpoint.
func (l *LiveEventEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "protocol":
			err = unpopulate(val, "Protocol", &l.Protocol)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &l.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LiveEventInput.
func (l LiveEventInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accessControl", l.AccessControl)
	populate(objectMap, "accessToken", l.AccessToken)
	populate(objectMap, "endpoints", l.Endpoints)
	populate(objectMap, "keyFrameIntervalDuration", l.KeyFrameIntervalDuration)
	populate(objectMap, "streamingProtocol", l.StreamingProtocol)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LiveEventInput.
func (l *LiveEventInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessControl":
			err = unpopulate(val, "AccessControl", &l.AccessControl)
			delete(rawMsg, key)
		case "accessToken":
			err = unpopulate(val, "AccessToken", &l.AccessToken)
			delete(rawMsg, key)
		case "endpoints":
			err = unpopulate(val, "Endpoints", &l.Endpoints)
			delete(rawMsg, key)
		case "keyFrameIntervalDuration":
			err = unpopulate(val, "KeyFrameIntervalDuration", &l.KeyFrameIntervalDuration)
			delete(rawMsg, key)
		case "streamingProtocol":
			err = unpopulate(val, "StreamingProtocol", &l.StreamingProtocol)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LiveEventInputAccessControl.
func (l LiveEventInputAccessControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "ip", l.IP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LiveEventInputAccessControl.
func (l *LiveEventInputAccessControl) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ip":
			err = unpopulate(val, "IP", &l.IP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LiveEventInputTrackSelection.
func (l LiveEventInputTrackSelection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "operation", l.Operation)
	populate(objectMap, "property", l.Property)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LiveEventInputTrackSelection.
func (l *LiveEventInputTrackSelection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operation":
			err = unpopulate(val, "Operation", &l.Operation)
			delete(rawMsg, key)
		case "property":
			err = unpopulate(val, "Property", &l.Property)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LiveEventListResult.
func (l LiveEventListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "@odata.count", l.ODataCount)
	populate(objectMap, "@odata.nextLink", l.ODataNextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LiveEventListResult.
func (l *LiveEventListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.count":
			err = unpopulate(val, "ODataCount", &l.ODataCount)
			delete(rawMsg, key)
		case "@odata.nextLink":
			err = unpopulate(val, "ODataNextLink", &l.ODataNextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LiveEventOutputTranscriptionTrack.
func (l LiveEventOutputTranscriptionTrack) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "trackName", l.TrackName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LiveEventOutputTranscriptionTrack.
func (l *LiveEventOutputTranscriptionTrack) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "trackName":
			err = unpopulate(val, "TrackName", &l.TrackName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LiveEventPreview.
func (l LiveEventPreview) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accessControl", l.AccessControl)
	populate(objectMap, "alternativeMediaId", l.AlternativeMediaID)
	populate(objectMap, "endpoints", l.Endpoints)
	populate(objectMap, "previewLocator", l.PreviewLocator)
	populate(objectMap, "streamingPolicyName", l.StreamingPolicyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LiveEventPreview.
func (l *LiveEventPreview) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessControl":
			err = unpopulate(val, "AccessControl", &l.AccessControl)
			delete(rawMsg, key)
		case "alternativeMediaId":
			err = unpopulate(val, "AlternativeMediaID", &l.AlternativeMediaID)
			delete(rawMsg, key)
		case "endpoints":
			err = unpopulate(val, "Endpoints", &l.Endpoints)
			delete(rawMsg, key)
		case "previewLocator":
			err = unpopulate(val, "PreviewLocator", &l.PreviewLocator)
			delete(rawMsg, key)
		case "streamingPolicyName":
			err = unpopulate(val, "StreamingPolicyName", &l.StreamingPolicyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LiveEventPreviewAccessControl.
func (l LiveEventPreviewAccessControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "ip", l.IP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LiveEventPreviewAccessControl.
func (l *LiveEventPreviewAccessControl) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ip":
			err = unpopulate(val, "IP", &l.IP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LiveEventProperties.
func (l LiveEventProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "created", l.Created)
	populate(objectMap, "crossSiteAccessPolicies", l.CrossSiteAccessPolicies)
	populate(objectMap, "description", l.Description)
	populate(objectMap, "encoding", l.Encoding)
	populate(objectMap, "hostnamePrefix", l.HostnamePrefix)
	populate(objectMap, "input", l.Input)
	populateTimeRFC3339(objectMap, "lastModified", l.LastModified)
	populate(objectMap, "preview", l.Preview)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "resourceState", l.ResourceState)
	populate(objectMap, "streamOptions", l.StreamOptions)
	populate(objectMap, "transcriptions", l.Transcriptions)
	populate(objectMap, "useStaticHostname", l.UseStaticHostname)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LiveEventProperties.
func (l *LiveEventProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "created":
			err = unpopulateTimeRFC3339(val, "Created", &l.Created)
			delete(rawMsg, key)
		case "crossSiteAccessPolicies":
			err = unpopulate(val, "CrossSiteAccessPolicies", &l.CrossSiteAccessPolicies)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &l.Description)
			delete(rawMsg, key)
		case "encoding":
			err = unpopulate(val, "Encoding", &l.Encoding)
			delete(rawMsg, key)
		case "hostnamePrefix":
			err = unpopulate(val, "HostnamePrefix", &l.HostnamePrefix)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &l.Input)
			delete(rawMsg, key)
		case "lastModified":
			err = unpopulateTimeRFC3339(val, "LastModified", &l.LastModified)
			delete(rawMsg, key)
		case "preview":
			err = unpopulate(val, "Preview", &l.Preview)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &l.ResourceState)
			delete(rawMsg, key)
		case "streamOptions":
			err = unpopulate(val, "StreamOptions", &l.StreamOptions)
			delete(rawMsg, key)
		case "transcriptions":
			err = unpopulate(val, "Transcriptions", &l.Transcriptions)
			delete(rawMsg, key)
		case "useStaticHostname":
			err = unpopulate(val, "UseStaticHostname", &l.UseStaticHostname)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LiveEventTranscription.
func (l LiveEventTranscription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "inputTrackSelection", l.InputTrackSelection)
	populate(objectMap, "language", l.Language)
	populate(objectMap, "outputTranscriptionTrack", l.OutputTranscriptionTrack)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LiveEventTranscription.
func (l *LiveEventTranscription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inputTrackSelection":
			err = unpopulate(val, "InputTrackSelection", &l.InputTrackSelection)
			delete(rawMsg, key)
		case "language":
			err = unpopulate(val, "Language", &l.Language)
			delete(rawMsg, key)
		case "outputTranscriptionTrack":
			err = unpopulate(val, "OutputTranscriptionTrack", &l.OutputTranscriptionTrack)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LiveOutput.
func (l LiveOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "systemData", l.SystemData)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LiveOutput.
func (l *LiveOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &l.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LiveOutputListResult.
func (l LiveOutputListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "@odata.count", l.ODataCount)
	populate(objectMap, "@odata.nextLink", l.ODataNextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LiveOutputListResult.
func (l *LiveOutputListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.count":
			err = unpopulate(val, "ODataCount", &l.ODataCount)
			delete(rawMsg, key)
		case "@odata.nextLink":
			err = unpopulate(val, "ODataNextLink", &l.ODataNextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LiveOutputProperties.
func (l LiveOutputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "archiveWindowLength", l.ArchiveWindowLength)
	populate(objectMap, "assetName", l.AssetName)
	populateTimeRFC3339(objectMap, "created", l.Created)
	populate(objectMap, "description", l.Description)
	populate(objectMap, "hls", l.Hls)
	populateTimeRFC3339(objectMap, "lastModified", l.LastModified)
	populate(objectMap, "manifestName", l.ManifestName)
	populate(objectMap, "outputSnapTime", l.OutputSnapTime)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "resourceState", l.ResourceState)
	populate(objectMap, "rewindWindowLength", l.RewindWindowLength)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LiveOutputProperties.
func (l *LiveOutputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "archiveWindowLength":
			err = unpopulate(val, "ArchiveWindowLength", &l.ArchiveWindowLength)
			delete(rawMsg, key)
		case "assetName":
			err = unpopulate(val, "AssetName", &l.AssetName)
			delete(rawMsg, key)
		case "created":
			err = unpopulateTimeRFC3339(val, "Created", &l.Created)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &l.Description)
			delete(rawMsg, key)
		case "hls":
			err = unpopulate(val, "Hls", &l.Hls)
			delete(rawMsg, key)
		case "lastModified":
			err = unpopulateTimeRFC3339(val, "LastModified", &l.LastModified)
			delete(rawMsg, key)
		case "manifestName":
			err = unpopulate(val, "ManifestName", &l.ManifestName)
			delete(rawMsg, key)
		case "outputSnapTime":
			err = unpopulate(val, "OutputSnapTime", &l.OutputSnapTime)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &l.ResourceState)
			delete(rawMsg, key)
		case "rewindWindowLength":
			err = unpopulate(val, "RewindWindowLength", &l.RewindWindowLength)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogSpecification.
func (l LogSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blobDuration", l.BlobDuration)
	populate(objectMap, "displayName", l.DisplayName)
	populate(objectMap, "name", l.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogSpecification.
func (l *LogSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobDuration":
			err = unpopulate(val, "BlobDuration", &l.BlobDuration)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &l.DisplayName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaFilterProperties.
func (m MediaFilterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "firstQuality", m.FirstQuality)
	populate(objectMap, "presentationTimeRange", m.PresentationTimeRange)
	populate(objectMap, "tracks", m.Tracks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaFilterProperties.
func (m *MediaFilterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "firstQuality":
			err = unpopulate(val, "FirstQuality", &m.FirstQuality)
			delete(rawMsg, key)
		case "presentationTimeRange":
			err = unpopulate(val, "PresentationTimeRange", &m.PresentationTimeRange)
			delete(rawMsg, key)
		case "tracks":
			err = unpopulate(val, "Tracks", &m.Tracks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaService.
func (m MediaService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", m.ID)
	populate(objectMap, "identity", m.Identity)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaService.
func (m *MediaService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &m.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaServiceCollection.
func (m MediaServiceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "@odata.nextLink", m.ODataNextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaServiceCollection.
func (m *MediaServiceCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.nextLink":
			err = unpopulate(val, "ODataNextLink", &m.ODataNextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaServiceIdentity.
func (m MediaServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaServiceIdentity.
func (m *MediaServiceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &m.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &m.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &m.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaServiceOperationStatus.
func (m MediaServiceOperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endTime", m.EndTime)
	populate(objectMap, "error", m.Error)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populateTimeRFC3339(objectMap, "startTime", m.StartTime)
	populate(objectMap, "status", m.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaServiceOperationStatus.
func (m *MediaServiceOperationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &m.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &m.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &m.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &m.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaServiceProperties.
func (m MediaServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "encryption", m.Encryption)
	populate(objectMap, "keyDelivery", m.KeyDelivery)
	populate(objectMap, "mediaServiceId", m.MediaServiceID)
	populate(objectMap, "privateEndpointConnections", m.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", m.PublicNetworkAccess)
	populate(objectMap, "storageAccounts", m.StorageAccounts)
	populate(objectMap, "storageAuthentication", m.StorageAuthentication)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaServiceProperties.
func (m *MediaServiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryption":
			err = unpopulate(val, "Encryption", &m.Encryption)
			delete(rawMsg, key)
		case "keyDelivery":
			err = unpopulate(val, "KeyDelivery", &m.KeyDelivery)
			delete(rawMsg, key)
		case "mediaServiceId":
			err = unpopulate(val, "MediaServiceID", &m.MediaServiceID)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &m.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &m.PublicNetworkAccess)
			delete(rawMsg, key)
		case "storageAccounts":
			err = unpopulate(val, "StorageAccounts", &m.StorageAccounts)
			delete(rawMsg, key)
		case "storageAuthentication":
			err = unpopulate(val, "StorageAuthentication", &m.StorageAuthentication)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaServiceUpdate.
func (m MediaServiceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", m.Identity)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaServiceUpdate.
func (m *MediaServiceUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &m.Identity)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricDimension.
func (m MetricDimension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "toBeExportedForShoebox", m.ToBeExportedForShoebox)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricDimension.
func (m *MetricDimension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "toBeExportedForShoebox":
			err = unpopulate(val, "ToBeExportedForShoebox", &m.ToBeExportedForShoebox)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricSpecification.
func (m MetricSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "aggregationType", m.AggregationType)
	populate(objectMap, "dimensions", m.Dimensions)
	populate(objectMap, "displayDescription", m.DisplayDescription)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "enableRegionalMdmAccount", m.EnableRegionalMdmAccount)
	populate(objectMap, "lockAggregationType", m.LockAggregationType)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "sourceMdmAccount", m.SourceMdmAccount)
	populate(objectMap, "sourceMdmNamespace", m.SourceMdmNamespace)
	populate(objectMap, "supportedAggregationTypes", m.SupportedAggregationTypes)
	populate(objectMap, "supportedTimeGrainTypes", m.SupportedTimeGrainTypes)
	populate(objectMap, "unit", m.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricSpecification.
func (m *MetricSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregationType":
			err = unpopulate(val, "AggregationType", &m.AggregationType)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &m.Dimensions)
			delete(rawMsg, key)
		case "displayDescription":
			err = unpopulate(val, "DisplayDescription", &m.DisplayDescription)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "enableRegionalMdmAccount":
			err = unpopulate(val, "EnableRegionalMdmAccount", &m.EnableRegionalMdmAccount)
			delete(rawMsg, key)
		case "lockAggregationType":
			err = unpopulate(val, "LockAggregationType", &m.LockAggregationType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "sourceMdmAccount":
			err = unpopulate(val, "SourceMdmAccount", &m.SourceMdmAccount)
			delete(rawMsg, key)
		case "sourceMdmNamespace":
			err = unpopulate(val, "SourceMdmNamespace", &m.SourceMdmNamespace)
			delete(rawMsg, key)
		case "supportedAggregationTypes":
			err = unpopulate(val, "SupportedAggregationTypes", &m.SupportedAggregationTypes)
			delete(rawMsg, key)
		case "supportedTimeGrainTypes":
			err = unpopulate(val, "SupportedTimeGrainTypes", &m.SupportedTimeGrainTypes)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &m.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Mp4Format.
func (m Mp4Format) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "filenamePattern", m.FilenamePattern)
	objectMap["@odata.type"] = "#Microsoft.Media.Mp4Format"
	populate(objectMap, "outputFiles", m.OutputFiles)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Mp4Format.
func (m *Mp4Format) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filenamePattern":
			err = unpopulate(val, "FilenamePattern", &m.FilenamePattern)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &m.ODataType)
			delete(rawMsg, key)
		case "outputFiles":
			err = unpopulate(val, "OutputFiles", &m.OutputFiles)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MultiBitrateFormat.
func (m MultiBitrateFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "filenamePattern", m.FilenamePattern)
	objectMap["@odata.type"] = "#Microsoft.Media.MultiBitrateFormat"
	populate(objectMap, "outputFiles", m.OutputFiles)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MultiBitrateFormat.
func (m *MultiBitrateFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filenamePattern":
			err = unpopulate(val, "FilenamePattern", &m.FilenamePattern)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &m.ODataType)
			delete(rawMsg, key)
		case "outputFiles":
			err = unpopulate(val, "OutputFiles", &m.OutputFiles)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NoEncryption.
func (n NoEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enabledProtocols", n.EnabledProtocols)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NoEncryption.
func (n *NoEncryption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabledProtocols":
			err = unpopulate(val, "EnabledProtocols", &n.EnabledProtocols)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionType", o.ActionType)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	populate(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &o.ActionType)
			delete(rawMsg, key)
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationCollection.
func (o OperationCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationCollection.
func (o *OperationCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OutputFile.
func (o OutputFile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "labels", o.Labels)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OutputFile.
func (o *OutputFile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "labels":
			err = unpopulate(val, "Labels", &o.Labels)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Overlay.
func (o Overlay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "audioGainLevel", o.AudioGainLevel)
	populate(objectMap, "end", o.End)
	populate(objectMap, "fadeInDuration", o.FadeInDuration)
	populate(objectMap, "fadeOutDuration", o.FadeOutDuration)
	populate(objectMap, "inputLabel", o.InputLabel)
	objectMap["@odata.type"] = o.ODataType
	populate(objectMap, "start", o.Start)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Overlay.
func (o *Overlay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "audioGainLevel":
			err = unpopulate(val, "AudioGainLevel", &o.AudioGainLevel)
			delete(rawMsg, key)
		case "end":
			err = unpopulate(val, "End", &o.End)
			delete(rawMsg, key)
		case "fadeInDuration":
			err = unpopulate(val, "FadeInDuration", &o.FadeInDuration)
			delete(rawMsg, key)
		case "fadeOutDuration":
			err = unpopulate(val, "FadeOutDuration", &o.FadeOutDuration)
			delete(rawMsg, key)
		case "inputLabel":
			err = unpopulate(val, "InputLabel", &o.InputLabel)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &o.ODataType)
			delete(rawMsg, key)
		case "start":
			err = unpopulate(val, "Start", &o.Start)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PNGFormat.
func (p PNGFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "filenamePattern", p.FilenamePattern)
	objectMap["@odata.type"] = "#Microsoft.Media.PngFormat"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PNGFormat.
func (p *PNGFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filenamePattern":
			err = unpopulate(val, "FilenamePattern", &p.FilenamePattern)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &p.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PNGImage.
func (p PNGImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "keyFrameInterval", p.KeyFrameInterval)
	populate(objectMap, "label", p.Label)
	populate(objectMap, "layers", p.Layers)
	objectMap["@odata.type"] = "#Microsoft.Media.PngImage"
	populate(objectMap, "range", p.Range)
	populate(objectMap, "start", p.Start)
	populate(objectMap, "step", p.Step)
	populate(objectMap, "stretchMode", p.StretchMode)
	populate(objectMap, "syncMode", p.SyncMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PNGImage.
func (p *PNGImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyFrameInterval":
			err = unpopulate(val, "KeyFrameInterval", &p.KeyFrameInterval)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &p.Label)
			delete(rawMsg, key)
		case "layers":
			err = unpopulate(val, "Layers", &p.Layers)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &p.ODataType)
			delete(rawMsg, key)
		case "range":
			err = unpopulate(val, "Range", &p.Range)
			delete(rawMsg, key)
		case "start":
			err = unpopulate(val, "Start", &p.Start)
			delete(rawMsg, key)
		case "step":
			err = unpopulate(val, "Step", &p.Step)
			delete(rawMsg, key)
		case "stretchMode":
			err = unpopulate(val, "StretchMode", &p.StretchMode)
			delete(rawMsg, key)
		case "syncMode":
			err = unpopulate(val, "SyncMode", &p.SyncMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PNGLayer.
func (p PNGLayer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "height", p.Height)
	populate(objectMap, "label", p.Label)
	populate(objectMap, "width", p.Width)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PNGLayer.
func (p *PNGLayer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "height":
			err = unpopulate(val, "Height", &p.Height)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &p.Label)
			delete(rawMsg, key)
		case "width":
			err = unpopulate(val, "Width", &p.Width)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PresentationTimeRange.
func (p PresentationTimeRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "endTimestamp", p.EndTimestamp)
	populate(objectMap, "forceEndTimestamp", p.ForceEndTimestamp)
	populate(objectMap, "liveBackoffDuration", p.LiveBackoffDuration)
	populate(objectMap, "presentationWindowDuration", p.PresentationWindowDuration)
	populate(objectMap, "startTimestamp", p.StartTimestamp)
	populate(objectMap, "timescale", p.Timescale)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PresentationTimeRange.
func (p *PresentationTimeRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTimestamp":
			err = unpopulate(val, "EndTimestamp", &p.EndTimestamp)
			delete(rawMsg, key)
		case "forceEndTimestamp":
			err = unpopulate(val, "ForceEndTimestamp", &p.ForceEndTimestamp)
			delete(rawMsg, key)
		case "liveBackoffDuration":
			err = unpopulate(val, "LiveBackoffDuration", &p.LiveBackoffDuration)
			delete(rawMsg, key)
		case "presentationWindowDuration":
			err = unpopulate(val, "PresentationWindowDuration", &p.PresentationWindowDuration)
			delete(rawMsg, key)
		case "startTimestamp":
			err = unpopulate(val, "StartTimestamp", &p.StartTimestamp)
			delete(rawMsg, key)
		case "timescale":
			err = unpopulate(val, "Timescale", &p.Timescale)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Preset.
func (p Preset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = p.ODataType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Preset.
func (p *Preset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &p.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PresetConfigurations.
func (p PresetConfigurations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "complexity", p.Complexity)
	populate(objectMap, "interleaveOutput", p.InterleaveOutput)
	populate(objectMap, "keyFrameIntervalInSeconds", p.KeyFrameIntervalInSeconds)
	populate(objectMap, "maxBitrateBps", p.MaxBitrateBps)
	populate(objectMap, "maxHeight", p.MaxHeight)
	populate(objectMap, "maxLayers", p.MaxLayers)
	populate(objectMap, "minBitrateBps", p.MinBitrateBps)
	populate(objectMap, "minHeight", p.MinHeight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PresetConfigurations.
func (p *PresetConfigurations) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "complexity":
			err = unpopulate(val, "Complexity", &p.Complexity)
			delete(rawMsg, key)
		case "interleaveOutput":
			err = unpopulate(val, "InterleaveOutput", &p.InterleaveOutput)
			delete(rawMsg, key)
		case "keyFrameIntervalInSeconds":
			err = unpopulate(val, "KeyFrameIntervalInSeconds", &p.KeyFrameIntervalInSeconds)
			delete(rawMsg, key)
		case "maxBitrateBps":
			err = unpopulate(val, "MaxBitrateBps", &p.MaxBitrateBps)
			delete(rawMsg, key)
		case "maxHeight":
			err = unpopulate(val, "MaxHeight", &p.MaxHeight)
			delete(rawMsg, key)
		case "maxLayers":
			err = unpopulate(val, "MaxLayers", &p.MaxLayers)
			delete(rawMsg, key)
		case "minBitrateBps":
			err = unpopulate(val, "MinBitrateBps", &p.MinBitrateBps)
			delete(rawMsg, key)
		case "minHeight":
			err = unpopulate(val, "MinHeight", &p.MinHeight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpoint.
func (p PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpoint.
func (p *PrivateEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnection.
func (p PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnection.
func (p *PrivateEndpointConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionListResult.
func (p PrivateEndpointConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionListResult.
func (p *PrivateEndpointConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionProperties.
func (p PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "privateEndpoint", p.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionProperties.
func (p *PrivateEndpointConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &p.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResource.
func (p PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResource.
func (p *PrivateLinkResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceListResult.
func (p PrivateLinkResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceListResult.
func (p *PrivateLinkResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceProperties.
func (p *PrivateLinkResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "requiredMembers":
			err = unpopulate(val, "RequiredMembers", &p.RequiredMembers)
			delete(rawMsg, key)
		case "requiredZoneNames":
			err = unpopulate(val, "RequiredZoneNames", &p.RequiredZoneNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnectionState.
func (p PrivateLinkServiceConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionsRequired", p.ActionsRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnectionState.
func (p *PrivateLinkServiceConnectionState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsRequired":
			err = unpopulate(val, "ActionsRequired", &p.ActionsRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "serviceSpecification", p.ServiceSpecification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Properties.
func (p *Properties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceSpecification":
			err = unpopulate(val, "ServiceSpecification", &p.ServiceSpecification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Rectangle.
func (r Rectangle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "height", r.Height)
	populate(objectMap, "left", r.Left)
	populate(objectMap, "top", r.Top)
	populate(objectMap, "width", r.Width)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Rectangle.
func (r *Rectangle) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "height":
			err = unpopulate(val, "Height", &r.Height)
			delete(rawMsg, key)
		case "left":
			err = unpopulate(val, "Left", &r.Left)
			delete(rawMsg, key)
		case "top":
			err = unpopulate(val, "Top", &r.Top)
			delete(rawMsg, key)
		case "width":
			err = unpopulate(val, "Width", &r.Width)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceIdentity.
func (r ResourceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "useSystemAssignedIdentity", r.UseSystemAssignedIdentity)
	populate(objectMap, "userAssignedIdentity", r.UserAssignedIdentity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceIdentity.
func (r *ResourceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "useSystemAssignedIdentity":
			err = unpopulate(val, "UseSystemAssignedIdentity", &r.UseSystemAssignedIdentity)
			delete(rawMsg, key)
		case "userAssignedIdentity":
			err = unpopulate(val, "UserAssignedIdentity", &r.UserAssignedIdentity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SelectAudioTrackByAttribute.
func (s SelectAudioTrackByAttribute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "attribute", s.Attribute)
	populate(objectMap, "channelMapping", s.ChannelMapping)
	populate(objectMap, "filter", s.Filter)
	populate(objectMap, "filterValue", s.FilterValue)
	objectMap["@odata.type"] = "#Microsoft.Media.SelectAudioTrackByAttribute"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SelectAudioTrackByAttribute.
func (s *SelectAudioTrackByAttribute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attribute":
			err = unpopulate(val, "Attribute", &s.Attribute)
			delete(rawMsg, key)
		case "channelMapping":
			err = unpopulate(val, "ChannelMapping", &s.ChannelMapping)
			delete(rawMsg, key)
		case "filter":
			err = unpopulate(val, "Filter", &s.Filter)
			delete(rawMsg, key)
		case "filterValue":
			err = unpopulate(val, "FilterValue", &s.FilterValue)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &s.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SelectAudioTrackByID.
func (s SelectAudioTrackByID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "channelMapping", s.ChannelMapping)
	objectMap["@odata.type"] = "#Microsoft.Media.SelectAudioTrackById"
	populate(objectMap, "trackId", s.TrackID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SelectAudioTrackByID.
func (s *SelectAudioTrackByID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelMapping":
			err = unpopulate(val, "ChannelMapping", &s.ChannelMapping)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &s.ODataType)
			delete(rawMsg, key)
		case "trackId":
			err = unpopulate(val, "TrackID", &s.TrackID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SelectVideoTrackByAttribute.
func (s SelectVideoTrackByAttribute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "attribute", s.Attribute)
	populate(objectMap, "filter", s.Filter)
	populate(objectMap, "filterValue", s.FilterValue)
	objectMap["@odata.type"] = "#Microsoft.Media.SelectVideoTrackByAttribute"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SelectVideoTrackByAttribute.
func (s *SelectVideoTrackByAttribute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attribute":
			err = unpopulate(val, "Attribute", &s.Attribute)
			delete(rawMsg, key)
		case "filter":
			err = unpopulate(val, "Filter", &s.Filter)
			delete(rawMsg, key)
		case "filterValue":
			err = unpopulate(val, "FilterValue", &s.FilterValue)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &s.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SelectVideoTrackByID.
func (s SelectVideoTrackByID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = "#Microsoft.Media.SelectVideoTrackById"
	populate(objectMap, "trackId", s.TrackID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SelectVideoTrackByID.
func (s *SelectVideoTrackByID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &s.ODataType)
			delete(rawMsg, key)
		case "trackId":
			err = unpopulate(val, "TrackID", &s.TrackID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceSpecification.
func (s ServiceSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "logSpecifications", s.LogSpecifications)
	populate(objectMap, "metricSpecifications", s.MetricSpecifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceSpecification.
func (s *ServiceSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logSpecifications":
			err = unpopulate(val, "LogSpecifications", &s.LogSpecifications)
			delete(rawMsg, key)
		case "metricSpecifications":
			err = unpopulate(val, "MetricSpecifications", &s.MetricSpecifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StandardEncoderPreset.
func (s StandardEncoderPreset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "codecs", s.Codecs)
	populate(objectMap, "filters", s.Filters)
	populate(objectMap, "formats", s.Formats)
	objectMap["@odata.type"] = "#Microsoft.Media.StandardEncoderPreset"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StandardEncoderPreset.
func (s *StandardEncoderPreset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "codecs":
			s.Codecs, err = unmarshalCodecClassificationArray(val)
			delete(rawMsg, key)
		case "filters":
			err = unpopulate(val, "Filters", &s.Filters)
			delete(rawMsg, key)
		case "formats":
			s.Formats, err = unmarshalFormatClassificationArray(val)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &s.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageAccount.
func (s StorageAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageAccount.
func (s *StorageAccount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageEncryptedAssetDecryptionData.
func (s StorageEncryptedAssetDecryptionData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assetFileEncryptionMetadata", s.AssetFileEncryptionMetadata)
	populateByteArray(objectMap, "key", s.Key, runtime.Base64StdFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageEncryptedAssetDecryptionData.
func (s *StorageEncryptedAssetDecryptionData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assetFileEncryptionMetadata":
			err = unpopulate(val, "AssetFileEncryptionMetadata", &s.AssetFileEncryptionMetadata)
			delete(rawMsg, key)
		case "key":
			err = runtime.DecodeByteArray(string(val), &s.Key, runtime.Base64StdFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingEndpoint.
func (s StreamingEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingEndpoint.
func (s *StreamingEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingEndpointAccessControl.
func (s StreamingEndpointAccessControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "akamai", s.Akamai)
	populate(objectMap, "ip", s.IP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingEndpointAccessControl.
func (s *StreamingEndpointAccessControl) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "akamai":
			err = unpopulate(val, "Akamai", &s.Akamai)
			delete(rawMsg, key)
		case "ip":
			err = unpopulate(val, "IP", &s.IP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingEndpointListResult.
func (s StreamingEndpointListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "@odata.count", s.ODataCount)
	populate(objectMap, "@odata.nextLink", s.ODataNextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingEndpointListResult.
func (s *StreamingEndpointListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.count":
			err = unpopulate(val, "ODataCount", &s.ODataCount)
			delete(rawMsg, key)
		case "@odata.nextLink":
			err = unpopulate(val, "ODataNextLink", &s.ODataNextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingEndpointProperties.
func (s StreamingEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accessControl", s.AccessControl)
	populate(objectMap, "availabilitySetName", s.AvailabilitySetName)
	populate(objectMap, "cdnEnabled", s.CdnEnabled)
	populate(objectMap, "cdnProfile", s.CdnProfile)
	populate(objectMap, "cdnProvider", s.CdnProvider)
	populateTimeRFC3339(objectMap, "created", s.Created)
	populate(objectMap, "crossSiteAccessPolicies", s.CrossSiteAccessPolicies)
	populate(objectMap, "customHostNames", s.CustomHostNames)
	populate(objectMap, "description", s.Description)
	populateTimeRFC3339(objectMap, "freeTrialEndTime", s.FreeTrialEndTime)
	populate(objectMap, "hostName", s.HostName)
	populateTimeRFC3339(objectMap, "lastModified", s.LastModified)
	populate(objectMap, "maxCacheAge", s.MaxCacheAge)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "resourceState", s.ResourceState)
	populate(objectMap, "scaleUnits", s.ScaleUnits)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingEndpointProperties.
func (s *StreamingEndpointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessControl":
			err = unpopulate(val, "AccessControl", &s.AccessControl)
			delete(rawMsg, key)
		case "availabilitySetName":
			err = unpopulate(val, "AvailabilitySetName", &s.AvailabilitySetName)
			delete(rawMsg, key)
		case "cdnEnabled":
			err = unpopulate(val, "CdnEnabled", &s.CdnEnabled)
			delete(rawMsg, key)
		case "cdnProfile":
			err = unpopulate(val, "CdnProfile", &s.CdnProfile)
			delete(rawMsg, key)
		case "cdnProvider":
			err = unpopulate(val, "CdnProvider", &s.CdnProvider)
			delete(rawMsg, key)
		case "created":
			err = unpopulateTimeRFC3339(val, "Created", &s.Created)
			delete(rawMsg, key)
		case "crossSiteAccessPolicies":
			err = unpopulate(val, "CrossSiteAccessPolicies", &s.CrossSiteAccessPolicies)
			delete(rawMsg, key)
		case "customHostNames":
			err = unpopulate(val, "CustomHostNames", &s.CustomHostNames)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "freeTrialEndTime":
			err = unpopulateTimeRFC3339(val, "FreeTrialEndTime", &s.FreeTrialEndTime)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &s.HostName)
			delete(rawMsg, key)
		case "lastModified":
			err = unpopulateTimeRFC3339(val, "LastModified", &s.LastModified)
			delete(rawMsg, key)
		case "maxCacheAge":
			err = unpopulate(val, "MaxCacheAge", &s.MaxCacheAge)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &s.ResourceState)
			delete(rawMsg, key)
		case "scaleUnits":
			err = unpopulate(val, "ScaleUnits", &s.ScaleUnits)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingEndpointSKUInfoListResult.
func (s StreamingEndpointSKUInfoListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingEndpointSKUInfoListResult.
func (s *StreamingEndpointSKUInfoListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingEntityScaleUnit.
func (s StreamingEntityScaleUnit) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "scaleUnit", s.ScaleUnit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingEntityScaleUnit.
func (s *StreamingEntityScaleUnit) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scaleUnit":
			err = unpopulate(val, "ScaleUnit", &s.ScaleUnit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingLocator.
func (s StreamingLocator) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingLocator.
func (s *StreamingLocator) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingLocatorCollection.
func (s StreamingLocatorCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "@odata.nextLink", s.ODataNextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingLocatorCollection.
func (s *StreamingLocatorCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.nextLink":
			err = unpopulate(val, "ODataNextLink", &s.ODataNextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingLocatorContentKey.
func (s StreamingLocatorContentKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "labelReferenceInStreamingPolicy", s.LabelReferenceInStreamingPolicy)
	populate(objectMap, "policyName", s.PolicyName)
	populate(objectMap, "tracks", s.Tracks)
	populate(objectMap, "type", s.Type)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingLocatorContentKey.
func (s *StreamingLocatorContentKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "labelReferenceInStreamingPolicy":
			err = unpopulate(val, "LabelReferenceInStreamingPolicy", &s.LabelReferenceInStreamingPolicy)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &s.PolicyName)
			delete(rawMsg, key)
		case "tracks":
			err = unpopulate(val, "Tracks", &s.Tracks)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingLocatorProperties.
func (s StreamingLocatorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alternativeMediaId", s.AlternativeMediaID)
	populate(objectMap, "assetName", s.AssetName)
	populate(objectMap, "contentKeys", s.ContentKeys)
	populateTimeRFC3339(objectMap, "created", s.Created)
	populate(objectMap, "defaultContentKeyPolicyName", s.DefaultContentKeyPolicyName)
	populateTimeRFC3339(objectMap, "endTime", s.EndTime)
	populate(objectMap, "filters", s.Filters)
	populateTimeRFC3339(objectMap, "startTime", s.StartTime)
	populate(objectMap, "streamingLocatorId", s.StreamingLocatorID)
	populate(objectMap, "streamingPolicyName", s.StreamingPolicyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingLocatorProperties.
func (s *StreamingLocatorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alternativeMediaId":
			err = unpopulate(val, "AlternativeMediaID", &s.AlternativeMediaID)
			delete(rawMsg, key)
		case "assetName":
			err = unpopulate(val, "AssetName", &s.AssetName)
			delete(rawMsg, key)
		case "contentKeys":
			err = unpopulate(val, "ContentKeys", &s.ContentKeys)
			delete(rawMsg, key)
		case "created":
			err = unpopulateTimeRFC3339(val, "Created", &s.Created)
			delete(rawMsg, key)
		case "defaultContentKeyPolicyName":
			err = unpopulate(val, "DefaultContentKeyPolicyName", &s.DefaultContentKeyPolicyName)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &s.EndTime)
			delete(rawMsg, key)
		case "filters":
			err = unpopulate(val, "Filters", &s.Filters)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		case "streamingLocatorId":
			err = unpopulate(val, "StreamingLocatorID", &s.StreamingLocatorID)
			delete(rawMsg, key)
		case "streamingPolicyName":
			err = unpopulate(val, "StreamingPolicyName", &s.StreamingPolicyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingPath.
func (s StreamingPath) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "encryptionScheme", s.EncryptionScheme)
	populate(objectMap, "paths", s.Paths)
	populate(objectMap, "streamingProtocol", s.StreamingProtocol)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingPath.
func (s *StreamingPath) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptionScheme":
			err = unpopulate(val, "EncryptionScheme", &s.EncryptionScheme)
			delete(rawMsg, key)
		case "paths":
			err = unpopulate(val, "Paths", &s.Paths)
			delete(rawMsg, key)
		case "streamingProtocol":
			err = unpopulate(val, "StreamingProtocol", &s.StreamingProtocol)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingPolicy.
func (s StreamingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingPolicy.
func (s *StreamingPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingPolicyCollection.
func (s StreamingPolicyCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "@odata.nextLink", s.ODataNextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingPolicyCollection.
func (s *StreamingPolicyCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.nextLink":
			err = unpopulate(val, "ODataNextLink", &s.ODataNextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingPolicyContentKey.
func (s StreamingPolicyContentKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "label", s.Label)
	populate(objectMap, "policyName", s.PolicyName)
	populate(objectMap, "tracks", s.Tracks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingPolicyContentKey.
func (s *StreamingPolicyContentKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "label":
			err = unpopulate(val, "Label", &s.Label)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &s.PolicyName)
			delete(rawMsg, key)
		case "tracks":
			err = unpopulate(val, "Tracks", &s.Tracks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingPolicyContentKeys.
func (s StreamingPolicyContentKeys) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "defaultKey", s.DefaultKey)
	populate(objectMap, "keyToTrackMappings", s.KeyToTrackMappings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingPolicyContentKeys.
func (s *StreamingPolicyContentKeys) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultKey":
			err = unpopulate(val, "DefaultKey", &s.DefaultKey)
			delete(rawMsg, key)
		case "keyToTrackMappings":
			err = unpopulate(val, "KeyToTrackMappings", &s.KeyToTrackMappings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingPolicyFairPlayConfiguration.
func (s StreamingPolicyFairPlayConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowPersistentLicense", s.AllowPersistentLicense)
	populate(objectMap, "customLicenseAcquisitionUrlTemplate", s.CustomLicenseAcquisitionURLTemplate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingPolicyFairPlayConfiguration.
func (s *StreamingPolicyFairPlayConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowPersistentLicense":
			err = unpopulate(val, "AllowPersistentLicense", &s.AllowPersistentLicense)
			delete(rawMsg, key)
		case "customLicenseAcquisitionUrlTemplate":
			err = unpopulate(val, "CustomLicenseAcquisitionURLTemplate", &s.CustomLicenseAcquisitionURLTemplate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingPolicyPlayReadyConfiguration.
func (s StreamingPolicyPlayReadyConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customLicenseAcquisitionUrlTemplate", s.CustomLicenseAcquisitionURLTemplate)
	populate(objectMap, "playReadyCustomAttributes", s.PlayReadyCustomAttributes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingPolicyPlayReadyConfiguration.
func (s *StreamingPolicyPlayReadyConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customLicenseAcquisitionUrlTemplate":
			err = unpopulate(val, "CustomLicenseAcquisitionURLTemplate", &s.CustomLicenseAcquisitionURLTemplate)
			delete(rawMsg, key)
		case "playReadyCustomAttributes":
			err = unpopulate(val, "PlayReadyCustomAttributes", &s.PlayReadyCustomAttributes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingPolicyProperties.
func (s StreamingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "commonEncryptionCbcs", s.CommonEncryptionCbcs)
	populate(objectMap, "commonEncryptionCenc", s.CommonEncryptionCenc)
	populateTimeRFC3339(objectMap, "created", s.Created)
	populate(objectMap, "defaultContentKeyPolicyName", s.DefaultContentKeyPolicyName)
	populate(objectMap, "envelopeEncryption", s.EnvelopeEncryption)
	populate(objectMap, "noEncryption", s.NoEncryption)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingPolicyProperties.
func (s *StreamingPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commonEncryptionCbcs":
			err = unpopulate(val, "CommonEncryptionCbcs", &s.CommonEncryptionCbcs)
			delete(rawMsg, key)
		case "commonEncryptionCenc":
			err = unpopulate(val, "CommonEncryptionCenc", &s.CommonEncryptionCenc)
			delete(rawMsg, key)
		case "created":
			err = unpopulateTimeRFC3339(val, "Created", &s.Created)
			delete(rawMsg, key)
		case "defaultContentKeyPolicyName":
			err = unpopulate(val, "DefaultContentKeyPolicyName", &s.DefaultContentKeyPolicyName)
			delete(rawMsg, key)
		case "envelopeEncryption":
			err = unpopulate(val, "EnvelopeEncryption", &s.EnvelopeEncryption)
			delete(rawMsg, key)
		case "noEncryption":
			err = unpopulate(val, "NoEncryption", &s.NoEncryption)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingPolicyWidevineConfiguration.
func (s StreamingPolicyWidevineConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customLicenseAcquisitionUrlTemplate", s.CustomLicenseAcquisitionURLTemplate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingPolicyWidevineConfiguration.
func (s *StreamingPolicyWidevineConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customLicenseAcquisitionUrlTemplate":
			err = unpopulate(val, "CustomLicenseAcquisitionURLTemplate", &s.CustomLicenseAcquisitionURLTemplate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SyncStorageKeysInput.
func (s SyncStorageKeysInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SyncStorageKeysInput.
func (s *SyncStorageKeysInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TextTrack.
func (t TextTrack) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "displayName", t.DisplayName)
	populate(objectMap, "fileName", t.FileName)
	populate(objectMap, "hlsSettings", t.HlsSettings)
	populate(objectMap, "languageCode", t.LanguageCode)
	objectMap["@odata.type"] = "#Microsoft.Media.TextTrack"
	populate(objectMap, "playerVisibility", t.PlayerVisibility)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TextTrack.
func (t *TextTrack) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &t.DisplayName)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &t.FileName)
			delete(rawMsg, key)
		case "hlsSettings":
			err = unpopulate(val, "HlsSettings", &t.HlsSettings)
			delete(rawMsg, key)
		case "languageCode":
			err = unpopulate(val, "LanguageCode", &t.LanguageCode)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &t.ODataType)
			delete(rawMsg, key)
		case "playerVisibility":
			err = unpopulate(val, "PlayerVisibility", &t.PlayerVisibility)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackBase.
func (t TrackBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = t.ODataType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackBase.
func (t *TrackBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &t.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackDescriptor.
func (t TrackDescriptor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = t.ODataType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackDescriptor.
func (t *TrackDescriptor) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &t.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackPropertyCondition.
func (t TrackPropertyCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "operation", t.Operation)
	populate(objectMap, "property", t.Property)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackPropertyCondition.
func (t *TrackPropertyCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operation":
			err = unpopulate(val, "Operation", &t.Operation)
			delete(rawMsg, key)
		case "property":
			err = unpopulate(val, "Property", &t.Property)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackSelection.
func (t TrackSelection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "trackSelections", t.TrackSelections)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackSelection.
func (t *TrackSelection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "trackSelections":
			err = unpopulate(val, "TrackSelections", &t.TrackSelections)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResource.
func (t *TrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Transform.
func (t Transform) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Transform.
func (t *Transform) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &t.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransformCollection.
func (t TransformCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "@odata.nextLink", t.ODataNextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransformCollection.
func (t *TransformCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.nextLink":
			err = unpopulate(val, "ODataNextLink", &t.ODataNextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransformOutput.
func (t TransformOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "onError", t.OnError)
	populate(objectMap, "preset", t.Preset)
	populate(objectMap, "relativePriority", t.RelativePriority)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransformOutput.
func (t *TransformOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "onError":
			err = unpopulate(val, "OnError", &t.OnError)
			delete(rawMsg, key)
		case "preset":
			t.Preset, err = unmarshalPresetClassification(val)
			delete(rawMsg, key)
		case "relativePriority":
			err = unpopulate(val, "RelativePriority", &t.RelativePriority)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransformProperties.
func (t TransformProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "created", t.Created)
	populate(objectMap, "description", t.Description)
	populateTimeRFC3339(objectMap, "lastModified", t.LastModified)
	populate(objectMap, "outputs", t.Outputs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransformProperties.
func (t *TransformProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "created":
			err = unpopulateTimeRFC3339(val, "Created", &t.Created)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &t.Description)
			delete(rawMsg, key)
		case "lastModified":
			err = unpopulateTimeRFC3339(val, "LastModified", &t.LastModified)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &t.Outputs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransportStreamFormat.
func (t TransportStreamFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "filenamePattern", t.FilenamePattern)
	objectMap["@odata.type"] = "#Microsoft.Media.TransportStreamFormat"
	populate(objectMap, "outputFiles", t.OutputFiles)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransportStreamFormat.
func (t *TransportStreamFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filenamePattern":
			err = unpopulate(val, "FilenamePattern", &t.FilenamePattern)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &t.ODataType)
			delete(rawMsg, key)
		case "outputFiles":
			err = unpopulate(val, "OutputFiles", &t.OutputFiles)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UTCClipTime.
func (u UTCClipTime) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = "#Microsoft.Media.UtcClipTime"
	populateTimeRFC3339(objectMap, "time", u.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UTCClipTime.
func (u *UTCClipTime) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &u.ODataType)
			delete(rawMsg, key)
		case "time":
			err = unpopulateTimeRFC3339(val, "Time", &u.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedManagedIdentity.
func (u UserAssignedManagedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedManagedIdentity.
func (u *UserAssignedManagedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Video.
func (v Video) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "keyFrameInterval", v.KeyFrameInterval)
	populate(objectMap, "label", v.Label)
	objectMap["@odata.type"] = "#Microsoft.Media.Video"
	populate(objectMap, "stretchMode", v.StretchMode)
	populate(objectMap, "syncMode", v.SyncMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Video.
func (v *Video) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyFrameInterval":
			err = unpopulate(val, "KeyFrameInterval", &v.KeyFrameInterval)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &v.Label)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &v.ODataType)
			delete(rawMsg, key)
		case "stretchMode":
			err = unpopulate(val, "StretchMode", &v.StretchMode)
			delete(rawMsg, key)
		case "syncMode":
			err = unpopulate(val, "SyncMode", &v.SyncMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VideoAnalyzerPreset.
func (v VideoAnalyzerPreset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "audioLanguage", v.AudioLanguage)
	populate(objectMap, "experimentalOptions", v.ExperimentalOptions)
	populate(objectMap, "insightsToExtract", v.InsightsToExtract)
	populate(objectMap, "mode", v.Mode)
	objectMap["@odata.type"] = "#Microsoft.Media.VideoAnalyzerPreset"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VideoAnalyzerPreset.
func (v *VideoAnalyzerPreset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "audioLanguage":
			err = unpopulate(val, "AudioLanguage", &v.AudioLanguage)
			delete(rawMsg, key)
		case "experimentalOptions":
			err = unpopulate(val, "ExperimentalOptions", &v.ExperimentalOptions)
			delete(rawMsg, key)
		case "insightsToExtract":
			err = unpopulate(val, "InsightsToExtract", &v.InsightsToExtract)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &v.Mode)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &v.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VideoLayer.
func (v VideoLayer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "adaptiveBFrame", v.AdaptiveBFrame)
	populate(objectMap, "bFrames", v.BFrames)
	populate(objectMap, "bitrate", v.Bitrate)
	populate(objectMap, "frameRate", v.FrameRate)
	populate(objectMap, "height", v.Height)
	populate(objectMap, "label", v.Label)
	populate(objectMap, "maxBitrate", v.MaxBitrate)
	populate(objectMap, "slices", v.Slices)
	populate(objectMap, "width", v.Width)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VideoLayer.
func (v *VideoLayer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adaptiveBFrame":
			err = unpopulate(val, "AdaptiveBFrame", &v.AdaptiveBFrame)
			delete(rawMsg, key)
		case "bFrames":
			err = unpopulate(val, "BFrames", &v.BFrames)
			delete(rawMsg, key)
		case "bitrate":
			err = unpopulate(val, "Bitrate", &v.Bitrate)
			delete(rawMsg, key)
		case "frameRate":
			err = unpopulate(val, "FrameRate", &v.FrameRate)
			delete(rawMsg, key)
		case "height":
			err = unpopulate(val, "Height", &v.Height)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &v.Label)
			delete(rawMsg, key)
		case "maxBitrate":
			err = unpopulate(val, "MaxBitrate", &v.MaxBitrate)
			delete(rawMsg, key)
		case "slices":
			err = unpopulate(val, "Slices", &v.Slices)
			delete(rawMsg, key)
		case "width":
			err = unpopulate(val, "Width", &v.Width)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VideoOverlay.
func (v VideoOverlay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "audioGainLevel", v.AudioGainLevel)
	populate(objectMap, "cropRectangle", v.CropRectangle)
	populate(objectMap, "end", v.End)
	populate(objectMap, "fadeInDuration", v.FadeInDuration)
	populate(objectMap, "fadeOutDuration", v.FadeOutDuration)
	populate(objectMap, "inputLabel", v.InputLabel)
	objectMap["@odata.type"] = "#Microsoft.Media.VideoOverlay"
	populate(objectMap, "opacity", v.Opacity)
	populate(objectMap, "position", v.Position)
	populate(objectMap, "start", v.Start)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VideoOverlay.
func (v *VideoOverlay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "audioGainLevel":
			err = unpopulate(val, "AudioGainLevel", &v.AudioGainLevel)
			delete(rawMsg, key)
		case "cropRectangle":
			err = unpopulate(val, "CropRectangle", &v.CropRectangle)
			delete(rawMsg, key)
		case "end":
			err = unpopulate(val, "End", &v.End)
			delete(rawMsg, key)
		case "fadeInDuration":
			err = unpopulate(val, "FadeInDuration", &v.FadeInDuration)
			delete(rawMsg, key)
		case "fadeOutDuration":
			err = unpopulate(val, "FadeOutDuration", &v.FadeOutDuration)
			delete(rawMsg, key)
		case "inputLabel":
			err = unpopulate(val, "InputLabel", &v.InputLabel)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &v.ODataType)
			delete(rawMsg, key)
		case "opacity":
			err = unpopulate(val, "Opacity", &v.Opacity)
			delete(rawMsg, key)
		case "position":
			err = unpopulate(val, "Position", &v.Position)
			delete(rawMsg, key)
		case "start":
			err = unpopulate(val, "Start", &v.Start)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VideoTrack.
func (v VideoTrack) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = "#Microsoft.Media.VideoTrack"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VideoTrack.
func (v *VideoTrack) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &v.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VideoTrackDescriptor.
func (v VideoTrackDescriptor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["@odata.type"] = "#Microsoft.Media.VideoTrackDescriptor"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VideoTrackDescriptor.
func (v *VideoTrackDescriptor) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &v.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateByteArray(m map[string]interface{}, k string, b []byte, f runtime.Base64Encoding) {
	if azcore.IsNullValue(b) {
		m[k] = nil
	} else if len(b) == 0 {
		return
	} else {
		m[k] = runtime.EncodeByteArray(b, f)
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
