/* The following code was generated by JFlex 1.4.3 on 22/12/10 21:12 */

//CHECKSTYLE:OFF

/* 
GeoGebra - Dynamic Mathematics for Everyone
http://www.geogebra.org

This file is part of GeoGebra.
This code has been written initially for Scilab (http://www.scilab.org/).

This program is free software; you can redistribute it and/or modify it 
under the terms of the GNU General Public License as published by 
the Free Software Foundation.

*/

package geogebra.gui.editor;

import geogebra.kernel.GeoElement;
import geogebra.main.Application;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 22/12/10 21:12 from the specification file
 * <tt>geogebra.jflex</tt>
 */
public final class GeoGebraLexer extends Lexer implements GeoGebraLexerConstants {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0, 0
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\55\1\103\1\1\2\55\1\1\22\55\1\102\1\43\1\0\1\55"+
    "\1\54\1\21\1\42\1\57\1\3\1\5\1\41\1\44\1\55\1\44"+
    "\1\47\1\41\2\51\1\70\7\51\1\36\1\55\1\43\1\37\1\43"+
    "\1\7\1\55\1\67\1\54\1\64\1\100\1\53\1\35\1\77\1\54"+
    "\1\26\2\54\1\72\1\54\1\16\1\54\1\23\1\54\1\76\1\65"+
    "\1\32\1\10\5\54\1\2\1\41\1\5\1\41\1\56\1\55\1\17"+
    "\1\74\1\62\1\12\1\13\1\14\1\71\1\66\1\15\1\75\1\54"+
    "\1\33\1\25\1\11\1\63\1\22\1\73\1\31\1\34\1\27\1\20"+
    "\1\101\1\54\1\61\1\30\1\60\1\4\1\40\1\6\56\55\1\41"+
    "\3\55\1\41\1\55\1\46\1\46\3\55\1\54\1\55\1\46\6\55"+
    "\27\54\1\55\350\54\4\55\345\54\350\55\57\54\1\24\63\54\15\55"+
    "\201\54\16\55\152\54\67\55\u012f\54\12\52\1\54\1\50\204\54\12\52"+
    "\u026c\54\12\52\166\54\12\52\166\54\12\52\166\54\12\52\166\54\12\52"+
    "\166\54\12\52\166\54\12\52\166\54\12\52\166\54\12\52\340\54\12\52"+
    "\166\54\12\52\106\54\12\52\u0116\54\12\52\u0796\54\12\52\46\54\12\52"+
    "\u0336\54\12\52\126\54\12\52\206\54\12\52\6\54\12\52\u03a3\54\26\55"+
    "\1\44\134\55\1\46\3\55\6\46\1\55\1\45\263\55\1\7\330\55"+
    "\1\41\11\55\1\44\13\55\1\7\6\55\1\41\1\55\1\41\1\41"+
    "\66\55\1\41\1\41\3\55\1\41\1\41\34\55\1\41\3\55\1\41"+
    "\20\55\1\41\15\55\1\41\37\55\1\41\u0d7b\55\u0317\54\u1aa8\55\u5ad0\54"+
    "\12\52\u2eca\54\u1f79\55\u0311\54\345\55\u02e9\54\204\55\175\54\151\55\70\54"+
    "\3\55\74\54\40\55\1\7\2\55";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\2\1\1\2\1\3\10\4\1\1\1\4\1\3"+
    "\3\4\1\5\3\4\1\1\3\6\2\1\1\6\1\1"+
    "\1\4\2\7\1\1\1\5\10\4\1\10\1\11\1\12"+
    "\1\0\1\13\1\14\1\4\1\0\13\4\1\0\4\4"+
    "\1\15\10\4\3\7\1\0\13\4\1\3\14\4\1\0"+
    "\2\7\6\4\1\0\1\13\1\14\5\4\2\0\22\4";

  private static int [] zzUnpackAction() {
    int [] result = new int[142];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
    public int end;
    public Set<String> commands;
    public Set<String> variables;

    private Document doc;
    private Element elem;

    public GeoGebraLexer(Application app) {
        variables = new HashSet<String>();
        Iterator<GeoElement> iter = app.getKernel().getConstruction().getGeoSetLabelOrder().iterator();
        while (iter.hasNext()) {
        	GeoElement g = iter.next();
        	if (g.isLabelSet()) {
        		variables.add(g.getLabel());
        	}
        }
        commands = new HashSet();
        commands.addAll(app.getCommandDictionary().values());
    }

    public GeoGebraLexer(Document doc, Application app) {
		this(app);
        setDocument(doc);
    }

	public void setDocument(Document doc) {
		this.doc = doc;
		this.elem = doc.getDefaultRootElement();
	}

    public void setRange(int p0, int p1) {
        this.start = p0;
        this.end = p1;
        String str = "";
        try {
        	str = doc.getText(start, end - start);
        } catch (BadLocationException e) { }
        yyreset(new StringReader(str));
    }

    public int yychar() {
        return yychar;
    }

    public int scan() throws IOException {
        return yylex();
    }

    public int getKeyword(int pos, boolean strict) {
        Element line = elem.getElement(elem.getElementIndex(pos));
        int end = line.getEndOffset();
        int tok = -1;
        start = line.getStartOffset();
        int startL = start;
        int s = -1;

        try {
           yyreset(new StringReader(doc.getText(start, end - start)));
           if (!strict) {
              pos++;
           }

           while (startL < pos && s != startL) {
               s = startL;
               tok = yylex();
               startL = start + yychar + yylength();
           }

           return tok;
        } catch (Exception e) {
           return GeoGebraLexerConstants.DEFAULT;
        }
     }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public GeoGebraLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public GeoGebraLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 430) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;


    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          zzInput = zzCMapL[zzInput];

          boolean zzIsFinal = false;
          boolean zzNoLookAhead = false;

          zzForNext: { switch (zzState) {
            case 0:
              switch (zzInput) {
                case 0: zzIsFinal = true; zzState = 1; break zzForNext;
                case 1: zzIsFinal = true; zzState = 2; break zzForNext;
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: zzIsFinal = true; zzNoLookAhead = true; zzState = 3; break zzForNext;
                case 7: zzIsFinal = true; zzNoLookAhead = true; zzState = 4; break zzForNext;
                case 8: zzIsFinal = true; zzState = 5; break zzForNext;
                case 11: 
                case 43: zzIsFinal = true; zzState = 7; break zzForNext;
                case 12: 
                case 29: zzIsFinal = true; zzState = 8; break zzForNext;
                case 13: zzIsFinal = true; zzState = 9; break zzForNext;
                case 14: zzIsFinal = true; zzState = 10; break zzForNext;
                case 15: zzIsFinal = true; zzState = 11; break zzForNext;
                case 16: zzIsFinal = true; zzState = 12; break zzForNext;
                case 17: zzIsFinal = true; zzState = 13; break zzForNext;
                case 18: 
                case 19: zzIsFinal = true; zzState = 14; break zzForNext;
                case 20: zzIsFinal = true; zzState = 15; break zzForNext;
                case 21: zzIsFinal = true; zzState = 16; break zzForNext;
                case 22: zzIsFinal = true; zzState = 17; break zzForNext;
                case 23: 
                case 26: zzIsFinal = true; zzState = 18; break zzForNext;
                case 24: 
                case 49: zzIsFinal = true; zzState = 19; break zzForNext;
                case 25: zzIsFinal = true; zzState = 20; break zzForNext;
                case 27: zzIsFinal = true; zzState = 21; break zzForNext;
                case 28: zzIsFinal = true; zzState = 22; break zzForNext;
                case 30: zzIsFinal = true; zzState = 23; break zzForNext;
                case 31: 
                case 35: zzIsFinal = true; zzState = 24; break zzForNext;
                case 32: zzIsFinal = true; zzState = 25; break zzForNext;
                case 33: 
                case 36: zzIsFinal = true; zzNoLookAhead = true; zzState = 26; break zzForNext;
                case 34: zzIsFinal = true; zzState = 27; break zzForNext;
                case 37: zzIsFinal = true; zzState = 28; break zzForNext;
                case 38: zzIsFinal = true; zzState = 29; break zzForNext;
                case 39: zzIsFinal = true; zzState = 30; break zzForNext;
                case 40: zzIsFinal = true; zzState = 31; break zzForNext;
                case 41: 
                case 56: zzIsFinal = true; zzState = 32; break zzForNext;
                case 42: zzIsFinal = true; zzState = 33; break zzForNext;
                case 45: 
                case 46: 
                case 47: zzIsFinal = true; zzNoLookAhead = true; zzState = 34; break zzForNext;
                case 48: zzIsFinal = true; zzState = 35; break zzForNext;
                case 50: zzIsFinal = true; zzState = 36; break zzForNext;
                case 52: zzIsFinal = true; zzState = 37; break zzForNext;
                case 53: zzIsFinal = true; zzState = 38; break zzForNext;
                case 55: zzIsFinal = true; zzState = 39; break zzForNext;
                case 57: 
                case 63: zzIsFinal = true; zzState = 40; break zzForNext;
                case 58: zzIsFinal = true; zzState = 41; break zzForNext;
                case 62: zzIsFinal = true; zzState = 42; break zzForNext;
                case 64: zzIsFinal = true; zzState = 43; break zzForNext;
                case 66: zzIsFinal = true; zzNoLookAhead = true; zzState = 44; break zzForNext;
                case 67: zzIsFinal = true; zzNoLookAhead = true; zzState = 45; break zzForNext;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 1:
              switch (zzInput) {
                case 0: zzIsFinal = true; zzNoLookAhead = true; zzState = 46; break zzForNext;
                default: zzState = 47; break zzForNext;
              }

            case 2:
              switch (zzInput) {
                case 1: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 5:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 9: zzIsFinal = true; zzState = 50; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 6:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; break zzForNext;
              }

            case 7:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 49: zzIsFinal = true; zzState = 52; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 8:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 15: zzIsFinal = true; zzState = 53; break zzForNext;
                case 27: zzIsFinal = true; zzState = 54; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 9:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 9: zzIsFinal = true; zzState = 55; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 10:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 15: zzIsFinal = true; zzState = 56; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 11:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 23: zzIsFinal = true; zzState = 57; break zzForNext;
                case 25: zzIsFinal = true; zzState = 58; break zzForNext;
                case 28: zzIsFinal = true; zzState = 59; break zzForNext;
                case 50: zzIsFinal = true; zzState = 60; break zzForNext;
                case 60: zzIsFinal = true; zzState = 61; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 12:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 9: zzIsFinal = true; zzState = 62; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 13:
              switch (zzInput) {
                case 11: zzIsFinal = true; zzNoLookAhead = true; zzState = 4; break zzForNext;
                case 18: zzState = 63; break zzForNext;
                default: break zzForAction;
              }

            case 14:
              switch (zzInput) {
                case 13: zzIsFinal = true; zzState = 15; break zzForNext;
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 15:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 16:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 13: zzIsFinal = true; zzState = 64; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 17:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 9: zzIsFinal = true; zzState = 65; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 18:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 15: zzIsFinal = true; zzState = 66; break zzForNext;
                case 25: zzIsFinal = true; zzState = 67; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 19:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 68; break zzForNext;
                case 50: zzIsFinal = true; zzState = 69; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 20:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 15: zzIsFinal = true; zzState = 70; break zzForNext;
                case 51: zzIsFinal = true; zzState = 71; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 21:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 9: 
                case 10: 
                case 57: zzIsFinal = true; zzState = 72; break zzForNext;
                case 51: zzIsFinal = true; zzState = 73; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 22:
              switch (zzInput) {
                case 57: zzIsFinal = true; zzState = 41; break zzForNext;
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 11: zzIsFinal = true; zzState = 74; break zzForNext;
                case 13: zzIsFinal = true; zzState = 75; break zzForNext;
                case 59: zzIsFinal = true; zzState = 76; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 23:
              switch (zzInput) {
                case 31: zzIsFinal = true; zzNoLookAhead = true; zzState = 26; break zzForNext;
                default: break zzForAction;
              }

            case 24:
              switch (zzInput) {
                case 31: zzIsFinal = true; zzNoLookAhead = true; zzState = 26; break zzForNext;
                default: break zzForAction;
              }

            case 25:
              switch (zzInput) {
                case 32: zzIsFinal = true; zzNoLookAhead = true; zzState = 26; break zzForNext;
                default: break zzForAction;
              }

            case 27:
              switch (zzInput) {
                case 34: zzIsFinal = true; zzNoLookAhead = true; zzState = 26; break zzForNext;
                default: break zzForAction;
              }

            case 28:
              switch (zzInput) {
                case 38: zzIsFinal = true; zzState = 29; break zzForNext;
                default: break zzForAction;
              }

            case 29:
              switch (zzInput) {
                case 38: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 30:
              switch (zzInput) {
                case 41: 
                case 42: 
                case 56: zzIsFinal = true; zzState = 77; break zzForNext;
                default: break zzForAction;
              }

            case 31:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 41: 
                case 42: 
                case 56: zzIsFinal = true; zzState = 78; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 32:
              switch (zzInput) {
                case 41: 
                case 42: 
                case 56: zzIsFinal = true; break zzForNext;
                case 39: 
                case 40: zzIsFinal = true; zzState = 77; break zzForNext;
                case 17: zzIsFinal = true; zzNoLookAhead = true; zzState = 79; break zzForNext;
                case 43: zzState = 80; break zzForNext;
                default: break zzForAction;
              }

            case 33:
              switch (zzInput) {
                case 41: 
                case 42: 
                case 56: zzIsFinal = true; break zzForNext;
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 39: zzIsFinal = true; zzState = 77; break zzForNext;
                case 40: zzIsFinal = true; zzState = 78; break zzForNext;
                case 17: zzIsFinal = true; zzNoLookAhead = true; zzState = 79; break zzForNext;
                case 43: zzIsFinal = true; zzState = 81; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 35:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 36:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 28: zzIsFinal = true; zzState = 74; break zzForNext;
                case 60: zzIsFinal = true; zzState = 76; break zzForNext;
                case 11: zzIsFinal = true; zzState = 82; break zzForNext;
                case 51: zzIsFinal = true; zzState = 83; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 37:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 28: zzIsFinal = true; zzState = 74; break zzForNext;
                case 11: zzIsFinal = true; zzState = 82; break zzForNext;
                case 51: zzIsFinal = true; zzState = 83; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 38:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 11: zzIsFinal = true; zzState = 74; break zzForNext;
                case 13: zzIsFinal = true; zzState = 75; break zzForNext;
                case 59: zzIsFinal = true; zzState = 76; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 39:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 60: zzIsFinal = true; zzState = 61; break zzForNext;
                case 25: zzIsFinal = true; zzState = 84; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 40:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 15: zzIsFinal = true; zzState = 85; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 41:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 9: zzIsFinal = true; zzState = 72; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 42:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 51: zzIsFinal = true; zzState = 71; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 43:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 11: zzIsFinal = true; zzState = 86; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 47:
              switch (zzInput) {
                case 0: zzIsFinal = true; zzNoLookAhead = true; zzState = 46; break zzForNext;
                default: break zzForNext;
              }

            case 50:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 10: zzIsFinal = true; zzState = 87; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 51:
              switch (zzInput) {
                case 4: zzIsFinal = true; zzState = 89; break zzForNext;
                case 0: break zzForAction;
                default: zzIsFinal = true; zzState = 88; break zzForNext;
              }

            case 52:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 18: zzIsFinal = true; zzState = 72; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 53:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 27: zzIsFinal = true; zzState = 90; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 54:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 51: zzIsFinal = true; zzState = 91; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 55:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 12: zzIsFinal = true; zzState = 92; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 56:
              switch (zzInput) {
                case 14: zzIsFinal = true; zzState = 15; break zzForNext;
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 57:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 15: zzIsFinal = true; zzState = 93; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 58:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 57: zzIsFinal = true; zzState = 72; break zzForNext;
                case 50: zzIsFinal = true; zzState = 94; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 59:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 13: zzIsFinal = true; zzState = 95; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 60:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 51: zzIsFinal = true; zzState = 96; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 61:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 28: zzIsFinal = true; zzState = 72; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 62:
              switch (zzInput) {
                case 10: zzIsFinal = true; zzState = 15; break zzForNext;
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 63:
              switch (zzInput) {
                case 13: zzIsFinal = true; zzNoLookAhead = true; zzState = 4; break zzForNext;
                default: break zzForAction;
              }

            case 64:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 9: zzIsFinal = true; zzState = 97; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 65:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 12: zzIsFinal = true; zzState = 98; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 66:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 9: zzIsFinal = true; zzState = 99; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 67:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 16: zzIsFinal = true; zzState = 100; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 69:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 51: zzIsFinal = true; zzState = 101; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 70:
              switch (zzInput) {
                case 10: zzIsFinal = true; zzState = 15; break zzForNext;
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 9: zzIsFinal = true; zzState = 102; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 71:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 16: zzIsFinal = true; zzState = 103; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 72:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 68; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 73:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 57: zzIsFinal = true; zzState = 72; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 74:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 50: zzIsFinal = true; zzState = 99; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 75:
              switch (zzInput) {
                case 57: zzIsFinal = true; zzState = 41; break zzForNext;
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 9: zzIsFinal = true; zzState = 99; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 76:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 25: zzIsFinal = true; zzState = 104; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 77:
              switch (zzInput) {
                case 41: 
                case 42: 
                case 56: zzIsFinal = true; break zzForNext;
                case 17: zzIsFinal = true; zzNoLookAhead = true; zzState = 79; break zzForNext;
                case 43: zzState = 80; break zzForNext;
                default: break zzForAction;
              }

            case 78:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 41: 
                case 42: 
                case 56: zzIsFinal = true; break zzForNext;
                case 17: zzIsFinal = true; zzNoLookAhead = true; zzState = 79; break zzForNext;
                case 43: zzIsFinal = true; zzState = 81; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 80:
              switch (zzInput) {
                case 36: zzState = 105; break zzForNext;
                case 41: 
                case 42: 
                case 56: zzIsFinal = true; zzState = 106; break zzForNext;
                default: break zzForAction;
              }

            case 81:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 36: zzState = 105; break zzForNext;
                case 41: 
                case 42: 
                case 56: zzIsFinal = true; zzState = 107; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 82:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 13: zzIsFinal = true; zzState = 108; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 83:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 23: 
                case 28: zzIsFinal = true; zzState = 99; break zzForNext;
                case 9: zzIsFinal = true; zzState = 109; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 84:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 57: zzIsFinal = true; zzState = 72; break zzForNext;
                case 50: zzIsFinal = true; zzState = 110; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 85:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 21: zzIsFinal = true; zzState = 111; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 86:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 25: zzIsFinal = true; zzState = 112; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 87:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 11: zzIsFinal = true; zzState = 113; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 88:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 46: 
                case 47: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; break zzForNext;
              }

            case 89:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 46: 
                case 47: 
                case 66: 
                case 67: zzState = 114; break zzForNext;
                case 2: zzIsFinal = true; zzState = 115; break zzForNext;
                case 3: zzIsFinal = true; zzState = 116; break zzForNext;
                case 6: break zzForAction;
                default: zzIsFinal = true; zzState = 117; break zzForNext;
              }

            case 90:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 28: zzIsFinal = true; zzState = 100; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 91:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 51: zzIsFinal = true; zzState = 118; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 92:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 13: zzIsFinal = true; zzState = 119; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 93:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 9: zzIsFinal = true; zzState = 120; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 94:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 23: zzIsFinal = true; zzState = 57; break zzForNext;
                case 28: zzIsFinal = true; zzState = 59; break zzForNext;
                case 50: zzIsFinal = true; zzState = 60; break zzForNext;
                case 51: zzIsFinal = true; zzState = 96; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 95:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 9: zzIsFinal = true; zzState = 121; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 96:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 28: zzIsFinal = true; zzState = 121; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 97:
              switch (zzInput) {
                case 12: zzIsFinal = true; zzState = 15; break zzForNext;
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 98:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 13: zzIsFinal = true; zzState = 119; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 99:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 68; break zzForNext;
                case 37: zzState = 122; break zzForNext;
                case 38: zzState = 123; break zzForNext;
                case 54: zzIsFinal = true; zzState = 124; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 100:
              switch (zzInput) {
                case 11: zzIsFinal = true; zzState = 15; break zzForNext;
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 101:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 51: zzIsFinal = true; zzState = 125; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 102:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 10: zzIsFinal = true; zzState = 126; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 103:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 9: zzIsFinal = true; zzState = 127; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 104:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 23: zzIsFinal = true; zzState = 72; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 105:
              switch (zzInput) {
                case 41: 
                case 42: 
                case 56: zzIsFinal = true; zzState = 106; break zzForNext;
                default: break zzForAction;
              }

            case 106:
              switch (zzInput) {
                case 41: 
                case 42: 
                case 56: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 107:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 41: 
                case 42: 
                case 56: zzIsFinal = true; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 108:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 27: zzIsFinal = true; zzState = 72; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 109:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 61: zzIsFinal = true; zzState = 128; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 110:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 26: zzIsFinal = true; zzState = 57; break zzForNext;
                case 53: zzIsFinal = true; zzState = 59; break zzForNext;
                case 52: zzIsFinal = true; zzState = 60; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 111:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 21: zzIsFinal = true; zzState = 129; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 112:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 13: zzIsFinal = true; zzState = 130; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 113:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 12: zzIsFinal = true; zzState = 131; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 114:
              switch (zzInput) {
                case 6: zzIsFinal = true; zzState = 88; break zzForNext;
                default: break zzForNext;
              }

            case 115:
              switch (zzInput) {
                case 6: zzIsFinal = true; zzState = 88; break zzForNext;
                default: zzState = 114; break zzForNext;
              }

            case 116:
              switch (zzInput) {
                case 6: zzIsFinal = true; zzState = 88; break zzForNext;
                default: zzState = 114; break zzForNext;
              }

            case 117:
              switch (zzInput) {
                case 6: zzIsFinal = true; zzState = 88; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 46: 
                case 47: 
                case 66: 
                case 67: zzState = 114; break zzForNext;
                case 2: zzIsFinal = true; zzState = 115; break zzForNext;
                case 3: zzIsFinal = true; zzState = 116; break zzForNext;
                default: zzIsFinal = true; break zzForNext;
              }

            case 118:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 25: zzIsFinal = true; zzState = 72; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 119:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 9: zzIsFinal = true; zzState = 132; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 120:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 68; break zzForNext;
                case 54: 
                case 56: zzIsFinal = true; zzState = 72; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 121:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 68; break zzForNext;
                case 54: zzIsFinal = true; zzState = 72; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 122:
              switch (zzInput) {
                case 38: zzState = 123; break zzForNext;
                default: break zzForAction;
              }

            case 123:
              switch (zzInput) {
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 68; break zzForNext;
                case 38: break zzForNext;
                default: break zzForAction;
              }

            case 124:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 68; break zzForNext;
                case 37: zzState = 122; break zzForNext;
                case 38: zzState = 123; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 125:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 25: zzIsFinal = true; zzState = 127; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 126:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 51: zzIsFinal = true; zzState = 133; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 127:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 10: zzIsFinal = true; zzState = 72; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 128:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 16: zzIsFinal = true; zzState = 134; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 129:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 15: zzIsFinal = true; zzState = 72; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 130:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 65: zzIsFinal = true; zzState = 72; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 131:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 13: zzIsFinal = true; zzState = 135; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 132:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 13: zzIsFinal = true; zzState = 136; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 133:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 21: zzIsFinal = true; zzState = 72; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 134:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 57: zzIsFinal = true; zzState = 137; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 135:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 9: zzIsFinal = true; zzState = 138; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 136:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 23: zzIsFinal = true; zzState = 139; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 137:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 15: zzIsFinal = true; zzState = 140; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 138:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 11: zzIsFinal = true; zzState = 62; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 139:
              switch (zzInput) {
                case 24: zzIsFinal = true; zzState = 15; break zzForNext;
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 140:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 23: zzIsFinal = true; zzState = 141; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            case 141:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 46: zzState = 51; break zzForNext;
                case 11: zzIsFinal = true; zzState = 72; break zzForNext;
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 66: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 6; break zzForNext;
              }

            default:
              // if this is ever reached, there is a serious bug in JFlex
              zzScanError(ZZ_UNKNOWN_ERROR);
              break;
          } }

          if ( zzIsFinal ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( zzNoLookAhead ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 5: 
          { return GeoGebraLexerConstants.VARIABLE;
          }
        case 14: break;
        case 2: 
          { return GeoGebraLexerConstants.OPENCLOSE;
          }
        case 15: break;
        case 10: 
          { return GeoGebraLexerConstants.STRING;
          }
        case 16: break;
        case 8: 
          { return GeoGebraLexerConstants.WHITE;
          }
        case 17: break;
        case 12: 
          { yypushback(1);
  								   return GeoGebraLexerConstants.FUNCTION;
          }
        case 18: break;
        case 7: 
          { return GeoGebraLexerConstants.NUMBER;
          }
        case 19: break;
        case 11: 
          { yypushback(1);
  								   String com = yytext();
  								   if (commands.contains(com)) {
  								   		return GeoGebraLexerConstants.COMMAND;
  								   }
  								   
  								   return GeoGebraLexerConstants.UNKNOWN;
          }
        case 20: break;
        case 1: 
          { return GeoGebraLexerConstants.DEFAULT;
          }
        case 21: break;
        case 6: 
          { return GeoGebraLexerConstants.OPERATOR;
          }
        case 22: break;
        case 9: 
          { return GeoGebraLexerConstants.TAB;
          }
        case 23: break;
        case 3: 
          { return GeoGebraLexerConstants.CONSTANTE;
          }
        case 24: break;
        case 13: 
          { yypushback(1);
                                   return GeoGebraLexerConstants.BUILTINFUNCTION;
          }
        case 25: break;
        case 4: 
          { String lab = yytext();
  								   if (variables.contains(lab)) {
  								   		return GeoGebraLexerConstants.VARIABLE;
  								   }
  								   
  								   return GeoGebraLexerConstants.UNKNOWN;
          }
        case 26: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              {
                return GeoGebraLexerConstants.EOF;
              }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
