/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.impl;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.ITransaction;
import com.modeliosoft.modelio.api.model.InvalidTransactionException;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ILifeline;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IMessage;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IState;
import com.modeliosoft.modelio.api.model.uml.behavior.state.ITransition;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IAttributeLink;
import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IInterface;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.api.module.IMdacConfiguration;
import com.modeliosoft.modelio.modelingwizard.api.IModelingWizardPeerMdac;
import com.modeliosoft.modelio.modelingwizard.impl.ModelingWizardMdac;
import com.modeliosoft.modelio.modelingwizard.impl.engine.InstanceUpdater;
import com.modeliosoft.modelio.modelingwizard.impl.engine.InterfaceImplementer;
import com.modeliosoft.modelio.modelingwizard.impl.engine.ModelingWizardException;
import com.modeliosoft.modelio.modelingwizard.impl.engine.StateUpdater;
import java.util.List;

public class ModelingWizardPeerMdac
implements IModelingWizardPeerMdac {
    private ModelingWizardMdac mdac;

    public ModelingWizardPeerMdac(ModelingWizardMdac mdac) {
        this.mdac = mdac;
    }

    public IMdacConfiguration getConfiguration() {
        return this.mdac.getConfiguration();
    }

    public String getDescription() {
        return this.mdac.getDescription();
    }

    public String getName() {
        return this.mdac.getName();
    }

    public Version getVersion() {
        return this.mdac.getVersion();
    }

    void init() {
    }

    public ModelingWizardMdac getMdac() {
        return this.mdac;
    }

    @Override
    public boolean createAttribute(IAttributeLink attr) throws ModelingWizardException {
        IModelingSession session = this.mdac.getModelingSession();
        ITransaction transaction = session.createTransaction("CreateAttribute");
        boolean result = false;
        try {
            try {
                InstanceUpdater p = new InstanceUpdater();
                result = p.createAttribute(session, attr);
                session.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                result = false;
                if (transaction != null) {
                    session.rollback(transaction);
                    result = false;
                }
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
                result = false;
            }
        }
        return result;
    }

    @Override
    public boolean createClassifier(IInstance inst) throws ModelingWizardException {
        IModelingSession session = this.mdac.getModelingSession();
        ITransaction transaction = session.createTransaction("CreateClassifierByLifeline");
        boolean result = false;
        try {
            try {
                InstanceUpdater p = new InstanceUpdater();
                result = p.createClassifier(session, inst);
                session.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                result = false;
                if (transaction != null) {
                    session.rollback(transaction);
                    result = false;
                }
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
                result = false;
            }
        }
        return result;
    }

    @Override
    public boolean createClassifierByLifeline(ILifeline ll) throws ModelingWizardException {
        IModelingSession session = this.mdac.getModelingSession();
        ITransaction transaction = session.createTransaction("CreateClassifierByLifeline");
        boolean result = false;
        try {
            try {
                InstanceUpdater p = new InstanceUpdater();
                IInstance inst = ll.getRepresented();
                result = inst != null ? p.createClassifier(session, inst) : p.createInstanceAndClassifier(session, ll);
                session.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                result = false;
                if (transaction != null) {
                    session.rollback(transaction);
                    result = false;
                }
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
                result = false;
            }
        }
        return result;
    }

    @Override
    public boolean createOperationFromMessage(IMessage message) throws ModelingWizardException {
        IModelingSession session = this.mdac.getModelingSession();
        ITransaction transaction = session.createTransaction("CreateOperationFromMessage");
        boolean result = false;
        try {
            try {
                InstanceUpdater p = new InstanceUpdater();
                result = p.createOperation(session, message);
                session.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                result = false;
                if (transaction != null) {
                    session.rollback(transaction);
                    result = false;
                }
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
                result = false;
            }
        }
        return result;
    }

    @Override
    public boolean createOperationFromTransition(ITransition transition) throws ModelingWizardException {
        IModelingSession session = this.mdac.getModelingSession();
        ITransaction transaction = session.createTransaction("CreateOperationFromTransition");
        boolean result = false;
        try {
            try {
                InstanceUpdater p = new InstanceUpdater();
                result = p.createOperation(session, transition);
                session.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                result = false;
                if (transaction != null) {
                    session.rollback(transaction);
                    result = false;
                }
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
                result = false;
            }
        }
        return result;
    }

    @Override
    public boolean createStateMachineFromState(IState state) {
        IModelingSession session = this.mdac.getModelingSession();
        ITransaction transaction = session.createTransaction("CreateStateMachineFromState");
        boolean result = false;
        try {
            try {
                StateUpdater stateWizard = new StateUpdater();
                result = stateWizard.createStateMachineFromState(session, state);
                session.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                result = false;
                if (transaction != null) {
                    session.rollback(transaction);
                    result = false;
                }
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
                result = false;
            }
        }
        return result;
    }

    @Override
    public void implementInterfaces(List<IClassifier> classifiers) {
        InterfaceImplementer interfaceManager = new InterfaceImplementer();
        IModelingSession session = this.mdac.getModelingSession();
        ITransaction transaction = session.createTransaction("Update class from interfaces");
        try {
            try {
                boolean hasDoneWork = false;
                for (IElement iElement : classifiers) {
                    IClassifier theClassifier = (IClassifier)iElement;
                    boolean newResult = interfaceManager.implementInterfaces(session, theClassifier);
                    boolean bl = hasDoneWork = hasDoneWork || newResult;
                }
                if (hasDoneWork) {
                    session.commit(transaction);
                    transaction = null;
                }
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction != null) {
                    session.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
            }
        }
    }

    @Override
    public void unimplementInterfaces(List<IClassifier> classifiers) {
        InterfaceImplementer interfaceManager = new InterfaceImplementer();
        IModelingSession session = this.mdac.getModelingSession();
        ITransaction transaction = session.createTransaction("Unimplement Interfaces in class");
        try {
            try {
                boolean hasDoneWork = false;
                for (IClassifier theClassifier : classifiers) {
                    boolean newResult = interfaceManager.unImplementInterfaces(theClassifier);
                    boolean bl = hasDoneWork = hasDoneWork || newResult;
                }
                if (hasDoneWork) {
                    session.commit(transaction);
                    transaction = null;
                }
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction != null) {
                    session.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
            }
        }
    }

    @Override
    public void updateClassesFromInterface(List<IInterface> interfaces) {
        InterfaceImplementer interfaceManager = new InterfaceImplementer();
        IModelingSession session = this.mdac.getModelingSession();
        ITransaction transaction = session.createTransaction("Update classes from interface");
        try {
            try {
                boolean hasDoneWork = false;
                for (IInterface theInterface : interfaces) {
                    boolean newResult = interfaceManager.updateImplementingClassifiers(session, theInterface);
                    boolean bl = hasDoneWork = hasDoneWork || newResult;
                }
                if (hasDoneWork) {
                    session.commit(transaction);
                    transaction = null;
                }
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction != null) {
                    session.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
            }
        }
    }

    @Override
    public void updateInstanceFromClassifier(IInstance inst) throws ModelingWizardException {
        IModelingSession session = this.mdac.getModelingSession();
        ITransaction transaction = session.createTransaction("UpdateFromClassifier");
        try {
            try {
                InstanceUpdater p = new InstanceUpdater();
                p.updatePartFromInstanciedClassifier(session, inst);
                session.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction != null) {
                    session.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
            }
        }
    }

    @Override
    public void updateFromClassifierByLifeline(ILifeline ll) throws ModelingWizardException {
        IModelingSession session = this.mdac.getModelingSession();
        ITransaction transaction = session.createTransaction("UpdateFromClassifierByLifeline");
        try {
            try {
                InstanceUpdater p = new InstanceUpdater();
                IInstance inst = ll.getRepresented();
                if (inst != null) {
                    p.updatePartFromInstanciedClassifier(session, inst);
                } else {
                    p.updateInstanceAndClassifier(session, ll);
                }
                session.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction != null) {
                    session.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
            }
        }
    }

    @Override
    public void updateInternalStructure(IClass classe) throws ModelingWizardException {
        IModelingSession session = this.mdac.getModelingSession();
        ITransaction transaction = session.createTransaction("UpdateInternalStructure");
        try {
            try {
                InstanceUpdater p = new InstanceUpdater();
                p.updateInternalStructure(session, classe);
                session.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction != null) {
                    session.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
            }
        }
    }

    @Override
    public void updateStateFromStateMachine(IState state) {
        IModelingSession session = this.mdac.getModelingSession();
        ITransaction transaction = session.createTransaction("UpdateStateFromStateMachine");
        try {
            try {
                StateUpdater updater = new StateUpdater();
                updater.updateStateFromStateMachine(session, state);
                session.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction != null) {
                    session.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
            }
        }
    }
}

