/*
 * Copyright (C) 2003-2015 FreeIPMI Core Team
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_SPEC_H
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_SPEC_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Intel Node Manager
 *
 * For Intel Chips, not just Intel Motherboards.  Confirmed for:
 *
 * Intel S5500WB/Penguin Computing Relion 700
 * Intel S2600JF/Appro 512X
 * Intel S2600WP
 * Intel S2600KP
 * Intel S2600WT2
 * Intel S2600WTT
 * Intel S2600GZ
 * Inventec 5441/Dell Xanadu II
 * Inventec 5442/Dell Xanadu III
 * Quanta S99Q/Dell FS12-TY
 * Quanta QSSC-S4R/Appro GB812X-CN
 */

/* IPMI_CMD_OEM_INTEL_ENABLE_DISABLE_NODE_MANAGER_POLICY_CONTROL */
/* IPMI_CMD_OEM_INTEL_SET_NODE_MANAGER_POLICY */
/* IPMI_CMD_OEM_INTEL_GET_NODE_MANAGER_POLICY */
/* IPMI_CMD_OEM_INTEL_SET_NODE_MANAGER_POLICY_ALERT_THRESHOLDS */
/* IPMI_CMD_OEM_INTEL_GET_NODE_MANAGER_POLICY_ALERT_THRESHOLDS */
/* IPMI_CMD_OEM_INTEL_SET_NODE_MANAGER_POLICY_SUSPEND_PERIODS */
/* IPMI_CMD_OEM_INTEL_GET_NODE_MANAGER_POLICY_SUSPEND_PERIODS */
/* IPMI_CMD_OEM_INTEL_RESET_NODE_MANAGER_STATISTICS */
/* IPMI_CMD_OEM_INTEL_GET_NODE_MANAGER_STATISTICS */
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_INVALID_POLICY_ID 0x80
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_INVALID_POLICY_ID_STR \
  "Invalid Policy Id"

/* IPMI_CMD_OEM_INTEL_ENABLE_DISABLE_NODE_MANAGER_POLICY_CONTROL */
/* IPMI_CMD_OEM_INTEL_SET_NODE_MANAGER_POLICY */
/* IPMI_CMD_OEM_INTEL_GET_NODE_MANAGER_POLICY */
/* IPMI_CMD_OEM_INTEL_SET_NODE_MANAGER_POLICY_ALERT_THRESHOLDS */
/* IPMI_CMD_OEM_INTEL_GET_NODE_MANAGER_POLICY_ALERT_THRESHOLDS */
/* IPMI_CMD_OEM_INTEL_SET_NODE_MANAGER_POLICY_SUSPEND_PERIODS */
/* IPMI_CMD_OEM_INTEL_GET_NODE_MANAGER_POLICY_SUSPEND_PERIODS */
/* IPMI_CMD_OEM_INTEL_RESET_NODE_MANAGER_STATISTICS */
/* IPMI_CMD_OEM_INTEL_GET_NODE_MANAGER_STATISTICS */
/* IPMI_CMD_OEM_INTEL_GET_NODE_MANAGER_CAPABILITIES */
/* IPMI_CMD_OEM_INTEL_SET_NODE_MANAGER_POWER_DRAW_RANGE */
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_INVALID_DOMAIN_ID 0x81
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_INVALID_DOMAIN_ID_STR \
  "Invalid Domain Id"

/* IPMI_CMD_OEM_INTEL_SET_NODE_MANAGER_POLICY */
/* IPMI_CMD_OEM_INTEL_SET_NODE_MANAGER_POLICY_ALERT_THRESHOLDS */
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_UNKNOWN_OR_UNSUPPORTED_POLICY_TRIGGER_TYPE 0x82
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_UNKNOWN_OR_UNSUPPORTED_POLICY_TRIGGER_TYPE_STR \
  "unknown or unsupported Policy Trigger Type"

/* IPMI_CMD_OEM_INTEL_SET_NODE_MANAGER_POLICY */
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_UNKNOWN_OR_UNSUPPORTED_POLICY_CONFIGURATION_ACTION 0x83
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_UNKNOWN_OR_UNSUPPORTED_POLICY_CONFIGURATION_ACTION_STR \
  "unknown or unsupported Policy Configuration Action"

#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_POWER_LIMIT_OUT_OF_RANGE 0x84
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_POWER_LIMIT_OUT_OF_RANGE_STR \
  "Power Limit out of range"

#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_CORRECTION_TIME_OUT_OF_RANGE 0x85
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_CORRECTION_TIME_OUT_OF_RANGE_STR \
  "Correction Time out of range"

#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_POLICY_TRIGGER_VALUE_OUT_OF_RANGE 0x86
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_POLICY_TRIGGER_VALUE_OUT_OF_RANGE_STR \
  "Policy Trigger value out of range"

#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_STATISTICS_REPORTING_PERIOD_OUT_OF_RANGE 0x89
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_STATISTICS_REPORTING_PERIOD_OUT_OF_RANGE_STR \
  "Statistics Reporting Period out of range"

#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_INVALID_VALUE_OF_AGGRESSIVE_CPU_POWER_CORRECTION_FIELD 0x8B
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_INVALID_VALUE_OF_AGGRESSIVE_CPU_POWER_CORRECTION_FIELD_STR \
  "Invalid value of Aggressive CPU Power Correction field"

/* Standard error with special meaning */
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_SET_NODE_MANAGER_POLICY_REQUEST_PARAMETER_NOT_SUPPORTED 0xD5
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_SET_NODE_MANAGER_POLICY_REQUEST_PARAMETER_NOT_SUPPORTED_STR \
  "Policy could not be updated since PolicyId already exists and is enabled"

/* Standard error with special meaning */
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_SET_NODE_MANAGER_POLICY_SUSPEND_PERIODS_REQUEST_PARAMETER_ILLEGAL 0xD6
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_SET_NODE_MANAGER_POLICY_SUSPEND_PERIODS_REQUEST_PARAMETER_ILLEGAL_STR \
  "Command disabled/unavailable due to lack of RTC synchronization"

/* IPMI_CMD_OEM_INTEL_SET_NODE_MANAGER_POLICY_ALERT_THRESHOLDS */
/* No longer in 3.0 */
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_LIMIT_IN_ONE_OF_THRESHOLDS_IS_INVALID 0x84
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_LIMIT_IN_ONE_OF_THRESHOLDS_IS_INVALID_STR \
  "Limit in one of thresholds is invalid"

#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_NUMBER_OF_THRESHOLDS_IS_TOO_LARGE_OR_POWER_LIMITS_ARE_INVALID 0x87
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_NUMBER_OF_THRESHOLDS_IS_TOO_LARGE_OR_POWER_LIMITS_ARE_INVALID_STR \
  "Number of thresholds is too large or power limits are invalid"

/* legacy name */
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_INVALID_NUMBER_OF_POLICY_THRESHOLDS     IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_NUMBER_OF_THRESHOLDS_IS_TOO_LARGE_OR_POWER_LIMITS_ARE_INVALID
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_INVALID_NUMBER_OF_POLICY_THRESHOLDS_STR IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_NUMBER_OF_THRESHOLDS_IS_TOO_LARGE_OR_POWER_LIMITS_ARE_INVALID_STR

/* Standard error with special meaning */
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_SET_NODE_MANAGER_POLICY_ALERT_THRESHOLDS_REQUEST_PARAMETER_NOT_SUPPORTED 0xD5
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_SET_NODE_MANAGER_POLICY_ALERT_THRESHOLDS_REQUEST_PARAMETER_NOT_SUPPORTED_STR \
  "Alert thresholds can not be changed for enabled policy, disable it first"

/* legacy name */
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_SET_NODE_MANAGER_ALERT_THRESHOLDS_REQUEST_PARAMETER_NOT_SUPPORTED     IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_SET_NODE_MANAGER_POLICY_ALERT_THRESHOLDS_REQUEST_PARAMETER_NOT_SUPPORTED
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_SET_NODE_MANAGER_ALERT_THRESHOLDS_REQUEST_PARAMETER_NOT_SUPPORTED_STR IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_SET_NODE_MANAGER_POLICY_ALERT_THRESHOLDS_REQUEST_PARAMETER_NOT_SUPPORTED_STR

/* IPMI_CMD_OEM_INTEL_SET_NODE_MANAGER_POLICY_SUSPEND_PERIODS */
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_ONE_OF_PERIODS_IN_THE_TABLE_IS_INCONSISTENT 0x85
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_ONE_OF_PERIODS_IN_THE_TABLE_IS_INCONSISTENT_STR \
  "One of the periods in the table is inconsistent.  Start time is greater than or " \
  "equal to stop time or stop time sets time beyond 1 day"

#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_INVALID_NUMBER_OF_POLICY_SUSPEND_PERIODS 0x87
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_INVALID_NUMBER_OF_POLICY_SUSPEND_PERIODS_STR \
  "Invalid Number of policy suspend periods"

/* Standard error with special meaning */
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_SET_NODE_MANAGER_POLICY_SUSPEND_PERIODS_REQUEST_PARAMETER_NOT_SUPPORTED 0xD5
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_SET_NODE_MANAGER_POLICY_SUSPEND_PERIODS_REQUEST_PARAMETER_NOT_SUPPORTED_STR \
  "Suspend periods can not be changed for enabled policy, disable it first"

/* IPMI_CMD_OEM_INTEL_RESET_NODE_MANAGER_STATISTICS */
/* IPMI_CMD_OEM_INTEL_GET_NODE_MANAGER_STATISTICS */
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_INVALID_MODE 0x88
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_INVALID_MODE_STR \
  "Invalid Mode"

/* IPMI_CMD_OEM_INTEL_GET_NODE_MANAGER_CAPABILITIES */
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_UNKNOWN_POLICY_TRIGGER_TYPE 0x82
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_UNKNOWN_POLICY_TRIGGER_TYPE_STR \
  "unknown Policy Trigger Type"

#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_UNKNOWN_POLICY_TYPE 0x83
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_UNKNOWN_POLICY_TYPE_STR \
  "unknown Policy Type"

/* IPMI_CMD_OEM_INTEL_NODE_MANAGER_GET_LIMITING_POLICY_ID */
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_NO_POLICY_IS_CURRENTLY_LIMITING 0xA1
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_NO_POLICY_IS_CURRENTLY_LIMITING_STR \
  "No policy is currently limiting for the specified DomainID"

/* IPMI_CMD_OEM_INTEL_NODE_MANAGER_SET_TURBO_SYNCHRONIZATION_RATIO */
/* IPMI_CMD_OEM_INTEL_NODE_MANAGER_GET_TURBO_SYNChRONIZATION_RATIO */
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_WRONG_CPU_SOCKET_NUMBER 0xA1
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_WRONG_CPU_SOCKET_NUMBER_STR \
  "Wrong CPU socket number"

#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_COMMAND_RESPONSE_TIMEOUT 0xA2
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_COMMAND_RESPONSE_TIMEOUT_STR \
  "Command response timeout"

#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_BAD_READ_FSC_IN_THE_RESPONSE 0xA4
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_BAD_READ_FSC_IN_THE_RESPONSE_STR \
  "Bad read FSC in the response"

#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_BAD_WRITE_FCS_FIELD_IN_THE_RESPONSE 0xA5
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_BAD_WRITE_FCS_FIELD_IN_THE_RESPONSE_STR \
  "Bad write FCS field in the response"

#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_CPU_NOT_PRESENT 0xAC
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_CPU_NOT_PRESENT_STR \
  "CPU not present"

/* standard error with special meaning */
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_PLATFORM_NOT_IN_S0_S1_STATE 0xD5
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_PLATFORM_NOT_IN_S0_S1_STATE_STR \
  "Platform not in the S0/S1 state "

/* standard error with special meaning */
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_INCORRECT_ACTIVE_CORES_CONFIGURATION 0xC9
#define IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_INCORRECT_ACTIVE_CORES_CONFIGURATION_STR \
  "Incorrect active cores configuration.  Number of active cores exceeding number of cores on CPU"

#ifdef __cplusplus
}
#endif

#endif /* IPMI_COMP_CODE_OEM_INTEL_NODE_MANAGER_SPEC_H */
