/******************************************************************************

	fd.h -- UNIX file descriptor bookkeeping and handling
	Copyright (C) 2004  Wessel Dankers <wsl@uvt.nl>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.

	$Id: fd.h 223 2011-12-02 10:53:44Z wsl $
	$URL: https://svn.fair.uvt.nl/branches/0.5/src/fd.h $

******************************************************************************/

#ifndef FD_H
#define FD_H

#include <avl.h>
#include <sys/select.h>

#include "fair.h"
#include "chrono.h"

typedef enum {
	FD_EVENT_READ,
	FD_EVENT_WRITE,
	FD_EVENT_OOB
} fd_event_t;

struct fd;

typedef void (*fd_hook_t)(struct fd *, fd_event_t);

typedef struct fd {
	avl_node_t node;
	int fd;
	fd_hook_t rfunc;
	fd_hook_t wfunc;
	fd_hook_t ofunc;
	void *rdata;
	void *wdata;
	void *odata;
} fd_t;

extern unsigned int fd_count(void);
extern fd_t *fd_new(int);
extern void fd_delete(fd_t *);
extern void fd_close(fd_t *);
extern fd_t *fd_byfd(int);
extern void fd_read(fd_t *, fd_hook_t, void *);
extern void fd_write(fd_t *, fd_hook_t, void *);
extern void fd_oob(fd_t *, fd_hook_t, void *);
extern int fd_select(stamp_t);

#endif
