// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v3.21.12
// source: internal/proto/v2/s2a/s2a.proto

package s2a_go_proto

import (
	common_go_proto "github.com/google/s2a-go/internal/proto/v2/common_go_proto"
	s2a_context_go_proto "github.com/google/s2a-go/internal/proto/v2/s2a_context_go_proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type SignatureAlgorithm int32

const (
	SignatureAlgorithm_S2A_SSL_SIGN_UNSPECIFIED SignatureAlgorithm = 0
	// RSA Public-Key Cryptography Standards #1.
	SignatureAlgorithm_S2A_SSL_SIGN_RSA_PKCS1_SHA256 SignatureAlgorithm = 1
	SignatureAlgorithm_S2A_SSL_SIGN_RSA_PKCS1_SHA384 SignatureAlgorithm = 2
	SignatureAlgorithm_S2A_SSL_SIGN_RSA_PKCS1_SHA512 SignatureAlgorithm = 3
	// ECDSA.
	SignatureAlgorithm_S2A_SSL_SIGN_ECDSA_SECP256R1_SHA256 SignatureAlgorithm = 4
	SignatureAlgorithm_S2A_SSL_SIGN_ECDSA_SECP384R1_SHA384 SignatureAlgorithm = 5
	SignatureAlgorithm_S2A_SSL_SIGN_ECDSA_SECP521R1_SHA512 SignatureAlgorithm = 6
	// RSA Probabilistic Signature Scheme.
	SignatureAlgorithm_S2A_SSL_SIGN_RSA_PSS_RSAE_SHA256 SignatureAlgorithm = 7
	SignatureAlgorithm_S2A_SSL_SIGN_RSA_PSS_RSAE_SHA384 SignatureAlgorithm = 8
	SignatureAlgorithm_S2A_SSL_SIGN_RSA_PSS_RSAE_SHA512 SignatureAlgorithm = 9
	// ED25519.
	SignatureAlgorithm_S2A_SSL_SIGN_ED25519 SignatureAlgorithm = 10
)

// Enum value maps for SignatureAlgorithm.
var (
	SignatureAlgorithm_name = map[int32]string{
		0:  "S2A_SSL_SIGN_UNSPECIFIED",
		1:  "S2A_SSL_SIGN_RSA_PKCS1_SHA256",
		2:  "S2A_SSL_SIGN_RSA_PKCS1_SHA384",
		3:  "S2A_SSL_SIGN_RSA_PKCS1_SHA512",
		4:  "S2A_SSL_SIGN_ECDSA_SECP256R1_SHA256",
		5:  "S2A_SSL_SIGN_ECDSA_SECP384R1_SHA384",
		6:  "S2A_SSL_SIGN_ECDSA_SECP521R1_SHA512",
		7:  "S2A_SSL_SIGN_RSA_PSS_RSAE_SHA256",
		8:  "S2A_SSL_SIGN_RSA_PSS_RSAE_SHA384",
		9:  "S2A_SSL_SIGN_RSA_PSS_RSAE_SHA512",
		10: "S2A_SSL_SIGN_ED25519",
	}
	SignatureAlgorithm_value = map[string]int32{
		"S2A_SSL_SIGN_UNSPECIFIED":            0,
		"S2A_SSL_SIGN_RSA_PKCS1_SHA256":       1,
		"S2A_SSL_SIGN_RSA_PKCS1_SHA384":       2,
		"S2A_SSL_SIGN_RSA_PKCS1_SHA512":       3,
		"S2A_SSL_SIGN_ECDSA_SECP256R1_SHA256": 4,
		"S2A_SSL_SIGN_ECDSA_SECP384R1_SHA384": 5,
		"S2A_SSL_SIGN_ECDSA_SECP521R1_SHA512": 6,
		"S2A_SSL_SIGN_RSA_PSS_RSAE_SHA256":    7,
		"S2A_SSL_SIGN_RSA_PSS_RSAE_SHA384":    8,
		"S2A_SSL_SIGN_RSA_PSS_RSAE_SHA512":    9,
		"S2A_SSL_SIGN_ED25519":                10,
	}
)

func (x SignatureAlgorithm) Enum() *SignatureAlgorithm {
	p := new(SignatureAlgorithm)
	*p = x
	return p
}

func (x SignatureAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SignatureAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_internal_proto_v2_s2a_s2a_proto_enumTypes[0].Descriptor()
}

func (SignatureAlgorithm) Type() protoreflect.EnumType {
	return &file_internal_proto_v2_s2a_s2a_proto_enumTypes[0]
}

func (x SignatureAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SignatureAlgorithm.Descriptor instead.
func (SignatureAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{0}
}

type GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate int32

const (
	GetTlsConfigurationResp_ServerTlsConfiguration_UNSPECIFIED                                            GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate = 0
	GetTlsConfigurationResp_ServerTlsConfiguration_DONT_REQUEST_CLIENT_CERTIFICATE                        GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate = 1
	GetTlsConfigurationResp_ServerTlsConfiguration_REQUEST_CLIENT_CERTIFICATE_BUT_DONT_VERIFY             GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate = 2
	GetTlsConfigurationResp_ServerTlsConfiguration_REQUEST_CLIENT_CERTIFICATE_AND_VERIFY                  GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate = 3
	GetTlsConfigurationResp_ServerTlsConfiguration_REQUEST_AND_REQUIRE_CLIENT_CERTIFICATE_BUT_DONT_VERIFY GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate = 4
	GetTlsConfigurationResp_ServerTlsConfiguration_REQUEST_AND_REQUIRE_CLIENT_CERTIFICATE_AND_VERIFY      GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate = 5
)

// Enum value maps for GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate.
var (
	GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "DONT_REQUEST_CLIENT_CERTIFICATE",
		2: "REQUEST_CLIENT_CERTIFICATE_BUT_DONT_VERIFY",
		3: "REQUEST_CLIENT_CERTIFICATE_AND_VERIFY",
		4: "REQUEST_AND_REQUIRE_CLIENT_CERTIFICATE_BUT_DONT_VERIFY",
		5: "REQUEST_AND_REQUIRE_CLIENT_CERTIFICATE_AND_VERIFY",
	}
	GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate_value = map[string]int32{
		"UNSPECIFIED":                                            0,
		"DONT_REQUEST_CLIENT_CERTIFICATE":                        1,
		"REQUEST_CLIENT_CERTIFICATE_BUT_DONT_VERIFY":             2,
		"REQUEST_CLIENT_CERTIFICATE_AND_VERIFY":                  3,
		"REQUEST_AND_REQUIRE_CLIENT_CERTIFICATE_BUT_DONT_VERIFY": 4,
		"REQUEST_AND_REQUIRE_CLIENT_CERTIFICATE_AND_VERIFY":      5,
	}
)

func (x GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate) Enum() *GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate {
	p := new(GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate)
	*p = x
	return p
}

func (x GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate) Descriptor() protoreflect.EnumDescriptor {
	return file_internal_proto_v2_s2a_s2a_proto_enumTypes[1].Descriptor()
}

func (GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate) Type() protoreflect.EnumType {
	return &file_internal_proto_v2_s2a_s2a_proto_enumTypes[1]
}

func (x GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate.Descriptor instead.
func (GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate) EnumDescriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{4, 1, 0}
}

type OffloadPrivateKeyOperationReq_PrivateKeyOperation int32

const (
	OffloadPrivateKeyOperationReq_UNSPECIFIED OffloadPrivateKeyOperationReq_PrivateKeyOperation = 0
	// When performing a TLS 1.2 or 1.3 handshake, the (partial) transcript of
	// the TLS handshake must be signed to prove possession of the private key.
	//
	// See https://www.rfc-editor.org/rfc/rfc8446.html#section-4.4.3.
	OffloadPrivateKeyOperationReq_SIGN OffloadPrivateKeyOperationReq_PrivateKeyOperation = 1
	// When performing a TLS 1.2 handshake using an RSA algorithm, the key
	// exchange algorithm involves the client generating a premaster secret,
	// encrypting it using the server's public key, and sending this encrypted
	// blob to the server in a ClientKeyExchange message.
	//
	// See https://www.rfc-editor.org/rfc/rfc4346#section-7.4.7.1.
	OffloadPrivateKeyOperationReq_DECRYPT OffloadPrivateKeyOperationReq_PrivateKeyOperation = 2
)

// Enum value maps for OffloadPrivateKeyOperationReq_PrivateKeyOperation.
var (
	OffloadPrivateKeyOperationReq_PrivateKeyOperation_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "SIGN",
		2: "DECRYPT",
	}
	OffloadPrivateKeyOperationReq_PrivateKeyOperation_value = map[string]int32{
		"UNSPECIFIED": 0,
		"SIGN":        1,
		"DECRYPT":     2,
	}
)

func (x OffloadPrivateKeyOperationReq_PrivateKeyOperation) Enum() *OffloadPrivateKeyOperationReq_PrivateKeyOperation {
	p := new(OffloadPrivateKeyOperationReq_PrivateKeyOperation)
	*p = x
	return p
}

func (x OffloadPrivateKeyOperationReq_PrivateKeyOperation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OffloadPrivateKeyOperationReq_PrivateKeyOperation) Descriptor() protoreflect.EnumDescriptor {
	return file_internal_proto_v2_s2a_s2a_proto_enumTypes[2].Descriptor()
}

func (OffloadPrivateKeyOperationReq_PrivateKeyOperation) Type() protoreflect.EnumType {
	return &file_internal_proto_v2_s2a_s2a_proto_enumTypes[2]
}

func (x OffloadPrivateKeyOperationReq_PrivateKeyOperation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OffloadPrivateKeyOperationReq_PrivateKeyOperation.Descriptor instead.
func (OffloadPrivateKeyOperationReq_PrivateKeyOperation) EnumDescriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{5, 0}
}

type OffloadResumptionKeyOperationReq_ResumptionKeyOperation int32

const (
	OffloadResumptionKeyOperationReq_UNSPECIFIED OffloadResumptionKeyOperationReq_ResumptionKeyOperation = 0
	OffloadResumptionKeyOperationReq_ENCRYPT     OffloadResumptionKeyOperationReq_ResumptionKeyOperation = 1
	OffloadResumptionKeyOperationReq_DECRYPT     OffloadResumptionKeyOperationReq_ResumptionKeyOperation = 2
)

// Enum value maps for OffloadResumptionKeyOperationReq_ResumptionKeyOperation.
var (
	OffloadResumptionKeyOperationReq_ResumptionKeyOperation_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "ENCRYPT",
		2: "DECRYPT",
	}
	OffloadResumptionKeyOperationReq_ResumptionKeyOperation_value = map[string]int32{
		"UNSPECIFIED": 0,
		"ENCRYPT":     1,
		"DECRYPT":     2,
	}
)

func (x OffloadResumptionKeyOperationReq_ResumptionKeyOperation) Enum() *OffloadResumptionKeyOperationReq_ResumptionKeyOperation {
	p := new(OffloadResumptionKeyOperationReq_ResumptionKeyOperation)
	*p = x
	return p
}

func (x OffloadResumptionKeyOperationReq_ResumptionKeyOperation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OffloadResumptionKeyOperationReq_ResumptionKeyOperation) Descriptor() protoreflect.EnumDescriptor {
	return file_internal_proto_v2_s2a_s2a_proto_enumTypes[3].Descriptor()
}

func (OffloadResumptionKeyOperationReq_ResumptionKeyOperation) Type() protoreflect.EnumType {
	return &file_internal_proto_v2_s2a_s2a_proto_enumTypes[3]
}

func (x OffloadResumptionKeyOperationReq_ResumptionKeyOperation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OffloadResumptionKeyOperationReq_ResumptionKeyOperation.Descriptor instead.
func (OffloadResumptionKeyOperationReq_ResumptionKeyOperation) EnumDescriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{7, 0}
}

type ValidatePeerCertificateChainReq_VerificationMode int32

const (
	// The default verification mode supported by S2A.
	ValidatePeerCertificateChainReq_UNSPECIFIED ValidatePeerCertificateChainReq_VerificationMode = 0
	// The SPIFFE verification mode selects the set of trusted certificates to
	// use for path building based on the SPIFFE trust domain in the peer's leaf
	// certificate.
	ValidatePeerCertificateChainReq_SPIFFE ValidatePeerCertificateChainReq_VerificationMode = 1
	// The connect-to-Google verification mode uses the trust bundle for
	// connecting to Google, e.g. *.mtls.googleapis.com endpoints.
	ValidatePeerCertificateChainReq_CONNECT_TO_GOOGLE ValidatePeerCertificateChainReq_VerificationMode = 2
	// Internal use only.
	ValidatePeerCertificateChainReq_RESERVED_CUSTOM_VERIFICATION_MODE_3 ValidatePeerCertificateChainReq_VerificationMode = 3
	// Internal use only.
	ValidatePeerCertificateChainReq_RESERVED_CUSTOM_VERIFICATION_MODE_4 ValidatePeerCertificateChainReq_VerificationMode = 4
	// Internal use only.
	ValidatePeerCertificateChainReq_RESERVED_CUSTOM_VERIFICATION_MODE_5 ValidatePeerCertificateChainReq_VerificationMode = 5
	// Internal use only.
	ValidatePeerCertificateChainReq_RESERVED_CUSTOM_VERIFICATION_MODE_6 ValidatePeerCertificateChainReq_VerificationMode = 6
)

// Enum value maps for ValidatePeerCertificateChainReq_VerificationMode.
var (
	ValidatePeerCertificateChainReq_VerificationMode_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "SPIFFE",
		2: "CONNECT_TO_GOOGLE",
		3: "RESERVED_CUSTOM_VERIFICATION_MODE_3",
		4: "RESERVED_CUSTOM_VERIFICATION_MODE_4",
		5: "RESERVED_CUSTOM_VERIFICATION_MODE_5",
		6: "RESERVED_CUSTOM_VERIFICATION_MODE_6",
	}
	ValidatePeerCertificateChainReq_VerificationMode_value = map[string]int32{
		"UNSPECIFIED":                         0,
		"SPIFFE":                              1,
		"CONNECT_TO_GOOGLE":                   2,
		"RESERVED_CUSTOM_VERIFICATION_MODE_3": 3,
		"RESERVED_CUSTOM_VERIFICATION_MODE_4": 4,
		"RESERVED_CUSTOM_VERIFICATION_MODE_5": 5,
		"RESERVED_CUSTOM_VERIFICATION_MODE_6": 6,
	}
)

func (x ValidatePeerCertificateChainReq_VerificationMode) Enum() *ValidatePeerCertificateChainReq_VerificationMode {
	p := new(ValidatePeerCertificateChainReq_VerificationMode)
	*p = x
	return p
}

func (x ValidatePeerCertificateChainReq_VerificationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ValidatePeerCertificateChainReq_VerificationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_internal_proto_v2_s2a_s2a_proto_enumTypes[4].Descriptor()
}

func (ValidatePeerCertificateChainReq_VerificationMode) Type() protoreflect.EnumType {
	return &file_internal_proto_v2_s2a_s2a_proto_enumTypes[4]
}

func (x ValidatePeerCertificateChainReq_VerificationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ValidatePeerCertificateChainReq_VerificationMode.Descriptor instead.
func (ValidatePeerCertificateChainReq_VerificationMode) EnumDescriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{9, 0}
}

type ValidatePeerCertificateChainResp_ValidationResult int32

const (
	ValidatePeerCertificateChainResp_UNSPECIFIED ValidatePeerCertificateChainResp_ValidationResult = 0
	ValidatePeerCertificateChainResp_SUCCESS     ValidatePeerCertificateChainResp_ValidationResult = 1
	ValidatePeerCertificateChainResp_FAILURE     ValidatePeerCertificateChainResp_ValidationResult = 2
)

// Enum value maps for ValidatePeerCertificateChainResp_ValidationResult.
var (
	ValidatePeerCertificateChainResp_ValidationResult_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "SUCCESS",
		2: "FAILURE",
	}
	ValidatePeerCertificateChainResp_ValidationResult_value = map[string]int32{
		"UNSPECIFIED": 0,
		"SUCCESS":     1,
		"FAILURE":     2,
	}
)

func (x ValidatePeerCertificateChainResp_ValidationResult) Enum() *ValidatePeerCertificateChainResp_ValidationResult {
	p := new(ValidatePeerCertificateChainResp_ValidationResult)
	*p = x
	return p
}

func (x ValidatePeerCertificateChainResp_ValidationResult) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ValidatePeerCertificateChainResp_ValidationResult) Descriptor() protoreflect.EnumDescriptor {
	return file_internal_proto_v2_s2a_s2a_proto_enumTypes[5].Descriptor()
}

func (ValidatePeerCertificateChainResp_ValidationResult) Type() protoreflect.EnumType {
	return &file_internal_proto_v2_s2a_s2a_proto_enumTypes[5]
}

func (x ValidatePeerCertificateChainResp_ValidationResult) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ValidatePeerCertificateChainResp_ValidationResult.Descriptor instead.
func (ValidatePeerCertificateChainResp_ValidationResult) EnumDescriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{10, 0}
}

type AlpnPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If true, the application MUST perform ALPN negotiation.
	EnableAlpnNegotiation bool `protobuf:"varint,1,opt,name=enable_alpn_negotiation,json=enableAlpnNegotiation,proto3" json:"enable_alpn_negotiation,omitempty"`
	// The ordered list of ALPN protocols that specify how the application SHOULD
	// negotiate ALPN during the TLS handshake.
	//
	// The application MAY ignore any ALPN protocols in this list that are not
	// supported by the application.
	AlpnProtocols []common_go_proto.AlpnProtocol `protobuf:"varint,2,rep,packed,name=alpn_protocols,json=alpnProtocols,proto3,enum=s2a.proto.v2.AlpnProtocol" json:"alpn_protocols,omitempty"`
}

func (x *AlpnPolicy) Reset() {
	*x = AlpnPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AlpnPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlpnPolicy) ProtoMessage() {}

func (x *AlpnPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlpnPolicy.ProtoReflect.Descriptor instead.
func (*AlpnPolicy) Descriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{0}
}

func (x *AlpnPolicy) GetEnableAlpnNegotiation() bool {
	if x != nil {
		return x.EnableAlpnNegotiation
	}
	return false
}

func (x *AlpnPolicy) GetAlpnProtocols() []common_go_proto.AlpnProtocol {
	if x != nil {
		return x.AlpnProtocols
	}
	return nil
}

type AuthenticationMechanism struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Applications may specify an identity associated to an authentication
	// mechanism. Otherwise, S2A assumes that the authentication mechanism is
	// associated with the default identity. If the default identity cannot be
	// determined, the request is rejected.
	Identity *common_go_proto.Identity `protobuf:"bytes,3,opt,name=identity,proto3" json:"identity,omitempty"`
	// Types that are assignable to MechanismOneof:
	//
	//	*AuthenticationMechanism_Token
	MechanismOneof isAuthenticationMechanism_MechanismOneof `protobuf_oneof:"mechanism_oneof"`
}

func (x *AuthenticationMechanism) Reset() {
	*x = AuthenticationMechanism{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthenticationMechanism) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthenticationMechanism) ProtoMessage() {}

func (x *AuthenticationMechanism) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthenticationMechanism.ProtoReflect.Descriptor instead.
func (*AuthenticationMechanism) Descriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{1}
}

func (x *AuthenticationMechanism) GetIdentity() *common_go_proto.Identity {
	if x != nil {
		return x.Identity
	}
	return nil
}

func (m *AuthenticationMechanism) GetMechanismOneof() isAuthenticationMechanism_MechanismOneof {
	if m != nil {
		return m.MechanismOneof
	}
	return nil
}

func (x *AuthenticationMechanism) GetToken() string {
	if x, ok := x.GetMechanismOneof().(*AuthenticationMechanism_Token); ok {
		return x.Token
	}
	return ""
}

type isAuthenticationMechanism_MechanismOneof interface {
	isAuthenticationMechanism_MechanismOneof()
}

type AuthenticationMechanism_Token struct {
	// A token that the application uses to authenticate itself to S2A.
	Token string `protobuf:"bytes,2,opt,name=token,proto3,oneof"`
}

func (*AuthenticationMechanism_Token) isAuthenticationMechanism_MechanismOneof() {}

type Status struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status code that is specific to the application and the implementation
	// of S2A, e.g., gRPC status code.
	Code uint32 `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	// The status details.
	Details string `protobuf:"bytes,2,opt,name=details,proto3" json:"details,omitempty"`
}

func (x *Status) Reset() {
	*x = Status{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Status) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Status) ProtoMessage() {}

func (x *Status) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Status.ProtoReflect.Descriptor instead.
func (*Status) Descriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{2}
}

func (x *Status) GetCode() uint32 {
	if x != nil {
		return x.Code
	}
	return 0
}

func (x *Status) GetDetails() string {
	if x != nil {
		return x.Details
	}
	return ""
}

type GetTlsConfigurationReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The role of the application in the TLS connection.
	ConnectionSide common_go_proto.ConnectionSide `protobuf:"varint,1,opt,name=connection_side,json=connectionSide,proto3,enum=s2a.proto.v2.ConnectionSide" json:"connection_side,omitempty"`
	// The server name indication (SNI) extension, which MAY be populated when a
	// server is offloading to S2A. The SNI is used to determine the server
	// identity if the local identity in the request is empty.
	Sni string `protobuf:"bytes,2,opt,name=sni,proto3" json:"sni,omitempty"`
}

func (x *GetTlsConfigurationReq) Reset() {
	*x = GetTlsConfigurationReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTlsConfigurationReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTlsConfigurationReq) ProtoMessage() {}

func (x *GetTlsConfigurationReq) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTlsConfigurationReq.ProtoReflect.Descriptor instead.
func (*GetTlsConfigurationReq) Descriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{3}
}

func (x *GetTlsConfigurationReq) GetConnectionSide() common_go_proto.ConnectionSide {
	if x != nil {
		return x.ConnectionSide
	}
	return common_go_proto.ConnectionSide(0)
}

func (x *GetTlsConfigurationReq) GetSni() string {
	if x != nil {
		return x.Sni
	}
	return ""
}

type GetTlsConfigurationResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to TlsConfiguration:
	//
	//	*GetTlsConfigurationResp_ClientTlsConfiguration_
	//	*GetTlsConfigurationResp_ServerTlsConfiguration_
	TlsConfiguration isGetTlsConfigurationResp_TlsConfiguration `protobuf_oneof:"tls_configuration"`
}

func (x *GetTlsConfigurationResp) Reset() {
	*x = GetTlsConfigurationResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTlsConfigurationResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTlsConfigurationResp) ProtoMessage() {}

func (x *GetTlsConfigurationResp) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTlsConfigurationResp.ProtoReflect.Descriptor instead.
func (*GetTlsConfigurationResp) Descriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{4}
}

func (m *GetTlsConfigurationResp) GetTlsConfiguration() isGetTlsConfigurationResp_TlsConfiguration {
	if m != nil {
		return m.TlsConfiguration
	}
	return nil
}

func (x *GetTlsConfigurationResp) GetClientTlsConfiguration() *GetTlsConfigurationResp_ClientTlsConfiguration {
	if x, ok := x.GetTlsConfiguration().(*GetTlsConfigurationResp_ClientTlsConfiguration_); ok {
		return x.ClientTlsConfiguration
	}
	return nil
}

func (x *GetTlsConfigurationResp) GetServerTlsConfiguration() *GetTlsConfigurationResp_ServerTlsConfiguration {
	if x, ok := x.GetTlsConfiguration().(*GetTlsConfigurationResp_ServerTlsConfiguration_); ok {
		return x.ServerTlsConfiguration
	}
	return nil
}

type isGetTlsConfigurationResp_TlsConfiguration interface {
	isGetTlsConfigurationResp_TlsConfiguration()
}

type GetTlsConfigurationResp_ClientTlsConfiguration_ struct {
	ClientTlsConfiguration *GetTlsConfigurationResp_ClientTlsConfiguration `protobuf:"bytes,1,opt,name=client_tls_configuration,json=clientTlsConfiguration,proto3,oneof"`
}

type GetTlsConfigurationResp_ServerTlsConfiguration_ struct {
	ServerTlsConfiguration *GetTlsConfigurationResp_ServerTlsConfiguration `protobuf:"bytes,2,opt,name=server_tls_configuration,json=serverTlsConfiguration,proto3,oneof"`
}

func (*GetTlsConfigurationResp_ClientTlsConfiguration_) isGetTlsConfigurationResp_TlsConfiguration() {
}

func (*GetTlsConfigurationResp_ServerTlsConfiguration_) isGetTlsConfigurationResp_TlsConfiguration() {
}

type OffloadPrivateKeyOperationReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operation the private key is used for.
	Operation OffloadPrivateKeyOperationReq_PrivateKeyOperation `protobuf:"varint,1,opt,name=operation,proto3,enum=s2a.proto.v2.OffloadPrivateKeyOperationReq_PrivateKeyOperation" json:"operation,omitempty"`
	// The signature algorithm to be used for signing operations.
	SignatureAlgorithm SignatureAlgorithm `protobuf:"varint,2,opt,name=signature_algorithm,json=signatureAlgorithm,proto3,enum=s2a.proto.v2.SignatureAlgorithm" json:"signature_algorithm,omitempty"`
	// The input bytes to be signed or decrypted.
	//
	// Types that are assignable to InBytes:
	//
	//	*OffloadPrivateKeyOperationReq_RawBytes
	//	*OffloadPrivateKeyOperationReq_Sha256Digest
	//	*OffloadPrivateKeyOperationReq_Sha384Digest
	//	*OffloadPrivateKeyOperationReq_Sha512Digest
	InBytes isOffloadPrivateKeyOperationReq_InBytes `protobuf_oneof:"in_bytes"`
}

func (x *OffloadPrivateKeyOperationReq) Reset() {
	*x = OffloadPrivateKeyOperationReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OffloadPrivateKeyOperationReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OffloadPrivateKeyOperationReq) ProtoMessage() {}

func (x *OffloadPrivateKeyOperationReq) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OffloadPrivateKeyOperationReq.ProtoReflect.Descriptor instead.
func (*OffloadPrivateKeyOperationReq) Descriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{5}
}

func (x *OffloadPrivateKeyOperationReq) GetOperation() OffloadPrivateKeyOperationReq_PrivateKeyOperation {
	if x != nil {
		return x.Operation
	}
	return OffloadPrivateKeyOperationReq_UNSPECIFIED
}

func (x *OffloadPrivateKeyOperationReq) GetSignatureAlgorithm() SignatureAlgorithm {
	if x != nil {
		return x.SignatureAlgorithm
	}
	return SignatureAlgorithm_S2A_SSL_SIGN_UNSPECIFIED
}

func (m *OffloadPrivateKeyOperationReq) GetInBytes() isOffloadPrivateKeyOperationReq_InBytes {
	if m != nil {
		return m.InBytes
	}
	return nil
}

func (x *OffloadPrivateKeyOperationReq) GetRawBytes() []byte {
	if x, ok := x.GetInBytes().(*OffloadPrivateKeyOperationReq_RawBytes); ok {
		return x.RawBytes
	}
	return nil
}

func (x *OffloadPrivateKeyOperationReq) GetSha256Digest() []byte {
	if x, ok := x.GetInBytes().(*OffloadPrivateKeyOperationReq_Sha256Digest); ok {
		return x.Sha256Digest
	}
	return nil
}

func (x *OffloadPrivateKeyOperationReq) GetSha384Digest() []byte {
	if x, ok := x.GetInBytes().(*OffloadPrivateKeyOperationReq_Sha384Digest); ok {
		return x.Sha384Digest
	}
	return nil
}

func (x *OffloadPrivateKeyOperationReq) GetSha512Digest() []byte {
	if x, ok := x.GetInBytes().(*OffloadPrivateKeyOperationReq_Sha512Digest); ok {
		return x.Sha512Digest
	}
	return nil
}

type isOffloadPrivateKeyOperationReq_InBytes interface {
	isOffloadPrivateKeyOperationReq_InBytes()
}

type OffloadPrivateKeyOperationReq_RawBytes struct {
	// Raw bytes to be hashed and signed, or decrypted.
	RawBytes []byte `protobuf:"bytes,4,opt,name=raw_bytes,json=rawBytes,proto3,oneof"`
}

type OffloadPrivateKeyOperationReq_Sha256Digest struct {
	// A SHA256 hash to be signed. Must be 32 bytes.
	Sha256Digest []byte `protobuf:"bytes,5,opt,name=sha256_digest,json=sha256Digest,proto3,oneof"`
}

type OffloadPrivateKeyOperationReq_Sha384Digest struct {
	// A SHA384 hash to be signed. Must be 48 bytes.
	Sha384Digest []byte `protobuf:"bytes,6,opt,name=sha384_digest,json=sha384Digest,proto3,oneof"`
}

type OffloadPrivateKeyOperationReq_Sha512Digest struct {
	// A SHA512 hash to be signed. Must be 64 bytes.
	Sha512Digest []byte `protobuf:"bytes,7,opt,name=sha512_digest,json=sha512Digest,proto3,oneof"`
}

func (*OffloadPrivateKeyOperationReq_RawBytes) isOffloadPrivateKeyOperationReq_InBytes() {}

func (*OffloadPrivateKeyOperationReq_Sha256Digest) isOffloadPrivateKeyOperationReq_InBytes() {}

func (*OffloadPrivateKeyOperationReq_Sha384Digest) isOffloadPrivateKeyOperationReq_InBytes() {}

func (*OffloadPrivateKeyOperationReq_Sha512Digest) isOffloadPrivateKeyOperationReq_InBytes() {}

type OffloadPrivateKeyOperationResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The signed or decrypted output bytes.
	OutBytes []byte `protobuf:"bytes,1,opt,name=out_bytes,json=outBytes,proto3" json:"out_bytes,omitempty"`
}

func (x *OffloadPrivateKeyOperationResp) Reset() {
	*x = OffloadPrivateKeyOperationResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OffloadPrivateKeyOperationResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OffloadPrivateKeyOperationResp) ProtoMessage() {}

func (x *OffloadPrivateKeyOperationResp) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OffloadPrivateKeyOperationResp.ProtoReflect.Descriptor instead.
func (*OffloadPrivateKeyOperationResp) Descriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{6}
}

func (x *OffloadPrivateKeyOperationResp) GetOutBytes() []byte {
	if x != nil {
		return x.OutBytes
	}
	return nil
}

type OffloadResumptionKeyOperationReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operation the resumption key is used for.
	Operation OffloadResumptionKeyOperationReq_ResumptionKeyOperation `protobuf:"varint,1,opt,name=operation,proto3,enum=s2a.proto.v2.OffloadResumptionKeyOperationReq_ResumptionKeyOperation" json:"operation,omitempty"`
	// The bytes to be encrypted or decrypted.
	InBytes []byte `protobuf:"bytes,2,opt,name=in_bytes,json=inBytes,proto3" json:"in_bytes,omitempty"`
}

func (x *OffloadResumptionKeyOperationReq) Reset() {
	*x = OffloadResumptionKeyOperationReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OffloadResumptionKeyOperationReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OffloadResumptionKeyOperationReq) ProtoMessage() {}

func (x *OffloadResumptionKeyOperationReq) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OffloadResumptionKeyOperationReq.ProtoReflect.Descriptor instead.
func (*OffloadResumptionKeyOperationReq) Descriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{7}
}

func (x *OffloadResumptionKeyOperationReq) GetOperation() OffloadResumptionKeyOperationReq_ResumptionKeyOperation {
	if x != nil {
		return x.Operation
	}
	return OffloadResumptionKeyOperationReq_UNSPECIFIED
}

func (x *OffloadResumptionKeyOperationReq) GetInBytes() []byte {
	if x != nil {
		return x.InBytes
	}
	return nil
}

type OffloadResumptionKeyOperationResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The encrypted or decrypted bytes.
	OutBytes []byte `protobuf:"bytes,1,opt,name=out_bytes,json=outBytes,proto3" json:"out_bytes,omitempty"`
}

func (x *OffloadResumptionKeyOperationResp) Reset() {
	*x = OffloadResumptionKeyOperationResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OffloadResumptionKeyOperationResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OffloadResumptionKeyOperationResp) ProtoMessage() {}

func (x *OffloadResumptionKeyOperationResp) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OffloadResumptionKeyOperationResp.ProtoReflect.Descriptor instead.
func (*OffloadResumptionKeyOperationResp) Descriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{8}
}

func (x *OffloadResumptionKeyOperationResp) GetOutBytes() []byte {
	if x != nil {
		return x.OutBytes
	}
	return nil
}

type ValidatePeerCertificateChainReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The verification mode that S2A MUST use to validate the peer certificate
	// chain.
	Mode ValidatePeerCertificateChainReq_VerificationMode `protobuf:"varint,1,opt,name=mode,proto3,enum=s2a.proto.v2.ValidatePeerCertificateChainReq_VerificationMode" json:"mode,omitempty"`
	// Types that are assignable to PeerOneof:
	//
	//	*ValidatePeerCertificateChainReq_ClientPeer_
	//	*ValidatePeerCertificateChainReq_ServerPeer_
	PeerOneof isValidatePeerCertificateChainReq_PeerOneof `protobuf_oneof:"peer_oneof"`
}

func (x *ValidatePeerCertificateChainReq) Reset() {
	*x = ValidatePeerCertificateChainReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidatePeerCertificateChainReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidatePeerCertificateChainReq) ProtoMessage() {}

func (x *ValidatePeerCertificateChainReq) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidatePeerCertificateChainReq.ProtoReflect.Descriptor instead.
func (*ValidatePeerCertificateChainReq) Descriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{9}
}

func (x *ValidatePeerCertificateChainReq) GetMode() ValidatePeerCertificateChainReq_VerificationMode {
	if x != nil {
		return x.Mode
	}
	return ValidatePeerCertificateChainReq_UNSPECIFIED
}

func (m *ValidatePeerCertificateChainReq) GetPeerOneof() isValidatePeerCertificateChainReq_PeerOneof {
	if m != nil {
		return m.PeerOneof
	}
	return nil
}

func (x *ValidatePeerCertificateChainReq) GetClientPeer() *ValidatePeerCertificateChainReq_ClientPeer {
	if x, ok := x.GetPeerOneof().(*ValidatePeerCertificateChainReq_ClientPeer_); ok {
		return x.ClientPeer
	}
	return nil
}

func (x *ValidatePeerCertificateChainReq) GetServerPeer() *ValidatePeerCertificateChainReq_ServerPeer {
	if x, ok := x.GetPeerOneof().(*ValidatePeerCertificateChainReq_ServerPeer_); ok {
		return x.ServerPeer
	}
	return nil
}

type isValidatePeerCertificateChainReq_PeerOneof interface {
	isValidatePeerCertificateChainReq_PeerOneof()
}

type ValidatePeerCertificateChainReq_ClientPeer_ struct {
	ClientPeer *ValidatePeerCertificateChainReq_ClientPeer `protobuf:"bytes,2,opt,name=client_peer,json=clientPeer,proto3,oneof"`
}

type ValidatePeerCertificateChainReq_ServerPeer_ struct {
	ServerPeer *ValidatePeerCertificateChainReq_ServerPeer `protobuf:"bytes,3,opt,name=server_peer,json=serverPeer,proto3,oneof"`
}

func (*ValidatePeerCertificateChainReq_ClientPeer_) isValidatePeerCertificateChainReq_PeerOneof() {}

func (*ValidatePeerCertificateChainReq_ServerPeer_) isValidatePeerCertificateChainReq_PeerOneof() {}

type ValidatePeerCertificateChainResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The result of validating the peer certificate chain.
	ValidationResult ValidatePeerCertificateChainResp_ValidationResult `protobuf:"varint,1,opt,name=validation_result,json=validationResult,proto3,enum=s2a.proto.v2.ValidatePeerCertificateChainResp_ValidationResult" json:"validation_result,omitempty"`
	// The validation details. This field is only populated when the validation
	// result is NOT SUCCESS.
	ValidationDetails string `protobuf:"bytes,2,opt,name=validation_details,json=validationDetails,proto3" json:"validation_details,omitempty"`
	// The S2A context contains information from the peer certificate chain.
	//
	// The S2A context MAY be populated even if validation of the peer certificate
	// chain fails.
	Context *s2a_context_go_proto.S2AContext `protobuf:"bytes,3,opt,name=context,proto3" json:"context,omitempty"`
}

func (x *ValidatePeerCertificateChainResp) Reset() {
	*x = ValidatePeerCertificateChainResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidatePeerCertificateChainResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidatePeerCertificateChainResp) ProtoMessage() {}

func (x *ValidatePeerCertificateChainResp) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidatePeerCertificateChainResp.ProtoReflect.Descriptor instead.
func (*ValidatePeerCertificateChainResp) Descriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{10}
}

func (x *ValidatePeerCertificateChainResp) GetValidationResult() ValidatePeerCertificateChainResp_ValidationResult {
	if x != nil {
		return x.ValidationResult
	}
	return ValidatePeerCertificateChainResp_UNSPECIFIED
}

func (x *ValidatePeerCertificateChainResp) GetValidationDetails() string {
	if x != nil {
		return x.ValidationDetails
	}
	return ""
}

func (x *ValidatePeerCertificateChainResp) GetContext() *s2a_context_go_proto.S2AContext {
	if x != nil {
		return x.Context
	}
	return nil
}

type SessionReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identity corresponding to the TLS configurations that MUST be used for
	// the TLS handshake.
	//
	// If a managed identity already exists, the local identity and authentication
	// mechanisms are ignored. If a managed identity doesn't exist and the local
	// identity is not populated, S2A will try to deduce the managed identity to
	// use from the SNI extension. If that also fails, S2A uses the default
	// identity (if one exists).
	LocalIdentity *common_go_proto.Identity `protobuf:"bytes,7,opt,name=local_identity,json=localIdentity,proto3" json:"local_identity,omitempty"`
	// The authentication mechanisms that the application wishes to use to
	// authenticate to S2A, ordered by preference. S2A will always use the first
	// authentication mechanism that matches the managed identity.
	AuthenticationMechanisms []*AuthenticationMechanism `protobuf:"bytes,2,rep,name=authentication_mechanisms,json=authenticationMechanisms,proto3" json:"authentication_mechanisms,omitempty"`
	// Types that are assignable to ReqOneof:
	//
	//	*SessionReq_GetTlsConfigurationReq
	//	*SessionReq_OffloadPrivateKeyOperationReq
	//	*SessionReq_OffloadResumptionKeyOperationReq
	//	*SessionReq_ValidatePeerCertificateChainReq
	ReqOneof isSessionReq_ReqOneof `protobuf_oneof:"req_oneof"`
}

func (x *SessionReq) Reset() {
	*x = SessionReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionReq) ProtoMessage() {}

func (x *SessionReq) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionReq.ProtoReflect.Descriptor instead.
func (*SessionReq) Descriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{11}
}

func (x *SessionReq) GetLocalIdentity() *common_go_proto.Identity {
	if x != nil {
		return x.LocalIdentity
	}
	return nil
}

func (x *SessionReq) GetAuthenticationMechanisms() []*AuthenticationMechanism {
	if x != nil {
		return x.AuthenticationMechanisms
	}
	return nil
}

func (m *SessionReq) GetReqOneof() isSessionReq_ReqOneof {
	if m != nil {
		return m.ReqOneof
	}
	return nil
}

func (x *SessionReq) GetGetTlsConfigurationReq() *GetTlsConfigurationReq {
	if x, ok := x.GetReqOneof().(*SessionReq_GetTlsConfigurationReq); ok {
		return x.GetTlsConfigurationReq
	}
	return nil
}

func (x *SessionReq) GetOffloadPrivateKeyOperationReq() *OffloadPrivateKeyOperationReq {
	if x, ok := x.GetReqOneof().(*SessionReq_OffloadPrivateKeyOperationReq); ok {
		return x.OffloadPrivateKeyOperationReq
	}
	return nil
}

func (x *SessionReq) GetOffloadResumptionKeyOperationReq() *OffloadResumptionKeyOperationReq {
	if x, ok := x.GetReqOneof().(*SessionReq_OffloadResumptionKeyOperationReq); ok {
		return x.OffloadResumptionKeyOperationReq
	}
	return nil
}

func (x *SessionReq) GetValidatePeerCertificateChainReq() *ValidatePeerCertificateChainReq {
	if x, ok := x.GetReqOneof().(*SessionReq_ValidatePeerCertificateChainReq); ok {
		return x.ValidatePeerCertificateChainReq
	}
	return nil
}

type isSessionReq_ReqOneof interface {
	isSessionReq_ReqOneof()
}

type SessionReq_GetTlsConfigurationReq struct {
	// Requests the certificate chain and TLS configuration corresponding to the
	// local identity, which the application MUST use to negotiate the TLS
	// handshake.
	GetTlsConfigurationReq *GetTlsConfigurationReq `protobuf:"bytes,3,opt,name=get_tls_configuration_req,json=getTlsConfigurationReq,proto3,oneof"`
}

type SessionReq_OffloadPrivateKeyOperationReq struct {
	// Signs or decrypts the input bytes using a private key corresponding to
	// the local identity in the request.
	//
	// WARNING: More than one OffloadPrivateKeyOperationReq may be sent to the
	// S2Av2 by a server during a TLS 1.2 handshake.
	OffloadPrivateKeyOperationReq *OffloadPrivateKeyOperationReq `protobuf:"bytes,4,opt,name=offload_private_key_operation_req,json=offloadPrivateKeyOperationReq,proto3,oneof"`
}

type SessionReq_OffloadResumptionKeyOperationReq struct {
	// Encrypts or decrypts the input bytes using a resumption key corresponding
	// to the local identity in the request.
	OffloadResumptionKeyOperationReq *OffloadResumptionKeyOperationReq `protobuf:"bytes,5,opt,name=offload_resumption_key_operation_req,json=offloadResumptionKeyOperationReq,proto3,oneof"`
}

type SessionReq_ValidatePeerCertificateChainReq struct {
	// Verifies the peer's certificate chain using
	// (a) trust bundles corresponding to the local identity in the request, and
	// (b) the verification mode in the request.
	ValidatePeerCertificateChainReq *ValidatePeerCertificateChainReq `protobuf:"bytes,6,opt,name=validate_peer_certificate_chain_req,json=validatePeerCertificateChainReq,proto3,oneof"`
}

func (*SessionReq_GetTlsConfigurationReq) isSessionReq_ReqOneof() {}

func (*SessionReq_OffloadPrivateKeyOperationReq) isSessionReq_ReqOneof() {}

func (*SessionReq_OffloadResumptionKeyOperationReq) isSessionReq_ReqOneof() {}

func (*SessionReq_ValidatePeerCertificateChainReq) isSessionReq_ReqOneof() {}

type SessionResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Status of the session response.
	//
	// The status field is populated so that if an error occurs when making an
	// individual request, then communication with the S2A may continue. If an
	// error is returned directly (e.g. at the gRPC layer), then it may result
	// that the bidirectional stream being closed.
	Status *Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Types that are assignable to RespOneof:
	//
	//	*SessionResp_GetTlsConfigurationResp
	//	*SessionResp_OffloadPrivateKeyOperationResp
	//	*SessionResp_OffloadResumptionKeyOperationResp
	//	*SessionResp_ValidatePeerCertificateChainResp
	RespOneof isSessionResp_RespOneof `protobuf_oneof:"resp_oneof"`
}

func (x *SessionResp) Reset() {
	*x = SessionResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionResp) ProtoMessage() {}

func (x *SessionResp) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionResp.ProtoReflect.Descriptor instead.
func (*SessionResp) Descriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{12}
}

func (x *SessionResp) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (m *SessionResp) GetRespOneof() isSessionResp_RespOneof {
	if m != nil {
		return m.RespOneof
	}
	return nil
}

func (x *SessionResp) GetGetTlsConfigurationResp() *GetTlsConfigurationResp {
	if x, ok := x.GetRespOneof().(*SessionResp_GetTlsConfigurationResp); ok {
		return x.GetTlsConfigurationResp
	}
	return nil
}

func (x *SessionResp) GetOffloadPrivateKeyOperationResp() *OffloadPrivateKeyOperationResp {
	if x, ok := x.GetRespOneof().(*SessionResp_OffloadPrivateKeyOperationResp); ok {
		return x.OffloadPrivateKeyOperationResp
	}
	return nil
}

func (x *SessionResp) GetOffloadResumptionKeyOperationResp() *OffloadResumptionKeyOperationResp {
	if x, ok := x.GetRespOneof().(*SessionResp_OffloadResumptionKeyOperationResp); ok {
		return x.OffloadResumptionKeyOperationResp
	}
	return nil
}

func (x *SessionResp) GetValidatePeerCertificateChainResp() *ValidatePeerCertificateChainResp {
	if x, ok := x.GetRespOneof().(*SessionResp_ValidatePeerCertificateChainResp); ok {
		return x.ValidatePeerCertificateChainResp
	}
	return nil
}

type isSessionResp_RespOneof interface {
	isSessionResp_RespOneof()
}

type SessionResp_GetTlsConfigurationResp struct {
	// Contains the certificate chain and TLS configurations corresponding to
	// the local identity.
	GetTlsConfigurationResp *GetTlsConfigurationResp `protobuf:"bytes,2,opt,name=get_tls_configuration_resp,json=getTlsConfigurationResp,proto3,oneof"`
}

type SessionResp_OffloadPrivateKeyOperationResp struct {
	// Contains the signed or encrypted output bytes using the private key
	// corresponding to the local identity.
	OffloadPrivateKeyOperationResp *OffloadPrivateKeyOperationResp `protobuf:"bytes,3,opt,name=offload_private_key_operation_resp,json=offloadPrivateKeyOperationResp,proto3,oneof"`
}

type SessionResp_OffloadResumptionKeyOperationResp struct {
	// Contains the encrypted or decrypted output bytes using the resumption key
	// corresponding to the local identity.
	OffloadResumptionKeyOperationResp *OffloadResumptionKeyOperationResp `protobuf:"bytes,4,opt,name=offload_resumption_key_operation_resp,json=offloadResumptionKeyOperationResp,proto3,oneof"`
}

type SessionResp_ValidatePeerCertificateChainResp struct {
	// Contains the validation result, peer identity and fingerprints of peer
	// certificates.
	ValidatePeerCertificateChainResp *ValidatePeerCertificateChainResp `protobuf:"bytes,5,opt,name=validate_peer_certificate_chain_resp,json=validatePeerCertificateChainResp,proto3,oneof"`
}

func (*SessionResp_GetTlsConfigurationResp) isSessionResp_RespOneof() {}

func (*SessionResp_OffloadPrivateKeyOperationResp) isSessionResp_RespOneof() {}

func (*SessionResp_OffloadResumptionKeyOperationResp) isSessionResp_RespOneof() {}

func (*SessionResp_ValidatePeerCertificateChainResp) isSessionResp_RespOneof() {}

// Next ID: 8
type GetTlsConfigurationResp_ClientTlsConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The certificate chain that the client MUST use for the TLS handshake.
	// It's a list of PEM-encoded certificates, ordered from leaf to root,
	// excluding the root.
	CertificateChain []string `protobuf:"bytes,1,rep,name=certificate_chain,json=certificateChain,proto3" json:"certificate_chain,omitempty"`
	// The minimum TLS version number that the client MUST use for the TLS
	// handshake. If this field is not provided, the client MUST use the default
	// minimum version of the client's TLS library.
	MinTlsVersion common_go_proto.TLSVersion `protobuf:"varint,2,opt,name=min_tls_version,json=minTlsVersion,proto3,enum=s2a.proto.v2.TLSVersion" json:"min_tls_version,omitempty"`
	// The maximum TLS version number that the client MUST use for the TLS
	// handshake. If this field is not provided, the client MUST use the default
	// maximum version of the client's TLS library.
	MaxTlsVersion common_go_proto.TLSVersion `protobuf:"varint,3,opt,name=max_tls_version,json=maxTlsVersion,proto3,enum=s2a.proto.v2.TLSVersion" json:"max_tls_version,omitempty"`
	// The ordered list of TLS 1.0-1.2 ciphersuites that the client MAY offer to
	// negotiate in the TLS handshake.
	Ciphersuites []common_go_proto.Ciphersuite `protobuf:"varint,6,rep,packed,name=ciphersuites,proto3,enum=s2a.proto.v2.Ciphersuite" json:"ciphersuites,omitempty"`
	// The policy that dictates how the client negotiates ALPN during the TLS
	// handshake.
	AlpnPolicy *AlpnPolicy `protobuf:"bytes,7,opt,name=alpn_policy,json=alpnPolicy,proto3" json:"alpn_policy,omitempty"`
}

func (x *GetTlsConfigurationResp_ClientTlsConfiguration) Reset() {
	*x = GetTlsConfigurationResp_ClientTlsConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTlsConfigurationResp_ClientTlsConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTlsConfigurationResp_ClientTlsConfiguration) ProtoMessage() {}

func (x *GetTlsConfigurationResp_ClientTlsConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTlsConfigurationResp_ClientTlsConfiguration.ProtoReflect.Descriptor instead.
func (*GetTlsConfigurationResp_ClientTlsConfiguration) Descriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{4, 0}
}

func (x *GetTlsConfigurationResp_ClientTlsConfiguration) GetCertificateChain() []string {
	if x != nil {
		return x.CertificateChain
	}
	return nil
}

func (x *GetTlsConfigurationResp_ClientTlsConfiguration) GetMinTlsVersion() common_go_proto.TLSVersion {
	if x != nil {
		return x.MinTlsVersion
	}
	return common_go_proto.TLSVersion(0)
}

func (x *GetTlsConfigurationResp_ClientTlsConfiguration) GetMaxTlsVersion() common_go_proto.TLSVersion {
	if x != nil {
		return x.MaxTlsVersion
	}
	return common_go_proto.TLSVersion(0)
}

func (x *GetTlsConfigurationResp_ClientTlsConfiguration) GetCiphersuites() []common_go_proto.Ciphersuite {
	if x != nil {
		return x.Ciphersuites
	}
	return nil
}

func (x *GetTlsConfigurationResp_ClientTlsConfiguration) GetAlpnPolicy() *AlpnPolicy {
	if x != nil {
		return x.AlpnPolicy
	}
	return nil
}

// Next ID: 12
type GetTlsConfigurationResp_ServerTlsConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The certificate chain that the server MUST use for the TLS handshake.
	// It's a list of PEM-encoded certificates, ordered from leaf to root,
	// excluding the root.
	CertificateChain []string `protobuf:"bytes,1,rep,name=certificate_chain,json=certificateChain,proto3" json:"certificate_chain,omitempty"`
	// The minimum TLS version number that the server MUST use for the TLS
	// handshake. If this field is not provided, the server MUST use the default
	// minimum version of the server's TLS library.
	MinTlsVersion common_go_proto.TLSVersion `protobuf:"varint,2,opt,name=min_tls_version,json=minTlsVersion,proto3,enum=s2a.proto.v2.TLSVersion" json:"min_tls_version,omitempty"`
	// The maximum TLS version number that the server MUST use for the TLS
	// handshake. If this field is not provided, the server MUST use the default
	// maximum version of the server's TLS library.
	MaxTlsVersion common_go_proto.TLSVersion `protobuf:"varint,3,opt,name=max_tls_version,json=maxTlsVersion,proto3,enum=s2a.proto.v2.TLSVersion" json:"max_tls_version,omitempty"`
	// The ordered list of TLS 1.0-1.2 ciphersuites that the server MAY offer to
	// negotiate in the TLS handshake.
	Ciphersuites []common_go_proto.Ciphersuite `protobuf:"varint,10,rep,packed,name=ciphersuites,proto3,enum=s2a.proto.v2.Ciphersuite" json:"ciphersuites,omitempty"`
	// Whether to enable TLS resumption.
	TlsResumptionEnabled bool `protobuf:"varint,6,opt,name=tls_resumption_enabled,json=tlsResumptionEnabled,proto3" json:"tls_resumption_enabled,omitempty"`
	// Whether the server MUST request a client certificate (i.e. to negotiate
	// TLS vs. mTLS).
	RequestClientCertificate GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate `protobuf:"varint,7,opt,name=request_client_certificate,json=requestClientCertificate,proto3,enum=s2a.proto.v2.GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate" json:"request_client_certificate,omitempty"`
	// Returns the maximum number of extra bytes that
	// |OffloadResumptionKeyOperation| can add to the number of unencrypted
	// bytes to form the encrypted bytes.
	MaxOverheadOfTicketAead uint32 `protobuf:"varint,9,opt,name=max_overhead_of_ticket_aead,json=maxOverheadOfTicketAead,proto3" json:"max_overhead_of_ticket_aead,omitempty"`
	// The policy that dictates how the server negotiates ALPN during the TLS
	// handshake.
	AlpnPolicy *AlpnPolicy `protobuf:"bytes,11,opt,name=alpn_policy,json=alpnPolicy,proto3" json:"alpn_policy,omitempty"`
}

func (x *GetTlsConfigurationResp_ServerTlsConfiguration) Reset() {
	*x = GetTlsConfigurationResp_ServerTlsConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTlsConfigurationResp_ServerTlsConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTlsConfigurationResp_ServerTlsConfiguration) ProtoMessage() {}

func (x *GetTlsConfigurationResp_ServerTlsConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTlsConfigurationResp_ServerTlsConfiguration.ProtoReflect.Descriptor instead.
func (*GetTlsConfigurationResp_ServerTlsConfiguration) Descriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{4, 1}
}

func (x *GetTlsConfigurationResp_ServerTlsConfiguration) GetCertificateChain() []string {
	if x != nil {
		return x.CertificateChain
	}
	return nil
}

func (x *GetTlsConfigurationResp_ServerTlsConfiguration) GetMinTlsVersion() common_go_proto.TLSVersion {
	if x != nil {
		return x.MinTlsVersion
	}
	return common_go_proto.TLSVersion(0)
}

func (x *GetTlsConfigurationResp_ServerTlsConfiguration) GetMaxTlsVersion() common_go_proto.TLSVersion {
	if x != nil {
		return x.MaxTlsVersion
	}
	return common_go_proto.TLSVersion(0)
}

func (x *GetTlsConfigurationResp_ServerTlsConfiguration) GetCiphersuites() []common_go_proto.Ciphersuite {
	if x != nil {
		return x.Ciphersuites
	}
	return nil
}

func (x *GetTlsConfigurationResp_ServerTlsConfiguration) GetTlsResumptionEnabled() bool {
	if x != nil {
		return x.TlsResumptionEnabled
	}
	return false
}

func (x *GetTlsConfigurationResp_ServerTlsConfiguration) GetRequestClientCertificate() GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate {
	if x != nil {
		return x.RequestClientCertificate
	}
	return GetTlsConfigurationResp_ServerTlsConfiguration_UNSPECIFIED
}

func (x *GetTlsConfigurationResp_ServerTlsConfiguration) GetMaxOverheadOfTicketAead() uint32 {
	if x != nil {
		return x.MaxOverheadOfTicketAead
	}
	return 0
}

func (x *GetTlsConfigurationResp_ServerTlsConfiguration) GetAlpnPolicy() *AlpnPolicy {
	if x != nil {
		return x.AlpnPolicy
	}
	return nil
}

type ValidatePeerCertificateChainReq_ClientPeer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The certificate chain to be verified. The chain MUST be a list of
	// DER-encoded certificates, ordered from leaf to root, excluding the root.
	CertificateChain [][]byte `protobuf:"bytes,1,rep,name=certificate_chain,json=certificateChain,proto3" json:"certificate_chain,omitempty"`
}

func (x *ValidatePeerCertificateChainReq_ClientPeer) Reset() {
	*x = ValidatePeerCertificateChainReq_ClientPeer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidatePeerCertificateChainReq_ClientPeer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidatePeerCertificateChainReq_ClientPeer) ProtoMessage() {}

func (x *ValidatePeerCertificateChainReq_ClientPeer) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidatePeerCertificateChainReq_ClientPeer.ProtoReflect.Descriptor instead.
func (*ValidatePeerCertificateChainReq_ClientPeer) Descriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{9, 0}
}

func (x *ValidatePeerCertificateChainReq_ClientPeer) GetCertificateChain() [][]byte {
	if x != nil {
		return x.CertificateChain
	}
	return nil
}

type ValidatePeerCertificateChainReq_ServerPeer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The certificate chain to be verified. The chain MUST be a list of
	// DER-encoded certificates, ordered from leaf to root, excluding the root.
	CertificateChain [][]byte `protobuf:"bytes,1,rep,name=certificate_chain,json=certificateChain,proto3" json:"certificate_chain,omitempty"`
	// The expected hostname of the server.
	ServerHostname string `protobuf:"bytes,2,opt,name=server_hostname,json=serverHostname,proto3" json:"server_hostname,omitempty"`
	// The UnrestrictedClientPolicy specified by the user.
	SerializedUnrestrictedClientPolicy []byte `protobuf:"bytes,3,opt,name=serialized_unrestricted_client_policy,json=serializedUnrestrictedClientPolicy,proto3" json:"serialized_unrestricted_client_policy,omitempty"`
}

func (x *ValidatePeerCertificateChainReq_ServerPeer) Reset() {
	*x = ValidatePeerCertificateChainReq_ServerPeer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidatePeerCertificateChainReq_ServerPeer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidatePeerCertificateChainReq_ServerPeer) ProtoMessage() {}

func (x *ValidatePeerCertificateChainReq_ServerPeer) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_v2_s2a_s2a_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidatePeerCertificateChainReq_ServerPeer.ProtoReflect.Descriptor instead.
func (*ValidatePeerCertificateChainReq_ServerPeer) Descriptor() ([]byte, []int) {
	return file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP(), []int{9, 1}
}

func (x *ValidatePeerCertificateChainReq_ServerPeer) GetCertificateChain() [][]byte {
	if x != nil {
		return x.CertificateChain
	}
	return nil
}

func (x *ValidatePeerCertificateChainReq_ServerPeer) GetServerHostname() string {
	if x != nil {
		return x.ServerHostname
	}
	return ""
}

func (x *ValidatePeerCertificateChainReq_ServerPeer) GetSerializedUnrestrictedClientPolicy() []byte {
	if x != nil {
		return x.SerializedUnrestrictedClientPolicy
	}
	return nil
}

var File_internal_proto_v2_s2a_s2a_proto protoreflect.FileDescriptor

var file_internal_proto_v2_s2a_s2a_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x76, 0x32, 0x2f, 0x73, 0x32, 0x61, 0x2f, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x0c, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x1a,
	0x25, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x32, 0x61, 0x5f, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x73, 0x32, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x87, 0x01, 0x0a, 0x0a, 0x41, 0x6c, 0x70, 0x6e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x36, 0x0a, 0x17, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x61, 0x6c, 0x70, 0x6e, 0x5f, 0x6e, 0x65, 0x67, 0x6f, 0x74, 0x69, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41,
	0x6c, 0x70, 0x6e, 0x4e, 0x65, 0x67, 0x6f, 0x74, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41,
	0x0a, 0x0e, 0x61, 0x6c, 0x70, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6c, 0x70, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x52, 0x0d, 0x61, 0x6c, 0x70, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x73, 0x22, 0x7e, 0x0a, 0x17, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d, 0x12, 0x32, 0x0a, 0x08,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x12, 0x16, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x42, 0x11, 0x0a, 0x0f, 0x6d, 0x65, 0x63, 0x68,
	0x61, 0x6e, 0x69, 0x73, 0x6d, 0x5f, 0x6f, 0x6e, 0x65, 0x6f, 0x66, 0x4a, 0x04, 0x08, 0x01, 0x10,
	0x02, 0x22, 0x36, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x71, 0x0a, 0x16, 0x47, 0x65, 0x74,
	0x54, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x12, 0x45, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x69, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x73,
	0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x64, 0x65, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x64, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x6e,
	0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x73, 0x6e, 0x69, 0x22, 0xf1, 0x0b, 0x0a,
	0x17, 0x47, 0x65, 0x74, 0x54, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x12, 0x78, 0x0a, 0x18, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x5f, 0x74, 0x6c, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x73, 0x32, 0x61,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x6c, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x54, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x16, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x54, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x78, 0x0a, 0x18, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x74, 0x6c, 0x73,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x54, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x16, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x6c, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xcf, 0x02, 0x0a,
	0x16, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x54, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x11, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x10, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43,
	0x68, 0x61, 0x69, 0x6e, 0x12, 0x40, 0x0a, 0x0f, 0x6d, 0x69, 0x6e, 0x5f, 0x74, 0x6c, 0x73, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x18, 0x2e,
	0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x4c, 0x53,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x6d, 0x69, 0x6e, 0x54, 0x6c, 0x73, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x6c,
	0x73, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x18, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x54,
	0x4c, 0x53, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x54, 0x6c,
	0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x0c, 0x63, 0x69, 0x70, 0x68,
	0x65, 0x72, 0x73, 0x75, 0x69, 0x74, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x19,
	0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x69,
	0x70, 0x68, 0x65, 0x72, 0x73, 0x75, 0x69, 0x74, 0x65, 0x52, 0x0c, 0x63, 0x69, 0x70, 0x68, 0x65,
	0x72, 0x73, 0x75, 0x69, 0x74, 0x65, 0x73, 0x12, 0x39, 0x0a, 0x0b, 0x61, 0x6c, 0x70, 0x6e, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x73,
	0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6c, 0x70, 0x6e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0a, 0x61, 0x6c, 0x70, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x4a, 0x04, 0x08, 0x05, 0x10, 0x06, 0x1a, 0xfa,
	0x06, 0x0a, 0x16, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x11, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x12, 0x40, 0x0a, 0x0f, 0x6d, 0x69, 0x6e, 0x5f, 0x74, 0x6c,
	0x73, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x18, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x54,
	0x4c, 0x53, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x6d, 0x69, 0x6e, 0x54, 0x6c,
	0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f,
	0x74, 0x6c, 0x73, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x18, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32,
	0x2e, 0x54, 0x4c, 0x53, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x6d, 0x61, 0x78,
	0x54, 0x6c, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x0c, 0x63, 0x69,
	0x70, 0x68, 0x65, 0x72, 0x73, 0x75, 0x69, 0x74, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x19, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e,
	0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x73, 0x75, 0x69, 0x74, 0x65, 0x52, 0x0c, 0x63, 0x69, 0x70,
	0x68, 0x65, 0x72, 0x73, 0x75, 0x69, 0x74, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x74, 0x6c, 0x73,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x74, 0x6c, 0x73, 0x52, 0x65,
	0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12,
	0x93, 0x01, 0x0a, 0x1a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x55, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x54, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x18, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x3c, 0x0a, 0x1b, 0x6d, 0x61, 0x78, 0x5f, 0x6f, 0x76, 0x65,
	0x72, 0x68, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x66, 0x5f, 0x74, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x5f,
	0x61, 0x65, 0x61, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x17, 0x6d, 0x61, 0x78, 0x4f,
	0x76, 0x65, 0x72, 0x68, 0x65, 0x61, 0x64, 0x4f, 0x66, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x41,
	0x65, 0x61, 0x64, 0x12, 0x39, 0x0a, 0x0b, 0x61, 0x6c, 0x70, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6c, 0x70, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x0a, 0x61, 0x6c, 0x70, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x9e,
	0x02, 0x0a, 0x18, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x23, 0x0a, 0x1f,
	0x44, 0x4f, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x43, 0x4c, 0x49,
	0x45, 0x4e, 0x54, 0x5f, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x10,
	0x01, 0x12, 0x2e, 0x0a, 0x2a, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x43, 0x4c, 0x49,
	0x45, 0x4e, 0x54, 0x5f, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f,
	0x42, 0x55, 0x54, 0x5f, 0x44, 0x4f, 0x4e, 0x54, 0x5f, 0x56, 0x45, 0x52, 0x49, 0x46, 0x59, 0x10,
	0x02, 0x12, 0x29, 0x0a, 0x25, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x43, 0x4c, 0x49,
	0x45, 0x4e, 0x54, 0x5f, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f,
	0x41, 0x4e, 0x44, 0x5f, 0x56, 0x45, 0x52, 0x49, 0x46, 0x59, 0x10, 0x03, 0x12, 0x3a, 0x0a, 0x36,
	0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x52, 0x45, 0x51, 0x55,
	0x49, 0x52, 0x45, 0x5f, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x45, 0x52, 0x54, 0x49,
	0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x42, 0x55, 0x54, 0x5f, 0x44, 0x4f, 0x4e, 0x54, 0x5f,
	0x56, 0x45, 0x52, 0x49, 0x46, 0x59, 0x10, 0x04, 0x12, 0x35, 0x0a, 0x31, 0x52, 0x45, 0x51, 0x55,
	0x45, 0x53, 0x54, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x5f,
	0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41,
	0x54, 0x45, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x56, 0x45, 0x52, 0x49, 0x46, 0x59, 0x10, 0x05, 0x4a,
	0x04, 0x08, 0x04, 0x10, 0x05, 0x4a, 0x04, 0x08, 0x05, 0x10, 0x06, 0x42, 0x13, 0x0a, 0x11, 0x74,
	0x6c, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xb0, 0x03, 0x0a, 0x1d, 0x4f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x12, 0x5d, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x51, 0x0a, 0x13, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x61,
	0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20,
	0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x69,
	0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d,
	0x52, 0x12, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x6c, 0x67, 0x6f, 0x72,
	0x69, 0x74, 0x68, 0x6d, 0x12, 0x1d, 0x0a, 0x09, 0x72, 0x61, 0x77, 0x5f, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x08, 0x72, 0x61, 0x77, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0d, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x5f, 0x64, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x68,
	0x61, 0x32, 0x35, 0x36, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x0d, 0x73, 0x68,
	0x61, 0x33, 0x38, 0x34, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0c, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x68, 0x61, 0x33, 0x38, 0x34, 0x44, 0x69, 0x67, 0x65, 0x73,
	0x74, 0x12, 0x25, 0x0a, 0x0d, 0x73, 0x68, 0x61, 0x35, 0x31, 0x32, 0x5f, 0x64, 0x69, 0x67, 0x65,
	0x73, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x68, 0x61, 0x35,
	0x31, 0x32, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x22, 0x3d, 0x0a, 0x13, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x08, 0x0a, 0x04, 0x53, 0x49, 0x47, 0x4e, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45,
	0x43, 0x52, 0x59, 0x50, 0x54, 0x10, 0x02, 0x42, 0x0a, 0x0a, 0x08, 0x69, 0x6e, 0x5f, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x22, 0x3d, 0x0a, 0x1e, 0x4f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x12, 0x1b, 0x0a, 0x09, 0x6f, 0x75, 0x74, 0x5f, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6f, 0x75, 0x74, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x22, 0xe7, 0x01, 0x0a, 0x20, 0x4f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65,
	0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x12, 0x63, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x73, 0x32, 0x61,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x66, 0x66, 0x6c, 0x6f, 0x61,
	0x64, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6d,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08,
	0x69, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07,
	0x69, 0x6e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x43, 0x0a, 0x16, 0x52, 0x65, 0x73, 0x75, 0x6d,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x44, 0x45, 0x43, 0x52, 0x59, 0x50, 0x54, 0x10, 0x02, 0x22, 0x40, 0x0a, 0x21,
	0x4f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x12, 0x1b, 0x0a, 0x09, 0x6f, 0x75, 0x74, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6f, 0x75, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x9d,
	0x06, 0x0a, 0x1f, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x50, 0x65, 0x65, 0x72, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x52,
	0x65, 0x71, 0x12, 0x52, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3e, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e,
	0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x50, 0x65, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x2e,
	0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65,
	0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x5b, 0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x5f, 0x70, 0x65, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x73, 0x32,
	0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x65, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x50, 0x65, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x50,
	0x65, 0x65, 0x72, 0x12, 0x5b, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x70, 0x65,
	0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x50, 0x65, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43,
	0x68, 0x61, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x50, 0x65,
	0x65, 0x72, 0x48, 0x00, 0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x50, 0x65, 0x65, 0x72,
	0x1a, 0x39, 0x0a, 0x0a, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x50, 0x65, 0x65, 0x72, 0x12, 0x2b,
	0x0a, 0x11, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x68,
	0x61, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x10, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x1a, 0xb5, 0x01, 0x0a, 0x0a,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x50, 0x65, 0x65, 0x72, 0x12, 0x2b, 0x0a, 0x11, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x10, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x48, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x51, 0x0a, 0x25, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x75,
	0x6e, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x22, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x55, 0x6e, 0x72, 0x65, 0x73,
	0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x22, 0xea, 0x01, 0x0a, 0x10, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x50, 0x49,
	0x46, 0x46, 0x45, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54,
	0x5f, 0x54, 0x4f, 0x5f, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x27, 0x0a, 0x23,
	0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x45, 0x44, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f,
	0x56, 0x45, 0x52, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44,
	0x45, 0x5f, 0x33, 0x10, 0x03, 0x12, 0x27, 0x0a, 0x23, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x45,
	0x44, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f, 0x56, 0x45, 0x52, 0x49, 0x46, 0x49, 0x43,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x34, 0x10, 0x04, 0x12, 0x27,
	0x0a, 0x23, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x45, 0x44, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f,
	0x4d, 0x5f, 0x56, 0x45, 0x52, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d,
	0x4f, 0x44, 0x45, 0x5f, 0x35, 0x10, 0x05, 0x12, 0x27, 0x0a, 0x23, 0x52, 0x45, 0x53, 0x45, 0x52,
	0x56, 0x45, 0x44, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f, 0x56, 0x45, 0x52, 0x49, 0x46,
	0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x36, 0x10, 0x06,
	0x42, 0x0c, 0x0a, 0x0a, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x6f, 0x6e, 0x65, 0x6f, 0x66, 0x22, 0xb2,
	0x02, 0x0a, 0x20, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x50, 0x65, 0x65, 0x72, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x12, 0x6c, 0x0a, 0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f,
	0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x50, 0x65, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x2e, 0x56,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x10, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x2d, 0x0a, 0x12, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x32, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x18, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x32, 0x41, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x07, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x22, 0x3d, 0x0a, 0x10, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x43,
	0x43, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52,
	0x45, 0x10, 0x02, 0x22, 0xa0, 0x05, 0x0a, 0x0a, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x12, 0x3d, 0x0a, 0x0e, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x73, 0x32, 0x61,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x52, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x12, 0x62, 0x0a, 0x19, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x76, 0x32, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d, 0x52, 0x18, 0x61, 0x75, 0x74,
	0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x63, 0x68, 0x61,
	0x6e, 0x69, 0x73, 0x6d, 0x73, 0x12, 0x61, 0x0a, 0x19, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x6c, 0x73,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x71, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x6c, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x48, 0x00,
	0x52, 0x16, 0x67, 0x65, 0x74, 0x54, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x12, 0x77, 0x0a, 0x21, 0x6f, 0x66, 0x66, 0x6c,
	0x6f, 0x61, 0x64, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x76, 0x32, 0x2e, 0x4f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x4b, 0x65, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x48, 0x00, 0x52, 0x1d, 0x6f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x4b, 0x65, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x12, 0x80, 0x01, 0x0a, 0x24, 0x6f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e,
	0x4f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x48, 0x00, 0x52, 0x20, 0x6f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6d,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x12, 0x7d, 0x0a, 0x23, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x5f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32,
	0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x50, 0x65, 0x65, 0x72, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x52, 0x65, 0x71,
	0x48, 0x00, 0x52, 0x1f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x50, 0x65, 0x65, 0x72,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x69, 0x6e,
	0x52, 0x65, 0x71, 0x42, 0x0b, 0x0a, 0x09, 0x72, 0x65, 0x71, 0x5f, 0x6f, 0x6e, 0x65, 0x6f, 0x66,
	0x4a, 0x04, 0x08, 0x01, 0x10, 0x02, 0x22, 0xb4, 0x04, 0x0a, 0x0b, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x12, 0x2c, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x64, 0x0a, 0x1a, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x6c, 0x73, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x73, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x6c, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x48,
	0x00, 0x52, 0x17, 0x67, 0x65, 0x74, 0x54, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x12, 0x7a, 0x0a, 0x22, 0x6f, 0x66,
	0x66, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65,
	0x79, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x70,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x48, 0x00, 0x52, 0x1e, 0x6f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x50,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x12, 0x83, 0x01, 0x0a, 0x25, 0x6f, 0x66, 0x66, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65,
	0x79, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x70,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73,
	0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x48, 0x00, 0x52, 0x21, 0x6f, 0x66, 0x66, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x12, 0x80, 0x01, 0x0a,
	0x24, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x69, 0x6e,
	0x5f, 0x72, 0x65, 0x73, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x73, 0x32,
	0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x65, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x48, 0x00, 0x52, 0x20, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x50, 0x65, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x42,
	0x0c, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x70, 0x5f, 0x6f, 0x6e, 0x65, 0x6f, 0x66, 0x2a, 0xa2, 0x03,
	0x0a, 0x12, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x6c, 0x67, 0x6f, 0x72,
	0x69, 0x74, 0x68, 0x6d, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x32, 0x41, 0x5f, 0x53, 0x53, 0x4c, 0x5f,
	0x53, 0x49, 0x47, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d, 0x53, 0x32, 0x41, 0x5f, 0x53, 0x53, 0x4c, 0x5f, 0x53, 0x49,
	0x47, 0x4e, 0x5f, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x4b, 0x43, 0x53, 0x31, 0x5f, 0x53, 0x48, 0x41,
	0x32, 0x35, 0x36, 0x10, 0x01, 0x12, 0x21, 0x0a, 0x1d, 0x53, 0x32, 0x41, 0x5f, 0x53, 0x53, 0x4c,
	0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x4b, 0x43, 0x53, 0x31, 0x5f,
	0x53, 0x48, 0x41, 0x33, 0x38, 0x34, 0x10, 0x02, 0x12, 0x21, 0x0a, 0x1d, 0x53, 0x32, 0x41, 0x5f,
	0x53, 0x53, 0x4c, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x4b, 0x43,
	0x53, 0x31, 0x5f, 0x53, 0x48, 0x41, 0x35, 0x31, 0x32, 0x10, 0x03, 0x12, 0x27, 0x0a, 0x23, 0x53,
	0x32, 0x41, 0x5f, 0x53, 0x53, 0x4c, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x45, 0x43, 0x44, 0x53,
	0x41, 0x5f, 0x53, 0x45, 0x43, 0x50, 0x32, 0x35, 0x36, 0x52, 0x31, 0x5f, 0x53, 0x48, 0x41, 0x32,
	0x35, 0x36, 0x10, 0x04, 0x12, 0x27, 0x0a, 0x23, 0x53, 0x32, 0x41, 0x5f, 0x53, 0x53, 0x4c, 0x5f,
	0x53, 0x49, 0x47, 0x4e, 0x5f, 0x45, 0x43, 0x44, 0x53, 0x41, 0x5f, 0x53, 0x45, 0x43, 0x50, 0x33,
	0x38, 0x34, 0x52, 0x31, 0x5f, 0x53, 0x48, 0x41, 0x33, 0x38, 0x34, 0x10, 0x05, 0x12, 0x27, 0x0a,
	0x23, 0x53, 0x32, 0x41, 0x5f, 0x53, 0x53, 0x4c, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x45, 0x43,
	0x44, 0x53, 0x41, 0x5f, 0x53, 0x45, 0x43, 0x50, 0x35, 0x32, 0x31, 0x52, 0x31, 0x5f, 0x53, 0x48,
	0x41, 0x35, 0x31, 0x32, 0x10, 0x06, 0x12, 0x24, 0x0a, 0x20, 0x53, 0x32, 0x41, 0x5f, 0x53, 0x53,
	0x4c, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x53, 0x53, 0x5f, 0x52,
	0x53, 0x41, 0x45, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x07, 0x12, 0x24, 0x0a, 0x20,
	0x53, 0x32, 0x41, 0x5f, 0x53, 0x53, 0x4c, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x52, 0x53, 0x41,
	0x5f, 0x50, 0x53, 0x53, 0x5f, 0x52, 0x53, 0x41, 0x45, 0x5f, 0x53, 0x48, 0x41, 0x33, 0x38, 0x34,
	0x10, 0x08, 0x12, 0x24, 0x0a, 0x20, 0x53, 0x32, 0x41, 0x5f, 0x53, 0x53, 0x4c, 0x5f, 0x53, 0x49,
	0x47, 0x4e, 0x5f, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x53, 0x53, 0x5f, 0x52, 0x53, 0x41, 0x45, 0x5f,
	0x53, 0x48, 0x41, 0x35, 0x31, 0x32, 0x10, 0x09, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x32, 0x41, 0x5f,
	0x53, 0x53, 0x4c, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x45, 0x44, 0x32, 0x35, 0x35, 0x31, 0x39,
	0x10, 0x0a, 0x32, 0x57, 0x0a, 0x0a, 0x53, 0x32, 0x41, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x49, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x55, 0x70, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x18, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x1a, 0x19, 0x2e, 0x73, 0x32, 0x61,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x42, 0x36, 0x5a, 0x34, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x73, 0x32, 0x61, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x32, 0x61, 0x5f, 0x67, 0x6f, 0x5f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_internal_proto_v2_s2a_s2a_proto_rawDescOnce sync.Once
	file_internal_proto_v2_s2a_s2a_proto_rawDescData = file_internal_proto_v2_s2a_s2a_proto_rawDesc
)

func file_internal_proto_v2_s2a_s2a_proto_rawDescGZIP() []byte {
	file_internal_proto_v2_s2a_s2a_proto_rawDescOnce.Do(func() {
		file_internal_proto_v2_s2a_s2a_proto_rawDescData = protoimpl.X.CompressGZIP(file_internal_proto_v2_s2a_s2a_proto_rawDescData)
	})
	return file_internal_proto_v2_s2a_s2a_proto_rawDescData
}

var file_internal_proto_v2_s2a_s2a_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_internal_proto_v2_s2a_s2a_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_internal_proto_v2_s2a_s2a_proto_goTypes = []any{
	(SignatureAlgorithm)(0), // 0: s2a.proto.v2.SignatureAlgorithm
	(GetTlsConfigurationResp_ServerTlsConfiguration_RequestClientCertificate)(0), // 1: s2a.proto.v2.GetTlsConfigurationResp.ServerTlsConfiguration.RequestClientCertificate
	(OffloadPrivateKeyOperationReq_PrivateKeyOperation)(0),                       // 2: s2a.proto.v2.OffloadPrivateKeyOperationReq.PrivateKeyOperation
	(OffloadResumptionKeyOperationReq_ResumptionKeyOperation)(0),                 // 3: s2a.proto.v2.OffloadResumptionKeyOperationReq.ResumptionKeyOperation
	(ValidatePeerCertificateChainReq_VerificationMode)(0),                        // 4: s2a.proto.v2.ValidatePeerCertificateChainReq.VerificationMode
	(ValidatePeerCertificateChainResp_ValidationResult)(0),                       // 5: s2a.proto.v2.ValidatePeerCertificateChainResp.ValidationResult
	(*AlpnPolicy)(nil),                                     // 6: s2a.proto.v2.AlpnPolicy
	(*AuthenticationMechanism)(nil),                        // 7: s2a.proto.v2.AuthenticationMechanism
	(*Status)(nil),                                         // 8: s2a.proto.v2.Status
	(*GetTlsConfigurationReq)(nil),                         // 9: s2a.proto.v2.GetTlsConfigurationReq
	(*GetTlsConfigurationResp)(nil),                        // 10: s2a.proto.v2.GetTlsConfigurationResp
	(*OffloadPrivateKeyOperationReq)(nil),                  // 11: s2a.proto.v2.OffloadPrivateKeyOperationReq
	(*OffloadPrivateKeyOperationResp)(nil),                 // 12: s2a.proto.v2.OffloadPrivateKeyOperationResp
	(*OffloadResumptionKeyOperationReq)(nil),               // 13: s2a.proto.v2.OffloadResumptionKeyOperationReq
	(*OffloadResumptionKeyOperationResp)(nil),              // 14: s2a.proto.v2.OffloadResumptionKeyOperationResp
	(*ValidatePeerCertificateChainReq)(nil),                // 15: s2a.proto.v2.ValidatePeerCertificateChainReq
	(*ValidatePeerCertificateChainResp)(nil),               // 16: s2a.proto.v2.ValidatePeerCertificateChainResp
	(*SessionReq)(nil),                                     // 17: s2a.proto.v2.SessionReq
	(*SessionResp)(nil),                                    // 18: s2a.proto.v2.SessionResp
	(*GetTlsConfigurationResp_ClientTlsConfiguration)(nil), // 19: s2a.proto.v2.GetTlsConfigurationResp.ClientTlsConfiguration
	(*GetTlsConfigurationResp_ServerTlsConfiguration)(nil), // 20: s2a.proto.v2.GetTlsConfigurationResp.ServerTlsConfiguration
	(*ValidatePeerCertificateChainReq_ClientPeer)(nil),     // 21: s2a.proto.v2.ValidatePeerCertificateChainReq.ClientPeer
	(*ValidatePeerCertificateChainReq_ServerPeer)(nil),     // 22: s2a.proto.v2.ValidatePeerCertificateChainReq.ServerPeer
	(common_go_proto.AlpnProtocol)(0),                      // 23: s2a.proto.v2.AlpnProtocol
	(*common_go_proto.Identity)(nil),                       // 24: s2a.proto.v2.Identity
	(common_go_proto.ConnectionSide)(0),                    // 25: s2a.proto.v2.ConnectionSide
	(*s2a_context_go_proto.S2AContext)(nil),                // 26: s2a.proto.v2.S2AContext
	(common_go_proto.TLSVersion)(0),                        // 27: s2a.proto.v2.TLSVersion
	(common_go_proto.Ciphersuite)(0),                       // 28: s2a.proto.v2.Ciphersuite
}
var file_internal_proto_v2_s2a_s2a_proto_depIdxs = []int32{
	23, // 0: s2a.proto.v2.AlpnPolicy.alpn_protocols:type_name -> s2a.proto.v2.AlpnProtocol
	24, // 1: s2a.proto.v2.AuthenticationMechanism.identity:type_name -> s2a.proto.v2.Identity
	25, // 2: s2a.proto.v2.GetTlsConfigurationReq.connection_side:type_name -> s2a.proto.v2.ConnectionSide
	19, // 3: s2a.proto.v2.GetTlsConfigurationResp.client_tls_configuration:type_name -> s2a.proto.v2.GetTlsConfigurationResp.ClientTlsConfiguration
	20, // 4: s2a.proto.v2.GetTlsConfigurationResp.server_tls_configuration:type_name -> s2a.proto.v2.GetTlsConfigurationResp.ServerTlsConfiguration
	2,  // 5: s2a.proto.v2.OffloadPrivateKeyOperationReq.operation:type_name -> s2a.proto.v2.OffloadPrivateKeyOperationReq.PrivateKeyOperation
	0,  // 6: s2a.proto.v2.OffloadPrivateKeyOperationReq.signature_algorithm:type_name -> s2a.proto.v2.SignatureAlgorithm
	3,  // 7: s2a.proto.v2.OffloadResumptionKeyOperationReq.operation:type_name -> s2a.proto.v2.OffloadResumptionKeyOperationReq.ResumptionKeyOperation
	4,  // 8: s2a.proto.v2.ValidatePeerCertificateChainReq.mode:type_name -> s2a.proto.v2.ValidatePeerCertificateChainReq.VerificationMode
	21, // 9: s2a.proto.v2.ValidatePeerCertificateChainReq.client_peer:type_name -> s2a.proto.v2.ValidatePeerCertificateChainReq.ClientPeer
	22, // 10: s2a.proto.v2.ValidatePeerCertificateChainReq.server_peer:type_name -> s2a.proto.v2.ValidatePeerCertificateChainReq.ServerPeer
	5,  // 11: s2a.proto.v2.ValidatePeerCertificateChainResp.validation_result:type_name -> s2a.proto.v2.ValidatePeerCertificateChainResp.ValidationResult
	26, // 12: s2a.proto.v2.ValidatePeerCertificateChainResp.context:type_name -> s2a.proto.v2.S2AContext
	24, // 13: s2a.proto.v2.SessionReq.local_identity:type_name -> s2a.proto.v2.Identity
	7,  // 14: s2a.proto.v2.SessionReq.authentication_mechanisms:type_name -> s2a.proto.v2.AuthenticationMechanism
	9,  // 15: s2a.proto.v2.SessionReq.get_tls_configuration_req:type_name -> s2a.proto.v2.GetTlsConfigurationReq
	11, // 16: s2a.proto.v2.SessionReq.offload_private_key_operation_req:type_name -> s2a.proto.v2.OffloadPrivateKeyOperationReq
	13, // 17: s2a.proto.v2.SessionReq.offload_resumption_key_operation_req:type_name -> s2a.proto.v2.OffloadResumptionKeyOperationReq
	15, // 18: s2a.proto.v2.SessionReq.validate_peer_certificate_chain_req:type_name -> s2a.proto.v2.ValidatePeerCertificateChainReq
	8,  // 19: s2a.proto.v2.SessionResp.status:type_name -> s2a.proto.v2.Status
	10, // 20: s2a.proto.v2.SessionResp.get_tls_configuration_resp:type_name -> s2a.proto.v2.GetTlsConfigurationResp
	12, // 21: s2a.proto.v2.SessionResp.offload_private_key_operation_resp:type_name -> s2a.proto.v2.OffloadPrivateKeyOperationResp
	14, // 22: s2a.proto.v2.SessionResp.offload_resumption_key_operation_resp:type_name -> s2a.proto.v2.OffloadResumptionKeyOperationResp
	16, // 23: s2a.proto.v2.SessionResp.validate_peer_certificate_chain_resp:type_name -> s2a.proto.v2.ValidatePeerCertificateChainResp
	27, // 24: s2a.proto.v2.GetTlsConfigurationResp.ClientTlsConfiguration.min_tls_version:type_name -> s2a.proto.v2.TLSVersion
	27, // 25: s2a.proto.v2.GetTlsConfigurationResp.ClientTlsConfiguration.max_tls_version:type_name -> s2a.proto.v2.TLSVersion
	28, // 26: s2a.proto.v2.GetTlsConfigurationResp.ClientTlsConfiguration.ciphersuites:type_name -> s2a.proto.v2.Ciphersuite
	6,  // 27: s2a.proto.v2.GetTlsConfigurationResp.ClientTlsConfiguration.alpn_policy:type_name -> s2a.proto.v2.AlpnPolicy
	27, // 28: s2a.proto.v2.GetTlsConfigurationResp.ServerTlsConfiguration.min_tls_version:type_name -> s2a.proto.v2.TLSVersion
	27, // 29: s2a.proto.v2.GetTlsConfigurationResp.ServerTlsConfiguration.max_tls_version:type_name -> s2a.proto.v2.TLSVersion
	28, // 30: s2a.proto.v2.GetTlsConfigurationResp.ServerTlsConfiguration.ciphersuites:type_name -> s2a.proto.v2.Ciphersuite
	1,  // 31: s2a.proto.v2.GetTlsConfigurationResp.ServerTlsConfiguration.request_client_certificate:type_name -> s2a.proto.v2.GetTlsConfigurationResp.ServerTlsConfiguration.RequestClientCertificate
	6,  // 32: s2a.proto.v2.GetTlsConfigurationResp.ServerTlsConfiguration.alpn_policy:type_name -> s2a.proto.v2.AlpnPolicy
	17, // 33: s2a.proto.v2.S2AService.SetUpSession:input_type -> s2a.proto.v2.SessionReq
	18, // 34: s2a.proto.v2.S2AService.SetUpSession:output_type -> s2a.proto.v2.SessionResp
	34, // [34:35] is the sub-list for method output_type
	33, // [33:34] is the sub-list for method input_type
	33, // [33:33] is the sub-list for extension type_name
	33, // [33:33] is the sub-list for extension extendee
	0,  // [0:33] is the sub-list for field type_name
}

func init() { file_internal_proto_v2_s2a_s2a_proto_init() }
func file_internal_proto_v2_s2a_s2a_proto_init() {
	if File_internal_proto_v2_s2a_s2a_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_internal_proto_v2_s2a_s2a_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*AlpnPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_v2_s2a_s2a_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*AuthenticationMechanism); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_v2_s2a_s2a_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*Status); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_v2_s2a_s2a_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*GetTlsConfigurationReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_v2_s2a_s2a_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*GetTlsConfigurationResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_v2_s2a_s2a_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*OffloadPrivateKeyOperationReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_v2_s2a_s2a_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*OffloadPrivateKeyOperationResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_v2_s2a_s2a_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*OffloadResumptionKeyOperationReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_v2_s2a_s2a_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*OffloadResumptionKeyOperationResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_v2_s2a_s2a_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*ValidatePeerCertificateChainReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_v2_s2a_s2a_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*ValidatePeerCertificateChainResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_v2_s2a_s2a_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*SessionReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_v2_s2a_s2a_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*SessionResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_v2_s2a_s2a_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*GetTlsConfigurationResp_ClientTlsConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_v2_s2a_s2a_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*GetTlsConfigurationResp_ServerTlsConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_v2_s2a_s2a_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*ValidatePeerCertificateChainReq_ClientPeer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_v2_s2a_s2a_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*ValidatePeerCertificateChainReq_ServerPeer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_internal_proto_v2_s2a_s2a_proto_msgTypes[1].OneofWrappers = []any{
		(*AuthenticationMechanism_Token)(nil),
	}
	file_internal_proto_v2_s2a_s2a_proto_msgTypes[4].OneofWrappers = []any{
		(*GetTlsConfigurationResp_ClientTlsConfiguration_)(nil),
		(*GetTlsConfigurationResp_ServerTlsConfiguration_)(nil),
	}
	file_internal_proto_v2_s2a_s2a_proto_msgTypes[5].OneofWrappers = []any{
		(*OffloadPrivateKeyOperationReq_RawBytes)(nil),
		(*OffloadPrivateKeyOperationReq_Sha256Digest)(nil),
		(*OffloadPrivateKeyOperationReq_Sha384Digest)(nil),
		(*OffloadPrivateKeyOperationReq_Sha512Digest)(nil),
	}
	file_internal_proto_v2_s2a_s2a_proto_msgTypes[9].OneofWrappers = []any{
		(*ValidatePeerCertificateChainReq_ClientPeer_)(nil),
		(*ValidatePeerCertificateChainReq_ServerPeer_)(nil),
	}
	file_internal_proto_v2_s2a_s2a_proto_msgTypes[11].OneofWrappers = []any{
		(*SessionReq_GetTlsConfigurationReq)(nil),
		(*SessionReq_OffloadPrivateKeyOperationReq)(nil),
		(*SessionReq_OffloadResumptionKeyOperationReq)(nil),
		(*SessionReq_ValidatePeerCertificateChainReq)(nil),
	}
	file_internal_proto_v2_s2a_s2a_proto_msgTypes[12].OneofWrappers = []any{
		(*SessionResp_GetTlsConfigurationResp)(nil),
		(*SessionResp_OffloadPrivateKeyOperationResp)(nil),
		(*SessionResp_OffloadResumptionKeyOperationResp)(nil),
		(*SessionResp_ValidatePeerCertificateChainResp)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_internal_proto_v2_s2a_s2a_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_internal_proto_v2_s2a_s2a_proto_goTypes,
		DependencyIndexes: file_internal_proto_v2_s2a_s2a_proto_depIdxs,
		EnumInfos:         file_internal_proto_v2_s2a_s2a_proto_enumTypes,
		MessageInfos:      file_internal_proto_v2_s2a_s2a_proto_msgTypes,
	}.Build()
	File_internal_proto_v2_s2a_s2a_proto = out.File
	file_internal_proto_v2_s2a_s2a_proto_rawDesc = nil
	file_internal_proto_v2_s2a_s2a_proto_goTypes = nil
	file_internal_proto_v2_s2a_s2a_proto_depIdxs = nil
}
