import _typeof from "@babel/runtime-corejs3/helpers/typeof";
import _toConsumableArray from "@babel/runtime-corejs3/helpers/toConsumableArray";
import _classCallCheck from "@babel/runtime-corejs3/helpers/classCallCheck";
import _createClass from "@babel/runtime-corejs3/helpers/createClass";
import _assertThisInitialized from "@babel/runtime-corejs3/helpers/assertThisInitialized";
import _inherits from "@babel/runtime-corejs3/helpers/inherits";
import _createSuper from "@babel/runtime-corejs3/helpers/createSuper";
import _defineProperty from "@babel/runtime-corejs3/helpers/defineProperty";
import _concatInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/concat";
import _includesInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/includes";
import _filterInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/filter";
import _JSON$stringify from "@babel/runtime-corejs3/core-js-stable/json/stringify";
import React from "react";
import PropTypes from "prop-types";
import swaggerUIConstructor from "./swagger-ui-es-bundle-core";
var SwaggerUI = /*#__PURE__*/function (_React$Component) {
  _inherits(SwaggerUI, _React$Component);
  var _super = _createSuper(SwaggerUI);
  function SwaggerUI(props) {
    var _this;
    _classCallCheck(this, SwaggerUI);
    _this = _super.call(this, props);
    _defineProperty(_assertThisInitialized(_this), "requestInterceptor", function (req) {
      if (typeof _this.props.requestInterceptor === "function") {
        return _this.props.requestInterceptor(req);
      }
      return req;
    });
    _defineProperty(_assertThisInitialized(_this), "responseInterceptor", function (res) {
      if (typeof _this.props.responseInterceptor === "function") {
        return _this.props.responseInterceptor(res);
      }
      return res;
    });
    _defineProperty(_assertThisInitialized(_this), "onComplete", function () {
      if (typeof _this.props.onComplete === "function") {
        return _this.props.onComplete(_this.system);
      }
    });
    _this.SwaggerUIComponent = null;
    _this.system = null;
    return _this;
  }
  _createClass(SwaggerUI, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _context, _context2;
      var ui = swaggerUIConstructor({
        plugins: this.props.plugins,
        spec: this.props.spec,
        url: this.props.url,
        layout: this.props.layout,
        defaultModelsExpandDepth: this.props.defaultModelsExpandDepth,
        defaultModelRendering: this.props.defaultModelRendering,
        presets: _concatInstanceProperty(_context = [swaggerUIConstructor.presets.apis]).call(_context, _toConsumableArray(this.props.presets)),
        requestInterceptor: this.requestInterceptor,
        responseInterceptor: this.responseInterceptor,
        onComplete: this.onComplete,
        docExpansion: this.props.docExpansion,
        supportedSubmitMethods: this.props.supportedSubmitMethods,
        queryConfigEnabled: this.props.queryConfigEnabled,
        defaultModelExpandDepth: this.props.defaultModelExpandDepth,
        displayOperationId: this.props.displayOperationId,
        tryItOutEnabled: this.props.tryItOutEnabled,
        displayRequestDuration: this.props.displayRequestDuration,
        requestSnippetsEnabled: this.props.requestSnippetsEnabled,
        requestSnippets: this.props.requestSnippets,
        showMutatedRequest: typeof this.props.showMutatedRequest === "boolean" ? this.props.showMutatedRequest : true,
        deepLinking: typeof this.props.deepLinking === "boolean" ? this.props.deepLinking : false,
        showExtensions: this.props.showExtensions,
        showCommonExtensions: this.props.showCommonExtensions,
        filter: _includesInstanceProperty(_context2 = ["boolean", "string"]).call(_context2, _typeof(_filterInstanceProperty(this.props))) ? _filterInstanceProperty(this.props) : false,
        persistAuthorization: this.props.persistAuthorization,
        withCredentials: this.props.withCredentials,
        oauth2RedirectUrl: this.props.oauth2RedirectUrl
      });
      this.system = ui;
      this.SwaggerUIComponent = ui.getComponent("App", "root");
      this.forceUpdate();
    }
  }, {
    key: "render",
    value: function render() {
      return this.SwaggerUIComponent ? /*#__PURE__*/React.createElement(this.SwaggerUIComponent, null) : null;
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var prevStateUrl = this.system.specSelectors.url();
      if (this.props.url !== prevStateUrl || this.props.url !== prevProps.url) {
        // flush current content
        this.system.specActions.updateSpec("");
        if (this.props.url) {
          // update the internal URL
          this.system.specActions.updateUrl(this.props.url);
          // trigger remote definition fetch
          this.system.specActions.download(this.props.url);
        }
      }
      var prevStateSpec = this.system.specSelectors.specStr();
      if (this.props.spec && (this.props.spec !== prevStateSpec || this.props.spec !== prevProps.spec)) {
        if (_typeof(this.props.spec) === "object") {
          this.system.specActions.updateSpec(_JSON$stringify(this.props.spec));
        } else {
          this.system.specActions.updateSpec(this.props.spec);
        }
      }
    }
  }]);
  return SwaggerUI;
}(React.Component);
export { SwaggerUI as default };
SwaggerUI.propTypes = {
  spec: PropTypes.oneOfType([PropTypes.string, PropTypes.object]),
  url: PropTypes.string,
  layout: PropTypes.string,
  requestInterceptor: PropTypes.func,
  responseInterceptor: PropTypes.func,
  onComplete: PropTypes.func,
  docExpansion: PropTypes.oneOf(["list", "full", "none"]),
  supportedSubmitMethods: PropTypes.arrayOf(PropTypes.oneOf(["get", "put", "post", "delete", "options", "head", "patch", "trace"])),
  queryConfigEnabled: PropTypes.bool,
  plugins: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.object), PropTypes.arrayOf(PropTypes.func), PropTypes.func]),
  displayOperationId: PropTypes.bool,
  showMutatedRequest: PropTypes.bool,
  defaultModelExpandDepth: PropTypes.number,
  defaultModelsExpandDepth: PropTypes.number,
  defaultModelRendering: PropTypes.oneOf(["example", "model"]),
  presets: PropTypes.arrayOf(PropTypes.func),
  deepLinking: PropTypes.bool,
  showExtensions: PropTypes.bool,
  showCommonExtensions: PropTypes.bool,
  filter: PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
  requestSnippetsEnabled: PropTypes.bool,
  requestSnippets: PropTypes.object,
  tryItOutEnabled: PropTypes.bool,
  displayRequestDuration: PropTypes.bool,
  persistAuthorization: PropTypes.bool,
  withCredentials: PropTypes.bool,
  oauth2RedirectUrl: PropTypes.string
};
SwaggerUI.defaultProps = {
  layout: "BaseLayout",
  supportedSubmitMethods: ["get", "put", "post", "delete", "options", "head", "patch", "trace"],
  queryConfigEnabled: false,
  docExpansion: "list",
  defaultModelsExpandDepth: 1,
  defaultModelRendering: "example",
  presets: [],
  deepLinking: false,
  displayRequestDuration: false,
  showExtensions: false,
  showCommonExtensions: false,
  filter: false,
  requestSnippetsEnabled: false,
  requestSnippets: {
    generators: {
      "curl_bash": {
        title: "cURL (bash)",
        syntax: "bash"
      },
      "curl_powershell": {
        title: "cURL (PowerShell)",
        syntax: "powershell"
      },
      "curl_cmd": {
        title: "cURL (CMD)",
        syntax: "bash"
      }
    },
    defaultExpanded: true,
    languages: null // e.g. only show curl bash = ["curl_bash"]
  },

  persistAuthorization: false
};
SwaggerUI.presets = swaggerUIConstructor.presets;
SwaggerUI.plugins = swaggerUIConstructor.plugins;

