/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges.io;

import java.io.File;
import sleep.bridges.io.IOObject;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class ProcessObject
extends IOObject {
    protected Process process;

    public Object getSource() {
        return this.process;
    }

    public void open(String[] stringArray, String[] stringArray2, File file, ScriptEnvironment scriptEnvironment) {
        try {
            if (stringArray.length > 0) {
                stringArray[0] = stringArray[0].replace('/', File.separatorChar);
            }
            this.process = Runtime.getRuntime().exec(stringArray, stringArray2, file);
            this.openRead(this.process.getInputStream());
            this.openWrite(this.process.getOutputStream());
        }
        catch (Exception exception) {
            scriptEnvironment.flagError(exception);
        }
    }

    public Scalar wait(ScriptEnvironment scriptEnvironment, long l) {
        if (this.getThread() != null && this.getThread().isAlive()) {
            super.wait(scriptEnvironment, l);
        }
        try {
            this.process.waitFor();
            return SleepUtils.getScalar(this.process.waitFor());
        }
        catch (Exception exception) {
            scriptEnvironment.flagError(exception);
            return SleepUtils.getEmptyScalar();
        }
    }

    public void close() {
        super.close();
        this.process.destroy();
    }
}

